(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9816,        374]
NotebookOptionsPosition[      5266,        219]
NotebookOutlinePosition[      8379,        314]
CellTagsIndexPosition[      8310,        309]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dropping Tables with Raw SQL", "Title",
 CellID->24948],

Cell[TextData[{
 "The raw SQL command DROP TABLE drops tables from a database. An alternative \
is to use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command ",
 Cell[BoxData[
  ButtonBox["SQLDropTable",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDropTable"]], "InlineFormula"],
 ", described in ",
 ButtonBox["Dropping Tables",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DroppingTables"],
 "."
}], "Text",
 CellTags->"b:4.2.7",
 CellID->5938],

Cell[TextData[{
 "If you find that the examples in this ",
 "tutorial",
 " do not work as shown, you may need to install or restore the example \
database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->19037],

Cell[TextData[{
 "When dropping a table, the result of ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 " will be ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if there is an error."
}], "Text",
 CellTags->"b:4.2.7",
 CellID->6410],

Cell[TextData[{
 "Here is an example that drops a table. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:4.2.7",
 CellID->31461],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:4.2.7",
 CellLabel->"In[1]:=",
 CellID->6234],

Cell["A simple table is created and two rows are inserted.", "Text",
 CellTags->"b:4.2.7",
 CellID->12508],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", " ", "\[IndentingNewLine]", 
    "\"\<CREATE TABLE TEST (COL1 INTEGER, COL2 INTEGER)\>\""}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", "\"\<INSERT INTO TEST (COL1, COL2) VALUES (`1`)\>\"", ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{"5", ",", "6"}], "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{"7", ",", "9"}], "]"}], "}"}]}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}], "\n", 
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", "\"\<SELECT * FROM TEST\>\""}], "]"}]}], "Input",
 CellTags->"b:4.2.7",
 CellLabel->"In[3]:=",
 CellID->9961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "9"}], "}"}]}], "}"}]], "Output",
 CellTags->"b:4.2.7",
 CellLabel->"Out[5]=",
 CellID->3959]
}, Open  ]],

Cell[TextData[{
 "An SQL statement that drops the ",
 StyleBox["TEST",
  FontSlant->"Italic"],
 " table is executed."
}], "Text",
 CellTags->"b:4.2.7",
 CellID->6493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<DROP TABLE TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.7",
 CellLabel->"In[6]:=",
 CellID->1515],

Cell[BoxData["0"], "Output",
 CellTags->"b:4.2.7",
 CellLabel->"Out[6]=",
 CellID->25269]
}, Open  ]],

Cell[TextData[{
 "This confirms that the ",
 StyleBox["TEST",
  FontSlant->"Italic"],
 " table is no longer in the database."
}], "Text",
 CellTags->"b:4.2.7",
 CellID->24937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLTableNames", "[", 
  RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.7",
 CellLabel->"In[7]:=",
 CellID->28869],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellTags->"b:4.2.7",
 CellLabel->"Out[7]=",
 CellID->58]
}, Open  ]],

Cell["This closes the connection.", "Text",
 CellTags->"b:4.2.7",
 CellID->14700],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->"b:4.2.7",
 CellLabel->"In[8]:=",
 CellID->13971],

Cell["\<\
It should be noted that it is not permitted to drop a table that is \
referenced by another.\
\>", "Text",
 CellTags->"b:4.2.7",
 CellID->26264]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dropping Tables with Raw SQL - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 51.5308564}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "The raw SQL command DROP TABLE drops tables from a database. An \
alternative is to use the Mathematica command SQLDropTable, described in \
Dropping Tables. If you find that the examples in this tutorial do not work \
as shown, you may need to install or restore the example database with the \
DatabaseExamples` package, as described in Using the Example Databases. When \
dropping a table, the result of SQLExecute will be $Failed if there is an \
error.", "synonyms" -> {}, "title" -> "Dropping Tables with Raw SQL", "type" -> 
    "Tutorial", "uri" -> "DatabaseLink/tutorial/SQLDroppingTables"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.2.7"->{
  Cell[793, 32, 502, 17, 70, "Text",
   CellTags->"b:4.2.7",
   CellID->5938],
  Cell[1738, 66, 399, 14, 70, "Text",
   CellTags->"b:4.2.7",
   CellID->6410],
  Cell[2140, 82, 252, 10, 70, "Text",
   CellTags->"b:4.2.7",
   CellID->31461],
  Cell[2395, 94, 286, 9, 70, "Input",
   CellTags->"b:4.2.7",
   CellID->6234],
  Cell[2684, 105, 106, 2, 70, "Text",
   CellTags->"b:4.2.7",
   CellID->12508],
  Cell[2815, 111, 820, 25, 70, "Input",
   CellTags->"b:4.2.7",
   CellID->9961],
  Cell[3638, 138, 231, 9, 70, "Output",
   CellTags->"b:4.2.7",
   CellID->3959],
  Cell[3884, 150, 166, 7, 70, "Text",
   CellTags->"b:4.2.7",
   CellID->6493],
  Cell[4075, 161, 176, 5, 70, "Input",
   CellTags->"b:4.2.7",
   CellID->1515],
  Cell[4254, 168, 89, 3, 70, "Output",
   CellTags->"b:4.2.7",
   CellID->25269],
  Cell[4358, 174, 175, 7, 70, "Text",
   CellTags->"b:4.2.7",
   CellID->24937],
  Cell[4558, 185, 169, 5, 70, "Input",
   CellTags->"b:4.2.7",
   CellID->28869],
  Cell[4730, 192, 103, 4, 70, "Output",
   CellTags->"b:4.2.7",
   CellID->58],
  Cell[4848, 199, 81, 2, 70, "Text",
   CellTags->"b:4.2.7",
   CellID->14700],
  Cell[4932, 203, 135, 4, 70, "Input",
   CellTags->"b:4.2.7",
   CellID->13971],
  Cell[5070, 209, 154, 5, 70, "Text",
   CellTags->"b:4.2.7",
   CellID->26264]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.2.7", 6992, 257}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 61, 1, 70, "Title",
 CellID->24948],
Cell[793, 32, 502, 17, 70, "Text",
 CellTags->"b:4.2.7",
 CellID->5938],
Cell[1298, 51, 437, 13, 70, "Text",
 CellID->19037],
Cell[1738, 66, 399, 14, 70, "Text",
 CellTags->"b:4.2.7",
 CellID->6410],
Cell[2140, 82, 252, 10, 70, "Text",
 CellTags->"b:4.2.7",
 CellID->31461],
Cell[2395, 94, 286, 9, 70, "Input",
 CellTags->"b:4.2.7",
 CellID->6234],
Cell[2684, 105, 106, 2, 70, "Text",
 CellTags->"b:4.2.7",
 CellID->12508],
Cell[CellGroupData[{
Cell[2815, 111, 820, 25, 70, "Input",
 CellTags->"b:4.2.7",
 CellID->9961],
Cell[3638, 138, 231, 9, 70, "Output",
 CellTags->"b:4.2.7",
 CellID->3959]
}, Open  ]],
Cell[3884, 150, 166, 7, 70, "Text",
 CellTags->"b:4.2.7",
 CellID->6493],
Cell[CellGroupData[{
Cell[4075, 161, 176, 5, 70, "Input",
 CellTags->"b:4.2.7",
 CellID->1515],
Cell[4254, 168, 89, 3, 70, "Output",
 CellTags->"b:4.2.7",
 CellID->25269]
}, Open  ]],
Cell[4358, 174, 175, 7, 70, "Text",
 CellTags->"b:4.2.7",
 CellID->24937],
Cell[CellGroupData[{
Cell[4558, 185, 169, 5, 70, "Input",
 CellTags->"b:4.2.7",
 CellID->28869],
Cell[4730, 192, 103, 4, 70, "Output",
 CellTags->"b:4.2.7",
 CellID->58]
}, Open  ]],
Cell[4848, 199, 81, 2, 70, "Text",
 CellTags->"b:4.2.7",
 CellID->14700],
Cell[4932, 203, 135, 4, 70, "Input",
 CellTags->"b:4.2.7",
 CellID->13971],
Cell[5070, 209, 154, 5, 70, "Text",
 CellTags->"b:4.2.7",
 CellID->26264]
}, Open  ]],
Cell[5239, 217, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

