(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27386,        876]
NotebookOptionsPosition[     17157,        563]
NotebookOutlinePosition[     24302,        767]
CellTagsIndexPosition[     23733,        749]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLArgument" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLArgument"], 
         "SQLExecute" :> 
         Documentation`HelpLookup["paclet:DatabaseLink/ref/SQLExecute"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"SQLArgument\"\>", 
      2->"\<\"SQLExecute\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SQLExecute", "Title",
 CellID->2741],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 " allows SQL statements to be executed.",
 " ",
 "Statements can be used to select data, create tables, insert data, update \
data, remove data, and drop tables. The statement used by ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 " is a string that can contain all arguments. However, it is also possible \
to give the arguments separately, which makes the statement a prepared \
statement. ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 " can also be used to execute a batch of prepared statements with different \
arguments, as described in the ",
 ButtonBox["Batch Input",
  BaseStyle->"AddOnsLinkText",
  ButtonData:>{"DatabaseLink6.3.0", "xref:79"}],
 " tutorial."
}], "Text",
 CellTags->"b:4.2.2",
 CellID->26052],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLExecute",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLExecute"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["statement", "TI"], ",", 
     StyleBox["opts\[Ellipsis]", "TI"], "]"}], Cell[
    "execute an SQL statement", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLExecute",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLExecute"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["statement", "TI"], ",", "{", 
     StyleBox["args\[Ellipsis]", "TI"], "}", ",", 
     StyleBox["opts\[Ellipsis]", "TI"], "]"}], Cell[
    "execute a prepared statement with arguments", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLExecute",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLExecute"], "[", 
     StyleBox["conn", "TI"], ",", 
     StyleBox["statement", "TI"], ",", "{", "{", 
     StyleBox["args\[Ellipsis]", "TI"], "}", "\[Ellipsis]", "}", ",", 
     StyleBox["opts\[Ellipsis]", "TI"], "]"}], Cell["\<\
execute a batch of prepared statement with different arguments\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->5402],

Cell["Executing SQL statements.", "Caption",
 CellTags->"b:4.1.6",
 CellID->6923],

Cell["\<\
The following sections show how to use SQL statements to carry out different \
types of manipulations.\
\>", "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->236],

Cell[TextData[{
 "There are a number of options that can be given to ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:4.3",
 CellID->31111],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<GetAsStrings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "return the results as strings", "TableText"]},
   {"\"\<MaxRows\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the maximum number of rows returned", "TableText"]},
   {"\"\<ShowColumnHeadings\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to return headings with the results", "TableText"]},
   {"\"\<Timeout\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "set the timeout for a query", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->32182],

Cell[TextData[{
 "Options of ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:4.3",
 CellID->23856],

Cell[TextData[{
 "Here is an example of these options. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database. If you find that the examples in this tutorial do not work as \
shown, you may need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellTags->"b:4.3",
 CellID->19490],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,156"},
 CellLabel->"In[1]:=",
 CellID->8925],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<GetAsStrings\>\""], "InlineFormula"],
 " can retrieve data without converting it to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " type. "
}], "Text",
 CellTags->"b:4.3",
 CellID->4324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", " ", "\"\<SELECT * FROM SAMPLETABLE1\>\"", ",", " ", 
    RowBox[{"\"\<GetAsStrings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,157"},
 CellLabel->"In[3]:=",
 CellID->6486],

Cell["\<\
{{\"1\", \"5.6\", \"Day1\"}, {\"2\", \"5.9\", \"Day2\"}, 
 {\"3\", \"7.2\", \"Day3\"}, {\"4\", \"6.2\", \"Day4\"}, 
 {\"5\", \"6.0\", \"Day5\"}}\
\>", "Output",
 CellTags->{"b:4.3", "Ex--21943492438155078303,157"},
 CellLabel->"Out[3]//InputForm=",
 CellID->19677]
}, Open  ]],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<MaxRows\>\""], "InlineFormula"],
 " can limit the number of rows returned. "
}], "Text",
 CellTags->"b:4.3",
 CellID->15969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM SAMPLETABLE1\>\"", ",", " ", 
   RowBox[{"\"\<MaxRows\>\"", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,158"},
 CellLabel->"In[4]:=",
 CellID->11643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5.6`", ",", "\<\"Day1\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5.9`", ",", "\<\"Day2\"\>"}], "}"}]}], "}"}]], "Output",\

 CellTags->{"b:4.3", "Ex--21943492438155078303,158"},
 CellLabel->"Out[4]=",
 CellID->7534]
}, Open  ]],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<ShowColumnHeadings\>\""], "InlineFormula"],
 " can retrieve the column headings with the results."
}], "Text",
 CellTags->"b:4.3",
 CellID->15677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", " ", "\"\<SELECT * FROM SAMPLETABLE1\>\"", ",", " ", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], " ", "//",
   "TableForm"}]], "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,159"},
 CellLabel->"In[5]:=",
 CellID->22668],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"ENTRY\"\>", "\<\"VALUE\"\>", "\<\"NAME\"\>"},
    {"1", "5.6`", "\<\"Day1\"\>"},
    {"2", "5.9`", "\<\"Day2\"\>"},
    {"3", "7.2`", "\<\"Day3\"\>"},
    {"4", "6.2`", "\<\"Day4\"\>"},
    {"5", "6.`", "\<\"Day5\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellTags->{"b:4.3", "Ex--21943492438155078303,159"},
 CellLabel->"Out[5]//TableForm=",
 CellID->31068]
}, Open  ]],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<Timeout\>\""], "InlineFormula"],
 " can be used to cancel a query if it takes too long to execute. "
}], "Text",
 CellTags->"b:4.3",
 CellID->21991],

Cell["This closes the connection.", "Text",
 CellTags->"b:4.3",
 CellID->32196],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,160"},
 CellLabel->"In[6]:=",
 CellID->7783],

Cell[CellGroupData[{

Cell[TextData[{
 "Argument Sequences in SQL",
 StyleBox["\[Hyphen]",
  FontSlant->"Italic"],
 "Style Queries"
}], "Section",
 CellTags->{"xref:46", "c:66", "b:6.0"},
 CellID->16828],

Cell[TextData[{
 "If you want to use one argument in an SQL statement that holds a sequence \
of several values, you can use ",
 Cell[BoxData[
  ButtonBox["SQLArgument",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLArgument"]]],
 ". This is particularly useful for selects and inserts in tables that have \
many columns. With selects, you can dynamically specify multiple tables and \
columns, and with inserts you can dynamically specify multiple columns and \
values."
}], "Text",
 CellTags->"b:6.0",
 CellID->7727],

Cell[BoxData[GridBox[{
   {
    ButtonBox["SQLArgument",
     BaseStyle->"Link",
     ButtonData->"paclet:DatabaseLink/ref/SQLArgument"], Cell[
    "a sequence of arguments to a command", "TableText"]}
  }]], "DefinitionBox",
 CellID->29426],

Cell["Argument sequences.", "Caption",
 CellTags->"b:6.0",
 CellID->15871],

Cell[TextData[{
 "To demonstrate this, load ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connect to the ",
 Cell[BoxData[
  StyleBox["publisher", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:6.0",
 CellID->10697],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<publisher\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->{"b:6.0", "Ex--21943492438155078303,161"},
 CellLabel->"In[7]:=",
 CellID->17612],

Cell[TextData[{
 "Now, you can execute a select query using ",
 Cell[BoxData[
  ButtonBox["SQLArgument",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLArgument"]], "InlineFormula"],
 ". Notice how the statement refers to two arguments as ",
 Cell[BoxData["`1`"], "InlineFormula"],
 " arguments. This makes the statement simpler since it saves having to \
number the arguments individually."
}], "Text",
 CellTags->"b:6.0",
 CellID->18703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", "\"\<SELECT `1` FROM `2`\>\"", ",", " ", 
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{"SQLArgument", "[", 
      RowBox[{
       RowBox[{"SQLColumn", "[", "\"\<TITLE_ID\>\"", "]"}], ",", " ", 
       RowBox[{"SQLColumn", "[", "\"\<ROYALTY\>\"", "]"}]}], "]"}], ",", 
     RowBox[{"SQLTable", "[", "\"\<ROYSCHED\>\"", "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellTags->{"b:6.0", "Ex--21943492438155078303,162"},
 CellLabel->"In[9]:=",
 CellID->11027],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1011\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5018\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1001\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PS9999\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2002\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2003\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3004\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4005\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CP5010\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2012\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2013\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3006\"\>", ",", "0.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1014\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"UK3015\"\>", ",", "0.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4016\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"CK4017\"\>", ",", "0.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.1`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"BS1007\"\>", ",", "0.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"PY2008\"\>", ",", "0.1`"}], "}"}]}], "}"}]], "Output",
 CellTags->{"b:6.0", "Ex--21943492438155078303,162"},
 CellLabel->"Out[9]=",
 CellID->11408]
}, Open  ]],

Cell["This closes the connection.", "Text",
 CellTags->"b:6.0",
 CellID->5545],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->{"b:6.0", "Ex--21943492438155078303,163"},
 CellLabel->"In[10]:=",
 CellID->9508],

Cell[TextData[{
 "It should be noted that ",
 Cell[BoxData[
  ButtonBox["SQLArgument",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLArgument"]], "InlineFormula"],
 " is not supported in ",
 StyleBox["Mathematica-",
  FontSlant->"Italic"],
 "based queries."
}], "Text",
 CellTags->"b:6.0",
 CellID->7185]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SQLExecute - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 52.2183520}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "SQLExecute allows SQL statements to be executed. Statements can be used \
to select data, create tables, insert data, update data, remove data, and \
drop tables. The statement used by SQLExecute is a string that can contain \
all arguments. However, it is also possible to give the arguments separately, \
which makes the statement a prepared statement. SQLExecute can also be used \
to execute a batch of prepared statements with different arguments, as \
described in the Batch Input tutorial. Executing SQL statements. The \
following sections show how to use SQL statements to carry out different \
types of manipulations.", "synonyms" -> {}, "title" -> "SQLExecute", "type" -> 
    "Tutorial", "uri" -> "DatabaseLink/tutorial/SQLExecute"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.2.2"->{
  Cell[1379, 47, 1059, 28, 70, "Text",
   CellTags->"b:4.2.2",
   CellID->26052]},
 "b:4.1.6"->{
  Cell[3631, 111, 81, 2, 70, "Caption",
   CellTags->"b:4.1.6",
   CellID->6923]},
 "b:4.3"->{
  Cell[3892, 122, 260, 9, 70, "Text",
   CellTags->"b:4.3",
   CellID->31111],
  Cell[5191, 163, 223, 9, 70, "Caption",
   CellTags->"b:4.3",
   CellID->23856],
  Cell[5417, 174, 611, 17, 70, "Text",
   CellTags->"b:4.3",
   CellID->19490],
  Cell[6031, 193, 318, 9, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,156"},
   CellID->8925],
  Cell[6352, 204, 246, 9, 70, "Text",
   CellTags->"b:4.3",
   CellID->4324],
  Cell[6623, 217, 323, 8, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,157"},
   CellID->6486],
  Cell[6949, 227, 274, 7, 70, "Output",
   CellTags->{"b:4.3", "Ex--21943492438155078303,157"},
   CellID->19677],
  Cell[7238, 237, 175, 6, 70, "Text",
   CellTags->"b:4.3",
   CellID->15969],
  Cell[7438, 247, 279, 6, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,158"},
   CellID->11643],
  Cell[7720, 255, 313, 10, 70, "Output",
   CellTags->{"b:4.3", "Ex--21943492438155078303,158"},
   CellID->7534],
  Cell[8048, 268, 197, 6, 70, "Text",
   CellTags->"b:4.3",
   CellID->15677],
  Cell[8270, 278, 335, 8, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,159"},
   CellID->22668],
  Cell[8608, 288, 789, 23, 70, "Output",
   CellTags->{"b:4.3", "Ex--21943492438155078303,159"},
   CellID->31068],
  Cell[9412, 314, 199, 6, 70, "Text",
   CellTags->"b:4.3",
   CellID->21991],
  Cell[9614, 322, 79, 2, 70, "Text",
   CellTags->"b:4.3",
   CellID->32196],
  Cell[9696, 326, 166, 4, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,160"},
   CellID->7783]},
 "Ex--21943492438155078303,156"->{
  Cell[6031, 193, 318, 9, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,156"},
   CellID->8925]},
 "Ex--21943492438155078303,157"->{
  Cell[6623, 217, 323, 8, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,157"},
   CellID->6486],
  Cell[6949, 227, 274, 7, 70, "Output",
   CellTags->{"b:4.3", "Ex--21943492438155078303,157"},
   CellID->19677]},
 "Ex--21943492438155078303,158"->{
  Cell[7438, 247, 279, 6, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,158"},
   CellID->11643],
  Cell[7720, 255, 313, 10, 70, "Output",
   CellTags->{"b:4.3", "Ex--21943492438155078303,158"},
   CellID->7534]},
 "Ex--21943492438155078303,159"->{
  Cell[8270, 278, 335, 8, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,159"},
   CellID->22668],
  Cell[8608, 288, 789, 23, 70, "Output",
   CellTags->{"b:4.3", "Ex--21943492438155078303,159"},
   CellID->31068]},
 "Ex--21943492438155078303,160"->{
  Cell[9696, 326, 166, 4, 70, "Input",
   CellTags->{"b:4.3", "Ex--21943492438155078303,160"},
   CellID->7783]},
 "xref:46"->{
  Cell[9887, 334, 181, 7, 70, "Section",
   CellTags->{"xref:46", "c:66", "b:6.0"},
   CellID->16828]},
 "c:66"->{
  Cell[9887, 334, 181, 7, 70, "Section",
   CellTags->{"xref:46", "c:66", "b:6.0"},
   CellID->16828]},
 "b:6.0"->{
  Cell[9887, 334, 181, 7, 70, "Section",
   CellTags->{"xref:46", "c:66", "b:6.0"},
   CellID->16828],
  Cell[10071, 343, 537, 13, 70, "Text",
   CellTags->"b:6.0",
   CellID->7727],
  Cell[10855, 367, 74, 2, 70, "Caption",
   CellTags->"b:6.0",
   CellID->15871],
  Cell[10932, 371, 248, 10, 70, "Text",
   CellTags->"b:6.0",
   CellID->10697],
  Cell[11183, 383, 324, 9, 70, "Input",
   CellTags->{"b:6.0", "Ex--21943492438155078303,161"},
   CellID->17612],
  Cell[11510, 394, 457, 12, 70, "Text",
   CellTags->"b:6.0",
   CellID->18703],
  Cell[11992, 410, 517, 13, 70, "Input",
   CellTags->{"b:6.0", "Ex--21943492438155078303,162"},
   CellID->11027],
  Cell[12512, 425, 4002, 107, 70, "Output",
   CellTags->{"b:6.0", "Ex--21943492438155078303,162"},
   CellID->11408],
  Cell[16529, 535, 78, 2, 70, "Text",
   CellTags->"b:6.0",
   CellID->5545],
  Cell[16610, 539, 167, 4, 70, "Input",
   CellTags->{"b:6.0", "Ex--21943492438155078303,163"},
   CellID->9508],
  Cell[16780, 545, 323, 12, 70, "Text",
   CellTags->"b:6.0",
   CellID->7185]},
 "Ex--21943492438155078303,161"->{
  Cell[11183, 383, 324, 9, 70, "Input",
   CellTags->{"b:6.0", "Ex--21943492438155078303,161"},
   CellID->17612]},
 "Ex--21943492438155078303,162"->{
  Cell[11992, 410, 517, 13, 70, "Input",
   CellTags->{"b:6.0", "Ex--21943492438155078303,162"},
   CellID->11027],
  Cell[12512, 425, 4002, 107, 70, "Output",
   CellTags->{"b:6.0", "Ex--21943492438155078303,162"},
   CellID->11408]},
 "Ex--21943492438155078303,163"->{
  Cell[16610, 539, 167, 4, 70, "Input",
   CellTags->{"b:6.0", "Ex--21943492438155078303,163"},
   CellID->9508]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.2.2", 19010, 603},
 {"b:4.1.6", 19107, 607},
 {"b:4.3", 19202, 611},
 {"Ex--21943492438155078303,156", 20785, 660},
 {"Ex--21943492438155078303,157", 20934, 664},
 {"Ex--21943492438155078303,158", 21198, 671},
 {"Ex--21943492438155078303,159", 21463, 678},
 {"Ex--21943492438155078303,160", 21729, 685},
 {"xref:46", 21857, 689},
 {"c:66", 21972, 693},
 {"b:6.0", 22088, 697},
 {"Ex--21943492438155078303,161", 23173, 731},
 {"Ex--21943492438155078303,162", 23324, 735},
 {"Ex--21943492438155078303,163", 23595, 742}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 709, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1334, 44, 42, 1, 70, "Title",
 CellID->2741],
Cell[1379, 47, 1059, 28, 70, "Text",
 CellTags->"b:4.2.2",
 CellID->26052],
Cell[2441, 77, 1187, 32, 70, "DefinitionBox",
 CellID->5402],
Cell[3631, 111, 81, 2, 70, "Caption",
 CellTags->"b:4.1.6",
 CellID->6923],
Cell[3715, 115, 174, 5, 70, "Text",
 CellID->236],
Cell[3892, 122, 260, 9, 70, "Text",
 CellTags->"b:4.3",
 CellID->31111],
Cell[4155, 133, 1033, 28, 70, "DefinitionBox3Col",
 CellID->32182],
Cell[5191, 163, 223, 9, 70, "Caption",
 CellTags->"b:4.3",
 CellID->23856],
Cell[5417, 174, 611, 17, 70, "Text",
 CellTags->"b:4.3",
 CellID->19490],
Cell[6031, 193, 318, 9, 70, "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,156"},
 CellID->8925],
Cell[6352, 204, 246, 9, 70, "Text",
 CellTags->"b:4.3",
 CellID->4324],
Cell[CellGroupData[{
Cell[6623, 217, 323, 8, 70, "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,157"},
 CellID->6486],
Cell[6949, 227, 274, 7, 70, "Output",
 CellTags->{"b:4.3", "Ex--21943492438155078303,157"},
 CellID->19677]
}, Open  ]],
Cell[7238, 237, 175, 6, 70, "Text",
 CellTags->"b:4.3",
 CellID->15969],
Cell[CellGroupData[{
Cell[7438, 247, 279, 6, 70, "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,158"},
 CellID->11643],
Cell[7720, 255, 313, 10, 70, "Output",
 CellTags->{"b:4.3", "Ex--21943492438155078303,158"},
 CellID->7534]
}, Open  ]],
Cell[8048, 268, 197, 6, 70, "Text",
 CellTags->"b:4.3",
 CellID->15677],
Cell[CellGroupData[{
Cell[8270, 278, 335, 8, 70, "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,159"},
 CellID->22668],
Cell[8608, 288, 789, 23, 70, "Output",
 CellTags->{"b:4.3", "Ex--21943492438155078303,159"},
 CellID->31068]
}, Open  ]],
Cell[9412, 314, 199, 6, 70, "Text",
 CellTags->"b:4.3",
 CellID->21991],
Cell[9614, 322, 79, 2, 70, "Text",
 CellTags->"b:4.3",
 CellID->32196],
Cell[9696, 326, 166, 4, 70, "Input",
 CellTags->{"b:4.3", "Ex--21943492438155078303,160"},
 CellID->7783],
Cell[CellGroupData[{
Cell[9887, 334, 181, 7, 70, "Section",
 CellTags->{"xref:46", "c:66", "b:6.0"},
 CellID->16828],
Cell[10071, 343, 537, 13, 70, "Text",
 CellTags->"b:6.0",
 CellID->7727],
Cell[10611, 358, 241, 7, 70, "DefinitionBox",
 CellID->29426],
Cell[10855, 367, 74, 2, 70, "Caption",
 CellTags->"b:6.0",
 CellID->15871],
Cell[10932, 371, 248, 10, 70, "Text",
 CellTags->"b:6.0",
 CellID->10697],
Cell[11183, 383, 324, 9, 70, "Input",
 CellTags->{"b:6.0", "Ex--21943492438155078303,161"},
 CellID->17612],
Cell[11510, 394, 457, 12, 70, "Text",
 CellTags->"b:6.0",
 CellID->18703],
Cell[CellGroupData[{
Cell[11992, 410, 517, 13, 70, "Input",
 CellTags->{"b:6.0", "Ex--21943492438155078303,162"},
 CellID->11027],
Cell[12512, 425, 4002, 107, 70, "Output",
 CellTags->{"b:6.0", "Ex--21943492438155078303,162"},
 CellID->11408]
}, Open  ]],
Cell[16529, 535, 78, 2, 70, "Text",
 CellTags->"b:6.0",
 CellID->5545],
Cell[16610, 539, 167, 4, 70, "Input",
 CellTags->{"b:6.0", "Ex--21943492438155078303,163"},
 CellID->9508],
Cell[16780, 545, 323, 12, 70, "Text",
 CellTags->"b:6.0",
 CellID->7185]
}, Open  ]]
}, Open  ]],
Cell[17130, 561, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

