(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27197,       1042]
NotebookOptionsPosition[     16514,        649]
NotebookOutlinePosition[     22628,        852]
CellTagsIndexPosition[     22558,        847]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Inserting Data with Raw SQL", "Title",
 CellID->26153],

Cell[TextData[{
 "The SQL command INSERT inserts data into a database. An alternative is to \
use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command ",
 Cell[BoxData[
  ButtonBox["SQLInsert",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLInsert"]], "InlineFormula"],
 ", as described in ",
 ButtonBox["Inserting Data",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/InsertingData"],
 ". "
}], "Text",
 CellTags->"b:4.2.4",
 CellID->14721],

Cell[TextData[{
 "If you find that the examples in this ",
 "tutorial",
 " do not work as shown, you may need to install or restore the example \
database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->6064],

Cell[TextData[{
 "When inserting data, the result of ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 " is an integer specifying the number of rows affected by the query."
}], "Text",
 CellTags->"b:4.2.4",
 CellID->29309],

Cell[TextData[{
 "Here is an example that inserts data. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:4.2.4",
 CellID->20415],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[1]:=",
 CellID->17902],

Cell[TextData[{
 "As discussed in ",
 ButtonBox["Creating Tables with Raw SQL",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLCreatingTables"],
 ", the ",
 StyleBox["ADDRESSES",
  FontSlant->"Italic"],
 " and ",
 StyleBox["MAILER",
  FontSlant->"Italic"],
 " tables should be created."
}], "Text",
 CellTags->"b:4.2.4",
 CellID->29873],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", " ", "\[IndentingNewLine]", 
    "\"\<CREATE TABLE ADDRESSES (\n    USERNAME VARCHAR NOT NULL PRIMARY KEY, \
\n    ADDRESS VARCHAR,\n    CITY VARCHAR, \n    ZIPCODE VARCHAR, \n    UNIQUE \
(ADDRESS, CITY, ZIPCODE))\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", " ", 
    "\"\<CREATE TABLE MAILER (\n  MAILERID INT IDENTITY, \n  USERNAME VARCHAR \
NOT NULL, \n  SENDMAILER BIT DEFAULT '1' NOT NULL,\n  FOREIGN KEY (USERNAME) \
REFERENCES ADDRESSES (USERNAME))\>\""}], "]"}], ";"}]}], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[3]:=",
 CellID->17124],

Cell[TextData[{
 "This demonstrates an SQL statement that inserts a row into the ",
 StyleBox["ADDRESSES",
  FontSlant->"Italic"],
 " table. "
}], "Text",
 CellTags->"b:4.2.4",
 CellID->23941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\[IndentingNewLine]", "  ", 
   "\"\<INSERT INTO ADDRESSES (USERNAME, ADDRESS, CITY, ZIPCODE) VALUES \n    \
 ('user1', '100 Trade Center', 'Champaign, IL', '61820')\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[5]:=",
 CellID->32745],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[5]=",
 CellID->31762]
}, Open  ]],

Cell["\<\
A SELECT statement verifies that the data has been added to the table.\
\>", "Text",
 CellTags->"b:4.2.4",
 CellID->28423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM ADDRESSES\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[6]:=",
 CellID->27531],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"user1\"\>", ",", "\<\"100 Trade Center\"\>", 
    ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}], 
  "}"}]], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[6]=",
 CellID->4806]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["USERNAME",
  FontSlant->"Italic"],
 " column is made to be a primary key, which means that it must be unique. If \
you try to insert the same data again, there is an error and the result is ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:4.2.4",
 CellID->12268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\[IndentingNewLine]", "  ", 
   "\"\<INSERT INTO ADDRESSES (USERNAME, ADDRESS, CITY, ZIPCODE) VALUES \n    \
 ('user1', '100 Trade Center', 'Champaign, IL', '61820')\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[7]:=",
 CellID->9318],

Cell[BoxData[
 RowBox[{
  RowBox[{"JDBC", "::", "\<\"error\"\>"}], ":", 
  " ", "\<\"JDBC error: \\!\\(\\\"Unique constraint violation:  in st\\\"\
\[Ellipsis]\\\" Center', 'Champaign, IL', '61820')]\\\"\\)\"\>"}]], "Message",\
 "MSG",
 CellTags->"b:4.2.4",
 CellLabel->"From In[7]:=",
 CellID->5602],

Cell[BoxData["$Failed"], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[7]=",
 CellID->31907]
}, Open  ]],

Cell[TextData[{
 "With this command, the ",
 StyleBox["USERNAME",
  FontSlant->"Italic"],
 " parameter is unique, but ",
 StyleBox["ADDRESS",
  FontSlant->"Italic"],
 ", ",
 StyleBox["CITY",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["ZIPCODE",
  FontSlant->"Italic"],
 " are not. These must also be unique and again there is an error."
}], "Text",
 CellTags->"b:4.2.4",
 CellID->24307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\[IndentingNewLine]", "  ", 
   "\"\<INSERT INTO ADDRESSES (USERNAME, ADDRESS, CITY, ZIPCODE) VALUES \n    \
 ('user2', '100 Trade Center', 'Champaign, IL', '61820')\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[8]:=",
 CellID->23481],

Cell[BoxData[
 RowBox[{
  RowBox[{"JDBC", "::", "\<\"error\"\>"}], ":", 
  " ", "\<\"JDBC error: \\!\\(\\\"Unique constraint violation: SYS_CT\\\"\
\[Ellipsis]\\\" Center', 'Champaign, IL', '61820')]\\\"\\)\"\>"}]], "Message",\
 "MSG",
 CellTags->"b:4.2.4",
 CellLabel->"From In[8]:=",
 CellID->1012],

Cell[BoxData["$Failed"], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[8]=",
 CellID->21136]
}, Open  ]],

Cell[TextData[{
 "This inserts unique values of ",
 StyleBox["ADDRESS",
  FontSlant->"Italic"],
 ", ",
 StyleBox["CITY",
  FontSlant->"Italic"],
 ", and ",
 StyleBox["ZIPCODE",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:4.2.4",
 CellID->26630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\[IndentingNewLine]", "  ", 
   "\"\<INSERT INTO ADDRESSES (USERNAME, ADDRESS, CITY, ZIPCODE) VALUES \n    \
 ('user2', '200 Trade Center', 'Champaign, IL', '61820')\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[9]:=",
 CellID->24114],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[9]=",
 CellID->26809]
}, Open  ]],

Cell["\<\
A SELECT statement verifies that the data has been added to the table.\
\>", "Text",
 CellTags->"b:4.2.4",
 CellID->4084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM ADDRESSES\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[10]:=",
 CellID->23556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"user1\"\>", ",", "\<\"100 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"user2\"\>", ",", "\<\"200 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[10]=",
 CellID->12290]
}, Open  ]],

Cell[TextData[{
 "A prepared statement may be more useful for working with data to insert. In \
addition, ",
 Cell[BoxData[
  ButtonBox["SQLArgument",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLArgument"]], "InlineFormula"],
 " may be useful to reduce the number of argument fields in the prepared \
statement. ",
 Cell[BoxData[
  ButtonBox["SQLArgument",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLArgument"]], "InlineFormula"],
 " is described in ",
 ButtonBox["Argument Sequences in SQL-Style Queries",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLExecute#16828"],
 "."
}], "Text",
 CellTags->"b:4.2.4",
 CellID->21293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", "\[IndentingNewLine]", "  ", 
   "\"\<INSERT INTO ADDRESSES (USERNAME, ADDRESS, CITY, ZIPCODE) VALUES \n    \
 (`1`)\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"SQLArgument", "[", 
     RowBox[{
     "\"\<user3\>\"", ",", "\"\<300 Trade Center\>\"", ",", 
      "\"\<Champaign, IL\>\"", ",", "\"\<61820\>\""}], "]"}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[11]:=",
 CellID->29996],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[11]=",
 CellID->29152]
}, Open  ]],

Cell["\<\
A SELECT statement verifies that the data has been added to the table.\
\>", "Text",
 CellTags->"b:4.2.4",
 CellID->1054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM ADDRESSES\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[12]:=",
 CellID->25345],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"user1\"\>", ",", "\<\"100 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"user2\"\>", ",", "\<\"200 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"user3\"\>", ",", "\<\"300 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[12]=",
 CellID->14708]
}, Open  ]],

Cell[TextData[{
 "Identity columns are very useful as they automatically increment their \
values and do not require a value. They are also the primary key for the \
table, which means they uniquely identify a row. Identity values should be \
set to ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " in a SQL statement."
}], "Text",
 CellTags->"b:4.2.4",
 CellID->248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLColumnNames", "[", 
  RowBox[{"conn", ",", " ", "\"\<MAILER\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[13]:=",
 CellID->7491],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"MAILER\"\>", ",", "\<\"MAILERID\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"MAILER\"\>", ",", "\<\"USERNAME\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"MAILER\"\>", ",", "\<\"SENDMAILER\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[13]=",
 CellID->13712]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<INSERT INTO MAILER (MAILERID, USERNAME, SENDMAILER) VALUES (NULL, \
'user1', 0)\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[14]:=",
 CellID->5131],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[14]=",
 CellID->30114]
}, Open  ]],

Cell["\<\
A SELECT statement verifies that the data has been added to the table.\
\>", "Text",
 CellTags->"b:4.2.4",
 CellID->16439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM MAILER\>\""}], "]"}]], "Input",\

 CellTags->"b:4.2.4",
 CellLabel->"In[15]:=",
 CellID->7958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"0", ",", "\<\"user1\"\>", ",", "False"}], "}"}], "}"}]], "Output",\

 CellTags->"b:4.2.4",
 CellLabel->"Out[15]=",
 CellID->24722]
}, Open  ]],

Cell[TextData[{
 "Since ",
 StyleBox["USERNAME",
  FontSlant->"Italic"],
 " is a foreign key, its value must be present in ",
 StyleBox["ADDRESSES",
  FontSlant->"Italic"],
 ". The following fails because ",
 StyleBox["user4", "MR"],
 " is not present in ",
 StyleBox["ADDRESSES",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:4.2.4",
 CellID->29704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<INSERT INTO MAILER (MAILERID, USERNAME, SENDMAILER) VALUES (NULL, \
'user4', 0)\>\""}], "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[16]:=",
 CellID->6995],

Cell[BoxData[
 RowBox[{
  RowBox[{"JDBC", "::", "\<\"error\"\>"}], ":", 
  " ", "\<\"JDBC error: \\!\\(\\\"Integrity constraint violation - no\\\"\
\[Ellipsis]\\\"NDMAILER) VALUES (NULL, 'user4', 0)]\\\"\\)\"\>"}]], "Message",\
 "MSG",
 CellTags->"b:4.2.4",
 CellLabel->"From In[16]:=",
 CellID->1052],

Cell[BoxData["$Failed"], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[16]=",
 CellID->25269]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["SENDMAILER",
  FontSlant->"Italic"],
 " column has a default value and is therefore not required when data is \
inserted."
}], "Text",
 CellTags->"b:4.2.4",
 CellID->7479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", 
   "\"\<INSERT INTO MAILER (MAILERID, USERNAME) VALUES (NULL, 'user2')\>\""}],
   "]"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[17]:=",
 CellID->18238],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[17]=",
 CellID->26423]
}, Open  ]],

Cell["\<\
A SELECT statement verifies that the data exists in the database and ties the \
values together.\
\>", "Text",
 CellTags->"b:4.2.4",
 CellID->27918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", " ", 
    "\"\<SELECT USERNAME, ADDRESS, CITY, ZIPCODE, SENDMAILER FROM ADDRESSES, \
MAILER WHERE ADDRESSES.USERNAME = MAILER.USERNAME\>\"", ",", " ", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[18]:=",
 CellID->10866],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"USERNAME\"\>", "\<\"ADDRESS\"\>", "\<\"CITY\"\>", \
"\<\"ZIPCODE\"\>", "\<\"SENDMAILER\"\>"},
    {"\<\"user1\"\>", "\<\"100 Trade Center\"\>", "\<\"Champaign, IL\"\>", \
"\<\"61820\"\>", "False"},
    {"\<\"user2\"\>", "\<\"200 Trade Center\"\>", "\<\"Champaign, IL\"\>", \
"\<\"61820\"\>", "False"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:4.2.4",
 CellLabel->"Out[18]//TableForm=",
 CellID->17659]
}, Open  ]],

Cell["This deletes the tables and closes the connection.", "Text",
 CellTags->"b:4.2.4",
 CellID->32498],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", "\"\<DROP TABLE MAILER\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", "\"\<DROP TABLE ADDRESSES\>\""}], "]"}], 
  ";"}], "\n", 
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]}], "Input",
 CellTags->"b:4.2.4",
 CellLabel->"In[19]:=",
 CellID->28486]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inserting Data with Raw SQL - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 53.0933464}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "The SQL command INSERT inserts data into a database. An alternative is \
to use the Mathematica command SQLInsert, as described in Inserting Data. If \
you find that the examples in this tutorial do not work as shown, you may \
need to install or restore the example database with the DatabaseExamples` \
package, as described in Using the Example Databases. When inserting data, \
the result of SQLExecute is an integer specifying the number of rows affected \
by the query.", "synonyms" -> {}, "title" -> "Inserting Data with Raw SQL", 
    "type" -> "Tutorial", "uri" -> "DatabaseLink/tutorial/SQLInsertingData"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.2.4"->{
  Cell[792, 32, 491, 17, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->14721],
  Cell[1725, 66, 312, 9, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->29309],
  Cell[2040, 77, 251, 10, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->20415],
  Cell[2294, 89, 287, 9, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->17902],
  Cell[2584, 100, 357, 14, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->29873],
  Cell[2944, 116, 686, 17, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->17124],
  Cell[3633, 135, 192, 7, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->23941],
  Cell[3850, 146, 329, 9, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->32745],
  Cell[4182, 157, 89, 3, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->31762],
  Cell[4286, 163, 132, 4, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->28423],
  Cell[4443, 171, 188, 6, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->27531],
  Cell[4634, 179, 252, 8, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->4806],
  Cell[4901, 190, 400, 13, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->12268],
  Cell[5326, 207, 328, 9, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->9318],
  Cell[5657, 218, 300, 8, 70, "Message",
   CellTags->"b:4.2.4",
   CellID->5602],
  Cell[5960, 228, 95, 3, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->31907],
  Cell[6070, 234, 388, 16, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->24307],
  Cell[6483, 254, 329, 9, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->23481],
  Cell[6815, 265, 300, 8, 70, "Message",
   CellTags->"b:4.2.4",
   CellID->1012],
  Cell[7118, 275, 95, 3, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->21136],
  Cell[7228, 281, 255, 13, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->26630],
  Cell[7508, 298, 329, 9, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->24114],
  Cell[7840, 309, 89, 3, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->26809],
  Cell[7944, 315, 131, 4, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->4084],
  Cell[8100, 323, 189, 6, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->23556],
  Cell[8292, 331, 422, 12, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->12290],
  Cell[8729, 346, 689, 20, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->21293],
  Cell[9443, 370, 480, 14, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->29996],
  Cell[9926, 386, 90, 3, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->29152],
  Cell[10031, 392, 131, 4, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->1054],
  Cell[10187, 400, 189, 6, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->25345],
  Cell[10379, 408, 574, 15, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->14708],
  Cell[10968, 426, 435, 12, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->248],
  Cell[11428, 442, 172, 5, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->7491],
  Cell[11603, 449, 381, 12, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->13712],
  Cell[12021, 466, 248, 8, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->5131],
  Cell[12272, 476, 90, 3, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->30114],
  Cell[12377, 482, 132, 4, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->16439],
  Cell[12534, 490, 184, 6, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->7958],
  Cell[12721, 498, 187, 7, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->24722],
  Cell[12923, 508, 359, 15, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->29704],
  Cell[13307, 527, 248, 8, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->6995],
  Cell[13558, 537, 301, 8, 70, "Message",
   CellTags->"b:4.2.4",
   CellID->1052],
  Cell[13862, 547, 96, 3, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->25269],
  Cell[13973, 553, 207, 8, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->7479],
  Cell[14205, 565, 235, 8, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->18238],
  Cell[14443, 575, 90, 3, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->26423],
  Cell[14548, 581, 158, 5, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->27918],
  Cell[14731, 590, 401, 11, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->10866],
  Cell[15135, 603, 839, 23, 70, "Output",
   CellTags->"b:4.2.4",
   CellID->17659],
  Cell[15989, 629, 104, 2, 70, "Text",
   CellTags->"b:4.2.4",
   CellID->32498],
  Cell[16096, 633, 376, 11, 70, "Input",
   CellTags->"b:4.2.4",
   CellID->28486]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.2.4", 18255, 687}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 60, 1, 70, "Title",
 CellID->26153],
Cell[792, 32, 491, 17, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->14721],
Cell[1286, 51, 436, 13, 70, "Text",
 CellID->6064],
Cell[1725, 66, 312, 9, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->29309],
Cell[2040, 77, 251, 10, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->20415],
Cell[2294, 89, 287, 9, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->17902],
Cell[2584, 100, 357, 14, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->29873],
Cell[2944, 116, 686, 17, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->17124],
Cell[3633, 135, 192, 7, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->23941],
Cell[CellGroupData[{
Cell[3850, 146, 329, 9, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->32745],
Cell[4182, 157, 89, 3, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->31762]
}, Open  ]],
Cell[4286, 163, 132, 4, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->28423],
Cell[CellGroupData[{
Cell[4443, 171, 188, 6, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->27531],
Cell[4634, 179, 252, 8, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->4806]
}, Open  ]],
Cell[4901, 190, 400, 13, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->12268],
Cell[CellGroupData[{
Cell[5326, 207, 328, 9, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->9318],
Cell[5657, 218, 300, 8, 70, "Message",
 CellTags->"b:4.2.4",
 CellID->5602],
Cell[5960, 228, 95, 3, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->31907]
}, Open  ]],
Cell[6070, 234, 388, 16, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->24307],
Cell[CellGroupData[{
Cell[6483, 254, 329, 9, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->23481],
Cell[6815, 265, 300, 8, 70, "Message",
 CellTags->"b:4.2.4",
 CellID->1012],
Cell[7118, 275, 95, 3, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->21136]
}, Open  ]],
Cell[7228, 281, 255, 13, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->26630],
Cell[CellGroupData[{
Cell[7508, 298, 329, 9, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->24114],
Cell[7840, 309, 89, 3, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->26809]
}, Open  ]],
Cell[7944, 315, 131, 4, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->4084],
Cell[CellGroupData[{
Cell[8100, 323, 189, 6, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->23556],
Cell[8292, 331, 422, 12, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->12290]
}, Open  ]],
Cell[8729, 346, 689, 20, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->21293],
Cell[CellGroupData[{
Cell[9443, 370, 480, 14, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->29996],
Cell[9926, 386, 90, 3, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->29152]
}, Open  ]],
Cell[10031, 392, 131, 4, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->1054],
Cell[CellGroupData[{
Cell[10187, 400, 189, 6, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->25345],
Cell[10379, 408, 574, 15, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->14708]
}, Open  ]],
Cell[10968, 426, 435, 12, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->248],
Cell[CellGroupData[{
Cell[11428, 442, 172, 5, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->7491],
Cell[11603, 449, 381, 12, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->13712]
}, Open  ]],
Cell[CellGroupData[{
Cell[12021, 466, 248, 8, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->5131],
Cell[12272, 476, 90, 3, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->30114]
}, Open  ]],
Cell[12377, 482, 132, 4, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->16439],
Cell[CellGroupData[{
Cell[12534, 490, 184, 6, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->7958],
Cell[12721, 498, 187, 7, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->24722]
}, Open  ]],
Cell[12923, 508, 359, 15, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->29704],
Cell[CellGroupData[{
Cell[13307, 527, 248, 8, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->6995],
Cell[13558, 537, 301, 8, 70, "Message",
 CellTags->"b:4.2.4",
 CellID->1052],
Cell[13862, 547, 96, 3, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->25269]
}, Open  ]],
Cell[13973, 553, 207, 8, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->7479],
Cell[CellGroupData[{
Cell[14205, 565, 235, 8, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->18238],
Cell[14443, 575, 90, 3, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->26423]
}, Open  ]],
Cell[14548, 581, 158, 5, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->27918],
Cell[CellGroupData[{
Cell[14731, 590, 401, 11, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->10866],
Cell[15135, 603, 839, 23, 70, "Output",
 CellTags->"b:4.2.4",
 CellID->17659]
}, Open  ]],
Cell[15989, 629, 104, 2, 70, "Text",
 CellTags->"b:4.2.4",
 CellID->32498],
Cell[16096, 633, 376, 11, 70, "Input",
 CellTags->"b:4.2.4",
 CellID->28486]
}, Open  ]],
Cell[16487, 647, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

