(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15994,        570]
NotebookOptionsPosition[      9927,        357]
NotebookOutlinePosition[     13798,        479]
CellTagsIndexPosition[     13728,        474]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Updating Data with Raw SQL", "Title",
 CellID->4693],

Cell[TextData[{
 "The raw SQL command UPDATE updates data in a database. An alternative is to \
use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command ",
 Cell[BoxData[
  ButtonBox["SQLUpdate",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLUpdate"]], "InlineFormula"],
 ", described in ",
 ButtonBox["Updating Data",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UpdatingData"],
 ". "
}], "Text",
 CellTags->"b:4.2.5",
 CellID->22104],

Cell[TextData[{
 "If you find that the examples in this ",
 "tutorial",
 " do not work as shown, you may need to install or restore the example \
database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->15084],

Cell[TextData[{
 "When updating data, the result of ",
 Cell[BoxData[
  ButtonBox["SQLExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLExecute"]], "InlineFormula"],
 " is an integer specifying the number of rows affected by the query."
}], "Text",
 CellTags->"b:4.2.5",
 CellID->19095],

Cell[TextData[{
 "Here is an example that updates data. This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:4.2.5",
 CellID->13525],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:4.2.5",
 CellLabel->"In[1]:=",
 CellID->30221],

Cell[TextData[{
 "As discussed in ",
 ButtonBox["Creating Tables with Raw SQL",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/SQLCreatingTables"],
 ", the ADDRESSES and ",
 "MAILER",
 " tables should be created."
}], "Text",
 CellTags->"b:4.2.5",
 CellID->3964],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", " ", "\[IndentingNewLine]", 
    "\"\<CREATE TABLE ADDRESSES (\n    USERNAME VARCHAR NOT NULL PRIMARY KEY, \
\n    ADDRESS VARCHAR,\n    CITY VARCHAR, \n    ZIPCODE VARCHAR, \n    UNIQUE \
(ADDRESS, CITY, ZIPCODE))\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", " ", 
    "\"\<CREATE TABLE MAILER (\n  MAILERID INT IDENTITY, \n  USERNAME VARCHAR \
NOT NULL, \n  SENDMAILER BIT DEFAULT '1' NOT NULL,\n  FOREIGN KEY (USERNAME) \
REFERENCES ADDRESSES (USERNAME))\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", 
    "\"\<INSERT INTO ADDRESSES (USERNAME, ADDRESS, CITY, ZIPCODE) VALUES \
(`1`)\>\"", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{
        "\"\<user1\>\"", ",", "\"\<100 Trade Center\>\"", ",", 
         "\"\<Champaign, IL\>\"", ",", "\"\<61820\>\""}], "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{
        "\"\<user2\>\"", ",", "\"\<200 Trade Center\>\"", ",", 
         "\"\<Champaign, IL\>\"", ",", "\"\<61820\>\""}], "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{
        "\"\<user3\>\"", ",", "\"\<300 Trade Center\>\"", ",", 
         "\"\<Champaign, IL\>\"", ",", "\"\<61820\>\""}], "]"}], "}"}]}], 
     "}"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", 
    "\"\<INSERT INTO MAILER (MAILERID, USERNAME, SENDMAILER) VALUES \
(`1`)\>\"", ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{"Null", ",", "\"\<user1\>\"", ",", "False"}], "]"}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"SQLArgument", "[", 
        RowBox[{"Null", ",", "\"\<user2\>\"", ",", "False"}], "]"}], "}"}]}], 
     "}"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], "Input",
 CellTags->"b:4.2.5",
 CellLabel->"In[3]:=",
 CellID->21781],

Cell["\<\
This executes an SQL statement that updates a row in the MAILER table. This \
query updates the SENDMAILER column based on the value of USERNAME. Many \
update statements may be created using conditions that work with values in \
columns.\
\>", "Text",
 CellTags->"b:4.2.5",
 CellID->4872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{
  "conn", ",", " ", "\[IndentingNewLine]", "  ", 
   "\"\<UPDATE MAILER SET SENDMAILER = 1 WHERE USERNAME = 'user1'\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.5",
 CellLabel->"In[7]:=",
 CellID->8106],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.2.5",
 CellLabel->"Out[7]=",
 CellID->3656]
}, Open  ]],

Cell["\<\
A SELECT statement verifies that the data has been changed in the table.\
\>", "Text",
 CellTags->"b:4.2.5",
 CellID->3343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM MAILER\>\""}], "]"}]], "Input",\

 CellTags->"b:4.2.5",
 CellLabel->"In[8]:=",
 CellID->22593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "\<\"user1\"\>", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "\<\"user2\"\>", ",", "False"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.2.5",
 CellLabel->"Out[8]=",
 CellID->27080]
}, Open  ]],

Cell[TextData[{
 "Using prepared statements, you can dynamically create SQL statements that \
update data within the database. You can combine this with a simple ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function. This example updates the address for a particular user."
}], "Text",
 CellTags->"b:4.2.5",
 CellID->16080],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetAddress", "[", 
   RowBox[{"username_String", ",", " ", "address_String"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"SQLExecute", "[", 
   RowBox[{
   "conn", ",", " ", "\[IndentingNewLine]", "  ", 
    "\"\<UPDATE ADDRESSES SET ADDRESS = `2` WHERE USERNAME = `1`\>\"", ",", 
    " ", 
    RowBox[{"{", 
     RowBox[{"username", ",", " ", "address"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:4.2.5",
 CellLabel->"In[9]:=",
 CellID->14868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetAddress", "[", 
  RowBox[{"\"\<user1\>\"", ",", " ", "\"\<100 Trade Center Office 123\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.5",
 CellLabel->"In[10]:=",
 CellID->21411],

Cell[BoxData["1"], "Output",
 CellTags->"b:4.2.5",
 CellLabel->"Out[10]=",
 CellID->13713]
}, Open  ]],

Cell["\<\
A SELECT statement verifies that the data has been changed in the table.\
\>", "Text",
 CellTags->"b:4.2.5",
 CellID->20968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLExecute", "[", 
  RowBox[{"conn", ",", " ", "\"\<SELECT * FROM ADDRESSES\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.5",
 CellLabel->"In[11]:=",
 CellID->3251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"user1\"\>", ",", "\<\"100 Trade Center Office 123\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"user2\"\>", ",", "\<\"200 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"user3\"\>", ",", "\<\"300 Trade Center\"\>", 
     ",", "\<\"Champaign, IL\"\>", ",", "\<\"61820\"\>"}], "}"}]}], 
  "}"}]], "Output",
 CellTags->"b:4.2.5",
 CellLabel->"Out[11]=",
 CellID->27216]
}, Open  ]],

Cell["\<\
The same restrictions that apply to inserts also apply to updates. Thus, if \
you try to update an ADDRESS value to equal the ADDRESS value of another row, \
an error will be returned; this table requires them to be unique.\
\>", "Text",
 CellTags->"b:4.2.5",
 CellID->12079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetAddress", "[", 
  RowBox[{"\"\<user1\>\"", ",", " ", "\"\<200 Trade Center\>\""}], 
  "]"}]], "Input",
 CellTags->"b:4.2.5",
 CellLabel->"In[12]:=",
 CellID->28768],

Cell[BoxData[
 RowBox[{
  RowBox[{"JDBC", "::", "\<\"error\"\>"}], ":", 
  " ", "\<\"JDBC error: \\!\\(\\\"Unique constraint violation: SYS_CT\\\"\
\[Ellipsis]\\\" SET ADDRESS = ? WHERE USERNAME = ?]\\\"\\)\"\>"}]], "Message",\
 "MSG",
 CellTags->"b:4.2.5",
 CellLabel->"From In[12]:=",
 CellID->17040],

Cell[BoxData["$Failed"], "Output",
 CellTags->"b:4.2.5",
 CellLabel->"Out[12]=",
 CellID->31531]
}, Open  ]],

Cell["This deletes the tables and closes the connection.", "Text",
 CellTags->"b:4.2.5",
 CellID->12933],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", "\"\<DROP TABLE MAILER\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLExecute", "[", 
   RowBox[{"conn", ",", "\"\<DROP TABLE ADDRESSES\>\""}], "]"}], 
  ";"}], "\n", 
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]}], "Input",
 CellTags->"b:4.2.5",
 CellLabel->"In[9]:=",
 CellID->23779]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Updating Data with Raw SQL - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 54.7183360}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "The raw SQL command UPDATE updates data in a database. An alternative is \
to use the Mathematica command SQLUpdate, described in Updating Data. If you \
find that the examples in this tutorial do not work as shown, you may need to \
install or restore the example database with the DatabaseExamples` package, \
as described in Using the Example Databases. When updating data, the result \
of SQLExecute is an integer specifying the number of rows affected by the \
query.", "synonyms" -> {}, "title" -> "Updating Data with Raw SQL", "type" -> 
    "Tutorial", "uri" -> "DatabaseLink/tutorial/SQLUpdatingData"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:4.2.5"->{
  Cell[790, 32, 488, 17, 70, "Text",
   CellTags->"b:4.2.5",
   CellID->22104],
  Cell[1721, 66, 311, 9, 70, "Text",
   CellTags->"b:4.2.5",
   CellID->19095],
  Cell[2035, 77, 251, 10, 70, "Text",
   CellTags->"b:4.2.5",
   CellID->13525],
  Cell[2289, 89, 287, 9, 70, "Input",
   CellTags->"b:4.2.5",
   CellID->30221],
  Cell[2579, 100, 280, 10, 70, "Text",
   CellTags->"b:4.2.5",
   CellID->3964],
  Cell[2862, 112, 2176, 57, 70, "Input",
   CellTags->"b:4.2.5",
   CellID->21781],
  Cell[5041, 171, 299, 7, 70, "Text",
   CellTags->"b:4.2.5",
   CellID->4872],
  Cell[5365, 182, 257, 8, 70, "Input",
   CellTags->"b:4.2.5",
   CellID->8106],
  Cell[5625, 192, 88, 3, 70, "Output",
   CellTags->"b:4.2.5",
   CellID->3656],
  Cell[5728, 198, 133, 4, 70, "Text",
   CellTags->"b:4.2.5",
   CellID->3343],
  Cell[5886, 206, 184, 6, 70, "Input",
   CellTags->"b:4.2.5",
   CellID->22593],
  Cell[6073, 214, 286, 10, 70, "Output",
   CellTags->"b:4.2.5",
   CellID->27080],
  Cell[6374, 227, 333, 8, 70, "Text",
   CellTags->"b:4.2.5",
   CellID->16080],
  Cell[6710, 237, 488, 14, 70, "Input",
   CellTags->"b:4.2.5",
   CellID->14868],
  Cell[7223, 255, 202, 6, 70, "Input",
   CellTags->"b:4.2.5",
   CellID->21411],
  Cell[7428, 263, 90, 3, 70, "Output",
   CellTags->"b:4.2.5",
   CellID->13713],
  Cell[7533, 269, 134, 4, 70, "Text",
   CellTags->"b:4.2.5",
   CellID->20968],
  Cell[7692, 277, 188, 6, 70, "Input",
   CellTags->"b:4.2.5",
   CellID->3251],
  Cell[7883, 285, 585, 15, 70, "Output",
   CellTags->"b:4.2.5",
   CellID->27216],
  Cell[8483, 303, 285, 6, 70, "Text",
   CellTags->"b:4.2.5",
   CellID->12079],
  Cell[8793, 313, 191, 6, 70, "Input",
   CellTags->"b:4.2.5",
   CellID->28768],
  Cell[8987, 321, 302, 8, 70, "Message",
   CellTags->"b:4.2.5",
   CellID->17040],
  Cell[9292, 331, 96, 3, 70, "Output",
   CellTags->"b:4.2.5",
   CellID->31531],
  Cell[9403, 337, 104, 2, 70, "Text",
   CellTags->"b:4.2.5",
   CellID->12933],
  Cell[9510, 341, 375, 11, 70, "Input",
   CellTags->"b:4.2.5",
   CellID->23779]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:4.2.5", 11662, 395}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 58, 1, 70, "Title",
 CellID->4693],
Cell[790, 32, 488, 17, 70, "Text",
 CellTags->"b:4.2.5",
 CellID->22104],
Cell[1281, 51, 437, 13, 70, "Text",
 CellID->15084],
Cell[1721, 66, 311, 9, 70, "Text",
 CellTags->"b:4.2.5",
 CellID->19095],
Cell[2035, 77, 251, 10, 70, "Text",
 CellTags->"b:4.2.5",
 CellID->13525],
Cell[2289, 89, 287, 9, 70, "Input",
 CellTags->"b:4.2.5",
 CellID->30221],
Cell[2579, 100, 280, 10, 70, "Text",
 CellTags->"b:4.2.5",
 CellID->3964],
Cell[2862, 112, 2176, 57, 70, "Input",
 CellTags->"b:4.2.5",
 CellID->21781],
Cell[5041, 171, 299, 7, 70, "Text",
 CellTags->"b:4.2.5",
 CellID->4872],
Cell[CellGroupData[{
Cell[5365, 182, 257, 8, 70, "Input",
 CellTags->"b:4.2.5",
 CellID->8106],
Cell[5625, 192, 88, 3, 70, "Output",
 CellTags->"b:4.2.5",
 CellID->3656]
}, Open  ]],
Cell[5728, 198, 133, 4, 70, "Text",
 CellTags->"b:4.2.5",
 CellID->3343],
Cell[CellGroupData[{
Cell[5886, 206, 184, 6, 70, "Input",
 CellTags->"b:4.2.5",
 CellID->22593],
Cell[6073, 214, 286, 10, 70, "Output",
 CellTags->"b:4.2.5",
 CellID->27080]
}, Open  ]],
Cell[6374, 227, 333, 8, 70, "Text",
 CellTags->"b:4.2.5",
 CellID->16080],
Cell[6710, 237, 488, 14, 70, "Input",
 CellTags->"b:4.2.5",
 CellID->14868],
Cell[CellGroupData[{
Cell[7223, 255, 202, 6, 70, "Input",
 CellTags->"b:4.2.5",
 CellID->21411],
Cell[7428, 263, 90, 3, 70, "Output",
 CellTags->"b:4.2.5",
 CellID->13713]
}, Open  ]],
Cell[7533, 269, 134, 4, 70, "Text",
 CellTags->"b:4.2.5",
 CellID->20968],
Cell[CellGroupData[{
Cell[7692, 277, 188, 6, 70, "Input",
 CellTags->"b:4.2.5",
 CellID->3251],
Cell[7883, 285, 585, 15, 70, "Output",
 CellTags->"b:4.2.5",
 CellID->27216]
}, Open  ]],
Cell[8483, 303, 285, 6, 70, "Text",
 CellTags->"b:4.2.5",
 CellID->12079],
Cell[CellGroupData[{
Cell[8793, 313, 191, 6, 70, "Input",
 CellTags->"b:4.2.5",
 CellID->28768],
Cell[8987, 321, 302, 8, 70, "Message",
 CellTags->"b:4.2.5",
 CellID->17040],
Cell[9292, 331, 96, 3, 70, "Output",
 CellTags->"b:4.2.5",
 CellID->31531]
}, Open  ]],
Cell[9403, 337, 104, 2, 70, "Text",
 CellTags->"b:4.2.5",
 CellID->12933],
Cell[9510, 341, 375, 11, 70, "Input",
 CellTags->"b:4.2.5",
 CellID->23779]
}, Open  ]],
Cell[9900, 355, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

