(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11553,        392]
NotebookOptionsPosition[      5888,        209]
NotebookOutlinePosition[      9983,        328]
CellTagsIndexPosition[      9890,        322]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Secure Socket Layer (SSL)", "Title",
 CellTags->{"xref:159", "b:6.5"},
 CellID->24208],

Cell["\<\
Secure Socket Layer (SSL) is a protocol for providing secure transactions \
between servers and clients. It uses a certificate to identify one or both \
ends of the transaction. It can be useful for database communications to \
protect any authentication information, such as usernames and passwords, as \
well as the actual data itself.\
\>", "Text",
 CellTags->"b:6.5",
 CellID->9646],

Cell[TextData[{
 "Some databases support SSL and some do not. To know if your database \
supports SSL, you need to study the documentation for your database and work \
with the administrator of the database. If your database can be configured to \
use SSL with JDBC, it should be possible to configure ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " to communicate with the database using SSL."
}], "Text",
 CellTags->"b:6.5",
 CellID->22276],

Cell[TextData[{
 "One database that does support SSL is MySQL, and it is possible for ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " to communicate with a MySQL database using SSL. You will need to configure \
the database to provide SSL communications and generate a certificate. To do \
this you will need to work with the administrator of your database."
}], "Text",
 CellTags->"b:6.5",
 CellID->25759],

Cell["\<\
There are typically four stages to setting up SSL to work with a MySQL \
database.\
\>", "Text",
 CellTags->"b:6.5",
 CellID->30189],

Cell["Get a certificate of authority.", "ItemizedText",
 CellTags->"b:6.5",
 CellID->30422],

Cell["Generate a truststore file.", "ItemizedText",
 CellTags->"b:6.5",
 CellID->27666],

Cell["Configure Java to use the truststore.", "ItemizedText",
 CellTags->"b:6.5",
 CellID->8486],

Cell[CellGroupData[{

Cell["Configure the connection to use SSL.", "ItemizedText",
 CellTags->"b:6.5",
 CellID->3455],

Cell[TextData[{
 "The administrator of the server should be able to provide the certificate \
of authority, suppose this is called ",
 StyleBox["CA.cer", "InlineCode"],
 "."
}], "Text",
 CellTags->"b:6.5",
 CellID->2028],

Cell[TextData[{
 "You need to generate the truststore file. This can be done with the ",
 StyleBox["keytool", "InlineCode"],
 " executable that is part of a Java Runtime Environment (JRE). You can use \
the version included in the JRE that ships with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". To generate the truststore file, you would need to execute the following \
in some type of shell (e.g. a command prompt on Windows)."
}], "Text",
 CellTags->"b:6.5",
 CellID->29614],

Cell["keytool -import -file CA.cer -keystore truststore", "Program",
 CellTags->"b:6.5",
 CellID->4860],

Cell[TextData[{
 "This will generate the file ",
 StyleBox["truststore", "InlineCode"],
 "."
}], "Text",
 CellTags->"b:6.5",
 CellID->29253],

Cell[TextData[{
 "The next stage is to modify your Java command line for ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to refer to the ",
 StyleBox["truststore", "InlineCode"],
 " file. This can be done by adding the following settings, in which you need \
to give the full pathname to the ",
 StyleBox["truststore", "InlineCode"],
 " file that was generated."
}], "Text",
 CellTags->"b:6.5",
 CellID->11777],

Cell["\<\
-Djavax.net.ssl.trustStore=c:\\java-examples\\truststore
-Djavax.net.ssl.trustStorePassword=keystore\
\>", "Program",
 CellTags->"b:6.5",
 CellID->31348],

Cell[TextData[{
 "If you are running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " inside a web server, such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"web", 
    StyleBox[
     AdjustmentBox["Mathematica",
      BoxMargins->{{-0.175, 0}, {0, 0}}],
     FontSlant->"Italic"]}], TextForm]]],
 ", you will need to add these settings to the server that launches Java by \
following your server documentation. If you are running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a stand-alone fashion, you can add the settings to the options of Java \
by executing the following before you load ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:6.5",
 CellID->12503],

Cell["\<\
Needs[ \"JLink`\"];
SetOptions[InstallJava, JVMArguments \
->\"-Djavax.net.ssl.trustStore=c:\\java-examples\\truststore \
-Djavax.net.ssl.trustStorePassword=keystore\"]\
\>", "Program",
 CellTags->"b:6.5",
 CellID->10861],

Cell["\<\
Finally, you need to modify the URL that connects to the database. This can \
be done by placing an extra parameter with a '?', as shown in the following.\
\>", "Text",
 CellTags->"b:6.5",
 CellID->22431],

Cell["\<\
OpenSQLConnection[ JDBC[ \"com.mysql.jdbc.Driver\",
\"databases:1234/conn_test?useSSL=true\"], \"Username\" -> \"test\"]\
\>", "Program",
 CellTags->"b:6.5",
 CellID->29082],

Cell[TextData[{
 "It should be noted that not all databases support SSL and that databases \
other than MySQL that do support SSL may need to be configured in a different \
way to work with ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:6.5",
 CellID->12455]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Secure Socket Layer (SSL) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 47.3746330}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "Secure Socket Layer (SSL) is a protocol for providing secure \
transactions between servers and clients. It uses a certificate to identify \
one or both ends of the transaction. It can be useful for database \
communications to protect any authentication information, such as usernames \
and passwords, as well as the actual data itself. Some databases support SSL \
and some do not. To know if your database supports SSL, you need to study the \
documentation for your database and work with the administrator of the \
database. If your database can be configured to use SSL with JDBC, it should \
be possible to configure DatabaseLink to communicate with the database using \
SSL. One database that does support SSL is MySQL, and it is possible for \
DatabaseLink to communicate with a MySQL database using SSL. You will need to \
configure the database to provide SSL communications and generate a \
certificate. To do this you will need to work with the administrator of your \
database.", "synonyms" -> {}, "title" -> "Secure Socket Layer SSL", "type" -> 
    "Tutorial", "uri" -> "DatabaseLink/tutorial/SecureSocketLayer"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:159"->{
  Cell[729, 29, 92, 2, 70, "Title",
   CellTags->{"xref:159", "b:6.5"},
   CellID->24208]},
 "b:6.5"->{
  Cell[729, 29, 92, 2, 70, "Title",
   CellTags->{"xref:159", "b:6.5"},
   CellID->24208],
  Cell[824, 33, 396, 8, 70, "Text",
   CellTags->"b:6.5",
   CellID->9646],
  Cell[1223, 43, 450, 10, 70, "Text",
   CellTags->"b:6.5",
   CellID->22276],
  Cell[1676, 55, 414, 9, 70, "Text",
   CellTags->"b:6.5",
   CellID->25759],
  Cell[2093, 66, 142, 5, 70, "Text",
   CellTags->"b:6.5",
   CellID->30189],
  Cell[2238, 73, 91, 2, 70, "ItemizedText",
   CellTags->"b:6.5",
   CellID->30422],
  Cell[2332, 77, 87, 2, 70, "ItemizedText",
   CellTags->"b:6.5",
   CellID->27666],
  Cell[2422, 81, 96, 2, 70, "ItemizedText",
   CellTags->"b:6.5",
   CellID->8486],
  Cell[2543, 87, 95, 2, 70, "ItemizedText",
   CellTags->"b:6.5",
   CellID->3455],
  Cell[2641, 91, 220, 7, 70, "Text",
   CellTags->"b:6.5",
   CellID->2028],
  Cell[2864, 100, 488, 11, 70, "Text",
   CellTags->"b:6.5",
   CellID->29614],
  Cell[3355, 113, 103, 2, 70, "Program",
   CellTags->"b:6.5",
   CellID->4860],
  Cell[3461, 117, 140, 6, 70, "Text",
   CellTags->"b:6.5",
   CellID->29253],
  Cell[3604, 125, 412, 12, 70, "Text",
   CellTags->"b:6.5",
   CellID->11777],
  Cell[4019, 139, 163, 5, 70, "Program",
   CellTags->"b:6.5",
   CellID->31348],
  Cell[4185, 146, 714, 23, 70, "Text",
   CellTags->"b:6.5",
   CellID->12503],
  Cell[4902, 171, 231, 7, 70, "Program",
   CellTags->"b:6.5",
   CellID->10861],
  Cell[5136, 180, 214, 5, 70, "Text",
   CellTags->"b:6.5",
   CellID->22431],
  Cell[5353, 187, 183, 5, 70, "Program",
   CellTags->"b:6.5",
   CellID->29082],
  Cell[5539, 194, 295, 9, 70, "Text",
   CellTags->"b:6.5",
   CellID->12455]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:159", 8141, 254},
 {"b:6.5", 8245, 258}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 92, 2, 70, "Title",
 CellTags->{"xref:159", "b:6.5"},
 CellID->24208],
Cell[824, 33, 396, 8, 70, "Text",
 CellTags->"b:6.5",
 CellID->9646],
Cell[1223, 43, 450, 10, 70, "Text",
 CellTags->"b:6.5",
 CellID->22276],
Cell[1676, 55, 414, 9, 70, "Text",
 CellTags->"b:6.5",
 CellID->25759],
Cell[2093, 66, 142, 5, 70, "Text",
 CellTags->"b:6.5",
 CellID->30189],
Cell[2238, 73, 91, 2, 70, "ItemizedText",
 CellTags->"b:6.5",
 CellID->30422],
Cell[2332, 77, 87, 2, 70, "ItemizedText",
 CellTags->"b:6.5",
 CellID->27666],
Cell[2422, 81, 96, 2, 70, "ItemizedText",
 CellTags->"b:6.5",
 CellID->8486],
Cell[CellGroupData[{
Cell[2543, 87, 95, 2, 70, "ItemizedText",
 CellTags->"b:6.5",
 CellID->3455],
Cell[2641, 91, 220, 7, 70, "Text",
 CellTags->"b:6.5",
 CellID->2028],
Cell[2864, 100, 488, 11, 70, "Text",
 CellTags->"b:6.5",
 CellID->29614],
Cell[3355, 113, 103, 2, 70, "Program",
 CellTags->"b:6.5",
 CellID->4860],
Cell[3461, 117, 140, 6, 70, "Text",
 CellTags->"b:6.5",
 CellID->29253],
Cell[3604, 125, 412, 12, 70, "Text",
 CellTags->"b:6.5",
 CellID->11777],
Cell[4019, 139, 163, 5, 70, "Program",
 CellTags->"b:6.5",
 CellID->31348],
Cell[4185, 146, 714, 23, 70, "Text",
 CellTags->"b:6.5",
 CellID->12503],
Cell[4902, 171, 231, 7, 70, "Program",
 CellTags->"b:6.5",
 CellID->10861],
Cell[5136, 180, 214, 5, 70, "Text",
 CellTags->"b:6.5",
 CellID->22431],
Cell[5353, 187, 183, 5, 70, "Program",
 CellTags->"b:6.5",
 CellID->29082],
Cell[5539, 194, 295, 9, 70, "Text",
 CellTags->"b:6.5",
 CellID->12455]
}, Open  ]]
}, Open  ]],
Cell[5861, 207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

