(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20596,        583]
NotebookOptionsPosition[     15674,        412]
NotebookOutlinePosition[     19066,        520]
CellTagsIndexPosition[     18949,        513]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLDataTypeInformation" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLDataTypeInformation"], 
         "SQLDataTypeNames" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLDataTypeNames"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"SQLDataTypeInformation\"\>", 
      2->"\<\"SQLDataTypeNames\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Data Types", "Title",
 CellTags->{"xref:27", "c:39", "b:3.5"},
 CellID->13169],

Cell["\<\
This tutorial discusses how to retrieve information about data types. When \
you create a table, you will need to refer to these data types. \
\>", "Text",
 CellTags->"b:3.5",
 CellID->23831],

Cell[TextData[{
 "If you find that the examples in this ",
 "tutorial",
 " do not work as shown, you may need to install or restore the example \
database with the ",
 StyleBox["DatabaseExamples`", "MR"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->20040],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SQLDataTypeNames",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLDataTypeNames"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "list all data type names within a data source", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLDataTypeInformation",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLDataTypeInformation"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "list all data type information within a data source", "TableText"]}
  }]], "DefinitionBox",
 CellID->26488],

Cell["Functions for retrieving information about data types.", "Caption",
 CellTags->"b:3.5",
 CellID->28685],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 StyleBox["demo",
  FontSlant->"Italic"],
 " database."
}], "Text",
 CellTags->"b:3.5",
 CellID->19090],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:3.5",
 CellLabel->"In[1]:=",
 CellID->19497],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLDataTypeNames",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDataTypeNames"]], 
  "InlineFormula"],
 " returns a list of the data type names within a database."
}], "Text",
 CellTags->"b:3.5",
 CellID->2589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SQLDataTypeNames", "[", "conn", "]"}]], "Input",
 CellTags->"b:3.5",
 CellLabel->"In[3]:=",
 CellID->25990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"TINYINT\"\>", ",", "\<\"BIGINT\"\>", 
   ",", "\<\"LONGVARBINARY\"\>", ",", "\<\"VARBINARY\"\>", 
   ",", "\<\"BINARY\"\>", ",", "\<\"LONGVARCHAR\"\>", ",", "\<\"CHAR\"\>", 
   ",", "\<\"NUMERIC\"\>", ",", "\<\"DECIMAL\"\>", ",", "\<\"INTEGER\"\>", 
   ",", "\<\"SMALLINT\"\>", ",", "\<\"FLOAT\"\>", ",", "\<\"REAL\"\>", 
   ",", "\<\"DOUBLE\"\>", ",", "\<\"VARCHAR\"\>", 
   ",", "\<\"VARCHAR_IGNORECASE\"\>", ",", "\<\"BOOLEAN\"\>", 
   ",", "\<\"DATE\"\>", ",", "\<\"TIME\"\>", ",", "\<\"TIMESTAMP\"\>", 
   ",", "\<\"OTHER\"\>"}], "}"}]], "Output",
 CellTags->"b:3.5",
 CellLabel->"Out[3]=",
 CellID->15145]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLDataTypeInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDataTypeInformation"]], 
  "InlineFormula"],
 " returns more complete information about the data types."
}], "Text",
 CellTags->"b:3.5",
 CellID->19353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLDataTypeInformation", "[", "conn", "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.5",
 CellLabel->"In[4]:=",
 CellID->19314],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TINYINT\"\>", 
     RowBox[{"-", "6"}], "3", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"TINYINT\"\>", "0", "0", 
     RowBox[{"-", "6"}], "0", "10", "1"},
    {"\<\"BIGINT\"\>", 
     RowBox[{"-", "5"}], "19", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"BIGINT\"\>", "0", "0", "25", "0", "10", 
     "1"},
    {"\<\"LONGVARBINARY\"\>", 
     RowBox[{"-", "4"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"LONGVARBINARY\"\>", "0", 
     "0", "30", "0", "0", "1"},
    {"\<\"VARBINARY\"\>", 
     RowBox[{"-", "3"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"VARBINARY\"\>", "0", "0", 
     "30", "0", "0", "1"},
    {"\<\"BINARY\"\>", 
     RowBox[{"-", "2"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"BINARY\"\>", "0", "0", 
     "30", "0", "0", "1"},
    {"\<\"LONGVARCHAR\"\>", 
     RowBox[{"-", "1"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "True", "3", "False", "False", "False", "\<\"LONGVARCHAR\"\>", "0", "0", 
     "40", "0", "0", "1"},
    {"\<\"CHAR\"\>", "1", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "True", 
     "3", "False", "False", "False", "\<\"CHAR\"\>", "0", "0", "1", "0", "0", 
     "1"},
    {"\<\"NUMERIC\"\>", "2", "646456993", "Null", 
     "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", "False", 
     "False", "\<\"NUMERIC\"\>", "0", "32767", "2", "0", "10", "1"},
    {"\<\"DECIMAL\"\>", "3", "646456993", "Null", 
     "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", "False", 
     "False", "\<\"DECIMAL\"\>", "0", "32767", "3", "0", "10", "1"},
    {"\<\"INTEGER\"\>", "4", "10", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"INTEGER\"\>", "0", "0", "4", "0", "10", 
     "1"},
    {"\<\"SMALLINT\"\>", "5", "5", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"SMALLINT\"\>", "0", "0", "5", "0", "10", 
     "1"},
    {"\<\"FLOAT\"\>", "6", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"FLOAT\"\>", 
     RowBox[{"-", "324"}], "306", "6", "0", "10", "1"},
    {"\<\"REAL\"\>", "7", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"REAL\"\>", 
     RowBox[{"-", "324"}], "306", "7", "0", "10", "1"},
    {"\<\"DOUBLE\"\>", "8", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"DOUBLE\"\>", 
     RowBox[{"-", "324"}], "306", "8", "0", "10", "1"},
    {"\<\"VARCHAR\"\>", "12", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "False", 
     "3", "False", "False", "False", "\<\"VARCHAR\"\>", "0", "0", "12", "0", 
     "0", "1"},
    {"\<\"VARCHAR_IGNORECASE\"\>", "12", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "True", 
     "3", "False", "False", "False", "\<\"VARCHAR_IGNORECASE\"\>", "0", "0", 
     "12", "0", "0", "4"},
    {"\<\"BOOLEAN\"\>", "16", "1", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"BOOLEAN\"\>", "0", "0", "16", "0", "0", 
     "1"},
    {"\<\"DATE\"\>", "91", "10", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"DATE\"\>", "0", "0", "9", 
     "1", "0", "1"},
    {"\<\"TIME\"\>", "92", "8", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"TIME\"\>", "0", "0", "9", 
     "2", "0", "1"},
    {"\<\"TIMESTAMP\"\>", "93", "29", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"TIMESTAMP\"\>", "0", "0", 
     "9", "3", "0", "1"},
    {"\<\"OTHER\"\>", "1111", "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", 
     "1", "True", "0", "False", "False", "False", "\<\"OTHER\"\>", "0", "0", 
     "1111", "0", "0", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.5",
 CellLabel->"Out[4]//TableForm=",
 CellID->18651]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLDataTypeInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLDataTypeInformation"]], 
  "InlineFormula"],
 " takes a single option: \"",
 StyleBox["ShowColumnHeadings", "MR"],
 "\". This returns the column headings."
}], "Text",
 CellTags->"b:3.5",
 CellID->26740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLDataTypeInformation", "[", 
   RowBox[{"conn", ",", " ", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:3.5",
 CellLabel->"In[5]:=",
 CellID->22044],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"TYPE_NAME\"\>", "\<\"DATA_TYPE\"\>", "\<\"PRECISION\"\>", \
"\<\"LITERAL_PREFIX\"\>", "\<\"LITERAL_SUFFIX\"\>", "\<\"CREATE_PARAMS\"\>", \
"\<\"NULLABLE\"\>", "\<\"CASE_SENSITIVE\"\>", "\<\"SEARCHABLE\"\>", \
"\<\"UNSIGNED_ATTRIBUTE\"\>", "\<\"FIXED_PREC_SCALE\"\>", "\<\"AUTO_INCREMENT\
\"\>", "\<\"LOCAL_TYPE_NAME\"\>", "\<\"MINIMUM_SCALE\"\>", "\<\"MAXIMUM_SCALE\
\"\>", "\<\"SQL_DATA_TYPE\"\>", "\<\"SQL_DATETIME_SUB\"\>", \
"\<\"NUM_PREC_RADIX\"\>", "\<\"TYPE_SUB\"\>"},
    {"\<\"TINYINT\"\>", 
     RowBox[{"-", "6"}], "3", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"TINYINT\"\>", "0", "0", 
     RowBox[{"-", "6"}], "0", "10", "1"},
    {"\<\"BIGINT\"\>", 
     RowBox[{"-", "5"}], "19", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"BIGINT\"\>", "0", "0", "25", "0", "10", 
     "1"},
    {"\<\"LONGVARBINARY\"\>", 
     RowBox[{"-", "4"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"LONGVARBINARY\"\>", "0", 
     "0", "30", "0", "0", "1"},
    {"\<\"VARBINARY\"\>", 
     RowBox[{"-", "3"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"VARBINARY\"\>", "0", "0", 
     "30", "0", "0", "1"},
    {"\<\"BINARY\"\>", 
     RowBox[{"-", "2"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"BINARY\"\>", "0", "0", 
     "30", "0", "0", "1"},
    {"\<\"LONGVARCHAR\"\>", 
     RowBox[{"-", "1"}], "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "True", "3", "False", "False", "False", "\<\"LONGVARCHAR\"\>", "0", "0", 
     "40", "0", "0", "1"},
    {"\<\"CHAR\"\>", "1", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "True", 
     "3", "False", "False", "False", "\<\"CHAR\"\>", "0", "0", "1", "0", "0", 
     "1"},
    {"\<\"NUMERIC\"\>", "2", "646456993", "Null", 
     "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", "False", 
     "False", "\<\"NUMERIC\"\>", "0", "32767", "2", "0", "10", "1"},
    {"\<\"DECIMAL\"\>", "3", "646456993", "Null", 
     "Null", "\<\"PRECISION,SCALE\"\>", "1", "False", "3", "False", "False", 
     "False", "\<\"DECIMAL\"\>", "0", "32767", "3", "0", "10", "1"},
    {"\<\"INTEGER\"\>", "4", "10", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"INTEGER\"\>", "0", "0", "4", "0", "10", 
     "1"},
    {"\<\"SMALLINT\"\>", "5", "5", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"SMALLINT\"\>", "0", "0", "5", "0", "10", 
     "1"},
    {"\<\"FLOAT\"\>", "6", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"FLOAT\"\>", 
     RowBox[{"-", "324"}], "306", "6", "0", "10", "1"},
    {"\<\"REAL\"\>", "7", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"REAL\"\>", 
     RowBox[{"-", "324"}], "306", "7", "0", "10", "1"},
    {"\<\"DOUBLE\"\>", "8", "17", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"DOUBLE\"\>", 
     RowBox[{"-", "324"}], "306", "8", "0", "10", "1"},
    {"\<\"VARCHAR\"\>", "12", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "False", 
     "3", "False", "False", "False", "\<\"VARCHAR\"\>", "0", "0", "12", "0", 
     "0", "1"},
    {"\<\"VARCHAR_IGNORECASE\"\>", "12", 
     "2147483647", "\<\"'\"\>", "\<\"'\"\>", "\<\"LENGTH\"\>", "1", "True", 
     "3", "False", "False", "False", "\<\"VARCHAR_IGNORECASE\"\>", "0", "0", 
     "12", "0", "0", "4"},
    {"\<\"BOOLEAN\"\>", "16", "1", "Null", "Null", "Null", "1", "False", "3", 
     "False", "False", "False", "\<\"BOOLEAN\"\>", "0", "0", "16", "0", "0", 
     "1"},
    {"\<\"DATE\"\>", "91", "10", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"DATE\"\>", "0", "0", "9", 
     "1", "0", "1"},
    {"\<\"TIME\"\>", "92", "8", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"TIME\"\>", "0", "0", "9", 
     "2", "0", "1"},
    {"\<\"TIMESTAMP\"\>", "93", "29", "\<\"'\"\>", "\<\"'\"\>", "Null", "1", 
     "False", "3", "False", "False", "False", "\<\"TIMESTAMP\"\>", "0", "0", 
     "9", "3", "0", "1"},
    {"\<\"OTHER\"\>", "1111", "2147483647", "\<\"'\"\>", "\<\"'\"\>", "Null", 
     "1", "True", "0", "False", "False", "False", "\<\"OTHER\"\>", "0", "0", 
     "1111", "0", "0", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:3.5",
 CellLabel->"Out[5]//TableForm=",
 CellID->11258]
}, Open  ]],

Cell["This closes the connection.", "Text",
 CellTags->"b:3.5",
 CellID->335],

Cell[BoxData[
 RowBox[{"CloseSQLConnection", "[", "conn", "]"}]], "Input",
 CellTags->"b:3.5",
 CellLabel->"In[6]:=",
 CellID->8759],

Cell[TextData[{
 "More information on working with data types is provided in ",
 ButtonBox["Data Type Mapping",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DataTypeMapping"],
 "."
}], "Text",
 CellTags->"b:3.5",
 CellID->11192]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Data Types - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 55.3745818}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "This tutorial discusses how to retrieve information about data types. \
When you create a table, you will need to refer to these data types. If you \
find that the examples in this tutorial do not work as shown, you may need to \
install or restore the example database with the DatabaseExamples` package, \
as described in Using the Example Databases. Functions for retrieving \
information about data types.", "synonyms" -> {}, "title" -> "Data Types", 
    "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/SupportedDataTypes"}, "SearchTextTranslated" -> "",
   "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:27"->{
  Cell[1406, 46, 84, 2, 70, "Title",
   CellTags->{"xref:27", "c:39", "b:3.5"},
   CellID->13169]},
 "c:39"->{
  Cell[1406, 46, 84, 2, 70, "Title",
   CellTags->{"xref:27", "c:39", "b:3.5"},
   CellID->13169]},
 "b:3.5"->{
  Cell[1406, 46, 84, 2, 70, "Title",
   CellTags->{"xref:27", "c:39", "b:3.5"},
   CellID->13169],
  Cell[1493, 50, 201, 5, 70, "Text",
   CellTags->"b:3.5",
   CellID->23831],
  Cell[2733, 90, 109, 2, 70, "Caption",
   CellTags->"b:3.5",
   CellID->28685],
  Cell[2845, 94, 211, 10, 70, "Text",
   CellTags->"b:3.5",
   CellID->19090],
  Cell[3059, 106, 285, 9, 70, "Input",
   CellTags->"b:3.5",
   CellID->19497],
  Cell[3347, 117, 274, 9, 70, "Text",
   CellTags->"b:3.5",
   CellID->2589],
  Cell[3646, 130, 131, 4, 70, "Input",
   CellTags->"b:3.5",
   CellID->25990],
  Cell[3780, 136, 655, 13, 70, "Output",
   CellTags->"b:3.5",
   CellID->15145],
  Cell[4450, 152, 286, 9, 70, "Text",
   CellTags->"b:3.5",
   CellID->19353],
  Cell[4761, 165, 172, 6, 70, "Input",
   CellTags->"b:3.5",
   CellID->19314],
  Cell[4936, 173, 4546, 89, 70, "Output",
   CellTags->"b:3.5",
   CellID->18651],
  Cell[9497, 265, 337, 11, 70, "Text",
   CellTags->"b:3.5",
   CellID->26740],
  Cell[9859, 280, 260, 8, 70, "Input",
   CellTags->"b:3.5",
   CellID->22044],
  Cell[10122, 290, 5032, 96, 70, "Output",
   CellTags->"b:3.5",
   CellID->11258],
  Cell[15169, 389, 77, 2, 70, "Text",
   CellTags->"b:3.5",
   CellID->335],
  Cell[15249, 393, 132, 4, 70, "Input",
   CellTags->"b:3.5",
   CellID->8759],
  Cell[15384, 399, 248, 8, 70, "Text",
   CellTags->"b:3.5",
   CellID->11192]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:27", 17322, 450},
 {"c:39", 17433, 454},
 {"b:3.5", 17545, 458}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 781, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1406, 46, 84, 2, 70, "Title",
 CellTags->{"xref:27", "c:39", "b:3.5"},
 CellID->13169],
Cell[1493, 50, 201, 5, 70, "Text",
 CellTags->"b:3.5",
 CellID->23831],
Cell[1697, 57, 437, 13, 70, "Text",
 CellID->20040],
Cell[2137, 72, 593, 16, 70, "DefinitionBox",
 CellID->26488],
Cell[2733, 90, 109, 2, 70, "Caption",
 CellTags->"b:3.5",
 CellID->28685],
Cell[2845, 94, 211, 10, 70, "Text",
 CellTags->"b:3.5",
 CellID->19090],
Cell[3059, 106, 285, 9, 70, "Input",
 CellTags->"b:3.5",
 CellID->19497],
Cell[3347, 117, 274, 9, 70, "Text",
 CellTags->"b:3.5",
 CellID->2589],
Cell[CellGroupData[{
Cell[3646, 130, 131, 4, 70, "Input",
 CellTags->"b:3.5",
 CellID->25990],
Cell[3780, 136, 655, 13, 70, "Output",
 CellTags->"b:3.5",
 CellID->15145]
}, Open  ]],
Cell[4450, 152, 286, 9, 70, "Text",
 CellTags->"b:3.5",
 CellID->19353],
Cell[CellGroupData[{
Cell[4761, 165, 172, 6, 70, "Input",
 CellTags->"b:3.5",
 CellID->19314],
Cell[4936, 173, 4546, 89, 70, "Output",
 CellTags->"b:3.5",
 CellID->18651]
}, Open  ]],
Cell[9497, 265, 337, 11, 70, "Text",
 CellTags->"b:3.5",
 CellID->26740],
Cell[CellGroupData[{
Cell[9859, 280, 260, 8, 70, "Input",
 CellTags->"b:3.5",
 CellID->22044],
Cell[10122, 290, 5032, 96, 70, "Output",
 CellTags->"b:3.5",
 CellID->11258]
}, Open  ]],
Cell[15169, 389, 77, 2, 70, "Text",
 CellTags->"b:3.5",
 CellID->335],
Cell[15249, 393, 132, 4, 70, "Input",
 CellTags->"b:3.5",
 CellID->8759],
Cell[15384, 399, 248, 8, 70, "Text",
 CellTags->"b:3.5",
 CellID->11192]
}, Open  ]],
Cell[15647, 410, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

