(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    116009,       2376]
NotebookOptionsPosition[    105174,       1995]
NotebookOutlinePosition[    112246,       2228]
CellTagsIndexPosition[    111834,       2210]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["The Database Explorer", "Title",
 CellTags->{"xref:55", "c:60"},
 CellID->24970],

Cell[TextData[{
 "The Database Explorer is a graphical interface to ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 ". It provides a number of useful functions, such as managing connections \
and working with the data in a database. It can be launched by loading ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and executing the command ",
 Cell[BoxData[
  ButtonBox["DatabaseExplorer",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/DatabaseExplorer"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:5.0",
 CellID->23847],

Cell[TextData[{
 "If you find that the examples in this section do not work as shown, you may \
need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->16687],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{"DatabaseExplorer", "[", "]"}]}], "Input",
 CellTags->"b:5.0",
 CellLabel->"In[1]:=",
 CellID->32604],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIObject[
  JLink`Objects`JavaObject551504855433217, 
   JLink`Objects`JavaObject497998857502721]]], "Output",
 CellTags->"b:5.0",
 CellLabel->"Out[18]=",
 CellID->503]
}, Open  ]],

Cell["On Windows it appears as follows.", "Text",
 CellTags->"b:5.0",
 CellID->21221],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{488, 445},
 CellTags->"b:5.0",
 CellID->22663],

Cell[TextData[{
 "At this point you can connect to a database and make queries from its \
tables. When you have selected the data, it can be used to create a report as \
a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook. This will allow you to work with the results in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:5.0",
 CellID->5706],

Cell["\<\
This version of the Database Explorer can only select and read data from a \
database.\
\>", "Text",
 CellTags->"b:5.0",
 CellID->2363],

Cell[CellGroupData[{

Cell["The Connection Tool", "Section",
 CellTags->{"xref:68", "c:62", "b:5.1"},
 CellID->9010],

Cell[TextData[{
 "From the main ",
 StyleBox["Database Explorer", "DialogElementName"],
 " window, you can open the ",
 StyleBox["Connection Tool", "DialogElementName"],
 " by using the ",
 StyleBox["Connect to a data source", "DialogElementName"],
 " button. It can also be launched by executing the command ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 ", described in ",
 ButtonBox["Database Connections: Establishing a Connection",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#16139"],
 "."
}], "Text",
 CellTags->"b:5.1",
 CellID->22171],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{344, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.1",
 CellID->27489],

Cell[TextData[{
 "If you do not see the sample databases shown in the picture, ",
 "you may need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellID->228391340],

Cell[TextData[{
 "The ",
 StyleBox["Connection Tool", "DialogElementName"],
 " shows all of the database connections that appear in configuration files \
in ",
 StyleBox["DatabaseResources", "InlineCode"],
 " directories. The details of named connections and their configuration \
files are described in ",
 ButtonBox["Database Resources",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
 ". From the ",
 StyleBox["Connection Tool", "DialogElementName"],
 " you can select a connection and edit or delete it. You can also create a \
new connection, as described in ",
 ButtonBox["New Connection Wizard",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TheDatabaseExplorer#13584"],
 "."
}], "Text",
 CellTags->"b:5.1",
 CellID->18240],

Cell[TextData[{
 "You can use the ",
 StyleBox["Connect", "DialogElementName"],
 " button to open a connection to the database that was selected and update \
the main ",
 StyleBox["Database Explorer", "DialogElementName"],
 " window. You can now make queries from the database."
}], "Text",
 CellTags->"b:5.1",
 CellID->12164]
}, Open  ]],

Cell[CellGroupData[{

Cell["Querying the Database", "Section",
 CellTags->{"xref:71", "c:63", "b:5.2"},
 CellID->25542],

Cell[TextData[{
 "When you have connected to a database, as described ",
 ButtonBox["previously",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TheDatabaseExplorer#9010"],
 ", the ",
 StyleBox["Database Explorer", "DialogElementName"],
 " shows the actual database in the ",
 StyleBox["Connection", "DialogElementName"],
 " list and the tables in a scroll list. The following picture shows the \
result of connecting to the ",
 StyleBox["publisher",
  FontSlant->"Italic"],
 " database. This contains a number of tables. If you select one of the \
tables, its columns will be shown, and you can select any of them. A button \
for selecting all the columns is also provided."
}], "Text",
 CellTags->"b:5.2",
 CellID->7619],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{488.75, 443.688},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.2",
 CellID->20913],

Cell[TextData[{
 "Clicking the ",
 StyleBox["Result", "DialogElementName"],
 " tab selects the data from the table and selected columns. Here is an \
example."
}], "Text",
 CellTags->"b:5.2",
 CellID->7591],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXQuQHEd57puZ3TvdnSSbR0jFhCJxTAxF/MCQwpQNhhBjXGVTxavAECiV
wYEC7PAKgSDiUCI8dGfZKVOgWJJjx2BjI+OHJCywJEuWz0I63UmydHqc7izp
JJ318ulk2SdZj0v/f3fP9PT0zM7szuzO7vZW9UzP33+//v/r5z/bc92Mb33p
i1+b8a0v3zjjzR/6xox/+dKXb/zmm6++5RuUZLcQ0nKAuiffTMA/SYh7scnk
5CS56aYfoEPfKHqJFHTq9BkaRK/74dISEv7Ab/64Dy4tMpPjY6Kh+DACl5YA
c0Fl5oWi1N0YZCMBAoChVLR58xbsgotUCB5VxGzVxoQoQJ8ku54fGYILzUIQ
dQUwyTRGMm2Qgk0QtpAWetEHzuFXQeM/y41kKQycydKkhU+2JgBr8mDFNWnl
KchJizLrslXr65W7VZuGn6eoVlncQ2u4sOIadkTUsBhaG1ULsRWmo2FNHq5N
TRh7wSfwqKpa8IAFfjQdcDnRzUQnfD9MpJJj4ThmxU9FWoZQag2Fhr8WRbfe
apvX1dYPK8GPRX4knZ5KV2QUpS4UM16VTsZOmEJ0useMV1eccb5GCpNMfpIp
hiWDE8dhDI1OofwJZFhMWurdvC0kyTCbaHoBff2WL3ST8bE9oh3TZ3hENwnX
69CbMMkurjCIKvf0kDoW9HreUQCDRqBlJXwxr8LQqm6y9xdXkP2z304uwKtN
Dv3iIrK75zbkeCmDvC/ieUMeL959KTm1/HLyFjK55gpKO7n03UiDsCzynsLz
XrNxPbnn8T+SO+5fRP4Krzb5zdIVZOiej5GTT7ybXEgmn8XyUD/QINaxDMoj
xp0NAxvIktXryZHxl8hf84Xb3gOHyR13zSOnT58lb8Wrjc8i/niG5QFZjBw4
RM6ePeOW5+zZszUrD2jolePHMInzeHlwqJyc5L0Vo4nygXN4GeEnaJaGxlcW
1Ov52PyqgOGCV9wtNvWqvgBEZd+oEYATKoCCr7KiIkwQrdowcbcVYbnxmHQc
NUJbDWWC9bd5uYAgCcfSk/lsNChLOzX5+oFW5LFkmitmLxn5XguRvnryLDob
r6xcggaOVY9xyGEWB43gYTQ/H2tVwbgOpwXFqxdXwY9FJsIpkWjOQqTtEO+H
5D/mL40h15ePn0Fn4ZXV36MxiIJf0LFeflYmPl30IJ/Daa/QqxBrwS+7Mtp/
tcDazgUHohVt8Ae8DQJNCFusJkHYIs+iJPTx8TPoLLyyugiardBY/YI0RwoR
dB1fgdNSGIQs3mGEqAdLlOYQlJa4Dx48ic7CK6uioNkKjdU4jOb4aCgSeCj4
khTBDk+mHMmfq0F5HpF88OAJdBZehchO8Cc/TYgxyMcFecIV5ImSkUSGAeFi
Eq+rE/Ht238cnY1XVntBAwe/8ziHXNMLc1iX558fR+fAFUX/RnzOf8kHdx4h
g0NHSCdcC/D4GnzOf8m3bD2A7ny85r+8vev3oDsfr/kvb8+aIXTn4zX/5V2+
fBu6N8PVIstXbKMBQMhiiVxJoXG3ahJIH4RLoVZF4Muq+fPvQYe+q9CrY65d
AQUNfe/jAVBMEcHJQQExDbi+F70sWBSy1ioWBbyWx7311lvd9D6koV0TSnOQ
tnnDGnL4yHEyu2tuJ5m/4CFag5/NnktG9h/BbKSqN2LN7/z5vWRoeHcn2b5j
L60B9SIppzXH/RRu8Qvuouh3Wwh/M0bxFTTM52sEdklYRkp6TkSB5PQuhmvB
rUJo+WxN3MuU0IIvN3BumJeDomxK6STrendwpeVK2QV/D8Tro0rWq7/jq78k
tCBrNC0MPeGAiBC9Ni89vxOavq5srdo0SuftFxPN650RRSrGbliNjS39Bm1S
YLE86O9vaoCkS8tKPxMEhTe4xkBQ0Sc0yd9aAXDy0iO9Q4OB6kOIlawtwK/A
p4Dwscn7rrwSfeCceoSU4xPiJDc0FVxf/DGh6OORwi+oAZguq6BBpISkgkZy
CooYZBBFhXoET+mORJ3/Rss8EYQuCk0mDloLPlqOoKSTbGsMKNmkd/1gAaDk
gK++oZTKxNsfXXRoOihd7IbGB5A6ywhBz8VlJJgimgpKzfRcIXMki2zctIuN
cQ540cedjYS6BpluLZ27hfwlmrjJF/Lq/FBTKlpDtUuBzRqbKZt60WfxHZzc
qT3bvStsDCMjh/iMD3zsCa7tPhq45pNOJzl8eLwpcdFJjh+faNKanzp9Ov81
xzHy7Vh429e9TeXdnqbsDWl+gHoODAx2IrkI3jyrrfKaF92aDwxuJ3NuX0AW
L15OFi1aXqCXZaSDPE6v4HPvjy8jXd3zkL1xAdHhiuXwiy+Rw2PHyYvUjR19
mRwdf4W89NIEOf7ySTIxcZKcOHGKluvkyVNkCnn11TPk1KmzroP4eZVRDew3
7/fHVUIvDStGounc5Upo1PqxEZVcF3abqyJUo5vfZ7h7/p6IpMPtLwY5VbHK
GJzUGU5qansxaKkztNTIrGJwUmc4qakFJSlaLg7NNrV3RqJQE76H29yoqbKx
JClqLnFTqyJWvJ7WICQjS0d1l7yhFoyGVK3Z8zEyMjIyMsqnjCSLSnvcitZj
PQ0WjIyMjLKSkX762hY2z4vxZ5bQV7tCY8R9C+dtkakkfx8nyoDDRD49ENbM
CAi3yFT+Zh04cTyUrK2LKko//qvKb02pHtG0lF6MN7AMyqT87dMwaOvg+I5E
6o4Pv7+rGFopwS2wAyX9ubARxz9HhRkKQLf7UtDIxyAsOcKi9iybt2OLsyub
zMYZfy/5Ihf38UfzhCNrwtSrNp6qth4v6Ubs7KKgV7JjY0zldRhJOkD1H0Ve
3HT/UfTWivLJBKFxrAYGoQpCU3vBLAy4OpCqRlivL0nxX0tvSymTFBHqWfTU
/zQ1Ihr1k8O4B73G2J8I3SvxMqpkryQ0leR7JTrLX/MsRs1OopGRkZGRUT5l
ZCyBBgtGRkZG9WAJvCgybnX/jx+1k2X7y9nkGq+F5a+yJXb8/ckanw2S7Ay+
5oZhNS19TXA2VnirbkSY5c7Sd2nSbOoKXM2zOZQ/g15WNmRla7J2h9QykU9T
k2msxW9dWOvKhZp8D5+VpWmdq9gS12pApwVdTQxwlb0XGNMAV+PjuZMcG9g8
M7ZqmN9CYyTaoIhrftNN3kKNbuqBgY2oeLNdZ2RkZGRklE8ZGXObwYKRkZFR
PZjboo+HqOT7VOYcxLj6q4Xx7KoInYSuV7Jd6ZqjqPJt8EoKGXNqWTMarZKi
JJvvSRmA5Nf4lBQhGdgqDTzqyoaUc8SYEw/zaABKCpoqvObV7Ech1sReE73C
reRFUXPsodm9MTIyMjIyypOMjPXFYMHIyMgoH9YXL1T3eRlz7GEjIKAy+01g
cfy3GuWYUw59Yc3+34H0TEF6/rdooNHw584FdrAb/N+dVTMdxf18VsMjzJxs
qOvM0rdFlWdlMKccapJuxI6vLmxe5pRDbdENQvNkYzOnHJpTDmX5pGi2M6cc
5g8IZuPQyMjIyMgonzIyhj+DBSMjI6N6MPyF/p2mzHmuOe+w4Ux+WZ8vZ441
rBu0ZW3aM0cZNhi0cmfaawKENc82UL7NeFUZN1Mw5FUMOHPGoa/qIbCpha0u
bnNIaqszZx7WDQhrZ46TjFEpGuHMSYc5nNBlbILLZJMirjFON8ELNcGZMw/B
mc07IyMjIyMjY3wzWDAyMjKqPxlVx/gWfSLEpWG5JZqvmtMP42qyCqa0qyJU
YE6uyz1CsjZ/GXjkEB65M2EZlOQQJfk2RRnI1BlkcmNRSooc1TIUtxWkhCBz
AmIezUFJQYT782Wbj8qEjjn3sFT/UKb1prqrXHMCotnLMTIyMjIyqr2MjC3G
YMHIyMgoi1UOZuiUnpF6Pt2Oa/TcNJ3zDI0FRqc/3QZq+Ok/6a1P09hRrdHh
hGbrLBpS7RoZxN37iktLAz5VOgbOwCWGCcfbZfK2QkJ9aXxEyCg/F31FiXfO
s+nb0+pAqnqEn0FSMiR5cqkDEGlHvJrByVhv9KIs19BXbUjV6IA8Y9VRgOQt
i6uxQPYGoooXyMZ4YzZ/jIyMjIyMai8jY7wxWDAyMjJKeW5a8M9NQ/+yrcwb
dXyhH7LSrWpjpFfrT1o5Clcj4kG/6A1f+Ee9g1z+dzF0K53KjpBvgC9bRYm6
Kc9V0fURjYrKnH+ayKAwiABpV6t+T2Q0uKs97iLmaFY8AeUbY/n/4pWZ9IVI
yJNL+QfY6SB3qUZ5MdEm3+v4O1ZRjahxt9yTLj80LwiUo0s3cipYDH1rIRfW
OHN6Xn52Qy5y88j7t6uaYRg0+4VGRkZGRkb5lJGx9xksGBnlafZ2ceQcK9Fh
x7r1qLFglYWC/FqwLoqdZmX7aTU+gr3p92vza616R6iGDeKaA3HVs0xlhbUM
zz4zGMuxFQpHz4RWojpBlaOGeX8LaPIpWrXsTeqHmdhTZfnoYPYOjb6zRVic
/yaxRA3aqmdTquy1oZgGpuqDzdiPFKhVYwci1PITdwfiYrek5nNLyXVuduaM
jIyMjIzyKSNjNTJYMDIyMqqveW0mHxTN9L9htiuVxl3d5NeyVpVPuefwvXSF
1riLrPya1LKG3mWJYJUJ1PSbTgZqjfMvrxyAjBWrLcAvAHbk6DEyu+t/CmT+
gt/SqPMXPIQ+8fRb2qzn3/1b0j3nrpzhqdZ2s6qMjQntcpkgqKDJXqDnzp/f
S4aGd5NOsmHj8zQ2+IGmwCTvvY6u6p4EszWJpZFP+Nwqzf9jVWwfa9X0RTKS
4JkOahY5fHjcIi+88CKZSvaMHCKDO/eh27xlN+nrHyK96wfJ+r6dyK9BW+4H
OR0NXIY2scqTzuH7SUnMYgUd0ogfanso1Ab3o8s/1Bpi7yDUxpamdSxa9QfG
qOpHRg76Vb8hz6pPe2uthIBYN3zQ7Ya3UAH19+80AjICMgIyAlLMYU7YdK7u
K2lQkAsB7TnoWxD053qWZgSUs2lsdb/KWnrTp+EUml9r1lUR/HXxNfgmxQqT
oMGKwUre7EcGJXlDSa2tQgYReUNE/ixASTGiWnKSlatirERN3SKwcgD31EcU
rPTlejmbR/NNUrRc4vZ1VcSI+rmphkNGYy9Tw78/1XCKrOqGjBGQEZARULYC
winpyIgsoF11JaAYtpP6r6RBgRGQEVCmAvIme7r/MChH1EW/qmOHLUZ0Z3Yn
SFdJrZYfmWpwMMR5C0/3Yq/KU/K/WSFhF8QED0m+7dYwH5eK+yJsPaJRv5Oi
23ZU155po847C55HFRHVXrIc3NXFZ3ziv3A9JnZ3B/ehQ5zl+lXICJw5OsRl
gq5gn9a0nyprUqzRa4iqvTecY1p53K4pdBKmswdk9sVGJ1nqGcIuMOt05EpF
Wa0aDGtxZnVTInnK7e3SQp58r/tvSelfVGkwPCZfXehkTKJfyfBe3EgKTM/o
lfppf3X+OakGR6Ky6eENCd64lZ+tDqVMlWx1VP6/p7pXfVVeph7x/Scw76tu
IyAjoLoRUJHcRklT6kogkq2uEKgVrRMvSXtcTeelXkbRqQukqBUIisNAJBwi
9TP/qIa9LZ0PmeoOLA+mloaVzfaXN24jKKn0vOg8j2a1ys68j78dWP1j75Od
z1f33Ut+bGZVOdsqmU0uEzCF7r03QMdVa8tYhtb+i/VJ1/icNFbS4MZ7xApR
suz7Voj12ktV0wpWrW/u5QBZTORlvC7SEKCqnbmrXIjJ9xxCLIWj+er+0Kzc
WbAq+4htTFvWpW7x6vKUvrpHXXbWqnS+mZ3uRoE5my97C4MRkBGQEZARUISA
zNl8aZlyjYCMgJpXQNWwd0Ufe1DJB1XTPpOvjhWZRyPWVRH8oaecaFc0VTnv
pLLzk+oKO/mxSiXFiDlbq9FtTEkRkY0J24ChZEdRTcNQUlBk8JEug4iSiKid
VSfn+CjzuL16xEfOTTJJgVKFr5mmdgZf/cMlO1tK9CK0km8eV3ziXv2rzXwC
wRwoZwRkBJRzi0j9V9KgwAgo3wKqw2OtKjsGWheq29/QHQidzgs+1TxxT/0v
UMOBIc0vHcXf/IoLmMpeKGyAo/dS+N9QI+OSSbX6uMzqvf3cHI8W9y9GTYw7
b0+uXAQWDNrS/w9S3SCt8q88VYYqHFsl01VDn7uX0n+R6gZcaXwwKonlyh8/
9BQA7bjSlMfuJfuvUmNDsMR3qEqZxBzXF+egUZZ4cjy4hTLn6+X/kLUab3Eo
1rsytzhCU6nJv5jMMWBx1zp184fltAXk+AQ0MDDYieQieLM6V+KxRSvQ/QCv
ta/5mTOvktvvuLtAfv97KM6iRcvQB87BaxGCkbUJpHH4yHEyu2tuJ5m/4CFa
g5/NnktG9h/Ja80lk5rtwnhoeDfpJNt37KXlAH+T4Jh3cZ1kXe8OXoOMa86H
O/CyNy1FADj+bPHZkERikzIaW6ZRZ7ucukhFLmY5n481peg94XnS8OTlp1kx
aaFxLTYZMbLPTvaF6BZk69JProHaTbCr8WJb6c2uRkKMI6Ug6CofuELFqMm3
sfGqiHRz+KpsuIEwAE4LwWmT9115JfrYE1zbfTRwVQOw4wNhAryWO+K0+pAr
ox1+H8kAyUwZ+Udyjv89AqtnBK4NXvRZSKxiV+tHqjujLMjgdVkcKaKEt+jp
qK5LV2ngrs8IpNWzZdYtNDWd6sZNu1if6oAXfdzZSKjJbCBspLYUKPP4HRpW
x4Wp7UI3WfdYa9tmWUN5CtbKrLBmwwZEAZDl8K2ImiLLv7oQfhIcmsFNSQTQ
7Ps7neg9DaZr9CxvSpmm8TIRIsNn4gFEOmRk5BD2fgXwVWeLKNnmWE4MkEkx
UONTIdR/4AU0X8BvhLCBD3zgHOm7IbnCQK73KeIa+EjYPkX4H/A0+xPHj0/k
UUNV2Ms7dfp0M9Tc9tV8Gm/jWZkc81Fnv7YzNjn+EFMruNUUzhNp2tXzTvAf
GNxO5ty+gCxevJwsWrS8gJbFDvI4vYLPvT++jHR1z0P2tLTexUfT+NWGENvl
AfchDe2aMNpreEFT0l3p8gdGiWswTw/ATHNBmo5PpYE7p9o1Cs59gPdqHiYQ
IYoMYf8YERYV72qOADnsXFPdGlT3fKDg0uwvm6vidarn6RDP5gsQSAJ+vM6W
nmyzGSMrtkR3+SyXy1b4bR//J8sUdUdE3mLGrYQVpEDx47NXf7ncgDdE6MVx
k1SqqlRQrTRb2gRpjr7QXrqY17kRJVKr4eVe8OXkzzGtkr22lKy0JdOnWowh
R/akK22IInSFODf7xjWtVCMJ1NOP0jAM6eoehwbuU5k1On2YiipwU2KW9XUJ
cRVVjpIdVgx8Ic0qJ7WoFpK07eq6OI2gKyvw60uKPh0oxBW9Tkg1atVTQ1uu
f6jUgNqTQqtWQuLepsni01LDlem1brg6LZQ3IMRsgCGjO0ujTW0W6l3XTKLA
nkbrTKGIJacjFXRtkRoohKWiw0eOWmTcMdKRQgRdN+Y6rhywrX9WaY2CtZla
o34KUwqLJeHvLRoUtURNB5I202qX/c9K6iAwoOuaaaKmm6BLaJDGrHa+/Ffu
HBqcPF+Wf5k2dAzSLU2r2bwdXYZhotOJuNWtSsmla1FKWCRRSC//kiIKHeVY
XtGztdCZd4xGpqvLa/LbyNynkn2r7UaX+P0Jyfs/4geUZhpDnRj4SoT3DBee
WZe19JozWsaejmONpXFGhbBmGzVVqPHG0neVViXCat2qdKJNf4NHp6YYiLW8
EoZgJ0BOc9EYu2WVUc7SK0ddOUNSj4JHw7QuzybyWk3hviC1L7lwpdoXtgnV
DuHV00/zJiXlGyh003lvVMbE4+7IRW3Ye6mVZ6Dwz9azKVm8+Z8ioTKXXtE7
KTo9K8zTskd4kxk5TXVNdZuouoE3iT7EOzqlxFfrySHcjFzjqvlf8vowf2fN
/4ZUkHZNDBq4KrwhBb+w6kzC9b3oteX8SVoFED9dAVAucH2fBsJOCgWQf24B
8D3Df9Cows6gyli96zNQZuoJC9A3ZsIFbcK3QXybgYL6PoLJJUwDc9/NASTF
IplEEzPCxx/5P9L9k+8hDyY1WHZSA/09NLmHyNih0XKTqrAyo6OjrCKnJt0J
PTzDT/QVcH+dpv/4GKcdO3bM36d8KhXZsje/O9APWch3CJk6dWrg3gk+RLI8
LxcxMHQKPOKaj+agphty9yKeI9UZMoS7kM15553nyQyuH0gFGFO4WiA7+Ml3
VsuirzhCHjT9diYO4m2XyLq1XJZ2vlaRtdvJRaTLVr3TbDuYiC677DIlnam8
+KJoInd4FmpQRX7hhRe60pTovgErvlCn83KInPt6j5LtW0+R1U8fcPt1WXhy
SRkIvX9B7d8/SRYt6sX7A/ev5HVzGT283XTTTbxLddDf29srwtp5eeTaiWgr
VqzQAlGEd/C+FuQMz5AsdTaZO3cuCuUmN4gtLNvc6qxadYz090/6qiuwTdPV
6RV0sOm5j+F9zpw5bmnKVISu05HRDclv3fIqKmjH1tPuJpQG2Vze3vcxhVL4
3VbUwXDGZCeraBL+EgVCLLgkSVO8dNNcFSigxzuoDOKIuwSjDp6vUAkoCVgg
G/ADXVIZ09gUjH3HHavIggX9eAetgfbk5tPB1aYDNTSfZ3quJsuvn+FvRpWp
Te6cp/A+QmT/9KpRMrD5JFm/bowMbj8T6Ji5UIRAdM1JbVb011m+xsTzjBkz
fA0IfrK2RIPj4WVpjNVHaEu+y23ObfkdWrA/+8xBreIqVFpwJCm62T/bc4Ss
fGo/2fzcCdK79kXdllcH70SE+H7966d0SpumNLeI3k8oSBTi5ptv9vW8ogmp
vWB5TaqD97W6/lQoSm5uopkBX7vSxFSMi97x0fd/HDVXQRObroj5sce2k2dW
HyYrlu8lmza+Qtb96UWyY/uZ6UqJenv3hWlE6Sj8qmnFqx274Vx55c3kkktm
aO/lNZwOCQVyxyp3tKLv0OhGdD8hSA5TD2rnvSmOW15TfmLpbvLoo9vI008f
JMuXjZANG14ha9ccJoPbTrsV61TUN3v2faEqDFMfyFT8B1enPl2zUkcuzUhW
pvrgB/2baEZiKSBKJatQ6gfV0UMHd01fWKH6guOXp4p771tPFi/ZRX73yFay
cuUL5I9/2E36+47LIuLq8xopqEmjQvFavzwJnqJphDabuMHPcVUbIiBojKBR
3b2/v1/wTS2/EULjkjtEdbquwcwU3reWagKho9qVKY5q7W4xfvPgZnLPvb1k
0eJh8vDDA3SEH5VLPVWZ0d9669yAJnUq1E3wbd4c4Sc3xmDD9LoqUFfYcnPV
qlX+YoZM9B3fRN/V5BStJkX3KQo0VVkOhUFfnvz7hrfkahPrPJHlL+Y+TR54
8Dly9/+uJY89vtPtRhQYyw1NVhMTt8veWaFm5EYG2hFakNu+1Mgwuw7NSneK
VGwxZddNCn3FnhYLt6CDpd3XBcayK1Icy7wWFLUAXbJkyVRF3myax4YkQfN2
EFS9TMpfn1Zmm21KW4EuDrQhpC9pQW4rIiNQCW8nNHl6dTTL4k6uKyFaMUWX
teTv8b05URRuQS3bf7eQ7H/yD77xqnwVBcer9kA3rN6pemj/+zSqCEcqbHoY
r0MDd3lyLcNd0rgH9+nSclzGODxPU8BcAkKutNIBszwcXBdTUrw0uOmJ0Hm9
BFcx/ZwmASCG2N2+cvbs2RUA4L94DFEK3POAa/KN1epukWcVTW+bmD//Hux8
hjGUWWgFX9yMaZxdGNFRo5Ys8p5Du+GStKb5j/YJHgN7ZuoDh0n9tJZJFTVJ
2QqNjSvUh6RzkVbwxQhy2RFc0zV5WtpyiCSVwuATVvgnKVa44MvDyyvIPw2v
rdrK+eM5Pp6Q5KbGkIdOpqWKiRL6UeYSem0YXBRaQZGa7j4tpigKoeLJWASO
WmyUiYroMBGw2G2h1ef3uFIQJ9Qq0dMWBFN7May0cSAdJpDQribYclAoRSmW
CLdq3SzCesrpMboJjzuk2rqOsTMGPtynanSganME9xpFLXLt3xSzArp0sdiz
K0FyoMG8Loai3lj9Iuu6gQ+kl3xdzJpKRvNmmPANr1/+8v5J8p3v/PcIXFrg
sQXogtn2MU+SJ5et3weXCCaH7B0ZmU5u+OhHJ8G3CS4h7EfHj7srdsqPmwHg
LDI8PGyh1yajy2a5AbhfYJGxsbEP8mjPrtroLv7x+mkeQHMl8+5bSr7y7Tk0
PXq1yFf/9fYCPhcxBDhEVM5tl2Q8fPAgY/z15R+0yP3v+WABfDQ/YIRAlju9
tkD1RJ073Trv2b2HwKmMp06dRrWcPnUG697V1QW1xmpKte+5kUhigatDqz8K
IkBHk7LIaZqeQ69n0HfqFNzPXEGTBtv1tHPOQSnB00fg2g2RZmLmtiuiH/30
Ebq4h2sRn4EOHOA4T7sazGsAfiqDdvLgFZ+gfQKIg8U+jcWBCgIbVDwI3V27
dpNXKGrY9+TAV/BBAd1AH697gfT9OyFjd57D6MM9ZKzrHFoLkITtpvOKmxbQ
TmDtwVlwdYDFAZ/NvjJKfZZLI0j0x7C9UMcXKsIQhQXwFZQ0WK0msCTwLHRh
u7nygAledNtNVAmw3Ix0oe+EazdUeSYPFTqdt2A51Stci/gMdBGL87RjcJsU
fAKDQZGg0lUf/Qzp+fgNRdLzic/StKgXSRAELIJd3EGjwaY+PLSb1mEcGzw0
+6PHjgvYC9WOLp5FBm4gZGAWHWr7COm7Ecbi4a8QmunY4i4X8uDGafRxTOZl
vMOzg+KF5F9G4cCdOka2ZRJNltIsNRR84CxOkxNifK0+PnAyj62Jh5kUeGQg
qJHEM8ug4IYJqHgJFwLxGJToUxTD0/A0E4XOYPHY4g3k/gdWUanCtYjPQEe1
UMd5WtkWKfAUAjygeAthYJN1H/80Wf/pz6Fz+BVoEAoOe0qW/TjXPKAhiJGd
g7toogcPHaW0g4ePkgOHxhAjbJe4k7b3PtJzLSETFBxjC6lbTEFC4dFDQdND
78Nd15LRX1H6aB+NP8aScuh1DH1cIIzMVAI+WdhyGDxL0XhYmy9MDvcl7+jJ
ti+2zBoooO2SPVZ/dEfhY9AFX3upQupkoa9vQZuUrjjvgms3KG4mipyBbcnS
jWThwz2EvwwJXpv8ll4hgI3NfmYAQ5Hc/LU5NOsLLvh7jKHyQ9aAQMAaII0f
JL3hhs9bPP76T37GxSVwcgxgZi0AtCD6tm4bpiLdObyfnMtGoJ6F1HVRtP05
GVtGUdfDUDcKjqJsoIuhb5TSJweIOyrvHNqPqVj0uo+mD36vsQLNDw5KwWFG
EjUweWqApzbB6g4+AU3GTlmkLgoowtyByVYC4KmA16I2ITf7YjjOWBrhFdQU
g0tL0Cfh6f28moCEFSsHyBNL+0CBDgKmiIABknDAgjM6fyxQOY3gIA/b1JVj
+mJ5SNt4w+c4XNrIwOdv9Kad1G3+pxkYzvEm6x58gK3g3GfLwBDZsm0XGdgG
YyP4ioi8np4e2tcN4FxnlPVzFkLOJgN3UtB9k+DdAkjCvGCCDi0QewtNB91W
SHOXhLoBSvEkDE9isBTPPAxZ1TGRaSksDduXBiZQ4MORCBDOzZKViMEFfEop
LClYiyYvdymmJVVWDM+2pojI9y547AYxzUSZsQ5oXe8wWbN2O0dSAf1r/rQd
7xDGOiDgd1x+DiYbmaYiuwCUGhUUDYoBRG39/OfJ4Be+QK5+019wSLSjf9c/
fxHpEA58A0KxW/l9YEggqc1F0qbNQ6R/006yAd0Q3imS2MDZgTMqGCwBQ9h1
zeJdFwXXBKVPLCPYdQGUHIxsY3IegIDmCZxls9Pic2IgcxL4+eTWZbBdBk8X
/kiatPjdlvovIMu9H5bUYTlCWFGNLDhZIv5gkYimlOAsL4d4rLbLCvfL4NpN
ZTg0k4sT1P/cc3tI/4YhOvGCaxs+A12kJHjc7gnYprpogidwcjTQEqAEELP7
y18ku776ZUSR+HIKIorSwEE48AE/gARV1AJJtACAgkvVDZsGybr128ja9RTC
fXDfhv3TvHnz+PprAEZBOke/E7YVBmh3BcvVZR+gaPoV9EwLYeoOAJvsu5as
7duOqa2jqYkUPYABlckVfO6TBV7H9Sk026XZ/lD0FaREIRP2BNeiLyNw/NnL
KRBPZCKVknUmviIooe8CXzet6vaZWHfWawwM7CXbtu2jbr8FHrjsp4XiNH7f
h3w4DvmjcniwTqMDoaHEYDKm8gVV7735a2Tvt24ho1+/hXc0re4z3CEc+IAf
dIQ1agHlB+dI/f07aEGeWbOZz5HEcmxgHpsPARCws/kVzMYpFGA5R4erMRo+
QedH0MFAWs88uxlTsdBn0+sWaaTx2thqSgfXildPJWG0Nyg0dy7RqWH+MFy7
yeo1m2dS32beSLdsBkP3QXzT4SAMrPQZ6MABTvB489R2VAFwgxP8UD2aNJt9
fveb5MD3/018ZgkapTx5GPvP70EwsgH76jVbqBRo5BYQTAtIPTh56O3bQVat
3kRWrgaRraQ+toc2axZslw0T3CWj5YeFEU5dFzM1DItp6zyCGxUTNE2WjudW
reZdcTsmz8QGPnCtGtob4Iq99FRN6Ifh2g0pz8SsmKCPHHqJHHhhnMoDrq34
DPRVWIBNPp5WELEVYGTJg8jGb/02OTrr++7bPCDi8cfuwrvFxf5y1yzkAV6I
I2rKirkJJRqU89rebWT5U/1kGXUW9fVxOQvoMzmfw8bSnjY2xtJmMNoFC9EB
2iQuJ2MDi8kkhz6kBanI92VP9c2Bh27wzeSZQBU3bRwhx8YnaOHhWsRnoLOI
fYKnHYNb3eBlPBhqefxnM8nLt/+IlpPKwibHnliAPguJNgYDm6hefwvEbIFq
C1lMcWXxp7XbyJIn1pClT64jf0DX6+5dMjkUySidtYq5BDiQxcRoH5un2igS
0QtYNCH4/8Qf/tjrJgkU8N8Gvm7IYSbSHTKr616sXO+6Idh6FK/1wy4kkCCI
slhR3B0qN9YAsrzjlw+iGCbv7iZnV9xHXt35e1q8Vw8sscjJA0toEwcCBAAD
MEIEiCzKDmKh4glusves2Uqe+H2/TX738LN8fi9vZE1M4F2IZ4KuJoV4bE4D
P0QGh7670Wu7dQTXhldGE8xWGXxQN3BtfFs7wNcCtWmBagXr+tRK2uU+u5ku
8B9azfdxFy5ciHWEqjCAUJ8FrcFibyZR1o1waYGYLZAET1d8FvWB+1eQ/fuP
kE2bdpEnn+wnjz6ymsC/c1YMYVABCRAADMAI1Bb2ppfYDvjxj++ia7A9uB+9
d+QFsmHDLrJ27Y5JiDeIkYvwjHQIBz7gp/F4SjZP6ed3PuSmdGz8JXL40Itk
955Dk0DcjiFFeEY6hIuUaDxWGMI/mQZ1tMlPfjwfk4QyY6V2oNdBIgQCG3X8
H5NFJjNKeB4u/D+yOIoc5O+2tfw/49vPhQ==\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{489.5, 444.5},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.2",
 CellID->6704],

Cell[TextData[{
 "The ",
 StyleBox["Query", "DialogElementName"],
 " page also has an ",
 StyleBox["Advanced Options", "DialogElementName"],
 " button. When you click this button, more options for forming the query are \
provided. For example, you can put various conditions on columns. Here is an \
example where data in the ",
 "TITLE_ID",
 " column must be greater than 5000."
}], "Text",
 CellTags->"b:5.2",
 CellID->31818],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{504, 442.938},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.2",
 CellID->9232],

Cell[TextData[{
 "Clicking the ",
 StyleBox["Result", "DialogElementName"],
 " tab will run the query and display the results."
}], "Text",
 CellTags->"b:5.2",
 CellID->750]
}, Open  ]],

Cell[CellGroupData[{

Cell["Saving Queries", "Section",
 CellTags->{"xref:71", "c:63", "b:5.3"},
 CellID->25205],

Cell[TextData[{
 "When you have set up a query, it can be saved with the ",
 StyleBox["Save the Query", "DialogElementName"],
 " button. When you click this button a ",
 StyleBox["Save File", "DialogElementName"],
 " dialog box appears that includes a number of locations in ",
 StyleBox["DatabaseResources", "InlineCode"],
 " directories. (",
 StyleBox["DatabaseResources", "InlineCode"],
 " directories are described in ",
 ButtonBox["Database Resources",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
 ".) When you launch the ",
 StyleBox["Database Explorer", "DialogElementName"],
 ", all the queries that have been saved are made available and can be run."
}], "Text",
 CellTags->"b:5.3",
 CellID->4975]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Exporting to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Section",
 CellTags->{"xref:71", "c:63", "b:5.4"},
 CellID->1539],

Cell[TextData[{
 "When you have set up a query, the data can be extracted into a report in a \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook document. This can be used for printing or for further work in ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"]
}], "Text",
 CellTags->"b:5.4",
 CellID->303],

Cell[TextData[{
 "To generate a report, click the ",
 StyleBox["Create a notebook", "DialogElementName"],
 " button. Here is a sample notebook."
}], "Text",
 CellTags->"b:5.4",
 CellID->11422],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 ImageSize->{503, 533},
 ImageMargins->0,
 CellID->94557465],

Cell[TextData[{
 "When the data is in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you can process it further with all the tools that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides."
}], "Text",
 CellTags->"b:5.4",
 CellID->11247]
}, Open  ]],

Cell[CellGroupData[{

Cell["New Connection Wizard", "Section",
 CellTags->{"xref:70", "c:64", "b:5.5"},
 CellID->13584],

Cell[TextData[{
 "The ",
 StyleBox["New Connection Wizard", "DialogElementName"],
 " is available from the ",
 StyleBox["Connection Tool", "DialogElementName"],
 ", which can be launched either from the ",
 StyleBox["Database Explorer", "DialogElementName"],
 " (described ",
 ButtonBox["previously",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/TheDatabaseExplorer#9010"],
 ") or by executing the command ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"OpenSQLConnection", "[", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " (described in",
 ButtonBox[" Database Connections: Establishing a Connection",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseConnections#16139"],
 "). It will create a new named connection that will be available for future \
uses. The information about the connection will be written in a configuration \
file as described in ",
 ButtonBox["Database Resources",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources"],
 "."
}], "Text",
 CellTags->"b:5.5",
 CellID->13648],

Cell["\<\
The wizard takes you through the following steps for creating a new \
connection. \
\>", "Text",
 CellTags->"b:5.5",
 CellID->2971],

Cell["Overview.", "ItemizedText",
 CellMargins->{{44, 27}, {0, 8}},
 CellTags->"b:5.5",
 CellID->17864],

Cell["Specify name and description.", "ItemizedText",
 CellMargins->{{44, 27}, {0, 8}},
 CellTags->"b:5.5",
 CellID->22913],

Cell["Select type of database.", "ItemizedText",
 CellMargins->{{44, 27}, {0, 8}},
 CellTags->"b:5.5",
 CellID->11075],

Cell["Specify URL.", "ItemizedText",
 CellMargins->{{44, 27}, {0, 8}},
 CellTags->"b:5.5",
 CellID->21545],

Cell["Specify username and password.", "ItemizedText",
 CellMargins->{{44, 27}, {0, 8}},
 CellTags->"b:5.5",
 CellID->28712],

Cell["Choose save location.", "ItemizedText",
 CellMargins->{{44, 27}, {0, 8}},
 CellTags->"b:5.5",
 CellID->17546],

Cell[CellGroupData[{

Cell["Review.", "ItemizedText",
 CellMargins->{{44, 27}, {0, 8}},
 CellTags->"b:5.5",
 CellID->18678],

Cell[TextData[{
 "A view of the third step is shown in the following picture. In this step, \
the type of the database is selected from a list. There is also a button for \
entering a new type of database. The list includes types that have been \
installed in the system as described in ",
 ButtonBox["Database Resources: JDBC Configuration",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/DatabaseResources#15185"],
 "."
}], "Text",
 CellTags->"b:5.5",
 CellID->1769],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXXuUFUeZr+nHvQMMwyQmQTQPsquuR+Nm/WtPfJw9G0OCnJPjGiURXGVz
UFZ8JMbE1WyMq3tAdwPRqLDGI+iSE9QYs250hryYAJFHNoEhPGeAGWYmzPAa
EoZhBojCztb3VVV3V/dXfavv7Rkm2XvPqeqqr3711feoqq6u27fujbfe9bnP
funWu+bPvXXqDV+59cufmz/3zqnX3/4VTnJrGHM+xVjN6qkM0sOMqWiYzZv3
TYzmQMRJLl7/dPYchmGIMfokRDUJ0K8eeYaFTGZBVAPEGhoO12HW1XkAo1kQ
1Yg6Vfj/K3gjgJjPurt62MHew+xY36usv3+ADQwMsj9jJ08OXsHOnD7jQIqj
Tp4cYoODQ2xo6BQb5OnensPMS+FwJdS7rBQHlHacvbQe29/eyXpe7mL3/Pgx
9vZbFk5j7AN3cfLkG7/JvrDoF2zgxKs8nPRo9LU0enWKHpeC9FNK6TEhiwp7
2/aweQtXsBl3/Ij9rvkP09jGDa2cvHbjBjb9tgfY5+97mB0/fsKLof/ixoXs
xnvXfYjN/9dXOWPISiRbTWt7Da1tBlld1rZrN9Zfs+kFdgMK6rJVzc1I6zv6
iuwCIe7fH+th0zB2AwwgnqF1v4bWPZOIe3btQkWH+VR6A9uyuZPTIA20w4eO
MmVIhQPhePm1CPUQCiQJX00o/n5C8QpE3L6tJyLioYNHEiIuUiICVIi46Le9
Cr6a4Pp+QvEKRNzdeqiEiN/77UEhIkCFiPeXEjGpeNkivpnt2QsitrRsZBs3
NmPuKklLE/sHjx+C8ndKKFQFFpCbjLFQ5QePH0xXJWmgslWZHJHlscdWsiVL
lrAi0HyG9XnKgRRowYHwgSsPLqQdKXaEDslJFsZY0ngYyuskNMrBIWiR5gpa
QUQslLQo4aAJaASaRa27lLebYt1JgW5G5VUZJaEbM40OqSPsUrbrLmH7O49x
0ZqbmlDZxYsXw7WIZNEupCA4MZqQj6eEem5ADMG+BlbXBskozbEPPnlUOFaI
F5UjtcWCBo20GpdegAX3iOJgCGUTkO/BJ4+kOboefVE09SUW+FBJHC2MO5fq
EyZafZ6d4CJ2oLcfxm9zE1u5chnawsHYZffccw+WQvAlDj6K5sRoQuAkLV5X
dARBS+sIy56RHQGgtVrTUVbyWpRyRmEKUoupAmoEuqkAGnPNhRGE15c905fm
9YlEX/IwLsZ7qtbxXWIE+QSvOA5CHTFoynb4hcrhfFpbuVJM2K50+IIFC9id
d94pjVXa4cJqodsV3YMYu/0FWd1cTHWzH7aV5mgXtQBtot0ZNAWNQfMLs3g8
qTT2aEpzakgg2CfAEwnjVODXI31DXH8YyKAvdHUIygrSt0WAoTAOVhD2hpQK
Ki/khZSv0dS1AVPprv3PZ48J1wpotLpD0ERzBU2kSHm8igBD7GkO51cHdRf9
GiwCoAskFARewQVL9XmyJY8QLiKgk65UaVo9Yc+ye8ObWP+Js9y50NeXLFnM
Zs+ezebOnYtmAsvAtYgYIQSkIDgETa5LeFKuS4DoaRAGSzaBTesOK9e9IrqD
3kjIlWiYao4HJBSlllGtQEvQFrQG7d8k64NcK597Nd3rSRl8o97yExombiKd
UR1hn7Lde7GUDZZuoPhNN90UuNjWrRMIWkNGJzqB3hbMC1Jo5SEQGoQHJS62
91I9Gxw6J+ckSKkAnymYcrWyOknLac0MzDzWgnfPZUqPIpB9MYqTEjQQEsSt
+siG48KqyeoOQZtA0ApSNtUZQD4upxIZWodWUp9dTp0+h0zfAinJH1IQ6iQt
p0dgwQyG6LJlSzB3FdFA3E6PPd8vHoEFFKoCC8hNxlgo+ptN/emPwGfO5qbK
DQSzuNiPvzggNhwAKkR8fPNAuojnzuUoYpJZXMTGLSeFiAAVIja1nMwi4sE8
RTxIiPjES4NxEZ98aUjBg82vnTuNIvb2Ztru1JnFRQRmSkSFe3rHUFzEp3ec
UvCoFd9+y0K2pqWdiwggl6f3Ia27uye7FRWzGwhmXgy3eucpNg1jN8BEdzkB
d/eSR9jMex9ia7d2XIMsPbar8zCS7l76KOvs6Mq0aRxjOY1mGRUU0LBLfB1r
OQQKQVrCgh3jva17WGd7G2JjO8bzvrOCde3fy9r3dWTb3dZZTqNZejT6Whqt
nA6iQw3oKpez1h07p7AdLZtdSMkOBIojz0zm1Tm/DfhdkcLZIyr9OUAvS6lk
/1XHmPqWqAo/X/BhGOE8zIKoNHz58hUYzYKodLdH7lyOh+1GSRVehVfhVXgV
XoVX4VV4FV6FV+FVeBVehVfhVXgVXoWXB58k99vhMyx2vJhL0BxLGubE1wa+
VgABPlipJOrrlWtRW0oIQ5nQvkiW6Zi0+ros/zQa6uh4L0ajcPApxNSlrl/L
Jn4DIU5RChWlKWP5JtkomhcWjI7QPtWgTadIlpXWjvLkXdkUuYBgUcgyem10
DUdx6aF03rT5Ybam6gNvh36vJ9guyMZ2TE33VXgVXoWfz7WWa5oYPasp1dF5
GFM4R3oBTb3CH53HjUs6JPn6vY9qiGYKH0+j2ej1l2XM1QZWtdb3anfEaKn2
pe75TsjF/l5K38LL0z6UQq7VogzKUf+q/DxaNA2XHLwc2jGxOJ1orF4wWYfy
CLVcsfGSb4Gh+tMb0kGqIFyfhbTIIwHRp7FG/GnI1gfhNHoeRwW2X2sysVNJ
P8giejjn5z/28pnDbJ+y3Nh4lx9KlLIGic5inHFwJCRIv6eHKZ9g6QeldusH
ioeX2qqcyaKf4ci0F2k7odjV+c01Nrf3qZYd7SKCdjFBe3828cOF3viYYXS2
VwSje7JRkMRd6X3ZZBlTK+AqvAqvws8TnLo3hSsIwzNbOPunbdfHn12JmZd6
WMy4F0gpYFwtxpoyLwPSHrfsHsUoWiDHV/PSMcXyJH4CiTddy9ngjmLKUTPc
nghX8OH6klxpjhXRR3B7wfaLkAyL2PI7YjmbUFm/ESDnDb1D5DFv0AK9mxDo
znL78lWVMxtTd4yM8CsJ9S8haBm/maPYUuvlcr5kNe7GxjcWrB7VDPtI1Bzt
6xNghUOIuoOb5QmHbyEcYYnKtnfWEd5GMpi/kg0P23cZKL9VvtFisaEnzOxr
hSbhza6yc1/6xPuebM69kGh0vKV1qP2I+D3O0DVN1c2OTrD0M4w4E02wNu4N
5/W9BIR3V+6X2sDJlNwRwfyIFAoS37/KxTGKAdVgyT0tL9JY3AHG90jCWdj6
caEiP4RLhXGB9fPZxDV060q+lzI3Tc/GJXTw45UiU5LlzSe1mxqbL3s2G4HN
XFq+UOPQLOX5LcjFmyxoTcbNVkrAZN8ajq4g0nZ+jd8UZ1w3mN+JK2+bl3Ik
VfcDlY/6ScGorw1SF8XGRLQzx++YIyjamHp+qMKr8Cr8DfJ4fUHKBBcuu0b6
4dp2rYPgOeVoqPM2v5r6OniCTdh2bjaDhC/Q1lnqMQrPfDmrl+QyARJj5Dkq
lIIeeBk1jq+54PM6eHAxjvxbK1ff+BrO2Fj/B36J0TI6viFw7UgvsXMSmJqL
cTcxl8V2np1qTC0pqvAqfAzCPwJIHHBvhZQccJCC4BC06wnaJwjaJQTty9Zy
fYyoPQVjX6NBgM90S6kmE7TbraWaSNR2MfY0Gs5fPOEEKTdIxar7sVJavZCH
S6TifIPShDvDEkV3AzljBZSwmPODGqJCgZQ4qX1BlzzG2gvl8DQ5jOJpRhZS
aRYIUG4Ka8qmlIMr9FCYKloOs0iD6QYupJraifVO+TH3okRH9kydlvIKgr2Q
W7qegr0BPMNmVE4LlnvhEnleOSM1SY53hcCu8nslwh/MVC8bzddoafiw/3v2
StAzg4mms9S6mpPOLWWckI6h5irDVODHyTFrRHol1aYRbOqklID+qPSF0nJQ
nk9VTZ9OIuyNt6fS/crEPdKCQzWRRXmbGSU0CNGb6AJT4wmdcUlSakK6IZiG
XH1Cqofafgp724FBaeHm1BctOkk2NlYTUq2F9GmTUa3sqVR9s1WzW8vJ3coJ
80wYFecmmh2PiVqTz9W1mGLoop2/BQPrruEb7ZGhOi3waMwG4Ytv4TfjsdfR
Yu/jOnqpG6TkWm84uiMYcvZ1fgWCs0/gqHZZuD0mcskaMemnBPObwdRpM54f
Qahys9fzGgWWYDMD6y7oiajsGa4Q1s86w6XglaejQqQXJO5CLLEKlD8YHS3f
YXPUijzKIrBDmkkyzF2urrJ5uUP16wyL9ELgDNt5Km3RbTVZ1QeTQeQlIfgM
099CxDfTYwU0j5KAGMOiacazlcNCaL9s6XJX10KhN0NqEjnTmGfZEsty3wJT
ydI9fgMoxTf+XEtMAfZ7XiljLrEvMlrPtekTrK3bKncJtTAbvTZNcsSdnt7u
6/t5NoMola1jjRttH4XY6ls/VHlC6WnUWBBOxrFzJSznUJ1v7die2sMFcoz1
paYZHF1fEMy7Uvb2498ZWG3vuqmVtGnPOEe5ZIHG3DPjzK0ad67dQN20/fsI
WX7i9stooXGVVXd10Q0buiV2/RNPAsalecxcFWz+xycokxeJ21xEXZu5KEmz
WqOG09A40+jyZBwbkgUSmud05OksM81JKY/fhgKLuqE+qHzWhePFhDPfQUPr
CSj1fTL1cEj1mQJBu5KgXZ7SwWPQCbTk1N3zbQTtwpHu2Q16z3YD39ndbMp/
riq/w+f5kDUsXvExNiNNOhy8NpQmTga+Fs9aDYTrKTdT44Wi1duPoUstx0bl
Yyi9F2ccQFdKoaI0xfpN1gOJ5bJcDTs6tSlKbbdSs2iB6L0IKwap2MYrxYUa
Jk5qu2FpbJs3nB+ozdiMb9qmTxChrOGCu56w75VBihrrRYLLX2WTNdxND2/+
4TuyxuPV8eY3VTeaH9SN1SiUK9zYe7Xr9QwfL2eQ7q4edrD3MDvW9yrr7x9g
AwODbDI7eXLwInbm9BkHUhx18uQQGxwcYkNDp9ggT/f2HGZuCoe3Qb2ppTig
yA0ZRfbY/vZO1vNyF7vnx4/BH71eHfmj1y8s+gUbOPEqDyddGj2dRpcpyt62
PWzewhVsxh0/Yr9r/sPVbOOGVk5eu3EDm37bA+zz9z3Mjh8/4dLo6TS6LFFc
1rZrNyq1ZtML7L3I2WWrmpuR1nf0lWDJFsXNIHBlNh/99+j3si2bO9Vsx2mH
Dx0Nmo/iZhC4XJrfvq0nwhb+X5tq/jKJgw+kILyLqJuLSLtbD1mJJHDwgRSE
dxF1cxBpItuzVzUFKQgOQZN7DpD0tQII8GmQsFK6UQ26JiHkHRnyXlAqP64R
IIMTwoIiV685iRA6N6NaCeSkmJQyS33FZk5rK2HkeFegxDKJ6mQB142UJ/Z3
HpMvXEAKgkpHrgVMFKmi4DoJUzaWF7hoky7GvkZTfN0Y3kTzU3g4kJKLvmTr
EwnJc7Htgd5+aTRIQVBpdZWnretA6joJUzbW5Tgv5OprzSturuQWbYGieZES
RXdiOAiFoEE0cgMhbC4GPdI3JFuGlGg0SXMtcXEahDpJK21nwBW0uoovvzoh
fxsMJb+n0QziOiZ94zSTbrm4pf/EWdkUpISsOi3IiQJfK1CVXKJSnaSV9gfg
xpF841eUISKNp5UqQSIAXTc3xAR0V682iZDa3tLvIZ4HF5itPzh0TnYDnpLV
IAXhUkkrbT7A+VpdCPB5K8H3LQTfEVPw1GnVPKQgOATtUkkrrSrHoctFDU/j
wmDnIsnIXrfwvJ/0k7XFbmKtZgO17xG5ltypjDCjf+14h3m1feasjcFmELiM
9kj9E7M8z9W0+sl9ub9dhnC72ZrnztlZM4nLas34HnRS9NqYNSTd5v8lbA4f
GBGLHbS02MERsVhsQ5bSxD3f1mvbudNovd7ew4H1ori49QCXv/VyGaUVDt6S
1cne+PZbFrI1Le3cngK8pmUf0rq7e7TeqHAzCFy+9gxyNrcNw1XcLMr/84av
hGbyUP27lzzCZt77EFu7teNqWWVX52Ek3b30UdbZ0eXS6Ok0Op8byFTCdN+M
ir63dQ/rbG9DgWKboPO+s4J17d/L2vd1uDR6Oo0uZy0whRDUp+foe6M9lFsK
pYIRPYW17th5EdvRstmFFK8JVDA3yq08oFd6B0CnplTK+AAw9nbnh9m/LH9q
KUR+5scYXinsUxB/S/rp2CuDbNHin7DlP3uUP4JA7LL7Fv2ENT7xLFayairT
6U0lRVqy9CHWsb+b7dnbg7tBMD1BHugViWQ8+clKJEi9uHkvFwliMRNnEik8
QoieCIdH9Nwom+OSBC3kEJ9Iky2F82sexy1fO3rOyHbk4nk84CpxNGXqCxdj
4VzlD42eF6k/Nh7V87lq49BSXT90x6icpfy3Jl9Q/R/j2/L0D3V0UfgCwWic
KZb+b4ZeBBnHGZ+dKj5Y+Tw7hTowO/Y7x4h7Kpnjyjr5LL3pMXDSMjm/mZoL
b9hpN1Zq8tZ0Q2ZzR7oXGP82L8tqJG620DKhRuX1giBnBifuluHaJO0pMOIg
ixUJ5WsTzbijqZeVfgET43+I9YDNW/Zxp0Hssr/54AcxBcGTtMy9orx/sNBp
xuPyjPtN7yBo5CRpYpA63ehTRhYHptodbYxm98u1NvV+XR6HZ+dgz6BgHClJ
rtbctr2L53jsgzU9mc9sTe1NrKiGxIgyyTyywxWeZeFFih4xWj0kQEoGVz7t
5qe6Nuryvxd5mmpKMTdIOTkopPdWakVJORJL5sXsf+BAH3x5z2PhAEiJHMRF
jQZhDIldJwXNR6Sgh8afxo4dO8GbgviN1NTg4GneFMQj3tSfzsJX+RC/kZqC
MDFCgwpd6lcZ+TW1e/c+zKlHeMjnqNW3JdvvP/Az1tT0LGtsfJazbWxs5je5
3/O4UQaV/v3vm9ni+5dl2wutbL92TO06v57h18lOAJ8uw69eICDbT1iznYaV
6B/aIKvZ5W5bGXcA3fB2TNQgn4fCu0up/7hM++PbL0EKfyQlf/HSlXKqqktA
wvMk7H/YyrIedxq2OVLHnbqmUjeFZcwelETYXyaV219qUzyX5lXzVln5/zJL
rfS/ADF1KKj5BAf7YzgpWoZDzswnPlC0lAM5rfmen6M5kz/UHZGDObEjX1hu
R6a2FUSHSt+7LbGapuZUqi58CrH+T12/CKn4j5JD+6fTTI51Y15K6bP2Zzam
Y0b37MaROtUSu9ybR7vLUd9I2L4HFflq16KjNejzDH1mX5JmPqp0JI7OSz+K
bfSO0KNv0MkWjEfoYW+6KP/eVHq/KfWFrvK33mx30+cHS7xwrSabNbk+bcyb
b8vE/WwEzxMb1dty6Xsm1VaItxTalgbB/oYcf00PPtSvtG33d12hjr5UTKsU
4MmapRaZ802LzPiBTXFnKsMJeuI0o0iZad3vBhXN00/KiU9YKfezl9KlpVLY
VS626Sr4ZQVyHJ/ipSW2y/7ASzGa+UDmsg/wsD0Eh6Khfd5Z7q0hPFmGei/y
7mD2RdVq87fGZQTN9jiTyqwx9naEqvAq/HUNl5vKPLVUPIxYVMSzI3/Oli9f
MT7CgmeXQlTdl64I/lZiTv8PiC+wvP9hU4sqaupCOVdH2cobgmB/vw17/MKF
OqkpsipLeQXo+5CqM96q8tnAdYMbZcqWMtO2s/L5iyo04/XWoy3mJfOjWPZ3
0Kgl8OJ025+PzUt7fMkdzLiXTcLns4f5IRsnx9d5lLPCR6a0DXodf7/JkeZH
ypHY6Svdtnm3b0T/MgU99GEbD9UbB1HoEZs3EvnngexOGYldsdK3kpH7fwm0
+zQbu9cFdk99TbusH1PEpjq7vz0J+I/kbFfJgBnd0+bt5zjqRhZ7zzfzysDe
ZV1WGyU2x7CHubwPrM5/UbDCNNVQD/FpN1pqH4F66EcVZlkP7MgXGLoyPw+e
LFCe+PGm+kw0LnfhxtQjQRVehdvCT59+jT344C95V//a136I0SyIaoBYA6VJ
+OrmLRzOY4xmQ2RA9hyAMcRjjGZDRCD7TwziEJZnYW96btuwkJ2Hv5ZD/djR
o2zZw0+xX1xzHR/HPHbYL993nY95F0sAEcxqNcBUteLhtaurm53iMvHmHUzU
8fgMinmaX09hEGmknVL51/DKpXJYfUMDby2Evoa51yTttKQ1QtwIBU2Y97Qa
p+D40WglUeRgzg3ycHVkE0rxX39gJp+6IC5gHuinIzJzFZXOtXjd39HNTnDr
QgAr9w/w9ADmXdCIz939sliEIaQKRT1RhdOAzqt5WOgKLrII2cBJTEOuMBEQ
iwiElAoqLxmoikF5jA00PeSEDAmwKPDJlgopZV6MoaAphp6pzbB0GFJwTtZQ
ExjIQVNMCGwVNY4wtbj2nwjpDuZ8Th8K/PrcTZ9kGz8+m8u+cebfc/dBGmhQ
BpigPufF3ar8XMRr+74udrSvX4Rj/exI33GePs51EI4EOmhzFOn9Ifl4hHzc
A7KD4CLSAKVCyKI/wRZyaDcgeCqrk92AHObcVK5SISeUiuJhkEKHClBBo0GQ
eTdWRfBVzXoyrypGK3lSjyjTmRA3gh9WgRUVc2l7DA5B82QMzgbHQ3jx47MK
bMusT/O+wpMBGSCKzfEa8L4+1e3Z08kO9B5lB3qOwimBfbw78SQPffJ6NFAV
YKgoEMepLF5FcV8IheqcLrC1EtcXBJUP/AAZojeUS07w9jURVE23jAbciD0A
BHEx4B41hMqLegWtXqRcFI/TijVbRtIUq0j5LZBpBJs3gfkd9IMQUTgU0YLs
KrdL+wjdoLtAJ4IuJJ+aXpo9Rx1ts+Vm7GeIAGSUA+9I+q26tW0/a99/kOd4
DFEvq2ftHQdRWMxJJSANQHWN0gPTQ8bVin2k1cbY9Ca9BkTCmYJjlOzLThHl
6MVwkEtlWbIlpUlUdsNVVB1PqgjXqJX41ZF2IQwoZS6YrDUMmXURK6tyR0ra
EXNS9NrR0evKqqr/bJv9abkjUsd2z5mr7Sfu/NStWK56UZQV7zT6/LRrdwfb
1dbFdrd1O5jw2O7WLkztausW8xFkGgLNoHh3azcWQ4mi72qNpKEMcGG5jxVr
Y2y6ki4BIuFkIBO3BTnhhzOOqK5aCG4QKVxLNiZyuvjGHpWsGm0FUpIeFV+J
6kSUCHtWkuXNEDeCeZvQ1hOEOaXV0Z/cQ5BHZ7ZKuqQ5WFoU5eBoXgYdpXXO
HLbvM59h11/+FvkG+DhMd/3jZ5EO5YDbFbTTjf1H9Sgfr9t3drCt29vZSxg6
eGuQKrKtO9pRB8ip8lBHidku6ip6EuNq5b6sp/gCTXlD1XUjs45O8zQavzp2
ZFnkRkSIdgPIO8ZGXY2Ni7FFtxLgqF2iOihaIKzeinqIUCbS9NK53gxxIzii
CVLC3C46JuS2FeoiAygdh25WboUAnQQ6TPf8z7KuL87HTqRep8UOxWkQoBxw
+AzJGdRA7RroQfqtbuvWvWzD83CEF8ShtTY8v4ut37STredUoEEpWmsDJxaw
WJEVJCjmvDbJYn7FOWI9TwirrpdFcsHLs56eQrCrp8JS5gYcBJckpIAIsSpR
WOq6KXgG1HmG7EIppCtD4SPyKK0gzIS4EUzShObz0UIbpCFFehcTZnIRAZaE
HNIchBQEmBPB2z23fYn13HU7O3TH7b78UkVm8QrFYruAV6oB9jXgVP1WtLll
L3tu/Xa2bj130TqecCGJ8q/bsD0YPgBB2vptcpgVZH57EAJPQ8bjVbYFZOQe
9vt1WLSNXY5xOBZETsQqD2EixgUNp6SULUaXCKoY0hcTTdwMcSMI14SKuSin
kjcqv7QMUJwAKsjPoSUEc3weuftOduQbXw8WCDDkoguE49/+ZywHHD7irFeC
bgcn6F55YXMbe3btVta8dqvDEy0QbVXPjM1rW4CGAEGbgDQORhoEoCqMuqp6
WOfKMCkBLcwhaPUY+xoN6SgKpDwd39BwCcHmZogbQYRVQp9mrNkcEetZqStf
GipNmqX0UY3Bdie+9VXWv+AbahscTH3idz/Fq/ouZGjxAoAgFGc6XrcGmNSA
cfVdov95oY2tevJ59tTqF9nTGDarq4+JApKg+KmwCK4Oe/oZHgGVI5/ZHLB4
SuKbINUI8FVI92KcNjuSDc+NVzTJ4UWJFXjQe/C+e9nQAwsd0NRlA0/+DFMO
0LiMUAooJQeoxFXTZ/WNz7eyJ5/YyobZb/9rE0YfhoiL/4MHf43Vh39+P/vf
NQ+zP7Y/wa35xyOrHPbakVUcAAQoAAAAoYIDlWuAYw2w1ttau46PQT5XDbPf
PLoeoxkQ8dIFix9CFhBqMS4gDUpVgJqcg2Ipfh30q1+uYQcPvsK2b+9iq1dv
ZY//93okYvQxLPaBiIUAAjBQa+Q3POJnAt/97k/5qvxldvbsWdZz4DB76aUu
9sILe2FXd/VWjD6KHApIhVJAARpq8dqSnXqFZOmSRwN+AydO4r8udb/cNwxE
jD6CxQUgYiGAFDteWfBh8lQIUNhl//bd5cgXpA91/DvMe1gCCMDyIL9I98W+
MSdgNBMieYZEuKU8R5qi5v8AhhvWeQ==\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{605.5, 444.625},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:5.5",
 CellID->15262],

Cell[TextData[{
 "Each screen of the wizard has a full description. When it has finished, a \
new named connection has been created. This can be used by ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 " and will show up in the ",
 StyleBox["Connection Tool", "DialogElementName"],
 "."
}], "Text",
 CellTags->"b:5.5",
 CellID->8519]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"The Database Explorer - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 57.2651947}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "The Database Explorer is a graphical interface to DatabaseLink. It \
provides a number of useful functions, such as managing connections and \
working with the data in a database. It can be launched by loading \
DatabaseLink and executing the command DatabaseExplorer. If you find that the \
examples in this section do not work as shown, you may need to install or \
restore the example database with the DatabaseExamples` package, as described \
in Using the Example Databases. On Windows it appears as follows.", 
    "synonyms" -> {}, "title" -> "The Database Explorer", "type" -> 
    "Tutorial", "uri" -> "DatabaseLink/tutorial/TheDatabaseExplorer"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:55"->{
  Cell[729, 29, 86, 2, 70, "Title",
   CellTags->{"xref:55", "c:60"},
   CellID->24970]},
 "c:60"->{
  Cell[729, 29, 86, 2, 70, "Title",
   CellTags->{"xref:55", "c:60"},
   CellID->24970]},
 "b:5.0"->{
  Cell[818, 33, 557, 17, 70, "Text",
   CellTags->"b:5.0",
   CellID->23847],
  Cell[1845, 67, 205, 6, 70, "Input",
   CellTags->"b:5.0",
   CellID->32604],
  Cell[2053, 75, 278, 8, 70, "Output",
   CellTags->"b:5.0",
   CellID->503],
  Cell[2346, 86, 85, 2, 70, "Text",
   CellTags->"b:5.0",
   CellID->21221],
  Cell[2434, 90, 11215, 187, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:5.0",
   CellID->22663],
  Cell[13652, 279, 388, 12, 70, "Text",
   CellTags->"b:5.0",
   CellID->5706],
  Cell[14043, 293, 145, 5, 70, "Text",
   CellTags->"b:5.0",
   CellID->2363]},
 "xref:68"->{
  Cell[14213, 302, 94, 2, 70, "Section",
   CellTags->{"xref:68", "c:62", "b:5.1"},
   CellID->9010]},
 "c:62"->{
  Cell[14213, 302, 94, 2, 70, "Section",
   CellTags->{"xref:68", "c:62", "b:5.1"},
   CellID->9010]},
 "b:5.1"->{
  Cell[14213, 302, 94, 2, 70, "Section",
   CellTags->{"xref:68", "c:62", "b:5.1"},
   CellID->9010],
  Cell[14310, 306, 693, 20, 70, "Text",
   CellTags->"b:5.1",
   CellID->22171],
  Cell[15006, 328, 6632, 113, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:5.1",
   CellID->27489],
  Cell[22052, 455, 788, 21, 70, "Text",
   CellTags->"b:5.1",
   CellID->18240],
  Cell[22843, 478, 326, 9, 70, "Text",
   CellTags->"b:5.1",
   CellID->12164]},
 "xref:71"->{
  Cell[23206, 492, 97, 2, 70, "Section",
   CellTags->{"xref:71", "c:63", "b:5.2"},
   CellID->25542],
  Cell[70545, 1316, 90, 2, 70, "Section",
   CellTags->{"xref:71", "c:63", "b:5.3"},
   CellID->25205],
  Cell[71423, 1343, 152, 6, 70, "Section",
   CellTags->{"xref:71", "c:63", "b:5.4"},
   CellID->1539]},
 "c:63"->{
  Cell[23206, 492, 97, 2, 70, "Section",
   CellTags->{"xref:71", "c:63", "b:5.2"},
   CellID->25542],
  Cell[70545, 1316, 90, 2, 70, "Section",
   CellTags->{"xref:71", "c:63", "b:5.3"},
   CellID->25205],
  Cell[71423, 1343, 152, 6, 70, "Section",
   CellTags->{"xref:71", "c:63", "b:5.4"},
   CellID->1539]},
 "b:5.2"->{
  Cell[23206, 492, 97, 2, 70, "Section",
   CellTags->{"xref:71", "c:63", "b:5.2"},
   CellID->25542],
  Cell[23306, 496, 740, 18, 70, "Text",
   CellTags->"b:5.2",
   CellID->7619],
  Cell[24049, 516, 13544, 226, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:5.2",
   CellID->20913],
  Cell[37596, 744, 206, 7, 70, "Text",
   CellTags->"b:5.2",
   CellID->7591],
  Cell[37805, 753, 13788, 230, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:5.2",
   CellID->6704],
  Cell[51596, 985, 427, 12, 70, "Text",
   CellTags->"b:5.2",
   CellID->31818],
  Cell[52026, 999, 18306, 304, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:5.2",
   CellID->9232],
  Cell[70335, 1305, 173, 6, 70, "Text",
   CellTags->"b:5.2",
   CellID->750]},
 "b:5.3"->{
  Cell[70545, 1316, 90, 2, 70, "Section",
   CellTags->{"xref:71", "c:63", "b:5.3"},
   CellID->25205],
  Cell[70638, 1320, 748, 18, 70, "Text",
   CellTags->"b:5.3",
   CellID->4975]},
 "b:5.4"->{
  Cell[71423, 1343, 152, 6, 70, "Section",
   CellTags->{"xref:71", "c:63", "b:5.4"},
   CellID->1539],
  Cell[71578, 1351, 319, 10, 70, "Text",
   CellTags->"b:5.4",
   CellID->303],
  Cell[71900, 1363, 192, 6, 70, "Text",
   CellTags->"b:5.4",
   CellID->11422],
  Cell[90805, 1682, 258, 10, 70, "Text",
   CellTags->"b:5.4",
   CellID->11247]},
 "xref:70"->{
  Cell[91100, 1697, 97, 2, 70, "Section",
   CellTags->{"xref:70", "c:64", "b:5.5"},
   CellID->13584]},
 "c:64"->{
  Cell[91100, 1697, 97, 2, 70, "Section",
   CellTags->{"xref:70", "c:64", "b:5.5"},
   CellID->13584]},
 "b:5.5"->{
  Cell[91100, 1697, 97, 2, 70, "Section",
   CellTags->{"xref:70", "c:64", "b:5.5"},
   CellID->13584],
  Cell[91200, 1701, 1136, 31, 70, "Text",
   CellTags->"b:5.5",
   CellID->13648],
  Cell[92339, 1734, 141, 5, 70, "Text",
   CellTags->"b:5.5",
   CellID->2971],
  Cell[92483, 1741, 103, 3, 70, "ItemizedText",
   CellTags->"b:5.5",
   CellID->17864],
  Cell[92589, 1746, 123, 3, 70, "ItemizedText",
   CellTags->"b:5.5",
   CellID->22913],
  Cell[92715, 1751, 118, 3, 70, "ItemizedText",
   CellTags->"b:5.5",
   CellID->11075],
  Cell[92836, 1756, 106, 3, 70, "ItemizedText",
   CellTags->"b:5.5",
   CellID->21545],
  Cell[92945, 1761, 124, 3, 70, "ItemizedText",
   CellTags->"b:5.5",
   CellID->28712],
  Cell[93072, 1766, 115, 3, 70, "ItemizedText",
   CellTags->"b:5.5",
   CellID->17546],
  Cell[93212, 1773, 101, 3, 70, "ItemizedText",
   CellTags->"b:5.5",
   CellID->18678],
  Cell[93316, 1778, 486, 11, 70, "Text",
   CellTags->"b:5.5",
   CellID->1769],
  Cell[93805, 1791, 10859, 182, 70, "Picture",
   Evaluatable->False,
   CellTags->"b:5.5",
   CellID->15262],
  Cell[104667, 1975, 441, 13, 70, "Text",
   CellTags->"b:5.5",
   CellID->8519]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:55", 106949, 2034},
 {"c:60", 107050, 2038},
 {"b:5.0", 107152, 2042},
 {"xref:68", 107746, 2065},
 {"c:62", 107860, 2069},
 {"b:5.1", 107975, 2073},
 {"xref:71", 108443, 2090},
 {"c:63", 108766, 2100},
 {"b:5.2", 109090, 2110},
 {"b:5.3", 109853, 2138},
 {"b:5.4", 110051, 2145},
 {"xref:70", 110413, 2158},
 {"c:64", 110529, 2162},
 {"b:5.5", 110646, 2166}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 104, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[729, 29, 86, 2, 70, "Title",
 CellTags->{"xref:55", "c:60"},
 CellID->24970],
Cell[818, 33, 557, 17, 70, "Text",
 CellTags->"b:5.0",
 CellID->23847],
Cell[1378, 52, 442, 11, 70, "Text",
 CellID->16687],
Cell[CellGroupData[{
Cell[1845, 67, 205, 6, 70, "Input",
 CellTags->"b:5.0",
 CellID->32604],
Cell[2053, 75, 278, 8, 70, "Output",
 CellTags->"b:5.0",
 CellID->503]
}, Open  ]],
Cell[2346, 86, 85, 2, 70, "Text",
 CellTags->"b:5.0",
 CellID->21221],
Cell[2434, 90, 11215, 187, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:5.0",
 CellID->22663],
Cell[13652, 279, 388, 12, 70, "Text",
 CellTags->"b:5.0",
 CellID->5706],
Cell[14043, 293, 145, 5, 70, "Text",
 CellTags->"b:5.0",
 CellID->2363],
Cell[CellGroupData[{
Cell[14213, 302, 94, 2, 70, "Section",
 CellTags->{"xref:68", "c:62", "b:5.1"},
 CellID->9010],
Cell[14310, 306, 693, 20, 70, "Text",
 CellTags->"b:5.1",
 CellID->22171],
Cell[15006, 328, 6632, 113, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:5.1",
 CellID->27489],
Cell[21641, 443, 408, 10, 70, "Text",
 CellID->228391340],
Cell[22052, 455, 788, 21, 70, "Text",
 CellTags->"b:5.1",
 CellID->18240],
Cell[22843, 478, 326, 9, 70, "Text",
 CellTags->"b:5.1",
 CellID->12164]
}, Open  ]],
Cell[CellGroupData[{
Cell[23206, 492, 97, 2, 70, "Section",
 CellTags->{"xref:71", "c:63", "b:5.2"},
 CellID->25542],
Cell[23306, 496, 740, 18, 70, "Text",
 CellTags->"b:5.2",
 CellID->7619],
Cell[24049, 516, 13544, 226, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:5.2",
 CellID->20913],
Cell[37596, 744, 206, 7, 70, "Text",
 CellTags->"b:5.2",
 CellID->7591],
Cell[37805, 753, 13788, 230, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:5.2",
 CellID->6704],
Cell[51596, 985, 427, 12, 70, "Text",
 CellTags->"b:5.2",
 CellID->31818],
Cell[52026, 999, 18306, 304, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:5.2",
 CellID->9232],
Cell[70335, 1305, 173, 6, 70, "Text",
 CellTags->"b:5.2",
 CellID->750]
}, Open  ]],
Cell[CellGroupData[{
Cell[70545, 1316, 90, 2, 70, "Section",
 CellTags->{"xref:71", "c:63", "b:5.3"},
 CellID->25205],
Cell[70638, 1320, 748, 18, 70, "Text",
 CellTags->"b:5.3",
 CellID->4975]
}, Open  ]],
Cell[CellGroupData[{
Cell[71423, 1343, 152, 6, 70, "Section",
 CellTags->{"xref:71", "c:63", "b:5.4"},
 CellID->1539],
Cell[71578, 1351, 319, 10, 70, "Text",
 CellTags->"b:5.4",
 CellID->303],
Cell[71900, 1363, 192, 6, 70, "Text",
 CellTags->"b:5.4",
 CellID->11422],
Cell[72095, 1371, 18707, 309, 70, "Graphics",
 CellID->94557465],
Cell[90805, 1682, 258, 10, 70, "Text",
 CellTags->"b:5.4",
 CellID->11247]
}, Open  ]],
Cell[CellGroupData[{
Cell[91100, 1697, 97, 2, 70, "Section",
 CellTags->{"xref:70", "c:64", "b:5.5"},
 CellID->13584],
Cell[91200, 1701, 1136, 31, 70, "Text",
 CellTags->"b:5.5",
 CellID->13648],
Cell[92339, 1734, 141, 5, 70, "Text",
 CellTags->"b:5.5",
 CellID->2971],
Cell[92483, 1741, 103, 3, 70, "ItemizedText",
 CellTags->"b:5.5",
 CellID->17864],
Cell[92589, 1746, 123, 3, 70, "ItemizedText",
 CellTags->"b:5.5",
 CellID->22913],
Cell[92715, 1751, 118, 3, 70, "ItemizedText",
 CellTags->"b:5.5",
 CellID->11075],
Cell[92836, 1756, 106, 3, 70, "ItemizedText",
 CellTags->"b:5.5",
 CellID->21545],
Cell[92945, 1761, 124, 3, 70, "ItemizedText",
 CellTags->"b:5.5",
 CellID->28712],
Cell[93072, 1766, 115, 3, 70, "ItemizedText",
 CellTags->"b:5.5",
 CellID->17546],
Cell[CellGroupData[{
Cell[93212, 1773, 101, 3, 70, "ItemizedText",
 CellTags->"b:5.5",
 CellID->18678],
Cell[93316, 1778, 486, 11, 70, "Text",
 CellTags->"b:5.5",
 CellID->1769],
Cell[93805, 1791, 10859, 182, 70, "Picture",
 Evaluatable->False,
 CellTags->"b:5.5",
 CellID->15262],
Cell[104667, 1975, 441, 13, 70, "Text",
 CellTags->"b:5.5",
 CellID->8519]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[105147, 1993, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

