(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29341,       1035]
NotebookOptionsPosition[     19031,        673]
NotebookOutlinePosition[     25476,        878]
CellTagsIndexPosition[     25336,        870]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DATABASELINK TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SQLBeginTransaction" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLBeginTransaction"], 
         "SQLCommitTransaction" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLCommitTransaction"], 
         "SQLRollbackTransaction" :> 
         Documentation`HelpLookup[
          "paclet:DatabaseLink/ref/SQLRollbackTransaction"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"SQLBeginTransaction\"\>", 
      2->"\<\"SQLCommitTransaction\"\>", 
      3->"\<\"SQLRollbackTransaction\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Transactions", "Title",
 CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
 CellID->31020],

Cell["\<\
Some database operations involve carrying out a sequence of database \
commands. For example, information in two different tables may need to be \
updated. In these cases it may be very important that if one update is \
carried out, the other is also. If only one is done, it may leave the data \
inconsistent. You can use database transactions to ensure that all the \
operations are carried out. In addition, you can use transactions as a way of \
backing out of the middle of a sequence of operations. This tutorial will \
demonstrate how to use transactions. \
\>", "Text",
 CellTags->"b:6.4",
 CellID->23694],

Cell[TextData[{
 "If you find that the examples in this tutorial do not work as shown, you \
may need to install or restore the example database with the ",
 Cell[BoxData["DatabaseExamples`"], "InlineFormula"],
 " package, as described in ",
 ButtonBox["Using the Example Databases",
  BaseStyle->"Link",
  ButtonData->"paclet:DatabaseLink/tutorial/UsingTheExampleDatabases"],
 "."
}], "Text",
 CellMargins->{{27, 27}, {0, 8}},
 CellID->15529],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["SQLBeginTransaction",
       BaseStyle->"Link",
       ButtonData->"paclet:DatabaseLink/ref/SQLBeginTransaction"], "[", 
      StyleBox["conn", "TI"], "]"}], " "}], Cell[
    "begin an SQL transaction", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLCommitTransaction",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLCommitTransaction"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "permanently commit an SQL transaction to the database", "TableText"]},
   {
    RowBox[{
     ButtonBox["SQLRollbackTransaction",
      BaseStyle->"Link",
      ButtonData->"paclet:DatabaseLink/ref/SQLRollbackTransaction"], "[", 
     StyleBox["conn", "TI"], "]"}], Cell[
    "terminate an SQL transaction (do not change the database)", 
     "TableText"]}
  }]], "DefinitionBox",
 CellID->14788],

Cell["Functions for executing SQL transactions.", "Caption",
 CellTags->"b:6.4",
 CellID->30109],

Cell[TextData[{
 "This loads ",
 StyleBox["DatabaseLink",
  FontSlant->"Italic"],
 " and connects to the ",
 Cell[BoxData[
  StyleBox["demo", "TI"]], "InlineFormula"],
 " database."
}], "Text",
 CellTags->"b:6.4",
 CellID->17984],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Needs", "[", "\"\<DatabaseLink`\>\"", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"conn", " ", "=", " ", 
   RowBox[{"OpenSQLConnection", "[", " ", "\"\<demo\>\"", "]"}]}], 
  ";"}]}], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[28]:=",
 CellID->11969],

Cell["This creates a table to use for testing.", "Text",
 CellTags->"b:6.4",
 CellID->28978],

Cell[BoxData[{
 RowBox[{
  RowBox[{"table", " ", "=", " ", 
   RowBox[{"SQLTable", "[", "\"\<TEST\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"cols", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<X\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}]}], "]"}], 
     ",", 
     RowBox[{"SQLColumn", "[", 
      RowBox[{"\"\<Y\>\"", ",", " ", 
       RowBox[{"\"\<DataTypeName\>\"", "->", "\"\<Integer\>\""}]}], "]"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLCreateTable", "[", 
   RowBox[{"conn", ",", " ", "table", ",", " ", "cols"}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[30]:=",
 CellID->21617],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["SQLSelect",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSelect"]], "InlineFormula"],
 " to view data in the ",
 StyleBox["TEST",
  FontSlant->"Italic"],
 " table. There is one row."
}], "Text",
 CellTags->"b:6.4",
 CellID->4015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"\"\<ShowColumnHeadings\>\"", "\[Rule]", "True"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[7]:=",
 CellID->16626],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"X\"\>", "\<\"Y\"\>"},
    {"5", "6"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:6.4",
 CellLabel->"Out[7]//TableForm=",
 CellID->3684]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SQLBeginTransaction",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLBeginTransaction"]], 
  "InlineFormula"],
 " is used to start a transaction."
}], "Text",
 CellTags->"b:6.4",
 CellID->9168],

Cell[BoxData[
 RowBox[{"SQLBeginTransaction", "[", "conn", "]"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[8]:=",
 CellID->17906],

Cell["Next, two different insert operations are carried out.", "Text",
 CellTags->"b:6.4",
 CellID->25928],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"61", ",", "80"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"72", ",", "5"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[9]:=",
 CellID->12097],

Cell["This shows that two rows have been inserted.", "Text",
 CellTags->"b:6.4",
 CellID->28118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[11]:=",
 CellID->24390],

Cell[BoxData[
 TagBox[GridBox[{
    {"5", "6"},
    {"61", "80"},
    {"72", "5"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:6.4",
 CellLabel->"Out[11]//TableForm=",
 CellID->15199]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["SQLRollbackTransaction",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLRollbackTransaction"]], 
  "InlineFormula"],
 " is used, the database is returned to the point before the transaction \
began. The two rows are no longer present."
}], "Text",
 CellTags->"b:6.4",
 CellID->11785],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLRollbackTransaction", "[", "conn", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], "//", 
  "TableForm"}]}], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[12]:=",
 CellID->14486],

Cell[BoxData[
 TagBox[GridBox[{
    {"5", "6"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:6.4",
 CellLabel->"Out[13]//TableForm=",
 CellID->19199]
}, Open  ]],

Cell["\<\
A transaction is closed when it is rolled back. If any more transactions are \
required, a new transaction must be started. Here, a new transaction is \
started and the two rows are reinserted.\
\>", "Text",
 CellTags->"b:6.4",
 CellID->12420],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLBeginTransaction", "[", "conn", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"111", ",", " ", "141"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"190", ",", "1"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[14]:=",
 CellID->20710],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["SQLCommitTransaction",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLCommitTransaction"]], 
  "InlineFormula"],
 " to commit the data permanently."
}], "Text",
 CellTags->"b:6.4",
 CellID->18271],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLCommitTransaction", "[", "conn", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], "//", 
  "TableForm"}]}], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[17]:=",
 CellID->15813],

Cell[BoxData[
 TagBox[GridBox[{
    {"5", "6"},
    {"111", "141"},
    {"190", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:6.4",
 CellLabel->"Out[18]//TableForm=",
 CellID->27415]
}, Open  ]],

Cell[TextData[{
 "A transaction is closed when it is committed. If any more transactions are \
required, a new transaction must be started. In addition, once a transaction \
has been committed, it cannot be rolled back. Transactions may be split up \
using an ",
 Cell[BoxData[
  ButtonBox["SQLSavepoint",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLSavepoint"]], "InlineFormula"],
 "; a rollback can be made to a specific savepoint."
}], "Text",
 CellTags->"b:6.4",
 CellID->6085],

Cell["The following begins a transaction and inserts some data.", "Text",
 CellTags->"b:6.4",
 CellID->318],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLBeginTransaction", "[", "conn", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"22", ",", "11"}], "}"}]}], "]"}], ";"}]}], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[19]:=",
 CellID->3580],

Cell["A savepoint is created.", "Text",
 CellTags->"b:6.4",
 CellID->1331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"savepoint", " ", "=", " ", 
  RowBox[{"SQLSetSavepoint", "[", 
   RowBox[{"conn", ",", " ", "\"\<savepoint1\>\""}], "]"}]}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[21]:=",
 CellID->7267],

Cell[BoxData[
 RowBox[{"SQLSavepoint", "[", 
  InterpretationBox[
   RowBox[{
    RowBox[{
    "\[LeftGuillemet]JavaObject", 
     "[", "\<\"org.hsqldb.jdbc.jdbcSavepoint\"\>", "]"}], 
    "\[RightGuillemet]"}],
   JLink`Objects`JavaObject379475191660545], "]"}]], "Output",
 CellTags->"b:6.4",
 CellLabel->"Out[21]=",
 CellID->8387]
}, Open  ]],

Cell["Here some more data is inserted into the database.", "Text",
 CellTags->"b:6.4",
 CellID->13444],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLInsert", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<X\>\"", ",", " ", "\"\<Y\>\""}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"17", ",", "22"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], "//", 
  "TableForm"}]}], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[22]:=",
 CellID->23186],

Cell[BoxData[
 TagBox[GridBox[{
    {"5", "6"},
    {"111", "141"},
    {"190", "1"},
    {"22", "11"},
    {"17", "22"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:6.4",
 CellLabel->"Out[23]//TableForm=",
 CellID->14507]
}, Open  ]],

Cell[TextData[{
 "The transaction is rolled back to the savepoint using ",
 Cell[BoxData[
  ButtonBox["SQLRollbackTransaction",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/SQLRollbackTransaction"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:6.4",
 CellID->4360],

Cell[BoxData[
 RowBox[{"SQLRollbackTransaction", "[", 
  RowBox[{"conn", ",", " ", "savepoint"}], "]"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[24]:=",
 CellID->17827],

Cell["This shows that the last insert has not taken place.", "Text",
 CellTags->"b:6.4",
 CellID->28074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SQLSelect", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[25]:=",
 CellID->26431],

Cell[BoxData[
 TagBox[GridBox[{
    {"5", "6"},
    {"111", "141"},
    {"190", "1"},
    {"22", "11"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellTags->"b:6.4",
 CellLabel->"Out[25]//TableForm=",
 CellID->7152]
}, Open  ]],

Cell[TextData[{
 "This drops the ",
 StyleBox["TEST",
  FontSlant->"Italic"],
 " table and closes the connection."
}], "Text",
 CellTags->"b:6.4",
 CellID->30271],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SQLDropTable", "[", 
   RowBox[{"conn", ",", " ", "\"\<TEST\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"CloseSQLConnection", "[", "conn", "]"}], ";"}]}], "Input",
 CellTags->"b:6.4",
 CellLabel->"In[26]:=",
 CellID->10268],

Cell[CellGroupData[{

Cell["Transaction Isolation", "Section",
 CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
 CellID->200404233],

Cell["\<\
When working with database transactions with more than one concurrent user \
various problems with reading data can occur. These problems are can be \
termed as 'dirty reads', 'non-repeatable reads', and 'phantom reads'. There \
are two types of solution to these problems, one involves setting options for \
the database connection to isolate transactions, and the other involves other \
checks on data or instance by checking timestamps. Each of these strategies \
have advantages and disadvantages, for example, setting database options can \
degrade the performance of the database for concurrent usage.\
\>", "Text",
 CellID->54440545],

Cell[TextData[{
 "The actual details of these strategies are really outside the scope of this \
documentation. However, ",
 StyleBox["DatabaseLink ",
  FontSlant->"Italic"],
 "has a number of ways to set options of the connection to help isolate \
transactions. This is done with the ",
 StyleBox["TransactionIsolationLevel", "MR"],
 " option of",
 " ",
 Cell[BoxData[
  ButtonBox["OpenSQLConnection",
   BaseStyle->"Link",
   ButtonData->"paclet:DatabaseLink/ref/OpenSQLConnection"]], 
  "InlineFormula"],
 ". This option can also be set for an existing connection with ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 "."
}], "Text",
 CellID->241153517],

Cell[BoxData[GridBox[{
   {Cell["setting", "TableHeader"], Cell["description", "TableHeader"]},
   {"ReadUncommitted", Cell["no isolation", "TableText"]},
   {"ReadCommitted", Cell["prevent dirty reads", "TableText"]},
   {"RepeatableRead", Cell[
    "prevent dirty reads and non repeatable reads", "TableText"]},
   {"Serializable", Cell[
    "prevent dirty reads, non repeatable reads, and phantom reads", 
     "TableText"]}
  },
  GridBoxDividers->{
   "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {False, True, {False}, False}, 
    "RowsIndexed" -> {}}]], "DefinitionBox",
 CellID->29385656],

Cell[TextData[{
 "Settings of the ",
 Cell[BoxData["TransactionIsolationLevel"], "InlineFormula"],
 " option."
}], "Caption",
 CellTags->"b:6.4",
 CellID->7293938]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Transactions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 15, 59.1245578}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "DatabaseLink Tutorial", 
    "language" -> "en", "paclet" -> "DatabaseLink", "status" -> "None", 
    "summary" -> 
    "Some database operations involve carrying out a sequence of database \
commands. For example, information in two different tables may need to be \
updated. In these cases it may be very important that if one update is \
carried out, the other is also. If only one is done, it may leave the data \
inconsistent. You can use database transactions to ensure that all the \
operations are carried out. In addition, you can use transactions as a way of \
backing out of the middle of a sequence of operations. This tutorial will \
demonstrate how to use transactions. If you find that the examples in this \
tutorial do not work as shown, you may need to install or restore the example \
database with the DatabaseExamples` package, as described in Using the \
Example Databases. Functions for executing SQL transactions.", 
    "synonyms" -> {}, "title" -> "Transactions", "type" -> "Tutorial", "uri" -> 
    "DatabaseLink/tutorial/Transactions"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "xref:48"->{
  Cell[1588, 50, 94, 2, 70, "Title",
   CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
   CellID->31020],
  Cell[16695, 605, 109, 2, 70, "Section",
   CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
   CellID->200404233]},
 "c:75"->{
  Cell[1588, 50, 94, 2, 70, "Title",
   CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
   CellID->31020],
  Cell[16695, 605, 109, 2, 70, "Section",
   CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
   CellID->200404233]},
 "i:46"->{
  Cell[1588, 50, 94, 2, 70, "Title",
   CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
   CellID->31020],
  Cell[16695, 605, 109, 2, 70, "Section",
   CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
   CellID->200404233]},
 "b:6.4"->{
  Cell[1588, 50, 94, 2, 70, "Title",
   CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
   CellID->31020],
  Cell[1685, 54, 623, 11, 70, "Text",
   CellTags->"b:6.4",
   CellID->23694],
  Cell[3648, 107, 96, 2, 70, "Caption",
   CellTags->"b:6.4",
   CellID->30109],
  Cell[3747, 111, 229, 10, 70, "Text",
   CellTags->"b:6.4",
   CellID->17984],
  Cell[3979, 123, 286, 9, 70, "Input",
   CellTags->"b:6.4",
   CellID->11969],
  Cell[4268, 134, 92, 2, 70, "Text",
   CellTags->"b:6.4",
   CellID->28978],
  Cell[4363, 138, 982, 29, 70, "Input",
   CellTags->"b:6.4",
   CellID->21617],
  Cell[5348, 169, 308, 12, 70, "Text",
   CellTags->"b:6.4",
   CellID->4015],
  Cell[5681, 185, 273, 8, 70, "Input",
   CellTags->"b:6.4",
   CellID->16626],
  Cell[5957, 195, 571, 19, 70, "Output",
   CellTags->"b:6.4",
   CellID->3684],
  Cell[6543, 217, 255, 9, 70, "Text",
   CellTags->"b:6.4",
   CellID->9168],
  Cell[6801, 228, 134, 4, 70, "Input",
   CellTags->"b:6.4",
   CellID->17906],
  Cell[6938, 234, 106, 2, 70, "Text",
   CellTags->"b:6.4",
   CellID->25928],
  Cell[7047, 238, 600, 17, 70, "Input",
   CellTags->"b:6.4",
   CellID->12097],
  Cell[7650, 257, 96, 2, 70, "Text",
   CellTags->"b:6.4",
   CellID->28118],
  Cell[7771, 263, 200, 7, 70, "Input",
   CellTags->"b:6.4",
   CellID->24390],
  Cell[7974, 272, 576, 20, 70, "Output",
   CellTags->"b:6.4",
   CellID->15199],
  Cell[8565, 295, 353, 11, 70, "Text",
   CellTags->"b:6.4",
   CellID->11785],
  Cell[8943, 310, 282, 9, 70, "Input",
   CellTags->"b:6.4",
   CellID->14486],
  Cell[9228, 321, 541, 18, 70, "Output",
   CellTags->"b:6.4",
   CellID->19199],
  Cell[9784, 342, 253, 6, 70, "Text",
   CellTags->"b:6.4",
   CellID->12420],
  Cell[10040, 350, 686, 19, 70, "Input",
   CellTags->"b:6.4",
   CellID->20710],
  Cell[10729, 371, 273, 10, 70, "Text",
   CellTags->"b:6.4",
   CellID->18271],
  Cell[11027, 385, 280, 9, 70, "Input",
   CellTags->"b:6.4",
   CellID->15813],
  Cell[11310, 396, 579, 20, 70, "Output",
   CellTags->"b:6.4",
   CellID->27415],
  Cell[11904, 419, 502, 12, 70, "Text",
   CellTags->"b:6.4",
   CellID->6085],
  Cell[12409, 433, 107, 2, 70, "Text",
   CellTags->"b:6.4",
   CellID->318],
  Cell[12519, 437, 416, 12, 70, "Input",
   CellTags->"b:6.4",
   CellID->3580],
  Cell[12938, 451, 74, 2, 70, "Text",
   CellTags->"b:6.4",
   CellID->1331],
  Cell[13037, 457, 217, 6, 70, "Input",
   CellTags->"b:6.4",
   CellID->7267],
  Cell[13257, 465, 333, 11, 70, "Output",
   CellTags->"b:6.4",
   CellID->8387],
  Cell[13605, 479, 102, 2, 70, "Text",
   CellTags->"b:6.4",
   CellID->13444],
  Cell[13732, 485, 464, 14, 70, "Input",
   CellTags->"b:6.4",
   CellID->23186],
  Cell[14199, 501, 615, 22, 70, "Output",
   CellTags->"b:6.4",
   CellID->14507],
  Cell[14829, 526, 289, 10, 70, "Text",
   CellTags->"b:6.4",
   CellID->4360],
  Cell[15121, 538, 174, 5, 70, "Input",
   CellTags->"b:6.4",
   CellID->17827],
  Cell[15298, 545, 104, 2, 70, "Text",
   CellTags->"b:6.4",
   CellID->28074],
  Cell[15427, 551, 200, 7, 70, "Input",
   CellTags->"b:6.4",
   CellID->26431],
  Cell[15630, 560, 596, 21, 70, "Output",
   CellTags->"b:6.4",
   CellID->7152],
  Cell[16241, 584, 162, 7, 70, "Text",
   CellTags->"b:6.4",
   CellID->30271],
  Cell[16406, 593, 264, 8, 70, "Input",
   CellTags->"b:6.4",
   CellID->10268],
  Cell[16695, 605, 109, 2, 70, "Section",
   CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
   CellID->200404233],
  Cell[18814, 661, 163, 6, 70, "Caption",
   CellTags->"b:6.4",
   CellID->7293938]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"xref:48", 21084, 716},
 {"c:75", 21319, 723},
 {"i:46", 21554, 730},
 {"b:6.4", 21790, 737}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 963, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1588, 50, 94, 2, 70, "Title",
 CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
 CellID->31020],
Cell[1685, 54, 623, 11, 70, "Text",
 CellTags->"b:6.4",
 CellID->23694],
Cell[2311, 67, 443, 11, 70, "Text",
 CellID->15529],
Cell[2757, 80, 888, 25, 70, "DefinitionBox",
 CellID->14788],
Cell[3648, 107, 96, 2, 70, "Caption",
 CellTags->"b:6.4",
 CellID->30109],
Cell[3747, 111, 229, 10, 70, "Text",
 CellTags->"b:6.4",
 CellID->17984],
Cell[3979, 123, 286, 9, 70, "Input",
 CellTags->"b:6.4",
 CellID->11969],
Cell[4268, 134, 92, 2, 70, "Text",
 CellTags->"b:6.4",
 CellID->28978],
Cell[4363, 138, 982, 29, 70, "Input",
 CellTags->"b:6.4",
 CellID->21617],
Cell[5348, 169, 308, 12, 70, "Text",
 CellTags->"b:6.4",
 CellID->4015],
Cell[CellGroupData[{
Cell[5681, 185, 273, 8, 70, "Input",
 CellTags->"b:6.4",
 CellID->16626],
Cell[5957, 195, 571, 19, 70, "Output",
 CellTags->"b:6.4",
 CellID->3684]
}, Open  ]],
Cell[6543, 217, 255, 9, 70, "Text",
 CellTags->"b:6.4",
 CellID->9168],
Cell[6801, 228, 134, 4, 70, "Input",
 CellTags->"b:6.4",
 CellID->17906],
Cell[6938, 234, 106, 2, 70, "Text",
 CellTags->"b:6.4",
 CellID->25928],
Cell[7047, 238, 600, 17, 70, "Input",
 CellTags->"b:6.4",
 CellID->12097],
Cell[7650, 257, 96, 2, 70, "Text",
 CellTags->"b:6.4",
 CellID->28118],
Cell[CellGroupData[{
Cell[7771, 263, 200, 7, 70, "Input",
 CellTags->"b:6.4",
 CellID->24390],
Cell[7974, 272, 576, 20, 70, "Output",
 CellTags->"b:6.4",
 CellID->15199]
}, Open  ]],
Cell[8565, 295, 353, 11, 70, "Text",
 CellTags->"b:6.4",
 CellID->11785],
Cell[CellGroupData[{
Cell[8943, 310, 282, 9, 70, "Input",
 CellTags->"b:6.4",
 CellID->14486],
Cell[9228, 321, 541, 18, 70, "Output",
 CellTags->"b:6.4",
 CellID->19199]
}, Open  ]],
Cell[9784, 342, 253, 6, 70, "Text",
 CellTags->"b:6.4",
 CellID->12420],
Cell[10040, 350, 686, 19, 70, "Input",
 CellTags->"b:6.4",
 CellID->20710],
Cell[10729, 371, 273, 10, 70, "Text",
 CellTags->"b:6.4",
 CellID->18271],
Cell[CellGroupData[{
Cell[11027, 385, 280, 9, 70, "Input",
 CellTags->"b:6.4",
 CellID->15813],
Cell[11310, 396, 579, 20, 70, "Output",
 CellTags->"b:6.4",
 CellID->27415]
}, Open  ]],
Cell[11904, 419, 502, 12, 70, "Text",
 CellTags->"b:6.4",
 CellID->6085],
Cell[12409, 433, 107, 2, 70, "Text",
 CellTags->"b:6.4",
 CellID->318],
Cell[12519, 437, 416, 12, 70, "Input",
 CellTags->"b:6.4",
 CellID->3580],
Cell[12938, 451, 74, 2, 70, "Text",
 CellTags->"b:6.4",
 CellID->1331],
Cell[CellGroupData[{
Cell[13037, 457, 217, 6, 70, "Input",
 CellTags->"b:6.4",
 CellID->7267],
Cell[13257, 465, 333, 11, 70, "Output",
 CellTags->"b:6.4",
 CellID->8387]
}, Open  ]],
Cell[13605, 479, 102, 2, 70, "Text",
 CellTags->"b:6.4",
 CellID->13444],
Cell[CellGroupData[{
Cell[13732, 485, 464, 14, 70, "Input",
 CellTags->"b:6.4",
 CellID->23186],
Cell[14199, 501, 615, 22, 70, "Output",
 CellTags->"b:6.4",
 CellID->14507]
}, Open  ]],
Cell[14829, 526, 289, 10, 70, "Text",
 CellTags->"b:6.4",
 CellID->4360],
Cell[15121, 538, 174, 5, 70, "Input",
 CellTags->"b:6.4",
 CellID->17827],
Cell[15298, 545, 104, 2, 70, "Text",
 CellTags->"b:6.4",
 CellID->28074],
Cell[CellGroupData[{
Cell[15427, 551, 200, 7, 70, "Input",
 CellTags->"b:6.4",
 CellID->26431],
Cell[15630, 560, 596, 21, 70, "Output",
 CellTags->"b:6.4",
 CellID->7152]
}, Open  ]],
Cell[16241, 584, 162, 7, 70, "Text",
 CellTags->"b:6.4",
 CellID->30271],
Cell[16406, 593, 264, 8, 70, "Input",
 CellTags->"b:6.4",
 CellID->10268],
Cell[CellGroupData[{
Cell[16695, 605, 109, 2, 70, "Section",
 CellTags->{"xref:48", "c:75", "i:46", "b:6.4"},
 CellID->200404233],
Cell[16807, 609, 650, 10, 70, "Text",
 CellID->54440545],
Cell[17460, 621, 733, 22, 70, "Text",
 CellID->241153517],
Cell[18196, 645, 615, 14, 70, "DefinitionBox",
 CellID->29385656],
Cell[18814, 661, 163, 6, 70, "Caption",
 CellTags->"b:6.4",
 CellID->7293938]
}, Open  ]]
}, Open  ]],
Cell[19004, 671, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

