
Widget["Wizard", 
  {
  
    Script[
    	Needs["DatabaseLink`"];
    ],
    Script[
    	getJDBCNames[] :=
    		Module[ {list},
    			list = Sort[JDBCDriverNames[]];
    			list /. {"hsqldb", y__} -> {y, "hsqldb"}
    		];
    	getUsername[ username_] :=
    		If[ username === "", None, username]
    ],
       
    "title" -> "Data Source Wizard",
    "sideBarTitle" -> "Steps",
    
    "pages" -> {
  
    Widget["WizardPage", {
      "title" -> "Overview",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "content" -> Widget["WizardHTMLPanel", {
        "text" -> "This wizard helps create a reusable data source for use with DatabaseLink.<p>Some information about the data source is required to use this wizard.<ul><li>Type of the database</li><li>Location of the database</li><li>Username to use to Connect to Database.</li></ul></p><p>Many types of databases are preconfigured within this wizard to contain custom wizard pages to make it easier to configure a data source.  However, if a type of database is not listed, one may be added using this wizard.</p>"
          }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "<b>1. Overview</b><p>2. Specify Name and Description<p>3. Specify Visibility<p>4. Select Type of Database<p>5. Connect to Database<p>6. Specify Connection Properties"
          }]
      }, Name -> "overviewPage"],
      
    Widget["WizardPage", {
      "title" -> "Name and Description",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          ValidateNameSourcePage[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify the name."}, Name-> "nameHTMLPanel"],
        Widget["TextField", {
          "text" -> "",
          "toolTipText"->"The name is used to uniquely identify a data source.",
          PropertyValue[{"nameField", "document"}, Name -> "nameFieldDocument"],
          BindEvent[{"nameFieldDocument", "document"},
            Script[ ValidateNameSourcePage[];]],
          BindEvent["action", 
           Script[ ValidateNameSourcePage[];]]
        }, Name -> "nameField"],
        Widget["WizardHTMLPanel", {
          "text" -> "Specify the description."}],
        Widget["TextArea", {
          "text" -> "",
          "toolTipText"->"The description is used to further describe the data source."
        }, Name -> "descriptionField", WidgetLayout->{"Border"->""}],
        Widget["WizardHTMLPanel", {
          "text" -> "After specifying the name and description, choose 'Next' to select the select the visibility of the configuration."}, 
          Name->"nameContinueHTMLPanel"]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p><b>2. Specify Name and Description</b><p>3. Specify Visibility<p>4. Select Type of Database<p>5. Connect to Database<p>6. Specify Connection Properties"
          }]
      }, Name -> "nameChoicePage"],
            
    Widget["WizardPage", {
      "title" -> "Specify Visibility",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Please specify the visibility of the data source configuration."}],
        {
          Widget["RadioButton", 
          {
            "text"->"User Level",
            "selected"->True,
            BindEvent["action", 
              Script[ 
                SetPropertyValue[{"storeConfigSystemRadioButton", "selected"}, 
                  !PropertyValue[{"storeConfigUserRadioButton", "selected"}]];
              ]
            ]
            
          }, Name->"storeConfigUserRadioButton"],
          Widget["RadioButton", 
          {
            "text"->"System Level",
            "selected"->False,
            BindEvent["action", 
              Script[ 
                SetPropertyValue[{"storeConfigUserRadioButton", "selected"}, 
                  !PropertyValue[{"storeConfigSystemRadioButton", "selected"}]];
              ]
            ]
          }, Name->"storeConfigSystemRadioButton"]
        },
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the visibility of the data source configuration, choose 'Next' to select the type of database."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p><b>3. Specify Visibility</b><p>4. Select Type of Database<p>5. Connect to Database<p>6. Specify Connection Properties"
          }]
      }, Name -> "saveLocationPage"],

    Widget["WizardPage", {
      "title" -> "Type of Database",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          UpdateDatabaseField[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Select the type of database."}],
        Widget["ComboBox", {"editable" -> False, 
                            "autoComplete"->False,
                            "preferredSize"->Widget["Dimension", {"width" -> 290, "height" -> 25}],
                            "items" ->Script[getJDBCNames[]]
                           }, 
                           Name -> "databaseField"],
        Widget["TextArea", {
          "text" -> "",
          "editable"->False,
          "lineWrap"->True,
          "wrapStyleWord"->True
        }, Name -> "typeDescriptionField", WidgetLayout->{"Border"->""}],
        {
          Widget["Button", {
            "text"->"New", 
            "toolTipText"->"Click 'New' to create a new configuration for a type of database."
          }, Name -> "databaseNewButton"],
          Widget["Button", {
            "text"->"Edit",
            "toolTipText"->"Click 'Edit' to edit the configuration for a type of database."
          }, Name -> "databasePropertiesButton"]
        },
        Widget["WizardHTMLPanel", {
          "text" -> "After choosing the type of database, choose 'Next' to specify the location."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Visibility<p><b>4. Select Type of Database</b><p>5. Connect to Database<p>6. Specify Connection Properties"
          }]
      }, Name -> "databaseChoicePage"],   
      
    Widget["WizardPage", {
      "title" -> "Driver Missing!",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      BindEvent["pageWillActivate", 
        Script[
          ValidateLoadDriverPage[];
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Please specify the location of the jar containing the database driver: "}],
        Widget["Label", Name->"loadDriverName"],
        {
          Widget["TextField", {
            "text" -> "",
            "toolTipText"->"The name is used to uniquely identify a data source.",
            PropertyValue[{"loadDriverField", "document"}, Name -> "loadDriverFieldDocument"],
            BindEvent[{"loadDriverFieldDocument", "document"},
              Script[ ValidateInstallDriverButton[];]],
            BindEvent["action", 
              Script[ ValidateInstallDriverButton[];]]
          }, Name -> "loadDriverField"],
          Widget["Button", {"text" -> "Browse...",
            BindEvent["action", 
              Script[ BrowseDriverFilename[]; ValidateInstallDriverButton[]; ]]
          }]
        },
        Widget["WizardHTMLPanel", {
          "text" -> "Please specify where to install the driver."}],
        {
          Widget["RadioButton", 
          {
            "text"->"User Level",
            "selected"->True,
            BindEvent["action", 
              Script[ 
                SetPropertyValue[{"loadDriverSystemRadioButton", "selected"}, 
                  !PropertyValue[{"loadDriverUserRadioButton", "selected"}]];
              ]
            ]
            
          }, Name->"loadDriverUserRadioButton"],
          Widget["RadioButton", 
          {
            "text"->"System Level",
            "selected"->False,
            BindEvent["action", 
              Script[ 
                SetPropertyValue[{"loadDriverUserRadioButton", "selected"}, 
                  !PropertyValue[{"loadDriverSystemRadioButton", "selected"}]];
              ]
            ]
          }, Name->"loadDriverSystemRadioButton"]
        },
        {
          Widget["Button", 
          {
            "text"->"Install",
            "enabled"->False,
            BindEvent["action",
              Script[ InstallDriver[]; ValidateLoadDriverPage[]; ]]
          }, Name->"loadDriverButton"]
        },
        Widget["WizardHTMLPanel", {
          "text" -> "After specifying the location of the driver, choose 'Next' to specify the location of the database."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Visibility<p><b>4. Select Type of Database</b><p>5. Connect to Database<p>6. Specify Connection Properties"
          }]
      }, Name -> "loadDriverPage"],   

    Widget["WizardPage", {
      "title" -> "Database Location",
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "previousPage" -> WidgetReference["databaseChoicePage"],
      BindEvent["pageWillActivate", 
        Script[
          ValidateDefaultLocationPage[];       
          SetPropertyValue[{"propertiesChoicePage", "previousPage"}, WidgetReference["defaultLocationPage"]];             
        ]
      ],
      BindEvent["pageWillDeactivate", 
        Script[
          ValidateDefaultLocationPage[];       
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify how to connect to the database."}],
        WidgetGroup[
        {        
          {
            Widget["Label", {
              "text" -> "URL"}],
            Widget["TextField", {
              "text" -> "",
              "toolTipText"->"See the documentation for your JDBC driver to find out what the URL should look like.",
              PropertyValue[{"defaultLocationField", "document"}, Name -> "defaultLocationFieldDocument"],
              BindEvent[{"defaultLocationFieldDocument", "document"},
                Script[ ValidateDefaultLocationPage[];]],
              BindEvent["action", 
                Script[ ValidateDefaultLocationPage[];]]
            }, Name -> "defaultLocationField"]
          },
          {
            Widget["Label", {"text"->"Username"}],
            Widget["TextField", {"text"->""}, Name-> "defaultUsernameField"]
          },
          {
            Widget["Label", {"text"->"Password"}],
            Widget["PasswordField", {"text"->""}, Name-> "defaultPasswordField"]
          },
          {
            Widget["Button", {
              "text"->"Test",
              BindEvent["action",
                Script[ 
                  ValidateDefaultLocationPage[];
                  $error = Null;
                  Block[{$MessagePrePrint = ($error = #)&, $Messages = {}}, 
                    conn = OpenSQLConnection[JDBC[PropertyValue[{"databaseField", "selectedItem"}], $url],
                      Username -> getUsername[$username], Password -> $password];
                  ];
                  If[$error === Null, 
                    SetPropertyValue[{"defaultTestLabel", "text"}, " Test Successful!"],
                    SetPropertyValue[{"defaultTestLabel", "text"}, " Error: " <> ToString[$error]]
                  ];
                  CloseSQLConnection[conn];
                ]
              ]              
            }, Name->"defaultTestButton"],
            Widget["Label", Name->"defaultTestLabel"]
          }
        }, WidgetLayout->Grid],
        Widget["WizardHTMLPanel", {
          "text" -> "<p>After specifying the URL, choose 'Next' to specify connection properties."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Visibility<p>4. Select Type of Database<p><b>5. Connect to Database</b><p>6. Specify Connection Properties"
          }]
      }, Name -> "defaultLocationPage"],
      
    Widget["WizardPage", {
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "previousPage" -> WidgetReference["databaseChoicePage"],
      BindEvent["pageWillActivate", 
        Script[
          ValidateFileLocationPage[];
          SetPropertyValue[{"propertiesChoicePage", "previousPage"}, WidgetReference["fileLocationPage"]];
        ]
      ],
      BindEvent["pageWillDeactivate", 
        Script[
          ValidateFileLocationPage[];       
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify how to connect to the database."}],
        WidgetGroup[
        {        
          {
            Widget["Label", {
              "text" -> "Database File"}],          
            Widget["Panel", {
              {
                Widget["TextField", {
                  "text" -> "",
                  PropertyValue[{"fileLocationField", "document"}, Name -> "hsqldbLocationDocument"],
                  BindEvent[{"hsqldbLocationDocument", "document"},
                    Script[ ValidateFileLocationPage[];]],
                  BindEvent["action", 
                    Script[ ValidateFileLocationPage[];]]
                }, Name -> "fileLocationField"],
                Widget["Button", {"text" -> "Browse...",
                  BindEvent["action", 
                    Script[ BrowseFilename[]; ValidateFileLocationPage[]; ]]
                }]
              }
            }]
          },
          {
            Widget["Label", {
              "text" -> "Relative Path"}],          
            Widget["CheckBox", {
              "toolTipText"->"Select this to signify the path to the database files is relative to the location of the data source configuration file.",
              BindEvent["action", 
                Script[ ValidateFileLocationPage[];]]          
            }, Name -> "fileLocationRelativePathCheckBox"]
          }, 
          {
            Widget["Label", {"text"->"Username"}],
            Widget["TextField", {"text"->""}, Name-> "fileUsernameField"]
          },
          {
            Widget["Label", {"text"->"Password"}],
            Widget["PasswordField", {"text"->""}, Name-> "filePasswordField"]
          },
          {
            Widget["Button", {
              "text"->"Test",
              BindEvent["action",
                Script[ 
                  ValidateFileLocationPage[];
                  $error = Null;
                  Block[{$MessagePrePrint = ($error = #)&, $Messages = {}, file}, 
                    If[PropertyValue[{"storeConfigUserRadioButton", "selected"}], 
                      file = ToFileName[{$UserBaseDirectory, "DatabaseResources"}, "Test.m"],
                      file = ToFileName[{$BaseDirectory, "DatabaseResources"}, "Test.m"]
                    ]; 
                    conn = OpenSQLConnection[JDBC[PropertyValue[{"databaseField", "selectedItem"}], $url],
                      Username -> getUsername[$username], Password -> $password, RelativePath->TrueQ[$relativePath], Location->file];
                  ];
                  If[$error === Null, 
                    SetPropertyValue[{"fileTestLabel", "text"}, " Test Successful!"],
                    SetPropertyValue[{"fileTestLabel", "text"}, " Error: " <> ToString[$error]]
                  ];
                  CloseSQLConnection[conn];
                ]
              ]              
            }, Name->"fileTestButton"],
            Widget["Label", Name->"fileTestLabel"]
          }          
        }, WidgetLayout->Grid],          
        Widget["WizardHTMLPanel", {
          "text" -> "<p>After specifying the location, choose 'Next' to specify connection properties."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Visibility<p>4. Select Type of Database<p><b>5. Connect to Database</b><p>6. Specify Connection Properties"
          }]
      }, Name -> "fileLocationPage"],   
      
    Widget["WizardPage", {
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "previousPage" -> WidgetReference["databaseChoicePage"],
      BindEvent["pageWillActivate", 
        Script[
          ValidateNamedLocationPage[];       
          SetPropertyValue[{"propertiesChoicePage", "previousPage"}, WidgetReference["namedLocationPage"]];             
        ]
      ],
      BindEvent["pageWillDeactivate", 
        Script[
          ValidateNamedLocationPage[];       
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify how to connect to the database."}],
        WidgetGroup[
        {        
          {
            Widget["Label", {
              "text" -> "Database"}],          
            Widget["TextField", {
              "text" -> "",
              PropertyValue[{"namedLocationField", "document"}, Name -> "namedLocationFieldDocument"],
              BindEvent[{"namedLocationFieldDocument", "document"},
                Script[ ValidateNamedLocationPage[];]],
              BindEvent["action", 
                Script[ ValidateNamedLocationPage[];]]
            }, Name -> "namedLocationField"]
          },
          {
            Widget["Label", {"text"->"Username"}],
            Widget["TextField", {"text"->""}, Name-> "namedUsernameField"]
          },
          {
            Widget["Label", {"text"->"Password"}],
            Widget["PasswordField", {"text"->""}, Name-> "namedPasswordField"]
          },
          {
            Widget["Button", {
              "text"->"Test",
              BindEvent["action",
                Script[ 
                  ValidateNamedLocationPage[];
                  $error = Null;
                  Block[{$MessagePrePrint = ($error = #)&, $Messages = {}}, 
                    conn = OpenSQLConnection[JDBC[PropertyValue[{"databaseField", "selectedItem"}], $url],
                      Username -> getUsername[$username], Password -> $password];
                  ];
                  If[$error === Null, 
                    SetPropertyValue[{"namedTestLabel", "text"}, " Test Successful!"],
                    SetPropertyValue[{"namedTestLabel", "text"}, " Error: " <> ToString[$error]]
                  ];
                  CloseSQLConnection[conn];
                ]
              ]              
            }, Name->"namedTestButton"],
            Widget["Label", Name->"namedTestLabel"]
          }
        }, WidgetLayout->Grid],          
        Widget["WizardHTMLPanel", {
          "text" -> "<p>After specifying the name of the database, choose 'Next' to specify connection properties."}]
      }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Visibility<p>4. Select Type of Database<p><b>5. Connect to Database</b><p>6. Specify Connection Properties"
          }]
      }, Name -> "namedLocationPage"],

    Widget["WizardPage", {
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "previousPage" -> WidgetReference["databaseChoicePage"],
      BindEvent["pageWillActivate", 
        Script[
          ValidateServerLocationPage[];       
          SetPropertyValue[{"propertiesChoicePage", "previousPage"}, WidgetReference["serverLocationPage"]];             
        ]
      ],
      BindEvent["pageWillDeactivate", 
        Script[
          ValidateServerLocationPage[];       
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify how to connect to the database."}],
        WidgetGroup[
        {        
          {
            Widget["Label", {
              "text" -> "Hostname"}],
            Widget["TextField", {
              "text" -> "",
              "toolTipText" -> "The hostname of the database server.",
              PropertyValue[{"serverLocationNameField", "document"}, Name -> "serverLocationNameFieldDocument"],
              BindEvent[{"serverLocationNameFieldDocument", "document"},
                Script[ ValidateServerLocationPage[];]],
              BindEvent["action", 
                Script[ ValidateServerLocationPage[];]]
            }, Name -> "serverLocationNameField"]
          },
          {
            Widget["Label", {
              "text" -> "Port"}],
            Widget["TextField", {
              "text" -> "",
              "toolTipText" -> "The port of the database server.",
              PropertyValue[{"serverLocationPortField", "document"}, Name -> "serverLocationPortFieldDocument"],
              BindEvent[{"serverLocationPortFieldDocument", "document"},
                Script[ ValidateServerLocationPage[];]],
              BindEvent["action", 
                Script[ ValidateServerLocationPage[];]]
            }, Name -> "serverLocationPortField"]
          },
          {
            Widget["Label", {"text"->"Username"}],
            Widget["TextField", {"text"->""}, Name-> "serverUsernameField"]
          },
          {
            Widget["Label", {"text"->"Password"}],
            Widget["PasswordField", {"text"->""}, Name-> "serverPasswordField"]
          },
          {
            Widget["Label", {
              "text" -> "Database"}],
            Widget["ComboBox", {
              "autoComplete"->False,
              "editable"->True,
              "toolTipText" -> "The database to use once connected.",
              BindEvent["popupMenuWillBecomeVisible", 
                Script[ 
                  Block[{conn, catalogs = {}, txt, txt2, url, username, password},
                    txt = PropertyValue[{"serverLocationNameField", "text"}];
                    txt2 = PropertyValue[{"serverLocationPortField", "text"}];
                    If[ TrueQ[txt =!= ""] && (TrueQ[txt2 === ""] || DigitQ[txt2]),
                      url = txt;
                      If[txt2 =!= "", url = url <> ":" <> txt2];
                      url = url <> "/";
                      username = PropertyValue[{"serverUsernameField", "text"}];
                      password = PropertyValue[{"serverPasswordField", "text"}];
                      Off[JDBC::error]; 
                      conn = OpenSQLConnection[JDBC[PropertyValue[{"databaseField", "selectedItem"}], url],
                        Username -> username, Password -> password];
                      catalogs = SQLCatalogNames[conn];
                      On[JDBC::error];
                      If[!ListQ[catalogs], catalogs = {}];
                    ];
                    SetPropertyValue[{"serverLocationDatabaseField", "items"}, Prepend[catalogs,""]];
                  ];
                ]
              ]
            }, Name -> "serverLocationDatabaseField"]
          },
          {
            Widget["Button", {
              "text"->"Test",
              BindEvent["action",
                Script[ 
                  ValidateServerLocationPage[];
                  $error = Null;
                  Block[{$MessagePrePrint = ($error = #)&, $Messages = {}}, 
                    conn = OpenSQLConnection[JDBC[PropertyValue[{"databaseField", "selectedItem"}], $url],
                      Username -> getUsername[$username], Password -> $password];
                  ];
                  If[$error === Null, 
                    SetPropertyValue[{"serverTestLabel", "text"}, " Test Successful!"],
                    SetPropertyValue[{"serverTestLabel", "text"}, " Error: " <> ToString[$error]]
                  ];
                  CloseSQLConnection[conn];
                ]
              ]              
            }, Name->"serverTestButton"],
            Widget["Label", Name->"serverTestLabel"]
          }
        }, WidgetLayout->Grid],
        Widget["WizardHTMLPanel", {
          "text" -> "After specifying the location of the database, choose 'Next' to specify connection properties."}]
      }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Visibility<p>4. Select Type of Database<p><b>5. Connect to Database</b><p>6. Specify Connection Properties"
          }]
      }, Name -> "serverLocationPage"],

    Widget["WizardPage", {
      "navigationNames" -> {"Back", "Next", "Cancel"},
      "previousPage" -> WidgetReference["databaseChoicePage"],
      BindEvent["pageWillActivate", 
        Script[
          ValidateODBCLocationPage[];       
          SetPropertyValue[{"propertiesChoicePage", "previousPage"}, WidgetReference["odbcLocationPage"]];             
        ]
      ],
      BindEvent["pageWillDeactivate", 
        Script[
          ValidateODBCLocationPage[];       
        ]
      ],
      "content" -> Widget["Panel", {
        Widget["WizardHTMLPanel", {
          "text" -> "Specify how to connect to the database."}],
        WidgetGroup[{
          {
            Widget["Label", {"text"->"DSN"}],
            Widget["TextField", {
              "text" -> "",
              "toolTipText" -> "Attributes may be added by following the DSN using <data-source-name>[;<attribute-name>=<attribute-value>]*",
              PropertyValue[{"odbcLocationField", "document"}, Name -> "odbcLocationFieldDocument"],
              BindEvent[{"odbcLocationFieldDocument", "document"},
                Script[ ValidateODBCLocationPage[];]],
              BindEvent["action", 
                Script[ ValidateODBCLocationPage[];]]
            }, Name -> "odbcLocationField"]
          },
          {
            Widget["Label", {"text"->"Username"}],
            Widget["TextField", {"text"->""}, Name-> "odbcUsernameField"]
          },
          {
            Widget["Label", {"text"->"Password"}],
            Widget["PasswordField", {"text"->""}, Name-> "odbcPasswordField"]
          },
          {
            Widget["Button", {
              "text"->"Test",
              BindEvent["action",
                Script[ 
                  ValidateODBCLocationPage[];
                  $error = Null;
                  Block[{$MessagePrePrint = ($error = #)&, $Messages = {}}, 
                    conn = OpenSQLConnection[JDBC[PropertyValue[{"databaseField", "selectedItem"}], $url],
                      Username -> getUsername[$username], Password -> $password];
                  ];
                  If[$error === Null, 
                    SetPropertyValue[{"odbcTestLabel", "text"}, " Test Successful!"],
                    SetPropertyValue[{"odbcTestLabel", "text"}, " Error: " <> ToString[$error]]
                  ];
                  CloseSQLConnection[conn];
                ]
              ]              
            }, Name->"odbcTestButton"],
            Widget["Label", Name->"odbcTestLabel"]
          }          
        }, WidgetLayout->Grid], 
        Widget["WizardHTMLPanel", {
          "text" -> "<p>After specifying the name of the database, choose 'Next' to specify connection properties."}]
      }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Visibility<p>4. Select Type of Database<p><b>5. Connect to Database</b><p>6. Specify Connection Properties"
          }]
      }, Name -> "odbcLocationPage"],

    Widget["WizardPage", {
      "title" -> "Connection Properties",
      "navigationNames" -> {"Back", "Finish", "Cancel"},
      "content" -> Widget["Panel", {
        Widget["CheckBox", {
          "text" -> "Store the password in plain text.",
          "toolTipText"->"The user will be prompted if not checked."
        }, Name -> "storeCheckBox"],        
        Widget["CheckBox", {
          "text" -> "Use a connection pool.",
          "toolTipText"->"A connection will be created each time OpenSQLConnection is called if not checked.",
          "selected"-> False
        }, Name -> "connectionPoolCheckBox"], 
        Widget["CheckBox", {
          "text" -> "Use a read only connection.",
          "toolTipText"->"The connection will be read only if checked."
        }, Name -> "readOnlyCheckBox"], 
        WidgetGroup[{{
          Widget["ComboBox", {
            "toolTipText"->"The default transaction isolation level is ReadUncommited.",
            "editable" -> False, 
            "autoComplete"->False,
            "items" ->{"ReadUncommitted", "ReadCommitted", "RepeatableRead", "Serializable"}
          }, Name -> "transactionIsolationLevelField"],
          Widget["WizardHTMLPanel", {
            "text" -> "Select a transaction isolation level."}]
        }}, WidgetLayout->Grid],
        WidgetGroup[{{
          Widget["TextField", {
            "text" -> "",
            "toolTipText"->"The catalog is optional."
          }, Name -> "catalogField"],
          Widget["WizardHTMLPanel", {
           "text" -> "Provide a catalog."}]
        }}, WidgetLayout->Grid],
        Widget["ScrollPane", {
          "preferredSize" -> Widget["Dimension", {"width" -> 500, "height" -> 500}],
          "viewportView" -> 
            Widget["Table", {
              "columnSelectionAllowed"->True,
              PropertyValue["selectionModel", Name -> "propertiesTableSelectionModel"],
              PropertyValue["model", Name-> "propertiesTableModel"],
              InvokeMethod[{"propertiesTableModel", "addColumn"}, "Name"],
              InvokeMethod[{"propertiesTableModel", "addColumn"}, "Value"]
            }, Name->"propertiesTable"]          
        }, WidgetLayout -> {"Stretching" -> Automatic}],   
        {
          Widget["Button", {
            "text"->"Add Property",
              BindEvent["action",
                Script[ 
                  InvokeMethod[{"propertiesTableModel", "addRow"}, {MakeJavaObject[""], MakeJavaObject[""]}];
                ]
              ]              
            }],        
          Widget["Button", {
            "text"->"Remove Property",
              BindEvent["action",
                Script[ 
                  If[PropertyValue[{"propertiesTable", "selectedRow"}] >= 0, 
                    InvokeMethod[{"propertiesTableModel", "removeRow"}, PropertyValue[{"propertiesTable", "selectedRow"}]];
                  ]
                ]
              ]              
            }]       
        }, 
        {
          Widget["Button", {
            "text"->"Test",
            BindEvent["action",
              Script[ 
                Module[{conn, ucp, ro, til, cat, props},
                  ucp = PropertyValue[{"connectionPoolCheckBox", "selected"}];
                  ro = PropertyValue[{"readOnlyCheckBox", "selected"}];
                  til = PropertyValue[{"transactionIsolationLevelField", "selectedItem"}];
                  cat = PropertyValue[{"catalogField", "text"}];
                  props = PropertyValue[{"propertiesTable", "items"}];
                  props = Rule @@ # & /@ props;
                  
                  $error = Null;
                  Block[{$MessagePrePrint = ($error = #)&, $Messages = {}}, 
                    conn = OpenSQLConnection[JDBC[PropertyValue[{"databaseField", "selectedItem"}], $url],
                      Username -> getUsername[$username], 
                      	Password -> $password,
                      "UseConnectionPool"->ucp,
                      "ReadOnly"->ro,
                      "TransactionIsolationLevel"->til,
                      "Catalog"->cat,
                      "Properties"->props
                    ];
                  ];
                  If[$error === Null, 
                    SetPropertyValue[{"propertiesTestLabel", "text"}, " Test Successful!"],
                    SetPropertyValue[{"propertiesTestLabel", "text"}, " Error: " <> ToString[$error]]
                  ];
                  CloseSQLConnection[conn];
                ];
              ]
            ]              
          }, Name->"propertiesTestButton"],
          Widget["Label", Name->"propertiesTestLabel"]
        },          
        Widget["WizardHTMLPanel", {
          "text" -> "After specifying the connection properties, choose 'Finish' to save the data source configuration."}]
        }],
      "sideBarContent" -> Widget["WizardHTMLPanel", {
          "text" -> "1. Overview<p>2. Specify Name and Description<p>3. Specify Visibility<p>4. Select Type of Database<p>5. Connect to Database<p><b>6. Specify Connection Properties</b>"
          }]
      }, Name -> "propertiesChoicePage"]      
  },
  Script[

    jdbcDriverDialog = Null;
    jdbcDriverWizardDialog = Null;
    successDialog = Null;
    errorDialog = Null;

    ValidateNameSourcePage[] := 
      Module[{txt, isValid = False},
        txt = PropertyValue[{"nameField", "text"}];
        If[ TrueQ[txt =!= ""],
          If[MemberQ[DataSourceNames[], txt],
            SetPropertyValue[{"nameHTMLPanel", "text"}, "Specify the name.  <i>A data source with this name already exists.</i>"];
            SetPropertyValue[{"nameContinueHTMLPanel", "text"}, "After specifying the name and description, choose 'Next' to select the visibility of the configuration. <i>Continuing will eventually overwrite existing settings.</i>"]
            , 
            SetPropertyValue[{"nameHTMLPanel", "text"}, "Specify the name."];
            SetPropertyValue[{"nameContinueHTMLPanel", "text"}, "After specifying the name and description, choose 'Next' to select the visibility of the configuration."]
          ];
          isValid = True;
        ];
        SetPropertyValue[{"nameChoicePage", "allowNext"}, isValid];
      ];

    ValidateLoadDriverPage[] :=
      Module[{isValid = False, loaded, driver = PropertyValue[{"loadDriverName", "text"}]},
          Off[Java::"excptn"];
          Off[LoadJavaClass::"fail"];
          loaded = LoadJavaClass[driver];
          On[Java::"excptn"];
          On[LoadJavaClass::"fail"];
          If[ loaded =!= $Failed,
            isValid = True;
          ];
          SetPropertyValue[{"loadDriverPage", "allowNext"}, isValid];
      ];
    
    ValidateInstallDriverButton[] := 
      Module[{txt, isValid = False},
        txt = PropertyValue[{"loadDriverField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
        ];
        SetPropertyValue[{"loadDriverButton", "enabled"}, isValid];
      ];
      
    ValidateDefaultLocationPage[] := 
      Module[{txt, isValid = False},
        txt = PropertyValue[{"defaultLocationField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
          $url = txt;
          SetPropertyValue[{"defaultLocationPage", "nextPage"}, WidgetReference["propertiesChoicePage"]];          
        ];
        $username = PropertyValue[{"defaultUsernameField", "text"}];
        $password = PropertyValue[{"defaultPasswordField", "text"}];
        SetPropertyValue[{"defaultLocationPage", "allowNext"}, isValid];
        SetPropertyValue[{"defaultTestButton", "enabled"}, isValid];
      ];
      
    ValidateFileLocationPage[] :=
      Module[{txt, isValid = False, dir},
        txt = PropertyValue[{"fileLocationField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
          $url = txt;
          SetPropertyValue[{"fileLocationPage", "nextPage"}, WidgetReference["propertiesChoicePage"]];
        ];
        $relativePath = PropertyValue[{"fileLocationRelativePathCheckBox", "selected"}];
        $username = PropertyValue[{"fileUsernameField", "text"}];
        $password = PropertyValue[{"filePasswordField", "text"}];
        SetPropertyValue[{"fileLocationPage", "allowNext"}, isValid];
        SetPropertyValue[{"fileTestButton", "enabled"}, isValid];
      ];    
      
    ValidateNamedLocationPage[] :=
      Module[{txt, isValid = False},
        txt = PropertyValue[{"namedLocationField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
          $url = txt;
          SetPropertyValue[{"namedLocationPage", "nextPage"}, WidgetReference["propertiesChoicePage"]];
        ];
        $username = PropertyValue[{"namedUsernameField", "text"}];
        $password = PropertyValue[{"namedPasswordField", "text"}];
        SetPropertyValue[{"namedLocationPage", "allowNext"}, isValid];
        SetPropertyValue[{"namedTestButton", "enabled"}, isValid];
      ];    

    ValidateServerLocationPage[] :=
      Module[{txt, txt2, txt3, isValid = False, separator = "/"},
        txt = PropertyValue[{"serverLocationNameField", "text"}];
        txt2 = PropertyValue[{"serverLocationPortField", "text"}];
        txt3 = PropertyValue[{"serverLocationDatabaseField", "selectedItem"}];
        If[ TrueQ[txt =!= ""] && (TrueQ[txt2 === ""] || DigitQ[txt2]),
          isValid = True;
          $url = txt;
          If[txt2 =!= "", $url = $url <> ":" <> txt2];
          If[PropertyValue[{"databaseField", "selectedItem"}] === "Oracle(thin)", 
            separator = ":";
          ];
          $url = $url <> separator;
          If[txt3 =!= "" && txt3 =!= Null, $url = $url <> txt3];
          SetPropertyValue[{"serverLocationPage", "nextPage"}, WidgetReference["propertiesChoicePage"]];
        ];
        $username = PropertyValue[{"serverUsernameField", "text"}];
        $password = PropertyValue[{"serverPasswordField", "text"}];
        SetPropertyValue[{"serverLocationPage", "allowNext"}, isValid];
        SetPropertyValue[{"serverTestButton", "enabled"}, isValid];
      ];    

    ValidateODBCLocationPage[] :=
      Module[{txt, isValid = False},
        txt = PropertyValue[{"odbcLocationField", "text"}];
        If[ TrueQ[txt =!= ""],
          isValid = True;
          $url = txt;
          SetPropertyValue[{"odbcLocationPage", "nextPage"}, WidgetReference["propertiesChoicePage"]];
        ];
        $username = PropertyValue[{"odbcUsernameField", "text"}];
        $password = PropertyValue[{"odbcPasswordField", "text"}];
        SetPropertyValue[{"odbcLocationPage", "allowNext"}, isValid];
        SetPropertyValue[{"odbcTestButton", "enabled"}, isValid];
      ];    

    UpdateDatabaseField[] := 
      Module[{selected= PropertyValue[{"databaseField", "selectedItem"}]},       
        If[selected =!= Null,         
          SetPropertyValue[{"databaseField", "items"}, getJDBCNames[]];
          SetPropertyValue[{"databaseField", "selectedItem"}, selected],
          SetPropertyValue[{"databaseField", "items"}, getJDBCNames[]];
        ];
      ];

    BrowseFilename[] := Module[{returnValue},
      If[ WidgetReference["openFileDialog"] === Null,
        Widget["FileDialog", Name -> "openFileDialog"];
        SetPropertyValue[{"openFileDialog", "dialogTitle"}, "Select Source Text File"];
        SetPropertyValue[{"openFileDialog", "multiSelectionEnabled"}, False];
        SetPropertyValue[{"openFileDialog", "fileSelectionMode"},   
          PropertyValue[{"openFileDialog", "Files_Only"}]];
        ];
      returnValue = InvokeMethod[{"openFileDialog", "showOpenDialog"}, WidgetReference["wizardFrame"]];
      If[returnValue === PropertyValue[{"openFileDialog", "Approve_Option"}], 
        SetPropertyValue[{"fileLocationField", "text"}, 
          PropertyValue[{PropertyValue[{"openFileDialog", "selectedFile"}], "path"}] ]
        ];
      ];
      
    BrowseDriverFilename[] := Module[{returnValue},
      If[ WidgetReference["openFileDialog"] === Null,
        Widget["FileDialog", Name -> "openFileDialog"];
        SetPropertyValue[{"openFileDialog", "dialogTitle"}, "Select Source Text File"];
        SetPropertyValue[{"openFileDialog", "multiSelectionEnabled"}, False];
        SetPropertyValue[{"openFileDialog", "fileSelectionMode"},   
          PropertyValue[{"openFileDialog", "Files_Only"}]];
        ];
      returnValue = InvokeMethod[{"openFileDialog", "showOpenDialog"}, WidgetReference["wizardFrame"]];
      If[returnValue === PropertyValue[{"openFileDialog", "Approve_Option"}], 
        SetPropertyValue[{"loadDriverField", "text"}, 
          PropertyValue[{PropertyValue[{"openFileDialog", "selectedFile"}], "path"}] ]
        ];
      ];
      
    InstallDriver[] := 
      Module[{driverLocation, system, user, path, file, fileName},
        driverLocation = PropertyValue[{"loadDriverField", "text"}];
        user = PropertyValue[{"loadDriverUserRadioButton", "selected"}];
        system = PropertyValue[{"loadDriverSystemRadioButton", "selected"}];
        fileName = StringDrop[driverLocation, StringLength[DirectoryName[driverLocation]]];
        If[user, 
          If[FileNames[ToFileName[$UserBaseDirectory, "Java"]] === {},
            CreateDirectory[ToFileName[$UserBaseDirectory, "Java"]];
          ];
          file = CopyFile[driverLocation, ToFileName[{$UserBaseDirectory, "Java"}, fileName]];
        ];
        If[system, 
          If[FileNames[ToFileName[$BaseDirectory, "Java"]] === {},
            CreateDirectory[ToFileName[$BaseDirectory, "Java"]];
          ];
          file = CopyFile[driverLocation, ToFileName[{$BaseDirectory, "Java"}, fileName]];
        ];
        AddToClassPath[file];
      ];
      
    GetWindow[] :=   
      Module[{window = WidgetReference["sqlConnectionWizard"],
              next = PropertyValue[{"sqlConnectionWizard", "parent"}]},
        While[next =!= Null,
          window = next;           
          next = PropertyValue[{window, "parent"}];
        ];
        window
      ];             
  ],
    
  BindEvent[{"databaseField", "action"},
    Script[
      Block[{databaseName = PropertyValue[{"databaseField", "selectedItem"}], database, driver, description, loaded, nextPage},
        database = Cases[JDBCDrivers[], JDBCDriver[___, "Name" -> PropertyValue[{"databaseField", "selectedItem"}], ___]];
        If[Length[database] > 0, 
          database = First[database];	
          {driver, description} = {"Driver", "Description"} /. Options[database] /. {"Driver"->"", "Description"->""};
          SetPropertyValue[{"typeDescriptionField", "text"}, description];
          Off[Java::"excptn"];
          Off[LoadJavaClass::"fail"];
          loaded = LoadJavaClass[driver];
          On[Java::"excptn"];
          On[LoadJavaClass::"fail"];
          Switch[databaseName,
            "hsqldb", 
              SetPropertyValue[{"fileLocationPage", "title"}, "hsqldb Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["fileLocationPage"]];
              SetPropertyValue[{"fileLocationField", "toolTipText"}, Null],              
            "HSQL(Standalone)",
              SetPropertyValue[{"fileLocationPage", "title"}, "HSQL(Standalone) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["fileLocationPage"]];
              SetPropertyValue[{"fileLocationField", "toolTipText"}, Null],                            
            "HSQL(Memory)",
              SetPropertyValue[{"namedLocationPage", "title"}, "HSQL(Memory) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["namedLocationPage"]],
            "HSQL(Server)",
              SetPropertyValue[{"serverLocationPortField", "text"}, "9001"];
              SetPropertyValue[{"serverLocationPage", "title"}, "HSQL(Server) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["serverLocationPage"]],
            "HSQL(Server+TLS)",
              SetPropertyValue[{"serverLocationPortField", "text"}, "9001"];
              SetPropertyValue[{"serverLocationPage", "title"}, "HSQL(Server+TLS) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["serverLocationPage"]],
            "HSQL(Webserver)",
              SetPropertyValue[{"serverLocationPortField", "text"}, "9001"];
              SetPropertyValue[{"serverLocationPage", "title"}, "HSQL(Webserver) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["serverLocationPage"]],
            "HSQL(Webserver+TLS)",
              SetPropertyValue[{"serverLocationPortField", "text"}, "9001"];
              SetPropertyValue[{"serverLocationPage", "title"}, "HSQL(Webserver+TLS) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["serverLocationPage"]],              
            "odbc",
              SetPropertyValue[{"odbcLocationPage", "title"}, "ODBC Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["odbcLocationPage"]],
            "ODBC(DSN)",
              SetPropertyValue[{"odbcLocationPage", "title"}, "ODBC(DSN) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["odbcLocationPage"]],
            "Microsoft Access(ODBC)",
              SetPropertyValue[{"fileLocationPage", "title"}, "Microsoft Access(ODBC) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["fileLocationPage"]];
              SetPropertyValue[{"fileLocationField", "toolTipText"}, "Attributes may be added following the file using <file-path>[;<attribute-name>=<attribute-value>]*"],              
            "mysql",
              SetPropertyValue[{"serverLocationPortField", "text"}, "3306"];
              SetPropertyValue[{"serverLocationPage", "title"}, "MySQL Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["serverLocationPage"]],
            "MySQL(Connector/J)",
              SetPropertyValue[{"serverLocationPortField", "text"}, "3306"];
              SetPropertyValue[{"serverLocationPage", "title"}, "MySQL(Connector/J) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["serverLocationPage"]],
            "jtds_sqlserver",
              SetPropertyValue[{"serverLocationPortField", "text"}, "1433"];
              SetPropertyValue[{"serverLocationPage", "title"}, "Microsoft SQL Server(jTDS) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["serverLocationPage"]],
            "Microsoft SQL Server(jTDS)",
              SetPropertyValue[{"serverLocationPortField", "text"}, "1433"];
              SetPropertyValue[{"serverLocationPage", "title"}, "Microsoft SQL Server(jTDS) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["serverLocationPage"]],
            "jtds_sybase",
              SetPropertyValue[{"serverLocationPortField", "text"}, "5000"];
              SetPropertyValue[{"serverLocationPage", "title"}, "Sybase(jTDS) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["serverLocationPage"]],
            "Sybase(jTDS)",
              SetPropertyValue[{"serverLocationPortField", "text"}, "5000"];
	          SetPropertyValue[{"serverLocationPage", "title"}, "Sybase(jTDS) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["serverLocationPage"]],
            "Oracle(thin)",
              SetPropertyValue[{"serverLocationPortField", "text"}, "1521"];
	          SetPropertyValue[{"serverLocationPage", "title"}, "Oracle(thin) Location"];
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["serverLocationPage"]],
            _, 
              SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["defaultLocationPage"]]
          ];
          
          If[loaded === $Failed, 
            nextPage = PropertyValue[{"databaseChoicePage", "nextPage"}];
            SetPropertyValue[{"databaseChoicePage", "nextPage"}, WidgetReference["loadDriverPage"]];
            SetPropertyValue[{"loadDriverPage", "nextPage"}, nextPage];
            SetPropertyValue[{"loadDriverName", "text"}, driver];
          ];
        ];
      ]
    ]
  ],
    
  BindEvent[{"sqlConnectionWizard", "wizardFinished"}, 
    Script[
      Block[{name, desc, loc, driver, url, user, passwd, conn, dir, i,
             rel, ucp, ro, til, cat, props, dbrdir},
        name   = PropertyValue[{"nameField", "text"}];
        desc   = PropertyValue[{"descriptionField", "text"}];
        If[desc === "", desc = None];
        driver = PropertyValue[{"databaseField", "selectedItem"}];
        url    = $url;
        user   = $username;
        If[user === "", user = None];
        If[PropertyValue[{"storeCheckBox", "selected"}], 
          passwd = $password, 
          passwd = "$Prompt"
        ];
        If[user === None && passwd === "", passwd = None];
        ucp = PropertyValue[{"connectionPoolCheckBox", "selected"}];
        ro = PropertyValue[{"readOnlyCheckBox", "selected"}];
        til = PropertyValue[{"transactionIsolationLevelField", "selectedItem"}];
        cat = PropertyValue[{"catalogField", "text"}];
        If[cat === "", cat = Automatic];
        If[PropertyValue[{"storeConfigUserRadioButton", "selected"}], 
          dbrdir = $UserBaseDirectory;
          dir = ToFileName[{$UserBaseDirectory, "DatabaseResources"}],
          dbrdir = $BaseDirectory;
          dir = ToFileName[{$BaseDirectory, "DatabaseResources"}]
        ]; 
        props = PropertyValue[{"propertiesTable", "items"}];
        props = Rule @@ # & /@ props;

        If[$file === Null || DirectoryName[$file] =!= dir, 
          (* Make a unique name *) 
          loc = name <> ".m";
          i = 0;
          While[FileNames[loc, dir] =!= {},
            loc = name <> "(" <> ToString[++i] <> ").m"
          ];
          loc = ToFileName[dir, loc]
          , 
          loc = $file
        ];
          
        rel = TrueQ[$relativePath];
        
        conn = SQLConnection[JDBC[driver, url],
                               "Catalog"->cat,
                               "Description" -> desc,
                               "Name" -> name,
                               "Password" -> passwd,
                               "Properties"->props,
                               "ReadOnly"->ro,
                               "RelativePath"->rel,
                               "TransactionIsolationLevel"->til,
                               "UseConnectionPool"->ucp,
                               "Username" -> user, 
                               "Version"->DatabaseLink`Information`$VersionNumber];
        If[FileNames["DatabaseResources", {dbrdir}] === {},  
          CreateDirectory[dir];
        ];
        Put[conn, loc];          
      ]
    ]
  ],
  
  BindEvent[{"sqlConnectionWizard", "wizardDidReset"}, 
    Script[
      SetPropertyValue[{"nameField", "text"}, ""];
      SetPropertyValue[{"descriptionField", "text"}, ""];
      SetPropertyValue[{"databaseField", "selectedIndex"}, 0];
      SetPropertyValue[{"loadDriverField", "text"}, ""];
      SetPropertyValue[{"loadDriverUserRadioButton", "selected"}, True];
      SetPropertyValue[{"defaultLocationField", "text"}, ""];
      SetPropertyValue[{"defaultUsernameField", "text"}, ""];
      SetPropertyValue[{"defaultPasswordField", "text"}, ""];
      SetPropertyValue[{"fileLocationField", "text"}, ""];
      SetPropertyValue[{"fileLocationRelativePathCheckBox", "selected"}, False];     
      SetPropertyValue[{"fileUsernameField", "text"}, ""];
      SetPropertyValue[{"filePasswordField", "text"}, ""];
      SetPropertyValue[{"namedLocationField", "text"}, ""];
      SetPropertyValue[{"namedUsernameField", "text"}, ""];
      SetPropertyValue[{"namedPasswordField", "text"}, ""];
      SetPropertyValue[{"serverLocationNameField", "text"}, ""];
      SetPropertyValue[{"serverLocationPortField", "text"}, ""];
      SetPropertyValue[{"serverLocationDatabaseField", "selectedItem"}, ""];
      SetPropertyValue[{"serverUsernameField", "text"}, ""];
      SetPropertyValue[{"serverPasswordField", "text"}, ""];
      SetPropertyValue[{"odbcLocationField", "text"}, ""];
      SetPropertyValue[{"odbcUsernameField", "text"}, ""];
      SetPropertyValue[{"odbcPasswordField", "text"}, ""];
      SetPropertyValue[{"storeCheckBox", "selected"}, False];
      SetPropertyValue[{"connectionPoolCheckBox", "selected"}, False];
      SetPropertyValue[{"readOnlyCheckBox", "selected"}, False];
      SetPropertyValue[{"transactionIsolationLevelField", "selectedIndex"}, 0];
      SetPropertyValue[{"catalogField", "text"}, ""];
      SetPropertyValue[{"propertiesTable", "items"}, {}];
      $file = Null;
      
      If[WidgetReference["connection"] =!= Null, 
        Block[{conn, username, name, driver, url, description, relative,
               ucp, ro, til, cat, props, password, server, port, database, separator = "/"}, 
            
          conn = WidgetReference["connection"];
             
          name = "Name" /. Options[conn] /. Options[ OpenSQLConnection ]; 
          description = "Description" /. Options[conn] /. Options[ OpenSQLConnection ]; 
          username = "Username" /. Options[conn] /. Options[ OpenSQLConnection ]; 
          password = "Password" /. Options[conn] /. Options[ OpenSQLConnection ]; 
          ucp = "UseConnectionPool" /. Options[conn] /. Options[ OpenSQLConnection ]; 
          ro = "ReadOnly" /. Options[conn] /. Options[ OpenSQLConnection ]; 
          til = "TransactionIsolationLevel" /. Options[conn] /. Options[ OpenSQLConnection ]; 
          cat = "Catalog" /. Options[conn] /. Options[ OpenSQLConnection ]; 
          props = "Properties" /. Options[conn] /. Options[ OpenSQLConnection ]; 
          relative = "RelativePath" /. Options[conn] /. Options[ OpenSQLConnection ]; 
          $file = "Location" /. Options[conn] /. Options[ OpenSQLConnection ];
          
          driver = conn[[1,1]];
          url = conn[[1,2]];
             
          If[StringQ[name],
            SetPropertyValue[{"nameField", "text"}, name];
          ];
          If[StringQ[description],
            SetPropertyValue[{"descriptionField", "text"}, description];
          ];
          If[StringQ[$file] && StringMatchQ[$file, $BaseDirectory <> "*"], 
            SetPropertyValue[{"storeConfigSystemRadioButton", "selected"}, True];
            SetPropertyValue[{"storeConfigUserRadioButton", "selected"}, False]
            , 
            SetPropertyValue[{"storeConfigSystemRadioButton", "selected"}, False];
            SetPropertyValue[{"storeConfigUserRadioButton", "selected"}, True]; 
          ]; 
          
          If[MemberQ[JDBCDriverNames[], driver], 
            SetPropertyValue[{"databaseField", "selectedItem"}, driver]
          ];
          Switch[driver, 
            "hsqldb" | "HSQL(Standalone)" | "Microsoft Access(ODBC)",
              If[StringQ[url], 
                SetPropertyValue[{"fileLocationField", "text"}, url];
              ];
              SetPropertyValue[{"fileLocationRelativePathCheckBox", "selected"}, TrueQ[relative]];     
              If[StringQ[username], 
                SetPropertyValue[{"fileUsernameField", "text"}, username];
              ];
              If[StringQ[password], 
                SetPropertyValue[{"filePasswordField", "text"}, password]
              ],
            "HSQL(Memory)", 
              If[StringQ[url], 
                SetPropertyValue[{"namedLocationField", "text"}, url];
              ];
              If[StringQ[username], 
                SetPropertyValue[{"namedUsernameField", "text"}, username];
              ];
              If[StringQ[password], 
                SetPropertyValue[{"namedPasswordField", "text"}, password]
              ],
            "HSQL(Server)" | "HSQL(Server+TLS)" | "HSQL(Webserver)" | "HSQL(Webserver+TLS)" |
            "mysql" | "MySQL(Connector/J)" | "jtds_sqlserver" | "Microsoft SQL Server(jTDS)"|
            "jtds_sybase" | "Sybase(jTDS)" | "Oracle(thin)", 
              If[driver === "Oracle(thin)", 
                separator = ":";
              ];
              If[StringQ[url], 
                {{server, port, database}} = StringCases[url, 
                  x:WordCharacter..~~ (":"~~y:NumberString...)...~~(separator~~z:WordCharacter...)...:>{x,y,z}];
                SetPropertyValue[{"serverLocationNameField", "text"}, server];
                SetPropertyValue[{"serverLocationPortField", "text"}, port];
                SetPropertyValue[{"serverLocationDatabaseField", "selectedItem"}, database];
              ];
              If[StringQ[username],             
                SetPropertyValue[{"serverUsernameField", "text"}, username];
              ];
              If[StringQ[password], 
                SetPropertyValue[{"serverPasswordField", "text"}, password]                
              ],
            "odbc" | "ODBC(DSN)", 
              If[StringQ[url], 
                SetPropertyValue[{"odbcLocationField", "text"}, url];
              ];
              If[StringQ[username], 
                SetPropertyValue[{"odbcUsernameField", "text"}, username];
              ];
              If[StringQ[password], 
                SetPropertyValue[{"odbcPasswordField", "text"}, password]
              ],
            _, 
              If[StringQ[url], 
                SetPropertyValue[{"defaultLocationField", "text"}, url];
              ];
              If[StringQ[username], 
                SetPropertyValue[{"defaultUsernameField", "text"}, username];
              ];
              If[StringQ[password], 
                SetPropertyValue[{"defaultPasswordField", "text"}, password];               
              ]; 
          ];
          If[password =!= "$Prompt", 
            SetPropertyValue[{"storeCheckBox", "selected"}, True],
            SetPropertyValue[{"storeCheckBox", "selected"}, False]
          ];
          If[ucp === Automatic, ucp = $SQLUseConnectionPool];
          SetPropertyValue[{"connectionPoolCheckBox", "selected"}, TrueQ[ucp]];
          SetPropertyValue[{"readOnlyCheckBox", "selected"}, TrueQ[ro]];
          SetPropertyValue[{"transactionIsolationLevelField", "selectedItem"}, til];
          If[StringQ[cat], 
            SetPropertyValue[{"catalogField", "text"}, cat]
          ];
          If[MatchQ[props, {___Rule}],
            SetPropertyValue[{"propertiesTable", "items"}, List @@ # & /@ props];
          ];
        ]
      ];
      UnsetWidgetReference["connection"]
    ]
  ],
    
  BindEvent[{"databasePropertiesButton", "action"}, 
    Script[
      If[jdbcDriverWizardDialog === Null, 
        jdbcDriverWizardDialog = 
          Widget["DatabaseLink/Dialogs/JDBCDriverWizardDialog", 
            Name -> "jdbcDriverWizardDialog",
            InitialArguments->{Script[GetWindow[]]}];
      ];
      SetWidgetReference["jdbcDriver", PropertyValue[{"databaseField", "selectedItem"}]];
      InvokeMethod[{"jdbcDriverWizardDialog", "reset"}];
      InvokeMethod[{"jdbcDriverWizardDialog", "show"}];
      UpdateDatabaseField[];
    ] 
  ],

  BindEvent[{"databaseNewButton", "action"}, 
    Script[
      If[jdbcDriverWizardDialog === Null, 
        jdbcDriverWizardDialog = 
          Widget["DatabaseLink/Dialogs/JDBCDriverWizardDialog", 
            Name ->"jdbcDriverWizardDialog",
            InitialArguments->{Script[GetWindow[]]}];
      ];
      InvokeMethod[{"jdbcDriverWizardDialog", "reset"}];
      InvokeMethod[{"jdbcDriverWizardDialog", "show"}];
      UpdateDatabaseField[];
    ] 
  ]
  
}, Name -> "sqlConnectionWizard"]
    