Widget["Panel", 
  {
    Script[Needs["DatabaseLink`"];],
    
    Widget["Panel", 
      {
        WidgetGroup[
          {
            Widget["ScrollPane", 
              {
                "preferredSize" -> 
                  Widget["Dimension", {"width" -> 250, "height" -> 150}],
                "viewportView" -> 
                  Widget["List", 
                  {
                    PropertyValue["selectionModel", Name -> "connectionListSelectionModel"],
                    "selectionMode" -> 
                      PropertyValue[{"connectionListSelectionModel", "SINGLE_SELECTION"}]
                  }, 
                  Name -> "connectionList"]
              }
            ],
            { 
              Widget["Button", {"text" -> "New...", "enabled"->True, 
                BindEvent["action", Script[new[]]]}],
              Widget["Button", {"text" -> "Edit...", "enabled"->True,
                BindEvent["action", Script[edit[]]]}],
              Widget["Button", {"text" -> "Delete...", "enabled"->True,
                BindEvent["action", Script[delete[]]]}],
              WidgetFill[]
            }
          }, WidgetLayout -> {"Border" -> "Connections"}
        ],
        { 
          WidgetFill[],
          Widget["Button", {"text" -> "Connect", "enabled"->True}, Name -> "ok"],
          Widget["Button", {"text" -> "Cancel", "enabled"->True}, Name -> "cancel"],
          WidgetFill[]
        }
      }
    ],
    
    Script[
    
      SetPropertyValue[{"connectionList", "items"}, DataSourceNames[]];
      
      sqlConnectionWizard = Null;
      
      sqlConnection = Null;
      
      new[] := 
        Module[{},
          If[sqlConnectionWizard === Null, 
            sqlConnectionWizard = Widget["DatabaseLink/Dialogs/SQLConnectionWizardDialog", 
               Name -> "sqlConnectionWizardDialog",
               InitialArguments->{Script[GetWindow[]]}];
          ];
          InvokeMethod[{"sqlConnectionWizardDialog", "reset"}];
          InvokeMethod[{"sqlConnectionWizardDialog", "show"}];
          SetPropertyValue[{"connectionList", "items"}, DataSourceNames[]];
       ];

      edit[] := 
        Module[{selection}, 
          selection = PropertyValue[{"connectionList", "selectedIndex"}];
          If[selection >= 0,
            If[sqlConnectionWizard === Null, 
              sqlConnectionWizard = Widget["DatabaseLink/Dialogs/SQLConnectionWizardDialog", 
                 Name -> "sqlConnectionWizardDialog",
                 InitialArguments->{Script[GetWindow[]]}];
            ];
            SetWidgetReference["connection", DataSources[][[selection+1]]];
            InvokeMethod[{"sqlConnectionWizardDialog", "reset"}];                                         
            InvokeMethod[{"sqlConnectionWizardDialog", "show"}];
            SetPropertyValue[{"connectionList", "items"}, DataSourceNames[]];
          ]
        ];
        
      delete[] := 
        Module[{selection, conn, loc}, 
          selection = PropertyValue[{"connectionList", "selectedIndex"}];
          If[selection >= 0,
            conn = DataSources[][[selection+1]];
            file = "Location" /. Options[conn] /. Options[ SQLConnection ];
            DeleteFile[file];
            SetPropertyValue[{"connectionList", "items"}, DataSourceNames[]];
          ]
        ];
        
      GetWindow[] :=   
        Module[{window = WidgetReference["chooseConnectionPanel"],
                next = PropertyValue[{"chooseConnectionPanel", "parent"}]},
          While[next =!= Null,
            window = next;           
            next = PropertyValue[{window, "parent"}];
          ];
          window
        ];
    ]
    
  }, Name -> "chooseConnectionPanel", ExposeWidgetReferences -> {"connection"}
]