/*
 * Created on Jul 16, 2004
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.wolfram.databaselink.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComboBox;

import com.wolfram.jlink.Expr;

/**
 * @author chrisw
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class SortCondition extends Condition {

    protected JComboBox column = null;
    protected JComboBox direction = null;
    protected static final Object[] directionItems = new String[] {
      "Ascending", "Descending"
    };

    protected Object[] columnItems = new String[] {};

    private static final Expr SYM_SQLCOLUMN = new Expr(Expr.SYMBOL, "SQLColumn");
    private static final Expr SYM_RULE = new Expr(Expr.SYMBOL, "Rule");

    public SortCondition() {
        super();
        localInit();
    }

    public SortCondition(Object[] colVals)
    {
      super();
      columnItems = colVals;
      localInit();
    }

    public SortCondition(Expr expr, Object[] colVals)
    {
      super();
      columnItems = colVals;
      localInit();
      fromExpr(expr);
    }

    protected void localInit()
    {
        super.init();
        column = new JComboBox();
        setColumnItems(columnItems);
        direction = new JComboBox(directionItems);

        addButton = new JButton("+");
        addButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                addCondition();
            }
        });

        removeButton = new JButton("-");
        removeButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                removeCondition();
            }
        });

        addComponent(column);
        addComponent(direction);
    }

    public void setColumnItems(Object[] items)
    {
        columnItems = items;
        column.removeAllItems();
        for(int i = 0; i < items.length; i++)
        {
            column.addItem(items[i]);
        }
    }

    public Object[] getColumnItems()
    {
        Object[] items = new Object[column.getItemCount()];
        for(int i = 0; i < column.getItemCount(); i++)
        {
            items[i] = column.getItemAt(i);
        }
        return items;
    }

    public Object[] getDirectionItems()
    {
        Object[] items = new Object[direction.getItemCount()];
        for(int i = 0; i < direction.getItemCount(); i++)
        {
            items[i] = direction.getItemAt(i);
        }
        return items;
    }

    public void addCondition() {
        SortCondition condition = new SortCondition(columnItems);
        conditionPanel.addCondition(condition);
    }

    private void fromExpr(Expr expr) {

        Expr head = expr.head();
        if (!head.equals(SYM_RULE)|| expr.length() != 2)
            return;

        String op = null;
        String col = parseSQLColumn(expr.part(1));
        if (col == null)
            return;

        if (expr.part(2) != null && expr.part(2).stringQ())
        {
          try
          {
            op = expr.part(2).asString();
          }
          catch(Exception e) {}
        }
        if (op == null)
            return;

        direction.setSelectedItem(op);
        column.setSelectedItem(col);
    }

    private String parseSQLColumn(Expr expr) {
        try {
            if (expr.head().equals(SYM_SQLCOLUMN) && expr.length() == 1) {
                Expr part1 = expr.part(1);
                if (part1.stringQ()) {
                    return part1.asString().replaceAll("\\.", ", ");
                }
                if (part1.listQ() && part1.length() == 2) {
                    return part1.part(1).asString() + ", "
                            + part1.part(2).asString();
                }
            }
        } catch (Exception e) {
        }
        return null;

    }

    public Expr toExpr() {
        String op = (String)direction.getSelectedItem();
        String col = (String)column.getSelectedItem();
        if(op == null || col == null)
            return null;

        Expr sqlCol = new Expr(SYM_SQLCOLUMN, new Expr[] {new Expr(col.replaceAll(", ", "\\."))});
        return new Expr(SYM_RULE, new Expr[] {sqlCol, new Expr(op)});
    }

    public void stopEditing() {
    }

}
