/*
 * Created on Jul 13, 2004
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.wolfram.databaselink.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;

import com.wolfram.jlink.Expr;

/**
 * @author chrisw
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class WhereCondition extends Condition {

    protected JComboBox column = null;

    protected JComboBox operator = null;

    protected JComboBox value = null;

    protected static final Object[] operatorItems = new String[] { "is",
            "is not", "is greater than", "is less than",
            "is greater than or equal to", "is less than or equal to",
            "contains", "does not contain", "starts with", "ends with",
            "is contained in" };

    protected Object[] columnItems = new String[] {};

    protected Object[] valueItems = new String[] {};

    private static final Expr SYM_SQLCOLUMN = new Expr(Expr.SYMBOL, "SQLColumn");

    private static final Expr SYM_EQUAL = new Expr(Expr.SYMBOL, "Equal");

    private static final Expr SYM_UNEQUAL = new Expr(Expr.SYMBOL, "Unequal");

    private static final Expr SYM_GREATER = new Expr(Expr.SYMBOL, "Greater");

    private static final Expr SYM_LESS = new Expr(Expr.SYMBOL, "Less");

    private static final Expr SYM_GREATEREQUAL = new Expr(Expr.SYMBOL,
            "GreaterEqual");

    private static final Expr SYM_LESSEQUAL = new Expr(Expr.SYMBOL, "LessEqual");

    private static final Expr SYM_SQLSTRINGMATCHQ = new Expr(Expr.SYMBOL,
            "SQLStringMatchQ");

    private static final Expr SYM_NOT = new Expr(Expr.SYMBOL, "Not");

    public WhereCondition() {
        super();
        localInit();
    }

    public WhereCondition(Expr expr, Object[] colVals, Object[] valVals) {
        super();
        columnItems = colVals;
        valueItems = valVals;
        localInit();
        fromExpr(expr);
    }

    public WhereCondition(Object[] colVals, Object[] valVals) {
        super();
        columnItems = colVals;
        valueItems = valVals;
        localInit();
    }

    protected void localInit() {
        super.init();
        column = new JComboBox();
        setColumnItems(columnItems);
        operator = new JComboBox(operatorItems);
        value = new JComboBox();
        setValueItems(valueItems);
        value.setEditable(true);

        addButton = new JButton("+");
        addButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                addCondition();
            }
        });

        removeButton = new JButton("-");
        removeButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                removeCondition();
            }
        });

        addComponent(column);
        addComponent(operator);
        addComponent(value);
    }

    public void setColumnItems(Object[] items) {
        columnItems = items;
        column.removeAllItems();
        for (int i = 0; i < items.length; i++) {
            column.addItem(items[i]);
        }
    }

    public Object[] getColumnItems() {
        Object[] items = new Object[column.getItemCount()];
        for (int i = 0; i < column.getItemCount(); i++) {
            items[i] = column.getItemAt(i);
        }
        return items;
    }

    public Object[] getOperatorItems() {
        Object[] items = new Object[operator.getItemCount()];
        for (int i = 0; i < operator.getItemCount(); i++) {
            items[i] = operator.getItemAt(i);
        }
        return items;
    }

    public void setValueItems(Object[] items) {
        valueItems = items;
        Object item = value.getSelectedItem();

        value.removeAllItems();

        if (item != null)
            value.addItem(item);
        else
            value.addItem("");

        for (int i = 0; i < items.length; i++) {
            value.addItem(items[i]);
        }
    }

    public Object[] getValueItems() {
        Object[] items = new Object[value.getItemCount()];
        for (int i = 0; i < value.getItemCount(); i++) {
            items[i] = value.getItemAt(i);
        }
        return items;
    }

    public void addCondition() {
        WhereCondition condition = new WhereCondition(columnItems, valueItems);
        conditionPanel.addCondition(condition);
    }

    public void stopEditing() {
        JTextField tf = (JTextField) value.getEditor().getEditorComponent();
        tf.postActionEvent();
    }

    public String toString() {
        String result = null;
        String op = (String) operator.getSelectedItem();
        String col = (String) column.getSelectedItem();
        String v = (String) value.getSelectedItem();
        if (op == null || col == null || v == null || col.equals(v))
            return null;

        col = col.replaceAll(", ", "\\.");

        String val;
        Arrays.sort(columnItems);
        if (Arrays.binarySearch(columnItems, v) < 0)
            val = "'" + v + "'";
        else
            val = v.replaceAll(", ", "\\.");

        if (op.equals("is"))
            result = col + " = " + val;
        if (op.equals("is not"))
            result = col + " != " + val;
        if (op.equals("is greater than"))
            result = col + " > " + val;
        if (op.equals("is less than"))
            result = col + " < " + val;
        if (op.equals("is greater than or equal to"))
            result = col + " >= " + val;
        if (op.equals("is less than or equal to"))
            result = col + " <= " + val;
        if (op.equals("contains")) {
            if (Arrays.binarySearch(columnItems, v) < 0)
                val = "'%" + v + "%'";
            result = col + " LIKE " + val;
        }
        if (op.equals("does not contain")) {
            if (Arrays.binarySearch(columnItems, v) < 0)
                val = "'%" + v + "%'";
            result = "NOT " + col + " LIKE " + val;
        }
        if (op.equals("starts with")) {
            if (Arrays.binarySearch(columnItems, v) < 0)
                val = "'" + v + "%'";
            result = col + " LIKE " + val;
        }
        if (op.equals("ends with")) {
            if (Arrays.binarySearch(columnItems, v) < 0)
                val = "'%" + v + "'";
            result = col + " LIKE " + val;
        }

        return result;
    }

    private void fromExpr(Expr expr) {

        Expr head = expr.head();
        if (expr.length() != 2)
            return;

        String op = null;

        String col = parseSQLColumn(expr.part(1));
        if (col == null)
            return;

        boolean isColumn = true;
        String val = parseSQLColumn(expr.part(2));
        if (val == null)
        {
            isColumn = false;
            if(expr.part(2).stringQ())
            {
                try
                {
                  val = expr.part(2).asString();
                }
                catch(Exception e) {}
            }
            else
                val = expr.part(2).toString();
        }

        if (head.equals(SYM_EQUAL))
            op = "is";
        if (head.equals(SYM_UNEQUAL))
            op = "is not";
        if (head.equals(SYM_GREATER))
            op = "is greater than";
        if (head.equals(SYM_LESS))
            op = "is less than";
        if (head.equals(SYM_GREATEREQUAL))
            op = "is greater than or equal to";
        if (head.equals(SYM_LESSEQUAL))
            op = "is less than or equal to";
        if (head.equals(SYM_SQLSTRINGMATCHQ))
        {
            if(val.startsWith("%") && val.endsWith("%"))
            {
              op = "contains";
              val = val.substring(1, val.length()-1);
            }
            else if(val.startsWith("%"))
            {
                op  = "ends with";
                val = val.substring(1);
            }
            else if(val.endsWith("%"))
            {
                op = "starts with";
                val = val.substring(0, val.length()-1);
            }
        }
        if (op == null)
            return;

        operator.setSelectedItem(op);
        column.setSelectedItem(col);
        if(!isColumn)
        {
            value.removeItem("");
            value.insertItemAt(val, 0);
        }
        value.setSelectedItem(val);
    }

    private String parseSQLColumn(Expr expr) {
        try {
            if (expr.head().equals(SYM_SQLCOLUMN) && expr.length() == 1) {
                Expr part1 = expr.part(1);
                if (part1.stringQ()) {
                    return part1.asString().replaceAll("\\.", ", ");
                }
                if (part1.listQ() && part1.length() == 2) {
                    return part1.part(1).asString() + ", "
                            + part1.part(2).asString();
                }
            }
        } catch (Exception e) {
        }
        return null;

    }

    public Expr toExpr() {
        Expr expr = null;
        String op = (String) operator.getSelectedItem();
        String col = (String) column.getSelectedItem();
        String val = (String) value.getSelectedItem();
        if (op == null || col == null || val == null || col.equals(val))
            return null;

        Expr sqlCol = new Expr(SYM_SQLCOLUMN, new Expr[] { new Expr(col
                .replaceAll(", ", "\\.")) });
        Expr sqlVal = null;
        Arrays.sort(columnItems);
        if (Arrays.binarySearch(columnItems, val) < 0)
            sqlVal = new Expr(val);
        else
            sqlVal = new Expr(SYM_SQLCOLUMN, new Expr[] { new Expr(val
                    .replaceAll(", ", "\\.")) });

        if (op.equals("is"))
            expr = new Expr(SYM_EQUAL, new Expr[] { sqlCol, sqlVal });
        if (op.equals("is not"))
            expr = new Expr(SYM_UNEQUAL, new Expr[] { sqlCol, sqlVal });
        if (op.equals("is greater than"))
            expr = new Expr(SYM_GREATER, new Expr[] { sqlCol, sqlVal });
        if (op.equals("is less than"))
            expr = new Expr(SYM_LESS, new Expr[] { sqlCol, sqlVal });
        if (op.equals("is greater than or equal to"))
            expr = new Expr(SYM_GREATEREQUAL, new Expr[] { sqlCol, sqlVal });
        if (op.equals("is less than or equal to"))
            expr = new Expr(SYM_LESSEQUAL, new Expr[] { sqlCol, sqlVal });
        if (op.equals("contains")) {
            if (Arrays.binarySearch(columnItems, val) < 0)
                sqlVal = new Expr("%" + val + "%");
            expr = new Expr(SYM_SQLSTRINGMATCHQ, new Expr[] { sqlCol, sqlVal });
        }
        if (op.equals("does not contain")) {
            if (Arrays.binarySearch(columnItems, val) < 0)
                sqlVal = new Expr("%" + val + "%");
            expr = new Expr(SYM_NOT, new Expr[] { new Expr(SYM_SQLSTRINGMATCHQ,
                    new Expr[] { sqlCol, sqlVal }) });
        }
        if (op.equals("starts with")) {
            if (Arrays.binarySearch(columnItems, val) < 0)
                sqlVal = new Expr(val + "%");
            expr = new Expr(SYM_SQLSTRINGMATCHQ, new Expr[] { sqlCol, sqlVal });
        }
        if (op.equals("ends with")) {
            if (Arrays.binarySearch(columnItems, val) < 0)
                sqlVal = new Expr("%" + val);
            expr = new Expr(SYM_SQLSTRINGMATCHQ, new Expr[] { sqlCol, sqlVal });
        }
        if (op.equals("is contained in"))
            expr = new Expr(SYM_EQUAL, new Expr[] { sqlCol, sqlVal });
        if (op.equals("is not contained in"))
            expr = new Expr(SYM_EQUAL, new Expr[] { sqlCol, sqlVal });
        return expr;
    }

}