(* ::Package:: *)

$BatchInput::bitf = "Cannot set `1` to `2`; value must be True or False." 
$BoxForms::formset = "Cannot set `1` to `2`; value must be a list that includes TraditionalForm and StandardForm."
$Cache::set = "Cannot set `1` to `2`; value must be True or False."
$CharacterEncoding::charcode = Import::charcode = ImportString::charcode = Export::charcode = ExportString::charcode = "`1` is not a valid character encoding. Possible settings are the names given by $CharacterEncodings or None."
$CharacterEncoding::charfile = "The file `1` contains an invalid character encoding. A valid encoding is {\"type\", {{n1, \"c1\"}, ...}}."
$CharacterEncoding::sjis = "The byte sequence `1` could not be interpreted as a character in the Shift-JIS character encoding."
$CharacterEncoding::utf8 = "The byte sequence `1` could not be interpreted as a character in the UTF-8 character encoding."
$ContextPath::cxlist = $Packages::cxlist = "Cannot set `1` to `2`; value must be a list of strings ending in `3`."
$DateStringFormat::fmt = "`1` is not a valid date format."
$HistoryLength::limset = "Cannot set $HistoryLength to `1`; value must be Infinity or a non-negative machine-size integer."
$IterationLimit::itlim = "Iteration limit of `1` exceeded."
$IterationLimit::aitlim = "Iteration limit of `1` exceeded during evaluation with assumptions."
$IterationLimit::limset = $RecursionLimit::limset = "Cannot set `1` to `2`; value must be Infinity or an integer at least `3`."
$Language::noset = "The license configuration for the kernel does not allow $Language to be changed to `1`. All messages will be displayed in English."
$Language::notstr = "`1` is not a string. Only strings can be set as the value of $Language."
$MaxComputationSteps::complim = "The number of computation steps has been exceeded `1`."
$MaxExtraPrecision::meprecset = "Cannot set $MaxExtraPrecision to `1`; value must be a positive number or Infinity."
$MaxPrecision::prec = "In increasing internal precision while attempting to evaluate `1`, the limit $MaxPrecision = `2` was reached. Increasing the value of $MaxPrecision may help resolve the uncertainty."
$MaxPrecision::precset = "Cannot set `1` to `2`; value must be a positive number or Infinity."
$MaxPiecewiseCases::npi = "The new value `1` of $MaxPiecewiseCases is not a positive integer or Infinity."
$MaxRootDegree::npi = "The new value `1` of $MaxRootDegree is not a positive machine-size integer."
$MinPrecision::preccon = $MaxPrecision::preccon = "Cannot set `1` such that $MaxPrecision < $MinPrecision."
$MinPrecision::preclck = $MaxPrecision::preclck = "`1` is currently under the control of internal routines. You cannot change it at this time."
$MinPrecision::precset = "Cannot set `1` to `2`; value must be a real number or +/- Infinity."
$ModuleNumber::modnc = "Newly created symbol names may conflict with existing ones."
$ModuleNumber::set = "Cannot set `1` to `2`; value must be a positive integer."
NumericalMath`$NumberBits::realx = "`1` is not an inexact real number."
$OutputSizeLimit::nosess = "This output can only be updated in the same kernel session that generated it."
$OutputSizeLimit::noout = "This output cannot be updated because Out[`1`] has no value."
$ParentLink::lnset = "Cannot set $ParentLink to `1`; value is not a LinkObject."
$ParentLink::notfe = "`1` has refused the responsibility of $ParentLink."
$PreRead::prstr = "$PreRead[\"`1`\"] results in `2`, which is not a string."
$RandomState::rndst = "`1` is not a valid random state."
$RecursionLimit::areclim = "Recursion depth of `1` exceeded during evaluation with assumptions."
$RecursionLimit::reclim = "Recursion depth of `1` exceeded."
$SyntaxHandler::sntxh = "$SyntaxHandler returned `1`, which is not a string or $Failed."
AbsoluteTime::arg = "Argument `1` cannot be interpreted as a date or time input."
AbsoluteTime::str = "String `1` cannot be interpreted as a date in format `2`."
AbsoluteTime::zone = "Time zone specification `1` should be a real number."
AccountingForm::expint = EngineeringForm::expint = NumberForm::expint = PaddedForm::expint = ScientificForm::expint = "Result `1` obtained by applying the value of the ExponentFunction option to `2` should be an integer or Null."
AccountingForm::iprf = EngineeringForm::iprf = NumberForm::iprf = PaddedForm::iprf = ScientificForm::iprf = "Formatting specification `1` should be a positive integer or a pair of positive integers."
Accumulate::bdmtd = "Value of option Method -> `1` is not Automatic or \"CompensatedSummation\"."
Accuracy::mnprec = Precision::mnprec = "Value `1` would be inconsistent with $MinPrecision; bounding by $MinPrecision instead."
Accuracy::mxprec = Precision::mxprec = "Value `1` would be inconsistent with $MaxPrecision; bounding by $MaxPrecision instead."
AlgebraicNumber::cfls = "`1` is not a list of rational numbers." 
AlgebraicRules::algdat = "`1` is not a valid AlgebraicRules object obtained from AlgebraicRules."
AlgebraicRules::newv = "`1` involves variables not among `2`."
Alias::almark = "Source string `1` contains context mark."
Animate::unknop = ListAnimate::unknop = "`1` is not a recognized option."
Animate::vsform = "Animate argument `1` does not have the correct form for a variable specification."
ArrayFlatten::depth = "The ArrayDepth of the expression at position 1 of `1` must be at least equal to the specified rank `2`. (The rank is given by the optional second argument, which defaults to 2.)"
ArrayFlatten::match = "`1` fails the matching condition for ArrayFlatten[a,n]: if b = a[[i_1,i_2,...,i_n]], c = a[[j_1,j_2,...,j_n]], Head[a] == Head[b] == Head[c], Length[Dimensions[b]] >= n, Length[Dimensions[c]] >= n, and i_k = j_k, then Dimensions[b][[k]] must equal Dimensions[c][[k]]. Here the condition fails for k = `2` and i_k = j_k = `3`."
MatrixPlot::mat0 = "Argument `1` at position `2` is not a matrix."
ArrayPlot::mat = "Argument `1` at position `2` is not a list of lists."
MatrixPlot::drev = ArrayPlot::drev = ReliefPlot::drev = "The value of DataReversed -> `1` must be True, False, or a length-two list of True or False."
MatrixPlot::maxpt = ArrayPlot::maxpt = "The value of MaxPlotPoints -> `1` must be a positive real number, Infinity, or a list containing positive real numbers or Infinity."
MatrixPlot::dr = ArrayPlot::dr = "The value of DataRange -> `1` must be of the form {xrange, yrange}, with xrange and yrange either All or of the form {xmin, xmax} with xmin <= xmax."
MatrixPlot::crule = ArrayPlot::crule = "Value of option ColorRules -> `1` is not a valid list of color rules."
MatrixPlot::mesh = ArrayPlot::mesh = "Value of option Mesh -> `1` is not All, None, n, or a valid list of mesh specifications; using All instead."
MatrixPlot::imgsz = ArrayPlot::imgsz = "Value of option ImageSize -> `1` is not Automatic or a valid image size specification."
MatrixPlot::pixv = ArrayPlot::pixv = "Value of option PixelConstrained -> `1` is not True, False, a positive integer, or a list of two positive integers."
AspectRatio::aspr = "Value of option AspectRatio -> `1` is not a finite positive number or Automatic."
Attributes::attnf = "`1` is not a known attribute."
Attributes::attsl = "`1` is not a symbol, string, or list of symbols and strings."
Attributes::locked = ClearAll::locked = Protect::locked = SetOptions::locked = "Symbol `1` is locked."
Axes::axes = "`1` is not a valid axis specification."
AxesEdge::axedg = "`1` is not a valid axis edge specification."
BaseForm::basf = IntegerString::basf = "Requested base `1` should be an integer between 2 and `2`."
Experimental`BinaryExport::chtype = "First argument `1` is not a valid file specification."
Experimental`BinaryExport::coerce = "Coercing `1` to `2` zero."
Experimental`BinaryExport::format = "`1` is not a recognized BinaryExport format."
Experimental`BinaryExport::ignore = "Ignoring `1` because it does not match the `2` format."
Experimental`BinaryExport::nomatch = "Expression `1` does not match the format `2`."
Experimental`BinaryExportString::format = "`1` is not a recognized BinaryExportString format."
Experimental`BinaryImport::chtype = "First argument `1` is not a valid file specification."
Experimental`BinaryImport::format = "`1` is not a recognized BinaryImport format."
Experimental`BinaryImport::nffil = "File not found during `1`."
Experimental`BinaryImportString::format = "`1` is not a recognized BinaryImportString format."
BinaryRead::format = BinaryReadList::format = BinaryWrite::format = "`1` is not a recognized binary format."
BinaryRead::bfmt = BinaryReadList::bfmt = BinaryWrite::bfmt = "The channel `1` has been opened with BinaryFormat -> False and cannot be used with binary data."
BinaryWrite::nocoerce = "`1` cannot be coerced to the specified format."
BinaryWrite::memavail = "Could not allocate memory for BinaryWrite."
BinaryWrite::errfile = "Could not access file: `1`."
Block::lockt = Dialog::lockt = "Cannot localize locked symbol `1` in assignment `3` from local variable specification `2`."
Block::lockv = Dialog::lockv = "Cannot localize locked symbol `1` in local variable specification `2`."
Block::lvlist = Dialog::lvlist = Module::lvlist = With::lvlist = "Local variable specification `1` is not a List."
Block::lvset = Dialog::lvset = With::lvset = Module::lvset = "Local variable specification `1` contains `2`, which is an assignment to `3`; only assignments to symbols are allowed."
Block::lvsym = Dialog::lvsym = Module::lvsym = DynamicModule::lvsym = Interpretation::lvsym = "Local variable specification `1` contains `2`, which is not a symbol or an assignment to a symbol."
Break::nofunc = "Function `1` not found enclosing `2`."
Break::nofwd = "No enclosing For, While, or Do found for `1`."
Developer`CalendarData::date = DatePlus::date = DateDifference::date = "Argument `1` cannot be interpreted as a date."
Developer`CalendarData::cal = "`1` is not supported in the `2` calendar."
Developer`CalendarData::nohday = "`1` was not a recognized holiday in `2`."
Developer`CalendarData::ijtime = DatePlus::ijtime = DateDifference::ijtime = "Islamic and Jewish dates cannot have hours, minutes, seconds."
Developer`CalendarData::month = DatePlus::month = DateDifference::month = "`1` is not a known month for the `2` calendar. Use CalendarData[\"`2`\", \"MonthList\"] for a list of months."
Developer`CalendarData::negyr = DatePlus::negyr = DateDifference::negyr = "Negative years are not supported."
CellularAutomaton::ospec = "The specified order `1` should be a positive machine integer."
CellularAutomaton::rspec = "The neighbor specification at position 3 of rule specification `1` should be a radius, a nonempty list of radii, or a nonempty list of offsets. A radius must equal (d - 1)/2 for some positive machine integer d. The offsets are nonempty lists of machine integers."
CellularAutomaton::offfo = "Because rule specification `1` has no specified order, the offsets at position 3 must have the same length."
CellularAutomaton::offho = "Because rule specification `1` has the specified order `2`, the offsets at position 3 must have lengths differing by at most 1. Those of maximum length must have length at least 2; their first coordinate t (time) must satisfy -`2` < t <= 0. The shorter offsets are taken to have t = 0."
CellularAutomaton::offrep = "The offsets at position 3 in rule specification `1` (after adding any missing 0 time coordinates in the higher-order case) must be distinct."
CellularAutomaton::nhdm = "Each dimension of the smallest rectangle enclosing the cells in the neighborhood specified by rule `1` must be a machine integer."
CellularAutomaton::wtspec = "The weight specification at position {2, 2} of rule specification `1` should be 1 or an array of non-negative machine integers with dimensions `2`."
CellularAutomaton::nocol = "Since position 1 of rule specification `1` is a function or rule list, position 2 (if present) must be {}."
CellularAutomaton::kspec = "Since position 1 of rule specification `1` is not a function or rule list, position 2 (if present) must be of the form k, {k, 1}, or {k, wts} where k is a machine integer > 1 and wts is a nonempty array of non-negative machine integers."
CellularAutomaton::rlist = "The neighborhood specification cannot be computed from the list of rules at position `1` of the rule specification `2`."
CellularAutomaton::rsize = "The specified rule number `1` is greater than the largest possible rule number (`2`)."
CellularAutomaton::rneg = "The specified rule number `1` should be non-negative."
CellularAutomaton::nspec = "The rule specification `1` must be of the form nspec, {nspec}, {nspec, kspec}, {nspec, kspec, rspec}, or {nspec, kspec, rspec, ospec} where nspec is an integer, a list of rules, or a function."
CellularAutomaton::wtlen = "The length of the weight list `1` does not match the number of cells in the neighborhood `2`."
CellularAutomaton::offg= "The offset specification `1` should be an integer or {offt, offx1, offx2, ... offxk}, where offt is present and k does not exceed `2`, the number of spatial dimensions."
CellularAutomaton::offg4= "Since four arguments are used, the third argument `1` must be a non-negative machine integer, and the fourth argument `2` must be an integer or {offt, offx1, offx2, ... offxk}, where offt is present and k does not exceed `3`, the number of spatial dimensions. Note that the four-argument form of CellularAutomaton is being discontinued."
CellularAutomaton::offtg = "Temporal offset specification `1` should be t, {t}, {{t}}, {t1, t2}, or {t1, t2, dt} where t, t1, t2, and dt are machine integers and dt is positive."
CellularAutomaton::offtm = "Temporal offset specification `1` requests step `2` but the lowest step is `3`."
CellularAutomaton::offts = "The number of steps `2` requested by temporal offset specification `1` must be a positive machine integer."
CellularAutomaton::offtg4 = "Temporal offset specification `2` should be All, Automatic, t, {t}, {{t}}, {t1, t2}, or {t1, t2, dt}. If t, t1, or t2 is negative then the step size `1` plus 1 is added to it. The resulting t, t1, t2, and dt must be machine integers with dt > 0. Note that the four-argument form of CellularAutomaton is being discontinued."
CellularAutomaton::offtm4 = "Step size `1` and temporal offset specification `2` request step `3` but the lowest step is `4`. Note that the four-argument form of CellularAutomaton is being discontinued."
CellularAutomaton::offts4 = "The number of steps `3` requested by step size `1` and temporal offset specification `2` must be a positive machine integer. Note that the four-argument form of CellularAutomaton is being discontinued."
CellularAutomaton::offxg = "The spatial offset specification `1` for dimension `2` should be x, {x}, {{x}}, {x1, x2}, or {x1, x2, dx} where x, x1, x2, and dx are machine integers and dx is positive."
CellularAutomaton::offxs = "The number of cells `3` requested by the spatial offset specification `1` for dimension `2` must be a positive machine integer."
CellularAutomaton::ovflw = "The specified automaton rule `1` is too large to be computed."
CellularAutomaton::initn = "The initial condition specification `1` should be of the form aspec, {aspec, bspec}, or {{{aspec1, off1},{aspec2, off2},... {aspecn, offn}}, bspec} (n > 0). Each aspec must be a nonempty rank `2` array whose elements at level `2` are integers i in the range 0 <= i <= `3`."
CellularAutomaton::initno = "The initial condition specification `1` should be of the form aspec, {aspec, bspec}, or {{{aspec1, off1},{aspec2, off2},... {aspecn, offn}}, bspec} (n > 0). Each aspec must be a nonempty rank `2` array whose first dimension (time) has length `3` and whose elements at level `2` are integers i in the range 0 <= i <= `4`."
CellularAutomaton::inite = "The initial condition specification `1` should be of the form aspec, {aspec, bspec}, or {{{aspec1, off1},{aspec2, off2},... {aspecn, offn}}, bspec} (n > 0). Each aspec must be a nonempty rank `2` array whose elements at level `2` do not have head List."
CellularAutomaton::initeo = "The initial condition specification `1` should be of the form aspec, {aspec, bspec}, or {{{aspec1, off1},{aspec2, off2},... {aspecn, offn}}, bspec} (n > 0). Each aspec must be a nonempty rank `2` array whose first dimension (time) has length `3` and whose elements at level `2` do not have head List."
CellularAutomaton::bkgdn = "The background `1` should be an integer i, 0 <= i <= `3`, or a nonempty rank `2` array whose elements at level `2` are integers i in the range 0 <= i <= `3`."
CellularAutomaton::bkgdno = "The background `1` should be an integer i, 0 <= i <= `4`, or a nonempty rank `2` array whose first dimension (time) has length `3` and whose elements at level `2` are integers i in the range 0 <= i <= `4`."
CellularAutomaton::bkgde = "The background `1` should be an expression whose head is not List or a nonempty rank `2` array whose elements at level `2` do not have head List."
CellularAutomaton::bkgdeo = "The background `1` should be an expression whose head is not List or a nonempty rank `2` array whose first dimension (time) has length `3` and whose elements at level `2` do not have head List."
CellularAutomaton::stoff = "The offset `1` at position `2` in the initial condition specification should be a length `3` list of machine integers."
CellularAutomaton::rank = "The rule `1` has spatial rank `2`, which is greater than the maximum allowed spatial rank `3`."
CharacterRange::argtype = "Arguments `1` and `2` of `3` are not both strings of length 1."
Chop::tolnn = Rationalize::tolnn = "Tolerance specification `1` must be a non-negative number."
Circle::angle = "Starting angle is larger than ending angle in angle specification `1`."
Circle::radius = "Radius `1` is not a positive number or a pair of positive numbers."
Clear::spsym = ClearAll::spsym = "Special symbol `1` cannot be cleared."
Clear::ssym = ClearAll::ssym = "`1` is not a symbol or a string."
ClearAll::clloc = "Cannot clear local variable `1`."
ClebschGordan::phy = "`1` is not physical."
ClebschGordan::tri = "`1` is not triangular."
Clip::rtwo = "The argument `1` at position `2` is expected to be a list of a lower clip bound and an upper clip bound."
Clip::vtwo = "The argument `1` at position `2` is expected to be a list of a lower replacing value and an upper replacing value."
Clock::period = "Clock period `1` is not a finite positive number."
Clock::vals = "Clock called with illegal iterator values, `1`."
Clock::length = "The length of the Clock, `1`, cannot be computed."
Clock::inf = "It is not allowed to specify the period or count with an infinite clock."
Close::spfile = "Cannot close special file `1`."
Coefficient::numv = Exponent::numv = "`1` takes exactly one variable."
Color::aqp = "Model `1` and parameters `2` do not match. `3` or `4` parameters expected."
Color::badhex = "String `1` does not match Options: Hexpower -> `2` and HexColors -> `3` require a string of `4` characters."
Color::gpm = "Three-by-three matrix of numbers expected instead of `1`."
Color::html = "A string, an integer or a list of three numbers expected instead of `2`."
Color::nbw = "Number expected instead of `1`."
Color::ncmy = "List of three numbers expected instead of `1`."
Color::ncmyk = "List of three or four numbers expected instead of `1`."
Color::ncmykc = "List of three or four numbers expected instead of `1`."
Color::ngray = "Number expected instead of `1`."
Color::nhue = "Number or list of three numbers expected instead of `1`."
Color::nlab = "List of three numbers expected instead of `1`."
Color::nluv = "List of two or three numbers expected instead of `1`."
Color::noarg = "`1` does not match any model supported by Color."
Color::nomst = "String giving the name of a model expected instead of `1`."
Color::noopt = "Option expected instead of `1`."
Color::nop = "Rule or list of rules expected instead of `1`."
Color::notmgma = "`1` can use shared values for both Blackpoint and Whitepoint or by giving lists of equal length instead of `2` and `3`."
Color::notmsh = "`1` can use shared values for both Blackpoint and Whitepoint or by giving lists of equal length instead of `2` and `3`."
Color::notvci = "ConstantIntensityScaling expects a list of three numbers instead of `1`."
Color::nps = "Number expected instead of `1`."
Color::nrgb = "List of three numbers expected instead of `1`."
Color::nrgbcol = "List of three numbers expected instead of `1`."
Color::nsp = "Number expected instead of `1`."
Color::nsrgb = "List of three numbers expected instead of `1`."
Color::nxyy = "List of three numbers expected instead of `1`."
Color::nxyz = "List of two or three numbers expected instead of `1`."
Color::ocietem = "Degree Kelvin given by a number between 4000 and 25000 expected instead of `1`."
Color::otem = "Degree Kelvin given by a number between 4000 and 25000 expected instead of `1`."
ColorOutput::colpn = ToColor::colpn = "Result `1` obtained during color conversion by applying function `2` to color `3` contains a non-numerical argument."
ColumnForm::colmh = "Horizontal alignment specification `1` is not Left, Center, or Right."
ColumnForm::colmv = "Vertical alignment specification `1` is not Below, Center, or Above."
Compile::argset = "The assignment to `1` is illegal; it is not valid to assign a value to an argument."
Compile::iterset = "The assignment to `1` is illegal; the compiler cannot assign a value to an iterator variable."
Compile::ccon = "Non-numerical object `1` with attribute Constant cannot be compiled."
Compile::cif = "The types of the two results in `1` are incompatible because their ranks are different. Evaluation will use the uncompiled function."
Compile::compfail = "Compilation of `1` failed because `2` was not a form suitable for the compiler."
Compile::cpapot = "Compilation of `1` is not supported for the function argument `2`. The only function arguments supported are Times, Plus, or List. Evaluation will use the uncompiled function."
Compile::cpbool = "`1` at position `2` of `3` should be of type True | False; evaluation will use the uncompiled function."
Compile::cpdsts = "Compile cannot determine the rank of the result of `1`; evaluation will use the uncompiled function."
Compile::cpint = "`1` at position `2` of `3` should be a machine-size integer; evaluation will use the uncompiled function."
Compile::cpintlt = "`1` at position `2` of `3` should be either a nonzero integer or a vector of nonzero integers; evaluation will use the uncompiled function."
Compile::cpintlt2 = "`1` at position `2` of `3` should be a nonzero integer, or a vector or matrix of nonzero integers; evaluation will use the uncompiled function."
Compile::cpiter = "Iterator at position `1` of `2` cannot be compiled; evaluation will use the uncompiled function."
Compile::cplist = "`1` should be a tensor of type Integer, Real, or Complex; evaluation will use the uncompiled function."
Compile::cpout = "Compile cannot work on Outer for tensors of different rank; evaluation will use the uncompiled function."
Compile::cppat = "Compile does not support patterns: `1` cannot be compiled; evaluation will use the uncompiled function."
Compile::cprank = "Compile cannot determine the rank of the result tensor. The length of `1` in `2` is unknown at compiling time; evaluation will use the uncompiled function."
Compile::cpts = "The result after evaluating `1` should be a tensor. Nontensor lists are not supported at present; evaluation will proceed with the uncompiled function."
Compile::cptype = "`2` is not supported for type `1`; evaluation will use the uncompiled function."
Compile::cpw = "Cannot compile raw expression `1` of type `2`."
Compile::cret = "The type of return values in `1` are different. Evaluation will use the uncompiled function."
Compile::cret1 = "The type of Return expression `1` is incompatible with a previous Return expression."
Compile::cset = "Variable `1` of type `2` encountered in assignment of type `3`."
Compile::ctyp1 = "Number `1` in `2` is an invalid compiler variable. A symbol can be used as a valid variable."
Compile::ctyp2 = "Invalid type or rank specification in `1`."
Compile::ctyps = "Invalid subexpression type specification `1`."
Compile::exttensor = "`1` cannot be compiled and will be evaluated externally. The result is assumed to be a rank `3` tensor of type `2`."
Compile::extscalar = "`1` cannot be compiled and will be evaluated externally. The result is assumed to be of type `2`."
Compile::fun = "Compilation of `1` cannot proceed. It is not possible to compile pure functions with arguments that represent the function itself."
Compile::maxrank = "Rank specification `1` in `2` exceeds the rank limit (`3`)."
Compile::realcoerce = "Warning: compilation of `1` has coerced an exact number to an approximate real number."
Compile::cxcoerce = "Warning: compilation of `1` has coerced an exact number to an approximate complex number."
Compile::defn = "CompileValue `1` for `2` is not an expression of length 2."
Compile::part = "Part specification `1` cannot be compiled since the argument is not a tensor of sufficient rank. Evaluation will use the uncompiled function."
Compile::symdef = "The symbol `1` used in assignment `2` has not been declared as a local variable."
Compile::type = "Type specification `1` is not legal. A legal type is of the form {name, typepattern} or {name, typepattern, rank}."
Compile::initvar = "The variable `1` has not been initialized or has been initialized to Null."
Compile::nocomp = "The expression `1` cannot be compiled due to the presence of `2`. Evaluation will use the uncompiled function."
CompiledFunction::ccf = "Result `1` of external evaluation does not have the correct form."
CompiledFunction::cfcode = "Invalid opcode `1`; a non-negative integer less than `2` is expected."
CompiledFunction::cfct = "Number of arguments `1` does not match the length `2` of the argument template."
CompiledFunction::cfex = "Could not complete external evaluation at instruction `1`; proceeding with uncompiled evaluation."
CompiledFunction::cfff = "Fifth argument `1` should be of the form Function[{args}, expr]."
CompiledFunction::cffv = "First operation `1` does not check for correct version number."
CompiledFunction::cfins = "Arguments in instruction number `1` do not have the correct form."
CompiledFunction::cflist = "Nontensor object generated; proceeding with uncompiled evaluation."
CompiledFunction::cfn = "Numerical error encountered at instruction `1`; proceeding with uncompiled evaluation."
CompiledFunction::cfnlts = "Null tensor with rank > 1 encountered at instruction `1`; proceeding with uncompiled evaluation."
CompiledFunction::cfnv = "CompiledFunction object is invalid and cannot be used."
CompiledFunction::cfver = "Incorrect version number; CompiledFunction object cannot be used."
CompiledFunction::mldot = "MathLink compiler cannot interpret Dot, Det, and Inverse operations; proceeding with uncompiled evaluation."
CompiledFunction::cfsa = "Argument `1` at position `2` should be a `3`."
CompiledFunction::cfta = "Argument `1` at position `2` should be a rank `3` tensor of `4`s."
CompiledFunction::cfse = "Compiled expression `1` should be a `2`."
CompiledFunction::cfte = "Compiled expression `1` should be a rank `2` tensor of `3`s."
CompiledFunction::cfsec = "Warning: Compiled expression `1` was coerced to a `2`."
CompiledFunction::cftec = "Warning: Compiled expression `1` was coerced to a rank `2` tensor of `3`s."
CompiledFunction::orank = "The result of compiled Array or Outer has encountered a result of lower rank than expected due to a zero-length list; proceeding with uncompiled evaluation."
ComplexExpand::exf = "Value of option TargetFunctions -> `1` does not contain any of the allowed functions `2`."
ControllerState::csmal = "The file `1` does not contain a properly formatted device mapping table."
ControllerState::csnon = "The file `1` does not contain any valid device configurations."
RootIntervals::nupr = "`1` is not a univariate polynomial with rational number coefficients."
RootIntervals::bdom = "Domain specification `1` should be Reals or Complexes."
CountRoots::vbds = "The second argument `1` is expected to be a list of a variable, a Gaussian rational lower bound, and a Gaussian rational upper bound."
CountRoots::nupx = "`1` is not a univariate polynomial in `2` with Gaussian rational number coefficients."
Compress::comprfail = "The compressor failed when it tried to compress `1`."
CompressedData::corrupt = Uncompress::corrupt = "Compressed data \"`1`\" is corrupt and does not represent an expression."
Condition::condp = "Pattern `1` appears on the right-hand side of condition `2`."
ConstrainedMax::cmnov = ConstrainedMin::cmnov = "No variables found."
ConstrainedMax::cmcons = ConstrainedMin::cmcons = "`1` is not a list of valid equalities or inequalities."
ConstrainedMax::cmfun = ConstrainedMin::cmfun = "`1` is not a linear function of `2` with real coefficients."
ConstrainedMax::cmnc = ConstrainedMin::cmnc = "Non-numerical constraint `1` encountered."
Context::cxdup = "Cannot set `1` to `2`, since a symbol already exists with name `3` and context `4`."
Context::cxname = "`1` is not a parsable context name ending in `2`."
Context::cxset = $Context::cxset = "Cannot set `1` to `2`; value is not a parsable context name ending in `3`."
Context::quote = "Warning: `1` is not a valid context. A valid context uses back quotes instead of forward quotes as in `2`."
Context::quote1 = "Warning: `1` is not a valid context. A valid context uses back quotes instead of forward quotes and ends in a back quote as in `2`."
ContextToFileName::cxfil = "ContextToFileName[`1`] evaluated to `2`; a string is expected; using `3`."
Continue::nofunc = "Function `1` not found enclosing `2`."
Continue::nofwd = "No enclosing For, While, or Do found for `1`."
ContinuedFraction::incomp = "Warning: ContinuedFraction terminated before `` terms."
ContinuedFraction::noterms = "`` does not have a terminating or periodic continued fraction expansion; specify an explicit number of terms to generate."
ContinuedFraction::start = "Warning: ContinuedFraction was unable to obtain at least one term using precision `1`.`2`"
ContinuedFraction::terms = "Warning: ContinuedFraction only obtained `1` of `2` requested terms using precision `3`.`4`"
ContourGraphics::ctpnt = "The contour is attempting to traverse a cell in which some of the points have not evaluated to numbers, and it will be dropped."
ContourGraphics::ctsm = "It is not possible to shade a ContourGraphics object if some of the mesh points do not evaluate to numbers."
ContourGraphics::meshr = DensityGraphics::meshr = SurfaceGraphics::meshr = "Value of option MeshRange -> `1` is not of the form {{xmin, xmax}, {ymin, ymax}}."
ListPlot3D::arrayerr = "`1` must be a valid array or a list of valid arrays."
ListContourPlot::arrayerr = ListDensityPlot::arrayerr = "`1` must be a valid array."
General::pllim = "Range specification `1` is not of the form {x, xmin, xmax}."
LogLogPlot::llplim = LogLinearPlot::llplim = "Range specification `1` is not of the form {x, xmin, xmax} with xmin and xmax positive."
ContourPlot::pptt = DensityPlot::pptt = Plot3D::pptt = "Value of option PlotPoints -> `1` is not an integer >= 2 or a list of two such integers."
Contours::ctnl = "Value of option Contours -> `1` is not a positive integer or a list of numbers."
ContourSmoothing::ctnsm = "Value of option ContourSmoothing -> `1` is not True, Automatic, False, or None."
IsolatingInterval::npos = "`1` is not a positive number."
Convergents::terms = "`` does not have a terminating or periodic continued fraction expansion; specify an explicit number of terms to generate."
CopyDirectory::dirne = DeleteDirectory::dirne = RenameDirectory::dirne = "Directory `1` not empty."
CopyDirectory::filex = CopyFile::filex = RenameDirectory::filex = RenameFile::filex = "Cannot overwrite existing file `1`."
CopyDirectory::nodir = DeleteDirectory::nodir = RenameDirectory::nodir = "Directory `1` not found."
CopyFile::fdir = DeleteFile::fdir = Export::fdir = Get::fdir = RenameFile::fdir = "`1` is a directory; a file is expected."
Cross::nonn1 = "The arguments are expected to be vectors of equal length, and the number of arguments is expected to be 1 less than their length."
Experimental`CylindricalAlgebraicDecomposition::deprec = "Experimental`CylindricalAlgebraicDecomposition will not be supported in future versions of Mathematica. Use System`CylindricalDecomposition instead."
CylindricalDecomposition::nrtpi = GenericCylindricalDecomposition::nrtpi = "`1` is not a logical formula consisting of polynomial equations and inequalities in `2` with rational number coefficients."
D::dvar = "Multiple derivative specifier `1` does not have the form {variable, n}, where n is a non-negative machine integer."
Difference::dvar = "Difference specifier `1` does not have the form {variable, n} or {variable, n, h}, where n is a non-negative machine integer."
Differences::depth = "Requested differences `1` exceeds the array depth, `2`, of the input."
Dashing::dshn = AbsoluteDashing::dshn = "Argument in `1` is not a list of numbers."
Date::zspec = "Time zone specification `1` cannot be converted to a valid date."
DateDifference::cal = DatePlus::cal = "The time unit `1` is not supported in the `2` calendar."
DateDifference::inc = "Argument `1` is not a time unit or a list of time units."
DateDifference::twoarg = "Argument `1` is not a time unit or a list of time units, nor can it be interpreted as a date."
DateList::arg = "Argument `1` cannot be interpreted as a date or time input."
DateList::str = "String `1` cannot be interpreted as a date in format `2`."
DateList::zone = "Time zone specification `1` should be a real number."
DateList::ambig = DateString::ambig = AbsoluteTime::ambig = "Warning: the interpretation of the string `1` as a date is ambiguous."
DateList::zspec = "Time zone specification `1` cannot be converted to a valid date."
DateString::arg = "Argument `1` cannot be interpreted as a date or time input or as a date string format."
DateString::fmt = "`1` is not a valid date format."
DateString::fmtarg = "`1` specifies the date format twice."
DateString::str = "String `1` cannot be interpreted as a date in format `2`."
DateString::zone = "Time zone specification `1` should be a real number."
DateListPlot::ntdt = "The first argument to DateListPlot is not a list of pairs of dates and real values or a list of lists of pairs of dates and real values."
DateListPlot::ntdate = "The value `1` is not a valid date."
DateListPlot::ntstep = "The value `1` is not a valid step."
DateListPlot::fmt = "`1` is not a valid date format."
DateListPlot::ntreal = "The first argument `1` is not a list of real numbers or a list of lists of real numbers."
DateListPlot::dtvals = "Unable to automatically determine horizontal coordinates for the given data and DataRange."
DateListPlot::dtspec = "Unable to determine dates from the date step specification `1`."
DatePlus::inc = "Argument `1` is not a time increment or a list of time increments."
DatePlus::noinc = "A time increment or a list of time increments must be given."
Debug::dbug = "To inspect an expression, just evaluate it normally."
DeclarePackage::aldec = "Symbol `1` in `2` has already been declared."
DefaultFont::dfont = "$DefaultFont specification `1` is not of the form {\"name\", size}."
DefaultFont::font = "Value of option DefaultFont -> `1` cannot be used as a font; using global $DefaultFont instead."
DefineExternal::des = "External function `1` of `2` could not be defined; it may still be called with ExternalCall[`2`, CallPacket[`1`, {args}]]."
Derivative::novar = "`1` cannot be interpreted. A partial derivative requires a subscript differentiation variable."
DiagonalMatrix::offdim = "The matrix dimension `1` is not a machine-sized integer."
Dialog::dpa = "Abort while evaluating DialogProlog `1` caught in dialog."
Dialog::exd = "To exit a dialog, use Return[] or Return[expr]. To exit the entire Mathematica session, type Exit[]."
DigitCount::base = "The base `1` at position 2 of `2` should be an integer greater than 1."
DigitCount::digp = "Positive integer or list of non-negative integers less than the base `1` expected at position 3 in `2`."
Directory::dirx = "`1`"
Disk::angle = "Starting angle is larger than ending angle in angle specification `1`."
Disk::radius = "Radius `1` is not a positive number or a pair of positive numbers."
Display::badargs = "`1`"
Display::dispgif = "Too many arguments for GIF conversion."
Display::dopen = "Could not open the output file \"`1`\"."
Display::dwrite = "Could not write to the output file \"`1`\"."
Display::fname = "Filename `1` is not a string."
Display::gfile = "`1` is not a valid filename."
Display::image = Import::image = Export::image = ExportString::image = "Value of option `1` -> `2` is not a list of two numbers or Automatic."
Display::noform = "`1` is not a recognized Display format. The available formats include `2`."
Display::nolink = "Link to display device could not be opened."
Display::pserr = "`1`"
Display::type = "`1` is not a graphics, notebook, cell, or box expression."
Dot::dotsh = "Tensors `1` and `2` have incompatible shapes."
Dot::dotpat = "Cannot combine array of pattern type with an ordinary array."
DownValues::itloc = UpValues::itloc = OwnValues::itloc = FormatValues::itloc = DefaultValues::itloc = NValues::itloc = Messages::itloc = SubValues::itloc = "`1` currently contains iterator localizations, and cannot be set (to `2`)."
DownValues::vlist = UpValues::vlist = OwnValues::vlist = FormatValues::vlist = DefaultValues::vlist = NValues::vlist = Messages::vlist = SubValues::vlist = "Cannot set `1` to `2`; value must be a list of rules."
DownValues::vrule = UpValues::vrule = OwnValues::vrule = FormatValues::vrule = DefaultValues::vrule = NValues::vrule = Messages::vrule = SubValues::vrule = "Cannot set `1` to `2`; value contains `3`, which is not a rule."
Drop::drop = "Cannot drop positions `1` through `2` in `3`."
DSolve::dsfun = NDSolve::dsfun = RSolve::dsfun = "`1` cannot be used as a function."
DSolve::dsvar = NDSolve::dsvar = RSolve::dsvar = NDSolve`ProcessEquations::dsvar = "`1` cannot be used as a variable."
DSolve::deqx = NDSolve::deqx = "Supplied equations are not differential equations of the given functions."
RSolve::deqx = "Supplied equations are not difference equations of the given functions."
DSolve::dsmsm = RSolve::dsmsm = "Built-in routines cannot solve this problem. There is an equation that involves none of the dependent variables or there is a dependent variable that does not appear in any equation."
DSolve::underdet = RSolve::underdet = "There are more dependent variables than equations, so the system is underdetermined."
NDSolve::underdet = "There are more dependent variables, `1`, than equations, so the system is underdetermined."
DSolve::overdet = RSolve::overdet = "There are fewer dependent variables than equations, so the system is overdetermined."
NDSolve::overdet = "There are fewer dependent variables, `1`, than equations, so the system is overdetermined."
DSolve::deqn = NDSolve::deqn = RSolve::deqn = "Equation or list of equations expected instead of `1` in the first argument `2`."
DSolve::ivar2 = NDSolve::ivar2 = RSolve::ivar2 = "The independent variable `1` should not appear in two different arguments of the dependent variable `2`."
DSolve::pde = "Partial differential equation may not have a general solution. Try loading Calculus`DSolveIntegrals` to find special solutions."
DSolve::twoivarg = NDSolve::twoivarg = RSolve::twoivarg = "The function `1` has two independent variables in one argument. The independent variables should be in separate arguments."
DSolve::alliv = NDSolve::alliv = RSolve::alliv = "The function `1` was specified without dependence on all of the independent variables. Each function must depend on all of the independent variables."
DSolve::baddv = NDSolve::baddv = RSolve::baddv = "The dependent variable `1` is not clearly specified in the form `2`."
DSolve::ndord = NDSolve::ndord = NDSolve`Reinitialize::ndord = "Derivative order `1` in term `2` should be a non-negative machine-sized integer."
RSolve::rord = "Recurrence order `1` of equation `2` is not a machine-sized integer."
RSolve::piarg = "All arguments in position `1` of `2` should be either of the form `3` + integer or q^integer * `3`. Mixtures of these forms are not allowed."
DSolve::pdord = "The differential order of functions `1` is 0. All the functions must have positive differential order."
RSolve::pdord = "The recurrence order of functions `1` is 0. All the functions must have positive recurrence order."
NDSolve::pdord = "Some of the functions have zero differential order so the equations will be solved as a system of differential-algebraic equations."
DSolve::litarg = NDSolve::litarg = RSolve::litarg = "To avoid possible ambiguity, the arguments of the dependent variable in `1` should literally match the independent variables."
DSolve::bvimp = RSolve::bvimp = "General solution contains implicit solutions. In the boundary value problem these solutions will be ignored, so some of the solutions will be lost."
DSolve::bvlim = RSolve::bvlim = "For some branches of the general solution, unable to compute the limit at the given points. Some of the solutions may be lost."
DSolve::bvfail = RSolve::bvfail = "For some branches of the general solution, unable to solve the conditions."
DSolve::bvnul = RSolve::bvnul = "For some branches of the general solution, the given boundary conditions lead to an empty solution."
DSolve::bvnr = RSolve::bvnr = "For some branches of the general solution, the given boundary conditions do not restrict the existing freedom in the general solution."
DSolve::bvsing = RSolve::bvsing = "Unable to resolve some of the arbitrary constants in the general solution using the given boundary conditions. It is possible that some of the conditions have been specified at a singular point for the equation."
DSolve::nolist = "List encountered within `1`. There should be no lists on either side of the equations."
DSolve::nlpde = "Solution requested to nonlinear partial differential equation. Trying to build a special solution."
DumpGet::bgbf = "File `1` cannot be loaded, it is corrupted or is written on a different machine."
DumpGet::bgnew = "File `1` has been written by a newer version of DumpSave and cannot be loaded."
DumpGet::bgold = "Warning: File `1` has been written by an older version of DumpSave."
DumpGet::bgchk = "Checksum in binary file `1` does not agree."
DumpGet::bgcor = "Binary file `1` is corrupted."
DumpGet::valwarn = "Symbol `1` already has definition for `2`."
DumpSave::bschk = "Could not write to output file."
DumpSave::bsnosym = "`1` is not defined as a symbol or a context."
DumpSave::bsstm = "DumpSave will not write out stream information `1`."
DumpSave::outref = "Symbol `1` references an external object such as a file that will not be saved in the output."
EditDefinition::edsym = "`1` is not a symbol."
SparseArray`SVDArnoldi::svdwop = SingularValueList::svdwop = SingularValueDecomposition::svdwop = "The option `1` with value `2` is not accepted by `3`."
SparseArray`SVDArnoldi::noimp = SingularValueList::noimp = SingularValueDecomposition::noimp = "The generalized `1` for sparse matrices is not implemented yet."
SparseArray`SVDArnoldi::emeth = SparseArray`Arnoldi::emeth = SingularValueList::emeth = SingularValueDecomposition::emeth = Eigenvalues::emeth = Eigenvectors::emeth = Eigensystem::emeth = "The method specified by Method -> `1` should be either Automatic or Arnoldi."
SingularValueList::take = "Cannot take singular values `1` through `2` out of the total of `3` singular values."
SingularValueDecomposition::take = "Cannot take singular values and singular vectors `1` through `2` out of the total of `3` singular values and singular vectors."
MatrixRank::cflsvd = SingularValueDecomposition::cflsvd = SingularValueList::cflsvd = SingularValues::cflsvd = "Machine-precision algorithm failed to converge. Arbitrary-precision algorithm is called, which is slower but more accurate."
Eigenvalues::take = "Cannot take eigenvalues `1` through `2` out of the total of `3` eigenvalues."
Eigenvectors::take = "Cannot take eigenvectors `1` through `2` out of the total of `3` eigenvectors."
CharacteristicPolynomial::cpneig = "Cannot compute all the eigenvalues of the matrix `1`."
CharacteristicPolynomial::cpneig2 = "Cannot compute all the eigenvalues of the pair of matrices `1` and `2`."
CharacteristicPolynomial::cpnscr = "Cannot compute the Schur decomposition of the matrix `1`."
CharacteristicPolynomial::cpnscr2 = "Cannot compute the Schur decomposition of the pair of matrices `1` and `2`."
SparseArray`Arnoldi::take = Eigensystem::take = "Cannot take eigenvectors and eigenvalues `1` through `2` out of the total of `3` eigenvectors and eigenvalues."
SparseArray`SVDArnoldi::take = "Cannot take singular vectors and singular values `1` through `2` out of the total of `3` singular vectors and singular values."
SparseArray`Arnoldi::ars = Eigenvalues::ars = Eigenvectors::ars = Eigensystem::ars = "Method -> Arnoldi is typically only effective for finding a few eigenvalues and/or eigenvectors. Finding the requested `1` out of `2` eigenvalues and eigenvectors may be faster with dense matrix methods."
SparseArray`SVDArnoldi::ars = SingularValueList::ars = SingularValueDecomposition::ars = "Method -> Arnoldi is typically only effective for finding a few singular values and/or singular vectors.  Finding the requested `1` out of the `2` singular values and singular vectors may be faster with dense matrix methods."
SparseArray`Arnoldi::arall = Eigenvalues::arall = Eigenvectors::arall = Eigensystem::arall = "Method -> Arnoldi cannot be used to compute more than `1` out of the `2` eigenvalues and/or eigenvectors."
SparseArray`SVDArnoldi::arall = SingularValueDecomposition::arall = SingularValueList::arall =  "Method -> Arnoldi cannot be used to compute more than `1` out of the `2` singular values and/or singular vectors."
SparseArray`SVDArnoldi::arfac = SparseArray`Arnoldi::arfac = SingularValueDecomposition::arfac = SingularValueList::arfac = Eigenvalues::arfac = Eigenvectors::arfac = Eigensystem::arfac = "Arnoldi algorithm failed because it could not build an Arnoldi factorization."
SparseArray`Arnoldi::arh = Eigenvalues::arh = Eigenvectors::arh = Eigensystem::arh = "Because finding `1` out of the `2` eigenvalues and/or eigenvectors is likely to be faster with dense matrix methods, the sparse input matrix will be converted.  If fewer eigenvalues and/or eigenvectors would be sufficient, consider restricting this number using the second argument to `3`."
SparseArray`SVDArnoldi::arh = SingularValueDecomposition::arh = SingularValueList::arh = "Because finding `1` out of the `2` singular values and/or singular vectors is likely to be faster with dense matrix methods, the sparse input matrix will be converted.  If fewer singular values and/or singular vectors would be sufficient, consider restricting this number using the second argument to `3`."
SparseArray`Arnoldi::arhm = Eigenvalues::arhm = Eigenvectors::arhm = Eigensystem::arhm = "Because finding `1` out of the `2` eigenvalues and/or eigenvectors is likely to be faster with dense matrix methods, the sparse input matrix will be converted.  If fewer eigenvalues and/or eigenvectors at machine precision would be sufficient, consider using N on the matrix and restricting this number using the second argument to `3`."
SparseArray`SVDArnoldi::arhm = SingularValueDecomposition::arhm = SingularValueList::arhm = "Because finding `1` out of the `2` singular values and/or singular vectors is likely to be faster with dense matrix methods, the sparse input matrix will be converted.  If fewer singular values and/or singular vectors at machine precision would be sufficient, consider using N on the matrix and restricting this number using the second argument to `3`."
SparseArray`SVDArnoldi::armw = SparseArray`Arnoldi::armw = SingularValueDecomposition::armw = SingularValueList::armw = Eigenvalues::armw = Eigenvectors::armw = Eigensystem::armw = "The iterative Arnoldi method can only be used for matrices of machine numbers.  `1` will use dense matrix methods instead."
SparseArray`SVDArnoldi::arm = SparseArray`Arnoldi::arm = SingularValueDecomposition::arm = SingularValueList::arm = Eigenvalues::arm = Eigenvectors::arm = Eigensystem::arm = "Method -> Arnoldi can only be used for matrices of machine numbers."
SparseArray`SVDArnoldi::armc = SparseArray`Arnoldi::armc = SingularValueDecomposition::armc = SingularValueList::armc = Eigenvalues::armc = Eigenvectors::armc = Eigensystem::armc = "The Arnoldi method has encountered an intermediate value that is not a machine number."
SparseArray`Arnoldi::argpd = Eigenvalues::argpd = Eigenvectors::argpd = Eigensystem::argpd = "The input matrices are sufficiently sparse that it is likely that the Arnoldi method would be faster for computing the requested eigenvalues and eigenvectors.  However, the algorithm requires that the second matrix be positive definite, so dense methods will be used.  If you know that the second matrix is positive definite, it is recommended that you use Method -> Arnoldi in `1`."
SparseArray`SVDArnoldi::argpd = SingularValueDecomposition::argpd = SingularValueList::argpd = "The input matrices are sufficiently sparse that it is likely that the Arnoldi method would be faster for computing the requested singular values and singular vectors.  However, the algorithm requires that the second matrix be positive definite, so dense methods will be used.  If you know that the second matrix is positive definite, it is recommended that you choose Method -> Arnoldi in `1`."
SparseArray`Arnoldi::arconv = Eigenvalues::arconv = Eigenvectors::arconv = Eigensystem::arconv = "Could not find any eigenvalues to sufficient accuracy."
SparseArray`SVDArnoldi::arconv = SingularValueDecomposition::arconv = SingularValueList::arconv = "Could not find any singular values to sufficient accuracy."
SparseArray`SVDArnoldi::aribs = SparseArray`Arnoldi::aribs = SingularValueDecomposition::aribs = SingularValueList::aribs = Eigenvalues::aribs = Eigenvectors::aribs = Eigensystem::aribs = "No shifts could be applied during a cycle of the implicitly restarted Arnoldi iteration. Increasing the basis size with the method options Method -> {Arnoldi, BasisSize -> n}, where n is an integer no greater than the dimension of the matrix, may help."
SparseArray`SVDArnoldi::maxit = SparseArray`Arnoldi::maxit = SingularValueDecomposition::maxit = SingularValueList::maxit = Eigenvalues::maxit = Eigenvectors::maxit = Eigensystem::maxit = "Maximum number of iterations, `1`, has been reached by the Arnoldi algorithm without convergence to the specified tolerance.  You can use method options with Method -> {Arnoldi, opts) to increase the basis size or the maximum number of iterations, reduce the tolerance, or choose an appropriate shift, any of which may help."
SparseArray`SVDArnoldi::maxit2 = SparseArray`Arnoldi::maxit2 = SingularValueDecomposition::maxit2 = SingularValueList::maxit2 = Eigenvalues::maxit2 = Eigenvectors::maxit2 = Eigensystem::maxit2 = "Maximum number of iterations, `1`, has been reached by the Arnoldi algorithm without convergence to the specified tolerance, but the current best computed value has been returned.  You can use method options with Method -> {Arnoldi, opts} to increase the basis size or the maximum number of iterations, reduce the tolerance, or use an estimate as a shift, any of which may help."
SparseArray`SVDArnoldi::arstv = SparseArray`Arnoldi::arstv = SingularValueDecomposition::arstv = SingularValueList::arstv = Eigenvalues::arstv = Eigenvectors::arstv = Eigensystem::arstv = "The starting vector must have at least one nonzero component."
SparseArray`SVDArnoldi::arbsym = SparseArray`Arnoldi::arbsym = SingularValueDecomposition::arbsym = SingularValueList::arbsym = Eigenvalues::arbsym = Eigenvectors::arbsym = Eigensystem::arbsym = "You can only choose the Arnoldi method option Criteria -> BothEnds for real symmetric matrices."
SparseArray`Arnoldi::arb2 = Eigenvalues::arb2 = Eigenvectors::arb2 = Eigensystem::arb2 = "With the Arnoldi method option Criteria -> BothEnds, you need to request two or more eigenvalues and/or eigenvectors."
SparseArray`SVDArnoldi::arb2 = SingularValueDecomposition::arb2 = SingularValueList::arb2 = "With the Arnoldi method option Criteria -> BothEnds, you need to request two or more singular values and/or singular vectors."
SparseArray`SVDArnoldi::arerr = SparseArray`Arnoldi::arerr = SingularValueDecomposition::arerr = SingularValueList::arerr = Eigenvalues::arerr = Eigenvectors::arerr = Eigensystem::arerr = "Could not continue Arnoldi algorithm due to an invalid LAPACK operation."
SparseArray`SVDArnoldi::arbss =  SingularValueDecomposition::arbss = SingularValueList::arbss = "The value of the option BasisSize -> `1` should be an integer greater than `2`, and cannot exceed `3`."
SparseArray`Arnoldi::arbss = Eigenvalues::arbss = Eigenvectors::arbss = Eigensystem::arbss = "The value of the option BasisSize -> `1` should be an integer greater than `2`, and cannot exceed the dimension of the matrix, `3`."
SparseArray`SVDArnoldi::arbs = SingularValueDecomposition::arbs = SingularValueList::arbs = "The value of the option BasisSize -> `1` should be an integer greater than `2`, and cannot exceed `3`."
SparseArray`Arnoldi::arbs = Eigenvalues::arbs = Eigenvectors::arbs = Eigensystem::arbs = "The value of the option BasisSize -> `1` should be an integer greater than `2`, and cannot exceed the dimension of the matrix, `3`."
SparseArray`SVDArnoldi::lsgma = SingularValueDecomposition::lsgma = SingularValueList::lsgma = "The option Shift is used only for computing a few singular values close to the value of Shift. The second argument of `1` should be a positive small integer because computing other singular values may not be accurate."
SparseArray`Arnoldi::lsgma = Eigenvalues::lsgma = Eigenvectors::lsgma = Eigensystem::lsgma = "The option Shift is used only for computing a few eigenvalues close to the value of Shift; the second argument of `1` should be a positive small integer because computing other eigenvalues may not be accurate."
SparseArray`Arnoldi::bsing = Eigenvalues::bsing = Eigenvectors::bsing = Eigensystem::bsing = "The right-hand side matrix of the generalized eigenvalue problem is singular."
SparseArray`SVDArnoldi::bsing = SingularValueDecomposition::bsing = SingularValueList::bsing = "The right-hand side matrix of the generalized singular value problem is singular."
SparseArray`Arnoldi::eslct = Eigenvalues::eslct = Eigenvectors::eslct = Eigensystem::eslct = "A value of the option Criteria must be one of \"Magnitude\", \"RealPart\", \"ImaginaryPart\", or \"BothEnds\", with \"BothEnds\" appropriate for real symmetric eigenvalue problems only."
SparseArray`SVDArnoldi::eslct = SingularValueDecomposition::eslct = SingularValueList::eslct = "A value of the option Criteria must be one of \"Magnitude\", \"RealPart\", or \"BothEnds\"."
SparseArray`SVDArnoldi::mcsgma = SparseArray`Arnoldi::mcsgma = SingularValueDecomposition::mcsgma = SingularValueList::mcsgma = Eigenvalues::mcsgma = Eigenvectors::mcsgma = Eigensystem::mcsgma = "Value of option Shift -> `1` must be a machine number."
SparseArray`Arnoldi::svecnm = Eigenvalues::svecnm = Eigenvectors::svecnm = Eigensystem::svecnm = "A value of the option StartingVector -> `1` must be a vector of machine numbers, of the same length as the row dimension of the matrix."
SparseArray`SVDArnoldi::svecnm = SingularValueDecomposition::svecnm = SingularValueList::svecnm = "A value of the option StartingVector -> `1` must be a vector of machine numbers, of the length equal to the sum of the row and column dimensions of the matrix."
SparseArray`Arnoldi::ssing = Eigenvalues::ssing = Eigenvectors::ssing = Eigensystem::ssing = "Failed to factor the matrix involving the shift. This may be caused by the shift, `1`, corresponding exactly to an eigenvalue. Changing the shift value slightly might help."
SparseArray`SVDArnoldi::ssing = SingularValueDecomposition::ssing = SingularValueList::ssing = "Failed to factor the matrix involving the shift. This may be caused by the shift, `1`, corresponding exactly to a singular value. Changing the shift value slightly might help."
SparseArray`KrylovLinearSolve::kryzrow = LinearSolve::kryzrow = SparseArray`SparseMatrixILU::kryzrow = "Each row of the sparse matrix `1` must contain at least one nonzero element." 
SparseArray`KrylovLinearSolve::kryinz = LinearSolve::kryinz = SparseArray`SparseMatrixILU::kryinz = "The sparse matrix `1` must have an implicit value equal to zero." 
SparseArray`KrylovLinearSolve::krypat = LinearSolve::krypat = SparseArray`SparseMatrixILU::krypat = "The sparse matrix `1` cannot contain a pattern."
SparseArray`KrylovLinearSolve::krylfil = LinearSolve::krylfil = SparseArray`SparseMatrixILU::krylfil = "The value of the option FillIn must be a non-negative integer."
SparseArray`KrylovLinearSolve::krynfl0 = LinearSolve::krynfl0 = SparseArray`SparseMatrixILU::krynfl0 = "The option FillIn is not a valid option for the preconditioner ILU0."
SparseArray`KrylovLinearSolve::krynpmt = LinearSolve::krynpmt = SparseArray`SparseMatrixILU::krynpmt = "The option PermutationTolerance is not a valid option for the preconditioner ILU0 or ILUT."
SparseArray`KrylovLinearSolve::kryptol = LinearSolve::kryptol = SparseArray`SparseMatrixILU::kryptol = "Value of option PermutationTolerance -> `1` is not a non-negative real number or Automatic."
SparseArray`KrylovLinearSolve::kryzspd = LinearSolve::kryzspd = SparseArray`SparseMatrixILU::kryzspd = SparseArray`SparseMatrixApplyILU::kryzspd = "The sparse matrix `1` has zero element(s) on the main diagonal."
SparseArray`KrylovLinearSolve::kryzspd2 = LinearSolve::kryzspd2 = SparseArray`SparseMatrixILU::kryzspd2 = SparseArray`SparseMatrixApplyILU::kryzspd2 = "Warning: The sparse matrix `1` has zero element(s) on the main diagonal. The zero diagonal elements are replaced with a small number."
SparseArray`KrylovLinearSolve::kryprtl = LinearSolve::kryprtl = SparseArray`SparseMatrixILU::kryprtl = "Initial preconditioned residual is `1` times larger than unpreconditioned residual. The GMRES method will not converge."
SparseArray`SparseMatrixILU::krynilu = "`1` is not a valid ILU method." 
Eigensystem::geidm = Eigenvectors::geidm = Eigenvalues::geidm = "Incompatible matrix dimensions."
Eigensystem::geinsl = Eigenvectors::geinsl = Eigenvalues::geinsl = "Cannot find a solution for the generalized eigenproblem."
LinearAlgebra`Internal`Orthogonalize::orbop = Orthogonalize::orbop = "`1` is not a valid value for the Method option."
LinearAlgebra`Internal`Orthogonalize::ornex = Orthogonalize::ornex = "The option Method -> Reorthogonalization cannot be used with exact precision vectors. It is replaced with Method -> GramSchmidt."
LinearAlgebra`Internal`Orthogonalize::ornh = Orthogonalize::ornh = "The option Method -> Householder cannot be used with symbolic or exact precision vectors."
LinearAlgebra`Internal`Orthogonalize::ornhip = Orthogonalize::ornhip = "The option Method -> Householder can only be used with the default (Automatic) inner product."
LinearAlgebra`Internal`Orthogonalize::ornfa = Orthogonalize::ornfa = "The second argument `1` is not an inner product function, that always should return a number or symbol. If its two numeric arguments are the same, it should return a non-negative real number."
LinearAlgebra`Internal`Orthogonalize::orwdt = Orthogonalize::orwdt = "At least one element of the first argument cannot be used with the Dot inner product."
LinearAlgebra`Internal`Orthogonalize::ornvm = Orthogonalize::ornvm = "The first argument is not a vector or matrix."
LinearAlgebra`Internal`Orthogonalize::ornt = Orthogonalize::ornt = "The first argument `1` is incorrect. It should be a vector, matrix, or tensor." 
LinearAlgebra`Internal`Orthogonalize::orsym = Orthogonalize::orsym = "The option Method -> `1` is replaced by Method -> GramSchmidt."
Normalize::nlnfa = "The second argument `1` is not a norm function that always returns a non-negative real number for any numeric argument."
Normalize::nlnmat = "The first argument must be a number or a vector."
Normalize::nlnmt2 = "The first argument is not a number or a vector, or the second argument is not a norm function that always returns a non-negative real number for any numeric argument."
Projection::prnv = "The first and/or second argument are not vectors, or they are not vectors of equal length."
Projection::prnve = "The first and/or second argument is not an expression or a vector."
Projection::prne = "The first and/or second argument is not an expression."
Projection::prnip = "The inner product seems to be incorrect for the given two expressions/vectors. It cannot provide a reasonable result."
TransformationFunction::comp = "`1` and `2` in Composition have incompatible dimensions."
TransformationFunction::fdim = "`1` is not a vector of length `2` or a list of length `2` vectors."
TransformationFunction::inverse = "`1` is not invertible."
TransformationMatrix::input = "`1` is not a TransformationFunction object."
GeometricTransformation::nonaffine = "`1` is not an affine transformation function."
AffineTransform::input = "The input is expected be one of the forms: AffineTransform[{A}] or AffineTransform[{A,b}], where A is a matrix and b is a vector of appropriate dimension."
AffineTransform::rowdim = "The number of rows in `1` is not equal to the length of `2`."
LinearFractionalTransform::rowdim = "The number of rows in `1` is not equal to the length of `2`."
LinearFractionalTransform::coldim = "The number of columns `1` is not equal to the length `2`."
LinearFractionalTransform::input = "The input is expected to be one of the forms: LinearFractionalTransform[A], LinearFractionalTransform[{A,b,c,d}], LinearFractionalTransform[{A,b,c}], where A is a  matrix, b and c are vectors of appropriate dimension and d is a scalar."
RotationMatrix::degen = "The two vectors `1` provided for the rotation plane appear to be along the same line."
RotationMatrix::input = "The input is expected to be of one of the forms RotationMatrix[\[Theta]], RotationMatrix[\[Theta],w], RotationMatrix[\[Theta], {u,v}] or RotationMatrix[{u,v}], where \[Theta] is an angle and u, v and w are vectors of appropriate dimension."
ReflectionMatrix::input = "The input is expected to be of the form ReflectionMatrix[v], where v is a vector."
ScalingMatrix::input = "The input is expected to be of one of the forms ScalingMatrix[s,v] or ScalingMatrix[{s1,...,sn}] where s and si are scalars and v is a vector."
ShearingMatrix::input = "The input is expected to be of the form ShearingMatrix[\[Theta],v,n], where \[Theta] is an angle and v and n are vectors of appropriate dimension."
RotationTransform::input = "The input is expected to be of one of the forms RotationTransform[\[Theta]], RotationTransform[\[Theta],q], RotationTransform[\[Theta],w], RotationTransform[\[Theta],w,q], RotationTransform[\[Theta],{u,v}], RotationTransform[\[Theta],{u,v},q], RotationTransform[{u,v}] or RotationTransform[{u,v},q], where \[Theta] is an angle and u,v,w and q are vectors of appropriate dimension."
ReflectionTransform::input = "The input is expected to be of one of the forms ReflectionTransform[v] or ReflectionTransform[v,q] where v and q are vectors."
ScalingTransform::input = "The input is expected to be of one of the forms ScalingTransform[s,v], ScalingTransform[s,v,q], ScalingTransform[{s1,s2,...}] or ScalingTransform[{s1,s2,...}, q], where s and si are scalars and v and q are vectors of appropriate dimension."
ShearingTransform::input = "The input is expected to be of one of the forms ShearingTransform[\[Theta],v,n] or ShearingTransform[\[Theta],v,n,q], where \[Theta] is an angle and v, n and q are vectors of appropriate dimension."
TranslationTransform::input = "The input is expected to be of the form TranslationTransform[v], where v is a vector."
RescalingTransform::input = "The input is expected to be of one of the forms RescalingTransform[{{l1,u1},...,{ln,un}}] or RescalingTransform[{{l1,u1},...,{ln, un}}, {{L1,U1}, ..., {Ln,Un}}], where li, ui, Li and Ui are scalars."
RescalingTransform::finite = "RescalingTransform is intended for rescaling with finite ranges only."
RescalingTransform::sing="Cannot transform zero range in one of the components to non-zero range."
LeastSquares::lsnomtd = "A wrong value of the option Method. The acceptable methods are Automatic, Direct, Krylov, and NormalizedColumns."
LeastSquares::lsspmtd = "The option Method with value \"Krylov\" can be used only with a first argument that is a sparse matrix."
LeastSquares::lsnspmtd = "The option Method with value \"IterativeRefinement\" can be used only with a first argument that is a dense matrix."
LeastSquares::lszimp = "The option Method -> NormalizedColumns cannot be used with a sparse matrix having nonzero implicit value `1`."
LeastSquares::lsncex = "The option Method -> NormalizedColumns has no effect because exact array columns will not be normalized."
LeastSquares::lslmw = "For the option Method -> IterativeRefinement an auxiliary matrix is built that requires at least `1` Megabytes of memory."
Element::bset = "The second argument `1` of Element should be one of: Primes, Integers, Rationals, Algebraics, Reals, Complexes, or Booleans."
EllipticLog::elld = "The arguments to `1` are inconsistent with the defining equation y^2 == x^3 + a x^2 + b x."
EllipticLog::ellnp = EllipticExp::ellnp = "The argument `1` is not an ordered pair; a list of length 2 is expected."
EllipticReducedHalfPeriods::nind = "Half-periods `1` are not independent."
EllipticTheta::etype = EllipticThetaPrime::etype = "The first argument `1` is expected to be 1, 2, 3, or 4."
End::noctx = EndAdd::noctx = EndPackage::noctx = "No previous context defined."
Except::named = "Named pattern variables are not allowed in the first argument of `1`."
Except::lenmod = "A variable-length pattern is not allowed as the second argument in `1`."
ExitDialog::cant = "No dialog to exit from."
Export::badval = "The element `1` contains invalid values."
Export::bitcon = "BITPIX options, `1`, and BITPIX in header, `2`, have conflicting values. Using header value."
Export::bitrange = "BITPIX value `1` does not cover the data range. Try using `2`."
Export::bitval = "BITPIX value `1` is not a valid value."
Export::chtype = "First argument `1` is not a valid file specification."
Export::coerce = "Coercing `1` to `2` zero."
Export::erropts = Import::erropts = "The value `1` specified for the option `2` is invalid."
Export::createdir = "Export assumed `1` to be a directory into which to write an index.html file, but was unable to create this directory. Either create this directory and re-run HTMLSave, or choose a different destination for the HTML file."
Export::dffsr = "Cannot export a sound with multiple sample rates."
Export::dupelem = "The elements contain duplicate data for the `1` format."
Export::errelem = "The Export element `1` contains a malformed data structure and could not be exported to `2` format."
Export::errfile = Import::errfile = "Could not access the file. `1`."
Export::errstruct = Import::errstruct = "Malformed data structure. `1`."
Export::range = "The element `1` contains data that is out of range."
Export::fmterr = "Invalid `1` format."
Export::format = "`1` is not a recognized Export format."
Export::h5error = Import::h5error = "Could not execute HDF5 interface operation \"`1`\"; returned code `2`."
Export::dtaexist = "Could not append to the file because the dataset \"`1`\" already exists."
Export::h5noauto = "Could not coerce the expression into an array of integers or reals."
Export::noauto = "Could not coerce the expression into an array of integers or reals."
Export::incom = "Length `2` of list of expressions `1` does not match length `4` of list of elements `3`."
Export::ignore = "Ignoring `1` because it does not match the `2` format."
Export::inselem = "There are insufficient elements to create the `1` format."
Export::inselem2 = "There are insufficient elements in `1` to export to the specified format."
Export::int = "Warning: Sparse array `1` to be exported in `2` format has integer entries. They will be converted to real entries."
Export::uneqlen = "Elements `1` and `2` must have the same length."
Export::memavail = "Could not allocate memory for export of `1` format."
Export::no2dgr = "Two-dimensional graphics objects cannot be exported to `1` format. `1` format may be used for three-dimensional graphics."
Export::nocomp = "The given data cannot be exported to `1` format in compressed form. The data will be exported without compression."
Export::nodta = "`1` contains no data that can be exported to the `2` format."
Export::nodir = "Directory `1` does not exist."
Export::nodirsup = "Cannot export `2` format to directory `1`."
Export::noncompelem = "`1` is not compatible with `2`."
Export::noelem = "The Export elements `1` are not a valid set of elements for the `2` format."
Export::nofile = "Filenames were not specified for Export to the `1` format."
Export::noopts = "The Export option `1` is invalid for the `2` format."
Export::noscaled = "Scaled coordinates are currently not supported for Export of 3D formats."
Export::nofe = "A front end is not available; export of `1` requires a front end."
Export::nomatch = "Expression `1` does not match the format `2`."
Export::rasterr = "An unrecoverable error was encountered when rasterizing."
Export::obs = Import::obs = "`1` is obsolete."
Export::convoptobs = ExportString::convoptobs = Import::convoptobs = ImportString::convoptobs = "ConversionOptions are obsolete.  See the `1` format page for supported options."
General::obsalt = "`1` is obsolete. Instead, use `2`."
General::obsalt2 = "`1` will soon be obsolete. Instead, use `2`."
Export::optvmtx = "`1` is not a valid value for \"MatrixStructure\". Acceptable values are \"Unsymmetric\", \"Symmetric\", \"SkewSymmetric\", \"Hermitian\", and \"Rectangular\". \"MatrixStructure\" -> \"Unsymmetric\" is assumed."
Export::optsymmtx = "Option \"MatrixStructure\" -> \"Symmetric\" is specified, but the matrix `1` is not symmetric."
Export::optzmtx = "Option \"MatrixStructure\" -> \"SkewSymmetric\" is specified, but the matrix `1` is not skew symmetric."
Export::optcmtx = "Option \"MatrixStructure\" -> \"Hermitian\" is specified, but the matrix `1` is not Hermitian."
Export::optcc = "Option \"MatrixStructure\" -> \"Hermitian\" is specified, but the matrix `1` is not complex. Using \"MatrixStructure\" -> \"Symmetric\" instead."
Export::padbits = "Padding bits with zeros to create an integer number of bytes."
Export::rank = "The sparse array `1` to be exported in `2` format is not a matrix of rank 2."
Export::smtcsml = "Cannot infer semantics from MathML presentation elements in `1`"
Export::sndprm = "Cannot export sound to `1` using the specified settings."
Export::toomany = "Cannot export to `1`.  The number of `2` exceeds the limit supported by this format."
Export::toobig = "Cannot export to `1`.  Size of resulting data would exceed the limit supported by this format."
Export::type = "`1` cannot be exported to the `2` format."
Export::unsupfmt = Import::unsupfmt = "The `1` format is not currently supported on this platform."
Export::autofix = "Malformed symbolic XML expression encountered. This may result in unexpected XML data."
Export::badqte = "The quote character `1` is not a valid attribute quoting character. Attributes in the exported XML will be surrounded with single quotes."
Export::malsxml = "Malformed symbolic XML `1` expression may result in an invalid XML file."
Export::unrecov = "Could not export symbolic XML expression."
Export::xmlmal = "Malformed symbolic XML expression `1` encountered in export."
Export::xmlnopt = "An option was expected instead of `1` when exporting the symbolic XML expression `2`."
Export::xmloptv = "The value of option `1` in `2` is not valid in the exporting of the symbolic XML expression `3`."
Export::xmloptx = "Unknown option `1` encountered in the exporting of the symbolic XML expression `2`."
ExportString::format = "`1` is not a recognized ExportString format."
Rasterize::nofe = "A front end is not available; Rasterize requires a front end."
Rasterize::pxarr = "The pixel array dimension `1` is not a positive integer or a list of two positive integers."
Rasterize::noelem = "The element `1` is not a valid element for Rasterize."
Rasterize::type = "`1` cannot be rasterized."
ExtendedGCD::egcd = "Arguments in `1` should be integers."
ExtendedGCD::egcdz = "ExtendedGCD[0,0] has no unique solution."
LinearSolve::notrhsm = "Incorrect value of the second argument. Only the strings \"N\", \"T\", \"C\", or \"J\" are valid."
LinearSolve::rmeth = "Value of option Method -> `1` should be \"Cholesky\", \"Multifrontal\", \"Krylov\", \"CofactorExpansion\", \"OneStepRowReduction\", \"DivisionFreeRowReduction\", \"Direct\", \"IterativeRefinement\", or Automatic."
LinearSolve::mronly = "Only machine-real code is available for sparse matrices. If your matrix is not too large, consider trying again after using Normal on the matrix."
LinearSolveFunction::mconly = LinearSolve::mconly = "Only machine number code is available for sparse matrices. If your matrix is not too large, consider trying again after using Normal on the matrix."
LinearSolveFunction::spfac = "The sparse LU factors are not available separately."
LinearSolveFunction::mcovl = NDSolve::mcovl = LinearSolve::mcovl = "The computation encountered machine-number overflow.  Only machine-number code is available for sparse matrices. If your matrix is not too large, consider trying again after using Normal on the matrix."
LinearSolve::nolib = "The library for the sparse method chosen is not available on this platform.  Try choosing another method."
LinearSolve::lupat = "Cannot compute solutions for Pattern type sparse matrices."
LinearSolve::sqmat = "The matrix `1` is not square.  A square matrix is needed to compute a factorization."
LinearSolve::npdef = "The matrix `1` is not positive definite."
LinearSolve::herm = "The matrix `1` is not Hermitian or real symmetric, which is necessary for Method -> Cholesky."
LinearSolve::tmm = "Pre-factorization analysis indicates that the solution will require too much memory."
LinearSolve::sing1 = "The matrix `1` is singular so a factorization will not be saved."
LinearSolve::sqmat1 = "The matrix `1` is not square so a factorization will not be saved."
SparseArray`KrylovLinearSolve::krynfa = LinearSolve::krynfa = "The first argument `1` is not a square matrix or a function generating a vector of length equal to the length of the second argument."
SparseArray`KrylovLinearSolve::krycomp = LinearSolve::krycomp = "There are expressions generated by the Krylov method that are too complex to be compared."
SparseArray`KrylovLinearSolve::kryme = LinearSolve::kryme = "`1` is not a supported Krylov method."
SparseArray`KrylovLinearSolve::kryit = LinearSolve::kryit = "Value of option MaxIterations -> `1` should be a positive integer or Automatic."
SparseArray`KrylovLinearSolve::krypre = LinearSolve::krypre = "Value of option Preconditioner -> `1` is not ILU0, ILUT, ILUTP, or a user-defined function."
SparseArray`KrylovLinearSolve::krynor = LinearSolve::krynor = "Value of option ResidualNormFunction -> `1` is not a valid function."
SparseArray`KrylovLinearSolve::krynorv = LinearSolve::krynorv = "The result of applying the user-specified norm function `1` is not a valid number."
SparseArray`KrylovLinearSolve::krydia = LinearSolve::krydia = "ILU preconditioner is specified, but since there are missing diagonal entries in the input matrix, no preconditioner will be used."
SparseArray`KrylovLinearSolve::krymit = LinearSolve::krymit = "The maximum number of iterations, `1`, has been reached by the Krylov algorithm without convergence to a solution within the required tolerance. The currently computed solution has been returned."
SparseArray`KrylovLinearSolve::krypr = LinearSolve::krypr = "The result of applying the user-specified preconditioner `1` is not a list with length equal to the row dimension of the matrix."
SparseArray`KrylovLinearSolve::kryma = LinearSolve::kryma = "The result of applying the user-specified matrix `1` is not a list with length equal to the row dimension of the matrix."
SparseArray`KrylovLinearSolve::krynom = LinearSolve::krynom = "Non-numerical quantities were encountered during Krylov iteration. This could be because these linear equations have no solution."
SparseArray`KrylovLinearSolve::krynum = LinearSolve::krynum = "Input to Krylov algorithm contains elements that are not explicit numbers."
SparseArray`KrylovLinearSolve::kryivec = LinearSolve::kryivec = "An initial vector should be a vector of numbers."
SparseArray`KrylovLinearSolve::kryinfp = LinearSolve::kryinfp = "Input to Krylov algorithm is of infinite precision. Iterations may become very slow due to expression size growth."
SparseArray`KrylovLinearSolve::krynpd = LinearSolve::krynpd = "The input matrix is not positive definite. The conjugate gradient method cannot continue computations."
SparseArray`KrylovLinearSolve::krybsv = LinearSolve::krybsv = "The value of the option BasisSize must be a positive integer."
SparseArray`KrylovLinearSolve::krystg = LinearSolve::krystg = "The iterative method stagnates and cannot find a better solution."
SparseArray`KrylovLinearSolve::krybrk = LinearSolve::krybrk = "The iterative method breaks down and cannot continue computations. You can restart the method with another initial vector or change the method."
SparseArray`KrylovLinearSolve::kryexn = LinearSolve::kryexn = "This Krylov method does not work with exact numbers."
SparseArray`KrylovLinearSolve::krytol = LinearSolve::krytol = "Cannot compute a solution with the required tolerance. The current solution has been returned."
SparseArray`KrylovLinearSolve::kryprsd = LinearSolve::kryprsd = "PreconditionerSide option value is not Left or Right."
SparseArray`KrylovLinearSolve::krynrpr = LinearSolve::krynrpr = "The option PreconditionerSide cannot be used with the method `1`."
SparseArray`KrylovLinearSolve::krymbs = LinearSolve::krymbs = "The suboption BasisSize cannot be used with the method `1`."
SparseArray`KrylovLinearSolve::krymbs1 = LinearSolve::krymbs1 = "Wrong suboption for the method `1`."
SparseArray`KrylovLinearSolve::krypo = LinearSolve::krypo = "Suboptions cannot be used with the preconditioner method `1`."
SparseArray`KrylovLinearSolve::krypo1 = LinearSolve::krypo1 = "Wrong suboption(s) for the preconditioner method `1`."
General::lsnmod = "The option Modulus may be specified only for integer or rational matrices." 
LinearSolve::lsnzt = "The option ZeroTest may be specified only for integer or rational matrices."
LinearAlgebra`LinearSolve`IterativeRefinement::maxit = "Maximum number of iterations `1` reached without convergence."
LinearAlgebra`LinearSolve`IterativeRefinement::slwconv = "Slow convergence (less than `1` digits per iteration)."
LinearAlgebra`LinearSolve`IterativeRefinement::infprec = "Computations cannot be carried out in infinite precision."
LinearAlgebra`LinearSolve`IterativeRefinement::lcondn = "The matrix condition number `1` is too large for starting precision `2`. The method may not converge."
General::wrgopt = "The value `1` of the option `2` is incorrect."
LinearAlgebra`LinearSolve`IterativeRefinement::wrgopt1 = "Incorrect IterativeRefinement method option(s)."
LinearAlgebra`MatrixConditionNumber::nrmp = "The value `1` of the option Norm is incorrect. It should be 1 or Infinity."
Developer`SparseLinearSolve::lsvs = "Argument `1` is neither a nonempty vector of machine-sized numbers nor a list of same-length vectors of machine-sized numbers."
DiscreteMath`DecisionDiagram`BDD::bddold = "The BDD corresponding to `1` has been deleted by ClearBDD."
DiscreteMath`DecisionDiagram`ToBDD::bdderr = DiscreteMath`DecisionDiagram`FromBDD::bdderr = DiscreteMath`DecisionDiagram`BDDExpand::bdderr = DiscreteMath`DecisionDiagram`BDDInstance::bdderr = "BDD computations failed."
DiscreteMath`DecisionDiagram`FromBDD::varnum = DiscreteMath`DecisionDiagram`BDDInstance::varnum = "The function `1` has arity `2`. It cannot be applied to `3` variables."
DiscreteMath`DecisionDiagram`ClearBDD::clrf = "Cannot restart the BDD manager. The limit on the number of restarts has been reached."
GraphUtilities`GraphCoordinateRules1D::tsf = GraphUtilities`GraphCoordinateRules::tsf = GraphUtilities`GraphCoordinateRules3D::tsf = GraphUtilities`GraphCoordinates::tsf = GraphUtilities`GraphCoordinates3D::tsf = GraphUtilities`GraphCoordinates1D::tsf = TreePlot::tsf = GraphPlot::tsf = SparseArray`GraphPlacement::tsf = GraphPlot3D::tsf = SparseArray`GraphPlacement3D::tsf = "The value of option \"LayerSizeFunction\" -> `1` does not evaluate to a machine-sized real number at `2`."
GraphUtilities`GraphCoordinateRules1D::grph = GraphUtilities`GraphCoordinateRules::grph = GraphUtilities`GraphCoordinateRules3D::grph = GraphUtilities`GraphCoordinates::grph = GraphUtilities`GraphCoordinates3D::grph = GraphUtilities`GraphCoordinates1D::grph = TreePlot::grph = LayeredGraphPlot::grph = GraphPlot::grph = SparseArray`GraphPlacement::grph = GraphPlot3D::grph = SparseArray`GraphPlacement3D::grph = "`1` is not a valid graph."
GraphUtilities`GraphCoordinateRules1D::sqma = GraphUtilities`GraphCoordinateRules::sqma = GraphUtilities`GraphCoordinateRules3D::sqma = GraphUtilities`GraphCoordinates::sqma = GraphUtilities`GraphCoordinates3D::sqma = GraphUtilities`GraphCoordinates1D::sqma = TreePlot::sqma = LayeredGraphPlot::sqma = GraphPlot::sqma = SparseArray`GraphPlacement::sqma = GraphPlot3D::sqma = SparseArray`GraphPlacement3D::sqma = "First argument `1` is not a square matrix."
GraphUtilities`GraphCoordinateRules1D::coord = GraphUtilities`GraphCoordinateRules::coord = GraphUtilities`GraphCoordinateRules3D::coord = GraphUtilities`GraphCoordinates::coord = GraphUtilities`GraphCoordinates3D::coord = GraphUtilities`GraphCoordinates1D::coord = TreePlot::coord = LayeredGraphPlot::coord = GraphPlot::coord = SparseArray`GraphPlacement::coord = GraphPlot3D::coord = SparseArray`GraphPlacement3D::coord = "The second argument of `1` must be a matrix of real machine numbers with the same row dimension as the first argument and a column dimension of 2 or 3."
GraphUtilities`GraphCoordinateRules1D::coord3 = GraphUtilities`GraphCoordinateRules::coord3 = GraphUtilities`GraphCoordinateRules3D::coord3 = GraphUtilities`GraphCoordinates::coord3 = GraphUtilities`GraphCoordinates3D::coord3 = GraphUtilities`GraphCoordinates1D::coord3 = TreePlot::coord3 = LayeredGraphPlot::coord3 = GraphPlot::coord3 = SparseArray`GraphPlacement::coord3 = GraphPlot3D::coord3 = SparseArray`GraphPlacement3D::coord3 = "Warning: The second argument of `1` has a column dimension of 3. It will be treated as 3D instead."
GraphUtilities`GraphCoordinateRules1D::coord2 = GraphUtilities`GraphCoordinateRules::coord2 = GraphUtilities`GraphCoordinateRules3D::coord2 = GraphUtilities`GraphCoordinates::coord2 = GraphUtilities`GraphCoordinates3D::coord2 = GraphUtilities`GraphCoordinates1D::coord2 = TreePlot::coord2 = LayeredGraphPlot::coord2 = GraphPlot::coord2 = SparseArray`GraphPlacement::coord2 = GraphPlot3D::coord2 = SparseArray`GraphPlacement3D::coord2 = "Warning: The second argument of `1` has a column dimension of 2. It will be treated as 3D instead."
GraphUtilities`GraphCoordinateRules1D::vcoord = GraphUtilities`GraphCoordinateRules::vcoord = GraphUtilities`GraphCoordinateRules3D::vcoord = GraphUtilities`GraphCoordinates::vcoord = GraphUtilities`GraphCoordinates3D::vcoord = GraphUtilities`GraphCoordinates1D::vcoord = TreePlot::vcoord = LayeredGraphPlot::vcoord = GraphPlot::vcoord = SparseArray`GraphPlacement::vcoord = GraphPlot3D::vcoord = SparseArray`GraphPlacement3D::vcoord = "Value of option VertexCoordinateRules -> `1` must be either a list of rules or a matrix of real machine numbers with a row dimension of `2` and a column dimension of `3`."
GraphUtilities`GraphCoordinateRules1D::mlv = GraphUtilities`GraphCoordinateRules::mlv = GraphUtilities`GraphCoordinateRules3D::mlv = GraphUtilities`GraphCoordinates::mlv = GraphUtilities`GraphCoordinates3D::mlv = GraphUtilities`GraphCoordinates1D::mlv = LayeredGraphPlot::mlv = GraphPlot::mlv = SparseArray`GraphPlacement::mlv = GraphPlot3D::mlv = SparseArray`GraphPlacement3D::mlv = "The value of option RecursionMethod -> `1` should be \"Multilevel\", Automatic, or None."
GraphUtilities`GraphCoordinateRules1D::mlvcrs = GraphUtilities`GraphCoordinateRules::mlvcrs = GraphUtilities`GraphCoordinateRules3D::mlvcrs = GraphUtilities`GraphCoordinates::mlvcrs = GraphUtilities`GraphCoordinates3D::mlvcrs = GraphUtilities`GraphCoordinates1D::mlvcrs = LayeredGraphPlot::mlvcrs = GraphPlot::mlvcrs = SparseArray`GraphPlacement::mlvcrs = GraphPlot3D::mlvcrs = SparseArray`GraphPlacement3D::mlvcrs = "The value of option CoarseningScheme -> `1` should be \"MaximalIndependentVertexSet\", \"MaximalIndependentVertexSetInjection\", \"MaximalIndependentVertexSetRugeStuben\", \"MaximalIndependentVertexSetRugeStubenInjection\", \"MaximalIndependentEdgeSet\", \"MaximalIndependentEdgeSetHeavyEdge\", \"MaximalIndependentEdgeSetSmallestVertexWeight\", or \"Hybrid\"."
GraphUtilities`GraphCoordinateRules1D::mlvran = GraphUtilities`GraphCoordinateRules::mlvran = GraphUtilities`GraphCoordinateRules3D::mlvran = GraphUtilities`GraphCoordinates::mlvran = GraphUtilities`GraphCoordinates3D::mlvran = GraphUtilities`GraphCoordinates1D::mlvran = LayeredGraphPlot::mlvran = GraphPlot::mlvran = SparseArray`GraphPlacement::mlvran = GraphPlot3D::mlvran = SparseArray`GraphPlacement3D::mlvran = "The value of option Randomize -> `1` should be Automatic, True, or False."
GraphUtilities`GraphCoordinateRules1D::mlvmsz = GraphUtilities`GraphCoordinateRules::mlvmsz = GraphUtilities`GraphCoordinateRules3D::mlvmsz = GraphUtilities`GraphCoordinates::mlvmsz = GraphUtilities`GraphCoordinates3D::mlvmsz = GraphUtilities`GraphCoordinates1D::mlvmsz = LayeredGraphPlot::mlvmsz = GraphPlot::mlvmsz = SparseArray`GraphPlacement::mlvmsz = GraphPlot3D::mlvmsz = SparseArray`GraphPlacement3D::mlvmsz = "The value of option MinSize -> `1` should be Automatic or a positive machine integer."
GraphUtilities`GraphCoordinateRules1D::step = GraphUtilities`GraphCoordinateRules::step = GraphUtilities`GraphCoordinateRules3D::step = GraphUtilities`GraphCoordinates::step = GraphUtilities`GraphCoordinates3D::step = GraphUtilities`GraphCoordinates1D::step = LayeredGraphPlot::step = GraphPlot::step = SparseArray`GraphPlacement::step = GraphPlot3D::step = SparseArray`GraphPlacement3D::step = "The value of option StepLength -> `1` should be Automatic or a positive machine real."
GraphUtilities`GraphCoordinateRules1D::miter = GraphUtilities`GraphCoordinateRules::miter = GraphUtilities`GraphCoordinateRules3D::miter = GraphUtilities`GraphCoordinates::miter = GraphUtilities`GraphCoordinates3D::miter = GraphUtilities`GraphCoordinates1D::miter = LayeredGraphPlot::miter = GraphPlot::miter = SparseArray`GraphPlacement::miter = GraphPlot3D::miter = SparseArray`GraphPlacement3D::miter = "The value of option MaxIterations -> `1` should be Automatic or a positive machine integer."
GraphUtilities`GraphCoordinateRules1D::stepc = GraphUtilities`GraphCoordinateRules::stepc = GraphUtilities`GraphCoordinateRules3D::stepc = GraphUtilities`GraphCoordinates::stepc = GraphUtilities`GraphCoordinates3D::stepc = GraphUtilities`GraphCoordinates1D::stepc = LayeredGraphPlot::stepc = GraphPlot::stepc = SparseArray`GraphPlacement::stepc = GraphPlot3D::stepc = SparseArray`GraphPlacement3D::stepc = "The value of option StepControl -> `1` should be Automatic, \"NonMonotonic\", \"Monotonic\", or \"StrictlyMonotonic\"."
GraphUtilities`GraphCoordinateRules1D::engctl = GraphUtilities`GraphCoordinateRules::engctl = GraphUtilities`GraphCoordinateRules3D::engctl = GraphUtilities`GraphCoordinates::engctl = GraphUtilities`GraphCoordinates3D::engctl = GraphUtilities`GraphCoordinates1D::engctl = LayeredGraphPlot::engctl = GraphPlot::engctl = SparseArray`GraphPlacement::engctl = GraphPlot3D::engctl = SparseArray`GraphPlacement3D::engctl = "The value of option EnergyControl -> `1` should be Automatic, \"NonMonotonic\", or \"Monotonic\"."
GraphUtilities`GraphCoordinateRules1D::infd = GraphUtilities`GraphCoordinateRules::infd = GraphUtilities`GraphCoordinateRules3D::infd = GraphUtilities`GraphCoordinates::infd = GraphUtilities`GraphCoordinates3D::infd = GraphUtilities`GraphCoordinates1D::infd = LayeredGraphPlot::infd = GraphPlot::infd = SparseArray`GraphPlacement::infd = GraphPlot3D::infd = SparseArray`GraphPlacement3D::infd = "The value of option InferentialDistance -> `1` should be Automatic or a positive machine number."
GraphUtilities`GraphCoordinateRules1D::octr = GraphUtilities`GraphCoordinateRules::octr = GraphUtilities`GraphCoordinateRules3D::octr = GraphUtilities`GraphCoordinates::octr = GraphUtilities`GraphCoordinates3D::octr = GraphUtilities`GraphCoordinates1D::octr = LayeredGraphPlot::octr = GraphPlot::octr = SparseArray`GraphPlacement::octr = GraphPlot3D::octr = SparseArray`GraphPlacement3D::octr = "The value of option Octree -> `1` should be Automatic, True, or False."
GraphUtilities`GraphCoordinateRules1D::rfp = GraphUtilities`GraphCoordinateRules::rfp = GraphUtilities`GraphCoordinateRules3D::rfp = GraphUtilities`GraphCoordinates::rfp = GraphUtilities`GraphCoordinates3D::rfp = GraphUtilities`GraphCoordinates1D::rfp = LayeredGraphPlot::rfp = GraphPlot::rfp = SparseArray`GraphPlacement::rfp = GraphPlot3D::rfp = SparseArray`GraphPlacement3D::rfp = "The value of option RepulsiveForcePower -> `1` should be a negative machine number."
GraphUtilities`GraphCoordinateRules1D::refm = GraphUtilities`GraphCoordinateRules::refm = GraphUtilities`GraphCoordinateRules3D::refm = GraphUtilities`GraphCoordinates::refm = GraphUtilities`GraphCoordinates3D::refm = GraphUtilities`GraphCoordinates1D::refm = LayeredGraphPlot::refm = GraphPlot::refm = SparseArray`GraphPlacement::refm = GraphPlot3D::refm = SparseArray`GraphPlacement3D::refm = "The value of option RefinementMethod -> `1` should be None, \"SpringElectricalEmbedding\", or \"SpringEmbedding\"."
GraphUtilities`GraphCoordinateRules1D::mthd = GraphUtilities`GraphCoordinateRules::mthd = GraphUtilities`GraphCoordinateRules3D::mthd = GraphUtilities`GraphCoordinates::mthd = GraphUtilities`GraphCoordinates3D::mthd = GraphUtilities`GraphCoordinates1D::mthd = LayeredGraphPlot::mthd = GraphPlot::mthd = SparseArray`GraphPlacement::mthd = GraphPlot3D::mthd = SparseArray`GraphPlacement3D::mthd = "The value of option Method -> `1` should be Automatic, \"SpringElectricalEmbedding\", \"SpringEmbedding\", \"LayeredDrawing\", \"LayeredDigraphDrawing\", \"RadialDrawing\", \"HighDimensionalEmbedding\", \"CircularEmbedding\", \"SpiralEmbedding\", \"LinearEmbedding\", or \"RandomEmbedding\"."
GraphUtilities`GraphCoordinateRules1D::eig = GraphUtilities`GraphCoordinateRules::eig = GraphUtilities`GraphCoordinateRules3D::eig = GraphUtilities`GraphCoordinates::eig = GraphUtilities`GraphCoordinates3D::eig = GraphUtilities`GraphCoordinates1D::eig = LayeredGraphPlot::eig = GraphPlot::eig = SparseArray`GraphPlacement::eig = GraphPlot3D::eig = SparseArray`GraphPlacement3D::eig = "HighDimensionalEmbedding method failed because eigenvectors of the covariant matrix cannot be calculated."
GraphUtilities`GraphCoordinateRules1D::rseed = GraphUtilities`GraphCoordinateRules::rseed = GraphUtilities`GraphCoordinateRules3D::rseed = GraphUtilities`GraphCoordinates::rseed = GraphUtilities`GraphCoordinates3D::rseed = GraphUtilities`GraphCoordinates1D::rseed = LayeredGraphPlot::rseed = GraphPlot::rseed = GraphPlot3D::rseed = Experimental`FindClusters::rseed = NMinimize::rseed = NMaximize::rseed = FindInstance::rseed = "Value of option RandomSeed -> `1` is not an integer or Automatic."
GraphUtilities`GraphCoordinateRules1D::rooti = GraphUtilities`GraphCoordinateRules::rooti = GraphUtilities`GraphCoordinateRules3D::rooti = GraphUtilities`GraphCoordinates::rooti = GraphUtilities`GraphCoordinates3D::rooti = GraphUtilities`GraphCoordinates1D::rooti = TreePlot::rooti = LayeredGraphPlot::rooti = GraphPlot::rooti = GraphPlot3D::rooti = "Value of method option Root -> `1` is not a vertex."
GraphUtilities`GraphCoordinateRules1D::loop = GraphUtilities`GraphCoordinateRules::loop = GraphUtilities`GraphCoordinateRules3D::loop = GraphUtilities`GraphCoordinates::loop = GraphUtilities`GraphCoordinates3D::loop = GraphUtilities`GraphCoordinates1D::loop = LayeredGraphPlot::loop = GraphPlot::loop = GraphPlot3D::loop = SparseArray`GraphPlacement::loop = SparseArray`GraphPlacement3D::loop = "Value of option Loops -> `1` is not True, False, Automatic, or a positive machine number."
GraphUtilities`GraphCoordinateRules1D::medge = GraphUtilities`GraphCoordinateRules::medge = GraphUtilities`GraphCoordinateRules3D::medge = GraphUtilities`GraphCoordinates::medge = GraphUtilities`GraphCoordinates3D::medge = GraphUtilities`GraphCoordinates1D::medge = LayeredGraphPlot::medge = GraphPlot::medge = GraphPlot3D::medge = SparseArray`GraphPlacement::medge = SparseArray`GraphPlacement3D::medge = "Value of option Multiedges -> `1` is not True, False, Automatic, or a positive machine number."
GraphUtilities`GraphCoordinateRules1D::rot = GraphUtilities`GraphCoordinateRules::rot = GraphUtilities`GraphCoordinateRules3D::rot = GraphUtilities`GraphCoordinates::rot = GraphUtilities`GraphCoordinates3D::rot = GraphUtilities`GraphCoordinates1D::rot = LayeredGraphPlot::rot = GraphPlot::rot = GraphPlot3D::rot = SparseArray`GraphPlacement::rot = SparseArray`GraphPlacement3D::rot = "Value of option Rotation -> `1` is not a machine-size real number."
GraphUtilities`GraphCoordinateRules1D::vtxsz = GraphUtilities`GraphCoordinateRules::vtxsz = GraphUtilities`GraphCoordinateRules3D::vtxsz = GraphUtilities`GraphCoordinates::vtxsz = GraphUtilities`GraphCoordinates3D::vtxsz = GraphUtilities`GraphCoordinates1D::vtxsz = LayeredGraphPlot::vtxsz = GraphPlot::vtxsz = GraphPlot3D::vtxsz = SparseArray`GraphPlacement::vtxsz = SparseArray`GraphPlacement3D::vtxsz = "Value of option VertexSizes -> `1` is not a list of positive machine numbers, or positive machine-number pairs, of the same length as the number of vertices."
GraphUtilities`GraphCoordinateRules1D::vpr = GraphUtilities`GraphCoordinateRules::vpr = GraphUtilities`GraphCoordinateRules3D::vpr = GraphUtilities`GraphCoordinates::vpr = GraphUtilities`GraphCoordinates3D::vpr = GraphUtilities`GraphCoordinates1D::vpr = LayeredGraphPlot::vpr = GraphPlot::vpr = GraphPlot3D::vpr = SparseArray`GraphPlacement::vpr = SparseArray`GraphPlacement3D::vpr = "Value of option VertexCoordinateRules -> `1` is not a valid list of coordinate rules."
TreePlot::vprmtd = GraphUtilities`GraphCoordinateRules1D::vprmtd = GraphUtilities`GraphCoordinateRules::vprmtd = GraphUtilities`GraphCoordinateRules3D::vprmtd = GraphUtilities`GraphCoordinates::vprmtd = GraphUtilities`GraphCoordinates3D::vprmtd = GraphUtilities`GraphCoordinates1D::vprmtd = LayeredGraphPlot::vprmtd = GraphPlot::vprmtd = GraphPlot3D::vprmtd = SparseArray`GraphPlacement::vprmtd = SparseArray`GraphPlacement3D::vprmtd = "Warning: The VertexCoordinateRules option with rule list value is only supported for SpringElectricalEmbedding method. Switching to the SpringElectricalEmbedding method."
GraphPlot::pkst = GraphPlot3D::pkst = TreePlot::pkst = LayeredGraphPlot::pkst = "Value of option PackingMethod -> `1` must be Automatic, \"ClosestPacking\", \"ClosestPackingCenter\", \"Layered\", \"LayeredLeft\", \"LayeredTop\", or \"NestedGrid\"."
GraphPlot::pnum = GraphPlot3D::pnum = TreePlot::pnum = LayeredGraphPlot::pnum = "Value of option PolominoNumber -> `1` must be Automatic or a positive machine integer."
GraphPlot::ppad = GraphPlot3D::ppad = TreePlot::ppad = LayeredGraphPlot::ppad = "Value of option Padding -> `1` must be Automatic, None, or a non-negative machine real."
TreePlot::iind = "Argument `1` at position `3` is not a vertex index between 1 and `2`."
TreePlot::rind = "Argument `1` at position `2` is not a valid vertex."
TreePlot::rp = "The second argument `1` of TreePlot must be one of \"Top\", \"Bottom\", \"Left\", \"Right\", or \"Center\"."
LayeredGraphPlot::rp2 = "The second argument `1` of LayeredGraphPlot must be \"Top\", \"Bottom\", \"Left\", or \"Right\"."
GraphPlot::vlbs = GraphPlot3D::vlbs = TreePlot::vlbs = LayeredGraphPlot::vlbs = "Value of option VertexLabeling -> `1` must be Automatic, True, False, or Tooltip."
GraphPlot::elbs = GraphPlot3D::elbs = TreePlot::elbs = LayeredGraphPlot::elbs = "Value of option EdgeLabeling -> `1` must be either Automatic, True, or False."
GraphPlot::des = GraphPlot3D::des = TreePlot::des = LayeredGraphPlot::des = "Value of option DirectedEdges -> `1` must be either True or False."
FaceGrids::fglst = "Value for option FaceGrids -> `1` is not None, All, or a list with 6 or fewer elements."
FaceGrids::fgstl = "`1` is not a valid grid style specification."
FaceGrids::gface = "`1` is not a valid face specification."
Factor::facim = FactorSquareFree::facim = "Factoring non-integer polynomials with respect to a modulus is not implemented."
Factor::facmm = "Factoring multivariate polynomials with respect to a modulus is not yet implemented; using FactorSquareFree instead."
Factor::priml = "Prime `1` is too large for this implementation."
Factor::ufac = FactorSquareFree::ufac = "Unable to perform the square-free factorization."
Factor::extnp = FactorSquareFree::extnp = FactorList::extnp = FactorSquareFreeList::extnp = "`1` over an algebraic extension requires polynomial input; using `1` with Extension -> None instead."
FactorInteger::faccp = "Unable to factor `1` completely."
FactorInteger::facnf = "Unable to factor `1`."
FactorInteger::gfacnf = "Unable to factor `1` + `2` I."
FileFormat::chtype = "`1` is not a valid file specification."
FinancialData::conopen = "No internet connection can be established to the data source.";
FinancialData::notent = "`1` is not a known entity in FinancialData.";
FinancialData::notprop = "`1` is not a known property for FinancialData. Use FinancialData[\"Properties\"] for a list of properties.";
FinancialData::notdate = "`1` is not a valid date range for FinancialData.";
FindMinimum::bdmtd = FindMaximum::bdmtd = "The value of Method -> `1` is not Automatic, \"Gradient\", \"ConjugateGradient\", \"InteriorPoint\", \"QuasiNewton\", \"Newton\", or \"LevenbergMarquardt\"."
FindFit::bdmtd = "Value of option Method -> `1` is not Automatic, \"Gradient\", \"ConjugateGradient\", \"InteriorPoint\", \"QuasiNewton\", \"Newton\", \"NMinimize\", or \"LevenbergMarquardt\"."
FindMinimum::ucmtd = FindMaximum::ucmtd = FindFit::ucmtd = "Method -> `1` can only be used for unconstrained problems."
FindMinimum::cvecv = FindMaximum::cvecv = FindFit::cvecv = "Constrained optimization is only supported with scalar valued variables."
FindMinimum::fddis = FindMaximum::fddis = FindFit::fddis = FindRoot::fddis = "The starting values `1` and `2` are not sufficiently distinct to begin a search."
FindMinimum::fdin = FindMaximum::fdin = FindFit::fdin = FindRoot::fdin = "Form of start specification `1` in `2` is inconsistent with other start specifications."
FindMinimum::lss = FindMaximum::lss = FindRoot::lss = "`1` should be a nonempty list of search specifications, each consisting of a variable and starting values."
FindFit::lss = "`1` should be a nonempty list of search specifications, each consisting of a variable and possibly starting values."
FindMinimum::fdss = FindMaximum::fdss = FindRoot::fdss = "Search specification `1` should be a list with 1 to 5 elements."
FindFit::fdss = "Search specification `1` should be a list with 1-5 elements."
FindMinimum::srect = FindMaximum::srect = FindFit::srect = FindRoot::srect = "Value `1` in search specification `2` is not a number or array of numbers."
FindMinimum::scdims = FindMaximum::scdims = FindFit::scdims = FindRoot::scdims = "Values given in search specification `1` do not have consistent dimensions."
FindMinimum::snum = FindMaximum::snum = FindFit::snum = FindRoot::snum = "Value `1` in search specification `2` is not a number."
FindMinimum::fdssnv = FindMaximum::fdssnv = FindRoot::fdssnv = FindFit::fdssnv = "Search specification `1` without variables should be a list with 1-4 elements."
FindMinimum::fdvc = FindMaximum::fdvc = FindFit::fdvc = FindRoot::fdvc = "Variable number `1` has value `2` that cannot be compared with the bounds `3`."
FindMinimum::bbound = FindMaximum::bbound = FindFit::bbound = FindRoot::bbound = "Search region bound `1` for variable number `2` is not a number or Infinity."
FindMinimum::linf = FindMaximum::linf = FindFit::linf = FindRoot::linf = "Lower bound for search region for variable number `1` is Infinity, leaving no values in the region."
FindMinimum::uinf = FindMaximum::uinf = FindFit::uinf = FindRoot::uinf = "Upper bound for search region for variable number `1` is -Infinity, leaving no values in the region."
FindMinimum::eqineq = FindMaximum::eqineq = FindFit::eqineq = "Constraints in `1` are not all equality or inequality constraints. With the exception of integer domain constraints for linear programming, domain constraints or constraints with Unequal (!=) are not supported."
FindMinimum::cvmit = FindMaximum::cvmit = FindFit::cvmit = FindRoot::cvmit = NMinimize::cvmit = NMaximize::cvmit = "Failed to converge to the requested accuracy or precision within `1` iterations."
FindMinimum::quadnm = FindMaximum::quadnm = "The algorithm specified by option Method -> QuadraticProgramming can only be used to solve machine-precision problems."
NMinimize::eit = NMaximize::eit = Optimization`NonlinearInteriorPoint::eit = FindMinimum::eit = FindMaximum::eit = FindFit::eit = FindRoot::eit = NMinimize::eit = NMaximize::eit = "The algorithm does not converge to the tolerance of `1` in `2` iterations. The best estimated solution, with feasibility residual, KKT residual or complementary residual of `3`, is returned."
FindMinimum::fmdig = FindMaximum::fmdig = FindFit::fmdig = "`1` working digits is insufficient to achieve the requested accuracy or precision."
FindMinimum::nzres = FindMaximum::nzres = FindFit::nzres = "The step size for Method -> LevenbergMarquardt has become nearly zero at working precision `1`.  The residual appears to be nonzero, which can lead to poor convergence of the method.  It is recommended that you try Method -> Newton or Method -> QuasiNewton for better convergence."
FindMinimum::sctl = FindMaximum::sctl = FindFit::sctl = FindRoot::sctl = "The value of the option StepControl -> `1` is not one of Automatic, LineSearch, TrustRegion, or None."
FindMinimum::scone = FindMaximum::scone = FindFit::scone = FindRoot::scone = "The method you have chosen is only compatible with StepControl -> `1`."
FindFit::sdprec = FindMinimum::sdprec = "Line search unable to find a sufficient decrease in the function value with `1` digit precision."
FindMaximum::sdprec = "Line search unable to find a sufficient increase in the function value with `1` digit precision."
FindRoot::sdprec = "The line search was unable to find a sufficient decrease in the merit function value with `1` digit precision."
FindMinimum::lstol = "The line search decreased the step size to within tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find a sufficient decrease in the function.  You may need more than `1` digits of working precision to meet these tolerances."
LinearProgramming::lpdom = "Warning: `1` is not a valid domain specification and is ignored. Domain specification must be Reals, Integers, or of the form {dom1, dom2,...}, where dom1, doma2, etc. are either Reals or Integers."
LinearProgramming::lpdom2 = "Warning: `1` in `2` is not a valid domain specification and is ignored. Domain specification must be either Reals or Integers."
FindMinimum::nonlin = FindMaximum::nonlin = "Value of option Method -> LinearProgramming is inconsistent with nonlinear constraints or object function in `1`."
FindMaximum::lstol = "The line search decreased the step size to within tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find a sufficient increase in the function.  You may need more than `1` digits of working precision to meet these tolerances."
FindFit::lstol = "The line search decreased the step size to within tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find a sufficient decrease in the norm of the residual.  You may need more than `1` digits of working precision to meet these tolerances."
FindRoot::lstol = "The line search decreased the step size to within tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find a sufficient decrease in the merit function.  You may need more than `1` digits of working precision to meet these tolerances."
FindFit::lsbrak = FindMinimum::lsbrak = "Unable to bracket a minimum along the direction `2` from the point `1`."
FindMaximum::lsbrak = "Unable to bracket a maximum along the direction `2` from the point `1`."
FindRoot::btf = FindMinimum::btf = FindMaximum::btf = FindFit::btf = "The value of the option BacktrackingFactors -> `1` should be a list {amin, amax} with 0 < amin <= amax < 1."
FindRoot::bddir = "The search direction `1` is not a descent direction for the merit function. The step will be taken without the line search."
FindMinimum::bddir = FindFit::bddir = "The search direction `1` is not a descent direction for the function.  Typically this occurs when the function is not smooth or the values of the function are much less accurate than the WorkingPrecision."
FindMaximum::bddir = "The search direction `1` is not an ascent direction for the function.  Typically this occurs when the function is not smooth or the values of the function are much less accurate than the WorkingPrecision."
FindMinimum::fmgl = FindMaximum::fmgl = FindFit::fmgl = "Gradient `1` is not a length `2` list of real numbers at `3` = `4`."
FindMinimum::fmgs = FindMaximum::fmgs = FindFit::fmgs = "Could not symbolically find the gradient of `1`. Try using the default method, giving two starting values for each variable."
FindMinimum::prax2 = FindMaximum::prax2 = FindFit::prax2 = "Method -> PrincipalAxis requires two starting values in each variable." 
FindMinimum::fmhs = FindMaximum::fmhs = FindFit::fmhs = "Could not symbolically find the Hessian by differentiating the gradient `1`. Try using Method -> QuasiNewton instead."
FindMinimum::fmgz = FindFit::fmgz = "Encountered a gradient that is effectively zero. The result returned may not be a minimum; it may be a maximum or a saddle point."
FindMaximum::fmgz = "Encountered a gradient that is effectively zero. The result returned may not be a maximum; it may be a minimum or a saddle point."
FindMinimum::fmmp = FindMaximum::fmmp = FindFit::fmmp = "Machine precision is insufficient to achieve the requested accuracy or precision."
FindMinimum::fmns = FindMaximum::fmns = FindFit::fmns = "Starting value `1` contains numbers that are not real."
FindMinimum::fmwar = FindMaximum::fmwar = FindFit::fmwar = "Only the first starting value in each dimension, `1` is used unless Method -> PrincipalAxis or Automatic."
FindMinimum::fmwarc = FindMaximum::fmwarc = FindFit::fmwarc = "Only the first starting value in each dimension, `1` is used for constrained problems."
FindFit::notlm = FindMinimum::notlm = "The objective function for the method LevenbergMarquardt must be in a least-squares form: Sum[f[i][x]^2,{i,1,n}] or Sum[w[i] f[i][x]^2,{i,1,n}] with positive w[i]."
FindMaximum::notlm = "The objective function for the method LevenbergMarquardt must be in a least-squares form: Sum[-f[i][x]^2,{i,1,n}] or Sum[w[i] f[i][x]^2,{i,1,n}] with negative w[i]."
FindMinimum::regex1 = FindMaximum::regex1 = FindFit::regex1 = FindRoot::regex1 = "Reached the point `1` that has component `2` equal to `3`, which is outside the range `4`."
FindMinimum::regex = FindMaximum::regex = FindFit::regex = FindRoot::regex = "Reached the point `1`, which is outside the region `2`."
FindMinimum::reged = FindMaximum::reged = FindFit::reged = FindRoot::reged = "The point `1` is at the edge of the search region `3` in coordinate `2` and the computed search direction points outside the region."
FindMinimum::streg = FindMaximum::streg = FindFit::streg = FindRoot::streg = "The starting point `1` is not in the search region `2`."
FindFit::sszero = FindMinimum::sszero = "The step size in the search has become less than the tolerance prescribed by the PrecisionGoal option, but the gradient is larger than the tolerance specified by the AccuracyGoal option. There is a possibility that the method has stalled at a point that is not a local minimum."
FindMaximum::sszero = "The step size in the search has become less than the tolerance prescribed by the PrecisionGoal option, but the gradient is larger than the tolerance specified by the AccuracyGoal option. There is a possibility that the method has stalled at a point that is not a local maximum."
FindRoot::sszero = "The step size in the search has become less than the tolerance prescribed by the PrecisionGoal option, but the function value is still greater than the tolerance prescribed by the AccuracyGoal option."
FindMinimum::stfail = FindMaximum::stfail = FindFit::stfail = FindRoot::stfail = "The method `1` failed to compute the next step."
FindMinimum::umtd = FindMaximum::umtd = FindFit::umtd = "The method `1` has returned `2` instead of a step for FindMinimum to use or a list {step, state}."
FindMinimum::lsm = FindMaximum::lsm = FindFit::lsm = FindRoot::lsm = "The method `1` is not a line search method."
FindMinimum::trm = FindMaximum::trm = FindFit::trm = FindRoot::trm = "The method `1` is not a trust region method."
FindMinimum::trmss = FindMaximum::trmss = FindFit::trmss = FindRoot::trmss = "The maximum trust region scaled step size `1` is not a positive real number."
FindMinimum::trsss = FindMaximum::trsss = FindFit::trsss = FindRoot::trsss = "The starting trust region scaled step size `1` is not a positive real number."
FindMinimum::trasr = FindMaximum::trasr = FindFit::trasr = FindRoot::trasr = "The value of the option AcceptableStepRatio -> `1` should be a real number between 0 and 1/2."
FindRoot::umtd = "The method `1` has returned `2` instead of a step for FindRoot to use or a list {step, state}."
FindRoot::bdmtd = "Value of option Method -> `1` is not Automatic, Brent, Secant, or Newton."
FindRoot::eqlist = "In the first argument `1` only some of the components are equations."
FindRoot::fdst = FindMinimum::fdst = FindMaximum::fdst = FindFit::fdst = "Expression `1` in `2` is not a valid start specification; a number or pair of numbers is expected."
FindRoot::frdig = "`1` working digits is insufficient to achieve the absolute tolerance `2`."
FindRoot::sec2 = "Method -> Secant requires two starting values for each dimension."
FindRoot::bbrac = "Method -> Brent is only applicable to univariate real functions and requires two real starting values that bracket the root."
FindRoot::frn2 = "With Method -> Newton only the first starting value in each dimension will be used."
FindRoot::frmp = "Machine precision is insufficient to achieve the accuracy `1`."
FindRoot::brmp = "The root has been bracketed as closely as possible with machine precision but the function value exceeds the absolute tolerance `1`."
FindRoot::brdig = "The root has been bracketed as closely as possible with `1` working digits but the function value exceeds the absolute tolerance `2`."
FindRoot::frns = "Starting value `1` in `2` is not a number."
FindRoot::jsing = "Encountered a singular Jacobian at the point `1` = `2`. Try perturbing the initial point(s)."
FindRoot::jsing1 = "Encountered a singular Jacobian at the point `1`. Try perturbing the initial point(s)."
FindRoot::mmin = "The search appears to be stopped near a local minimum of the merit function that is not an actual root.  Try using a different starting point."
FindRoot::zdamp = "The factors given in DampingFactor -> `1` must all be strictly positive."
FindRoot::nveq = "The number of equations does not match the number of variables in `1`."
FindRoot::trcx = "The search has encountered a complex value and the trust region step control method is only implemented for real values."
FindRoot::precinc = "Increase of precision to `2` failed for method `1`."
FindFit::nlnrm = "The model `1` is linear in the parameters `2`, but because the norm specified with NormFunction -> `3` is non-Euclidean, the linear least-squares method specified with Method -> `4` cannot be used."
FindFit::lmnl = "The model `1` is linear in the parameters `2`, but a nonlinear method or non-Euclidean norm was specified, so nonlinear methods will be used."
FindFit::nlmod = "The model `1` is not linear in the parameters `2` so the linear least-squares method specified with Method -> `3` cannot be used."
FindFit::conv = FindMaximum::conv = FindMinimum::conv = NMaximize::conv = NMinimize::conv = Optimization`NonlinearInteriorPoint::conv = "Interior point method fails to converge."
FindFit::grad = FindMaximum::grad = FindMinimum::grad = NMaximize::grad = NMinimize::grad = Optimization`NonlinearInteriorPoint::grad = "Evaluation of the gradient of function `1` failed at `2`."
FindMaximum::nmthd = FindMinimum::nmthd = NMaximize::nmthd = NMinimize::nmthd = Optimization`NonlinearInteriorPoint::nmthd = "Warning: The value of option Method -> `1` is not valid; use Method -> Automatic instead."
FindShortestTour::ccap = "Method -> `1` can only be applied to a list of 2D points."
FindShortestTour::badin = "The input `1` is not a list of points in the Euclidean space."
FindShortestTour::illmet = "Value of option Method -> `1` is not Automatic, \"CCA\", \"TwoOpt\", \"SpaceFillingCurve\", \"OrOpt\", \"OrZweig\", \"AllTours\", \"Greedy\", \"GreedyCycle\", or \"SimulatedAnnealing\"."
FindShortestTour::reppt = "The input `1` does not contain distinct points."
FindShortestTour::dist = "The distance function `1` does not give a numerical result when applied to two points."
FindShortestTour::euc = "This method is meant for Euclidean distance only."
NMaximize::nreal = NMinimize::nreal = Optimization`NonlinearInteriorPoint::nreal = "Either the constraints, `2`, or the objective function, `1`, contain nonreal terms."
Optimization`NonlinearInteriorPoint::infea = "No solution can be found that satisfies the constraints."
Optimization`NonlinearInteriorPoint::ctype = "The list constraints `1` contain a constraint `2` that is not supported."
Optimization`NonlinearInteriorPoint::badspt = "Value of option StartingPoint -> `1` is not valid."
Optimization`NonlinearInteriorPoint::badit = "`1` is not a valid value for the MaxIterations option, which should be a positive integer."
Optimization`NonlinearInteriorPoint::uneq = "The constraints, `1`, contain unequal type constraints that are not supported."
Optimization`NonlinearInteriorPoint::elem = "The constraints, `1`, contain element type constraints that are not supported."
Optimization`NonlinearInteriorPoint::malf = "The constraints, `1`, are malformed. This may be, for example, because the constraints do not form equalities or inequalities."
First::first = "`1` has a length of zero and no first element."
Fit::fitc = FindFit::fitc = "Number of coordinates (`1`) is not equal to the number of variables (`2`)."
Fit::fitd = FindFit::fitd = "First argument `1` in Fit is not a list or a rectangular array."
Fit::fitm = FindFit::fitm = "Unable to solve for the fit parameters; the design matrix is nonrectangular, non-numerical, or could not be inverted."
Flatten::flev = "The level argument `1` in position `2` of `3` should be a non-negative integer or Infinity giving the levels to flatten through or a list of lists of levels to flatten together."
Flatten::fldep = "Level `1` specified in `2` exceeds the levels, `3`, which can be flattened together in `4`."
Flatten::flrep = "Level `1` specified in `2` should not be repeated."
Flatten::flpi = "Levels to be flattened together in `1` should be lists of positive integers."
FlattenAt::flatp = "Expression `3` at position `1` of `2` has no parts and cannot be flattened."
FontForm::ffsp = "`1` is not a valid font specification of the form {\"font\", size}."
Format::forml = ToBoxForm::forml = "Recursion depth limit $RecursionLimit exceeded while formatting output."
Format::fttp = "Format type `1` is not a symbol."
Format::lcont = "Line continuation print object too wide."
Format::toobig = "Expression too big for output."
FormatType::ftype = "Value of option FormatType -> `1` is not valid."
Fourier::fpopt = InverseFourier::fpopt = "The value of the option FourierParameters -> `1` should be a length 2 list"
Fourier::fpoptn = InverseFourier::fpoptn = "Both values of FourierParameters -> `1` need to be numeric."
InverseFourier::fpopt2 = "Warning: the discrete Fourier transform may not be invertible unless the second element of the option FourierParameters -> `1` is an integer having no factors in common with the length of the input."
Fourier::fftl = InverseFourier::fftl = FourierDCT::fftl = FourierDST::fftl = "Argument `1` is not a nonempty list or rectangular array of numeric quantities."
FourierDCT::fttype = "The discrete cosine transform type `1` should be 1, 2, 3, or 4."
FourierDST::fttype = "The discrete sine transform type `1` should be 1, 2, 3, or 4."
FrameLabel::fmlab = "Value of option FrameLabel -> `1` should be None, a label, or a list with 2 or 4 labels."
FrobeniusNumber::coef = FrobeniusSolve::coef = "The first argument `1` of `2` should be a list of at least two positive integers."
FrobeniusSolve::brhs = "The second argument `1` of FrobeniusSolve should be an integer."
FrobeniusSolve::nsol = "The number `1` of requested solutions should be a positive integer."
FromCharacterCode::notunicode = "A character code, which should be a non-negative integer less than 65536, is expected at position `2` in `1`."
FromContinuedFraction::root = "Unable to determine the appropriate root for the periodic continued fraction."
FromDate::fdls = "`1` is neither a list of 6 machine-size integers nor a list of 5 machine-size integers followed by a real number."
FromDigits::nlst = "The expression `1` is not a list of digits or a string of valid digits."
FromDigits::fdb = "The digit `1` is too large for base `2`."
FromDigits::nrom = "The expression `1` is not a proper string of Roman digits."
FrontEndObject::invfe = "`1` is not a valid front end object."
FrontEndObject::notavail = "A front end is not available; certain operations require a front end."
Function::attf = "Attributes `1` in `2` cannot be used as function attributes."
Function::fdup = Compile::fdup = "Duplicate parameter `1` found in `2`."
Function::fdups = "Conflicting parameters `1` and `3` found in `2`."
Function::flpar = "Parameter specification `1` in `2` should be a symbol or a list of symbols."
Function::fpct = "Too many parameters in `1` to be filled from `2`."
Function::slot = "`1` (in `2`) should contain a non-negative integer."
Function::slotn = "Slot number `1` in `2` cannot be filled from `3`."
Function::slotp = "`1` (in `2`) should contain a positive integer."
Function::slots = "SlotSequence[`1`] in `2` cannot be filled from `3`."
FunctionInterpolation::accg = "Value of option AccuracyGoal -> `1` is not Automatic, Infinity, or a machine-size integer."
FunctionInterpolation::argdim = "The dimension of the argument to an InterpolatingFunction function object in the input does not match the dimension of the InterpolatingFunction."
FunctionInterpolation::ncvb = "FunctionInterpolation failed to meet the prescribed accuracy and precision goals after `1` recursive bisections near `2` = `3`. Continuing to refine elsewhere."
FunctionInterpolation::npts = "Value of option InterpolationPoints -> `1` is not a machine-size integer >= 2."
FunctionInterpolation::nreal = "Near `1` = `2`, the function did not evaluate to a real number."
FunctionInterpolation::precg = "Value of option PrecisionGoal -> `1` is not Automatic, Infinity, or a positive machine-size real or integer."
FunctionInterpolation::range = "Argument `1` is not in the form of a range specification, {x, xmin, xmax}."
Gamma::gamc = "Gamma[`1`, `2`] is too ill-conditioned to compute."
General::altel = "Use `1` to specify assumptions for multiple variables."
General::altno = "Use multiple sets instead of Alternatives in `1`."
General::aofil = "`1` already open as `2`."
General::argb = "`1` called with `2` arguments; between `3` and `4` arguments are expected."
General::argbu = "`1` called with 1 argument; between `2` and `3` arguments are expected."
General::argct = "`1` called with `2` arguments."
General::argctu = "`1` called with 1 argument."
General::argf = "`1` called with `2` arguments; `3` or fewer arguments are expected."
General::argm = "`1` called with `2` arguments; `3` or more arguments are expected."
General::argmu = "`1` called with 1 argument; `2` or more arguments are expected."
General::argr = "`1` called with 1 argument; `2` arguments are expected."
General::argrx = "`1` called with `2` arguments; `3` arguments are expected."
General::argt = "`1` called with `2` arguments; `3` or `4` arguments are expected."
General::argtu = "`1` called with 1 argument; `2` or `3` arguments are expected."
General::argx = "`1` called with `2` arguments; 1 argument is expected."
General::base = "Requested base `1` in `2` should be between 2 and `3`."
General::bass = "`1` is not a well-formed assumption."
General::bebal = "Unterminated uses of BeginPackage or Begin in `1`."
General::bktfn = "\"`1`\" should probably be \"`2`\".`4`"
General::bktmch = "\"`1`\" must be followed by \"`2`\", not \"`3`\".`4`"
General::bktmcp = "Expression \"`1`\" has no closing \"`2`\".`4`"
General::bktmop = "Expression \"`1`\" has no opening \"`2`\".`4`"
General::bktwrn = "\"`1`\" represents multiplication; use \"`2`\" to represent a function.`4`"
General::bktx = "\"`1`\" has extra \"`2`\" after it.`4`"
General::bmod = "Modulus `1` must be an integer or an irreducible univariate polynomial."
General::bool = "True or False expected at position `2` in `1`."
General::boxfmt = "`1` in `2` is not a box formatting type. A box formatting type is any member of $BoxForms."
General::byteord = "Value of option ByteOrdering -> `1` should be 1 or -1."
General::cadpr = "The cylindrical algebraic decomposition algorithm used by `1` failed due to a too low WorkingPrecision. Increasing the value of WorkingPrecision may allow the algorithm to succeed." 
General::cas = "Warning: Contradictory assumption(s) `1` encountered."
General::cdir = "Cannot set current directory to `1`."
General::cfail = "Algorithm failed to converge."
General::color = "`1` is not a valid color or gray-level specification."
General::copt = "The option Compiled -> `1` should be True, False, or a list starting with True or False, followed by options."
General::conopt = "`1` is not a string option or a list of string options."
General::continfo = "\!\(`1`f\[DifferentialD]x\) is interpreted as \!\(`2`[f, x]\)."
General::cxls = "Context or nonempty list of contexts expected at position `1` in `2`."
General::cxt = "Invalid context specified at position `3` in `2`. A context must consist of valid symbol names separated by and ending with `4`."
General::dblk = "Value for option DigitBlock should be a positive integer, Infinity, or a pair of positive integers."
General::digit = "Digit at position `1` in `2` is too large to be used in base `3`."
General::dim = "Dimension `1` is not a positive integer giving a dimension to select for data associated with `2` dimensions."
General::dims = "Dimension specification `1` should be a positive machine integer or a pair of positive machine integers."
General::dimsl = "`1` given in `2` should be a list of dimensions for a particular argument."
General::dirdep = "Cannot get deeper in directory tree: `1`."
General::divz = "The argument `1` in `2` should be nonzero."
General::deprec = "`1` is deprecated and will not be supported in future versions of Mathematica.  Use `2` instead."
General::dstr = "Directory specification `1` is not a string."
General::dstrfe = "Directory specification `1` is not a string or a FrontEnd`.`FileName."
General::dupsym = "The symbol `1` with context `2` already exists."
General::eival = "Unable to find all roots of the characteristic polynomial."
General::eivec = "Unable to find eigenvector for eigenvalue `1`."
General::eivec0 = "Unable to find all eigenvectors."
General::eivn = "Incorrect number `1` of eigenvectors for eigenvalue `2` with multiplicity `3`."
General::enable = "`1` is not enabled in your version of Mathematica."
General::epoch = "`1` seconds is too far in the future.  Try a smaller amount of time."
General::estep = "Value of option `1` -> `2` is not a positive integer."
General::exact = "Argument `1` in `2` is not an exact number."
General::existinfo = "\!\(`1`\_x y\) is interpreted as `2`[x, y]."
General::fas = "Warning: One or more assumptions evaluated to False."
General::filro = "Attempt to modify a read-only file during `1`."
General::fmtval = "`1` is not a valid format type."
General::fnsym = "First argument in `1` is not a symbol or a string naming a symbol."
General::fstr = "File specification `1` is not a string of one or more characters."
General::globf = "Cannot open object obtained by expansion of `1`."
General::globm = "Too many matches for `1`: `2`."
General::globn = "No matches for `1`."
General::gprim = "`2` was encountered where a `1` primitive or directive was expected."
General::heads = "Heads `1` and `2` at positions `3` and `4` are expected to be the same."
General::heap = "Heap expected at position `2` in `1`."
General::hmdir = "\"~\" should be followed by \"/\": only the current user's home directory is supported."
General::idid = "`1` is not an integration direction specified by Forward or Backward."
General::ifexp = "The exponent `1` is not an integer."
General::ifpa = "The precision or accuracy `1` is not representable as a machine number."
General::ilsm = "List of machine-size integers expected at position `2` in `1`."
General::ilsmi = "Single or nonempty list of machine-size integers expected at position `2` in `1`."
General::ilsmn = "Single or list of non-negative machine-size integers expected at position `2` of `1`."
General::ilsmp = "Single or list of positive machine-size integers expected at position `2` of `1`."
General::incomma = "`1` is a structural element that is interpreted as an ordinary comma."
General::indet = "Indeterminate expression `1` encountered."
General::infy = "Infinite expression `1` encountered."
General::inf = "Input matrix contains an infinite entry."
General::initstate = "`1` cannot be used during initialization."
General::innf = "Non-negative integer or Infinity expected at position `2` in `1`."
General::interpfmt = "`1` is not a valid interpretation format. Valid interpretation formats include InputForm and any member of $BoxForms."
General::ipnf = "Positive integer or Infinity expected at position `2` in `1`."
General::ipnfm = "Positive machine-size integer or Infinity expected at position `2` in `1`."
General::int = "Integer expected at position `2` in `1`."
General::intg = "Integer greater than `3` expected at position `2` in `1`."
General::intinfo = "\!\(\[Integral]f\[DifferentialD]x\) or \!\(\[Integral]f\[CapitalDifferentialD]x\) is interpreted as Integrate[f, x]. \!\(\[Integral]\^b\%a f\[DifferentialD]x\) or \!\(\[Integral]\^b\%a f\[CapitalDifferentialD]x\) is interpreted as Integrate[f, {x,a,b}]."
General::intm = "Machine-size integer expected at position `2` in `1`."
General::intnm = "Non-negative machine-size integer expected at position `2` in `1`."
General::intnz = "Nonzero integer expected at position `2` in `1`."
General::intp = "Positive integer expected at position `2` in `1`."
General::intpm = "Positive machine-size integer expected at position `2` in `1`."
General::intpma = "Positive machine-size integer or Automatic expected at position `2` in `1`."
General::ioarg = "Argument in `1` is not valid for I/O operation."
General::ioerr = "Input/Output operation failed during `1`."
General::iopf = "Value of option `1` -> `2` should be an integer or Infinity."
General::iopa = "Value of option `1` -> `2` should be an integer or Automatic."
General::iopnf = "Value of option `1` -> `2` should be a non-negative integer or Infinity."
General::iopnm = "Value of option `1` -> `2` should be a non-negative machine-size integer."
General::ioppm = "Value of option `1` -> `2` should be a positive machine-size integer."
General::ioppf = "Value of option `1` -> `2` should be a positive integer or Infinity."
General::ioppfa = "Value of option `1` -> `2` should be a positive integer, Infinity, or Automatic."
General::isdir = "Cannot open directory for reading."
General::iterb = "Iterator `1` does not have appropriate bounds."
General::itflrw = "Warning: In evaluating `1` to find the number of iterations to use for `2`, $MaxExtraPrecision = `3` was encountered. An upper estimate will be used for the number of iterations."
General::itform = "Argument `1` at position `2` does not have the correct form for an iterator."
General::itraw = "Raw object `1` cannot be used as an iterator."
General::ittag = "Cannot use `1` as an iterator, since it contains no assignment tag."
General::ivar = "`1` is not a valid variable."
General::lconv = "QR algorithm failed to converge."
General::level = "Level specification `1` is not of the form n, {n}, or {m, n}."
General::list = "List expected at position `2` in `1`."
General::longp = "Pathname in `1` is too long."
General::lrgexp = "Exponent is out of bounds for function `1`."
General::lspec = "`1` is not a valid color, thickness, or dashing specification."
General::luc = "Result for `1` of badly conditioned matrix `2` may contain significant numerical errors."
General::markset = "Cannot set `1` to `2`; value must be True, False, or Automatic."
General::matrix = "Argument `1` at position `2` is not a nonempty rectangular matrix."
General::scalar = "Argument `1` at position `2` is not a scalar."
General::matsq = "Argument `1` at position `2` is not a nonempty square matrix."
General::vector = "Argument `1` at position `2` is not a nonempty vector."
General::vecmat = "Argument `1` at position `2` is neither a nonempty vector nor a nonempty matrix."
General::vecmat1 = "Argument `1` is neither a nonempty vector nor a nonempty matrix."
General::ndims = "The arguments `1` and `2` have incorrect dimensions."
General::mbox = "MatchBox cannot occur in transformation rule source."
General::mbrpos = "Position `2` in `1` must be one of `3`."
General::meprec = "Internal precision limit $MaxExtraPrecision = `1` reached while evaluating `2`."
General::mext = "Conflicting option setting. If Modulus is not 0, then Extension should be None."
General::mindet = "Input matrix contains an indeterminate entry."
General::nogr = "Unable to render `1` graphics."
General::numnm = "Non-negative machine-size number expected at position `2` in `1`."
General::modgp = "Value of option `1` -> `2` should be a Gaussian prime number."
General::modint = "Modulus `1` must be an integer."
General::modm = "Modulus `1` is too large for this implementation."
General::modn = "Value of option `1` -> `2` should be an integer."
General::modp = "Value of option `1` -> `2` should be a prime number or zero."
General::mult = "Value of option Multiplicity -> `1` is not a positive integer."
General::nalg = "`1` is not an explicit algebraic number."
General::naobj = "`1` is not a valid AlgebraicNumber object."
General::ncomp = "Unable to decide whether `1` and `2` are equal. Assuming they are."
General::ncompl = "Symbolic or noncomplex numerical arguments are expected."
General::newl = "The newline character after \"`1`\" is understood as a multiplication operator.`4`"
General::newsym = "Symbol `1` is new."
General::nfdir = "Directory not found during `1`."
General::nffil = "File not found during `1`."
General::niupf = "`1` is not an irreducible univariate polynomial function with rational coefficients."
General::nlist3 = "`1` is not a list of three numbers."
General::nmod = "`1` is not valid modulo `2`."
General::nofe = "A front end is not available. This action requires a front end."
General::nofestart = "Unable to launch a front end. Proceeding without a front end."
General::nonopt = "Options expected (instead of `1`) beyond position `2` in `3`. An option must be a rule or a list of rules."
General::noopen = "Cannot open `1`."
General::nord = "Invalid comparison with `1` attempted."
General::normal = "Nonatomic expression expected at position `1` in `2`."
General::nosym = "`1` does not contain a symbol to attach a rule to."
General::notfound = "Symbol `1` not found."
General::notnorm = "Argument `1` must be a nonatomic expression."
General::notstr = "The format type `1` is valid only for string input."
General::noval = "Symbol `1` in part assignment does not have an immediate value."
General::npad = "Value for option NumberPadding -> `1` should be a string or a pair of strings."
General::npoly = "`1` is not a polynomial with rational number coefficients."
General::npolys = "`1` is not a list of polynomials with rational number coefficients."
General::npt = "Value for option `1` -> `2` is expected to be a string."
General::nptg = "Value for option `1` -> `2` is expected to be a `3`."
General::nptn = "Value for option `1` -> `2` is expected to be a number."
General::nsdims = "Matrices `1` and `2` must have the same number of rows and columns."
General::nsgn = "Value for option NumberSigns -> `1` should be a pair of strings or two pairs of strings."
General::nspr = "Value for option NumberSeparator -> `1` should be a string or a pair of strings."
General::numberm = "Machine-size number expected at position `2` in `1`."
General::nupf = "`1` is not a univariate polynomial function with rational coefficients."
General::openr = "`1` is open for input."
General::openw = "`1` is open for output."
General::openx = "`1` is not open."
General::optlist = "Value of option `1` -> `2` should be a list."
General::opset = "Option `1` is not set in `2`."
General::opstl = "Value of option `1` -> `2` should be a string or a list of strings."
General::optb = "Optional object `1` in `2` is not a single blank."
General::optrs = "Option specification `1` in `2` is not a rule for a symbol or string."
General::patc = "Mixed operation with SparseArrays of explicit values and pattern type will result in a SparseArray of pattern type without explicit values."
General::moptrs = "Method option specification `1` in `2` is not a rule for a symbol or string."
General::opttf = "Value of option `1` -> `2` should be True or False."
General::optpn = "The value of `1` -> `2` should be a positive machine-size real number."
General::opttfa = "Value of option `1` -> `2` should be True, False, or Automatic."
General::optv = "Value of option `1` in `2` is not valid."
General::optvg = "Value of option `1` -> `2` should be `3`."
General::optvp = "Invalid option value at position `1` in `2`.  Allowed values are `3`."
General::optx = "Unknown option `1` in `2`."
General::moptx = "Method option `1` in `2` is not one of `3`."
General::ovfl = "Overflow occurred in computation."
General::par = "Inappropriate parameter: `1` -> `2`."
General::partd = "Part specification `1` is longer than depth of object."
General::partialinfo = "\!\(`1`\_x y\) is interpreted as `2`[y, x]."
General::partw = "Part `1` of `2` does not exist."
General::patop = "Pattern `1` contains inappropriate optional object."
General::pcolor = "The shading function has produced colors of different types."
General::plln = "Limiting value `1` in `2` is not a machine-size real number."
General::poly = "`1` is not a polynomial."
General::polyx = "`1` is not a polynomial with exact coefficients."
General::precbd = "Requested precision `1` is not a machine-sized real number between $MinPrecision and $MaxPrecision."
General::preclg = "Requested precision `1` is larger than $MaxPrecision. Using current $MaxPrecision of `2` instead. $MaxPrecision = Infinity specifies that any precision should be allowed."
General::precsm = "Requested precision `1` is smaller than $MinPrecision. Using $MinPrecision instead."
NDSolve::precw = "The precision of the differential equation (`1`) is less than WorkingPrecision (`2`)."
FindFit::precw = "The precision of the data and model function (`1`) is less than the specified WorkingPrecision (`2`)."
General::precw = "The precision of the argument function (`1`) is less than WorkingPrecision (`2`)."
General::primm = "Tried `1` primes, algorithm failed."
General::prims = "Prime `1` is too small, algorithm failed."
General::privv = "Privilege violation during `1`."
General::prserr = "`1`"
General::pspec = "Part specification `1` is neither an integer nor a list of integers."
General::pvec = "Unable to find principal vectors for eigenvalue `1`."
General::rawvar = "Parameter `1` in `2` is a raw expression and cannot be used as a variable."
General::rdeg = "`1` computation failed due to inability to use roots of the polynomial `2` of degree `3`, which exceeds $MaxRootDegree. Increasing the value of $MaxRootDegree may allow `1` to succeed."
General::readp = "Symbol `1` is read-protected."
General::real = "In attempting to decide whether a solution `1` is real, $MaxExtraPrecision `2` was encountered. The solution was assumed real. Increasing the value of $MaxExtraPrecision may help resolve the uncertainty."
General::span = "`1` is not a valid Span specification.  A Span specification should be 1, 2, or 3 integers separated by ;;.  (Any of the integers can be omitted, or replaced with All.)"
General::strval = "The value can only be changed to a string."
Dot::rect = Tr::rect = "Nonrectangular tensor encountered."
General::rect = "Nonrectangular array encountered."
General::rectn = "Rectangular array of real numbers is expected at position `2` in `1`."
General::rectt = "Rectangular array expected at position `2` in `1`."
General::remote = "`1` cannot write an output file since the front end and kernel do not share a common file system."
General::rnum = "`1` is not a valid root number."
General::rvalue = "`1` is not a variable with a value, so its value cannot be changed."
General::seqso = "Sequence specification (+n, -n, {+n}, {-n}, or {m, n}) expected at position `2` in `1`."
General::seqs = "Sequence specification (+n, -n, {+n}, {-n}, {m, n}, or {m, n, s}) expected at position `2` in `1`."
General::setp = "Part assignment to `1` could not be made."
General::setps = "`1` in the part assignment is not a symbol."
General::shdw = "Symbol `1` appears in multiple contexts `2`; definitions in context `3` may shadow or be shadowed by other definitions."
General::shdwcor = "Symbol `1` defined in `2` already exists in `3`. Select the version you want to use: `4`."
General::shlen = "The argument `1` should have at least two elements."
General::sign = "Unable to determine the sign of `1`. The expression was assumed to be zero. Increasing the value of $MaxExtraPrecision may help resolve the uncertainty."
General::sing = "Matrix `1` is singular."
General::sntx = "Invalid syntax in or before \"`1`\".`4`"
General::sntxb = "Expression cannot begin with \"`1`\".`4`"
General::sntxc = "The comment starting at \"`1`\" has no closing \"*)\".`4`"
General::sntup = "Unexpected end of file (probably unclosed parenthesis).`4`"
General::sntue = "Unexpected end of file (probably unfinished expression).`4`"
General::sntxf = "\"`1`\" cannot be followed by \"`2`\".`4`"
General::sntxi = "Incomplete expression; more input is needed.`4`"
General::sntxpi = "Incomplete expression in result of $PreRead.`4`"
General::sntxpr = "Invalid syntax in result of $PreRead."
General::sntxq = "The string starting at \"`1`\" has no closing quote.`4`"
General::spell = "New symbol name \"`1`\" is similar to existing symbols `2` and may be misspelled."
General::spell1 = "New symbol name \"`1`\" is similar to existing symbol \"`2`\" and may be misspelled."
General::ssle = "Symbol, string, or HoldPattern[symbol] expected at position `2` in `1`."
General::stmtype = "FormatType option of stream `1` cannot be set to `2`. Use a string-based format such as OutputForm."
General::stop = "Further output of `1` will be suppressed during this calculation."
General::strbox = "`1` is an operator for representing textual boxes in strings."
General::stream = "`1` is not a string, InputStream[ ], or OutputStream[ ]."
General::string = "String expected at position `1` in `2`."
General::stringopt = "`1` in `2` is not a string. All options to `3` must be strings."
General::strmi = "First argument in `1` is not a valid file or string identifier."
General::strml = "`1` is not a string, stream, or list of strings and streams."
General::strmn = "Requested stream `1` does not match existing stream `2` with the same stream number."
General::strpatt = "String or string pattern expected at position `1` in `2`."
General::strpatts = "String/string pattern or list of such expected at position `1` in `2`."
General::strs = "String or nonempty list of strings expected at position `1` in `2`."
General::strse = "String or list of strings expected at position `1` in `2`."
General::suminfo = "\!\(`1`\^i\%imax f\) is interpreted as `2`[f, {i,imax}]."
General::sym = "Argument `1` at position `2` is expected to be a symbol."
General::sysname = "`1` is not a known SystemOption."
General::systrg = "`1` is not a string. SystemOptions must be strings."
General::tag = "Rule for `1` of `2` can only be attached to `3`."
General::tolset = "Cannot set `1` to `2`; value must be a real number or +/- Infinity."
General::toomany = "The length of the output of `1` should be a machine integer."
General::trace = "`1` --> `2`."
General::tsntxi = "\"`1`\" is incomplete; more input is needed.`4`"
General::uinfix = "An infix operator. \!\(x `1` y\) is by default interpreted as \!\(`2`[x, y]\)."
General::unavail = "`1` is not available in this version of Mathematica."
General::unfl = "Underflow occurred in computation."
General::uniclose = "`1` is a closing matchfix operator."
General::uniopen = "`1` is an opening matchfix operator."
General::unique = "There is more than one occurrence of `1` in `2`.  `1` is required to be unique."
General::unuser = "Unknown user: `1`."
General::uprefix = "A prefix operator. \!\(`1` x\) is by default interpreted as \!\(`2`[x]\)."
General::upreinfix = "An infix and prefix operator. \!\(x `1` y\) is by default interpreted as \!\(`2`[x, y]\) ; \!\(`1` x\) is by default interpreted as \!\(`2`[x]\)."
General::write = "Tag `1` in `2` is Protected."
General::wrsym = "Symbol `1` is Protected."
General::ztest = "Unable to decide whether numeric quantities `1` are equal to zero. Assuming they are."
General::zval = "Non-numerical value `1` found at position `2` in the first argument."
General::unpack = "Unpacking array in call to `1`."
General::unpack1 = "Unpacking array."
General::punpack = "Unpacking array to level `2` in call to `1`."
General::punpack1 = "Unpacking array to level `1`."
General::colfun= "ColorFunction `1` does not produce a valid color or gray-level directive when applied to element `2`."
General::colfun1= "ColorFunction `1` produces a color incompatible with the previous color when applied to element `2`."
General::rep = "`1` is not a valid replacement rule."
General::addsyms = "Autoloading file `1` added symbols `2`."
General::autoload = "Symbol `1` has autoloading rules attached to load `2`; these rules are disabled by the setting of $AutoLoad to False. The package can be loaded with Get and the evaluation repeated."
General::badsys1 = "File `1` returned symbols `2` that did not match the declared symbol list `3`."
General::badsys2 = "Loading file `1` has removed these system definitions: `2`."
General::badsys3 = "Loading file `1` has added system definitions `2` that were not specified in the symbol list for that file."
General::badsys4 = "Loading file `1` returned `2`; it should return a list of the exported symbols."
General::sysfile = "Binary file loading of package `1` by symbol `2` failed."
General::dupv = "Duplicate variable `1` found in `2`."
General::blnotn = "The value of the argument `1` in position `2` is not a number."
General::blncorr = "The value of the argument `1` in position `2` is incorrect."
General::blwarg = "The output argument `1` in position `2` is inconsistent with the input argument(s)."
General::blndim1= "The argument `1` in position `2` has incorrect dimension(s)."
General::blrank = "The argument `1` evaluates to rank `2`. Rank `3` is expected."
General::blrank1 = "The argument `1` evaluates to rank `2`. Rank `3` or `4` is expected."
General::blnotsym = "The argument `1` at position `2` should not contain any symbol for which no numerical value is defined."
LinearAlgebra`LAPACK`LANV2::blnsym1 = "The input arguments cannot be symbols for which no numerical values are defined."
LinearAlgebra`LAPACK`LANV2::blcmplx = "The input arguments cannot be complex numbers."
General::blnoval = "The symbol `1` at position `2` should have an immediate value defined."
General::blscas = "The argument `1` should be a symbol that has a scalar immediate value."
General::bldim = "The arguments `1` and `2` in `3` do not have compatible dimensions."
General::bldim1 = "The argument `1` should be a matrix of dimensions `2` by `3`."
General::blveclen = "The argument `1` should be a vector of length `2`."
General::blnotsq = "The argument `1` does not have the first dimension at least as large as the second dimension."
General::blnsetst = "The argument `1` at position `2` is not a string starting with one of the letters from the set `3`."
General::blnulst = "The argument `1` at position `2` must be a nonempty string."
General::blreal = "The argument `1` cannot be of complex type."
General::blnegn = "The argument `1` should be non-negative." 
General::blnmpre = "Argument in `1` is not a positive real number or MachinePrecision symbol."
LinearAlgebra`BLAS`TestArgument::blapos = "The second argument `1` should be an integer that gives the argument position in `2` to test."
LinearAlgebra`BLAS`TestArgument::bltrank = "The required tensor rank `1` should be 0, 1, 2, or _."
General::blintli = "The argument `1` should have integer elements only."
General::blincor = "The arguments `1` and/or `2` are incorrect."
LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv = LinearAlgebra`LAPACK`LASWP::blnotpiv = "The pivot vector `1` is incorrect."
LinearAlgebra`LAPACK`LARTG::blneqsym = "You cannot use the same symbol `1` in positions `2` and `3`."
LinearAlgebra`LAPACK`GESVX::blinstlu = "Warning: the LU factorization of the matrix `1` at position `2` can be unstable, and the solution of the system can be unreliable."
General::notperm = "The permutation vector `1` is incorrect."
General::accg = "Value of option AccuracyGoal -> `1` is not Automatic, Infinity, or a machine-sized real or integer."
General::precg = "Value of option PrecisionGoal -> `1` is not Automatic, Infinity, or a positive machine-size integer or real."
General::specset = "Cannot change the value of special symbol `1`."
General::wprec = "Value of option WorkingPrecision -> `1` is not a positive machine-sized real or integer."
General::agpginf = "Both Accuracy and Precision goals are sufficiently large to allow effectively zero tolerance.  The numerical algorithm cannot solve the problem exactly."
Get::enkey = "Cannot decode encoded file; incorrect key or machine."
Get::notencode = "Warning: The file `1` is not encoded."
Get::path = "`1` in $Path is not a string."
Goto::nolabel = "Label `1` not found."
Graphics::gpt = "Coordinate `1` is not of the form {x, y}."
Graphics::gptn = "Coordinate `1` in `2` is not a floating-point number."
Graphics::hue = "`1` is not of length 1 or 3."
Graphics::realp = "Argument in `1` is not a positive real number."
Graphics::realu = "Argument in `1` is not a real number between 0 and 1."
Graphics::terminal = "Load JavaGraphics.m or Terminal.m for rendering graphics with a stand-alone kernel."
Graphics3D::ambnt = "Value of option `1` -> `2` is not a valid GrayLevel or RGBColor specification."
Graphics3D::boxz = "Box for 3D graphics has zero size."
Graphics3D::gsing = Plot3D::gsing = "Singular homogeneous transformation generated."
Graphics3D::gsort = "More than 10^9 polygons to sort."
Graphics3D::lights = "Value of option `1` -> `2` is not of the form {{pos, col}, {pos, col}, ...}."
Graphics3D::ltcol = "Element `1` in LightSources option contains `2`, which is not a valid GrayLevel or RGBColor directive."
Graphics3D::psvf = "Function value at x = `1`, y = `2` was sent to infinity by perspective transformation."
Graphics3D::p3mat = "Value of Plot3Matrix -> `1` is not a 4 x 4 numerical matrix."
GraphicsArray::obs = "GraphicsArray is obsolete. Switching to GraphicsGrid."
GraphicsArray::arrsp = "Value of option GraphicsSpacing -> `1` should be a number greater than 0 or a list of two such numbers."
GraphicsArray::prim = "Argument to GraphicsArray, `1`, should be a vector or a matrix of graphics objects."
GridLines::grid = "`1` is not a valid grid specification."
GroebnerBasis::badcf = GroebnerBasis`GroebnerWalk`GroebnerWalk::badcf = PolynomialReduce::badcf = GroebnerBasis`DistributedTermsList::badcf = "Encountered bad coefficient `1`."
GroebnerBasis::coef = GroebnerBasis`GroebnerWalk`GroebnerWalk::coef = PolynomialReduce::coef = GroebnerBasis`DistributedTermsList::coef = "Value of option CoefficientDomain -> `1` is not valid."
GroebnerBasis::elmvar = GroebnerBasis`GroebnerWalk`GroebnerWalk::elmvar = PolynomialReduce::elmvar = GroebnerBasis`DistributedTermsList::elmvar = "Term ordering `1` is not compatible with elimination variables."
GroebnerBasis::fltgb = GroebnerBasis`GroebnerWalk`GroebnerWalk::fltgb = PolynomialReduce::fltgb = GroebnerBasis`DistributedTermsList::fltgb = "Excessive loss of precision during computation."
GroebnerBasis::intgb = GroebnerBasis`GroebnerWalk`GroebnerWalk::intgb = PolynomialReduce::intgb = GroebnerBasis`DistributedTermsList::intgb = "Nontrivial denominator in `1` is invalid input for `2` over the integers."
GroebnerBasis::mnmord1 = GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord1 = PolynomialReduce::mnmord1 = GroebnerBasis`DistributedTermsList::mnmord1 = "Value of option MonomialOrder -> `1` is not valid."
GroebnerBasis::mnmord2 = GroebnerBasis`GroebnerWalk`GroebnerWalk::mnmord2 = PolynomialReduce::mnmord2 = GroebnerBasis`DistributedTermsList::mnmord2 = "`1` does not order all terms formed from variables `2`."
GroebnerBasis::modflt = GroebnerBasis`GroebnerWalk`GroebnerWalk::modflt = PolynomialReduce::modflt = GroebnerBasis`DistributedTermsList::modflt = "Cannot specify nonzero modulus when working with inexact coefficients."
GroebnerBasis::pdvar2 = GroebnerBasis`GroebnerWalk`GroebnerWalk::pdvar2 = PolynomialReduce::pdvar2 = GroebnerBasis`DistributedTermsList::pdvar2 = "The polynomial domain variable `1` is improperly used in polynomial `2`."
GroebnerBasis::poly2 = GroebnerBasis`GroebnerWalk`GroebnerWalk::poly2 = PolynomialReduce::poly2 = GroebnerBasis`DistributedTermsList::poly2 = Resultant::poly2 = Discriminant::poly2 = "`1` is not a well-formed polynomial in `2`."
GroebnerBasis::wgtmat1 = GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat1 = PolynomialReduce::wgtmat1 = GroebnerBasis`DistributedTermsList::wgtmat1 = "`1` is not a valid weight matrix."
GroebnerBasis::wgtmat2 = GroebnerBasis`GroebnerWalk`GroebnerWalk::wgtmat2 = PolynomialReduce::wgtmat2 = GroebnerBasis`DistributedTermsList::wgtmat2 = "Weight matrix based on variable list `1` is invalidated by the internal variable list `2`."
GroebnerBasis`GroebnerWalk`GroebnerWalk::gmeth1 = GroebnerBasis::gmeth1 = "Recursive use of `1` is invalid."
GroebnerBasis`GroebnerWalk`GroebnerWalk::gmeth2 = GroebnerBasis::gmeth2 = "Value of option Method -> `1` should be Automatic, \"Buchberger\", or \"GroebnerWalk\"."
GroebnerBasis`GroebnerWalk`GroebnerWalk::gstrat = GroebnerBasis::gstrat = "Value of option SelectionStrategy -> `1` should be \"SimulatedHomogenization\", \"NormalSelection\", or None."
GroebnerBasis`GroebnerWalk`GroebnerWalk::parmvar = "Use weight matrix instead of parameter(s) `1`."
HankelMatrix::crs = ToeplitzMatrix::crs = "Warning: The column element `1` and row element `2` at positions `3` and `4` are not the same. Using column element."
HermiteDecomposition::latm = LatticeReduce::latm = "Matrix contains an entry that is not rational."
HorizontalForm::precd = VerticalForm::precd = "Precedence list `1` is not of the form {head, prec, assoc, ...}."
Save::wtype = "`1` in `2` must be a symbol, a string or a list of symbols and strings."
Import::charenc = "Character encoding `1` is not supported." 
Import::chtype = "First argument `1` is not a valid file, directory, or URL specification."
Import::expectdir = "First argument `1` is not a directory specification."
Import::coerr = Export::coerr = "Invalid setting `1` -> `2`."
Import::costr = "`1` in `2` is not a string. This option must be specified as a string."
Import::errelem = "The Import element `1` is not a valid element for the `2` format."
Import::fmterr = "Cannot import data as `1` format."
Import::formvers = "Import of format version `1` may not work correctly."
Import::nosup = "`1` contains unsupported `2`, which will be ignored."
Import::fnfnd = "File `1` not found."
Import::format = "Cannot import data as `1`."
Import::fmtnosup = "`1` is not a supported Import format."
Import::general = Export::general = "`1`"
Import::infer = Export::infer = "Cannot infer format of file `1`."
Import::inferdir = "Cannot infer format from directory `1`."
Import::dataset = "File does not contain a dataset `1`." 
Import::h5empty = "The HDF5 file \"`1`\" does not contain any datasets."
Import::h5type = "The datatype of the dataset \"`1`\" is not currently supported."
Import::imgsze = "When importing as `1`, the raster size must be specified by setting the ImageSize option."
Import::installreq = "`1` is supported only if `2` is installed."
Import::intp = "`1` is not a positive integer."
Import::uneqlen = "Elements `1` and `2` must have the same length."
Import::memavail = "Could not allocate memory for import of `1` format."
Import::nffil = "File not found during `1`."
Import::nlist = "`1` is not a list of strings."
Import::nlist2 = "`1` is not a list of two elements."
Import::nodta = "Insufficient data found for `1` format."
Import::noelem = "The Import element \"`1`\" is not present when importing as `2`."
Import::elemstx = Export::elemstx = ImportString::elemstx = ExportString::elemstx = "`1` is not a valid format or element specification. Expecting a string, list, or integer."
Import::nodirsup = "Cannot import directory `1` as `2`."
Import::noopts = "The Import option `1` is not a valid option for the `2` format."
Import::nofe = "A front end is not available; import of `1` requires a front end."
Import::ribent = "RIB file `1` does not contain Entity data that can be imported."
Import::sdtsnolayer = "The following layers are not present in the SDTS bundle: `1`."
Import::sdtslayerspec = "Cannot understand layer specification `1`. Please enter a list of names or numbers."
Import::sdtsmodnf = "Module type `1` is not present in the file."
Import::sdtsmodinv = "Module `1` does not have the proper form. If this is an old SDTS file, please update it."
Import::unsup = "Unsupported `1` format type."
Import::malxml = "Could not read malformed XML document."
Import::pdtder = "Could not parse XML document. This may be due to undeclared entities in the XML document, or a failure loading the DTD.  Check that entities are correctly declared or use the \"AllowUnrecognizedEntities\" option."
Import::unrecxml = "The document was not a recognized type of XML.  Try Importing as a general \"XML\" document."
Import::texerr = "`1`"
ImportString::format = "`1` is not a recognized ImportString format."
ImportString::fmtnosup = "`1` is not a supported ImportString format."
ImportString::infer = "Cannot infer format from string `1`."
ImportString::string = "First argument `1` is not a string."
ImportString::bkslsh = ToExpression::bkslsh = "The string `1` contains single backslashes. Backslash characters inside strings are represented by \\\\."
Inequality::ineq = "Inequality called with `1` arguments; the number of arguments is expected to be an odd number >= 3."
Developer`InequalityInstance::lowpr = Experimental`ExistsRealQ::lowpr = Experimental`ForAllRealQ::lowpr = Experimental`ImpliesRealQ::lowpr = "The precision of coefficients of system `1` was too low to decide whether there are any solutions."
SemialgebraicComponentInstances::nrpi = Developer`InequalityInstance::nrpi = Experimental`ExistsRealQ::nrpi = Experimental`ForAllRealQ::nrpi = Experimental`ImpliesRealQ::nrpi = "`1` is not a logical formula consisting of polynomial equations and inequalities in `2` with exact real number coefficients."
Experimental`ExistsRealQ::nrps = Experimental`ForAllRealQ::nrps = Experimental`ImpliesRealQ::nrps = "`1` is not a logical formula consisting of polynomial equations and inequalities with real number coefficients."
Developer`InequalityInstance::weak = Experimental`ExistsRealQ::weak = Experimental`ForAllRealQ::weak = Experimental`ImpliesRealQ::weak = "No solution of the system of inequalities with inexact coefficients has been found. The solution `1` of the system with strong inequalities replaced by weak inequalities has been found. This means the original system may have solutions for some values of inexact coefficients within the error bounds."
Developer`InequalityInstance::wkno = Experimental`ExistsRealQ::wkno = Experimental`ForAllRealQ::wkno = Experimental`ImpliesRealQ::wkno = "No solution of the system of inequalities with inexact coefficients has been found. However, the algorithm was not able to prove that the system has no solutions for any values of inexact coefficients within the error bounds."
Infix::group = Postfix::group = Prefix::group = "Grouping specification `1` is not NonAssociative, None, Left, or Right."
Information::basic = "?Name gives information on Name, ?Ab* on all symbols starting with Ab. ??Name gives more information."
Information::nomatch = "No symbol matching `1` found."
Information::notfound1 = "Symbol `1` not found."
Information::opt = "`1` is an invalid option."
Information::ssym = "`1` is not a symbol or a valid string pattern."
Inner::incom = "Length `1` of dimension `2` in `3` is incommensurate with length `4` of dimension 1 in `5`."
Inner::inntf = "Transpose failed for `1`."
Inner::nolev = "Level `1` is not available in `2` (dimensions `3`)."
Insert::ins = "Cannot insert at position `1` in `2`"
IntegerDigits::ibase = IntegerExponent::ibase = IntegerLength::ibase = "Base `1` is not an integer greater than 1."
Integrate::diffend = "`1` cannot be interpreted since `2` is followed by `3`. It may be necessary to use parentheses to ensure that `2` appears at the end of the integral."
Integrate::gener = "Unable to check convergence."
Integrate::idiv = "Integral of `1` does not converge on `2`."
Integrate::isub = "Warning: Infinite subdivision of the integration domain has been used in computation of the definite integral `1`. If the integral is not absolutely convergent, the result may be incorrect."
Sum::isub = "Warning: infinite subdivision of the iteration domain has been used in computation of the sum `1`. If the sum is not absolutely convergent, the result may be incorrect."
Product::isub = "Warning: infinite subdivision of the iteration domain has been used in computation of the product `1`. If the product is not absolutely convergent, the result may be incorrect."
Integrate::mdiv = "The multivariate integral `1` does not converge."
Integrate::ilim = "Invalid integration variable or limit(s) in `1`."
Integrate::intmul = "The integral operator `1` cannot be nested directly inside the integral operator `2`. Only identical integral operators can be nested inside each other without parentheses."
Integrate::intnest = "The integral `1` cannot be interpreted. The number of integral operators must match the number of differential operators."
Integrate::nodiffd = Integrate::novar = "`1` cannot be interpreted. Integrals are entered in the form \!\(\[Integral]f\[DifferentialD]x\), where \!\(\[DifferentialD]\) is entered as \[EscapeKey]dd\[EscapeKey]."
Integrate::wrongd = "`1` cannot be interpreted. Integrals use the differential d (entered as \[EscapeKey]dd\[EscapeKey]), not an ordinary keyboard d."
InterpolatingFunction::cmpile = "The InterpolatingFunction could not be compiled because it has symbolic data or abscissas that cannot be resolved with machine numbers."
InterpolatingFunction::dmval = "Input value `1` lies outside the range of data in the interpolating function. Extrapolation will be used."
InterpolatingFunction::dmvali = "The integration endpoint `1` in dimension `2` lies outside the range of data in the interpolating function. Extrapolation will be used."
InterpolatingFunction::dprec = "The precision of input value `1` and/or the interpolation grid is insufficient to compute the value."
InterpolatingFunction::unsop = "The operation is not supported for `1` that was created with NDSolve using InterpolationOrder -> All."
InterpolatingPolynomial::ipdup = "The abscissae are not distinct."
InterpolatingPolynomial::ipnd = "No function or derivative value was specified with `1` in `2`."
InterpolatingPolynomial::ipab = "Abscissa specification `1` in `2` is not a point in `3` dimensions."
InterpolatingPolynomial::moddata = "When interpolating data with a prime modulus p, values must be exact and valid modulo p."
InterpolatingPolynomial::poised = "The interpolation points `1` are not poised, so an interpolating polynomial of total degree `2` could not be found."
InterpolatingPolynomial::noipf = "Unable to find an interpolating polynomial of total degree `1`."
Interpolation::inauto = ListInterpolation::inauto = "The function value at each grid point must be specified. It cannot be omitted or given as \"Automatic\"."
Interpolation::incon = ListInterpolation::incon = InterpolatingFunction::incon = "The `1` derivative was not specified consistently across other dimensions."
InterpolatingPolynomial::vdims = Interpolation::vdims = ListInterpolation::vdims = "Data value `1` has dimensions incompatible with other data that has been specified."
InterpolatingPolynomial::varry = Interpolation::varry = ListInterpolation::varry = "Data value `1` is not a rectangular array."
Interpolation::indat = ListInterpolation::indat = "Data point `1` contains abscissa `2`, which is not a real number."
Interpolation::indatg = ListInterpolation::indatg = "The abscissa `2` in dimension `1` is not a real number."
Interpolation::inddp = ListInterpolation::inddp = "The point `1` in dimension `2` is duplicated."
Interpolation::indep = ListInterpolation::indep = InterpolatingFunction::indep = "An order-`1` derivative was specified in `2` without all corresponding lower-order derivatives."
InterpolatingPolynomial::inder = Interpolation::inder = ListInterpolation::inder = "The order-`1` derivative of `2` is not a tensor of rank `1` with dimensions `3`."
Interpolation::indim = ListInterpolation::indim = "The coordinates do not lie on a structured tensor product grid."
Interpolation::indimt = ListInterpolation::indimt = "The coordinate `1` in dimension `2` is not consistent with other values for this coordinate in this row of the data."
Interpolation::inhr = ListInterpolation::inhr = InterpolatingFunction::inhr = "Requested order is too high; order has been reduced to `1`."
Interpolation::inlen = "Inconsistent element `1` encountered; all data elements must have the same length."
Interpolation::innd = ListInterpolation::innd = "First argument in `1` does not contain a list of data and coordinates."
Interpolation::inord = ListInterpolation::inord = FunctionInterpolation::inord = "Value of option `1` -> `2` should be a non-negative machine-sized integer or a list of integers with length equal to the number of dimensions, `3`."
Interpolation::inpts = "The total number `1` of data points is not a multiple of the number `2` of points in dimension `3`."
Interpolation::mixedp = ListInterpolation::mixedp = InterpolatingPolynomial::mixedp = "Equality of mixed partials in the `1` derivative of data `2` was not satisfied. Using `3`."
Interpolation::per = ListInterpolation::per = "In dimension `1` the data at the endpoints of the fundamental period are not equal."
Interpolation::ipdup = "The specified abcissae `1` are not distinct."
Interpolation::tpgrid = "The specified abcissae do not lie on a tensor product grid.  Piecewise interpolation is only supported on unstructured grids in two dimensions."
Interpolation::fdtp = "Specification of derivative values is only supported for abcissae on tensor product grids.  The abcissae in `1` do not lie on a tensor product grid."
Interrupt::dgbgn = TraceDialog::dgbgn = "Entering Dialog; use Return[] to exit."
Interrupt::dgend = TraceDialog::dgend = "Exiting Dialog."
Interval::nvld = "The form `1` does not represent a valid interval."
Inverse::invc = "Result for inverse of badly conditioned matrix `1` may contain significant numerical errors."
InverseFunction::ifun = "Inverse functions are being used. Values may be lost for multivalued inverses."
InverseFunction::noinv = "The function `1` is not invertible."
JacobiSymbol::jcpo = "Second argument `1` in `2` should be an odd, positive integer."
Join::headsd = "Expression `1` at position `2` is expected to have head `3` for all subexpressions through level `4`."
Last::nolast = "`1` has a length of zero and no last element."
LegendreP::ltype = LegendreQ::ltype = "Legendre type `1` is expected to be 1, 2, or 3."
Limit::ldir = "Value of Direction -> `1` should be a number or Automatic."
Limit::lim = "Limit specification `1` is not of the form x -> x0."
Limit::limf = "Unable to determine limit direction from `1`."
Limit::zfun = "Unable to determine whether expressions `1` are equal to zero. Assuming they are."
Import::mpsiv = "Warning: integer variables found in MPS data input and treated as real."
Import::mpsmr = "Warning: Multiple right-hand sides found in MPS data input. Only the first one will be used."
Import::mpsbv = "Warning: binary variables found in MPS data input and treated as real."
DualLinearProgramming::lpbd = LinearProgramming::lpbd = "The input that specifies lower/upper bounds contains elements that are not real numbers, Infinity, or -Infinity."
FindMinimum::maxit = FindMaximum::maxit = DualLinearProgramming::maxit = LinearProgramming::maxit = "Maximum number of iterations `1` reached without convergence."
DualLinearProgramming::lpdim = LinearProgramming::lpdim = "Invalid input: the dimensions of the input vectors or matrices must match."
DualLinearProgramming::lpnn = LinearProgramming::lpnn = ConstrainedMax::lpnn = ConstrainedMin::lpnn = "Input data to linear programming algorithm `1` contains elements that are empty matrices, invalid vectors or matrices, or not real numbers."
LinearProgramming::mreal = FindMinimum::mreal = FindMaximum::mreal = "Input data contains numbers that can not be coerced into machine reals."
DualLinearProgramming::lprank2 = LinearProgramming::lprank2 = "`1` is not a matrix."
DualLinearProgramming::lprank1 = LinearProgramming::lprank1 = "`1` is not a vector."
DualLinearProgramming::lprank12 = LinearProgramming::lprank12 = "`1` must be a vector or a matrix with 2 columns."
DualLinearProgramming::lprank012 = LinearProgramming::lprank012 = "`1` must be a scalar, a vector, or a matrix with 2 columns."
DualLinearProgramming::lpsg = LinearProgramming::lpsg = "The second column of `1` must be a vector consisting of -1,  1, or 0, indicating respectively inequalities with <=, =>, or equality."
DualLinearProgramming::lpmethod = LinearProgramming::lpmethod = "`1` is not a valid method for linear programming."
ConstrainedMax::cmr = ConstrainedMin::cmr = DualLinearProgramming::cmr = LinearProgramming::cmr = "The constraint matrix `1` in `2` must be a matrix of real numbers."
ConstrainedMax::cmz = ConstrainedMin::cmz = DualLinearProgramming::cmz = LinearProgramming::cmz = "For the constraint matrix `1` in `2` to represent valid constraints, each row must have length greater than zero and contain at least one nonzero entry."
ConstrainedMax::cvr = ConstrainedMin::cvr = DualLinearProgramming::cvr = LinearProgramming::cvr = "The vector `1` in `2` must be a nonzero-length vector of real numbers."
ConstrainedMax::lptol = ConstrainedMin::lptol = DualLinearProgramming::lptol = LinearProgramming::lptol = "Value of option Tolerance -> `1` is not a positive real number or Automatic."
Optimization`LinearProgramming`Simplex::lpsiter = DualLinearProgramming::lpsiter = LinearProgramming::lpsiter = "The value of option MaxIterations -> `1` should be a positive integer or Infinity."
Optimization`LinearProgramming`Simplex::lpsiter1 = DualLinearProgramming::lpsiter1 = LinearProgramming::lpsiter1 = "The number of iterations taken has exceeded the preset limit of MaxIterations = `1`. Try setting the MaxIterations option to a higher number."
Optimization`LinearProgramming`Simplex::lpsbnn = DualLinearProgramming::lpsbnn = LinearProgramming::lpsbnn = "Found lower bound and upper bound both set at `1`."
Optimization`LinearProgramming`Simplex::lpsom = DualLinearProgramming::lpsom = LinearProgramming::lpsom = "Warning: The value of the option \"ScalingMethod\" -> \"Optimal\" is not allowed for non-machine-number problems. \"ScalingMethod\" -> \"NormalizeRow\" will be used instead."
FindMaximum::lpsnf = FindMinimum::lpsnf = Optimization`LinearProgramming`Simplex::lpsnf = ConstrainedMax::lpsnf = ConstrainedMin::lpsnf = DualLinearProgramming::lpsnf = LinearProgramming::lpsnf = "No solution can be found that satisfies the constraints."
Optimization`LinearProgramming`Simplex::lpspm = DualLinearProgramming::lpspm = LinearProgramming::lpspm = "Pricing method specification `1` is invalid."
Optimization`LinearProgramming`Simplex::lpssm = DualLinearProgramming::lpssm = LinearProgramming::lpssm = "Scaling method specification `1` is invalid."
FindMinimum::lpsub = FindMaximum::lpsub = NMaximize::lpsub = NMinimize::lpsub = Optimization`NonlinearInteriorPoint::lpsub = Optimization`LinearProgramming`Simplex::lpsub = ConstrainedMax::lpsub = ConstrainedMin::lpsub = DualLinearProgramming::lpsub = LinearProgramming::lpsub = "This problem is unbounded."
DualLinearProgramming::lplop = LinearProgramming::lplop = "For a problem of this size, `1` uses the interior point algorithm, which only returns a result of machine precision. If a result of non-machine precision is needed, set the option to Method -> `2`, though it may take longer computing time."
DualLinearProgramming::lpipp = LinearProgramming::lpipp = "Warning: Method -> InteriorPoint specified for non-machine-precision problem. A machine-precision result will be given. If a non-machine-precision result is needed, set the option to Method -> `1`."
FindMinimum::lpdinf = FindMaximum::lpdinf = DualLinearProgramming::lpdinf = LinearProgramming::lpdinf = "The dual of this problem is infeasible, which implies that this problem is either unbounded or infeasible. Setting the option Method -> `1` should give a more definite answer, though large problems may take longer computing time."
FindMinimum::lpdinf0 = FindMaximum::lpdinf0 = DualLinearProgramming::lpdinf0 = LinearProgramming::lpdinf0 = "The dual of this problem is infeasible, which implies that this problem is either unbounded or infeasible."
DualLinearProgramming::lpdinfp = LinearProgramming::lpdinfp = "The dual of this problem is possibly infeasible, which implies that this problem is either unbounded or infeasible. Setting the option Method -> `1` should give a more definite answer, though large problems may take longer computing time."
DualLinearProgramming::lpsnfp = LinearProgramming::lpsnfp = "This problem is probably infeasible. Setting the option Method -> `1` should give a more definite answer, though large problems may take longer computing time."
DualLinearProgramming::lpipcv = LinearProgramming::lpipcv = "Warning: The interior point algorithm cannot converge to the tolerance of `2`. The best residual achieved is `1`, and the solution at that residual has been returned. Setting the option Method -> `3` should give a more definite answer, though large problems may take longer computing time."
DualLinearProgramming::lptols = LinearProgramming::lptols = "Warning: The supplied tolerance of `1` might be too small for the interior point algorithm. Typically a reasonable tolerance for the interior point algorithm is `2` (the square root of the machine epsilon)."
DualLinearProgramming::lpipncv = LinearProgramming::lpipncv = "The interior point algorithm cannot converge to the tolerance of `1`. The best residual achieved is `2`. The failure to converge might be because the problem is mildly infeasible. Setting the option Method -> `3` should give a more definite answer, though large problems may take longer computing time."
DualLinearProgramming::lpitd = LinearProgramming::lpitd = "Value of option TreatDenseColumns -> `1` is not True, False, or Automatic."
Optimization`LinearProgramming`Simplex::lpsdm2 = "The row dimensions of the second and third arguments do not match."
Optimization`LinearProgramming`Simplex::lpsdm3 = "The row dimensions of the fourth and fifth arguments do not match."
Optimization`LinearProgramming`Simplex::lpsdm4 = "The column dimension of the second argument does not match the length of the first argument."
Optimization`LinearProgramming`Simplex::lpsdm5 = "The length of the first argument does not match the length of the lower bound."
Optimization`LinearProgramming`Simplex::lpsdm6 = "The length of the first argument does not match the length of the upper bound."
Optimization`LinearProgramming`Simplex::lpsdm7 = "The column dimension of the fourth argument does not match the length of the first argument."
General::gfargs = "Generalized `1` arguments accept only matrices with machine real and complex elements."
FindMinimum::lpuncon = FindMaximum::lpuncon = "Method -> LinearProgramming cannot be used on an unconstrained optimization problem."
FindMinimum::qpuncon = FindMaximum::qpuncon = "Method -> QuadraticProgramming cannot be used on an unconstrained optimization problem."
LinearProgramming::intv = "The value of IntegerValues -> `1` must be None, All, or a list of positive integers no larger than the number of variables."
FindMinimum::nonquad = FindMaximum::nonquad = "The value of Method -> QuadraticProgramming is inconsistent with the nonquadratic objective or nonlinear constraints in `1`."
FindMinimum::nonilin = FindMaximum::nonlin = "The value of Method -> IntegerLinearProgramming is inconsistent with nonlinear constraints or object function in `1`."
FindMinimum::bdmtd = FindMaximum::bdmtd = "Value of option Method -> `1` is not Automatic, \"Gradient\", \"ConjugateGradient\", \"InteriorPoint\", \"QuasiNewton\", \"Newton\", \"LinearProgramming\", \"QuadraticProgramming\" or \"LevenbergMarquardt\"."
LinearProgramming::bab = "Warning: Problem specified contains integer variables; it cannot be solved using `1` method. Integer constraints ignored."
FindMinimum::lpmp2 = FindMaximum::lpmp2 = Optimization`QuadraticProgramming::lpmp2 = DualLinearProgramming::lpmp2 = LinearProgramming::lpmp2 = "Warning: Method -> `1` is specified for a non-machine-precision problem: the problem will be converted into machine precision. Used Method -> `2` for non-machine-number problem."
DualLinearProgramming::lpmp = LinearProgramming::lpmp = "Warning: Method -> `1` is specified for a non-machine-precision problem; the problem will be converted into machine precision."
FindMinimum::lpip = FindMaximum::lpip = DualLinearProgramming::lpip = LinearProgramming::lpip = "Warning: integer linear programming will use a machine precision approximation of the inputs."
Optimization`QuadraticProgramming::qp1 = LinearProgramming::qp1 = DualLinearProgramming::qp1 = "The first argument `1` must be a matrix."
DualLinearProgramming::ivs = LinearProgramming::ivs = "The value of IntegerValues -> `1` must be None, All, or a list of positive integers no larger than the number of variables."
Optimization`QuadraticProgramming::mcp = LinearProgramming::mcp = "Warning: Only Method -> CLP is allowed for a quadratic programming problem. Using Method -> CLP instead."
(* end Integer Programming/QP *)
General::nonnum = "`1` has received a matrix with non-numerical elements."
General::oflow = "Machine overflow encountered during computations."
Optimization`ModifiedCholeskyDecomposition::herm = CholeskyDecomposition::herm = "The matrix `1` is not Hermitian or real and symmetric."
Optimization`ModifiedCholeskyDecomposition::posdef = CholeskyDecomposition::posdef = "The matrix `1` is not sufficiently positive definite to complete the Cholesky decomposition to reasonable accuracy."
SingularValues::neqcols = SingularValueList::neqcols = SingularValueDecomposition::neqcols = "The matrices '1' and '2' must have the same number of columns."
LinearSolve::lsfail = "LinearSolve could not find solutions to the linear system."
General::lslc = "Coefficient matrix and target vector(s) or matrix do not have the same dimensions."
LeastSquares::nosol = LinearSolve::nosol = "Linear equation encountered that has no solution."
Developer`LinearExpressionToMatrix::nonlin = Developer`LinearExpressionToSparseMatrix::nonlin = "The expression `1` is not linear in the variables `2`."
Developer`LinearExpressionToMatrix::lexp = Developer`LinearExpressionToSparseMatrix::lexp = "The first argument `1` is not a list of expressions or a list of equations."
LinkConnect::linkc = "Unable to connect to `1`."
LinkObject::linkd = "Unable to communicate with closed link `1`."
LinkObject::linkn = "Argument `1` in `2` has an invalid LinkObject number; the link may be closed."
LinkObject::linkv = LinkWrite::linkv = LinkWriteHeld::linkv = "Argument `1` in `2` is not a valid LinkObject."
LinkObject::linkw = "Unable to write data to closed link `1`."
LinkObject::linkx = "Argument `1` in `2` is not an open LinkObject."
LinkOpen::linkh = "Value of LinkHost -> `1` should be a string."
LinkOpen::linki = "MathLink could not be initialized."
LinkOpen::linkm = "Value of LinkMode -> `1` should be Launch, ParentConnect, Listen, or Connect."
LinkOpen::linknm = "Either a link name or a value for LinkMode must be given."
LinkOpen::linkpl = "Value of option LinkProtocol -> `1` should be `2` or Automatic."
LinkOpen::links = "Too many open links."
LinkOpen::linke = "`1`."
LinkRead::linkep = "An unexpected end of packet was received."
LinkSelect::linknl = "`1` unexpectedly is not a LinkObject."
LinkSelect::linksle = "Could not select a LinkObject in `1`."
LinkSelect::linkzl = "Argument `1` in `2` does not contain a LinkObject."
LinkWriteHeld::linkhl = "Argument `1` in `2` is not a held expression."
ListConvolve::kldims = ListCorrelate::kldims = "The kernel `1` and list `2` are not both nonempty lists with the same tensor rank."
ListConvolve::nlen = ListCorrelate::nlen = "The end conditions cannot be satisfied. A zero length list will be returned."
ListConvolve::depth = ListCorrelate::depth = "The dimension `1` of the overhang parameters exceeds the rectangular rank of the kernel, `2`."
ListInterpolation::ingrdm = "The dimension of the data to be interpolated in the first argument is inconsistent with the dimension of the grid in the second argument."
ListPlay::lsamps = "The first argument to ListPlay must be a list of samples or a list of lists of samples."
ListPlay::silent = "Sound in channel `1` is silent."
General::lpn = "`1` is not a list of numbers or pairs of numbers."
LogicalExpand::elist = MainSolve::elist = Roots::elist = ToRules::elist = Solve::elist = Reduce::elist = System`Private`OldReduce::elist = Eliminate::elist = SolveAlways::elist = AlgebraicRules::elist = GroebnerBasis::elist = PolynomialReduce::elist = "List encountered during logical expansion of `1`."
LogicalExpand::eqf = MainSolve::eqf = Roots::eqf = ToRules::eqf = Solve::eqf = Reduce::eqf = System`Private`OldReduce::eqf = Eliminate::eqf = SolveAlways::eqf = AlgebraicRules::eqf = GroebnerBasis::eqf = PolynomialReduce::eqf = GroebnerBasis`DistributedTermsList::eqf = "`1` is not a well-formed equation."
LUBackSubstitution::bpvt = "The pivot vector `1` is invalid."
LUBackSubstitution::singlu = "The LU decomposition matrix `1` is singular."
LUDecomposition::sq = "LUDecomposition accepts only square matrices."
MainSolve::ibool = Solve::ibool = Reduce::ibool = System`Private`OldReduce::ibool = AlgebraicRules::ibool = Eliminate::ibool = SolveAlways::ibool = "Value of option InverseFunctions -> `1` should be True, False, or Automatic."
MainSolve::method = Solve::method = Reduce::method = System`Private`OldReduce::method = AlgebraicRules::method = Eliminate::method = SolveAlways::method = "Value of option Method -> `1` should be 1, 2, or 3."
MainSolve::mode = Solve::mode = Reduce::mode = System`Private`OldReduce::mode = AlgebraicRules::mode = Eliminate::mode = SolveAlways::mode = "Value of option Mode -> `1` should be Generic, Modular, or Rational."
MainSolve::verif = Solve::verif = Reduce::verif = System`Private`OldReduce::verif = AlgebraicRules::verif = Eliminate::verif = "Potential solution `1` (possibly discarded by verifier) should be checked by hand. May require use of limits."
Manipulate::nobks = "There must be at least `1` bookmarks set to perform that action."
Manipulate::novars = "This Manipulate has no local variables. That action requires a Manipulate with local variables."
Manipulate::vsform = "Manipulate argument `1` does not have the correct form for a variable specification."
Manipulate::vstype = "ControlType -> `2` is not supported for the variable specification `3`. ControlType -> `1` will be used instead."
Manipulate`AnimationData::nobks = "There are not enough bookmarks present to use the `1` method. The `2` method will be used instead."
Manipulate`AnimationData::noanim = "The expression `1` cannot be animated."
MapThread::mptc = "Incompatible dimensions of objects at positions {2, `1`} and {2, `2`} of `3`; dimensions are `4` and `5`."
MapThread::mptd = "Object `1` at position {2, `2`} in `3` has only `4` of required `5` dimensions."
MathieuCharacteristicA::nnord = MathieuCharacteristicB::nnord = "The order `1` is not non-negative."
MathieuCharacteristicB::zord = "There is no zero-order MathieuCharacteristicB."
MathMLForm::boxfmt = "The default typesetting format used by MathMLForm is set in Internal`1`$DefaultMathMLBoxFormat. The current value `2` is not valid; it must be a member of $BoxForms. MathMLForm will resort to TraditionalForm."
MatrixPower::zvec = MatrixExp::zvec = "Cannot compute `1` because the argument matrix `2` has a zero eigenvector."
MatrixExp::novec = "The method `1` requires the specification of a vector."
MatrixExp::invmtd = "Invalid method `1` for input with precision `2`."
MatrixExp::spar = "The option value Parameter -> `1` is not a scalar parameter."
MatrixExp::rpar = "The option value Parameter -> `1` is not a real parameter."
MatrixExp::ktol = "Unable to satisfy Tolerance -> `1` for parameter value `2`."
Algebra`MatrixPowerMod::arg1 = "The first argument `1` of MatrixPowerMod is not a square matrix with integer coefficients."
Algebra`MatrixPowerMod::arg2 = "The second argument `1` of MatrixPowerMod is not an integer."
Algebra`MatrixPowerMod::arg3 = "The third argument `1` of MatrixPowerMod is not a nonzero integer."
Experimental`Maximize::deprec = "Experimental`Maximize will not be supported in future versions of Mathematica. Use System`Maximize instead."
Maximize::consc = Minimize::consc = Experimental`Infimum::consc = Experimental`Supremum::consc = "The constraint `1` contains a nonreal constant `2`."
Maximize::consf = Minimize::consf = Experimental`Infimum::consf = Experimental`Supremum::consf = "Invalid constraint `1` encountered. Constraints should be equations, inequalities, or variable domain specifications."
Maximize::consv = Minimize::consv = Experimental`Infimum::consv = Experimental`Supremum::consv = "The constraint `1` contains a nonconstant expression `2` independent of variables `3`."
Maximize::mixdom = Minimize::mixdom = Experimental`Infimum::mixdom = Experimental`Supremum::mixdom = "Exact optimization with mixed real and integer variables is not yet implemented."
Maximize::noobj = Minimize::noobj = Experimental`Infimum::noobj = Experimental`Supremum::noobj = "No objective function specified."
Maximize::nopmet = Minimize::nopmet = Experimental`Infimum::nopmet = Experimental`Supremum::nopmet = "This optimization problem cannot be solved with methods available to `1`."
Maximize::natt = "The maximum is not attained at any point satisfying the given constraints. "
Maximize::infeas = Minimize::infeas = Experimental`Infimum::infeas = Experimental`Supremum::infeas = "There are no values of `1` for which the constraints `2` are satisfied and the objective function `3` is real-valued. "
Maximize::objc = Minimize::objc = Experimental`Infimum::objc = Experimental`Supremum::objc = "The objective function `1` contains a nonreal constant `2`."
Maximize::objv = Minimize::objv = Experimental`Infimum::objv = Experimental`Supremum::objv = "The objective function `1` contains a nonconstant expression `2` independent of variables `3`."
Maximize::vdom = Minimize::vdom = Experimental`Infimum::vdom = Experimental`Supremum::vdom = "Variable domain `1` should be either Reals or Integers."
Maximize::vlist = Minimize::vlist = Experimental`Infimum::vlist = Experimental`Supremum::vlist = FindInstance::vlist = "The variable list `1` should be nonempty."
Maximize::wksol = "Warning: There is no maximum in the region described by the constraints; returning a result on the boundary."
General::hdiv = "`1` does not exist. Arguments are not consistent."
MeijerG::rarg = "MeijerG is used with an abstract optional parameter. `1` is not defined for every complex value of its optional parameter."
MemoryInUse::memnf = "MemoryInUse of `1` is not supported." 
MeshStyle::mesh = "`1` is not a valid MeshStyle specification. Using the default."
Message::msgl = "$MessageList `1` not a list; reset to {}."
Message::name = "Message name `1` is not of the form symbol::name or symbol::name::language."
MessageName::messg = "`1` cannot be set to `2`. It must be set to a string."
Experimental`Minimize::deprec = "Experimental`Minimize will not be supported in future versions of Mathematica. Use System`Minimize instead."
Minimize::wksol = "Warning: There is no minimum in the region described by the constraints; returning a result on the boundary."
Minimize::natt = "The minimum is not attained at any point satisfying the given constraints."
N::arg = "Argument `1` is not of the form {precision, accuracy}."
NDSolve::acoeffs = "Unable to automatically determine the coefficients of the method `1`. Try specifying the coefficients as an option."
NDSolve::sprkdm = "The dimension `1` of the differential system in the method `2` is not even."
NDSolve::sprkqv = "The value of PositionsVariables -> `1` of the method `2` is not a valid list of position variables."
NDSolve::sprkpqv = "The position variables `1` and momentum variables `2` of the method `3` are not consistent with the variables `4` of the differential system."
NDSolve::spltdep = "The differential system `1` in the method `2` depends on `3`, which is ambiguous. The differential system should be in autonomous form."
NDSolve::spltdim = "The dimensions `1` of the equations in the method `2` are not compatible with the dimensions `3` of the differential system."
NDSolve::mdatav = "The `1` method data object encountered at the point `2` == `3` was generated by a previous version of NDSolve.  The method will be reinitialized."
NDSolve::msols = "Multiple solutions found using DSolve in the method `1`."
NDSolve::ndsol = "No solution found using DSolve in the method `1`."
NDSolve::ndsnf = "Unable to create a NumericalFunction for the expression `1` in the method `2`."
NDSolve::ndspe = "Unable to process the equations `1` in the method `2`."
NDSolve::nlst = "`1` in the method `2` is not a list of length `3`."
NDSolve::nfun = "`1` of the method `2` is not a function."
NDSolve::sfun = "Invalid simplification function `1` in the method `2`."
NDSolve::csymb = "Value of `1` -> `2` of the method `3` is not a symbol."
NDSolve::bcart = "Warning: An insufficient number of boundary conditions have been specified for the direction of independent variable `1`. Artificial boundary effects may be present in the solution."
NDSolve::bcedge = "Boundary condition `1` is not specified on a single edge of the boundary of the computational domain."
NDSolve::bcnan = "Boundary conditions not numerical."
NDSolve::bcnorm = "Boundary condition `1` includes non-normal derivatives."
NDSolve::bdord = "Boundary condition `1` should have derivatives of order lower than the differential order of the partial differential equation."
NDSolve::bcsol = "Could not solve for equations at boundary points from the boundary conditions."
NDSolve::bcuns = "Boundary condition `1` cannot be satisfied in general."
NDSolve::bddo = "Value of option DifferenceOrder -> `1` should be a positive integer or \"Pseudospectral\"."
NDSolve::bdmtd = "The value of the option Method -> `1` is not a known built-in method, a symbol that could be a user-defined method, or a list with a name followed by method options."
NDSolve::nostep = " The method specified by Method -> `1` is not a known built-in method and has not been properly set up as a user-defined method with a Step function."
NDSolve::baddo = "The method `1` returned `2` for dense output data, which is not in the correct form."
NDSolve::bdstep = "The Step function for Method -> `1` returned `2`, which is not an acceptable form."
NDSolve::berr = "There are significant errors `1` in the boundary value residuals.  Returning the best solution found."
NDSolve::bvlin = "The differential equation(s) and/or boundary conditions are not linear in the dependent variables. Method -> Chasing requires linearity to compute the solution of a multipoint boundary value problem."
NDSolve::bvluc = "The equations derived from the boundary conditions are numerically ill-conditioned. The boundary conditions may not be sufficient to uniquely define a solution. The computed solution may match the boundary conditions poorly."
NDSolve::bvls = "Unable to resolve the conditions derived from the given boundary conditions. It is possible there is no solution for the given boundary value problem."
NDSolve::bvlind = "Boundary conditions are not linearly independent."
NDSolve::bvaux = "Unable to solve auxiliary system for boundary condition at `1` == `2`"
NDSolve::bvep = "Value of option `1` -> `2` should be a non-negative real number."
NDSolve::bvcrat = "Value of option `1` -> `2` should be a nonzero real number."
NDSolve::bvdae = "Differential-algebraic equations must be given as initial value problems."
NDSolve::cprec = "The precision `1` of the coefficients of the method `2` is not consistent with the working precision `3`."
NDSolve::cconst = "The coefficients `1` of `2` do not give a consistent method."
NDSolve::cdims = "The dimensions of the options `1`, `2` and `3` of the method `4` are not compatible."
NDSolve::cstruct = "The coefficients `1` of `2` do not have the correct structure."
NDSolve::nosubmtd = "The method `1` requires that a submethod be specified using the Method option."
NDSolve::nosubmtds = "The method `1` requires that submethods be specified using the Method option."
NDSolve::submtd = "`1` is not a valid submethod."
NDSolve::submtds = "`1` is not a valid list of submethods of the method `2`."
DSolve::conarg = NDSolve::conarg = RSolve::conarg = "The arguments should be ordered consistently."
DSolve::dvnoarg = NDSolve::dvnoarg = RSolve::dvnoarg = "The function `1` appears with no arguments."
DSolve::ivhead = NDSolve::ivhead = RSolve::ivhead = "The independent variable `1` appears in the head of the expression `2`. The independent variables should always be arguments."
DSolve::dvleaf = NDSolve::dvleaf = RSolve::dvleaf = "The function `1` appears as the head of the expression `2`."
DSolve::der1 = NDSolve::der1 = "The derivative operator `1` in `2` should operate on only one function."
DSolve::derlen = NDSolve::derlen = "The length of the derivative operator `1` in `2` is not the same as the number of arguments."
DSolve::derarg = NDSolve::derarg = "The derivative operator `1` in `2` should act on the pure function."
DSolve::nestdv = NDSolve::nestdv = RSolve::nestdv = "The expression `1` has nested dependent variables."
DSolve::dvlen = NDSolve::dvlen = RSolve::dvlen = "The function `1` does not have the same number of arguments as independent variables (`2`)."
NDSolve::depvr = "The dependent variable cannot be found in the equation."
NDSolve::nodv = "No dependent variables were found in the equations.  Make sure that your functions appear with the independent variables in the arguments, as in x[t].  You may want to specify them explicitly using the DependentVariables option."
NDSolve::noout = "No functions were specified for output from NDSolve."
NDSolve::dvout = "The output function `1` is not one of the dependent variables `2`."
NDSolve::uniss = "The spacing specified by MinStepSize -> `1` and MaxStepSize -> `2` for independent variable `3` cannot be used to construct a uniform grid on an interval of length `4`.  Using spacing `5` instead."
NDSolve::eerr = "Warning: Scaled local spatial error estimate of `1` at `2` = `3` in the direction of independent variable `4` is much greater than prescribed error tolerance. Grid spacing with `5` points may be too large to achieve the desired accuracy or precision.  A singularity may have formed or you may want to specify a smaller grid spacing using the MaxStepSize or MinPoints method options."
NDSolve::eerri = "Warning: Estimated initial error on the specified spatial grid in the direction of independent variable `1` exceeds prescribed error tolerance."
NDSolve::ibcinc = "Warning: Boundary and initial conditions are inconsistent."
NDSolve`StateData::vdobj = NDSolve::vdobj = "Encountered `1`, which is not a valid `2` expression."
NDSolve::ininv = "Unable to ascertain the initial data for the invariants in the method `1`."
NDSolve::intor = "Value of InterpolationOrder -> `1` should be Automatic, All, or a positive integer."
NDSolve::ivone = "Boundary values may only be specified for one independent variable. Initial values may only be specified at one value of the other independent variable."
NDSolve::maxit = "Maximum number of iterations `1` reached at `2` = `3`."
NDSolve::mmpts = "Number of steps for independent variable `1` required by MaxStepSize -> `2` or MinPoints -> `3` is greater than the number of steps allowed by MinStepSize -> `4` and/or MaxPoints -> `5`."
NDSolve::dored = "The maximum number of spatial points (`1`) for independent variable `2` allowed by MaxPoints -> `3` or MinStepSize -> `4` is too few for DifferenceOrder -> `5`.  Spatial difference order for `2` will be reduced to `6`."
NDSolve::nerres = "The maximum number of spatial points (`1`) for independent variable `2` allowed by MaxPoints -> `3` or MinStepSize -> `4` is too few to compute a spatial error estimate."
NDSolve::eveerr = "The specified spatial grid in the direction of independent variable `1` has an even number of points (`2`) and the pseudospectral grid cannot be subdivided in two, so no spatial error estimate will be done on the final result in this direction."
NDSolve::stpmin = "The starting number of points determined by StartingStepSize -> `3` and StartingPoints -> `4` is `1`, which is less than the minimum number of `2` grid points. `2` will be used instead."
NDSolve::stpmax = "The starting number of points determined by StartingStepSize -> `3` and StartingPoints -> `4` is `1`, which is greater than the maximum number of `2` grid points. `2` will be used instead."
NDSolve::stps = "Only one of StartingPoints and StartingStepSize should be specified at a time.  StartingPoints -> `1` will be used and StartingStepSize -> `2` will be disregarded."
NDSolve::maxits = "The number of iterations `1` in the method `2` is not Automatic, a positive machine integer or Infinity."
NDSolve::bool = "The value of the option `1` -> `2` in the method `3` is not True or False."
NDSolve::pmi = "The value of the option `1` -> `2` in the method `3` is not a positive machine integer or Infinity."
General::moptxn = "The option `1` of the method `2` is not one of `3`."
NDSolve::mrsti = "Number of steps `1` required by `2` -> `3` should be a machine-sized integer."
NDSolve::msti = "Number of steps `1` required by MaxStepSize -> `2` for independent variable `3` should be a machine-sized integer."
NDSolve::mxsst = "Using maximum number of grid points `1` allowed by the MaxPoints or MinStepSize options for independent variable `2`."
NDSolve::mxst = "Maximum number of `1` steps reached at the point `2` == `3`."
NDSolve::ncsm = "The number of coefficients `1` is not the same as the number of submethods `2` in the method `3`."
NDSolve::ndcf = "Repeated convergence test failure at `1` == `2`; unable to continue."
NDSolve::lsf = "Unable to solve required system of linear equations to `1` == `2`."
NDSolve::nderr = "Error test failure at `1` == `2`; unable to continue."
NDSolve::ndinnt = "Initial condition `1` is not a number or a rectangular array of numbers."
NDSolve::ndincd = NDSolve`Reinitialize::ndincd = "Initial conditions for derivatives of the function `1` do not have consistent dimensions."
NDSolve::ndincb = "Initial conditions are not of consistent dimensionality."
NDSolve::ndinpd = "The initial conditions did not evaluate to an array of numbers of depth `1` on the spatial grid.  Initial conditions for partial differential equations should be specified as scalar functions of the spatial variables."
NDSolve::opdims = "The value of `1` -> `2` of the method `3` is not a pair of positive integers {n, m} with n >= m and n*m equal to `4`."
NDSolve::opmdims = "The dimensions `1` of the matrix function in the method `2` are not compatible with the specified dimensions `4`."
NDSolve`Reinitialize::ndincb = "The new initial conditions need to have the same dimensions as the original ones."
NDSolve::ndlim = "Range specification `1` is not of the form {x, xend} or {x, xmin, xmax}."
NDSolve::ndlims = "Range specification for spatial variable `1` needs to have two endpoints."
NDSolve::ndmss = "Value of option `1` -> `2` is not a positive real number or Infinity."
NDSolve::ndnco = NDSolve`Reinitialize::ndnco = "The number of constraints (`1`) (initial conditions) is not equal to the total differential order of the system (`2`)."
NDSolve::ndncov = NDSolve`Reinitialize::ndncov = "The number of constraints (initial conditions) for function `1` is insufficient for its differential order (`2`)."
NDSolve::ndnl = "Endpoint `1` in `2` is not a real number."
NDSolve::ndnum = "Encountered non-numerical value for a derivative at `1` == `2`."
NDSolve::ndfdmc = "Computed derivatives do not have dimensionality consistent with the initial conditions."
NDSolve::ndode = "Input is not an ordinary differential equation."
NDSolve::ndrsd = "Step size was not decreased after a rejected step at `1` == `2`."
NDSolve::ndsnorm = "Value of option NormFunction -> `1` is not Automatic or a function that gives a legitimate norm."
NDSolve::ndsnr = "Step size was not real at `1` == `2`."
NDSolve::ndssc = "Step size changed sign at `1` == `2`."
NDSolve::ndsss = "Value of StartingStepSize -> `1` is not a positive real number or Automatic."
NDSolve::ndstab = "Stability check failed at `1` == `2`."
NDSolve::sprcf = "Spectral radius estimate failed to converge at `1` == `2`."
NDSolve::ndstf = "At `1` == `2`, system appears to be stiff. Methods Automatic, BDF or StiffnessSwitching may be more appropriate."
NDSolve::ndsv = NDSolve`Reinitialize::ndsv = "Cannot find starting value for the variable `1`."
NDSolve::ndsz = "At `1` == `2`, step size is effectively zero; singularity or stiff system suspected."
NDSolve::ndtol = "Tolerances requested by the AccuracyGoal and PrecisionGoal options could not be achieved at `1` == `2`."
NDSolve::ndtola = "A component of the solution at `1` == `2` is essentially zero and the tolerance specified by the AccuracyGoal option could not be achieved."
NDSolve`ProcessSolutions::nodata = "No solution data was computed between `1` == `2` and `1` == `3`."
NDSolve::ivcon = NDSolve`Reinitialize::ivcon = "The given initial conditions were not consistent with the differential-algebraic equations.  NDSolve will attempt to correct the values."
NDSolve::ivdae = "For differential-algebraic equations, initial conditions need to be given for either all the non-algebraic variables or their derivatives."
NDSolve::ivres = "NDSolve has computed initial values that give a zero residual for the differential-algebraic system, but some components are different from those specified.  If you need those to be satisfied, it is recommended that you give initial conditions for all dependent variables and derivatives of them."
NDSolve::ntdv = "Cannot solve to find an explicit formula for the derivatives.  Consider using the option setting SolveDelayed -> True."
NDSolve::ntcs = "Cannot solve constraint equations for initial conditions."
NDSolve::icord = NDSolve`Reinitialize::icord = "The differential order of the functions in the initial or boundary conditions should be strictly less than in the differential equations."
NDSolve::icorddae = NDSolve`Reinitialize::icorddae = "For a system treated as a differential-algebraic equation, the differential order of the functions in the initial conditions should be equal or less than in the equations."
NDSolve::mdata = "An invalid `1` method data object was encountered at the point `2` == `3`."
NDSolve::pdeopt = "If the option `1` to NDSolve is a list, it must have length 2."
NDSolve::pdnbc = "Mixed periodic and Dirichlet/Neumann boundary conditions are not allowed."
NDSolve::tponly = "Currently the only discretization method implemented is SpatialDiscretization -> TensorProductGrid."
NDSolve::norm = "Invalid norm `1` in the method `2`."
NDSolve::rclist = "The value of the option `1` -> `2` should be Automatic or a list of the coordinate lists for each spatial dimension."
NDSolve::coend = "The endpoints of the grid coordinates `1` do not match those specified in `2`."
NDSolve::coexp = "Because the coordinates were explicitly given for the direction of independent variable `1`, the values of options `2` will be disregarded for this direction."
NDSolve::ssrei = "The value of the option `1` -> `2` should be a positive real number, Infinity, or Automatic."
NDSolve::ssre = "The value of the option `1` -> `2` should be a positive real number or Automatic."
NDSolve::sfty = "The value of the option `1` -> `2` of the method `3` is not a real number x such that 0 < x <= 1."
NDSolve::ndsstm = "`1` is not a `2` method in the method `3`."
NDSolve::ndsml = "The value of `1` -> `2` should be a list of `3` methods in the method `4`."
NDSolve::mtdp = "`1` does not have a correctly defined property `2` in `3`."
Needs::nocont = "Context `1` was not created when Needs was evaluated."
NDSolve::aord = "The selection of the order for the method `1` failed."
NDSolve::sss = "Unable to determine a starting step size for the method `1`."
NDSolve::mconly = "For the method `1`, only machine real code is available. Unable to continue with complex values or beyond floating-point exceptions."
NDSolve::nolib = "The library for the method `1` is missing so NDSolve is unable to compute the solution."
NDSolve::nodae = "The method `1` is not currently implemented to solve differential-algebraic equations.  Use Method -> Automatic instead."
NDSolve::nodde = "The method `1` is not currently implemented to solve delay differential equations.  Use Method -> Automatic instead."
NDSolve::noddem = "There is no NDSolve method currently implemented for delay-differential equations."
NDSolve::nomm = "The method `1` is not currently implemented to solve systems with a non-identity mass matrix.  Use Method -> Automatic instead."
NDSolve::nllhs = "A mass matrix cannot be determined because the left-hand sides of the equations are not linear.  You can use SolveDelayed -> True to solve the equations as a system of differential-algebraic equations."
NDSolve::ndmmc = "The mass matrix `1` is not constant.  You can use SolveDelayed -> True to solve the equations as a system of differential-algebraic equations."
NDSolve::ndsd = "The value of the option SolveDelayed -> `1` should be Automatic, True, False, or \"MassMatrix\"."
NDSolve::icfail = "Unable to find initial conditions that satisfy the residual function within specified tolerances.  Try giving initial conditions for both values and derivatives of the functions."
FindMinimum::initf = FindMaximum::initf = FindFit::initf = NDSolve::initf = FindRoot::initf = "The initialization of the method `1` failed."
NDSolve::lsopt = "The option `1` -> `2` should either be a single value or a list of length equal to the number of spatial independent variables, `3`."
NDSolve::molpde = "The option Method -> MethodOfLines is only legitimate for partial differential equations with more than one independent variable."
NDSolve::chbvp = "The option Method -> Chasing is only legitimate for boundary value problems with values specified at two or more distinct points."
NDSolve::jpde = "For PDEs, the Jacobian will be computed using finite differences unless you have chosen the MethodOfLines option ExpandEquationsSymbolically -> True."
NDSolve::tvar = "Value of option `1` -> `2` is not one of the independent variables `3`."
NDSolve::tvic = "`1` cannot be used as the temporal independent variable because the conditions `2` for that dimension do not constitute sufficient initial conditions given at only one value of `1`."
NDSolve::ponly = "The method given in Method -> `1` is only for equation processing and is not a time-stepping method."
NDSolve::mdo = "The value of \"MaxDifferenceOrder\" -> `1` should be an integer from `2` through `3` for the method `4`."
NDSolve::eord = "The value of the option `1` -> `2` should give a positive machine integer greater than 1 for the method `3`."
NDSolve::mord = "Unable to ascertain the order of the method `1`."
NDSolve::imps = "The value of the option ImplicitSolver -> `1` should be FixedPoint or Newton."
NDSolve::impsg = "The value of the option ImplicitSolver -> `1` should be FixedPoint, Newton, or GMRES."
NDSolve::impsgm = "ImplicitSolver -> GMRES may only be used with the BDF methods with VariableStepCoefficients -> True."
NDSolve::impsitsf = "Unable to satisfy the ImplicitSolver tolerance for IterationSafetyFactor at `1` = `2`."
NDSolve::impsagpg = "Unable to satisfy the ImplicitSolver tolerances for AccuracyGoal and PrecisionGoal at `1` = `2`."
NDSolve::bw = "The value of the option `1` -> `2` should be a positive integer or a list of two positive integers giving upper and lower bandwidths."
NDSolve::otype = "The value of the option `1` -> `2` should be ModifiedGramSchmidt or ClassicalGramSchmidt."
NDSolve::scpar = "The value of the option `1` -> `2` of the method `3` should be Automatic or a pair of real numbers 0 <= {a, b} <= 1."
NDSolve::subsp = "The value of `1` -> `2` should be a positive integer or Automatic."
NDSolve::ssrb = "The value of the option `1` -> `2` of the method `3` should be a pair of real numbers {0, 1} <= {a, b} <= {1, Infinity}."
NDSolve::sprest = "The value of `1` -> `2` of the method `3` should be Automatic or a positive real number."
NDSolve::maxstg = "The value of `1` -> `2` of the method `3` should be a positive machine integer s such that s >= `4`."
NDSolve::rbnd = "The value of the `1` -> `2` of the method `3` should be a real number x such that `4` <= x <= `5`."
NDSolve::irkcargs = "The argument `1` in ImplicitRungeKuttaCoefficients is not `2`."
NDSolve::irkcopts = "The option `1` in ImplicitRungeKuttaCoefficients is not `2`."
NDSolve::irkcploss = "Only obtained precision `1` of requested precision `2`. Try increasing $MaxExtraPrecision."
NDSolve`Iterate::sivpd = "The first argument `1` to `2` should be a symbol assigned to a value that is a valid `3` object."
NDSolve::evnone = "No events were specified for the EventLocator method."
NDSolve::evnf = "The event number `1` was not found between `2` = `3` and `2` = `4`."
NDSolve::evdir = "The value of the option Direction -> `1` for the EventLocator method should be All, 1, or -1, or a list consisting of these values with length equal to the number of events (`2`)."
NDSolve::evact = "The value of the option `1` for the EventLocator method is a list with length different from the number of events (`2`) so it will be treated as a single action to take for all specified events."
NDSolve::evre = "The value of the event function at `1` = `2` was not a real number.  The event will be ignored in steps where it does not evaluate to real numbers at both ends."
NDSolve::evboo = "The value of the event function at `1` = `2` was not True or False.  When not True, the value will be considered as False."
NDSolve::evfrf = "The event function did not evaluate to a real number somewhere between `1` = `2` and `1` = `3`, preventing FindRoot from finding the root accurately."
NDSolve::evcvmit = "Event location failed to converge to the requested accuracy or precision within `4` iterations between `1` = `2` and `1` = `3`."
NDSolve::evlm = "The value of EventLocationMethod -> `1` is not Automatic, Brent, LinearInterpolation, StepBegin, or StepEnd."
NDSolve::evsa = "The value of SolutionApproximation -> `1` is not Automatic, CubicHermiteInterpolation, DenseOutput, or InvokeMethod."
NDSolve::exseq = "The value of `1` -> `2` for the method `3` should be either Automatic, a strictly increasing list of at least `4` positive machine integers, or a function that generates such a list."
NDSolve::exmaxo = "The value of `1` -> `2` for the method `3` should be Automatic, Infinity, or an integer greater than or equal to `4`."
NDSolve::exmino = "The value of `1` -> `2` for the method `3` should be Automatic or an integer greater than or equal to `4`."
NDSolve::exsord = "The value of `1` -> `2` of the method `3` should be a positive integer strictly between `4` and `5`."
NDSolve::exordf = NDSolve::sssf = "The value of `1` -> `2` for the method `3` should be a list of `4` real numbers between 0 and 1."
NDSolve`FiniteDifferenceDerivative::deriv = "`1` should be a Derivative operator with non-negative integer order(s)."
NDSolve`FiniteDifferenceDerivative::ldim = "`1` should be a list with an element for each of the `2` dimensions."
NDSolve`FiniteDifferenceDerivative::grid = "The grid `1` given for dimension `2` is not an increasing list of distinct real coordinates."
NDSolve`FiniteDifferenceDerivative::aord = "The approximation order `1` given for dimension `2` should be a positive machine-sized integer or `3`."
NDSolve`FiniteDifferenceDerivative::per = "The specification of periodicity `1` given for dimension `2` should be either True or False."
NDSolve`FiniteDifferenceDerivative::spu = "The coordinates `1` for dimension `2` are not uniformly spaced. Periodic pseudospectral derivatives are computed on a uniform grid."
NDSolve`FiniteDifferenceDerivative::spc = "The coordinates `1` for dimension `2` do not have spacing proportional to the Chebyshev points -Cos[Range[0,`3`] Pi/`3`]. Nonperiodic pseudospectral derivatives are only computed for this spacing."
NDSolve`FiniteDifferenceDerivative::conw = "There are insufficient points in dimension `1` to generate consistent finite different weights."
NDSolve`FiniteDifferenceDerivative::ordred = "There are insufficient points in dimension `1` to achieve the requested approximation order. Order will be reduced to `2`."
NDSolve`FiniteDifferenceDerivativeFunction::ddim = "Data `1` is not a rectangular tensor with dimensions `2`."
NDSolve`FiniteDifferenceDerivativeFunction::spnum = "Data `1` is exact or symbolic. Spectral weight computation requires data with approximate numbers."
NDSolve`ImplicitRungeKutta::cmsing = "Singular coefficient matrix encountered for `1`, which is not suitable for stiff systems."
Nearest::near1 = "`1` is neither a list of real points, nor a valid list of rules."
Nearest::near3 = "`1` is neither a non-negative integer nor a list of the form {n, r} with n a positive integer and r a non-negative real number."
Nearest::nearuf = "The user-supplied distance function `1` does not give a real numeric distance when applied to the point pair `2` and `3`."
Nearest::neard = "The default distance function does not give a real numeric distance when applied to the point pair `1` and `2`."
Nearest::dmtch = "The dimension of `1` and `2` does not match."
NestWhile::nwargs = NestWhileList::nwargs = "Argument `1` in `2` is not of the form n, {m, n}, {n, Infinity}, or All, where m and n are non-negative machine-size integers."
NestWhile::nres = NestWhileList::nres = "Insufficient results generated to return the `1` term in `2`."
NIntegrate::bdith = "The values of the option BisectionDithering should be reals between -1/4 and 1/4."
NIntegrate::bdmcr = "The Method option of `1` can take only specifications of MonteCarloRule." 
NIntegrate::bdmtd = "The Method option should be one of Automatic, CartesianRule, ClenshawCurtisRule, GaussBerntsenEspelidRule, GaussKronrodRule, LobattoKronrodRule, LobattoPeanoRule, MultiPanelRule, NewtonCotesRule, TrapezoidalRule, AdaptiveMonteCarlo, AdaptiveQuasiMonteCarlo, DoubleExponential, DuffyCoordinates, ExtrapolatingOscillatory, MonteCarlo, QuasiMonteCarlo, Trapezoidal, EvenOddSubdivision, SymbolicPiecewiseSubdivision, OscillatorySelection, UnitCubeRescaling, or a user-implemented integration strategy or rule."
NIntegrate::cartdim = "The number of specified one-dimensional rules is larger than the dimension of the integral."
NIntegrate::comp = "For Method -> Oscillatory, the integrand can only contain one term of the general form: f[x] w[x], where w is one of the following functions: Sin, Cos, BesselJ, or BesselY. Try using Expand on your function and apply NIntegrate[..., Method -> Oscillatory] to each part."
NIntegrate::crnzo = "DuffyCoordinates should have its corners specified by lists containing zeros and ones. Each corner specification should match the dimension of the integral."
NIntegrate::deodiv = "DoubleExponentialOscillatory returns a finite integral estimate, but the integral might be divergent."
NIntegrate::deoncon = "DoubleExponentialOscillatory has failed to converge for the integrand `1` over `2`. DoubleExponentialOscillatory obtained `3` and `4` for the integral and error estimates."
NIntegrate::deorel = "The relative error `1` is larger than expected for the integrand `2` over `3` with DoubleExponentialOscillatory method and tuning parameters, TuningParameters -> `4`."
NIntegrate::deorela = "The relative error `1` is larger than expected for the integrand `2` over `3` with DoubleExponentialOscillatory method and automatic tuning parameters, TuningParameters -> `4`. The integration will proceed with TuningParameters -> `5`."
NIntegrate::eincr = "The global error of the strategy GlobalAdaptive has increased more than `1` times. The global error is expected to decrease monotonically after a number of integrand evaluations. Suspect one of the following: the working precision is insufficient for the specified precision goal; the integrand is highly oscillatory or it is not a (piecewise) smooth function; or the true value of the integral is 0. Increasing the value of the GlobalAdaptive option MaxErrorIncreases might lead to a convergent numerical integration. NIntegrate obtained `2` and `3` for the integral and error estimates."
NIntegrate::eonst = "EvenOddSubdivision cannot be its own submethod."
NIntegrate::grpar = "The rule data, `1`, for GeneralRule should be a list of lists of equal length that represent the abscissas, weights, and error weights."
NIntegrate::ierr = "The argument in the oscillatory function must be of the form a + b x^n, where a and b are constants."
NIntegrate::inits = "The result `1` returned by the strategy initializing function `2` is not a strategy data object of the form StrategyIdentifier_[data___]."
NIntegrate::inovf = "Overflow resulted when attempting to evaluate the integrand at `1` = `2`."
NIntegrate::inum = "Integrand `1` is not numerical at `2` = `3`."
NIntegrate::inumr = "The integrand `1` has evaluated to non-numerical values for all sampling points in the region with boundaries `2`."
NIntegrate::inumri = "The integrand `1` has evaluated to Overflow, Indeterminate, or Infinity for all sampling points in the region with boundaries `2`."
NIntegrate::invcr = "The Cartesian rule specification `1` is invalid."
NIntegrate::lzero = "Method -> Oscillatory does not support negative, complex, or variable indices for BesselY and BesselJ."
NIntegrate::maxp = "The integral failed to converge after `1` integrand evaluations. NIntegrate obtained `2` and `3` for the integral and error estimates."
NIntegrate::minmax = "MinRecursion (`1`) is greater than MaxRecursion (`2`)."
NIntegrate::mddim = "Multidimensional methods are for integrals with more than one variable."
NIntegrate::mpdim = "MultiPeriodic is for integrals with dimension less than or equal to twelve. The integration continues with MonteCarlo."
NIntegrate::mtdfb = "Numerical integration with `1` failed. The integration continues with Method -> `2`."
NIntegrate::nconv = "This oscillatory integral might not be convergent."
NIntegrate::ncvb = "NIntegrate failed to converge to prescribed accuracy after `1` recursive bisections in `2` near `3` = `4`. NIntegrate obtained `5` and `6` for the integral and error estimates."
NIntegrate::pwncvb = "NIntegrate failed to converge to prescribed accuracy after `1` recursive bisections."
NIntegrate::ncvi = "NIntegrate failed to converge to prescribed accuracy after `1` iterated refinements in `2` in the region `3`. NIntegrate obtained `4` and `5` for the integral and error estimates."
NIntegrate::pwncvi = "NIntegrate failed to converge to prescribed accuracy after `1` iterated refinements."
NIntegrate::ncvs = "NIntegrate failed to converge near the apparently non-integrable singularity at `1` = `2`."
NIntegrate::nexcl = "Incorrect Exclusions specification `1`."
NIntegrate::nfunc = "Numerical function object is expected at position `2` in `1`."
NIntegrate::ninf = "Invalid use of Infinity in integration limits `1`."
NIntegrate::nintp = "Encountered the non-number `1` at `2` = `3`."
NIntegrate::nlim = "`1` = `2` is not a valid limit of integration."
NIntegrate::noeval = "For oscillating integrals, individual points where evaluation takes place is not supported; the range has to be in the form {x, xmin, xmax}."
NIntegrate::nomdr = "Method `1` cannot use multidimensional integration rules."
NIntegrate::noprec = "There are not enough numbers in the working precision to calculate the internal points in the region `1`."
NIntegrate::nosp = "The SymbolicPreprocessing specification `1` will be ignored since the Method option has symbolic preprocessing specifications."
NIntegrate::nsr = "`1` is not a valid specification of an integration strategy or rule."
NIntegrate::oidiv = "The odd integrand `1` is being considered as zero over the specified region, but may actually be divergent."
NIntegrate::oscfm = "With Method -> `1`, the integrand should be a product of an oscillatory function w[x] and another function f[x], like NIntegrate[ w[x] f[x],{x, a, Infinity}, Method -> Oscillatory]. The function w should be Sin, Cos, BesselJ, or BesselY, and f[x] should be of the form a + b x^n for constant a and b."
NIntegrate::oscint = "This integral does not contain any of the oscillating functions Cos, Sin, BesselJ, or BesselY. Use some other method of NIntegrate instead."
NIntegrate::osran = "Oscillatory methods work only for one-dimensional integrals. The integration continues with Method -> `1`."
NIntegrate::oscir = "Method `1` works only for one-dimensional integrals with infinite ranges."
NIntegrate::osrn = "For oscillating integrals, the range has to contain one Infinity (or -Infinity) and be of nonzero length. The integration continues with the Gauss-Kronrod method."
NIntegrate::ploss = "Numerical integration stopping due to loss of precision. It achieved neither the requested PrecisionGoal nor AccuracyGoal. One of the following is suspected: highly oscillatory integrand or the true value of the integral is 0. If your integrand is oscillatory on an infinite (or semi-infinite) interval, try using the option Method -> Oscillatory in NIntegrate."
NIntegrate::pvexeq = "PrincipalValue cannot work with the specified exclusions." 
NIntegrate::pvrng = "Singular points must be specified in the integration range in order to use PrincipalValue." 
NIntegrate::pvdim = "PrincipalValue can be used for one-dimensional integrals only." 
NIntegrate::pvspr = "The PrincipalValue option `1` takes as a value a number or list of numbers with length equal to the number of the singular points." 
NIntegrate::rnderr = "Numerical approximation has caused `1` to take the value `2` where the integrand is singular."
NIntegrate::seprec = "The extra precision for the singularity handlers should be a real number greater than the negative of the working precision, `2`, or Automatic."
NIntegrate::singd = "Singularity handling has failed at point `1` = `2` for the specified precision goal. Try using larger values for some combination of ExtraPrecision, WorkingPrecision, SingularityDepth, or MaxRecursion."
NIntegrate::slwcon = "Numerical integration converging too slowly; suspect one of the following: singularity, value of the integration is 0, highly oscillatory integrand, or WorkingPrecision too small."
NIntegrate::sngrn = "DuffyCoordinates works only with integration ranges without singularity specifications."
NIntegrate::spnst = "SymbolicPiecewiseSubdivision can be used only once in the Method option."
NIntegrate::sproc = "The value of SymbolicProcessing should be a positive machine real number or zero."
NIntegrate::tmap = "NIntegrate is unable to achieve the tolerances specified by the PrecisionGoal and AccuracyGoal options because the working precision is insufficient.  Try increasing the setting of the WorkingPrecision option."
NIntegrate::vars = "Integration range specification `1` is not of the form {x, xmin, ..., xmax}."
NIntegrate::vconv = "The value for the option VerifyConvergence can only be Automatic, False, or True."
NIntegrate::vtdrop = "The last variable transformation of region `1` was not dropped."
General::gkrpts = "The Gauss points argument at position `2` in `1` should be an integer greater than `3`."
General::lkrpts = "The Gauss points argument at position `2` in `1` should be an integer greater than `3`."
NIntegrate::mdgen = "The number of generators argument at position `2` in `1` should be one of 5, 6, 9, or Automatic."
NIntegrate`MultiDimensionalRuleData::mdgen = "The number of generators argument at position 1 in `1` should be one of 5, 6, or 9."
NIntegrate`MultiPeriodic::minp = "The value of MinPoints `1` is greater than the maximum number of points allowed `2`."
NIntegrate`SymbolicPiecewiseSubdivision::maxpwc = "The number of piecewise regions has exceeded the maximum value specified by the option MaxPiecewiseCases -> `1`. The integration will continue with no piecewise subdivision."
NMinimize::bcons = NMaximize::bcons = "The following constraints are not valid: `1`. Constraints should be equalities, inequalities, or domain specifications involving the variables." 
NMinimize::lvar = NMaximize::lvar = "Variables `1` should be a list of variables, with each element being a variable, or a list containing a variable and lower and upper bounds for the starting region for that variable." 
NMinimize::cnft = "The point `1` better satisfies the constraints, but evaluates to `2`, which is larger than the final result." 
NMaximize::cnft = "The point `1` better satisfies the constraints, but evaluates to `2`, which is smaller than the final result." 
NMinimize::parchange = NMaximize::parchange = "Inappropriate parameter: `1` -> `2`, changed to `3`." 
NMinimize::nosat = NMaximize::nosat = "Obtained solution does not satisfy the following constraints within Tolerance -> `2`: `1`." 
NMinimize::workprec = NMaximize::workprec = "Precision of the input is less than WorkingPrecision. Precision of the input will be used in computation."
NMinimize::belt = NMaximize::belt = "Invalid integer elements: `1`. Currently only variables may have a specified domain."
NMinimize::elmt = NMaximize::elmt = "Invalid variable domain. All variables must be either Integers or Reals (Reals by default.)"
NMinimize::incst = NMaximize::incst = "`1` was unable to generate any initial points satisfying the inequality constraints `2`. The initial region specified may not contain any feasible points. Changing the initial region or specifying explicit initial points may provide a better solution."
NMinimize::nsol = NMaximize::nsol = FindMinimum::nsol = FindMaximum::nsol = FindFit::nsol = "There are no points that satisfy the constraints `1`." 
NMinimize::cvdiv = NMaximize::cvdiv = "Failed to converge to a solution.  The function may be unbounded."
NMinimize::ubnd = NMaximize::ubnd = "The problem is unbounded."
NMinimize::maxit = NMaximize::maxit = "Value of option MaxIterations -> `1` should be a non-negative integer or Automatic."
NMinimize::ropn = NMaximize::ropn = "Value of option `1` -> `2` should be a non-negative real number."
NMinimize::roprl = NMaximize::roprl = "Value of option `1` -> `2` should be a real number x greater than `3`."
NMinimize::roprlu = NMaximize::roprlu = "Value of option `1` -> `2` should be a real number between `3` and `4`."
NMinimize::bdmtd = NMaximize::bdmtd = "Value of option Method -> `1` is not Automatic, \"DifferentialEvolution\", \"NelderMead\", \"RandomSearch\", or \"SimulatedAnnealing\"."
Norm::symb = "Norm has received a matrix with symbolic element(s)."
Norm::nvm = "The first Norm argument should be a number, vector or matrix."
NDSolve`ScaledVectorNorm::vinp = "The ScaledVectorNorm argument `1` at position 1 is not a list of numbers."
Norm::winp = NDSolve`ScaledVectorNorm::winp = "The weight vector argument `1` is not a nonempty list of numbers."
Norm::ptype = "The second argument of Norm, `1`, should be a symbol, Infinity, or an integer or real number not less than 1 for vector p-norms; or 1, 2, Infinity, or \"Frobenius\" for matrix norms."
Norm::vlen = NDSolve`ScaledVectorNorm::vlen = "The vector `1` and the weight vector `2` are of unequal lengths."
Norm::armsm = "The Arnoldi method cannot be used because the matrix is too small."
Norm::armmps = "The Arnoldi method cannot be used because matrix elements are not machine-precision real/complex numbers. The matrix is replaced with the corresponding dense matrix."
Norm::armmp = "The Arnoldi method cannot be used because matrix elements are not machine-precision real/complex numbers."
NDSolve::urange = NDSolve`ScaledVectorNorm::urange = "The scaling vector has a zero component, so the zero absolute tolerance leads to an unbounded value."
NDSolve`ScaledVectorNorm::pinp = "Argument `1` at position 1 in `2` should be a real number greater than or equal to 1 or a function to compute the norm of the scaled vector."
NDSolve`ScaledVectorNorm::sinp = "The scaling vector argument `1` is not a nonempty list of numbers."
NDSolve`ScaledVectorNorm::tinp = "Argument `1` should be a list of non-negative real numbers, {rtol, atol}, giving relative and absolute tolerances with at least one strictly positive."
NDSolve`ScaledVectorNorm::nvec = "No vector specified."
NDSolve::nfnan = "The value of the option NormFunction -> `1` applied to the current scaled error vector was `2`, which is not a number."
NDSolve`ScaledVectorNorm::fnnan = "The norm function applied to the scaled vector gave `1`, which is not a number."
NDSolve::nfp = "The value of the option NormFunction -> `1` applied to the current scaled error vector was `2`, which is not a non-negative real number."
NDSolve`ScaledVectorNorm::nfp = "The norm function applied to the scaled vector gave `1`, which is not a non-negative real number."
NotebookDirectory::nosv = "The notebook `1` is not saved."
NotElement::bset = "The second argument `1` of NotElement should be one of: Primes, Integers, Rationals, Algebraics, Reals, Complexes, or Booleans."
NProduct::bdmtd = "`1` is not a valid specification of a numerical product approximation algorithm."
NProduct::emcon = NSum::emcon = "Euler-Maclaurin sum failed to converge to requested error tolerance."
NProduct::istep = "Cannot get from `1` to `2` in steps of `3`."
NProduct::itfn = "`1` does not have the correct form for an iterator."
NProduct::nplim = "Limit of product `1` is not a number."
NProduct::npnum = "Multiplicand `1` is not numerical at point `2` = `3`."
NProduct::npst = "Product step size `1` is zero or not a number."
NProduct::npz = "Some factors are 1. The algorithms are not very applicable."
NProduct::wynntd = NSum::wynntd = "WynnEpsilon requires the value `1` for the option `2` and the value `3` for the option `4` to satisfy `2` >= 2 (`4` + 1) ." 
System`Private`NRoot::bdst = "Starting value `1` is not sufficiently close to the true root."
System`Private`NRoot::nnum = "Starting value `1` is not a number."
NRoots::nomod = "NRoots does not take a modulus option."
NRoots::nnumeq = "`1` is expected to be a polynomial equation in the variable `2` with numeric coefficients."
System`Private`NRRoot::bpa = "Precision `2` is too low to find real roots of `1`."
System`Private`NRRoot::bfac = "Warning: Using factorization `1` = `2` * `3`, which may not be correct. The difference is `4`."
NSolve::sfail = "Subsystem could not be solved for `1` at value `2`. The likely cause is failure to detect zero due to low precision. The likely effect is the loss of one or more solutions. Increasing WorkingPrecision might prevent some solutions from being lost."
NSolve::zerosol = "Scale of possible solution value `1` for variable `2` is too small. Must set this value to zero in order to avoid generation of spurious solutions. This may cause the loss of some solutions."
NSolve::closesols = "Some solutions in variables `1` are close together. This may cause solution components in other variables to suffer from loss of precision. Use of increased WorkingPrecision may resolve this."
NSolve::illcnd = "Possible ill-conditioning detected in system. Likely cause is exact or approximate multiplicity. This may cause solutions to suffer from loss of precision. Use of sufficiently large WorkingPrecision may resolve this."
NSolve::nsolprec = "Cannot obtain small residual. Use of sufficiently large WorkingPrecision may resolve this."
NSolve::infsolns = "Infinite solution set has dimension at least `1`. Returning intersection of solutions with `2` == 1."
NSum::bdmtd = "`1` is not a valid specification of a numerical summation approximation algorithm."
NSum::istep = "Cannot get from `1` to `2` in steps of `3`."
NSum::itfn = "`1` does not have the correct form for an iterator."
NSum::nslim = "Limit of summation `1` is not a number."
NSum::nsnum = "Summand (or its derivative) `1` is not numerical at point `2` = `3`."
NSum::nsst = "Summation step size `1` is zero or not a number."
NSum::nsumz = "Some terms are zero. The algorithms are not very applicable."
General::sigz = "In addition to the number of digits requested, one or more zeros will appear as placeholders."
General::dvec = "The dependency cannot be found for individual components of vector arguments, so the dependency will be treated in block form."
General::mpwc = "`1` was unable to convert `2` to Piecewise, because the required number `3` of piecewise cases sought exceeds the internal limit $MaxPiecewiseCases = `4`."
General::nfil = "`1` is not a valid list of filters."
General::nomthd = "There is no method `1` for `2` objects."
General::nnum = "The function value `3` is not a number at `2` = `1`."
General::nnum1 = "The function value `2` is not a number when the arguments are `1`."
General::nlnum = "The function value `3` is not a list of numbers with dimensions `4` at `2` = `1`."
General::nlnum1 = "The function value `2` is not a list of numbers with dimensions `3` when the arguments are `1`."
General::ngnum = "The gradient is not a vector of numbers at `2` = `1`."
General::ngnum1 = "The gradient is not a vector of numbers when the arguments are `1`."
General::njnum = "The Jacobian is not a matrix of numbers at `2` = `1`."
General::njnum1 = "The Jacobian is not a matrix of numbers when the arguments are `1`."
General::nhnum = "The Hessian is not a matrix of numbers at `2` = `1`."
General::nhnum1 = "The Hessian is not a matrix of numbers when the arguments are `1`."
General::nrnum = "The function value `3` is not a real number at `2` = `1`."
General::nrnum1 = "The function value `2` is not a real number when the arguments are `1`."
General::nrlnum = "The function value `3` is not a list of real numbers with dimensions `4` at `2` = `1`."
General::nrlnum1 = "The function value `2` is not a list of real numbers with dimensions `3` when the arguments are `1`."
General::nbnum = "The function value `3` is not True or False at `2` = `1`."
General::nbnum1 = "The function value `2` is not True or False when the arguments are `1`."
General::nrgnum = "The gradient is not a vector of real numbers at `2` = `1`."
General::nrgnum1 = "The gradient is not a vector of real numbers of length when the arguments are `1`."
General::nrjnum = "The Jacobian is not a matrix of real numbers at `2` = `1`."
General::nrjnum1 = "The Jacobian is not a matrix of real numbers when the arguments are `1`."
General::nrhnum = "The Hessian is not a matrix of real numbers at `2` = `1`."
General::nrhnum1 = "The Hessian is not a matrix of real numbers when the arguments are `1`."
General::preal = "The parameter `1` should be real valued."
General::symd = "Unable to automatically compute the symbolic derivative of `1` with respect to the arguments `2`. Numerical approximations to derivatives will be used instead."
General::symd1 = "Unable to automatically compute the symbolic derivative of `1`. Numerical approximations to derivatives will be used instead."
General::symdv = "Unable to automatically compute the symbolic derivative for a function of vector arguments. Numerical approximations to derivatives will be used instead."
General::symfd = "Unable to compute the symbolic second derivative when the first derivative is computed using numerical approximations.  Numerical approximations will be used instead."
General::spsder= "The sparsity pattern must be explicitly given for the supplied derivative value function, `1`."
General::sdsh = "The sparsity pattern `1` is inconsistent with the dimensions `2` of the derivative."
General::tma = "Too much accuracy requested at start of problem. Try increasing the value of WorkingPrecision or decreasing the values of AccuracyGoal and/or PrecisionGoal."
General::vardep = "The variable `1` has dependencies on the other variables, `2`.  Try using variables that do not depend on each other."
General::vloc = "The variable `1` cannot be localized so that it can be assigned to numerical values."
General::vexdep = "The variable `1` has dependencies in the current session that causes it to evaluate to `2`, which cannot be used as a variable."
General::fsfq = "Unexpected state reached in `1`."
Experimental`CreateNumericalFunction::largd = "Argument specification `1` in `2` is not of the form {name, dimensions}."
Experimental`CreateNumericalFunction::dlist = "Dimension list expected instead of `1` in `2`."
Experimental`CreateNumericalFunction::largs = "Argument specification `1` in `2` is not of the form {name, sample value}."
Experimental`CreateNumericalFunction::nosamp = "Sample argument expected in specification `1`."
Experimental`CreateNumericalFunction::srect = "Sample argument `1` in specification `2` is not a number or array of numbers."
Experimental`CreateNumericalFunction::scdims = "Sample arguments given in specification `1` do not have consistent dimensions."
Experimental`CreateNumericalFunction::pval = "Sample parameter value `1` in `2` is not a number."
Experimental`CreateNumericalFunction::pdim = "Dimensions `1` in `2` for the parameter are inconsistent with the requirement that the parameter be a scalar."
Experimental`CreateNumericalFunction::dimsl = "`1` in list `2` is not a specification for the dimensions of an argument."
Experimental`CreateNumericalFunction::ardims = "The resulting dimensions for `1` cannot be computed automatically unless the option SampleArgument -> True and argument values are given in the second argument."
Experimental`CreateNumericalFunction::jg = "You cannot specify values for both the Gradient and Jacobian options."
Experimental`CreateNumericalFunction::neargs = "The first argument should be a nonempty list of argument specifications."
Experimental`CreateNumericalFunction::arglist = "The sample arguments `1` should be given as a list with elements corresponding to the variables `2`."
Experimental`CreateNumericalFunction::msym = "The value of the option `1` should be a symbol."
Experimental`CreateNumericalFunction::rdim = "The third argument `1` should be a list of positive machine integers containing the result dimensions."
Experimental`CreateNumericalFunction::aimm = "The total lengths of arguments specified by `1` are mismatched with the total length of inputs specified by `2` in `3`."
General::excf = "The value `1` of the option ExcludedForms is not a list."
General::stmb = "The value `1` of the option OptimizationSymbol is not a symbol."
General::strf = "The value `1` of the option StructuralForms is not a list."
General::colvl = "The value `1` of the option CompileOptimizations is not 0, 1, 2, All, or None."
General::lvl = "The value `1` of the option OptimizationLevel is not 0, 1, or 2."
Gradient::smeth = Jacobian::smeth = Hessian::smeth = "The method `1` in `2` for computing the derivative is not a function that will be evaluated to give the derivative or one of the strings \"FiniteDifference\" or \"Symbolic\"."
Gradient::spopt = Jacobian::spopt = Hessian::spopt = "The option Sparse -> `1` should be Automatic, True, False, or a SparseArray pattern object with corresponding nonzero elements."
Testing`Internal`MVectorNorm::mrange = "Either a vector element or a norm outside machine-precision boundaries."
Testing`Internal`MVectorNorm::mvntestp = "Incorrect p type in MTensor_VectorNorm( ) test driver; must be integer or real."
Testing`Internal`MVectorNorm::mvntestv = "Incorrect vector type in MTensor_VectorNorm( ) test driver; must be real or complex."
Testing`Internal`MScaledVectorNorm::mrange = "Either a vector element or a norm outside machine-precision boundaries."
Testing`Internal`MScaledVectorNorm::mvntestp = "Incorrect p type in MTensor_VectorNorm( ) test driver; must be integer or real."
Testing`Internal`MScaledVectorNorm::mvntestv = "Incorrect vector type in MTensor_VectorNorm( ) test driver; must be real or complex."
NumericQ::set = "Cannot set `1` to `2`; the lhs argument must be a symbol and the rhs must be True or False."
NumericQ::unset = "Cannot clear `1`; the argument must be a symbol."
On::none = "Message `1` not found."
Optional::opdef = "The default value for the optional argument `1` contains a pattern."
Options::opmix = "Cannot mix streams and non-streams in `1`."
Options::opsym = "Second argument in `1` should be a symbol or a list of symbols."
OptionValue::nodef = "Unknown option `1` for `2`."
OptionValue::optnf = "Option name `1` not found in defaults for `2`."
PadLeft::level = PadRight::level = "The padding specification `1` involves `2` levels; the list `3` has only `4` level."
PadLeft::margin = PadRight::margin = "The list of margins `1` given in `2` must be of the same length (`3`) as the list of padded dimensions `4`."
ParametricPlot::bend = Plot::bend = "MaxBend `1` is not greater than or equal to 0."
ParametricPlot::pldiv = Plot::pldiv = "Value of PlotDivision -> `1` is not greater than or equal to 1."
General::plld = ParametricPlot3D::plld = "Endpoints for `1` in `2` must have distinct machine-precision numerical values."
General::glims = "Range specifications `1` and `2` contain the same iteration variable."
ContourPlot3D::glims = RegionPlot3D::glims = "Range specifications `1`, `2`, and `3` contain the same iteration variable."
ParametricPlot3D::ppfun = "Argument `1` is not a list with three or four elements."
ParametricPlot3D::pplr = "`1` is not a list starting with three real numbers at `2` = `3`."
ParametricPlot3D::ppta = "Value of option PlotPoints -> `1` is not Automatic, an integer >= 2, or a list of two of these values."
ParametricPlot3D::ppx = "Graphics3D object calculated in ParametricPlot3D is empty."
ParentForm::deflt = "The ParentForm of `1` is not defined on $BoxForms."
Partition::ohpdm = "The `1`-dimensional overhang parameter cannot indicate position in the `2`-dimensional block."
Partition::ohp = ListConvolve::ohp = ListCorrelate::ohp = "Overhang parameters in `1` must be nonzero machine-size integers, or lists of nonzero machine-size integers."
Partition::pdep = Developer`PartitionMap::pdep = "Depth `1` requested in object with dimensions `2`."
Partition::pttl = Developer`PartitionMap::pttl = "Partition arguments `2` and `3` must be the same length (since both are lists)."
PartitionsP::nterms = PartitionsQ::nterms = "The number of terms to sum is not a machine-size integer."
IntegerPartitions::nninfseq = "Position `1` of `2` must be All, Infinity, a non-negative integer, or a List whose first element (required) is a non-negative integer, second element (optional) is a non-negative integer or Infinity, and third element (optional) is a nonzero integer."
IntegerPartitions::rat = "Position `1` of `2` must be a rational number."
IntegerPartitions::rseq = "Position `1` of `2` must be All, a rational number, or a list of rational numbers."
IntegerPartitions::seq = "Position `1` of `2` must be All, None, an integer, or a List of 1, 2 or 3 integers, with the third (if present) nonzero, and with {0} disallowed."
IntegerPartitions::take = "Cannot take sequence { `1`, `2`, `3` } of `4`, which has length `5`."
IntegerPartitions::undef = "`1` contains partitions that are undefined because they are infinitely large."
IntegerPartitions::infnone = "`1` has either no partitions or infinitely many, but Mathematica has failed to determine which."
IntegerPartitions::toomany = "`1` requests a list of `2` partitions, but the longest list in Mathematica contains `3` elements."
IntegerPartitions::bigk = "In trying to compute `1`, Mathematica attempted to examine potential partitions with more than `2` elements (`2` is the length of the longest list in Mathematica)."
Pattern::nodef = "No default setting found for `1` in position `2` when length is `3`."
Pattern::patm = "Too many (`1`) optional arguments required in `2`."
Pattern::patsym = "First element in pattern `1` is not a symbol."
Pattern::patvar = "First element in pattern `1` is not a valid pattern name."
Pattern::patv = "Name `1` used for both fixed and variable length patterns."
PatternTest::ptest = "No patterns found in test `1`."
Pick::incomp = "Expressions `1` and `2` have incompatible shapes."
Piecewise::pairs = "The first argument `1` of Piecewise is not a list of pairs."
Play::pfnum = "Function `1` (after normalization) never evaluates to a machine-size real number."
Play::playr = ListPlay::playr = "Value of PlayRange -> `1` is not a list of two machine-size real numbers."
Play::plx = "First argument `1` does not contain any functions to play."
Play::sample = "Sample length `1` is not a positive machine-size integer."
Play::sdep = ListPlay::sdep = "Value of SampleDepth -> `1` should be a positive machine-size integer."
Play::srate = ListPlay::srate = "Value of SampleRate -> `1` should be a positive machine-size real number."
SparseArray::dims = "The dimensions `1` in `2` are not given as a list of positive machine integers."
SparseArray::exdims = "The dimensions cannot be determined from the positions `1`."
SparseArray::drnk = "The requested dimensions, `1`, have length inconsistent with the tensor rank (`2`) of the input."
SparseArray::pind = "The indices in `1` are not all positive."
SparseArray::ilist = "The implicit value `1` in `2` cannot be a list."
SparseArray::rect = "Rectangular array or list of rules expected at position 1 in `1`."
SparseArray::rule = "`1` in `2` is not a replacement rule."
SparseArray::rule1 = "The rule `1` is not of the form indices -> values."
SparseArray::ntb = "Cannot convert the sparse array `1` to an ordinary array because the `2` elements required exceeds the current size limit."
SparseArray::pos = "The left-hand side of `1` in `2` is not a position or pattern that will match a position."
SparseArray::posr = "The left-hand side of `1` in `2` is not a position or a pattern that will match the position of an element in an array with depth `3`."
SparseArray::posd = "The left-hand side of `1` in `2` is not a position or a pattern that will match the position of an element in an array with dimensions `3`."
SparseArray::valnl = "The value specified by the rule `1` should not be a List."
SparseArray::bndst = "The starting position `1` for the band `2` is not an explicit element position in an array."
SparseArray::bndstr = "The starting position `1` for the band `2` is not an explicit element position in an array with depth `3`."
SparseArray::bndendr = "The ending position `1` for the band `2` is not Automatic or an explicit element position in an array with depth `3`."
SparseArray::bndstd = "The starting position `1` for the band `2` is not an explicit element position in an array with dimensions `3`."
SparseArray::bndendd = "The ending position `1` for the band `2` is not Automatic or an explicit element position in an array with dimensions `3`."
SparseArray::bndstp = "The step `1` for the band `2` is not an integer or list of integers having length equal to the array depth `3`."
SparseArray::bndstp0 = "To iterate over the elements in `1` specified for the band values, the step `2` needs to have at least `3` nonzero components."
SparseArray::bndtr = "There are insufficient positions available in the `1` to fit all the values `2` so some of the values will be omitted in the specification `3`."
SparseArray::bndvr = "The values `1` for a band specification should be a scalar, an array of depth less than or equal to `2`, or a list of arrays of depth `2`."
General::spmat = "`1` is not a sparse matrix."
General::sparv = "Valid SparseArray expected at position `2` in `1`."
General::spts = "Scalar, rectangular tensor, or valid SparseArray expected at position `2` in `1`."
General::ptlen = "Objects of unequal length in `1` cannot be combined."
Take::take = Part::take = Set::take = Internal`BagPart::take = Subsets::take = "Cannot take positions `1` through `2` in `3`."
Plot3D::gval = "Function value `1` at grid point xi = `2`, yi = `3` is not a real number."
ListPlot3D::gval = ListContourPlot::gval = ListDensityPlot::gval = ListPlot::gval = ListLinePlot::gval = "Value `1` is not a real number."
ListLinePlot::glval = ListPlot::glval = "`1` is not a valid pair of real numbers."
Plot3D::plnc = "`1` is neither a machine-size real number at `2`=`3` nor a list of a real number and a valid color directive."
PlotRange::gtype = Show::gtype = "`1` is not a type of graphics."
PlotRange::prng = "Value of option PlotRange -> `1` is not All, Full, Automatic, a positive machine number, or an appropriate list of range specifications."
PlotRegion::plotr = "Value of PlotRegion -> `1` is not two pairs of real numbers in the form {{xmin, xmax}, {ymin, ymax}}."
PolynomialExtendedGCD::nuniv = Algebra`PolynomialPowerMod`PolynomialPowerMod::nuniv = "`1` and `2` are not univariate polynomials in the same variable."
Algebra`PolynomialPowerMod`PolynomialPowerMod::expt = "Exponent `1` is not an integer."
Algebra`PolynomialPowerMod`PolynomialPowerMod::imodp = "Value of integer modulus `1` should be a prime number or zero."
Algebra`PolynomialPowerMod`PolynomialPowerMod::ninvm = "Polynomial `1` in `2` is not invertible modulo `3` and `4`."
Algebra`PolynomialPowerMod`PolynomialPowerMod::ninv = "Polynomial `1` in `2` is not invertible modulo `3`."
PolynomialMod::coef = "Value of option CoefficientDomain -> `1` should be Integers or Rationals."
PolynomialMod::polyi = "`1` is not valid input for PolynomialMod."
PolynomialMod::polym = "Modulus `1` is not a positive integer."
Algebra`PolynomialGCDModList::nogcd = "Cannot compute the GCD of `1` and `2` mod `3`."	
Algebra`PolynomialMakeMonicModList::nprimemod = "Modulus `1` is not prime."
Algebra`PolynomialModList::badmod = "Modulus `1` is not a positive integer."
Algebra`PolynomialModList::divby0 = "Cannot divide a univariate polynomial by zero."	
Algebra`PolynomialModList::ninv = "Cannot invert `1` modulo `2`."	
Algebra`PolynomialModList::nsfmod = "The polynomial `1` is not squarefree modulo `2`."	
Algebra`PolynomialModList::unipoly = "The argument `1` is not an integer vector."
Algebra`PolynomialPthRootModList::noroot = "The `1`th root of `2` modulo `1` does not exist."	
Algebra`PolynomialQuotientModList::divby0 = "Cannot divide a univariate polynomial by zero."
PossibleZeroQ::bdmtd = "Value of option Method -> `1` is not Automatic or \"ExactAlgebraics\"."
PowerMod::badmod = "The modulus `1` has too large prime factors."
PowerMod::ninv = "`1` is not invertible modulo `2`."
PowerMod::pmod = "The base and modulus arguments in `1` must be Gaussian integers and the power must be an integer or rational."
PowerMod::root = "The equation x^`1` = `2` (mod `3`) has no integer solutions."
PowerModList::arg1 = "The first argument `1` of PowerModList is not an integer."
PowerModList::arg2 = "The second argument `1` of PowerModList is not rational."
PowerModList::arg3 = "The third argument `1` of PowerModList is not a positive integer."
Prime::intpp = Internal`QuadraticFundamentalUnit::intpp = "Positive integer argument expected in `1`."
ZetaZero::largp = Prime::largp = PrimePi::largp = "Argument `1` in `2` is too large for this implementation."
PrimePi::nsfmm = "Insufficient memory to allocate required sieves."
Product::prodwarn = "Warning: `1` contains a capital Pi. Use \[EscapeKey]prod\[EscapeKey] to enter a product sign."
Product::div = "Product does not converge."
Protect::pssl = "`1` is not a string, symbol, or list of strings and symbols."
Internal`QuadraticFundamentalUnit::fund = "The argument `1` of QuadraticFundamentalUnit is not the fundamental discriminant of a real quadratic number field."
Quantile::nquan = "The Quantile specification `1` should be a number or a list of numbers between 0 and 1."
Quantile::parm = "The Quantile parameters `1` should be given as a 2 x 2 matrix of real numbers {{a,b},{c,d}} or as a pair of real plot point parameters {a,b}."
General::tol = "Value of option Tolerance -> `1` is not a non-negative real number or Automatic."
General::tol2 = "Value of option Tolerance -> `1` is not a positive real number or Automatic."
Quiet::allall = "Arguments 2 and 3 of `1` should not both be All."
Quiet::anmlist = "Argument `1` of `2` should be All, None, a message name, or a list of message names."
Quiet::conflict = "In `1` the message name(s) `2` appear in both the list of messages to switch off and the list of messages to switch on."
Random::randn = "Range specification `1` in `2` is not a valid number or pair of numbers."
Random::randt = "Type specification `1` in `2` should be Real, Integer, or Complex."
RandomChoice::lrwl = "The items for choice `1` should be a list or a rule weights -> choices."
RandomChoice::weightv = RandomSample::weightv = "The weights given on the left-hand side of `1` should be a list of positive numerical quantities having the same length as the list given on the right-hand side."
RandomChoice::array = RandomInteger::array = RandomReal::array = RandomComplex::array = "The array dimensions `2` given in position 2 of `1` should be a list of non-negative machine-sized integers giving the dimensions for the result."
RandomInteger::udist = RandomReal::udist = RandomComplex::udist = "The specification `1` is not a random distribution recognized by the system."
RandomInteger::distv = "The result returned by `1` for the distribution `2` was `3`, which is not a vector of integers of length `4`."
RandomReal::distv = "The result returned by `1` for the distribution `2` was `3`, which is not a vector of reals of length `4`."
RandomComplex::distv = "The result returned by `1` for the distribution `2` was `3`, which is not a vector of complex numbers of length `4`."
RandomInteger::unsdst = "The distribution  `1` is defined on a set of real values.  Use RandomReal instead."
RandomReal::unsdst = "The distribution `1` is defined on a set of integers.  Use RandomInteger instead."
RandomInteger::unstyp = "The current random generator does not support generation of random integers in the given range."
RandomReal::unstyp = "The current random generator does not support generation of random reals in the given range."
RandomComplex::unstyp = "The current random generator does not support generation of random complex numbers in the given range."
RandomInteger::unifr = "The endpoints specified by `1` for the endpoints of the discrete uniform distribution range are not integers."
RandomReal::unifr = "The endpoints specified by `1` for the endpoints of the uniform distribution range are not real valued."
RandomComplex::unifr = "The endpoints specified by `1` for the endpoints of the uniform distribution range are not complex valued."
RandomReal::parx = RandomInteger::parmx = "`1` should have `2` parameters."
RandomReal::parb = RandonInteger::parmb = "`1` should have between `2` and `3` parameters."
RandomReal::parre = "The parameter `1` in position `2` of `3` should be a real number."
RandomReal::parpos = "The parameter `1` in position `2` of `3` should be positive"
RandomReal::precw = "The precision of the parameter `1` is less than WorkingPrecision (`2`)."
RandomReal::posdof = "The degrees of freedom parameter `1` in `2` should be positive."
RandomSample::lrwl = "The set of items to sample from, `1`, should be a nonempty list or a rule weights -> choices."
RandomSample::smplen = "RandomSample cannot generate a sample of length `1`, which is greater than the length of the sample set `2`.  If you want a choice of possibly repeated elements from the set, use RandomChoice."
Random`MKL::bdmtd = "Value of option Method -> `1` is not one of `2`."
RandomPrime::noprime = "There are no primes in the specified interval."
RandomPrime::posdim = "The dimensions parameter `1` is expected to be a positive integer or a list of positive integers."
RandomPrime::prmrng = "First argument `1` is not a positive integer or a list of two positive integers."
Range::range = "Range specification in `1` does not have appropriate bounds."
Raster::rscd = RasterArray::rscd = "Color `1` is incompatible with the previous color."
Raster::rslim = "Third argument `1` to `2` is not a list of two distinct real numbers."
Raster::rsrec = RasterArray::rsrec = "Second argument `1` in `2` is not a list of two coordinates."
Raster::rsval = "Non-numerical value `1` found at position `2` in first argument of `3`."
RasterArray::rscol = "Expression `1` at position `2` in first argument of `3` is not a valid color or gray-level directive."
RasterArray::obs = "RasterArray is obsolete. Translating to Raster."
RasterGraphics::argx = "Graphics called with 0 arguments; 1 argument is expected."
RasterGraphics::rrng = "Value of `1` is not All, Automatic, or an appropriate range specification."
RasterGraphics::optx = "Unknown option `1` in `2`."
RasterGraphics::nonopt = "Options expected (instead of `2`) beyond position 1 in `1`. An option must be a rule or a list of rules."
RasterGraphics::gmat = "`1` is not a rectangular array larger than 2 x 2."
RasterGraphics::zval = "Non-numerical value `1` found at position `2` in the first argument."
Read::readf = ReadList::readf = Skip::readf = "`1` is not a valid format specification."
Read::readn = ReadList::readn = Skip::readn = "Invalid real number found when reading from `1`."
Read::readt = ReadList::readt = Skip::readt = "Invalid input found when reading `1` from `2`."
Read::readx = ReadList::readx = Skip::readx = "`1` reads no entries."
RealDigits::digs = "Unable to determine the number of terms in the list of digits."
RealDigits::period = "`1` has a period of `2` digits in base `3`. Use RealDigits[x, b, n] to request n digits."
RealDigits::ndig = "The number of digits to return cannot be determined."
RealExponent::rbase = RealDigits::rbase = MantissaExponent::rbase = "Base `1` is not a real number greater than 1."
RealExponent::fnumx = RealDigits::fnumx = MantissaExponent::fnumx = "The value `1` did not evaluate to a sufficiently precise finite number."
ContinuedFraction::realx = RealDigits::realx = MantissaExponent::realx = "The value `1` is not a real number."
Reduce::bddom = "Value `1` of the domain argument should be Complexes, Reals, Algebraics, Rationals, Integers, Primes, or Automatic."
Rescale::nargs = "If the first argument is not a list or a SparseArray, two or three arguments are expected."
Rescale::rtwo = "The argument `1` at position `2` is expected to be a list of a lower bound and an upper bound."
Resolve::bddom = FindInstance::bddom = "Value `1` of the domain argument should be Complexes, Reals, Algebraics, Rationals, Integers, Primes, Booleans, or Automatic."
Resolve::ratnz = "Resolve was unable to eliminate quantifiers from the system with inexact coefficients. The answer was obtained by eliminating quantifiers from a corresponding exact system and numericizing the result."
Reduce::bdomv = "Warning: `1` is not a valid domain specification. Assuming it is a variable to eliminate."
Reduce::naqs = FindInstance::naqs = "`1` is not a quantified system of equations and inequalities."
Reduce::ratnz = "Reduce was unable to solve the system with inexact coefficients. The answer was obtained by solving a corresponding exact system and numericizing the result."
Reduce::inex = "Reduce was unable to solve the system with inexact coefficients or the system obtained by direct rationalization of inexact numbers present in the system. Since many of the methods used by Reduce require exact input, providing Reduce with an exact version of the system may help."
Reduce::nsmet = "This system cannot be solved with the methods available to Reduce."
Reduce::fexp = Resolve::fexp = FindInstance::fexp = "Warning: `1` used FunctionExpand to transform the system. Since FunctionExpand transformation rules are only generically correct, the solution set might have been altered."
Reduce::incs = Resolve::incs = FindInstance::incs = "Warning: `1` was unable to prove that the solution set found is complete."
Reduce::nint = Resolve::nint = FindInstance::nint = "Warning: `1` used numeric integration to prove that the solution set found is complete."
Reduce::rhyp = Resolve::rhyp = FindInstance::rhyp = "Warning: `1` assumed the Riemann hypothesis in order to prove the solution set found is complete."
FindInstance::fwsol = "Warning: FindInstance found only `1` instance(s), but it was not able to prove `2` instances do not exist."
FindInstance::nsmet = "The methods available to FindInstance are insufficient to find the requested instances or prove they do not exist."
FindInstance::exvar = "The system contains a nonconstant expression `1` independent of variables `2`."
FindInstance::boolv = "The system is not Boolean valued at `1`."
Reduce::cpow = Resolve::cpow = FindInstance::cpow = "`1` was unable to prove that a radical of an expression containing only real variables and parameters is real valued. If you are interested only in solutions for which all radicals contained in the input are real valued, use `1` with domain argument Reals."
Reduce::croot = Resolve::croot = FindInstance::croot = "`1` was unable to prove that a Root object containing only real variables and parameters is real valued. If you are interested only in solutions for which all Root objects contained in the input are real valued, use `1` with domain argument Reals."
Reduce::nric = Resolve::nric = FindInstance::nric = "The system `1` contains a nonreal constant `2` inside an inequality. With no domain argument given, all constants appearing in inequalities should be real."
Reduce::nddc = Resolve::nddc = FindInstance::nddc = "The system `1` contains a nonreal constant `2`. With the domain `3` specified, all constants should be real."
Reduce::infc = Resolve::infc = FindInstance::infc = "The system `1` contains an infinite object `2`."
Reduce::useq = "The answer found by Reduce contains unsolved equation(s) `1`. A likely reason for this is that the solution set depends on branch cuts of Mathematica functions."
Reduce::rmod = FindInstance::rmod = "Modulus `1` must be a non-negative integer other than 1."
Reduce::mdom = FindInstance::mdom = "Warning: ignoring domain specification `1`; option setting Modulus -> `2` implies domain integers modulo `2`."
Reduce::melem = FindInstance::melem = "Cannot use Element statements with option setting Modulus -> `1`."
Reduce::mineq = FindInstance::mineq = "Cannot use inequalities with option setting Modulus -> `1`."
Reduce::mcoef = FindInstance::mcoef = "The system `1` contains a nonrational constant `2`. With Modulus -> `3` all constants should be integers or rational numbers with denominators invertible modulo `3`."
Reduce::munsp = FindInstance::munsp = "`1` was unable to solve the system. Increasing the value of SystemOption MaxModularPoints may help."
Refresh::tracksym = "Value of option TrackedSymbols -> `1` is not a list of symbols, All, or Automatic."
Refresh::arg = "The value of the second argument `1` is not None."
Experimental`RegisterConverter::extensions = "The third argument should be a list of strings and not `1`."
Experimental`RegisterConverter::mode = "The first argument should be either Import or Export and not `1`."
Experimental`RegisterConverter::noexe = "Could not find the executable `1` in any of `2`."
Experimental`RegisterConverter::source = "Fourth argument should be a string, pair of strings, or None, and not `1`."
RegularExpression::nocond = "No conditions allowed on right-hand side `1` of RegularExpression replacement rule."
RegularExpression::msg1 = "\\ at end of pattern in `1`."
RegularExpression::msg2 = "\\c at end of pattern in `1`."
RegularExpression::msg3 = "Unrecognized character follows \\ in `1`."
RegularExpression::msg4 = "Numbers out of order in {} quantifier in `1`."
RegularExpression::msg5 = "Number too big in {} quantifier in `1`."
RegularExpression::msg6 = "Missing terminating ] for character class in `1`."
RegularExpression::msg7 = "Invalid escape sequence in character class in `1`."
RegularExpression::msg8 = "Range out of order in character class in `1`."
RegularExpression::msg9 = "Nothing to repeat in `1`."
RegularExpression::msg10 = "Operand of unlimited repeat could match the empty string in `1`."
RegularExpression::msg11 = "Internal: unexpected repeat in `1`."
RegularExpression::msg12 = "Unrecognized character after (? in `1`."
RegularExpression::msg13 = "POSIX named classes are supported only within a class in `1`."
RegularExpression::msg14 = "Missing parenthesis in `1`."
RegularExpression::msg15 = "Reference to non-existent subpattern in `1`."
RegularExpression::msg16 = "Internal: erroffset passed as NULL in `1`."
RegularExpression::msg17 = "Unknown option bit(s) set in `1`."
RegularExpression::msg18 = "Missing parenthesis after comment in `1`."
RegularExpression::msg19 = "Parentheses nested too deeply in `1`."
RegularExpression::msg20 = "Regular expression too large in `1`."
RegularExpression::msg21 = "Failed to get memory in `1`."
RegularExpression::msg22 = "Unmatched parentheses in `1`."
RegularExpression::msg23 = "Internal: code overflow in `1`."
RegularExpression::msg24 = "Unrecognized character after (?< in `1`."
RegularExpression::msg25 = "Lookbehind assertion is not fixed length in `1`."
RegularExpression::msg26 = "Malformed number after (?( in `1`."
RegularExpression::msg27 = "Conditional group contains more than two branches in `1`."
RegularExpression::msg28 = "Assertion expected after (?( in `1`."
RegularExpression::msg29 = "(?R or (?digits must be followed by ) in `1`."
RegularExpression::msg30 = "Unknown POSIX class name in `1`."
RegularExpression::msg31 = "POSIX collating elements are not supported in `1`."
RegularExpression::msg32 = "Internal problem in `1`."
RegularExpression::msg33 = "Spare problem in `1`."
RegularExpression::msg34 = "Character value in \\x{...} sequence is too large in `1`."
RegularExpression::msg35 = "Invalid condition (?(0) in `1`."
RegularExpression::msg36 = "\\C not allowed in lookbehind assertion in `1`."
RegularExpression::msg37 = "Mathematica does not support \\L, \\l, \\N, \\P, \\p, \\U, \\u, or \\X in `1`."
RegularExpression::msg38 = "Number after (?C is > 255 in `1`."
RegularExpression::msg39 = "Closing ) for (?C expected in `1`."
RegularExpression::msg40 = "Recursive call could loop indefinitely in `1`."
RegularExpression::msg41 = "Unrecognized character after (?P in `1`."
RegularExpression::msg42 = "Invalid syntax after (?P in `1`."
RegularExpression::msg43 = "Two named groups have the same name in `1`."
RegularExpression::msg44 = "Invalid UTF-8 string in `1`."
RegularExpression::msg45 = "Missing \\E after \\Q in `1`."
RegularExpression::msg46 = "Missing newline after # in (?x) mode in `1`."
RegularExpression::materr = "Internal problem during match; positive match might be missed."
RegularExpression::maxrec = "Recursion limit exceeded; positive match might be missed."
Remove::relex = "Cannot remove lexical symbol `1` except automatically (when `2` is removed)."
Remove::remal = "Symbol `1` already removed."
Remove::rmlck = "Symbol `1` is Locked and cannot be removed."
Remove::rmnsm = "There are no symbols matching \"`1`\"."
Remove::rmptc = "Symbol `1` is Protected and cannot be removed."
Remove::spsym = "Special symbol `1` cannot be removed."
Remove::ssym = "`1` is not a symbol."
RenameFile::renfd = "Cannot rename a file into a directory."
Repeated::order = RepeatedNull::order = "Range out of order in `1`"
Repeated::range = RepeatedNull::range = "Range specification in integers (max or {min, max}) expected at position `1` in `2`."
Replace::erep = "`1` must be evaluated before use."
Replace::reps = ReplaceAll::reps = ReplaceRepeated::reps = ReplaceList::reps = ReplacePart::reps = "`1` is neither a list of replacement rules nor a valid dispatch table, and so cannot be used for replacing."
Replace::rmix = ReplaceAll::rmix = ReplaceRepeated::rmix = ReplaceList::rmix = "Elements of `1` are a mixture of lists and nonlists."
ReplacePart::psl = ReplaceHeldPart::psl = MapAt::psl = Delete::psl = FlattenAt::psl = Insert::psl = StringInsert::psl = StringReplacePart::psl = Extract::psl = "Position specification `1` in `2` is not an integer or a list of integers."
ReplaceRepeated::rrlim = "Exiting after `1` scanned `2` times."
ResetDirectory::dtop = "Directory stack is empty."
Experimental`Resolve::deprec = "Experimental`Resolve will not be supported in future versions of Mathematica. Use System`Resolve instead."
Resultant::method = Discriminant::method = "Value of option Method -> `1` should be Automatic, \"SylvesterMatrix\", \"BezoutMatrix\", Subresultants, or Modular."
Resultant::var = "Not a valid variable in `1`."
Rest::norest = "Cannot take the rest of expression `1` with length zero."
Most::norest = "Cannot take Most of expression `1` with length zero."
Riffle::rspec = "The third argument `1` should be a positive integer or a list with three integers."
Riffle::sepos = "The start and end positions in `1` should be nonzero machine-sized integers."
Riffle::npos = "The spacing between riffled elements given in `1` should be a positive machine-size integer."
Riffle::inclen = "The start and end positions and the spacing between riffled elements given in `1` cannot be satisfied for the input list of length `2`."
RegisterFormat::erropts = "The value `1` of the option `2` is invalid."
RegisterImport::fmt = RegisterExport::fmt = "The format `1` is not registered.  Use RegisterFormat[] to register this format."
RegisterImport::fch = RegisterExport::fch = "The value of option `1` is invalid.  Using default value of `2`."
Return::nofsdd = "No enclosing function, Scan, Do, or Dialog found for `1`."
Return::nofunc = "Function `1` not found enclosing `2`."
Return::obs = "Return's functionality of exiting a dialog is obsolete. To exit a dialog, use ExitDialog[] or ExitDialog[expr]. If an ExitDialog[expr] is encountered in the course of evaluation, the dialog will immediately be exited, returning expr."
Root::amb = "Root object `1` may be ambiguous. Changing the value of ExactRootIsolation from Root to True and redoing the computations is recommended."
Root::deg = "`1` has less than `2` root(s) as a polynomial in `3`."
Root::mdeg = "The degree `1` of the input polynomial `2` is not an integer between 1 and $MaxRootDegree."
Root::npoly = "`1` is not a polynomial in `2`."
Root::nup = "`1` is not a univariate polynomial."
Root::overfl = "Overflow occurred during root isolation. The result may be incorrect."
Root::rnv = "`1` is neither a valid variable nor a valid root number."
Root::sbr = "Because of branch cuts, the series may represent a different root of `1` for some values of `2`."
Root::var = "`1` is not a valid variable."
RootApproximant::bdeg = "The degree `1` should be an integer between 1 and $MaxRootDegree."
RootApproximant::bwgt = "The weight `1` should be a non-negative integer."
RootApproximant::cplx = "An algebraic number of degree one cannot have a nonzero imaginary part. Approximating Re[`1`]."
Roots::badmod = "Cannot extract roots of input modulo `1`."
Roots::eqn = NRoots::eqn = "`1` is not an equation."
Roots::neq = NRoots::neq = "`1` is expected to be a polynomial in the variable `2`."
Roots::lexp = "Exponent of `1` in `2` is too large."
RootSum::pfn = "`1` is not a pure function."
RotateLeft::rotate = RotateRight::rotate = "Cannot rotate atomic expression `1`."
RotateLeft::rspec = RotateRight::rspec = "Rotation specification `1` should be a machine-size integer or list of machine-size integers."
RowReduce::rmeth = NullSpace::rmeth = Inverse::rmeth = "Value of option Method -> `1` should be \"CofactorExpansion\", \"OneStepRowReduction\", \"DivisionFreeRowReduction\", or Automatic."
Rule::rhs = RuleDelayed::rhs = "Pattern `1` appears on the right-hand side of rule `2`."
Run::shell = "Cannot execute shell."
SchurDecomposition::schurf = HessenbergDecomposition::schurf = "`1` has received a matrix with infinite precision."
SchurDecomposition::schurn = HessenbergDecomposition::schurn = "`1` has received a matrix with non-numeric elements."
SeedRandom::eminit = "The initialization of random generator Method -> `1` failed.  The current random generator will remain as before."
SeedRandom::bitw = "The \"BitWidth\" property for the random generator `1` evaluated to `2`.  It should be a positive integer."
SeedRandom::gprop = "At least one of the properties \"GeneratesBitsQ\", \"GeneratesIntegersQ\", or \"GeneratesRealsQ\" needs to be True for the generator `1` to be used."
SeedRandom::initf = "Initialization of the `1` random number generator failed."
SeedRandom::initsf = "Random number generator initialization from the generator state `1` failed.  The data has been corrupted."
SeedRandom::initmf = "Random number generator initialization from the specification Method -> `1` failed."
SeedRandom::nogen = "`1` is not one of the built-in random number generators `2`.  A defined generator must be represented by a symbol."
SeedRandom::sfail = "Seeding of the `1` generator failed."
SeedRandom::seed = "Argument `1` in `2` should be an integer or a string."
SequenceLimit::bdmtd = "`1` is not a valid specification of a sequence limit extrapolation algorithm."
SequenceLimit::seqlim = "The general form of the sequence could not be determined, and the result may be incorrect."
SequenceLimit::seqw = "Sequence of length `1` is too short for use with Degree -> `2`."
SequenceLimit::wynn = "Value of Degree -> `1` should be a positive machine-size integer or Infinity."
Series::esss = "Essential singularity encountered in `1`."
Series::icm = "Series in `1` to be combined have unequal expansion points `2` and `3`."
Series::lss = "Logarithmic singularity encountered in `1`."
Series::nmer = "`1` is not a meromorphic function of `2` at `3`."
Series::sbyc = "Division by a series with no coefficients in `1`."
Series::serlim = "Series order specification `1` is not a machine-size integer."
PadeApproximant::sspec = Series::sspec = "Series specification `1` is not a list with three elements."
Series::vcnt = "Center point `2` of power series expansion involves the variable `1`."
SeriesData::csa = "Argument `1` in `2` is not a power series."
SeriesData::scmn = "Order of series `1` is negative."
SeriesData::scmp = "The constant term of series `1` does not match the expansion point of `2`."
SeriesData::sdatc = "Coefficient specification `1` in `2` is not a list."
SeriesData::sdatd = "Power denominator specification `1` in `2` is not a positive machine-size integer."
SeriesData::sdatn = "Order specification `1` in `2` is not a machine-size integer."
SeriesData::sdatv = "First argument `1` is not a valid variable."
SeriesData::slnc = "Argument `1` in Log is a series with no coefficients."
SeriesData::ssdn = "Attempt to evaluate a series at the number `1`. Returning Indeterminate."
Set::patset = "Warning: `1` in assignment `2` represents a named pattern; use symbol::tag to represent a message name."
Set::inset = "Assignments cannot be performed during inspection."
Set::lhsr = SetDelayed::lhsr = Unset::lhsr = TagSet::lhsr = TagSetDelayed::lhsr = TagUnset::lhsr = UpSet::lhsr = UpSetDelayed::lhsr = "Replacing rule `1` with rule `2` since their left-hand sides and conditions are equivalent."
Set::setraw = SetDelayed::setraw = UpSet::setraw = UpSetDelayed::setraw = TagSet::setraw = TagSetDelayed::setraw = "Cannot assign to raw object `1`."
Set::setrpt = SetDelayed::setrpt = UpSet::setrpt = UpSetDelayed::setrpt = TagSet::setrpt = TagSetDelayed::setrpt = "Cannot assign to raw object `1` in pattern `2`."
Set::shape = SetDelayed::shape = "Lists `1` and `2` are not the same shape."
SetAccuracy::accbd = "Requested accuracy `1` is not a real number within the allowable range."
SetAccuracy::acclg = "Requested accuracy `1` would result in a precision greater than $MaxPrecision; bounding by $MaxPrecision instead."
SetAccuracy::accsm = "Requested accuracy `1` would result in a precision smaller than $MinPrecision; bounding by $MinPrecision instead."
SetFileDate::fdate = "Date specification should be either the number of seconds since January 1, 1900 or a {y, m, d, h, m, s} list."
SetFileDate::toobig = "Requested date is too far in the future."
SetOptions::changebf = "The BinaryFormat option of stream `1` cannot be changed to `2`."
SetOptions::nspt = "SetOptions of `1` is not supported."
SetOptions::optf = "`1` has incorrectly formed option(s) `2`."
SetOptions::optnf = Options::optnf = AbsoluteOptions::optnf = "`1` is not a known option for `2`."
SetOptions::sstm = "Argument `1` is not a symbol or a stream."
SetStreamPosition::sbuf = "Requested position `1` in stream `2` is outside the file buffer; cannot reach outside the file buffer for non-disk files."
SetStreamPosition::stmrng = "Cannot set the current point in stream `2` to position `1`. The requested position exceeds the number of characters in the file."
Developer`SystemOptions::noset = "The value of SystemOption `1` cannot be modified."
Short::short = "Second argument `1` should be a positive real number."
Show::gcc = "Graphics of type `1` cannot be combined with other types of graphics."
Show::gcomb = "Could not combine the graphics objects in `1`."
Show::gmed = "No graphics output medium specified."
Show::shx = "No graphical objects to show."
Experimental`NumberScale::num = "Argument `1` should be a number."
Simplify::cfn = FullSimplify::cfn = "The cost function `1` does not evaluate to a real number at `2`."
Simplify::infd = FullSimplify::infd = "Expression `1` simplified to `2`."
Simplify::time = FullSimplify::time = "Time spent on a transformation exceeded `1` seconds, and the transformation was aborted. Increasing the value of TimeConstraint option may improve the result of simplification."
SingularValues::svdcmp = SingularValueList::svdcmp = SingularValueDecomposition::svdcmp = "Cannot compare singular values against the given tolerance `1`."
SingularValueList::gsvdta = SingularValueDecomposition::gsvdta = "Cannot take the second argument. Only one argument is permitted for generalized `1`."
SingularValueList::gmatrix = SingularValueDecomposition::gmatrix = "Argument `1` at position `2` is not a pair of nonempty rectangular matrices."
BoxForm`SetSizeCountRule::notsym = "The left side of the rule `1` is not a symbol."
BoxForm`SetSizeCountRule::valbad = "The value specified on the right side of the rule `1` is not Automatic, None, \"StartCounting\", \"StopCounting\", a machine integer, or a list of machine integers."
Solve::circ = MainSolve::circ = Roots::circ = Reduce::circ = System`Private`OldReduce::circ = Eliminate::circ = SolveAlways::circ = AlgebraicRules::circ = "Removing solution `1` from list of solutions. It results from an underdetermined system of equations involving transcendental functions."
Solve::dinv = MainSolve::dinv = Eliminate::dinv = Roots::dinv = AlgebraicRules::dinv = Reduce::dinv = System`Private`OldReduce::dinv = SolveAlways::dinv = GroebnerBasis::dinv = PolynomialReduce::dinv = "The expression `1` involves unknowns in more than one argument, so inverse functions cannot be used."
Solve::incnst = "Inconsistent or redundant transcendental equation. After reduction, the bad equation is `1` == 0."
Solve::smod = "Unable to solve equations for modulus."
Solve::solex = MainSolve::solex = Roots::solex = Reduce::solex = System`Private`OldReduce::solex = Eliminate::solex = SolveAlways::solex = AlgebraicRules::solex = GroebnerBasis::solex = PolynomialReduce::solex = "`1` cannot handle one of the exponents."
Solve::svars = "Equations may not give solutions for all \"solve\" variables."
Solve::tdep = MainSolve::tdep = Roots::tdep = Reduce::tdep = System`Private`OldReduce::tdep = Eliminate::tdep = SolveAlways::tdep = AlgebraicRules::tdep = GroebnerBasis::tdep = PolynomialReduce::tdep = "The equations appear to involve the variables to be solved for in an essentially non-algebraic way."
Solve::ifun = Eliminate::ifun = SolveAlways::ifun = "Inverse functions are being used by `1`, so some solutions may not be found; use Reduce for complete solution information."
Reduce::ifun = System`Private`OldReduce::ifun = MainSolve::ifun = AlgebraicRules::ifun = "Inverse functions are being used by `1`, so some solutions may not be found."
Solve::ifun2 = Eliminate::ifun2 = Reduce::ifun2 = System`Private`OldReduce::ifun2 = MainSolve::ifun2 = AlgebraicRules::ifun2 = SolveAlways::ifun2 = "Cannot obtain a solution with the InverseFunctions -> False option setting."
Sound::sdur = "Sound duration: `1` seconds."
Sound::sdur1 = "Sound duration: `1` second."
Sound::srate = "Sample rate: `1` samples/second."
Sound::ssnf = "`1` out of `2` sample points did not evaluate to real numbers."
Sound::ssnm = "A good PlayRange could not be found since most of the samples are not evaluating to machine-size real numbers."
Sow::encl = "Expression `1` has no enclosing Reap."
Sow::enclt = "Tag `1` in `2` has no matching Reap."
Developer`SparseLinearSolve::deprec = "Developer`SparseLinearSolve is deprecated.  Use LinearSolve with SparseArray matrices instead."
Developer`SparseLinearSolve::spam = "The sparse matrix `1` is not specified in the form {{i1, j1} -> a1, {i2, j2} -> a2, ...} with machine-sized integer position indices ik and jk and machine-sized real or complex values ak."
Developer`SparseLinearSolve::fovflw = "Machine overflow encountered factoring the sparse matrix."
Developer`SparseLinearSolve::sovflw = "Machine overflow encountered solving the sparse system."
Splice::splicd = "Missing right delimiter `1` at end of input file `2`."
Splice::splicf = "Cannot deduce output file name from `1`."
Splice::splict = "Cannot deduce output type from `1`."
Splice::splicx = "Invalid Mathematica input `1`."
Stack::stackx = "Expression number `1` does not exist in `2`; there are `3` expressions of the requested form."
StringCases::meta = StringFreeQ::meta = StringSplit::meta = StringReplaceList::meta = StringPosition::meta = StringReplace::meta = "Value of option MetaCharacters -> `1` is not None, Automatic, a string of length 3, or a list of three strings."
StringDrop::drop = "Cannot drop positions `1` through `2` in \"`3`\"."
StringExpression::cond = "Warning: Restrictions on pattern variable `1` in `2` are ignored as they are not associated with the first occurrence of `1`."
StringExpression::invld = "Element `1` is not a valid string or pattern element in `2`."
StringExpression::repbd = "Repeated argument out of range (> 65535) for a string pattern in `1`."
StringForm::sfq = "Unmatched backquote in `1`."
StringForm::sfr = "Item `1` requested in \"`3`\" out of range; `2` items available."
StringInsert::ins = StringReplacePart::ins = "Cannot insert at position `2` in `1`."
StringMatchQ::nospell = " Warning: The SpellingCorrection option is ignored for patterns that are not a plain string."
StringReplace::srep = "`1` is not a valid string replacement rule."
StringReplacePart::ovlp = "Position `1` overlaps previous positions; new string `2` will not be inserted."
StringReplacePart::plen = Array::plen = "`1` and `2` should have the same length."
StringReplacePart::repart = "Cannot replace positions `1` through `2` in \"`3`\"."
StringReplacePart::spos = "Position specification {m, n} is expected at position `1` in `2`."
StringSplit::slen = "Positive integer, All, or Automatic expected at position `1` in `2`."
StringTake::take = "Cannot take positions `1` through `2` in \"`3`\"."
StringTake::mseqs = "Sequence specification (+n, -n, {+n}, {-n}, {m, n}, or {m, n, s}) or a list of sequence specifications expected at position `2` in `1`."
Subresultants::slpr = "The algorithm failed due to a too low precision of input."
Subscripted::subn = "Subscripting specification `1` is not of the form n or {n1, n2}."
Subscripted::subv = "Specifications for superscripts and subscripts overlap."
Subscripted::subx = "Positions specified by `1` are not available in expression of length `2`."
Subsets::nninfseq = Permutations::nninfseq = "Position `1` of `2` must be All, Infinity, a non-negative integer, or a List whose first element (required) is a non-negative integer, second element (optional) is a non-negative integer or Infinity, and third element (optional) is a nonzero integer."
Subsets::seq = "Position `1` of `2` must be All, None, an integer, or a List of 1, 2 or 3 integers, with the third (if present) nonzero, and with {0} disallowed."
Subsets::toomany = "The number of subsets (`2`) indicated by `1` is too large; it must be a machine integer."
Sum::div = "Sum does not converge."
Sum::gener = "Unable to check convergence."
Sum::sumwarn = "Warning: `1` contains a capital sigma; use \[EscapeKey]sum\[EscapeKey] to enter a summation sign."
SurfaceColor::albedo = "Albedo specification `1` in first argument of `2` is not a valid GrayLevel or RGBColor directive."
SurfaceColor::shine = "Shininess specification `1` in third argument of `2` is not a positive real number."
SurfaceColor::specl = "Specularity specification `1` in second argument of `2` is not a valid GrayLevel or RGBColor directive."
MatrixPlot::clip = ArrayPlot::clip = SurfaceGraphics::clip = "Value of option ClipFill -> `1` is not None, Automatic, a color, or a list of two such values."
SurfaceGraphics::noproj = Graphics3D::noproj = "Mathematica is unable to make a projection matrix; check the settings of ViewPoint, ViewCenter, and ViewVertical."
SurfaceGraphics::pmsr = DensityGraphics::pmsr = ContourGraphics::pmsr = "PlotRange `1` is so much smaller than MeshRange `2` that there is nothing left to plot."
SurfaceGraphics::shade = "Shading array `1` is not the same shape as the z-value array."
Switch::argct = "Switch called with `2` arguments. Switch must be called with an odd number of arguments."
Symbol::symname = "The string \"`1`\" cannot be used for a symbol name. A symbol name must start with a letter followed by letters and numbers."
SymmetricPolynomial::toobig = "Cannot create a polynomial with `1` terms."
SymmetricPolynomial::nmint = "`1` is not a non-negative machine integer."
SymmetricPolynomial::hideg = "The degree `1` of an elementary symmetric polynomial cannot be higher than the number of variables `2`."
SymmetricPolynomial::nvarl = SymmetricReduction::nvarl = "`1` is not a list of variables."
SymmetricReduction::neql = "Lists `1` and `2` have different lengths."
Syntax::noinfo = "Input expression contains insufficient information to interpret the result."
Syntax::snthex = "4 hexadecimal digits are required after \\: to construct a 16-bit character."
Syntax::sntoct1 = "3 octal digits are required after \\ to construct an 8-bit character."
Syntax::sntoct2 = "2 hexadecimal digits are required after \\. to construct an 8-bit character."
Syntax::sntufn = "Unknown unicode longname `1`."
Syntax::sntunc = "Unicode longname `1` in the string is unterminated."
Syntax::stresc = "Unknown string escape \\`1`."
Syntax::syntyp = "\\ operators can only be used between \( \)."
Syntax::com = "Warning: Comma encountered with no adjacent expression. The expression will be treated as Null. `1`"
SystemDialogInput::unsupt = "The `1` dialog type is not currently supported on this platform."
SystemDialogInput::invt = "First argument `1` is not a valid dialog type."
TableForm::tfal = "Value of option TableAlignments -> `1` should be a list of alignment specifications (Top, Bottom, and Center for row dimensions, or Left, Right, and Center for column dimensions)."
TableForm::tfdir = "Value of option TableDirections -> `1` should be Row, Column, or a nonempty list of these values."
TableForm::tfh = "TableHeadings option contained `1`, which is not Automatic, None, or a list of labels."
TableForm::tfsp = "Value of TableSpacing -> `1` should be Automatic, a machine-size number, or a list of machine-size numbers."
TableForm::wtfsp = "Warning: TableSpacing value of `1` must be non-negative. Formatting will proceed with a value of 0."
TagSet::tagnf = TagSetDelayed::tagnf = TagUnset::tagnf = "Tag `1` not found in `2`."
TagSet::tagpos = TagSetDelayed::tagpos = TagUnset::tagpos = "Tag `1` in `2` is too deep for an assigned rule to be found."
TeXForm::unspt = "TeXForm of `1` is not supported."
Convert`TeX`BoxesToTeX::notboxes = "`1` is not a valid box structure. The first argument in `2` must be a valid box structure."
Text::textn = "Text offset `1` is not a pair of numbers."
Text::textz = "Vector for text rotation cannot have value {0, 0}."
Thickness::thkn = AbsoluteThickness::thkn = "The argument in `1` is not a number."
Accumulate::tdlen = "Objects of unequal length in `1` cannot be added."
Thread::tdlen = "Objects of unequal length in `1` cannot be combined."
Thread::tpos = "Cannot thread over positions `1` through `2` in `3`."
Throw::nocatch = "Uncaught `1` returned to top level."
Ticks::ticks = "`1` is not a valid tick specification."
General::timc = "Number of seconds `1` is not a positive machine-size integer or Infinity."
TreeForm::tlev = "Warning: Level specification `1` is not a non-negative integer or Infinity; ignored."
ToColor::colpc = ColorOutput::colpc = "Result `1` obtained during color conversion by applying function `2` to color `3` is not a GrayLevel, RGBColor, Hue, or CMYKColor directive."
ToColor::colpw = ColorOutput::colpw = "Result `1` obtained during color conversion by applying function `2` to color `3` has the wrong number of arguments for that color."
ToColor::tocol = "First argument `1` in ToColor should be a valid color directive."
ToDate::tdn = "First argument `1` should be an integer or a real number."
ToExpression::esntx = "Could not parse `1` as Mathematica input."
ToExpression::esntxb = "Expression cannot begin with \"`1`\"."
ToExpression::esntxf = "\"`1`\" cannot be followed by \"`2`\"."
ToExpression::esntxi = "Incomplete expression \"`1`\"."
ToExpression::notstrbox = "`1` is not a string or a box. ToExpression can only interpret strings or boxes as Mathematica input."
ToNumberField::nnfel = "`1` does not belong to the algebraic number field generated by `2`."
Total::tlauto = "The nested option for the Method option value Automatic can be \"ExtraPrecision\" -> n, where n is an integer >= 0, or \"ExtraPrecision\" -> Automatic, not `1`."
Total::tlep = "The value of the option \"ExtraPrecision\" -> `1` should be a positive integer or Automatic."
Total::tlmth = "The value of the option Method -> `1` should be Automatic or \"CompensatedSummation\"."
Total::tllen = "Lists of unequal length in `1` cannot be added."
ToString::notype = "FormatType `1` is not suitable for string-based output. Use a string-based format such as OutputForm."
Trace::tracb = TraceScan::tracb = TracePrint::tracb = TraceDialog::tracb = "Value of option `1` -> `2` should be False, True, All, or a list of two of these symbols."
Trace::tracd = TraceScan::tracd = TracePrint::tracd = TraceDialog::tracd = "Value of option `1` -> `2` should be False, True, or All."
TraceLevel::notrc = "No Trace function is currently active."
Reduce`TranscendentalRoot::invrt = "`1` is not equal to a root of `2`."
Reduce`TranscendentalRoot::ambr = "`1` is equal to more than one root of `2`."
Reduce`TranscendentalRoot::nunipf = Reduce`ExpLogRoots::nunipf = Reduce`AnalyticRoots::nunipf = "`1` is not a univariate numeric pure function."
Reduce`TranscendentalRoot::nunif = Reduce`ExpLogRoots::nunif = Reduce`AnalyticRoots::nunif = "`1` is not a univariate numeric function in `2`."
Reduce`ExpLogRoots::rbds = "`1` should be a pair of real numbers or real infinities."
Reduce`AnalyticRoots::cbds = "`1` should be a pair {a+b I, c+d I} with rational numbers a < b and c < d."
Reduce`AnalyticRoots::holo = "Unable to prove that `1` is holomorphic in the rectangle `2`. The solution set returned may be incomplete."
Reduce`AnalyticRoots::incs = "Only `1` out of the total of `2` solutions of `3` in the rectangle `4` have been found."
Reduce`AnalyticRoots::nint = "Warning: The number of solutions of `1` in the rectangle `2` has been determined using numeric integration."
Reduce`AnalyticRoots::unsn = "Unable to determine the number of solutions of `1` in the rectangle `2`. The solution set returned may be incomplete."
Transpose::diagnl = "Level rearrangement `1` would require collapsing dimensions of unequal lengths."
Transpose::newdims = "Level rearrangement `1` does not specify destination for level `2`."
Transpose::nmtx = "The first two levels of the one-dimensional list `1` cannot be transposed."
Transpose::perm = "The length of permutation `1` does not equal the depth of `2`."
Transpose::perm1 = "Entry `1` in permutation `2` is not a positive machine integer."
Transpose::perm2 = "Entry `1` is out of bounds for permutation `2`."
Transpose::tperm = "Permutation `1` is longer than the dimensions `2` of the array."
ConjugateTranspose::diagnl = "Level rearrangement `1` would require collapsing dimensions of unequal lengths."
ConjugateTranspose::newdims = "Level rearrangement `1` does not specify destination for level `2`."
ConjugateTranspose::nmtx = "The first two levels of the one-dimensional list `1` cannot be transposed."
ConjugateTranspose::perm = "The length of permutation `1` does not equal the depth of `2`."
ConjugateTranspose::perm1 = "Entry `1` in permutation `2` is not a positive machine integer."
ConjugateTranspose::perm2 = "Entry `1` is out of bounds for permutation `2`."
ConjugateTranspose::tperm = "Permutation `1` is longer than the dimensions `2` of the array."
UnAlias::alspr = "No previous alias found for `1`."
Uninstall::unlink = "External package `1` has not been installed."
Union::smtst = Intersection::smtst = Complement::smtst = Tally::smtst = "Application of the SameTest function yielded `1`, which evaluates to `2`. The SameTest function must evaluate to True or False at every pair of elements."
Unique::usym = "`1` is not a symbol or a valid symbol name."
Unitize::post = "The threshold `1` should be positive."
UnitVector::nokun = "There is no unit vector in direction `1` in `2` dimensions."
Unset::cxun = "Cannot unset contexts."
Unset::norep = TagUnset::norep = "Assignment on `2` for `1` not found."
Unset::usraw = TagUnset::usraw = "Cannot unset raw object `1`."
Unset::usrpt = TagUnset::usrpt = "Cannot unset raw object `1` in pattern `2`."
SystemInformation::noinfo = "No information available."
SystemInformation::nocomp = "`1` is not a component recognized by SystemInformation."
SystemInformation::noprop = "`2` is not a property returned by SystemInformation[\"`1`\"]."
VectorAngle::length = "The vectors `1` and `2` have different lengths."
VectorAngle::vec = "Input `1` is not a vector."
ViewCenter::viewc = "A projection cannot be constructed for a ViewCenter which coincides with a ViewPoint."
ViewPoint::viewp = "A projection cannot be constructed for a ViewPoint inside the bounding box."
ViewVertical::viewv = "The ViewVertical vector must have a nonzero component perpendicular to a line from the ViewPoint to the ViewCenter."
With::dup = Module::dup = Block::dup = Dialog::dup = "Duplicate local variable `1` found in local variable specification `2`."
With::dups = Module::dups = "Conflicting local variables `1` and `3` found in local variable specification `2`."
With::lvw = "Local variable specification `1` contains `2` which is not an assignment to a symbol."
With::lvws = "Variable `1` in local variable specification `2` requires a value."
WordData::unknstag = "`2` is not valid for `1`."
WordData::unknpos = "`1` is not a valid part of speech."
XMLElement::attlhs = "`1` in `2` is not a valid name for an attribute in an XMLElement.  It must be either a String (for the localname) or a List of two Strings (for the {namespace, localname} pair)."
XMLElement::attrhs = "`1` in `2` is not a valid value for an attribute in an XMLElement.  The value of the attribute must be a String."
XMLElement::attrslst = "`1` in `2` is not a List of attributes.  The second item in an XMLElement must be a List of attributes, even if it is an empty list."
XMLElement::attrule = "`1` in `2` is not a valid attribute.  Attributes must be specified in the form \"name\" -> \"value\" or {\"namespace\",\"localname\"} -> \"value\"."
XMLElement::cnts = "`1` is not valid in the contents of an XMLElement. The contents of an XMLElement must consist of Strings and XMLElements."
XMLElement::cntsList = "`1` in `2` is not a List of contents.  The third item in an XMLElement must be a List of contents, even if it is an empty List."
XMLElement::name = "`1` in `2` is not a valid name for an XMLElement.  It must be either a String (for the localname) or a List of two Strings (for the {namespace, localname} pair)."
XMLElement::unqatt = "The attribute name (`1`) in `2` is not unique; there is already an attribute with this name in the same XMLElement.  Two attributes with the same name cannot exist inside the same element."
XMLObject::decunsv = "`1` in `2` is not a valid setting for the Version option in an XMLObject[\"Declaration\"].  The only setting that is supported is \"1.0\"."
XMLObject::decvfst = "`1` in `2` is not a Version option.  The first option to XMLObject[\"Declaration\"] must be of the form \"Version\" -> _String."
XMLObject::decvreq = "`1` has no \"Version\" option; the \"Version\" option is required to be the first item in an XMLObject[\"Declaration\"]."
XMLObject::declfst = "The XMLObject[\"Declaration\"] is not in position 1 of `1`.  If present, an XMLObject[\"Declaration\"] must be the first item in the prolog of an XMLObject[\"Document\"]."
XMLObject::docbarg = "The argument at position `1` in `2` is expected to be a `3`"
XMLObject::docep = "`1` in `2` is not allowed in the List at position 3 of an XMLObject[\"Document\"].  Only XMLObject[\"Comment\"] and XMLObject[\"ProcessingInstruction\"] are allowed."
XMLObject::docprlgi = "`1` in `2` is not allowed in the prolog of an XMLObject[\"Document\"].  Only XMLObject[\"Declaration\"], XMLObject[\"Doctype\"], XMLObject[\"Comment\"], and XMLObject[\"ProccesingInstruction\"] are allowed in the prolog."
XMLObject::dtrtstr = "`1` in `2` is not a string.  The first item in an XMLObject[\"Doctype\"] must be a string that is the name of the root element."
XMLObject::slone = "`1` in `2` is not a valid setting for the \"Standalone\" option to XMLObject[\"Declaration\"].  The option can only be set to \"yes\" or \"no\" and is case sensitive."
XMLObject::unq = "There is more than one occurrence of `1` in `2`.  `1` is required to be unique."
XMLObject::unsenc = "`1` in `2` is not a supported setting for the encoding.  The only supported encodings are UTF-8 and US-ASCII."
XML`SymbolicXMLErrors::unknobj = "`1` is not a recognized symbolic XML object.  The only valid XML objects are XMLElement and XMLObject."
XML`MathML`BoxesToSymbolicMathML::attlhs = "`1` in `2` is not a valid name for an attribute to attach to the root <math> tag.  An attribute name must be either a String (for the localname) or a List of two Strings (for the {namespace, localname} pair)."
XML`MathML`BoxesToSymbolicMathML::attrhs = "`1` in `2` is not a valid value for an attribute to attach to the root <math> tag. The value of the attribute must be a String."
XML`MathML`BoxesToSymbolicMathML::attrule = "`1` is not a valid XML attribute to attach to the root <math> tag.  Attributes must be specified in the form \"name\" -> \"value\" or {\"namespace\",\"localname\"} -> \"value\"."
XML`MathML`BoxesToSymbolicMathML::badba = "Could not translate a box expression or an annotation to SymbolicMathML. The box expression or annotation has been ignored."
XML`MathML`BoxesToSymbolicMathML::incasmml = "Internal MathML processing failure. Attributes `2` wrapped around a leaf tag `1`."
XML`MathML`BoxesToSymbolicMathML::notboxes = XML`MathML`BoxesToMathML::notboxes = "`1` is not a valid box structure. The first argument in `2` must be a valid box structure."
XML`MathML`BoxesToSymbolicMathML::uncnvbxs = "The boxes `1` are not convertible to a symbolic XML expression."
XML`MathML`BoxesToSymbolicMathML::unrecf = "The format `1` is not a recognized annotation for MathML."
XML`MathML`SymbolicMathMLToBoxes::bmml = "The `1`, `2`, occurred without a surrounding XML tag. An attempt has been made to correct this defect."
XML`MathML`SymbolicMathMLToBoxes::incrt = "The SymbolicMathML structure being interpreted has the root tag \"`1`\" instead of the correct tag \"math\"."
XML`MathML`SymbolicMathMLToBoxes::invsmml = "The structure \"`1`\" attempting to be converted to boxes is not a valid SymbolicMathML structure."
XML`MathML`SymbolicMathMLToBoxes::malsmml = "The structure \"`1`\" attempting to be converted to boxes has a malformed XML structure."
XML`MathML`SymbolicMathMLToBoxes::nmmlr = "The structure \"`1`\" attempting to be converted to boxes has the root XML tag \"`2`\", which is not a recognized MathML tag."
XML`MathML`SymbolicMathMLToBoxes::unknstrc = "`1` is not a valid MathML structure."
XML`MathML`SymbolicMathMLToBoxes::unkntag = "`1` is not a valid MathML tag. The tag `1` is being treated as a symbol."
XML`MathML`SymbolicMathMLToExpression::invsmml = "The structure \"`1`\" attempting to be converted to an expression is not a valid SymbolicMathML structure."
XML`MathML`SymbolicMathMLToExpression::malsmml = "The structure \"`1`\" attempting to be converted to an expression has a malformed XML structure."
XML`MathML`SymbolicMathMLToExpression::nmmlr = "The structure \"`1`\" attempting to be converted to an expression has the root XML tag \"`2`\", which is not a recognized MathML tag."
XML`NotebookML`NotebookToSymbolicNotebookML::badobj = "Malformed notebook fragment `1` encountered.  The fragment is being converted to SymbolicExpressionML."
XML`NotebookML`NotebookToSymbolicNotebookML::filonb = "Filename, notebook expression, or NotebookObject expected at position 1 in `1`."
XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv = "A front end is not available. A front end is necessary to translate the `1` into the `2` graphics format."
XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd = "There is no built-in conversion for BoxData objects to `1`."
XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd = "There is no built-in conversion for GraphicsData encoded as `1` to `2`."
XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns = "`1` is not in the NotebookML Namespace, it is in the null namespace. Mathematica is assuming that it was intended to be in the NotebookML Namespace."
XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes = "A NotebookML BoxData element did not contain interpretable information.  It cannot be displayed correctly."
XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx = "A NotebookML GraphicsData element did not contain interpretable information.  It cannot be displayed correctly."
XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns = "`1` is not in the NotebookML Namespace, it is in the null namespace. Mathematica is assuming that it was intended to be in the NotebookML Namespace."
XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml = "`1` is not a valid NotebookML expression."
XML`Parser`InitializeXMLParser::memfail = "XMLInit failed due to a problem allocating memory."
XML`Parser`InitializeXMLParser::nfprserr = "`1`"
XML`Parser`InitializeXMLParser::prserr = "`1`"
XML`Parser`ReleaseXMLParser::bparsr = "XMLParser object expected at position 1 in `1`"
XML`Parser`ReleaseXMLParser::ilgprsr = "XMLParser[`1`]"
XML`Parser`XMLGet::badop = "Option `1` cannot take a value of `2`.  It can only take `3`."
XML`Parser`XMLGet::ilgprsr = "XMLParser[`1`]"
XML`Parser`XMLGet::memfail = "XMLGet failed due to a problem allocating memory."
XML`Parser`XMLGet::nfprserr = "`1`"
XML`Parser`XMLGet::prserr = "`1`"
XML`Parser`XMLGet::put = "Received MathLink message `1` when generating XML output."
XML`Parser`XMLGet::unknop = "`1` is not a recognized option."
XML`Parser`XMLGet::xmlprsop = "XMLParser object or option expected at position `1` in `2`."
XML`Parser`XMLGetString::ilgprsr = "XMLParser[`1`]"
XML`Parser`XMLGetString::memfail = "XMLGetString failed due to a problem allocating memory."
XML`Parser`XMLGetString::nfprserr = "`1`"
XML`Parser`XMLGetString::prserr = "`1`"
XML`Parser`XMLGetString::xmlprsop = "XMLParser object or option expected at position `1` in `2`."
XML`SVG`GraphicsToSymbolicSVG::bdmgr = "Malformed Graphics expression may be incorrectly translated to SVG."
XML`SVG`GraphicsToSymbolicSVG::bsvgf = "Unexpected form: `1`"
XML`SVG`GraphicsToSymbolicSVG::bsvgns = "Unexpected ToSVGNumberString: `1`"
XML`SVG`GraphicsToSymbolicSVG::gtype = "`1` is not a type of graphics."
XML`SVG`GraphicsToSymbolicSVG::ncvrt = "Conversion from Graphics to SVG is missing a conversion for `1`"
XML`SVG`SymbolicSVGToGraphics::unsup = "SVG import is not currently supported."
VertexNormals::errmatrixnor = "`1` must be a 3-vector matrix of `2` by `3`."
VertexNormals::errlistnor = "`1` must be a list of 3-vectors of length `2`."
VertexColors::errmatrixcol = "`1` must be a color-valued matrix of `2` by `3`."
VertexColors::errlistcol = "`1` must be a list of colors of length `2`."
ListPlot3D::invcolor = ListDensityPlot::invcolor = ListContourPlot::invcolor = "Invalid color `1` found."
Contours::ilevels = Mesh::ilevels = "`1` is not a valid mesh specification."
Method::meth = "`1` is an invalid method option."
ContourPlot3D::incmem = "The current value of `1` bytes may not be optimal. Increase this limit using Method -> {\"MaxMemoryUse\" -> n} or reduce the number of PlotPoints or MaxRecursion."
ContourPlot3D::noalmem = "Not enough memory to construct an algebraic surface. Use Method -> {\"MaxMemoryUse\" -> n} to increase memory."
MeshShading::colshd = "Invalid style tensor found `1`. The rank must be equal to the number of mesh functions."
General::dpts = "`1` duplicated points will not be processed."
General::invpt = "Point `1` not in general position, will not be processed."
Method::maxmem = "Method option MaxMemory -> `1` must be a positive integer or Infinity. Using `2` bytes as the default."
Plot3D::invfuncs = ParametricPlot3D::invfuncs = "Malformed set of functions `1`."
Plot::invfpts = ParametricPlot::invfpts = "`1` does not evaluate to a valid function expression."
ContourPlot::invctr = ListContourPlot::invctr = "`1` must be a machine-real value."
General::invregion = "`1` must be a Boolean function."
Filling::invfillentry = "`1` must be a numerical value, a list of the form {m}, a list of the form {val,style}, or {{m},style}."
Filling::invfilling = "`1` must be Axis, Top, Bottom, Automatic, a numerical or a list of valid Filling entries."
Filling::invfillsel = "`1` must be an integer between 1 and `2`."
DensityPlot::largf = "`1` can not be a list of more than one function."
General::invefunc = "`1` must be a function f or an equality of the form f == g."
DataRange::invdrange = "`1` must be of the form {xmin, xmax}."
General::pwregion = "Using `1` for clipping. This may produce invalid results. Use Method -> {\"SymbolicPiecewiseSubdivision\" -> False}."
General::pwfailed = "Symbolic Piecewise subdivision failed to create a suitable plotting domain subdivision. Use a regular plotting procedure, Method -> {\"SymbolicPiecewiseSubdivision\" -> True} to force piecewise evaluation."
General::reflevel = "MaxRecursion must be a non-negative integer."
ClipFill::legacycf = "ClipFill is no longer a valid option. Use ClippingStyle -> `1` instead."
General::ppts = "Value of option PlotPoints -> `1` is not an integer >= 2."
ContourPlot3D::ppts = "Value of option PlotPoints -> `1` is not an integer >= 2 or a list of 3 integers {nx, ny, nz}."
ListContourPlot3D::ppts = ListSurfacePlot::ppts = "Value of option MaxPlotPoints -> `1` is not an integer >= 2 or a list of three integers {nx, ny, nz}."
DensityPlot::legacycolfunc = ParametricPlot3D::legacycolfunc = Plot3D::legacycolfunc = "Use ColorFunction to specify coloring."
SiegelTheta::invmat = "`1` must be a symmetric matrix with a positive definite imaginary part."
PadeApproximant::nser = "A simple series expansion for `1` could not be found."
PadeApproximant::sing = "The series expansion of `1` has an irrational singularity at `2`."
PadeApproximant::degnum = "The function `1` has a zero of order `2` at `3` that is greater than the requested degree of the numerator."
PadeApproximant::degden = "The function `1` has a pole of order `2` at `3` that is greater than the requested degree of the denominator."
ChineseRemainder::pilist = "The arguments to ChineseRemainder must be two lists of integers of identical length, with the second list containing only positive integers."
PowersRepresentations::ppnt = "The value `1` of argument `2` must be a positive integer."
NumberFieldClassNumber::unkn = "The class number of the number field generated by `1` is not yet available."
SquaresR::pint = PowersRepresentations::pint = "The value `1` for argument `2` must be a non-negative integer."
SquaresR::nint = PowersRepresentations::nint = "The value `1` for argument `2` must be an integer."
SquareFreeQ::invopt = "The value `1` for argument `2` must be a valid option."
MovingAverage::arg1 = "The first argument `1` must be a vector or matrix."
LinearFilter::arg1 = "The first argument `1` must be a vector or matrix."
ExponentialMovingAverage::arg1 = "The first argument `1` must be a vector or matrix."
MovingAverage::arg2 = "The second argument `1` must be a positive integer less than or equal to the length `2` of the first argument, or a vector of length less than or equal to the length of the first argument."
MovingMedian::arg2 = "The second argument `1` must be a positive integer less than or equal to the length `2` of the first argument."
MovingMedian::rpsmth = "The value `1` for the option RepeatedSmoothing must be either True or False."
MovingMedian::arg1 = "The first argument `1` must be a vector or matrix of real values."
MovingMedian::even = "The span `1` of the moving median should be odd for repeated smoothing to converge."
LinearFilter::arg2 = "The second argument `1` must be a vector, matrix, or list of matrices having the same number of columns as the first argument."
ExponentialMovingAverage::arg2 = "The value `1` for the second argument is expected to be a number or symbol."
ExponentialMovingAverage::dims2 = "The length `1` of the first element of argument 1 is not consistent with the length `2` of the second argument `3`."
BinCounts::bincls = "`1` is not a valid value for the option BinClosure. Valid values are Left, Right, or a list containing Left and Right."
BinLists::bincls = "`1` is not a valid value for the option BinClosure. Valid values are Left, Right, or a list containing Left and Right." 
BinCounts::dims = "The dimension `1` of the first argument is not the same as the number of binning specifications `2`."
BinLists::dims = "The dimension `1` of the first argument is not the same as the number of binning specifications `2`." 
BinCounts::bins = "The bin specification `1` is not a list of 2 or 3 real values."
BinLists::bins = "The bin specification `1` is not a list of 2 or 3 real values." 
BinCounts::step = "The bin step size `1` is expected to be positive."
BinLists::step = "The bin step size `1` is expected to be positive."
BinCounts::cvals = "The bin specification `1` is not a list containing real values, Infinity, and -Infinity."
BinLists::cvals = "The bin specification `1` is not a list containing real values, Infinity, and -Infinity."
BinCounts::vectmat = "The first argument is expected to be a vector or matrix."
BinLists::vectmat = "The first argument is expected to be a vector or matrix."
LengthWhile::list = "The first argument `1` is expected to be a list."
TakeWhile::list = "The first argument `1` is expected to be a list."
CentralMoment::arg1 = "The first argument `1` is expected to be a vector or matrix."
CentralMoment::vectarg2 = "The second argument `1` must be a single number or variable when the first argument is a vector."
CentralMoment::matarg2 = "The second argument `1` must be a single number, a variable, or a list of numbers or variables of length equal to the number of columns in the first argument when the first argument is a matrix."
ExpectedValue::arg2 = "The second argument `1` must be a nonempty vector or matrix."
ExpectedValue::dims = "The number of columns `1` in the second argument is not consistent with the length `2` of the third argument."
ExpectedValue::arg3 = "The third argument `1` must be a non-numerical value or a vector of non-numeric values."
JordanDecomposition::jdimp = "Unable to find the Jordan decomposition of the matrix with the given precision. Try higher precision or SchurDecomposition instead."
ExpectedValue::sum = "In the case of discrete distributions, the Assumptions option of ExpectedValue is ignored. Sum does not currently accept Assumptions."
BernoulliDistribution::probparm = "Parameter `1` is expected to be a probability between 0 and 1."
BinomialDistribution::probparm = "Parameter `1` is expected to be a probability between 0 and 1."
GeometricDistribution::probparm = "Parameter `1` is expected to be a probability between 0 and 1."
General::posint = "Parameter `1` is expected to be a positive integer."
General::realparm = "Parameter `1` is expected to be real."
HypergeometricDistribution::nngint = "Parameter `1` is expected to be a non-negative integer."
HypergeometricDistribution::nsize = "The number `1` must be less than the total number `2`."
LogSeriesDistribution::frparm = "Parameter `1` is expected to be less than 1 and non-negative."
General::posparm = "Parameter `1` is expected to be positive."
NegativeBinomialDistribution::probparm = "Parameter `1` is expected to be a nonzero probability between 0 and 1."
TriangularDistribution::midparm = "Parameter `1` is expected to be between the parameters `2` and `3`."
TriangularDistribution::endparm = "Parameter `1` is expected to be greater than parameter `2`."
UniformDistribution::posdiff = "The difference `1` is expected to be positive."
UniformDistribution::minmax = "The syntax UniformDistribution[min, max] is deprecated. Use UniformDistribution[{min, max}] instead."
UniformDistribution::arg1 = "The first argument `1` is expected to be a length two list."
TriangularDistribution::arg1 = "The first argument `1` is expected to be a list of length two."
TriangularDistribution::arg2 = "The second argument `1` is expected to be a number or symbol."
DiscreteUniformDistribution::maxparm = "The syntax DiscreteUniformDistribution[n] is deprecated. Use DiscreteUniformDistribution[{1, n}] instead."
DiscreteUniformDistribution::intparm = "The value `1` is expected to be an integer."
DiscreteUniformDistribution::nndiff = "The difference `1` is expected to be non-negative."
DiscreteUniformDistribution::arg1 = "The first argument `1` is expected to be a length two list."
InverseCDF::zipfpr = "The input precision `1` is less than the expected number of digits `2` in the desired inverse CDF. The result may contain significant numerical error."
Quantile::zipfpr = "The input precision `1` is less than the expected number of digits `2` in the desired quantile. The result may contain significant numerical error."
InverseCDF::badacc = "Warning: The value `1` given for the AccuracyGoal is not a positive number or Automatic. Setting to WorkingPrecision -10."
Quantile::badacc = "Warning: The value `1` given for the AccuracyGoal is not a positive number or Automatic. Setting to WorkingPrecision -10."
InverseCDF::badits = "Warning: MaxIterations -> `1` is not set to a positive integer; setting to `2`."
Quantile::badits = "Warning: MaxIterations -> `1` is not set to a positive integer; setting to `2`."
InverseCDF::badprec = "Warning: The value `1` given for the PrecisionGoal is not a positive number or Automatic. Setting to WorkingPrecision -10."
Quantile::badprec = "Warning: The value `1` given for the PrecisionGoal is not a positive number or Automatic. Setting to WorkingPrecision -10."
InverseCDF::badwork = "Warning: The value `1` given for the WorkingPrecision is not a positive real number. Setting to MachinePrecision."
Quantile::badwork = "Warning: The value `1` given for the WorkingPrecision is not a positive real number. Setting to MachinePrecision."
InverseCDF::over = "Warning: Numeric overflow occurred during this search. This may mean that the search is starting from an inappropriate point or that insufficient precision is being used for these calculations. The returned inverse CDF may not be correct."
Quantile::over = "Warning: Numeric overflow occurred during this search. This may mean that the search is starting from an inappropriate point or that insufficient precision is being used for these calculations. The returned quantile may not be correct."
InverseCDF::qcv = "InverseCDF failed to converge to the requested accuracy or precision for the inverse CDF within `1` iterations."
Quantile::qcv = "Quantile failed to converge to the requested accuracy or precision for the quantile within `1` iterations."
InverseCDF::qdig = "`1` working digits is insufficient to achieve the requested accuracy or precision for the inverse CDF."
Quantile::qdig = "`1` working digits is insufficient to achieve the requested accuracy or precision for the quantile."
InverseCDF::qmp = "Machine precision is insufficient to achieve the requested accuracy or precision for the inverse CDF."
Quantile::qmp = "Machine precision is insufficient to achieve the requested accuracy or precision for the quantile."
EmitSound::nofe = "A front end is not available; Sound playback requires a front end."
TrimmedMean::arg1 = "The first argument `1` is expected to be a numeric vector or matrix."
TrimmedMean::arg2 = "The second argument `1` is expected to be a non-negative number less than 0.5 or a list of two non-negative numbers that sum to less than 1."
FindClusters::rseed = "Value of option RandomSeed -> `1` is not an integer or Automatic."
FindClusters::bdmtd = "The value of option Method -> `1` is not Automatic, \"Optimize\", or \"Agglomerate\"."
FindClusters::bdst = "The value of Method option SignificanceTest -> `1` is not Automatic, \"Gap\", or \"Silhouette\"."
FindClusters::amtd = "FindClusters is unable to automatically select an appropriate dissimilarity function for the input data `1`."
FindClusters::bditr = "The value of option \"Iterations\" -> `1` should be a positive integer."
FindClusters::bdnul = "The value of option \"NullSets\" -> `1` should be a positive integer greater than 1."
FindClusters::bdtol = "The value of option \"Tolerance\" -> `1` should be a real number."
FindClusters::nclst = "The number of clusters requested (`1`) is larger than the number of elements to cluster (`2`)."
FindClusters::gap = "The data to be clustered must consist of vectors of real machine numbers to use the \"Gap\" method.  Try Method -> \"Silhouette\" instead."
FindClusters::bdlink = "Value of Agglomerate method option \"Linkage\" -> `1` is not \"Single\", \"Complete\", \"Average\", \"Weighted\", \"Centroid\", \"Median\", or \"Ward\"."
FindClusters::xnum = "A non-numeric, negative, or complex dissimilarity value was computed; dissimilarities must be non-negative and real valued."
SoundNote::invnote = "\"`1`\" is not a valid pitch specification." 
SoundNote::invinst = "\"`1`\" is not a valid style specification."
SoundNote::instnum = "Too many styles were specified. There must be at most 15 styles plus percussion."
General::dataseterr = "`1` is not a valid dataset or list of datasets."
General::updpkg = "The `1` functionality has been updated. See the compatibility page for compatibility information. Use <<Legacy`.``1` to load the legacy version."
General::markersize = "Invalid size `1`. A PlotMarker must be of the form {marker, size}."
Commonest::arg1 = "The first argument is expected to be a list."
Commonest::arg2 = "The second argument `1` is expected to be a positive integer."
Commonest::dstlms = "The requested number of elements `1` is greater than the number of distinct elements `2`. Only `2` elements will be returned."
General::obspkg = "`1` is now obsolete. The legacy version being loaded may conflict with current Mathematica functionality. See the Compatibility Guide for updating information."
General::obspkgfn = "A version of `1` from the obsolete package `2` is being used. This may conflict with current Mathematica functionality. See the Compatibility Guide for updating information."
General::newpkg = "`1` is now available as the `2`. See the Compatibility Guide for updating information."
General::exclul = "`1` must be a list of equalities or real-valued functions."
General::excluc = "`1` must be an equation, a real-valued function, or a pair of the form {func, pred}."
General::invisol = "`1` must be a list of valid 2D coordinates."
General::invisop = "`1` must be a valid 2D coordinate."
General::mppts = "Value of option MaxPlotPoints -> `1` is not Infinity, an integer >= 2, or a list."
General::axes = "Value of option Axes -> `1` is not True, False, or a length-two list of True or False."
General::axorg = "Value of option AxesOrigin -> `1` is not Automatic or a valid 2D coordinate."
General::prng = "Value of option PlotRange -> `1` is not All, Full, Automatic, a positive machine number, or an appropriate list of range specifications."
General::cfun = "Value of option ColorFunction -> `1` is not a valid named color, or a pure function that produces a valid color or gray-level directive when applied."
General::invmaxrec = "MaxRecursion must be a non-negative integer; the recursion value is limited to `2`. Using MaxRecursion -> `1`."
General::accbend = "Target bending angle of `1` not satisfied; current maximal bending angle is `2`. Increase MaxRecursion option up to MaxRecursion -> `3`."
General::invmeshf = "MeshFunctions->`1` must be a pure function or a list of pure functions."
General::invnormalf = "Value of NormalsFunction -> `1` must be a function."
General::plnr = "`1` is not a machine-size real number at `2` = `3`."
General::pptr = "`1` does not evaluate to a pair of real numbers at `2` = `3`."
General::pp3tr = "`1` does not evaluate to a triplet of real numbers at `2` = `3`."
General::nfunfail = "`1` cannot be initialized properly. Symbolic Normals, WorkingPrecision, and EvaluationMonitor will not take effect."
General::cflegacy = "ClipFill has been superseded by ClippingStyle. Use ClippingStyle -> `1` instead."
General::boolf = "`1` must be a Boolean function."
General::pwtime = "Time spent on the piecewise transformation of `1` exceeded `2` seconds, and the transformation was aborted. Increasing the value of option Method -> {\"PiecewiseTimeConstraint\" -> `2`} may improve the result."
General::pwtimec = "In \"PiecewiseTimeConstraint\" -> `1`, `1` is not a nonzero positive machine-size integer."
General::iodeg = "`1` is not a valid interpolation order specification, or the given order is too high for the input array `2`."
General::ioparam = "Invalid or incompatible interpolation properties are given."
General::iodata2 = "`1` is not a valid numerical array for curve interpolation."
General::iodata3 = "`1` is not a valid numerical matrix for surface interpolation."
General::ioproc = "`1` may contain non-machine precision numbers, complex numbers, or invalid entries."
General::valuef = "`1` must be a numerical function."
General::gmat = "`1` is not a rectangular array larger than 2 x 2."
General::invctrs = "Contours -> `1` must be a non-negative integer or a list of real contour values."
General::coldir = "`1` contains an invalid color or gray-level directives."
General::nodata = "Unable to download data for `1`."
General::olddata = "Unable to update data for `1` to the latest version."
General::network = "`1` requires active Internet connectivity."
General::timeout = "A network operation for `1` timed out. Please try again later."
Blend::arg  = "`1` is not a valid list of color or gray-level directives, or pairs of a real number and a directive."
Blend::argp = "`1` should be a real number."
Blend::argl = "`1` should be a real number or a list of non-negative numbers, which has the same length as `2`."
Blend::argm = ToColor::colconv = "`1` should be one of RGBColor, Hue, CYMKColor, or GrayLevel."
Lighter::arg = Darker::arg = "`1` is not a GrayLevel, RGBColor, Hue, or CMYKColor directive, or a list of them."
Lighter::argp = Darker::argp = "`1` is not a real number between 0 and 1."
Lighter::argm = Darker::argm = "`1` should be one of \"RGB\", \"HSL\", or \"HSL\" paired with a positive number."
General::notent = "`1` is not a known entity, class, or tag for `2`. Use `2`[] for a list of entities."
General::notprop = "`1` is not a known property for `2`. Use `2`[\"Properties\"] for a list of properties."
General::notpropx = "`1` is not a known property for `2`. Use `3`[`2`, \"Properties\"] for a list of properties."
General::notsubprop = "`1` is not a known subproperty of `2`. Use subproperty \"Properties\" for a list of subproperties."
General::meshr = "Value of DataRange -> `1` is not of the form {{xmin, xmax}, {ymin, ymax}}."
Plot3D::njnum = ParametricPlot3D::njnum = ContourPlot3D::njnum = RegionPlot3D::njnum = "The Jacobian is not a matrix of numbers at `2` = `1`."
Covariance::vctmat = "The arguments to Covariance are not a pair of vectors or a pair of matrices of equal length."
Correlation::vctmat = "The arguments to Correlation are not a pair of vectors or a pair of matrices of equal length."
Covariance::arg1 = "The first argument must be either a vector or a matrix."
Correlation::arg1 = "The first argument must be either a vector or a matrix."
Correlation::zerosd = "The standard deviation for one or more vectors or matrix columns is zero."
ExampleData::notcoll = "`1` is not a known collection for ExampleData. Use ExampleData[] for a list of collections."
ExampleData::notent = "`1` is not a known entity for the collection `2`. Use ExampleData[`2`] for a list of entities."
NotebookCompatibility`ObsolescenceNote::nos = "Automatic translation rules are not available for this case."
NotebookCompatibility`ObsolescenceNote::nosc = "Automatic translation rules are not available for this case. See the Compatibility Guide for updating information. "
NotebookCompatibility`ObsolescenceNote::err = "The following input cell could not be processed, possibly due to syntax error(s)."
NotebookCompatibility`ObsolescenceNote::spr = "As of Version 6, `1` has been superseded by `2`. "
NotebookCompatibility`ObsolescenceNote::sprm = "As of Version 6, `1` has been superseded by `2` and `3`. "
NotebookCompatibility`ObsolescenceNote::sprf = "As of Version 6, `1` and `2` have been superseded by `3`. "
NotebookCompatibility`ObsolescenceNote::smcln = "`1` is terminated by a semicolon. Graphics output will be suppressed if it is not removed."
NotebookCompatibility`ObsolescenceNote::pldrn = "As of Version 6, the polyhedron functions previously available through the `1` package have been superseded by `2`. "
NotebookCompatibility`ObsolescenceNote::psc = "As of Version 6, the graphics primitive PostScript is no longer supported."
NotebookCompatibility`ObsolescenceNote::obs = "As of Version 6, `1` is no longer supported. "
NotebookCompatibility`ObsolescenceNote::shad = "As of Version 6, the argument to `1` specifying shading has been superseded by the options `2` and `3`. "
General::datainst = "Installing data from Wolfram Research data server ..."
General::datainstx = "Installing data from Wolfram Research data server (`1`%)"
General::dataupd = "Updating data from Wolfram Research data server ..."
General::dataupdx = "Updating data from Wolfram Research data server (`1`%)"
General::datainit = "Initializing `1` indices ..."
General::invnump = "`1` contains an invalid parameter reference."
General::ntri = "The data generates an inconsistent triangulation. You can perturb the data to make it valid."
General::dloff = "Mathematica is currently configured not to use the internet, and could not download data for `1`. To allow internet access, use Help > Internet Connectivity..."
General::dlfail = "Internet download of data for `1` failed.  Use Help > Internet Connectivity... to test or reconfigure internet connectivity."
General::dlrefused = "Data update refused.  See http://www.wolfram.com/datarefused for more information."
