(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8871,        299]
NotebookOptionsPosition[      6744,        232]
NotebookOutlinePosition[      7872,        262]
CellTagsIndexPosition[      7829,        259]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Creating User Interfaces in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#17034"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Creating User Interfaces in .NET/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RemoveEventHandler" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/ref/RemoveEventHandler"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RemoveEventHandler\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AddEventHandler", "ObjectName",
 CellID->8993],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AddEventHandler", "[", 
       RowBox[{
        StyleBox[
         RowBox[{"obj", "@", "event"}], "TI"], ",", 
        StyleBox["func", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assigns the specified ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " function ",
     Cell[BoxData[
      StyleBox["func", "TI"]], "InlineFormula"],
     " to be called when the given event ",
     Cell[BoxData[
      StyleBox["event", "TI"]], "InlineFormula"],
     " fires."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2054]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["AddEventHandler"], "InlineFormula"],
 " can be used to wire up ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " callbacks for events in .NET user interfaces, such as a button click."
}], "Notes",
 CellID->1657809003],

Cell["The following options can be given:", "Notes",
 CellID->8394],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "SendDelegateArguments", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[TextData[{
     "which delegate arguments to send to the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " event handler function"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "CallsUnshare", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether or not your event handler function calls the advanced function \
",
     Cell[BoxData["UnshareKernel"], "InlineFormula"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->29204],

Cell[TextData[{
 "The function argument can be a string, a symbol naming a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, or a pure function, and it will be called with whatever \
arguments the event sends."
}], "Notes",
 CellID->1343077243],

Cell[TextData[{
 Cell[BoxData["AddEventHandler"], "InlineFormula"],
 " returns a delegate object that can be passed to ",
 Cell[BoxData[
  ButtonBox["RemoveEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/RemoveEventHandler"]], "InlineFormula"],
 " to remove the callback function."
}], "Notes",
 CellID->898609484],

Cell[TextData[{
 "Alternatively, use ",
 Cell[BoxData[
  ButtonBox["NETNewDelegate",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNewDelegate"]], "InlineFormula"],
 " to manually create a delegate and pass that as the second argument instead \
of the function."
}], "Notes",
 CellID->1824591884]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->2643],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["RemoveEventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/RemoveEventHandler"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->21827]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->5542],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Creating User Interfaces in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#17034"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#17034"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#17034"]
}], "Tutorials",
 CellID->26124]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AddEventHandler - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "AddEventHandler", "summary" -> 
    "AddEventHandler[obj@event, func] assigns the specified Mathematica \
function func to be called when the given event event fires.", "uri" -> 
    "NETLink/ref/AddEventHandler", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"add event handler"}, "status" -> "None",
     "built" -> "{2007, 4, 18, 11, 13, 14.5666874}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1506, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2129, 67, 52, 1, 70, "ObjectName",
 CellID->8993],
Cell[2184, 70, 747, 24, 70, "Usage",
 CellID->2054]
}, Open  ]],
Cell[CellGroupData[{
Cell[2968, 99, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3427, 115, 253, 7, 70, "Notes",
 CellID->1657809003],
Cell[3683, 124, 67, 1, 70, "Notes",
 CellID->8394],
Cell[3753, 127, 889, 24, 70, "3ColumnTableMod",
 CellID->29204],
Cell[4645, 153, 259, 7, 70, "Notes",
 CellID->1343077243],
Cell[4907, 162, 338, 9, 70, "Notes",
 CellID->898609484],
Cell[5248, 173, 310, 9, 70, "Notes",
 CellID->1824591884]
}, Closed]],
Cell[CellGroupData[{
Cell[5595, 187, 49, 1, 70, "SeeAlsoSection",
 CellID->2643],
Cell[5647, 190, 224, 6, 70, "SeeAlso",
 CellID->21827]
}, Open  ]],
Cell[CellGroupData[{
Cell[5908, 201, 52, 1, 70, "TutorialsSection",
 CellID->5542],
Cell[5963, 204, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[6244, 215, 458, 12, 70, "Tutorials",
 CellID->26124]
}, Open  ]],
Cell[6717, 230, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

