(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11370,        353]
NotebookOptionsPosition[      8923,        285]
NotebookOutlinePosition[     10456,        320]
CellTagsIndexPosition[     10413,        317]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{".NET/Link User Guide" :> 
         Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
         "Calling DLLs from Mathematica in .NET/Link User Guide" :> 
         Documentation`HelpLookup[
          "paclet:NETLink/tutorial/CallingNETFromMathematica#32076"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
      2->"\<\"Calling DLLs from Mathematica in .NET/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DefineDLLFunction", "ObjectName",
 CellID->20598],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DefineDLLFunction", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"func\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"dll\", \"TI\"]\)\>\"", ",", 
        StyleBox["rtype", "TI"], ",", 
        StyleBox["atypes", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " function that calls the specified function ",
     Cell[BoxData[
      StyleBox["func", "TI"]], "InlineFormula"],
     " with argument types ",
     Cell[BoxData[
      StyleBox["atypes", "TI"]], "InlineFormula"],
     " and return type ",
     Cell[BoxData[
      StyleBox["rtype", "TI"]], "InlineFormula"],
     " in the specified unmanaged DLL ",
     Cell[BoxData[
      StyleBox["dll", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DefineDLLFunction", "[", "\"\<\!\(\*
StyleBox[\"declaration\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]lets you write a full C#-syntax ",
     StyleBox["'extern'", "InlineCode"],
     " function declaration. Use this form when you need to write a complex \
function declaration that requires features not available using options to ",
     Cell[BoxData["DefineDLLFunction"], "InlineFormula"],
     ", such as specific ",
     StyleBox["\"MarshalAs\"", "InlineCode"],
     " attributes on each of the parameters."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31042]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->22808],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[ButtonBox[
    "CallingConvention",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/CallingConvention"], "MR"]], 
     "TableText"], Cell[TextData[Cell[BoxData[
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]], "InlineFormula"]], "TableText"], 
    Cell[TextData[{
     "the calling convention expected by the DLL function (possible values \
are \"",
     StyleBox["StdCall", "MR"],
     "\", \"",
     StyleBox["CDecl", "MR"],
     "\", \"",
     StyleBox["ThisCall", "MR"],
     "\", and ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     ".)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[ButtonBox[
    "MarshalStringsAs",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/MarshalStringsAs"], "MR"]], "TableText"],
     Cell[TextData[{
     "\"",
     StyleBox["ANSI", "MR"],
     "\""
    }], "TableText"], Cell[TextData[{
     "how string arguments (char*, string, String) should be marshaled to and \
from the DLL function (possible values are \"",
     StyleBox["ANSI", "MR"],
     "\", \"",
     StyleBox["Unicode", "MR"],
     "\", and ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[ButtonBox[
    "ReferencedAssemblies",
     BaseStyle->"Link",
     ButtonData->"paclet:NETLink/ref/ReferencedAssemblies"], "MR"]], 
     "TableText"], Cell[TextData[Cell[BoxData[
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]], "InlineFormula"]], "TableText"], 
    Cell["\<\
a list of the names of assemblies referenced by your declaration\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->32277],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["atypes", "TI"]], "InlineFormula"],
 " argument is a list of type specifications for the arguments, and can be \
omitted if the function takes no arguments."
}], "Notes",
 CellID->1978592897],

Cell[TextData[{
 "The argument type and return type specifications are strings or, less \
commonly, ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " expressions."
}], "Notes",
 CellID->494312216],

Cell[TextData[{
 "Strings can be given in C-style syntax (such as ",
 Cell[BoxData["\"\<char*\>\""], "InlineFormula"],
 "), C#-syntax (",
 Cell[BoxData["\"\<string\>\""], "InlineFormula"],
 "), Visual Basic .NET syntax (",
 Cell[BoxData["\"\<ByVal As String\>\""], "InlineFormula"],
 "), or by using many Windows API types (such as ",
 Cell[BoxData["\"\<HWND\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DWORD\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<BOOL\>\""], "InlineFormula"],
 ", and so on)."
}], "Notes",
 CellID->1438667716],

Cell[TextData[{
 "Priority is given to the C interpretation of type names, so ",
 Cell[BoxData["char"], "InlineFormula"],
 " and ",
 Cell[BoxData["long"], "InlineFormula"],
 " have their meanings in C (1 and 4 bytes, respectively), not C#."
}], "Notes",
 CellID->1169921239],

Cell[TextData[{
 "You need to give the full pathname to the DLL if it is not located in a \
standard location (standard locations are a directory on your system ",
 StyleBox["PATH", "InlineCode"],
 " or a DLL subdirectory in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " application directory, such as ",
 "$InstallationDirectory\\AddOns\\Applications\\SomeApp\\DLL",
 ")."
}], "Notes",
 CellID->505991941]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->2066],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Calling DLLs from ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#32076"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#32076"],
  FontSlant->"Italic"],
 ButtonBox[" in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#32076"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#32076"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#32076"]
}], "Tutorials",
 CellID->27633]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DefineDLLFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "DefineDLLFunction", "summary" -> 
    "DefineDLLFunction[\"  func\", \"  dll\", rtype, atypes] returns a \
Mathematica function that calls the specified function func with argument \
types atypes and return type rtype in the specified unmanaged DLL dll.  \
DefineDLLFunction[\"  declaration\"] lets you write a full C#-syntax 'extern' \
function declaration. Use this form when you need to write a complex function \
declaration that requires features not available using options to \
DefineDLLFunction, such as specific \"MarshalAs\" attributes on each of the \
parameters.", "uri" -> "NETLink/ref/DefineDLLFunction", "type" -> "Symbol", 
    "label" -> "N E T Link Symbol", "paclet" -> "NETLink", "context" -> 
    "NETLink`", "keywords" -> {}, "synonyms" -> {"define function"}, "status" -> 
    "None", "built" -> "{2007, 4, 18, 11, 13, 28.3587194}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 913, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1536, 50, 55, 1, 70, "ObjectName",
 CellID->20598],
Cell[1594, 53, 1641, 44, 70, "Usage",
 CellID->31042]
}, Open  ]],
Cell[CellGroupData[{
Cell[3272, 102, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3731, 118, 68, 1, 70, "Notes",
 CellID->22808],
Cell[3802, 121, 2218, 62, 70, "3ColumnTableMod",
 CellID->32277],
Cell[6023, 185, 242, 7, 70, "Notes",
 CellID->1978592897],
Cell[6268, 194, 277, 9, 70, "Notes",
 CellID->494312216],
Cell[6548, 205, 547, 15, 70, "Notes",
 CellID->1438667716],
Cell[7098, 222, 274, 7, 70, "Notes",
 CellID->1169921239],
Cell[7375, 231, 417, 11, 70, "Notes",
 CellID->505991941]
}, Closed]],
Cell[CellGroupData[{
Cell[7829, 247, 52, 1, 70, "TutorialsSection",
 CellID->2066],
Cell[7884, 250, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[8165, 261, 716, 19, 70, "Tutorials",
 CellID->27633]
}, Open  ]],
Cell[8896, 283, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

