(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7095,        250]
NotebookOptionsPosition[      5241,        191]
NotebookOutlinePosition[      6333,        221]
CellTagsIndexPosition[      6290,        218]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Complex Numbers in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#21660"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Complex Numbers in .NET/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetComplexType" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/SetComplexType"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"SetComplexType\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GetComplexType", "ObjectName",
 CellID->1447],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GetComplexType", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the .NET type that is currently mapped to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " ",
     Cell[BoxData[
      ButtonBox["Complex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
     " numbers."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6868]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " when no type has yet been designated via ",
 Cell[BoxData[
  ButtonBox["SetComplexType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SetComplexType"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3939],

Cell[TextData[{
 "This type will be used when ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers are sent to .NET, and objects of this type will be converted to ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " when sent to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->329008090]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->14712],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["SetComplexType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/SetComplexType"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->24707]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->11999],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Complex Numbers in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#21660"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#21660"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#21660"]
}], "Tutorials",
 CellID->19615]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GetComplexType - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "GetComplexType", "summary" -> 
    "GetComplexType[] returns the .NET type that is currently mapped to \
Mathematica Complex numbers.", "uri" -> "NETLink/ref/GetComplexType", "type" -> 
    "Symbol", "label" -> "N E T Link Symbol", "paclet" -> "NETLink", 
    "context" -> "NETLink`", "keywords" -> {}, 
    "synonyms" -> {"get complex type"}, "status" -> "None", "built" -> 
    "{2007, 4, 18, 11, 13, 49.5125114}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1473, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2096, 67, 51, 1, 70, "ObjectName",
 CellID->1447],
Cell[2150, 70, 597, 19, 70, "Usage",
 CellID->6868]
}, Open  ]],
Cell[CellGroupData[{
Cell[2784, 94, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3243, 110, 358, 13, 70, "Notes",
 CellID->3939],
Cell[3604, 125, 466, 16, 70, "Notes",
 CellID->329008090]
}, Closed]],
Cell[CellGroupData[{
Cell[4107, 146, 50, 1, 70, "SeeAlsoSection",
 CellID->14712],
Cell[4160, 149, 216, 6, 70, "SeeAlso",
 CellID->24707]
}, Open  ]],
Cell[CellGroupData[{
Cell[4413, 160, 53, 1, 70, "TutorialsSection",
 CellID->11999],
Cell[4469, 163, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[4750, 174, 449, 12, 70, "Tutorials",
 CellID->19615]
}, Open  ]],
Cell[5214, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

