(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8647,        287]
NotebookOptionsPosition[      6530,        224]
NotebookOutlinePosition[      7819,        256]
CellTagsIndexPosition[      7776,        253]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Reference Counts and Memory Management in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#14400"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Reference Counts and Memory Management in .NET/Link User Guide\
\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReleaseNETObject" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/ReleaseNETObject"], 
          "NETBlock" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/NETBlock"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ReleaseNETObject\"\>", 
       2->"\<\"NETBlock\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KeepNETObject", "ObjectName",
 CellID->7326],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KeepNETObject", "[", 
       StyleBox["object", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]causes the specified object(s) not to be released when \
the current ",
     Cell[BoxData[
      ButtonBox["NETBlock",
       BaseStyle->"Link",
       ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
     " ends. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KeepNETObject", "[", 
       RowBox[{
        StyleBox["object", "TI"], 
        StyleBox[",", "TI"], 
        StyleBox[" ", "TI"], 
        ButtonBox["Manual",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Manual"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]causes the specified object to escape from all \
enclosing ",
     Cell[BoxData[
      ButtonBox["NETBlock",
       BaseStyle->"Link",
       ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
     " expressions, meaning that the object will only be released if you \
manually call ",
     Cell[BoxData[
      ButtonBox["ReleaseNETObject",
       BaseStyle->"Link",
       ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14017]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["KeepNETObject"], "InlineFormula"],
 " allows an object to \"escape\" from the current ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10180],

Cell["\<\
It only has an effect if the object was in fact slated to be released by that \
block.\
\>", "Notes",
 CellID->204693402],

Cell[TextData[{
 "The object is promoted to the \"release\" list of the next-enclosing ",
 Cell[BoxData[
  ButtonBox["NETBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETBlock"]], "InlineFormula"],
 ", if there is one. The object will be released when that block ends (unless \
",
 Cell[BoxData["KeepNETObject"], "InlineFormula"],
 " is called again in the outer block)."
}], "Notes",
 CellID->563874625]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->3700],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseNETObject",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/ReleaseNETObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NETBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/NETBlock"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15622]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30057],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Reference Counts and Memory Management in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#14400"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#14400"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#14400"]
}], "Tutorials",
 CellID->2028983154]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KeepNETObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "KeepNETObject", "summary" -> 
    "KeepNETObject[object] causes the specified object(s) not to be released \
when the current NETBlock ends. KeepNETObject[object, Manual] causes the \
specified object to escape from all enclosing NETBlock expressions, meaning \
that the object will only be released if you manually call ReleaseNETObject.",
     "uri" -> "NETLink/ref/KeepNETObject", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"keep object"}, "status" -> "None", 
    "built" -> "{2007, 4, 18, 11, 14, 2.1627194}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1640, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2263, 69, 50, 1, 70, "ObjectName",
 CellID->7326],
Cell[2316, 72, 1413, 42, 70, "Usage",
 CellID->14017]
}, Open  ]],
Cell[CellGroupData[{
Cell[3766, 119, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4225, 135, 280, 9, 70, "Notes",
 CellID->10180],
Cell[4508, 146, 131, 4, 70, "Notes",
 CellID->204693402],
Cell[4642, 152, 423, 11, 70, "Notes",
 CellID->563874625]
}, Closed]],
Cell[CellGroupData[{
Cell[5102, 168, 49, 1, 70, "SeeAlsoSection",
 CellID->3700],
Cell[5154, 171, 483, 17, 70, "SeeAlso",
 CellID->15622]
}, Open  ]],
Cell[CellGroupData[{
Cell[5674, 193, 53, 1, 70, "TutorialsSection",
 CellID->30057],
Cell[5730, 196, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[6011, 207, 477, 12, 70, "Tutorials",
 CellID->2028983154]
}, Open  ]],
Cell[6503, 222, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

