(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9109,        284]
NotebookOptionsPosition[      6565,        216]
NotebookOutlinePosition[      8346,        255]
CellTagsIndexPosition[      8303,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Loading .NET Assemblies and Types in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#1113"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Loading .NET Assemblies and Types in .NET/Link User \
Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LoadNETType" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/LoadNETType"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"LoadNETType\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LoadNETAssembly", "ObjectName",
 CellID->2491],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LoadNETAssembly", "[", 
       StyleBox["assembly", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]loads the specified assembly into the .NET runtime and \
returns a ",
     Cell[BoxData[
      ButtonBox["NETAssembly",
       BaseStyle->"Link",
       ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
     " expression that can be used to identify the assembly. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LoadNETAssembly", "[", "\"\<\!\(\*
StyleBox[\"directory\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]loads all the assemblies in the given directory and \
returns a list of ",
     Cell[BoxData[
      ButtonBox["NETAssembly",
       BaseStyle->"Link",
       ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
     " expressions."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LoadNETAssembly", "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]loads all the assemblies in the \"assembly\" \
subdirectory of the main application directory corresponding to the given \
context."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LoadNETAssembly", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"directory\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]loads the named assembly from the given directory, if \
possible. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LoadNETAssembly", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]loads the named assembly from the \"assembly\" \
subdirectory of the main application directory corresponding to the given \
context, if possible."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->27934]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["assembly", "TI"]], "InlineFormula"],
 " argument can be a simple name like \"System.Web\", a full name like \
\"System.Web, Version=1.0.5000.0, Culture=neutral, \
PublicKeyToken=b03f5f7f11d50a3a\", or a path or URL to the assembly file \
itself."
}], "Notes",
 CellID->502086351],

Cell[TextData[{
 "Multiple calls of ",
 Cell[BoxData["LoadNETAssembly"], "InlineFormula"],
 " on an already loaded assembly will return quickly."
}], "Notes",
 CellID->18752]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->13331],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->21901]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->18983],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Loading .NET Assemblies and Types in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#1113"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#1113"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#1113"]
}], "Tutorials",
 CellID->8550]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LoadNETAssembly - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "LoadNETAssembly", "summary" -> 
    "LoadNETAssembly[assembly] loads the specified assembly into the .NET \
runtime and returns a NETAssembly expression that can be used to identify the \
assembly. LoadNETAssembly[\"  directory\"] loads all the assemblies in the \
given directory and returns a list of NETAssembly expressions.  \
LoadNETAssembly[\"  StyleBox[  context`]\"] loads all the assemblies in the \
\"assembly\" subdirectory of the main application directory corresponding to \
the given context.  LoadNETAssembly[\"  name\", \"  directory\"] loads the \
named assembly from the given directory, if possible. LoadNETAssembly[\"  \
name\", \"  StyleBox[  context`]\"] loads the named assembly from the \
\"assembly\" subdirectory of the main application directory corresponding to \
the given context, if possible.", "uri" -> "NETLink/ref/LoadNETAssembly", 
    "type" -> "Symbol", "label" -> "N E T Link Symbol", "paclet" -> "NETLink",
     "context" -> "NETLink`", "keywords" -> {}, 
    "synonyms" -> {"load assembly"}, "status" -> "None", "built" -> 
    "{2007, 4, 18, 11, 14, 16.5857594}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1499, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2122, 67, 52, 1, 70, "ObjectName",
 CellID->2491],
Cell[2177, 70, 2205, 59, 70, "Usage",
 CellID->27934]
}, Open  ]],
Cell[CellGroupData[{
Cell[4419, 134, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4878, 150, 331, 9, 70, "Notes",
 CellID->502086351],
Cell[5212, 161, 174, 5, 70, "Notes",
 CellID->18752]
}, Closed]],
Cell[CellGroupData[{
Cell[5423, 171, 50, 1, 70, "SeeAlsoSection",
 CellID->13331],
Cell[5476, 174, 210, 6, 70, "SeeAlso",
 CellID->21901]
}, Open  ]],
Cell[CellGroupData[{
Cell[5723, 185, 53, 1, 70, "TutorialsSection",
 CellID->18983],
Cell[5779, 188, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[6060, 199, 463, 12, 70, "Tutorials",
 CellID->8550]
}, Open  ]],
Cell[6538, 214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

