(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9683,        315]
NotebookOptionsPosition[      7435,        245]
NotebookOutlinePosition[      8636,        276]
CellTagsIndexPosition[      8593,        273]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Loading .NET Assemblies and Types in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#1113"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Loading .NET Assemblies and Types in .NET/Link User \
Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LoadNETAssembly" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/LoadNETAssembly"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"LoadNETAssembly\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/CallingExternalPrograms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Calling External Programs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LoadNETType", "ObjectName",
 CellID->23535],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LoadNETType", "[", "\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]loads the specified type into the .NET runtime and \
returns a ",
     Cell[BoxData[
      ButtonBox["NETType",
       BaseStyle->"Link",
       ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
     " expression that can be used to identify the type."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LoadNETType", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", ",", " ", 
        StyleBox["assembly", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]loads the type from the given assembly. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23666]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["LoadNETType"], "InlineFormula"],
 " can load any of the types defined in .NET: classes, interfaces, structs \
(value types), enumerations, and delegates. The assembly in which the type is \
defined must have previously been loaded using ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->413296334],

Cell["The following options can be given:", "Notes",
 CellID->3092],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "StaticsVisible", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
make static methods and fields accessible by just their names, not in a \
special context\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "AllowShortContext", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
make static methods and fields accessible only in the context that mirrors \
the full hierarchical namespace name\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1882],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["assembly", "TI"]], "InlineFormula"],
 " argument can be an assembly name, a ",
 Cell[BoxData[
  ButtonBox["NETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
 " expression, a .NET Assembly object, or a path or URL to an assembly file. \
If it is an assembly name, the assembly must already have been loaded."
}], "Notes",
 CellID->1102052194]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->6444],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->22070]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->24049],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Loading .NET Assemblies and Types in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#1113"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#1113"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#1113"]
}], "Tutorials",
 CellID->8550]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->54654242],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->142763856]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LoadNETType - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "LoadNETType", "summary" -> 
    "LoadNETType[\"  type\"] loads the specified type into the .NET runtime \
and returns a NETType expression that can be used to identify the type.  \
LoadNETType[\"  type\", assembly] loads the type from the given assembly. ", 
    "uri" -> "NETLink/ref/LoadNETType", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"load type"}, "status" -> "None", 
    "built" -> "{2007, 4, 18, 11, 14, 19.1899194}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2111, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2734, 83, 49, 1, 70, "ObjectName",
 CellID->23535],
Cell[2786, 86, 933, 26, 70, "Usage",
 CellID->23666]
}, Open  ]],
Cell[CellGroupData[{
Cell[3756, 117, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4215, 133, 449, 11, 70, "Notes",
 CellID->413296334],
Cell[4667, 146, 67, 1, 70, "Notes",
 CellID->3092],
Cell[4737, 149, 804, 21, 70, "3ColumnTableMod",
 CellID->1882],
Cell[5544, 172, 448, 12, 70, "Notes",
 CellID->1102052194]
}, Closed]],
Cell[CellGroupData[{
Cell[6029, 189, 49, 1, 70, "SeeAlsoSection",
 CellID->6444],
Cell[6081, 192, 218, 6, 70, "SeeAlso",
 CellID->22070]
}, Open  ]],
Cell[CellGroupData[{
Cell[6336, 203, 53, 1, 70, "TutorialsSection",
 CellID->24049],
Cell[6392, 206, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[6673, 217, 463, 12, 70, "Tutorials",
 CellID->8550]
}, Open  ]],
Cell[CellGroupData[{
Cell[7173, 234, 57, 1, 70, "MoreAboutSection",
 CellID->54654242],
Cell[7233, 237, 160, 3, 70, "MoreAbout",
 CellID->142763856]
}, Open  ]],
Cell[7408, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

