(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6584,        233]
NotebookOptionsPosition[      4778,        175]
NotebookOutlinePosition[      5821,        204]
CellTagsIndexPosition[      5778,        201]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\".NET/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LoadNETType" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/LoadNETType"], 
          "LoadNETAssembly" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/LoadNETAssembly"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"LoadNETType\"\>", 
       2->"\<\"LoadNETAssembly\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NETAssembly", "ObjectName",
 CellID->16678],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETAssembly", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a .NET assembly with the specified name."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30942]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["NETAssembly"], "InlineFormula"],
 " expressions can be used in ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 " to specify the assembly from which you want to load the type."
}], "Notes",
 CellID->20145],

Cell[TextData[{
 Cell[BoxData["NETAssembly"], "InlineFormula"],
 " expressions cannot be typed in by the user; they are returned by ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->606564639],

Cell["\<\
The second argument is an integer index that is not relevant to users.\
\>", "Notes",
 CellID->1499009473]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->7426],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LoadNETType",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/LoadNETType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LoadNETAssembly",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/LoadNETAssembly"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19387]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->17330],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NETAssembly - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "NETAssembly", "summary" -> 
    "NETAssembly[\"  name\", n] represents a .NET assembly with the specified \
name.", "uri" -> "NETLink/ref/NETAssembly", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 18, 11, 14, 27.2427834}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1381, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2004, 65, 49, 1, 70, "ObjectName",
 CellID->16678],
Cell[2056, 68, 478, 14, 70, "Usage",
 CellID->30942]
}, Open  ]],
Cell[CellGroupData[{
Cell[2571, 87, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3030, 103, 324, 9, 70, "Notes",
 CellID->20145],
Cell[3357, 114, 313, 9, 70, "Notes",
 CellID->606564639],
Cell[3673, 125, 116, 3, 70, "Notes",
 CellID->1499009473]
}, Closed]],
Cell[CellGroupData[{
Cell[3826, 133, 49, 1, 70, "SeeAlsoSection",
 CellID->7426],
Cell[3878, 136, 487, 17, 70, "SeeAlso",
 CellID->19387]
}, Open  ]],
Cell[CellGroupData[{
Cell[4402, 158, 53, 1, 70, "TutorialsSection",
 CellID->17330],
Cell[4458, 161, 278, 9, 70, "Tutorials",
 CellID->608907033]
}, Open  ]],
Cell[4751, 173, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

