(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11409,        365]
NotebookOptionsPosition[      8875,        293]
NotebookOutlinePosition[     10467,        330]
CellTagsIndexPosition[     10424,        327]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Creating Objects in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#7716"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Creating Objects in .NET/Link User Guide\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LoadNETType" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/LoadNETType"], 
          "LoadNETAssembly" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/LoadNETAssembly"], 
          "MakeNETObject" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/MakeNETObject"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"LoadNETType\"\>", 
       2->"\<\"LoadNETAssembly\"\>", 
       3->"\<\"MakeNETObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/CallingExternalPrograms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Calling External Programs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NETNew", "ObjectName",
 CellID->21540],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETNew", "[", 
       StyleBox["type", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]constructs a new object of the specified .NET type.  "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETNew", "[", 
       StyleBox[
        RowBox[{"type", ",", "args"}], "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]constructs a new object of the specified .NET type, \
passing the supplied argument sequence to the constructor."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETNew", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", ",", 
          StyleBox["assembly", "TI"]}], "}"}], ",", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs the object from the named type in the \
specified assembly. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETNew", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"assembly\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\""}], "}"}], ",", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses the named assembly from the specified directory, \
if possible."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETNew", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"assembly\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"context\", \"TI\"]\)\>\""}], "}"}], ",", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses the named assembly from the \"assembly\" \
subdirectory of the main application directory corresponding to the given \
context, if possible."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["type", "TI"]], "InlineFormula"],
 " argument can be either a ",
 Cell[BoxData[
  ButtonBox["NETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETType"]], "InlineFormula"],
 " expression that was returned from ",
 Cell[BoxData[
  ButtonBox["LoadNETType",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETType"]], "InlineFormula"],
 ", or a string giving the type's name. The assembly in which the type \
resides must have been loaded with ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->646101310],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["assembly", "TI"]], "InlineFormula"],
 " argument can be an assembly name, a ",
 Cell[BoxData[
  ButtonBox["NETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETAssembly"]], "InlineFormula"],
 " expression returned from ",
 Cell[BoxData[
  ButtonBox["LoadNETAssembly",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/LoadNETAssembly"]], "InlineFormula"],
 ", or a path or URL to an assembly file. The assembly will be loaded if \
necessary."
}], "Notes",
 CellID->1347397938]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->24339],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LoadNETType",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/LoadNETType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LoadNETAssembly",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/LoadNETAssembly"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeNETObject",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/MakeNETObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25220759]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->31486],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Creating Objects in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7716"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7716"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7716"]
}], "Tutorials",
 CellID->5996]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->371806209],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->243046140]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NETNew - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "NETNew", "summary" -> 
    "NETNew[type] constructs a new object of the specified .NET type. \
NETNew[type, args] constructs a new object of the specified .NET type, \
passing the supplied argument sequence to the constructor.  NETNew[{\"  \
type\", assembly}, args] constructs the object from the named type in the \
specified assembly. NETNew[{\"  type\", \"  assembly\", \"  dir\"}, args] \
uses the named assembly from the specified directory, if possible.  \
NETNew[{\"  type\", \"  assembly\", \"  context\"}, args] uses the named \
assembly from the \"assembly\" subdirectory of the main application directory \
corresponding to the given context, if possible.", "uri" -> 
    "NETLink/ref/NETNew", "type" -> "Symbol", "label" -> "N E T Link Symbol", 
    "paclet" -> "NETLink", "context" -> "NETLink`", "keywords" -> {}, 
    "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 18, 11, 14, 37.5692794}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2341, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2964, 88, 44, 1, 70, "ObjectName",
 CellID->21540],
Cell[3011, 91, 2143, 59, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5191, 155, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5650, 171, 703, 22, 70, "Notes",
 CellID->646101310],
Cell[6356, 195, 556, 17, 70, "Notes",
 CellID->1347397938]
}, Closed]],
Cell[CellGroupData[{
Cell[6949, 217, 50, 1, 70, "SeeAlsoSection",
 CellID->24339],
Cell[7002, 220, 753, 26, 70, "SeeAlso",
 CellID->25220759]
}, Open  ]],
Cell[CellGroupData[{
Cell[7792, 251, 53, 1, 70, "TutorialsSection",
 CellID->31486],
Cell[7848, 254, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[8129, 265, 446, 12, 70, "Tutorials",
 CellID->5996]
}, Open  ]],
Cell[CellGroupData[{
Cell[8612, 282, 58, 1, 70, "MoreAboutSection",
 CellID->371806209],
Cell[8673, 285, 160, 3, 70, "MoreAbout",
 CellID->243046140]
}, Open  ]],
Cell[8848, 291, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

