(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8213,        271]
NotebookOptionsPosition[      6182,        208]
NotebookOutlinePosition[      7337,        238]
CellTagsIndexPosition[      7294,        235]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Returning Objects \[OpenCurlyDoubleQuote]By Value\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]By Reference\
\[CloseCurlyDoubleQuote] in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#18481"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Returning Objects \[OpenCurlyDoubleQuote]By Value\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]By Reference\
\[CloseCurlyDoubleQuote] in .NET/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReturnAsNetObject" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/ref/ReturnAsNETObject"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ReturnAsNetObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NETObjectToExpression", "ObjectName",
 CellID->20440],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NETObjectToExpression", "[", 
       StyleBox["netObject", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]converts the specified .NET object reference into its \
value as a \"native\" ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4234]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Most .NET objects that have a meaningful \"by value\" representation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are returned by value to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically. Such objects include strings, arrays (which become lists), \
and so-called \"boxed\" values like System.Int32."
}], "Notes",
 CellID->32232],

Cell[TextData[{
 "To get a reference form of one of these types, use ",
 Cell[BoxData[
  ButtonBox["NETNew",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/NETNew"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ReturnAsNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReturnAsNETObject"]], "InlineFormula"],
 ". In such cases, you can use ",
 Cell[BoxData["NETObjectToExpression"], "InlineFormula"],
 " to retrieve the value."
}], "Notes",
 CellID->142486463],

Cell[TextData[{
 Cell[BoxData["NETObjectToExpression"], "InlineFormula"],
 " also converts into values some types that are normally sent by reference, \
such as converting ",
 StyleBox["enum", "MR"],
 " objects to integer values and collections into lists."
}], "Notes",
 CellID->78481417],

Cell[TextData[{
 Cell[BoxData["NETObjectToExpression"], "InlineFormula"],
 " has no effect on object references that have no meaningful \"by value\" \
representation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->261924828]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->6369],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ReturnAsNetObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReturnAsNETObject"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->8468]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->3812],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Returning Objects \[OpenCurlyDoubleQuote]By Value\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]By Reference\
\[CloseCurlyDoubleQuote] in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#18481"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#18481"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#18481"]
}], "Tutorials",
 CellID->23131]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NETObjectToExpression - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "NETObjectToExpression", "summary" -> 
    "NETObjectToExpression[netObject] converts the specified .NET object \
reference into its value as a \"native\" Mathematica expression. ", "uri" -> 
    "NETLink/ref/NETObjectToExpression", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"object to expression"}, "status" -> 
    "None", "built" -> "{2007, 4, 18, 11, 14, 42.4671034}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1735, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2358, 70, 59, 1, 70, "ObjectName",
 CellID->20440],
Cell[2420, 73, 530, 16, 70, "Usage",
 CellID->4234]
}, Open  ]],
Cell[CellGroupData[{
Cell[2987, 94, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3446, 110, 380, 10, 70, "Notes",
 CellID->32232],
Cell[3829, 122, 500, 15, 70, "Notes",
 CellID->142486463],
Cell[4332, 139, 289, 7, 70, "Notes",
 CellID->78481417],
Cell[4624, 148, 258, 8, 70, "Notes",
 CellID->261924828]
}, Closed]],
Cell[CellGroupData[{
Cell[4919, 161, 49, 1, 70, "SeeAlsoSection",
 CellID->6369],
Cell[4971, 164, 221, 6, 70, "SeeAlso",
 CellID->8468]
}, Open  ]],
Cell[CellGroupData[{
Cell[5229, 175, 52, 1, 70, "TutorialsSection",
 CellID->3812],
Cell[5284, 178, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[5565, 189, 575, 14, 70, "Tutorials",
 CellID->23131]
}, Open  ]],
Cell[6155, 206, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

