(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7884,        263]
NotebookOptionsPosition[      5933,        201]
NotebookOutlinePosition[      7008,        230]
CellTagsIndexPosition[      6965,        227]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{".NET/Link User Guide" :> 
          Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
          "Calling COM from Mathematica in .NET/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:NETLink/tutorial/CallingNETFromMathematica#7475"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
       2->"\<\"Calling COM from Mathematica in .NET/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CreateCOMObject" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/CreateCOMObject"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"CreateCOMObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReleaseCOMObject", "ObjectName",
 CellID->3544],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReleaseCOMObject", "[", 
       StyleBox["obj", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]releases COM resources held by the specified .NET \
object."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15744]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Although any COM resources will be released when the .NET object is \
garbage-collected, it is often desirable to force their release explicitly.\
\>", "Notes",
 CellID->4688],

Cell[TextData[{
 "Each call to ",
 Cell[BoxData["ReleaseCOMObject"], "InlineFormula"],
 " decrements the reference count on the COM resources held by the object. \
The resources will be freed when the reference count goes to 0 (or the .NET \
object is garbage-collected)."
}], "Notes",
 CellID->78347820],

Cell[TextData[{
 Cell[BoxData["ReleaseCOMObject"], "InlineFormula"],
 " returns the new reference count on the COM resources, or a list of these \
counts if it was passed a list of objects."
}], "Notes",
 CellID->22107192],

Cell[TextData[{
 Cell[BoxData["ReleaseCOMObject"], "InlineFormula"],
 " should not be confused with ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["ReleaseNETObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/ReleaseNETObject"]], "InlineFormula"],
 " allows the .NET object to be garbage-collected, but does not force this to \
happen in a timely manner. ",
 Cell[BoxData["ReleaseCOMObject"], "InlineFormula"],
 " can be used to force the immediate release of the COM resources held by \
the object."
}], "Notes",
 CellID->100527729]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->11062],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CreateCOMObject",
   BaseStyle->"Link",
   ButtonData->"paclet:NETLink/ref/CreateCOMObject"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->31945]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->20275],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["Calling COM from ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
  FontSlant->"Italic"],
 ButtonBox[" in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#7475"]
}], "Tutorials",
 CellID->29316]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReleaseCOMObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "ReleaseCOMObject", "summary" -> 
    "ReleaseCOMObject[obj] releases COM resources held by the specified .NET \
object.", "uri" -> "NETLink/ref/ReleaseCOMObject", "type" -> "Symbol", 
    "label" -> "N E T Link Symbol", "paclet" -> "NETLink", "context" -> 
    "NETLink`", "keywords" -> {}, "synonyms" -> {"release object"}, "status" -> 
    "None", "built" -> "{2007, 4, 18, 11, 14, 57.0704314}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1501, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2124, 67, 53, 1, 70, "ObjectName",
 CellID->3544],
Cell[2180, 70, 422, 13, 70, "Usage",
 CellID->15744]
}, Open  ]],
Cell[CellGroupData[{
Cell[2639, 88, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3098, 104, 185, 4, 70, "Notes",
 CellID->4688],
Cell[3286, 110, 304, 7, 70, "Notes",
 CellID->78347820],
Cell[3593, 119, 222, 5, 70, "Notes",
 CellID->22107192],
Cell[3818, 126, 681, 18, 70, "Notes",
 CellID->100527729]
}, Closed]],
Cell[CellGroupData[{
Cell[4536, 149, 50, 1, 70, "SeeAlsoSection",
 CellID->11062],
Cell[4589, 152, 218, 6, 70, "SeeAlso",
 CellID->31945]
}, Open  ]],
Cell[CellGroupData[{
Cell[4844, 163, 53, 1, 70, "TutorialsSection",
 CellID->20275],
Cell[4900, 166, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[5181, 177, 710, 19, 70, "Tutorials",
 CellID->29316]
}, Open  ]],
Cell[5906, 199, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

