(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6832,        223]
NotebookOptionsPosition[      4972,        168]
NotebookOutlinePosition[      6209,        200]
CellTagsIndexPosition[      6166,        197]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{".NET/Link User Guide" :> 
         Documentation`HelpLookup["paclet:NETLink/tutorial/Overview"], 
         "The .NET Console Window in .NET/Link User Guide" :> 
         Documentation`HelpLookup[
          "paclet:NETLink/tutorial/CallingNETFromMathematica#9196"], 
         "Version Information in .NET/Link User Guide" :> 
         Documentation`HelpLookup[
          "paclet:NETLink/tutorial/CallingNETFromMathematica#12578"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\".NET/Link User Guide\"\>", 
      2->"\<\"The .NET Console Window in .NET/Link User Guide\"\>", 
      3->"\<\"Version Information in .NET/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShowNETConsole", "ObjectName",
 CellID->20649],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowNETConsole", "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]displays the .NET console window and begins capturing \
output sent to the ",
     StyleBox["Console.Out", "InlineCode"],
     " and ",
     StyleBox["Console.Error", "InlineCode"],
     " streams."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowNETConsole", "[", "\"\<stdout\>\"", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]captures only ",
     StyleBox["Console.out", "InlineCode"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ShowNETConsole", "[", "\"\<stderr\>\"", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]captures only ",
     StyleBox["Console.Error", "InlineCode"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->22029]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Anything written to these streams before ",
 Cell[BoxData["ShowNETConsole"], "InlineFormula"],
 " is first called will not appear, and closing the console window will stop \
capturing the streams (until ",
 Cell[BoxData["ShowNETConsole"], "InlineFormula"],
 " is called again)."
}], "Notes",
 CellID->25059]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->24588],

Cell[TextData[{
 StyleBox[ButtonBox[".NET/Link ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/Overview"]
}], "Tutorials",
 CellID->608907033],

Cell[TextData[{
 ButtonBox["The .NET Console Window in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#9196"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#9196"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#9196"]
}], "Tutorials",
 CellID->551699814],

Cell[TextData[{
 ButtonBox["Version Information in .",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#12578"],
 StyleBox[ButtonBox["NET/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#12578"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica#12578"]
}], "Tutorials",
 CellID->1731869799]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowNETConsole - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "ShowNETConsole", "summary" -> 
    "ShowNETConsole[] displays the .NET console window and begins capturing \
output sent to the Console.Out and Console.Error streams.  \
ShowNETConsole[\"stdout\"] captures only Console.out.  \
ShowNETConsole[\"stderr\"] captures only Console.Error.", "uri" -> 
    "NETLink/ref/ShowNETConsole", "type" -> "Symbol", "label" -> 
    "N E T Link Symbol", "paclet" -> "NETLink", "context" -> "NETLink`", 
    "keywords" -> {}, "synonyms" -> {"show console"}, "status" -> "None", 
    "built" -> "{2007, 4, 18, 11, 15, 19.0755834}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1130, 27, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1753, 54, 52, 1, 70, "ObjectName",
 CellID->20649],
Cell[1808, 57, 1008, 32, 70, "Usage",
 CellID->22029]
}, Open  ]],
Cell[CellGroupData[{
Cell[2853, 94, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3312, 110, 325, 8, 70, "Notes",
 CellID->25059]
}, Closed]],
Cell[CellGroupData[{
Cell[3674, 123, 53, 1, 70, "TutorialsSection",
 CellID->24588],
Cell[3730, 126, 278, 9, 70, "Tutorials",
 CellID->608907033],
Cell[4011, 137, 458, 12, 70, "Tutorials",
 CellID->551699814],
Cell[4472, 151, 458, 12, 70, "Tutorials",
 CellID->1731869799]
}, Open  ]],
Cell[4945, 166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

