(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17564,        581]
NotebookOptionsPosition[     11734,        400]
NotebookOutlinePosition[     15939,        515]
CellTagsIndexPosition[     15759,        506]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["N E T Link",
      FontSlant->"Italic"],
     " ",
     "Tutorial"
    }], "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction", "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell[TextData[StyleBox[".NET/Link",
 FontSlant->"Italic"]], "Section",
 CellTags->{".NET/Link", "nlug:1.0"},
 CellID->19550],

Cell[TextData[{
 "Welcome to ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", a product that integrates ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Microsoft's .NET platform. ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " lets you call .NET from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a completely transparent way, and allows you to use and control the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel from a .NET program. For ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users, ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " makes the entire .NET world an automatic extension to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " environment. For .NET programmers, ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " turns ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " into a scripting shell that lets you experiment with, build, and test .NET \
classes a line at a time. It also makes .NET an ideal environment for writing \
programs that use the computational services of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"nlug:1.0",
 CellID->18390],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s most unique feature is that it lets you load arbitrary \
.NET types into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and then create .NET objects, call methods, properties, and so on, \
directly from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. Thus, you can use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to \[OpenCurlyDoubleQuote]script\[CloseCurlyDoubleQuote] the functionality \
of an arbitrary .NET program\[LongDash]in effect, write a .NET program in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Essentially anything you can do from .NET, you can now do from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " perhaps even more easily because you are working in a true interpreted \
environment."
}], "Text",
 CellTags->"nlug:1.0",
 CellID->16148],

Cell[TextData[{
 ".NET/Link also lets you do some very useful things that do not appear to \
directly involve the .NET runtime. These include calling C-style DLL \
functions directly from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and creating and scripting COM objects, much like Visual Basic can do."
}], "Text",
 CellTags->"nlug:1.0",
 CellID->3356],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is designed for end-users and developers alike. The same features that let \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " users transparently call any .NET method also let developers create \
sophisticated commercial add-ons to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Programmers who want to write custom front ends for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a computational engine for another program will find using .NET with ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " is easier than using the traditional ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " interface from C or C++."
}], "Text",
 CellTags->"nlug:1.0",
 CellID->30124],

Cell[TextData[{
 StyleBox["Finally, ",
  FormatType->InputForm],
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 StyleBox[" comes with full source code. You can examine the code to \
supplement the documentation, get tips for your own programs, better \
understand how to use advanced features, or just see how it works.",
  FormatType->InputForm]
}], "Text",
 CellTags->"nlug:1.0",
 CellID->14901],

Cell[TextData[{
 "Some familiarity with both the .NET Framework and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is assumed in this manual. In Part 2, which covers writing .NET programs \
that call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", major examples are generally provided in both C# and Visual Basic .NET \
versions, although overall the documentation is perhaps slightly more \
C#-centric. Naturally, when writing .NET programs that use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ", you can use any .NET-aware ",
 "language",
 ", not just C# and Visual Basic .NET."
}], "Text",
 CellTags->"nlug:1.0",
 CellID->20318],

Cell[TextData[{
 ButtonBox["Calling .NET from ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingNETFromMathematica"],
  FontSlant->"Italic"],
 " shows how you use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " to call .NET from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and ",
 ButtonBox["Calling ",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingMathematicaFromNET"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingMathematicaFromNET"],
  FontSlant->"Italic"],
 ButtonBox[" from .NET",
  BaseStyle->"Link",
  ButtonData->"paclet:NETLink/tutorial/CallingMathematicaFromNET"],
 " shows how to call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from .NET."
}], "Text",
 CellTags->"nlug:1.0",
 CellID->3905]
}, Open  ]],

Cell[CellGroupData[{

Cell["What is .NET?", "Section",
 CellTags->"nlug:1.1",
 CellID->6768],

Cell["\<\
.NET is a new development platform for Windows programming. It replaces \
essentially everything that came before it, including an entire alphabet soup \
of programming technologies such as MFC, COM, ActiveX, ATL, ASP, ADO, and \
many others. Although Microsoft emphasizes XML Web Services in conjunction \
with .NET, XML Web Services are only a small part of the .NET platform, and \
the success of .NET is not dependent on the widespread adoption of XML Web \
Services.\
\>", "Text",
 CellTags->"nlug:1.1",
 CellID->32140],

Cell["\<\
.NET represents the future of Windows programming, and Microsoft is rapidly \
shifting more and more of its technology and products to a .NET foundation.\
\>", "Text",
 CellTags->"nlug:1.1",
 CellID->22187],

Cell["\<\
At the core of .NET is a runtime engine, similar to that used by Java, that \
loads and executes programs compiled into special bytecodes that the runtime \
understands. This runtime is called the Common Language Runtime (CLR), but we \
will often refer to it as the .NET runtime. A key feature of this system is \
that many languages can be compiled into CLR bytecodes and executed by the \
runtime. This means that .NET is language-neutral, supporting any programming \
language for which a .NET compiler is available. Microsoft provides compilers \
for C#, Visual Basic .NET, JScript, Visual J# .NET, and C++ With Managed \
Extensions. Many other compilers exist, including ones for Fortran, Perl, \
Python, Eiffel, COBOL. You can even create a class in one .NET language, say \
Visual Basic .NET, and subclass it in another language.\
\>", "Text",
 CellTags->"nlug:1.1",
 CellID->21155],

Cell["\<\
Although .NET is language-neutral, probably the two most important .NET \
languages are Visual Basic .NET, a modification of the Visual Basic language, \
and C#, a new language that is similar in many ways to Java.\
\>", "Text",
 CellTags->"nlug:1.1",
 CellID->23728]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "What is ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "?"
}], "Section",
 CellTags->"nlug:1.2",
 CellID->18655],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is Wolfram Research\[CloseCurlyQuote]s protocol for sending data and \
commands back and forth between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and other programs. ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is the underlying glue that lets .NET and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " talk to each other. When calling .NET from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " completely hides the low-level details of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " communication, allowing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programmers to load and use .NET classes as if they were part of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " environment itself. When writing .NET programs that call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " provides a higher-level layer of functionality than the traditional C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programming interface."
}], "Text",
 CellTags->"nlug:1.2",
 CellID->6335]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "How Does ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " Compare to ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "?"
}], "Section",
 CellTags->"nlug:1.3",
 CellID->4485],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is an existing Wolfram Research product that integrates Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in almost exactly the same way that ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " integrates .NET and ",
 StyleBox["Mathematica. ",
  FontSlant->"Italic"],
 "You can use ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to do many of the same things you can do with ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " and vice versa. Because it is based on Java, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " has the advantage of being cross-platform. If you want to write programs \
that run on every ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " platform, you should use ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". On the other hand, .NET integrates more tightly with the Windows \
operating system than Java does, so if you want to do Windows-specific \
things, or you want a very native Windows look and feel, you should use ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 ". On Windows, ",
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " also does some things that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " cannot, such as allowing you to call C-style DLL functions directly from \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or controlling COM objects."
}], "Text",
 CellTags->"nlug:1.3",
 CellID->15600],

Cell[TextData[{
 StyleBox[".NET/Link",
  FontSlant->"Italic"],
 " and ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provide a very similar programming model. Familiarity with one will be \
very helpful when working with the other."
}], "Text",
 CellTags->"nlug:1.3",
 CellID->19629]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Introduction", "summary" -> 
    "Welcome to .NET/Link, a product that integrates Mathematica and \
Microsoft's .NET platform. .NET/Link lets you call .NET from Mathematica in a \
completely transparent way, and allows you to use and control the Mathematica \
kernel from a .NET program. For Mathematica users, .NET/Link makes the entire \
.NET world an automatic extension to the Mathematica environment. For .NET \
programmers, .NET/Link turns Mathematica into a scripting shell that lets you \
experiment with, build, and test .NET classes a line at a time. It also makes \
.NET an ideal environment for writing programs that use the computational \
services of Mathematica. .NET/Link's most unique feature is that it lets you \
load arbitrary .NET types into Mathematica and then create .NET objects, call \
methods, properties, and so on, directly from the Mathematica language. Thus, \
you can use Mathematica to 'script' the functionality of an arbitrary .NET \
program--in effect, write a .NET program in Mathematica. Essentially anything \
you can do from .NET, you can now do from Mathematica perhaps even more \
easily because you are working in a true interpreted environment. .NET/Link \
also lets you do some very useful things that do not appear to directly \
involve the .NET runtime. These include calling C-style DLL functions \
directly from Mathematica, and creating and scripting COM objects, much like \
Visual Basic can do.", "uri" -> "NETLink/tutorial/Introduction", "type" -> 
    "Tutorial", "label" -> "N E T Link Tutorial", "paclet" -> "NETLink", 
    "context" -> "", "keywords" -> {}, "synonyms" -> {}, "status" -> "None", 
    "built" -> "{2007, 4, 18, 11, 15, 53.8010554}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 16, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 ".NET/Link"->{
  Cell[879, 39, 124, 3, 70, "Section",
   CellTags->{".NET/Link", "nlug:1.0"},
   CellID->19550]},
 "nlug:1.0"->{
  Cell[879, 39, 124, 3, 70, "Section",
   CellTags->{".NET/Link", "nlug:1.0"},
   CellID->19550],
  Cell[1006, 44, 1174, 39, 70, "Text",
   CellTags->"nlug:1.0",
   CellID->18390],
  Cell[2183, 85, 900, 25, 70, "Text",
   CellTags->"nlug:1.0",
   CellID->16148],
  Cell[3086, 112, 365, 9, 70, "Text",
   CellTags->"nlug:1.0",
   CellID->3356],
  Cell[3454, 123, 819, 26, 70, "Text",
   CellTags->"nlug:1.0",
   CellID->30124],
  Cell[4276, 151, 398, 11, 70, "Text",
   CellTags->"nlug:1.0",
   CellID->14901],
  Cell[4677, 164, 655, 18, 70, "Text",
   CellTags->"nlug:1.0",
   CellID->20318],
  Cell[5335, 184, 951, 31, 70, "Text",
   CellTags->"nlug:1.0",
   CellID->3905]},
 "nlug:1.1"->{
  Cell[6323, 220, 70, 2, 70, "Section",
   CellTags->"nlug:1.1",
   CellID->6768],
  Cell[6396, 224, 534, 10, 70, "Text",
   CellTags->"nlug:1.1",
   CellID->32140],
  Cell[6933, 236, 216, 5, 70, "Text",
   CellTags->"nlug:1.1",
   CellID->22187],
  Cell[7152, 243, 900, 14, 70, "Text",
   CellTags->"nlug:1.1",
   CellID->21155],
  Cell[8055, 259, 277, 6, 70, "Text",
   CellTags->"nlug:1.1",
   CellID->23728]},
 "nlug:1.2"->{
  Cell[8369, 270, 133, 7, 70, "Section",
   CellTags->"nlug:1.2",
   CellID->18655],
  Cell[8505, 279, 1206, 40, 70, "Text",
   CellTags->"nlug:1.2",
   CellID->6335]},
 "nlug:1.3"->{
  Cell[9748, 324, 195, 10, 70, "Section",
   CellTags->"nlug:1.3",
   CellID->4485],
  Cell[9946, 336, 1445, 46, 70, "Text",
   CellTags->"nlug:1.3",
   CellID->15600],
  Cell[11394, 384, 286, 10, 70, "Text",
   CellTags->"nlug:1.3",
   CellID->19629]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {".NET/Link", 14064, 441},
 {"nlug:1.0", 14178, 445},
 {"nlug:1.1", 14869, 470},
 {"nlug:1.2", 15298, 486},
 {"nlug:1.3", 15482, 493}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 180, 7, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[805, 34, 49, 1, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[879, 39, 124, 3, 70, "Section",
 CellTags->{".NET/Link", "nlug:1.0"},
 CellID->19550],
Cell[1006, 44, 1174, 39, 70, "Text",
 CellTags->"nlug:1.0",
 CellID->18390],
Cell[2183, 85, 900, 25, 70, "Text",
 CellTags->"nlug:1.0",
 CellID->16148],
Cell[3086, 112, 365, 9, 70, "Text",
 CellTags->"nlug:1.0",
 CellID->3356],
Cell[3454, 123, 819, 26, 70, "Text",
 CellTags->"nlug:1.0",
 CellID->30124],
Cell[4276, 151, 398, 11, 70, "Text",
 CellTags->"nlug:1.0",
 CellID->14901],
Cell[4677, 164, 655, 18, 70, "Text",
 CellTags->"nlug:1.0",
 CellID->20318],
Cell[5335, 184, 951, 31, 70, "Text",
 CellTags->"nlug:1.0",
 CellID->3905]
}, Open  ]],
Cell[CellGroupData[{
Cell[6323, 220, 70, 2, 70, "Section",
 CellTags->"nlug:1.1",
 CellID->6768],
Cell[6396, 224, 534, 10, 70, "Text",
 CellTags->"nlug:1.1",
 CellID->32140],
Cell[6933, 236, 216, 5, 70, "Text",
 CellTags->"nlug:1.1",
 CellID->22187],
Cell[7152, 243, 900, 14, 70, "Text",
 CellTags->"nlug:1.1",
 CellID->21155],
Cell[8055, 259, 277, 6, 70, "Text",
 CellTags->"nlug:1.1",
 CellID->23728]
}, Open  ]],
Cell[CellGroupData[{
Cell[8369, 270, 133, 7, 70, "Section",
 CellTags->"nlug:1.2",
 CellID->18655],
Cell[8505, 279, 1206, 40, 70, "Text",
 CellTags->"nlug:1.2",
 CellID->6335]
}, Open  ]],
Cell[CellGroupData[{
Cell[9748, 324, 195, 10, 70, "Section",
 CellTags->"nlug:1.3",
 CellID->4485],
Cell[9946, 336, 1445, 46, 70, "Text",
 CellTags->"nlug:1.3",
 CellID->15600],
Cell[11394, 384, 286, 10, 70, "Text",
 CellTags->"nlug:1.3",
 CellID->19629]
}, Open  ]]
}, Open  ]],
Cell[11707, 398, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

