(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33311,        921]
NotebookOptionsPosition[     26313,        699]
NotebookOutlinePosition[     30203,        811]
CellTagsIndexPosition[     29887,        800]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Loading GUIs in GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/LoadingGUIs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Loading GUIs in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIObject"], 
          "GUIResolve" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIResolve"], "GUIRun" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIRun"], "GUIRunModal" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIRunModal"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"GUIObject\"\>", 
       2->"\<\"GUIResolve\"\>", 3->"\<\"GUIRun\"\>", 
       4->"\<\"GUIRunModal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GUILoad", "ObjectName",
 CellID->1411],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUILoad", "[", 
       StyleBox["src", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]loads an interface definition and returns immediately \
with a ",
     Cell[BoxData[
      ButtonBox["GUIObject",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
     " result."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUILoad", "[", 
       RowBox[{
        StyleBox["src", "TI"], ",", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]passes arguments to the interface definition."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GUILoad"], "InlineFormula"],
 " performs the same first steps as ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GUIRunModal",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRunModal"]], "InlineFormula"],
 ", but stops short of actually displaying the interface to the user."
}], "Notes",
 CellID->25893],

Cell[TextData[{
 Cell[BoxData["GUILoad"], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " expression representing the live interface instance."
}], "Notes",
 CellTags->"GUILoad",
 CellID->21984],

Cell[TextData[{
 Cell[BoxData["GUILoad"], "InlineFormula"],
 " is useful for manipulating the interface definition before calling ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GUIRunModal",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRunModal"]], "InlineFormula"],
 " and also for loading classes and preparing the interface in advance to \
reduce the eventual display time. "
}], "Notes",
 CellID->2357],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["src", "TI"]], "InlineFormula"],
 " can be a filename, a user interface expression definition, an XMLDocument \
interface expression, or a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"GUIRun",
 CellID->553],

Cell[TextData[{
 "If arguments are included, they are passed as arguments to the interface \
definition and are available from the widget registry through the names ",
 Cell[BoxData["\"\<##\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<#1\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<#2\>\""], "InlineFormula"],
 ", and so forth."
}], "Notes",
 CellTags->"GUIRun",
 CellID->26271],

Cell["The following options can be given: ", "Notes",
 CellID->6955],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ReleaseMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/ReleaseMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "determines when a ",
     Cell[BoxData[
      ButtonBox["GUIObject",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
     " is released"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IncludedScriptContexts",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/IncludedScriptContexts"], 
    RowBox[{"{", "}"}], Cell[TextData[{
     "extends the active ",
     Cell[BoxData[
      ButtonBox["$ContextPath",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
     " that ",
     Cell[BoxData[
      ButtonBox["Script",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
     " blocks use"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->9389]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->84719200],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->241298797],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->18389603],

Cell["Load an interface:", "ExampleText",
 CellID->28592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUILoad", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->{"GUILoad", "Ex--21907744555570480354,1"},
 CellLabel->"In[2]:=",
 CellID->31270],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject347641078611969, 
   JLink`Objects`JavaObject250688097484801]]], "Output",
 CellTags->{"GUILoad", "Ex--21907744555570480354,1"},
 CellLabel->"Out[2]=",
 CellID->30119]
}, Open  ]],

Cell["Manipulate widget settings:", "ExampleText",
 CellID->23017],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<FirstArgumentField\>\"", ",", " ", "\"\<text\>\""}], "}"}], 
    ",", " ", 
    RowBox[{"ToString", "[", 
     RowBox[{
      RowBox[{"3", "!"}], ",", " ", "InputForm"}], "]"}]}], "]"}]}]], "Input",\

 CellTags->{"GUILoad", "Ex--21907744555570480354,2"},
 CellLabel->"In[3]:=",
 CellID->29313],

Cell["Display the interface:", "ExampleText",
 CellID->15253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRun", "[", "ref", "]"}]], "Input",
 CellTags->{"GUILoad", "Ex--21907744555570480354,4"},
 CellLabel->"In[4]:=",
 CellID->16117],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject347641078611969, 
   JLink`Objects`JavaObject250688097484801]]], "Output",
 CellTags->{"GUILoad", "Ex--21907744555570480354,4"},
 CellLabel->"Out[4]=",
 CellID->4977]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GUIScreenShot", "[", " ", "ref", "]"}], " "}]], "Input",
 CellTags->{"GUILoad", "Ex--21907744555570480354,5"},
 CellLabel->"In[5]:=",
 CellID->19160],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{270, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"GUILoad", "Ex--21907744555570480354,5"},
 CellLabel->"Out[5]=",
 CellID->443966656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->160911545],

Cell["Load an interface and run it in a modal session:", "ExampleText",
 CellID->3576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\[IndentingNewLine]", "  ", 
  RowBox[{"GUILoad", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}], 
  "]"}]], "Input",
 CellTags->"GUILoad",
 CellLabel->"In[2]:=",
 CellID->4854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"FirstArgumentField\"\>", "\[Rule]", "56"}], ",", 
   RowBox[{"\<\"SecondArgumentField\"\>", "\[Rule]", "645"}], ",", 
   RowBox[{"\<\"SumField\"\>", "\[Rule]", "701"}], ",", 
   RowBox[{"\<\"DifferenceField\"\>", "\[Rule]", 
    RowBox[{"-", "589"}]}], ",", 
   RowBox[{"\<\"ProductField\"\>", "\[Rule]", "36120"}], ",", 
   RowBox[{"\<\"QuotientField\"\>", "\[Rule]", 
    FractionBox["56", "645"]}]}], "}"}]], "Output",
 CellTags->"GUILoad",
 CellLabel->"Out[2]=",
 CellID->20072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11134],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->327275672],

Cell["\<\
Load an interface and release the definition without displaying it:\
\>", "ExampleText",
 CellID->25050],

Cell[BoxData[
 RowBox[{"ReleaseGUIObject", "[", "\[IndentingNewLine]", "  ", 
  RowBox[{"GUILoad", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}], 
  "]"}]], "Input",
 CellTags->"GUILoad",
 CellLabel->"In[2]:=",
 CellID->9193]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21457],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIResolve",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIResolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRun",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRun"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRunModal",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRunModal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32405]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22999],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->30336],

Cell[TextData[{
 ButtonBox["Loading GUIs in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/LoadingGUIs"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/LoadingGUIs"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/LoadingGUIs"]
}], "Tutorials",
 CellID->8896481]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUILoad - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 22, 46.8541324}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "GUILoad[src] loads an interface definition and returns immediately with \
a GUIObject result. GUILoad[src, args] passes arguments to the interface \
definition.", "synonyms" -> {}, "title" -> "GUILoad", "type" -> "Symbol", 
    "uri" -> "GUIKit/ref/GUILoad"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GUILoad"->{
  Cell[4170, 132, 311, 10, 70, "Notes",
   CellTags->"GUILoad",
   CellID->21984],
  Cell[7935, 265, 224, 6, 70, "Input",
   CellTags->{"GUILoad", "Ex--21907744555570480354,1"},
   CellID->31270],
  Cell[8162, 273, 320, 8, 70, "Output",
   CellTags->{"GUILoad", "Ex--21907744555570480354,1"},
   CellID->30119],
  Cell[8566, 287, 423, 13, 70, "Input",
   CellTags->{"GUILoad", "Ex--21907744555570480354,2"},
   CellID->29313],
  Cell[9078, 307, 154, 4, 70, "Input",
   CellTags->{"GUILoad", "Ex--21907744555570480354,4"},
   CellID->16117],
  Cell[9235, 313, 319, 8, 70, "Output",
   CellTags->{"GUILoad", "Ex--21907744555570480354,4"},
   CellID->4977],
  Cell[9591, 326, 184, 5, 70, "Input",
   CellTags->{"GUILoad", "Ex--21907744555570480354,5"},
   CellID->19160],
  Cell[9778, 333, 12385, 207, 70, "Output",
   Evaluatable->False,
   CellTags->{"GUILoad", "Ex--21907744555570480354,5"},
   CellID->443966656],
  Cell[22543, 558, 223, 6, 70, "Input",
   CellTags->"GUILoad",
   CellID->4854],
  Cell[22769, 566, 538, 13, 70, "Output",
   CellTags->"GUILoad",
   CellID->20072],
  Cell[23695, 597, 228, 6, 70, "Input",
   CellTags->"GUILoad",
   CellID->9193]},
 "GUIRun"->{
  Cell[5022, 161, 364, 12, 70, "Notes",
   CellTags->"GUIRun",
   CellID->553],
  Cell[5389, 175, 391, 11, 70, "Notes",
   CellTags->"GUIRun",
   CellID->26271]},
 "PrimaryExamplesSection"->{
  Cell[7187, 234, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->84719200]},
 "Ex--21907744555570480354,1"->{
  Cell[7935, 265, 224, 6, 70, "Input",
   CellTags->{"GUILoad", "Ex--21907744555570480354,1"},
   CellID->31270],
  Cell[8162, 273, 320, 8, 70, "Output",
   CellTags->{"GUILoad", "Ex--21907744555570480354,1"},
   CellID->30119]},
 "Ex--21907744555570480354,2"->{
  Cell[8566, 287, 423, 13, 70, "Input",
   CellTags->{"GUILoad", "Ex--21907744555570480354,2"},
   CellID->29313]},
 "Ex--21907744555570480354,4"->{
  Cell[9078, 307, 154, 4, 70, "Input",
   CellTags->{"GUILoad", "Ex--21907744555570480354,4"},
   CellID->16117],
  Cell[9235, 313, 319, 8, 70, "Output",
   CellTags->{"GUILoad", "Ex--21907744555570480354,4"},
   CellID->4977]},
 "Ex--21907744555570480354,5"->{
  Cell[9591, 326, 184, 5, 70, "Input",
   CellTags->{"GUILoad", "Ex--21907744555570480354,5"},
   CellID->19160],
  Cell[9778, 333, 12385, 207, 70, "Output",
   Evaluatable->False,
   CellTags->{"GUILoad", "Ex--21907744555570480354,5"},
   CellID->443966656]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GUILoad", 27407, 725},
 {"GUIRun", 28585, 760},
 {"PrimaryExamplesSection", 28777, 767},
 {"Ex--21907744555570480354,1", 28929, 771},
 {"Ex--21907744555570480354,2", 29192, 778},
 {"Ex--21907744555570480354,4", 29341, 782},
 {"Ex--21907744555570480354,5", 29603, 789}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1668, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2291, 65, 44, 1, 70, "ObjectName",
 CellID->1411],
Cell[2338, 68, 852, 26, 70, "Usage",
 CellID->22957]
}, Open  ]],
Cell[CellGroupData[{
Cell[3227, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3705, 116, 462, 14, 70, "Notes",
 CellID->25893],
Cell[4170, 132, 311, 10, 70, "Notes",
 CellTags->"GUILoad",
 CellID->21984],
Cell[4484, 144, 535, 15, 70, "Notes",
 CellID->2357],
Cell[5022, 161, 364, 12, 70, "Notes",
 CellTags->"GUIRun",
 CellID->553],
Cell[5389, 175, 391, 11, 70, "Notes",
 CellTags->"GUIRun",
 CellID->26271],
Cell[5783, 188, 68, 1, 70, "Notes",
 CellID->6955],
Cell[5854, 191, 1296, 38, 70, "3ColumnTableMod",
 CellID->9389]
}, Closed]],
Cell[CellGroupData[{
Cell[7187, 234, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->84719200],
Cell[CellGroupData[{
Cell[7571, 248, 148, 5, 70, "ExampleSection",
 CellID->241298797],
Cell[7722, 255, 128, 3, 70, "Input",
 CellID->18389603],
Cell[7853, 260, 57, 1, 70, "ExampleText",
 CellID->28592],
Cell[CellGroupData[{
Cell[7935, 265, 224, 6, 70, "Input",
 CellTags->{"GUILoad", "Ex--21907744555570480354,1"},
 CellID->31270],
Cell[8162, 273, 320, 8, 70, "Output",
 CellTags->{"GUILoad", "Ex--21907744555570480354,1"},
 CellID->30119]
}, Open  ]],
Cell[8497, 284, 66, 1, 70, "ExampleText",
 CellID->23017],
Cell[8566, 287, 423, 13, 70, "Input",
 CellTags->{"GUILoad", "Ex--21907744555570480354,2"},
 CellID->29313],
Cell[8992, 302, 61, 1, 70, "ExampleText",
 CellID->15253],
Cell[CellGroupData[{
Cell[9078, 307, 154, 4, 70, "Input",
 CellTags->{"GUILoad", "Ex--21907744555570480354,4"},
 CellID->16117],
Cell[9235, 313, 319, 8, 70, "Output",
 CellTags->{"GUILoad", "Ex--21907744555570480354,4"},
 CellID->4977]
}, Open  ]],
Cell[CellGroupData[{
Cell[9591, 326, 184, 5, 70, "Input",
 CellTags->{"GUILoad", "Ex--21907744555570480354,5"},
 CellID->19160],
Cell[9778, 333, 12385, 207, 70, "Output",
 Evaluatable->False,
 CellTags->{"GUILoad", "Ex--21907744555570480354,5"},
 CellID->443966656]
}, Open  ]],
Cell[22178, 543, 119, 3, 70, "ExampleDelimiter",
 CellID->153],
Cell[22300, 548, 129, 3, 70, "Input",
 CellID->160911545],
Cell[22432, 553, 86, 1, 70, "ExampleText",
 CellID->3576],
Cell[CellGroupData[{
Cell[22543, 558, 223, 6, 70, "Input",
 CellTags->"GUILoad",
 CellID->4854],
Cell[22769, 566, 538, 13, 70, "Output",
 CellTags->"GUILoad",
 CellID->20072]
}, Open  ]],
Cell[23322, 582, 121, 3, 70, "ExampleDelimiter",
 CellID->11134],
Cell[23446, 587, 129, 3, 70, "Input",
 CellID->327275672],
Cell[23578, 592, 114, 3, 70, "ExampleText",
 CellID->25050],
Cell[23695, 597, 228, 6, 70, "Input",
 CellTags->"GUILoad",
 CellID->9193]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23972, 609, 311, 9, 70, "SeeAlsoSection",
 CellID->21457],
Cell[24286, 620, 977, 35, 70, "SeeAlso",
 CellID->32405]
}, Open  ]],
Cell[CellGroupData[{
Cell[25300, 660, 314, 9, 70, "TutorialsSection",
 CellID->22999],
Cell[25617, 671, 269, 9, 70, "Tutorials",
 CellID->30336],
Cell[25889, 682, 382, 12, 70, "Tutorials",
 CellID->8896481]
}, Open  ]],
Cell[26286, 697, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

