(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16967,        621]
NotebookOptionsPosition[     11714,        437]
NotebookOutlinePosition[     14469,        525]
CellTagsIndexPosition[     14356,        519]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Widget Basics in GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/WidgetBasics"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Widget Basics in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CloseGUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/CloseGUIObject"], 
          "GUILoad" :> Documentation`HelpLookup["paclet:GUIKit/ref/GUILoad"], 
          "GUIObjectQ" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIObjectQ"], "GUIRun" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIRun"], 
          "ReleaseGUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/ReleaseGUIObject"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"CloseGUIObject\"\>", 
       2->"\<\"GUILoad\"\>", 3->"\<\"GUIObjectQ\"\>", 4->"\<\"GUIRun\"\>", 
       5->"\<\"ReleaseGUIObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GUIObject", "ObjectName",
 CellID->17686],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIObject", "[", 
       RowBox[{
        StyleBox["root", "TI"], ",", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a live interface instance with root widget \
",
     Cell[BoxData[
      StyleBox["root", "TI"]], "InlineFormula"],
     ", wrapping the active widgets and environment."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2403]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A ",
 Cell[BoxData["GUIObject"], "InlineFormula"],
 " represents a live interface instance wrapping both the created Java \
objects as well as the runtime environment associated with the scripting code \
and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " contexts."
}], "Notes",
 CellTags->"GUIObject",
 CellID->8252],

Cell[TextData[{
 Cell[BoxData["GUIObject"], "InlineFormula"],
 " objects are comprised mostly of private definitions, but the first \
argument is a ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " instance of the top-level widget in the interface and supports direct ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " style calls."
}], "Notes",
 CellID->15718],

Cell[TextData[{
 "A ",
 Cell[BoxData["GUIObject"], "InlineFormula"],
 " is created whenever ",
 Cell[BoxData[
  ButtonBox["GUILoad",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUILoad"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GUIRun",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIRun"]], "InlineFormula"],
 " is called."
}], "Notes",
 CellTags->"GUIObject",
 CellID->23035],

Cell[TextData[{
 "A ",
 Cell[BoxData["GUIObject"], "InlineFormula"],
 " is released interactively when an interface is closed or programmatically \
using ",
 Cell[BoxData[
  ButtonBox["CloseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/CloseGUIObject"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ReleaseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7285]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->72234030],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->13535199],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->149107155],

Cell[TextData[{
 "Create a ",
 Cell[BoxData["GUIObject"], "InlineFormula"],
 " instance:"
}], "ExampleText",
 CellTags->"GUIObject",
 CellID->4841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUILoad", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->"GUIObject",
 CellLabel->"In[2]:=",
 CellID->18938],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject384490824269825, 
   JLink`Objects`vm1`JavaObject412479062540289]]], "Output",
 CellTags->"GUIObject",
 CellLabel->"Out[2]=",
 CellID->805394916]
}, Open  ]],

Cell[TextData[{
 "The first argument is a normal ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " instance:"
}], "ExampleText",
 CellTags->"GUIObject",
 CellID->17096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", "ref", "]"}]], "Input",
 CellTags->"GUIObject",
 CellLabel->"In[3]:=",
 CellID->31033],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{
    "com", ".", "wolfram", ".", "guikit", ".", "swing", ".", "GUIKitJFrame"}],
     "]"}], "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject384490824269825]], "Output",
 CellTags->"GUIObject",
 CellLabel->"Out[3]=",
 CellID->762394475]
}, Open  ]],

Cell["\<\
Most of the parameters are private environment states that cannot be properly \
built up manually:\
\>", "ExampleText",
 CellTags->"GUIObject",
 CellID->29768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "//", "InputForm"}]], "Input",
 CellTags->"GUIObject",
 CellLabel->"In[4]:=",
 CellID->27873],

Cell["\<\
GUIObject[JLink`Objects`vm1`JavaObject384490824269825, 
 JLink`Objects`vm1`JavaObject412479062540289]\
\>", "Output",
 CellTags->"GUIObject",
 CellLabel->"Out[4]//InputForm=",
 CellID->566112151]
}, Open  ]],

Cell[TextData[{
 "Many ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " functions work with a ",
 Cell[BoxData["GUIObject"], "InlineFormula"],
 " instance:"
}], "ExampleText",
 CellTags->"GUIObject",
 CellID->19109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WidgetNames\>\"", " ", "/.", " ", 
  RowBox[{"GUIInformation", "[", "ref", " ", "]"}]}]], "Input",
 CellTags->"GUIObject",
 CellLabel->"In[5]:=",
 CellID->30096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DifferenceField\"\>", ",", "\<\"FirstArgumentField\"\>", 
   ",", "\<\"ProductField\"\>", ",", "\<\"QuotientField\"\>", 
   ",", "\<\"SecondArgumentField\"\>", ",", "\<\"SumField\"\>"}], 
  "}"}]], "Output",
 CellTags->"GUIObject",
 CellLabel->"Out[5]=",
 CellID->174263948]
}, Open  ]],

Cell[TextData[{
 "Release the ",
 Cell[BoxData["GUIObject"], "InlineFormula"],
 " instance:"
}], "ExampleText",
 CellTags->"GUIObject",
 CellID->21561],

Cell[BoxData[
 RowBox[{"ReleaseGUIObject", "[", "ref", "]"}]], "Input",
 CellTags->"GUIObject",
 CellLabel->"In[6]:=",
 CellID->25739]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20949],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseGUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/CloseGUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUILoad",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUILoad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIObjectQ",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIObjectQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRun",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRun"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseGUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2364]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28428],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->16678],

Cell[TextData[{
 ButtonBox["Widget Basics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"]
}], "Tutorials",
 CellID->15292152]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 22, 48.0415716}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "GUIObject[root, args] represents a live interface instance with root \
widget root, wrapping the active widgets and environment.", "synonyms" -> {}, 
    "title" -> "GUIObject", "type" -> "Symbol", "uri" -> 
    "GUIKit/ref/GUIObject"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GUIObject"->{
  Cell[3603, 111, 343, 11, 70, "Notes",
   CellTags->"GUIObject",
   CellID->8252],
  Cell[4397, 139, 417, 16, 70, "Notes",
   CellTags->"GUIObject",
   CellID->23035],
  Cell[5998, 204, 147, 6, 70, "ExampleText",
   CellTags->"GUIObject",
   CellID->4841],
  Cell[6170, 214, 194, 6, 70, "Input",
   CellTags->"GUIObject",
   CellID->18938],
  Cell[6367, 222, 302, 8, 70, "Output",
   CellTags->"GUIObject",
   CellID->805394916],
  Cell[6684, 233, 253, 9, 70, "ExampleText",
   CellTags->"GUIObject",
   CellID->17096],
  Cell[6962, 246, 123, 4, 70, "Input",
   CellTags->"GUIObject",
   CellID->31033],
  Cell[7088, 252, 348, 10, 70, "Output",
   CellTags->"GUIObject",
   CellID->762394475],
  Cell[7451, 265, 169, 5, 70, "ExampleText",
   CellTags->"GUIObject",
   CellID->29768],
  Cell[7645, 274, 128, 4, 70, "Input",
   CellTags->"GUIObject",
   CellID->27873],
  Cell[7776, 280, 205, 6, 70, "Output",
   CellTags->"GUIObject",
   CellID->566112151],
  Cell[7996, 289, 216, 9, 70, "ExampleText",
   CellTags->"GUIObject",
   CellID->19109],
  Cell[8237, 302, 189, 5, 70, "Input",
   CellTags->"GUIObject",
   CellID->30096],
  Cell[8429, 309, 318, 8, 70, "Output",
   CellTags->"GUIObject",
   CellID->174263948],
  Cell[8762, 320, 151, 6, 70, "ExampleText",
   CellTags->"GUIObject",
   CellID->21561],
  Cell[8916, 328, 134, 4, 70, "Input",
   CellTags->"GUIObject",
   CellID->25739]},
 "PrimaryExamplesSection"->{
  Cell[5332, 178, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->72234030]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GUIObject", 12789, 463},
 {"PrimaryExamplesSection", 14214, 512}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1822, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2445, 68, 47, 1, 70, "ObjectName",
 CellID->17686],
Cell[2495, 71, 593, 18, 70, "Usage",
 CellID->2403]
}, Open  ]],
Cell[CellGroupData[{
Cell[3125, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3603, 111, 343, 11, 70, "Notes",
 CellTags->"GUIObject",
 CellID->8252],
Cell[3949, 124, 445, 13, 70, "Notes",
 CellID->15718],
Cell[4397, 139, 417, 16, 70, "Notes",
 CellTags->"GUIObject",
 CellID->23035],
Cell[4817, 157, 478, 16, 70, "Notes",
 CellID->7285]
}, Closed]],
Cell[CellGroupData[{
Cell[5332, 178, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->72234030],
Cell[CellGroupData[{
Cell[5716, 192, 147, 5, 70, "ExampleSection",
 CellID->13535199],
Cell[5866, 199, 129, 3, 70, "Input",
 CellID->149107155],
Cell[5998, 204, 147, 6, 70, "ExampleText",
 CellTags->"GUIObject",
 CellID->4841],
Cell[CellGroupData[{
Cell[6170, 214, 194, 6, 70, "Input",
 CellTags->"GUIObject",
 CellID->18938],
Cell[6367, 222, 302, 8, 70, "Output",
 CellTags->"GUIObject",
 CellID->805394916]
}, Open  ]],
Cell[6684, 233, 253, 9, 70, "ExampleText",
 CellTags->"GUIObject",
 CellID->17096],
Cell[CellGroupData[{
Cell[6962, 246, 123, 4, 70, "Input",
 CellTags->"GUIObject",
 CellID->31033],
Cell[7088, 252, 348, 10, 70, "Output",
 CellTags->"GUIObject",
 CellID->762394475]
}, Open  ]],
Cell[7451, 265, 169, 5, 70, "ExampleText",
 CellTags->"GUIObject",
 CellID->29768],
Cell[CellGroupData[{
Cell[7645, 274, 128, 4, 70, "Input",
 CellTags->"GUIObject",
 CellID->27873],
Cell[7776, 280, 205, 6, 70, "Output",
 CellTags->"GUIObject",
 CellID->566112151]
}, Open  ]],
Cell[7996, 289, 216, 9, 70, "ExampleText",
 CellTags->"GUIObject",
 CellID->19109],
Cell[CellGroupData[{
Cell[8237, 302, 189, 5, 70, "Input",
 CellTags->"GUIObject",
 CellID->30096],
Cell[8429, 309, 318, 8, 70, "Output",
 CellTags->"GUIObject",
 CellID->174263948]
}, Open  ]],
Cell[8762, 320, 151, 6, 70, "ExampleText",
 CellTags->"GUIObject",
 CellID->21561],
Cell[8916, 328, 134, 4, 70, "Input",
 CellTags->"GUIObject",
 CellID->25739]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9099, 338, 311, 9, 70, "SeeAlsoSection",
 CellID->20949],
Cell[9413, 349, 1246, 44, 70, "SeeAlso",
 CellID->2364]
}, Open  ]],
Cell[CellGroupData[{
Cell[10696, 398, 314, 9, 70, "TutorialsSection",
 CellID->28428],
Cell[11013, 409, 269, 9, 70, "Tutorials",
 CellID->16678],
Cell[11285, 420, 387, 12, 70, "Tutorials",
 CellID->15292152]
}, Open  ]],
Cell[11687, 435, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

