(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13798,        505]
NotebookOptionsPosition[      9684,        362]
NotebookOutlinePosition[     11784,        428]
CellTagsIndexPosition[     11670,        422]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "GUI Lifecycles in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/GUILifecycles"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"GUI Lifecycles in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CloseGUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/CloseGUIObject"], 
          "GUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIObject"], "GUIRun" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIRun"], 
          "ReleaseGUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/ReleaseGUIObject"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"CloseGUIObject\"\>", 
       2->"\<\"GUIObject\"\>", 3->"\<\"GUIRun\"\>", 
       4->"\<\"ReleaseGUIObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GUIObjectQ", "ObjectName",
 CellID->25519],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIObjectQ", "[", 
       StyleBox["ref", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["ref", "TI"]], "InlineFormula"],
     " is an active ",
     Cell[BoxData[
      ButtonBox["GUIObject",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
     " and otherwise returns ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14341]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GUIObjectQ"], "InlineFormula"],
 " is used to determine whether ",
 Cell[BoxData[
  StyleBox["ref", "TI"]], "InlineFormula"],
 " represents a live interface."
}], "Notes",
 CellID->26197],

Cell[TextData[{
 "Live interfaces are typically terminated either when the user closes the \
window by calling ",
 Cell[BoxData[
  ButtonBox["CloseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/CloseGUIObject"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ReleaseGUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"GUIObjectQ",
 CellID->8545]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->234580936],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->303559601],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->406472532],

Cell[TextData[{
 "Create a ",
 Cell[BoxData["GUIObject"], "InlineFormula"],
 " instance and assign it to a variable:"
}], "ExampleText",
 CellID->19736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->"GUIObjectQ",
 CellLabel->"In[2]:=",
 CellID->17438],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject101402147815425, 
   JLink`Objects`vm1`JavaObject412479062540289]]], "Output",
 CellTags->"GUIObjectQ",
 CellLabel->"Out[2]=",
 CellID->24362838]
}, Open  ]],

Cell[TextData[{
 "With the interface still running, test whether the variable references an \
active ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->30580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIObjectQ", "[", "ref", "]"}]], "Input",
 CellTags->"GUIObjectQ",
 CellLabel->"In[3]:=",
 CellID->27085],

Cell[BoxData["True"], "Output",
 CellTags->"GUIObjectQ",
 CellLabel->"Out[3]=",
 CellID->15013]
}, Open  ]],

Cell["Force the interface to terminate and release its resources:", \
"ExampleText",
 CellTags->"GUIObjectQ",
 CellID->5284],

Cell[BoxData[
 RowBox[{
  StyleBox["ReleaseGUIObject", "Output"], "[", "ref", "]"}]], "Input",
 CellTags->"GUIObjectQ",
 CellLabel->"In[4]:=",
 CellID->5253],

Cell[TextData[{
 "Test whether the variable still references an active ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["GUIObjectQ", "Output"], "[", "ref", "]"}]], "Input",
 CellTags->"GUIObjectQ",
 CellLabel->"In[5]:=",
 CellID->30285],

Cell[BoxData["False"], "Output",
 CellTags->"GUIObjectQ",
 CellLabel->"Out[5]=",
 CellID->133941312]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23791],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseGUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/CloseGUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRun",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRun"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseGUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13341]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1654],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->7158],

Cell[TextData[{
 ButtonBox["GUI Lifecycles in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/GUILifecycles"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/GUILifecycles"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/GUILifecycles"]
}], "Tutorials",
 CellID->314964108]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIObjectQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 22, 49.4477496}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "GUIObjectQ[ref] returns True if ref is an active GUIObject and otherwise \
returns False.", "synonyms" -> {}, "title" -> "GUIObjectQ", "type" -> 
    "Symbol", "uri" -> "GUIKit/ref/GUIObjectQ"}, "SearchTextTranslated" -> "",
   "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GUIObjectQ"->{
  Cell[4053, 132, 460, 15, 70, "Notes",
   CellTags->"GUIObjectQ",
   CellID->8545],
  Cell[5395, 187, 194, 6, 70, "Input",
   CellTags->"GUIObjectQ",
   CellID->17438],
  Cell[5592, 195, 302, 8, 70, "Output",
   CellTags->"GUIObjectQ",
   CellID->24362838],
  Cell[6206, 219, 129, 4, 70, "Input",
   CellTags->"GUIObjectQ",
   CellID->27085],
  Cell[6338, 225, 95, 3, 70, "Output",
   CellTags->"GUIObjectQ",
   CellID->15013],
  Cell[6448, 231, 124, 3, 70, "ExampleText",
   CellTags->"GUIObjectQ",
   CellID->5284],
  Cell[6575, 236, 157, 5, 70, "Input",
   CellTags->"GUIObjectQ",
   CellID->5253],
  Cell[7001, 255, 152, 5, 70, "Input",
   CellTags->"GUIObjectQ",
   CellID->30285],
  Cell[7156, 262, 100, 3, 70, "Output",
   CellTags->"GUIObjectQ",
   CellID->133941312]},
 "PrimaryExamplesSection"->{
  Cell[4550, 152, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->234580936]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GUIObjectQ", 10719, 387},
 {"PrimaryExamplesSection", 11527, 415}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1732, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2355, 68, 48, 1, 70, "ObjectName",
 CellID->25519],
Cell[2406, 71, 911, 30, 70, "Usage",
 CellID->14341]
}, Open  ]],
Cell[CellGroupData[{
Cell[3354, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3832, 123, 218, 7, 70, "Notes",
 CellID->26197],
Cell[4053, 132, 460, 15, 70, "Notes",
 CellTags->"GUIObjectQ",
 CellID->8545]
}, Closed]],
Cell[CellGroupData[{
Cell[4550, 152, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->234580936],
Cell[CellGroupData[{
Cell[4935, 166, 148, 5, 70, "ExampleSection",
 CellID->303559601],
Cell[5086, 173, 129, 3, 70, "Input",
 CellID->406472532],
Cell[5218, 178, 152, 5, 70, "ExampleText",
 CellID->19736],
Cell[CellGroupData[{
Cell[5395, 187, 194, 6, 70, "Input",
 CellTags->"GUIObjectQ",
 CellID->17438],
Cell[5592, 195, 302, 8, 70, "Output",
 CellTags->"GUIObjectQ",
 CellID->24362838]
}, Open  ]],
Cell[5909, 206, 272, 9, 70, "ExampleText",
 CellID->30580],
Cell[CellGroupData[{
Cell[6206, 219, 129, 4, 70, "Input",
 CellTags->"GUIObjectQ",
 CellID->27085],
Cell[6338, 225, 95, 3, 70, "Output",
 CellTags->"GUIObjectQ",
 CellID->15013]
}, Open  ]],
Cell[6448, 231, 124, 3, 70, "ExampleText",
 CellTags->"GUIObjectQ",
 CellID->5284],
Cell[6575, 236, 157, 5, 70, "Input",
 CellTags->"GUIObjectQ",
 CellID->5253],
Cell[6735, 243, 241, 8, 70, "ExampleText",
 CellID->20727],
Cell[CellGroupData[{
Cell[7001, 255, 152, 5, 70, "Input",
 CellTags->"GUIObjectQ",
 CellID->30285],
Cell[7156, 262, 100, 3, 70, "Output",
 CellTags->"GUIObjectQ",
 CellID->133941312]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7317, 272, 311, 9, 70, "SeeAlsoSection",
 CellID->23791],
Cell[7631, 283, 995, 35, 70, "SeeAlso",
 CellID->13341]
}, Open  ]],
Cell[CellGroupData[{
Cell[8663, 323, 313, 9, 70, "TutorialsSection",
 CellID->1654],
Cell[8979, 334, 268, 9, 70, "Tutorials",
 CellID->7158],
Cell[9250, 345, 392, 12, 70, "Tutorials",
 CellID->314964108]
}, Open  ]],
Cell[9657, 360, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

