(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14859,        537]
NotebookOptionsPosition[     10377,        381]
NotebookOutlinePosition[     12678,        453]
CellTagsIndexPosition[     12539,        446]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Resolving Arbitrary Objects in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/ResolvingArbitraryObjects"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Resolving Arbitrary Objects in GUIKit User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUILoad" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUILoad"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GUILoad\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GUIResolve", "ObjectName",
 CellID->14363],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIResolve", "[", 
       StyleBox["src", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]resolves an interface definition to its top-level \
completely loaded widget and enclosing widgets."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIResolve", "[", 
       RowBox[{
        StyleBox["src", "TI"], ",", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]passes arguments to the interface definition."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GUIResolve"], "InlineFormula"],
 " returns the top-level root widget in a definition, possibly modified with \
some scripting."
}], "Notes",
 CellTags->"GUIResolve",
 CellID->14726],

Cell[TextData[{
 Cell[BoxData["GUIResolve"], "InlineFormula"],
 " does not create a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " for post-manipulation; nor does it preserve an environment."
}], "Notes",
 CellID->201],

Cell[TextData[{
 Cell[BoxData["GUIResolve"], "InlineFormula"],
 " is a variant of ",
 Cell[BoxData[
  ButtonBox["GUILoad",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUILoad"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6424],

Cell[TextData[{
 Cell[BoxData["GUIResolve"], "InlineFormula"],
 " is useful for loading model widgets within an interface library where the \
non-GUI content is dynamically populated with scripting."
}], "Notes",
 CellTags->"GUIResolve",
 CellID->24083],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["src", "TI"]], "InlineFormula"],
 " can be a filename, a user interface expression definition, an XMLDocument \
interface expression, or a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"GUIRun",
 CellID->553],

Cell[TextData[{
 "If arguments are included, they are passed as arguments to the interface \
definition and are available from the widget registry through the names ",
 Cell[BoxData["\"\<##\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<#1\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<#2\>\""], "InlineFormula"],
 ", and so forth."
}], "Notes",
 CellTags->"GUIRun",
 CellID->26271],

Cell["The following options can be given: ", "Notes",
 CellID->6955],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ReleaseMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/ReleaseMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "determines when a ",
     Cell[BoxData[
      ButtonBox["GUIObject",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
     " is released"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IncludedScriptContexts",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/IncludedScriptContexts"], 
    RowBox[{"{", "}"}], Cell[TextData[{
     "extends the active ",
     Cell[BoxData[
      ButtonBox["$ContextPath",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
     " that ",
     Cell[BoxData[
      ButtonBox["Script",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
     " blocks use"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->9389]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->132675087],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->136059864],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->328455419],

Cell["\<\
Load and resolve a definition whose top-level widget is a list object:\
\>", "ExampleText",
 CellID->11324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", " ", "=", " ", 
  RowBox[{
  "GUIResolve", "[", " ", "\"\<Wolfram/Example/List\>\"", "]"}]}]], "Input",
 CellTags->"GUIResolve",
 CellLabel->"In[2]:=",
 CellID->19773],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
   "\[LeftGuillemet]JavaObject", "[", "\<\"java.util.ArrayList\"\>", "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject33135594188046337]], "Output",
 CellTags->"GUIResolve",
 CellLabel->"Out[2]=",
 CellID->27740]
}, Open  ]],

Cell[" The content is populated with values within the definition:", \
"ExampleText",
 CellID->18255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", " ", "@", " ", 
  RowBox[{"size", "[", "]"}]}]], "Input",
 CellTags->"GUIResolve",
 CellLabel->"In[3]:=",
 CellID->4468],

Cell[BoxData["7"], "Output",
 CellTags->"GUIResolve",
 CellLabel->"Out[3]=",
 CellID->22070]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"l", " ", "@", " ", 
   RowBox[{"toString", "[", "]"}]}], " ", "//", " ", "InputForm"}]], "Input",
 CellTags->"GUIResolve",
 CellLabel->"In[4]:=",
 CellID->16843],

Cell["\<\

\"[java.awt.Label[label0,0,0,0x0,invalid,align=left,text=Label1], string1, 
string2, \\

java.awt.Label[label1,0,0,0x0,invalid,align=left,text=Label2], Mon Jan 20 
15:22:50 CST 2003, \\

3628800, 34]\"
\
\>", "Output",
 CellTags->"GUIResolve",
 CellLabel->"Out[4]//InputForm=",
 CellID->10030]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28745],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["GUILoad",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUILoad"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->6170]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7389],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->20735],

Cell[TextData[{
 ButtonBox["Resolving Arbitrary Objects in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/ResolvingArbitraryObjects"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/ResolvingArbitraryObjects"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/ResolvingArbitraryObjects"]
}], "Tutorials",
 CellID->231179096]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIResolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 22, 50.5570678}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "GUIResolve[src] resolves an interface definition to its top-level \
completely loaded widget and enclosing widgets. GUIResolve[src, args] passes \
arguments to the interface definition.", "synonyms" -> {}, "title" -> 
    "GUIResolve", "type" -> "Symbol", "uri" -> "GUIKit/ref/GUIResolve"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GUIResolve"->{
  Cell[3293, 107, 212, 6, 70, "Notes",
   CellTags->"GUIResolve",
   CellID->14726],
  Cell[4061, 137, 253, 6, 70, "Notes",
   CellTags->"GUIResolve",
   CellID->24083],
  Cell[7292, 251, 195, 6, 70, "Input",
   CellTags->"GUIResolve",
   CellID->19773],
  Cell[7490, 259, 280, 9, 70, "Output",
   CellTags->"GUIResolve",
   CellID->27740],
  Cell[7911, 277, 148, 5, 70, "Input",
   CellTags->"GUIResolve",
   CellID->4468],
  Cell[8062, 284, 92, 3, 70, "Output",
   CellTags->"GUIResolve",
   CellID->22070],
  Cell[8191, 292, 196, 6, 70, "Input",
   CellTags->"GUIResolve",
   CellID->16843],
  Cell[8390, 300, 304, 13, 70, "Output",
   CellTags->"GUIResolve",
   CellID->10030]},
 "GUIRun"->{
  Cell[4317, 145, 364, 12, 70, "Notes",
   CellTags->"GUIRun",
   CellID->553],
  Cell[4684, 159, 391, 11, 70, "Notes",
   CellTags->"GUIRun",
   CellID->26271]},
 "PrimaryExamplesSection"->{
  Cell[6482, 218, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->132675087]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GUIResolve", 11508, 407},
 {"GUIRun", 12204, 432},
 {"PrimaryExamplesSection", 12396, 439}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1371, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1994, 61, 48, 1, 70, "ObjectName",
 CellID->14363],
Cell[2045, 64, 733, 21, 70, "Usage",
 CellID->22957]
}, Open  ]],
Cell[CellGroupData[{
Cell[2815, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3293, 107, 212, 6, 70, "Notes",
 CellTags->"GUIResolve",
 CellID->14726],
Cell[3508, 115, 305, 9, 70, "Notes",
 CellID->201],
Cell[3816, 126, 242, 9, 70, "Notes",
 CellID->6424],
Cell[4061, 137, 253, 6, 70, "Notes",
 CellTags->"GUIResolve",
 CellID->24083],
Cell[4317, 145, 364, 12, 70, "Notes",
 CellTags->"GUIRun",
 CellID->553],
Cell[4684, 159, 391, 11, 70, "Notes",
 CellTags->"GUIRun",
 CellID->26271],
Cell[5078, 172, 68, 1, 70, "Notes",
 CellID->6955],
Cell[5149, 175, 1296, 38, 70, "3ColumnTableMod",
 CellID->9389]
}, Closed]],
Cell[CellGroupData[{
Cell[6482, 218, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->132675087],
Cell[CellGroupData[{
Cell[6867, 232, 148, 5, 70, "ExampleSection",
 CellID->136059864],
Cell[7018, 239, 129, 3, 70, "Input",
 CellID->328455419],
Cell[7150, 244, 117, 3, 70, "ExampleText",
 CellID->11324],
Cell[CellGroupData[{
Cell[7292, 251, 195, 6, 70, "Input",
 CellTags->"GUIResolve",
 CellID->19773],
Cell[7490, 259, 280, 9, 70, "Output",
 CellTags->"GUIResolve",
 CellID->27740]
}, Open  ]],
Cell[7785, 271, 101, 2, 70, "ExampleText",
 CellID->18255],
Cell[CellGroupData[{
Cell[7911, 277, 148, 5, 70, "Input",
 CellTags->"GUIResolve",
 CellID->4468],
Cell[8062, 284, 92, 3, 70, "Output",
 CellTags->"GUIResolve",
 CellID->22070]
}, Open  ]],
Cell[CellGroupData[{
Cell[8191, 292, 196, 6, 70, "Input",
 CellTags->"GUIResolve",
 CellID->16843],
Cell[8390, 300, 304, 13, 70, "Output",
 CellTags->"GUIResolve",
 CellID->10030]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8755, 320, 311, 9, 70, "SeeAlsoSection",
 CellID->28745],
Cell[9069, 331, 200, 6, 70, "SeeAlso",
 CellID->6170]
}, Open  ]],
Cell[CellGroupData[{
Cell[9306, 342, 313, 9, 70, "TutorialsSection",
 CellID->7389],
Cell[9622, 353, 269, 9, 70, "Tutorials",
 CellID->20735],
Cell[9894, 364, 441, 12, 70, "Tutorials",
 CellID->231179096]
}, Open  ]],
Cell[10350, 379, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

