(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26521,        689]
NotebookOptionsPosition[     22286,        555]
NotebookOutlinePosition[     24733,        624]
CellTagsIndexPosition[     24533,        616]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Executing GUIs in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/ExecutingGUIs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Executing GUIs in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CloseGUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/CloseGUIObject"], 
          "GUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIObject"], 
          "GUIRunModal" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIRunModal"], 
          "ReleaseGUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/ReleaseGUIObject"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"CloseGUIObject\"\>", 
       2->"\<\"GUIObject\"\>", 3->"\<\"GUIRunModal\"\>", 
       4->"\<\"ReleaseGUIObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GUIRun", "ObjectName",
 CellID->27222],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIRun", "[", 
       StyleBox["src", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]loads and runs an interface definition in a modeless \
state and returns immediately with a ",
     Cell[BoxData[
      ButtonBox["GUIObject",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
     " expression that represents the live interface."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIRun", "[", 
       RowBox[{
        StyleBox["src", "TI"], ",", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]passes arguments to the interface definition."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["src", "TI"]], "InlineFormula"],
 " can be a filename, a user interface expression definition, an XMLDocument \
interface expression, or a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"GUIRun",
 CellID->553],

Cell[TextData[{
 "If arguments are included, they are passed as arguments to the interface \
definition and are available from the widget registry through the names ",
 Cell[BoxData["\"\<##\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<#1\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<#2\>\""], "InlineFormula"],
 ", and so forth."
}], "Notes",
 CellTags->"GUIRun",
 CellID->26271],

Cell["The following options can be given: ", "Notes",
 CellID->6955],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ReleaseMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/ReleaseMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "determines when a ",
     Cell[BoxData[
      ButtonBox["GUIObject",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
     " is released"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IncludedScriptContexts",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/IncludedScriptContexts"], 
    RowBox[{"{", "}"}], Cell[TextData[{
     "extends the active ",
     Cell[BoxData[
      ButtonBox["$ContextPath",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
     " that ",
     Cell[BoxData[
      ButtonBox["Script",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
     " blocks use"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->9389]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->240405704],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->131054679],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->89000789],

Cell["Run an interface definition:", "ExampleText",
 CellID->24192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->{"GUIRun", "Ex--21907744555570480354,7"},
 CellLabel->"In[2]:=",
 CellID->32530],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject443519378391041, 
   JLink`Objects`JavaObject69433968033793]]], "Output",
 CellTags->{"GUIRun", "Ex--21907744555570480354,7"},
 CellLabel->"Out[2]=",
 CellID->12618]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907744555570480354,8",
 CellLabel->"In[3]:=",
 CellID->3148],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{270, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907744555570480354,8",
 CellLabel->"Out[3]=",
 CellID->93049547]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1527],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseGUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/CloseGUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRunModal",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRunModal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseGUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20394]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27625],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->8029],

Cell[TextData[{
 ButtonBox["Executing GUIs in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/ExecutingGUIs"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/ExecutingGUIs"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/ExecutingGUIs"]
}], "Tutorials",
 CellID->250222598]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIRun - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 22, 52.7600800}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "GUIRun[src] loads and runs an interface definition in a modeless state \
and returns immediately with a GUIObject expression that represents the live \
interface. GUIRun[src, args] passes arguments to the interface definition.", 
    "synonyms" -> {}, "title" -> "GUIRun", "type" -> "Symbol", "uri" -> 
    "GUIKit/ref/GUIRun"}, "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GUIRun"->{
  Cell[3861, 120, 364, 12, 70, "Notes",
   CellTags->"GUIRun",
   CellID->553],
  Cell[4228, 134, 391, 11, 70, "Notes",
   CellTags->"GUIRun",
   CellID->26271],
  Cell[6785, 224, 212, 6, 70, "Input",
   CellTags->{"GUIRun", "Ex--21907744555570480354,7"},
   CellID->32530],
  Cell[7000, 232, 318, 8, 70, "Output",
   CellTags->{"GUIRun", "Ex--21907744555570480354,7"},
   CellID->12618]},
 "PrimaryExamplesSection"->{
  Cell[6026, 193, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->240405704]},
 "Ex--21907744555570480354,7"->{
  Cell[6785, 224, 212, 6, 70, "Input",
   CellTags->{"GUIRun", "Ex--21907744555570480354,7"},
   CellID->32530],
  Cell[7000, 232, 318, 8, 70, "Output",
   CellTags->{"GUIRun", "Ex--21907744555570480354,7"},
   CellID->12618]},
 "Ex--21907744555570480354,8"->{
  Cell[7355, 245, 147, 4, 70, "Input",
   CellTags->"Ex--21907744555570480354,8",
   CellID->3148],
  Cell[7505, 251, 12343, 207, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907744555570480354,8",
   CellID->93049547]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GUIRun", 23444, 581},
 {"PrimaryExamplesSection", 23863, 594},
 {"Ex--21907744555570480354,7", 24016, 598},
 {"Ex--21907744555570480354,8", 24277, 605}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1758, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2381, 69, 44, 1, 70, "ObjectName",
 CellID->27222],
Cell[2428, 72, 918, 26, 70, "Usage",
 CellID->22957]
}, Open  ]],
Cell[CellGroupData[{
Cell[3383, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3861, 120, 364, 12, 70, "Notes",
 CellTags->"GUIRun",
 CellID->553],
Cell[4228, 134, 391, 11, 70, "Notes",
 CellTags->"GUIRun",
 CellID->26271],
Cell[4622, 147, 68, 1, 70, "Notes",
 CellID->6955],
Cell[4693, 150, 1296, 38, 70, "3ColumnTableMod",
 CellID->9389]
}, Closed]],
Cell[CellGroupData[{
Cell[6026, 193, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->240405704],
Cell[CellGroupData[{
Cell[6411, 207, 148, 5, 70, "ExampleSection",
 CellID->131054679],
Cell[6562, 214, 128, 3, 70, "Input",
 CellID->89000789],
Cell[6693, 219, 67, 1, 70, "ExampleText",
 CellID->24192],
Cell[CellGroupData[{
Cell[6785, 224, 212, 6, 70, "Input",
 CellTags->{"GUIRun", "Ex--21907744555570480354,7"},
 CellID->32530],
Cell[7000, 232, 318, 8, 70, "Output",
 CellTags->{"GUIRun", "Ex--21907744555570480354,7"},
 CellID->12618]
}, Open  ]],
Cell[CellGroupData[{
Cell[7355, 245, 147, 4, 70, "Input",
 CellTags->"Ex--21907744555570480354,8",
 CellID->3148],
Cell[7505, 251, 12343, 207, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907744555570480354,8",
 CellID->93049547]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19909, 465, 310, 9, 70, "SeeAlsoSection",
 CellID->1527],
Cell[20222, 476, 1005, 35, 70, "SeeAlso",
 CellID->20394]
}, Open  ]],
Cell[CellGroupData[{
Cell[21264, 516, 314, 9, 70, "TutorialsSection",
 CellID->27625],
Cell[21581, 527, 268, 9, 70, "Tutorials",
 CellID->8029],
Cell[21852, 538, 392, 12, 70, "Tutorials",
 CellID->250222598]
}, Open  ]],
Cell[22259, 553, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

