(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15444,        535]
NotebookOptionsPosition[     11535,        402]
NotebookOutlinePosition[     13419,        458]
CellTagsIndexPosition[     13304,        452]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Executing GUIs in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/ExecutingGUIs"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Executing GUIs in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CloseGUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/CloseGUIObject"], 
          "GUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIObject"], "GUIRun" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIRun"], 
          "ReleaseGUIObject" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/ReleaseGUIObject"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"CloseGUIObject\"\>", 
       2->"\<\"GUIObject\"\>", 3->"\<\"GUIRun\"\>", 
       4->"\<\"ReleaseGUIObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GUIRunModal", "ObjectName",
 CellID->1052],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIRunModal", "[", 
       StyleBox["src", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]loads and runs an interface definition in a modal \
state with the kernel and returns a result when finished."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GUIRunModal", "[", 
       RowBox[{
        StyleBox["src", "TI"], ",", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]passes arguments to the interface definition."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GUIRunModal"], "InlineFormula"],
 " does not return control to the kernel until the interface is closed."
}], "Notes",
 CellID->21256],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["src", "TI"]], "InlineFormula"],
 " can be a filename, a user interface expression definition, an XMLDocument \
interface expression, or a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11110],

Cell[TextData[{
 "If arguments are included, they are passed as arguments to the interface \
definition and are available from the widget registry through the names ",
 Cell[BoxData["\"\<##\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<#1\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<#2\>\""], "InlineFormula"],
 ", and so on."
}], "Notes",
 CellTags->"GUIRunModal",
 CellID->32057],

Cell["The following options can be given: ", "Notes",
 CellID->10666],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ReleaseMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/ReleaseMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "determines when a ",
     Cell[BoxData[
      ButtonBox["GUIObject",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
     " is released"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ReturnScript",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/ReturnScript"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "a script expression to evaluate as the return result", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IncludedScriptContexts",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/IncludedScriptContexts"], 
    RowBox[{"{", "}"}], Cell[TextData[{
     "extends the active ",
     Cell[BoxData[
      ButtonBox["$ContextPath",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
     " that ",
     Cell[BoxData[
      ButtonBox["Script",
       BaseStyle->"Link",
       ButtonData->"paclet:GUIKit/ref/Script"]], "InlineFormula"],
     " blocks use"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->26250]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15968071],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->382070550],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->19526745],

Cell["Run a user interface definition in a modal state:", "ExampleText",
 CellID->20016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", "\"\<Wolfram/Example/Calculator\>\"", 
  "]"}]], "Input",
 CellTags->"GUIRunModal",
 CellLabel->"In[2]:=",
 CellID->21858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"FirstArgumentField\"\>", "\[Rule]", "45"}], ",", 
   RowBox[{"\<\"SecondArgumentField\"\>", "\[Rule]", "45455"}], ",", 
   RowBox[{"\<\"SumField\"\>", "\[Rule]", "45500"}], ",", 
   RowBox[{"\<\"DifferenceField\"\>", "\[Rule]", 
    RowBox[{"-", "45410"}]}], ",", 
   RowBox[{"\<\"ProductField\"\>", "\[Rule]", "2045475"}], ",", 
   RowBox[{"\<\"QuotientField\"\>", "\[Rule]", 
    FractionBox["9", "9091"]}]}], "}"}]], "Output",
 CellTags->"GUIRunModal",
 CellLabel->"Out[2]=",
 CellID->23934]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3815],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ReturnScript",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21174],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->160911545],

Cell["Override the return result:", "ExampleText",
 CellID->30582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", 
  RowBox[{
  "\"\<Wolfram/Example/Calculator\>\"", ",", "\[IndentingNewLine]", "   ", 
   RowBox[{"ReturnScript", " ", "\[RuleDelayed]", 
    RowBox[{"ToExpression", "[", " ", 
     RowBox[{"PropertyValue", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<SumField\>\"", ",", "\"\<text\>\""}], "}"}], "]"}], 
     "]"}]}]}], "]"}]], "Input",
 CellTags->"GUIRunModal",
 CellLabel->"In[2]:=",
 CellID->12082],

Cell[BoxData["898807"], "Output",
 CellTags->"GUIRunModal",
 CellLabel->"Out[2]=",
 CellID->14024]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5874],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseGUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/CloseGUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRun",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRun"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseGUIObject",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/ReleaseGUIObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25774]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12670],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->8029],

Cell[TextData[{
 ButtonBox["Executing GUIs in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/ExecutingGUIs"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/ExecutingGUIs"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/ExecutingGUIs"]
}], "Tutorials",
 CellID->250222598]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GUIRunModal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 22, 51.6663860}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "GUIRunModal[src] loads and runs an interface definition in a modal state \
with the kernel and returns a result when finished. GUIRunModal[src, args] \
passes arguments to the interface definition.", "synonyms" -> {"run modal"}, 
    "title" -> "GUIRunModal", "type" -> "Symbol", "uri" -> 
    "GUIKit/ref/GUIRunModal"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GUIRunModal"->{
  Cell[4182, 133, 393, 11, 70, "Notes",
   CellTags->"GUIRunModal",
   CellID->32057],
  Cell[7083, 231, 165, 5, 70, "Input",
   CellTags->"GUIRunModal",
   CellID->21858],
  Cell[7251, 238, 550, 13, 70, "Output",
   CellTags->"GUIRunModal",
   CellID->23934],
  Cell[8547, 287, 447, 12, 70, "Input",
   CellTags->"GUIRunModal",
   CellID->12082],
  Cell[8997, 301, 98, 3, 70, "Output",
   CellTags->"GUIRunModal",
   CellID->14024]},
 "PrimaryExamplesSection"->{
  Cell[6304, 200, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->15968071]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GUIRunModal", 12698, 429},
 {"PrimaryExamplesSection", 13162, 445}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1732, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2355, 68, 48, 1, 70, "ObjectName",
 CellID->1052],
Cell[2406, 71, 745, 21, 70, "Usage",
 CellID->22957]
}, Open  ]],
Cell[CellGroupData[{
Cell[3188, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3666, 114, 165, 4, 70, "Notes",
 CellID->21256],
Cell[3834, 120, 345, 11, 70, "Notes",
 CellID->11110],
Cell[4182, 133, 393, 11, 70, "Notes",
 CellTags->"GUIRunModal",
 CellID->32057],
Cell[4578, 146, 69, 1, 70, "Notes",
 CellID->10666],
Cell[4650, 149, 1617, 46, 70, "3ColumnTableMod",
 CellID->26250]
}, Closed]],
Cell[CellGroupData[{
Cell[6304, 200, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15968071],
Cell[CellGroupData[{
Cell[6688, 214, 148, 5, 70, "ExampleSection",
 CellID->382070550],
Cell[6839, 221, 128, 3, 70, "Input",
 CellID->19526745],
Cell[6970, 226, 88, 1, 70, "ExampleText",
 CellID->20016],
Cell[CellGroupData[{
Cell[7083, 231, 165, 5, 70, "Input",
 CellTags->"GUIRunModal",
 CellID->21858],
Cell[7251, 238, 550, 13, 70, "Output",
 CellTags->"GUIRunModal",
 CellID->23934]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7850, 257, 217, 7, 70, "ExampleSection",
 CellID->3815],
Cell[CellGroupData[{
Cell[8092, 268, 229, 7, 70, "ExampleSubsection",
 CellID->21174],
Cell[8324, 277, 129, 3, 70, "Input",
 CellID->160911545],
Cell[8456, 282, 66, 1, 70, "ExampleText",
 CellID->30582],
Cell[CellGroupData[{
Cell[8547, 287, 447, 12, 70, "Input",
 CellTags->"GUIRunModal",
 CellID->12082],
Cell[8997, 301, 98, 3, 70, "Output",
 CellTags->"GUIRunModal",
 CellID->14024]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9168, 312, 310, 9, 70, "SeeAlsoSection",
 CellID->5874],
Cell[9481, 323, 995, 35, 70, "SeeAlso",
 CellID->25774]
}, Open  ]],
Cell[CellGroupData[{
Cell[10513, 363, 314, 9, 70, "TutorialsSection",
 CellID->12670],
Cell[10830, 374, 268, 9, 70, "Tutorials",
 CellID->8029],
Cell[11101, 385, 392, 12, 70, "Tutorials",
 CellID->250222598]
}, Open  ]],
Cell[11508, 400, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

