(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13803,        486]
NotebookOptionsPosition[      9916,        348]
NotebookOutlinePosition[     11935,        413]
CellTagsIndexPosition[     11825,        407]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Scripting GUIs in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/InteractionWithMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Scripting GUIs in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InvokeMethod" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/InvokeMethod"], 
          "Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InvokeMethod\"\>", 
       2->"\<\"Widget\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Script", "ObjectName",
 CellID->28983],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Script", "[", 
       StyleBox["scriptcode", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]defines a script to be used either on load or during \
an event."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5987]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Script"], "InlineFormula"],
 " is used to associate scripting code either as general code to be executed \
when the widget definition is read in or as code bound to a specific event, \
to be executed each time the event occurs within a ",
 Cell[BoxData[
  ButtonBox["BindEvent",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/BindEvent"]], "InlineFormula"],
 " expression."
}], "Notes",
 CellTags->"Script",
 CellID->10823],

Cell[TextData[{
 "By default, the language of a ",
 Cell[BoxData["Script"], "InlineFormula"],
 " is ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code unless an alternate language is specified. You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Language",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Language"], " ", "->", " ", "\"\<\!\(\*
StyleBox[\"xml\", \"TI\"]\)\>\""}]], "InlineFormula"],
 " to specify that the content of the ",
 Cell[BoxData["Script"], "InlineFormula"],
 " is a string of ",
 Cell[BoxData[
  ButtonBox["GUIKitXML",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/tutorial/XMLReference"]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"Script",
 CellID->397],

Cell[TextData[{
 Cell[BoxData["Script"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 " so that evaluation does not occur when processing ",
 Cell[BoxData["Script"], "InlineFormula"],
 " blocks."
}], "Notes",
 CellTags->"Script",
 CellID->11096],

Cell["The following options can be given: ", "Notes",
 CellID->16594],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Language",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Language"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the language the script code is written in", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScriptSource",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/ScriptSource"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "an external file that contains the script code", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->8901]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77931477],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->14667096],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->584762843],

Cell[TextData[{
 "Define a function to be called whenever a button's ",
 Cell[BoxData["\"\<action\>\""], "InlineFormula"],
 " event occurs:"
}], "ExampleText",
 CellID->15665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIRunModal", "[", 
  RowBox[{"Widget", "[", 
   RowBox[{"\"\<Button\>\"", ",", "\[IndentingNewLine]", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<text\>\"", "->", "\"\<Update\>\""}], ",", " ", 
      "\[IndentingNewLine]", " ", 
      RowBox[{"BindEvent", "[", 
       RowBox[{"\"\<action\>\"", ",", " ", "\[IndentingNewLine]", "  ", 
        RowBox[{"Script", "[", 
         RowBox[{"updateList", "[", "]"}], "]"}]}], " ", 
       "\[IndentingNewLine]", "   ", "]"}], ",", 
      RowBox[{"Script", "[", 
       RowBox[{
        RowBox[{"updateList", "[", "]"}], ":=", 
        RowBox[{"Print", "[", "\"\<Updating list...\>\"", "]"}]}], "]"}]}], 
     "\[IndentingNewLine]", " ", "}"}]}], "]"}], "]"}]], "Input",
 CellTags->"Script",
 CellLabel->"In[2]:=",
 CellID->2732],

Cell[CellGroupData[{

Cell[BoxData["\<\"Updating list...\"\>"], "Print",
 CellTags->"Script",
 CellLabel->"During evaluation of In[58]:=",
 CellID->12280],

Cell[BoxData["\<\"Updating list...\"\>"], "Print",
 CellTags->"Script",
 CellLabel->"During evaluation of In[58]:=",
 CellID->25167],

Cell[BoxData["\<\"Updating list...\"\>"], "Print",
 CellTags->"Script",
 CellLabel->"During evaluation of In[58]:=",
 CellID->16966],

Cell[BoxData["\<\"Updating list...\"\>"], "Print",
 CellTags->"Script",
 CellLabel->"During evaluation of In[58]:=",
 CellID->25690],

Cell[BoxData["\<\"Updating list...\"\>"], "Print",
 CellTags->"Script",
 CellLabel->"During evaluation of In[58]:=",
 CellID->868]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InvokeMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/InvokeMethod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1932]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17653],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->14520],

Cell[TextData[{
 ButtonBox["Scripting GUIs in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/InteractionWithMathematica"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/InteractionWithMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/InteractionWithMathematica"]
}], "Tutorials",
 CellID->104159790]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Script - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 4.7594656}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "Script[scriptcode] defines a script to be used either on load or during \
an event.", "synonyms" -> {}, "title" -> "Script", "type" -> "Symbol", "uri" -> 
    "GUIKit/ref/Script"}, "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Script"->{
  Cell[3093, 102, 463, 12, 70, "Notes",
   CellTags->"Script",
   CellID->10823],
  Cell[3559, 116, 708, 23, 70, "Notes",
   CellTags->"Script",
   CellID->397],
  Cell[4270, 141, 361, 12, 70, "Notes",
   CellTags->"Script",
   CellID->11096],
  Cell[6461, 221, 809, 20, 70, "Input",
   CellTags->"Script",
   CellID->2732],
  Cell[7295, 245, 132, 3, 70, "Print",
   CellTags->"Script",
   CellID->12280],
  Cell[7430, 250, 132, 3, 70, "Print",
   CellTags->"Script",
   CellID->25167],
  Cell[7565, 255, 132, 3, 70, "Print",
   CellTags->"Script",
   CellID->16966],
  Cell[7700, 260, 132, 3, 70, "Print",
   CellTags->"Script",
   CellID->25690],
  Cell[7835, 265, 130, 3, 70, "Print",
   CellTags->"Script",
   CellID->868]},
 "PrimaryExamplesSection"->{
  Cell[5595, 186, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->77931477]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Script", 10925, 372},
 {"PrimaryExamplesSection", 11683, 400}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1484, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2107, 64, 44, 1, 70, "ObjectName",
 CellID->28983],
Cell[2154, 67, 424, 13, 70, "Usage",
 CellID->5987]
}, Open  ]],
Cell[CellGroupData[{
Cell[2615, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3093, 102, 463, 12, 70, "Notes",
 CellTags->"Script",
 CellID->10823],
Cell[3559, 116, 708, 23, 70, "Notes",
 CellTags->"Script",
 CellID->397],
Cell[4270, 141, 361, 12, 70, "Notes",
 CellTags->"Script",
 CellID->11096],
Cell[4634, 155, 69, 1, 70, "Notes",
 CellID->16594],
Cell[4706, 158, 852, 23, 70, "3ColumnTableMod",
 CellID->8901]
}, Closed]],
Cell[CellGroupData[{
Cell[5595, 186, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77931477],
Cell[CellGroupData[{
Cell[5979, 200, 147, 5, 70, "ExampleSection",
 CellID->14667096],
Cell[6129, 207, 129, 3, 70, "Input",
 CellID->584762843],
Cell[6261, 212, 175, 5, 70, "ExampleText",
 CellID->15665],
Cell[CellGroupData[{
Cell[6461, 221, 809, 20, 70, "Input",
 CellTags->"Script",
 CellID->2732],
Cell[CellGroupData[{
Cell[7295, 245, 132, 3, 70, "Print",
 CellTags->"Script",
 CellID->12280],
Cell[7430, 250, 132, 3, 70, "Print",
 CellTags->"Script",
 CellID->25167],
Cell[7565, 255, 132, 3, 70, "Print",
 CellTags->"Script",
 CellID->16966],
Cell[7700, 260, 132, 3, 70, "Print",
 CellTags->"Script",
 CellID->25690],
Cell[7835, 265, 130, 3, 70, "Print",
 CellTags->"Script",
 CellID->868]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8038, 276, 308, 9, 70, "SeeAlsoSection",
 CellID->20],
Cell[8349, 287, 468, 17, 70, "SeeAlso",
 CellID->1932]
}, Open  ]],
Cell[CellGroupData[{
Cell[8854, 309, 314, 9, 70, "TutorialsSection",
 CellID->17653],
Cell[9171, 320, 269, 9, 70, "Tutorials",
 CellID->14520],
Cell[9443, 331, 431, 12, 70, "Tutorials",
 CellID->104159790]
}, Open  ]],
Cell[9889, 346, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

