(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29272,        801]
NotebookOptionsPosition[     23496,        618]
NotebookOutlinePosition[     26613,        704]
CellTagsIndexPosition[     26336,        694]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Properties in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/WidgetBasics#112718872"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Properties in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PropertyValue" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/PropertyValue"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"PropertyValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetPropertyValue", "ObjectName",
 CellID->5234],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetPropertyValue", "[", 
       RowBox[{
        StyleBox["name", "TI"], ",", 
        StyleBox["value", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]sets a widget property value."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetPropertyValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["target", "TI"], ",", 
          StyleBox["name", "TI"]}], 
         StyleBox["}", "TI"]}], ",", 
        StyleBox["value", "TI"]}], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{"SetPropertyValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["target", "TI"], ",", 
          StyleBox["name", "TI"]}], 
         StyleBox["}", "TI"]}], "->", 
        StyleBox["value", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]sets a widget property value, specifying the target \
widget."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetPropertyValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["target", "TI"], ",", 
          StyleBox["name", "TI"], ",", 
          StyleBox["index", "TI"]}], "}"}], ",", 
        StyleBox["value", "TI"]}], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{"SetPropertyValue", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["target", "TI"], ",", 
          StyleBox["name", "TI"], ",", 
          StyleBox["index", "TI"]}], "}"}], "->", 
        StyleBox["value", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]sets an indexed widget property value, specifying the \
target widget."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26841]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given: ", "Notes",
 CellID->24019],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Name",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/Name"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
a name with which to register the property value within the widget registry\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->25352]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19258968],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->510945232],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->343192374],

Cell["Run an interface definition:", "ExampleText",
 CellID->15842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->{"GUIRun", "Ex--21907757649578436210,2"},
 CellLabel->"In[2]:=",
 CellID->5694],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject347884851560449, 
   JLink`Objects`JavaObject452978121113601]]], "Output",
 CellTags->{"GUIRun", "Ex--21907757649578436210,2"},
 CellLabel->"Out[2]=",
 CellID->5084]
}, Open  ]],

Cell[TextData[{
 "Set the ",
 Cell[BoxData["\"\<text\>\""], "InlineFormula"],
 " property of the ",
 Cell[BoxData["\"\<FirstArgumentField\>\""], "InlineFormula"],
 " widget:"
}], "ExampleText",
 CellID->21535],

Cell[BoxData[
 RowBox[{"ref", "@", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<FirstArgumentField\>\"", ",", "\"\<text\>\""}], "}"}], ",", 
    "5"}], "]"}]}]], "Input",
 CellTags->{"PropertyValue", "Ex--21907757649578436210,3"},
 CellLabel->"In[3]:=",
 CellID->16500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907757649578436210,4",
 CellLabel->"In[4]:=",
 CellID->10955],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{270, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907757649578436210,4",
 CellLabel->"Out[4]=",
 CellID->800710817]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5939],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Name",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4010],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->160911545],

Cell["Run an interface definition:", "ExampleText",
 CellID->14932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{
  "GUIRun", "[", "\"\<Wolfram/Example/Calculator\>\"", "]"}]}]], "Input",
 CellTags->"GUIRun",
 CellLabel->"In[2]:=",
 CellID->14948],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject85895772372993, 
   JLink`Objects`JavaObject205106045779969]]], "Output",
 CellTags->"GUIRun",
 CellLabel->"Out[2]=",
 CellID->31210]
}, Open  ]],

Cell[TextData[{
 "Set a property value and register the value with the name ",
 Cell[BoxData["\"\<savedArgument\>\""], "InlineFormula"],
 " in the widget registry:"
}], "ExampleText",
 CellID->3495],

Cell[BoxData[
 RowBox[{"ref", "@", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<FirstArgumentField\>\"", ",", "\"\<text\>\""}], "}"}], ",", 
    "5", ",", " ", 
    RowBox[{"Name", "->", "\"\<savedArgument\>\""}]}], "]"}]}]], "Input",
 CellTags->"PropertyValue",
 CellLabel->"In[3]:=",
 CellID->26419],

Cell[TextData[{
 "Now this value can be referenced separately using ",
 Cell[BoxData[
  ButtonBox["WidgetReference",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetReference"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "@", 
  RowBox[{"WidgetReference", "[", "\"\<savedArgument\>\"", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4189],

Cell[BoxData["5"], "Output",
 CellLabel->"Out[4]=",
 CellID->10171]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17405],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["PropertyValue",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/PropertyValue"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->6881]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14062],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->18456],

Cell[TextData[{
 ButtonBox["Properties in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics#112718872"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics#112718872"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics#112718872"]
}], "Tutorials",
 CellID->449844216]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetPropertyValue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 6.7906116}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "SetPropertyValue[name, value] sets a widget property value. \
SetPropertyValue[{target, name}, value] or SetPropertyValue[{target, name} -> \
value] sets a widget property value, specifying the target widget. \
SetPropertyValue[{target, name, index}, value] or SetPropertyValue[{target, \
name, index} -> value] sets an indexed widget property value, specifying the \
target widget.", "synonyms" -> {"set property value"}, "title" -> 
    "SetPropertyValue", "type" -> "Symbol", "uri" -> 
    "GUIKit/ref/SetPropertyValue"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5168, 170, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19258968]},
 "GUIRun"->{
  Cell[5927, 201, 211, 6, 70, "Input",
   CellTags->{"GUIRun", "Ex--21907757649578436210,2"},
   CellID->5694],
  Cell[6141, 209, 318, 8, 70, "Output",
   CellTags->{"GUIRun", "Ex--21907757649578436210,2"},
   CellID->5084],
  Cell[20289, 491, 180, 6, 70, "Input",
   CellTags->"GUIRun",
   CellID->14948],
  Cell[20472, 499, 286, 8, 70, "Output",
   CellTags->"GUIRun",
   CellID->31210]},
 "Ex--21907757649578436210,2"->{
  Cell[5927, 201, 211, 6, 70, "Input",
   CellTags->{"GUIRun", "Ex--21907757649578436210,2"},
   CellID->5694],
  Cell[6141, 209, 318, 8, 70, "Output",
   CellTags->{"GUIRun", "Ex--21907757649578436210,2"},
   CellID->5084]},
 "PropertyValue"->{
  Cell[6686, 229, 309, 9, 70, "Input",
   CellTags->{"PropertyValue", "Ex--21907757649578436210,3"},
   CellID->16500],
  Cell[20974, 517, 341, 10, 70, "Input",
   CellTags->"PropertyValue",
   CellID->26419]},
 "Ex--21907757649578436210,3"->{
  Cell[6686, 229, 309, 9, 70, "Input",
   CellTags->{"PropertyValue", "Ex--21907757649578436210,3"},
   CellID->16500]},
 "Ex--21907757649578436210,4"->{
  Cell[7020, 242, 148, 4, 70, "Input",
   CellTags->"Ex--21907757649578436210,4",
   CellID->10955],
  Cell[7171, 248, 12380, 207, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907757649578436210,4",
   CellID->800710817]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24878, 648},
 {"GUIRun", 25010, 652},
 {"Ex--21907757649578436210,2", 25434, 665},
 {"PropertyValue", 25680, 672},
 {"Ex--21907757649578436210,3", 25924, 679},
 {"Ex--21907757649578436210,4", 26078, 683}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1359, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1982, 61, 53, 1, 70, "ObjectName",
 CellID->5234],
Cell[2038, 64, 1943, 60, 70, "Usage",
 CellID->26841]
}, Open  ]],
Cell[CellGroupData[{
Cell[4018, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4496, 146, 68, 1, 70, "Notes",
 CellID->24019],
Cell[4567, 149, 564, 16, 70, "3ColumnTableMod",
 CellID->25352]
}, Closed]],
Cell[CellGroupData[{
Cell[5168, 170, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19258968],
Cell[CellGroupData[{
Cell[5552, 184, 148, 5, 70, "ExampleSection",
 CellID->510945232],
Cell[5703, 191, 129, 3, 70, "Input",
 CellID->343192374],
Cell[5835, 196, 67, 1, 70, "ExampleText",
 CellID->15842],
Cell[CellGroupData[{
Cell[5927, 201, 211, 6, 70, "Input",
 CellTags->{"GUIRun", "Ex--21907757649578436210,2"},
 CellID->5694],
Cell[6141, 209, 318, 8, 70, "Output",
 CellTags->{"GUIRun", "Ex--21907757649578436210,2"},
 CellID->5084]
}, Open  ]],
Cell[6474, 220, 209, 7, 70, "ExampleText",
 CellID->21535],
Cell[6686, 229, 309, 9, 70, "Input",
 CellTags->{"PropertyValue", "Ex--21907757649578436210,3"},
 CellID->16500],
Cell[CellGroupData[{
Cell[7020, 242, 148, 4, 70, "Input",
 CellTags->"Ex--21907757649578436210,4",
 CellID->10955],
Cell[7171, 248, 12380, 207, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907757649578436210,4",
 CellID->800710817]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19600, 461, 217, 7, 70, "ExampleSection",
 CellID->5939],
Cell[CellGroupData[{
Cell[19842, 472, 220, 7, 70, "ExampleSubsection",
 CellID->4010],
Cell[20065, 481, 129, 3, 70, "Input",
 CellID->160911545],
Cell[20197, 486, 67, 1, 70, "ExampleText",
 CellID->14932],
Cell[CellGroupData[{
Cell[20289, 491, 180, 6, 70, "Input",
 CellTags->"GUIRun",
 CellID->14948],
Cell[20472, 499, 286, 8, 70, "Output",
 CellTags->"GUIRun",
 CellID->31210]
}, Open  ]],
Cell[20773, 510, 198, 5, 70, "ExampleText",
 CellID->3495],
Cell[20974, 517, 341, 10, 70, "Input",
 CellTags->"PropertyValue",
 CellID->26419],
Cell[21318, 529, 250, 8, 70, "ExampleText",
 CellID->14648],
Cell[CellGroupData[{
Cell[21593, 541, 151, 4, 70, "Input",
 CellID->4189],
Cell[21747, 547, 67, 2, 70, "Output",
 CellID->10171]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21887, 557, 311, 9, 70, "SeeAlsoSection",
 CellID->17405],
Cell[22201, 568, 212, 6, 70, "SeeAlso",
 CellID->6881]
}, Open  ]],
Cell[CellGroupData[{
Cell[22450, 579, 314, 9, 70, "TutorialsSection",
 CellID->14062],
Cell[22767, 590, 269, 9, 70, "Tutorials",
 CellID->18456],
Cell[23039, 601, 415, 12, 70, "Tutorials",
 CellID->449844216]
}, Open  ]],
Cell[23469, 616, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

