(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13000,        449]
NotebookOptionsPosition[      8521,        305]
NotebookOutlinePosition[     11102,        380]
CellTagsIndexPosition[     10848,        370]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{" GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\" GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WidgetReference" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetReference"], 
          "UnsetWidgetReference" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/ref/UnsetWidgetReference"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"WidgetReference\"\>", 
       2->"\<\"UnsetWidgetReference\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetWidgetReference", "ObjectName",
 CellID->9401],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetWidgetReference", "[", 
       RowBox[{
        StyleBox["name", "TI"], ",", 
        StyleBox["value", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]registers a widget with string ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " in the widget registry for the current interface."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25199]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SetWidgetReference"], "InlineFormula"],
 " is used to define or replace an associated string name with a given widget \
within the widget registry of the current script or when used with a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"SetWidgetReference",
 CellID->24727]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->222340768],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->769929759],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->123147695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", " ", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", " ", "\[IndentingNewLine]", " ", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<Label\>\"", ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Hello World!\>\""}], "}"}], 
        ",", " ", 
        RowBox[{"Name", "->", "\"\<myLabel\>\""}]}], "]"}], 
      "\[IndentingNewLine]", " ", "}"}]}], " ", "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellLabel->"In[2]:=",
 CellID->14702],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject385956632854529, 
   JLink`Objects`vm1`JavaObject524280701911041]]], "Output",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellLabel->"Out[2]=",
 CellID->543332721]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WidgetReference",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetReference"]], "InlineFormula"],
 " allows you to use a name to access the underlying object:"
}], "ExampleText",
 CellID->10606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"obj", " ", "=", " ", 
  RowBox[{"ref", " ", "@", " ", 
   RowBox[{"WidgetReference", "[", "\"\<myLabel\>\"", "]"}]}]}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[3]:=",
 CellID->21216515],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"javax", ".", "swing", ".", "JLabel"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject69188987125761]], "Output",
 CellTags->"JavaAccess",
 CellLabel->"Out[3]=",
 CellID->128289455]
}, Open  ]],

Cell["\<\
You can use this object to create a new reference to the widget:\
\>", "ExampleText",
 CellTags->"WidgetReference",
 CellID->12276],

Cell[BoxData[
 RowBox[{"ref", "@", 
  RowBox[{"SetWidgetReference", "[", 
   RowBox[{"\"\<myLabel1\>\"", ",", "obj"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->70290790],

Cell["Now there are two names, and both reference the same widget:", \
"ExampleText",
 CellTags->"WidgetReference",
 CellID->126092993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WidgetNames\>\"", "/.", 
  RowBox[{"GUIInformation", "[", "ref", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->193688073],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"myLabel\"\>", ",", "\<\"myLabel1\"\>"}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->291655956]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22567],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetReference",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetReference"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnsetWidgetReference",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/UnsetWidgetReference"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->774415220]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32692],

Cell[TextData[{
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->695430475]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetWidgetReference - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 7.9780508}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "SetWidgetReference[name, value] registers a widget with string name in \
the widget registry for the current interface.", 
    "synonyms" -> {"set widget reference"}, "title" -> "SetWidgetReference", 
    "type" -> "Symbol", "uri" -> "GUIKit/ref/SetWidgetReference"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SetWidgetReference"->{
  Cell[3117, 103, 417, 11, 70, "Notes",
   CellTags->"SetWidgetReference",
   CellID->24727]},
 "PrimaryExamplesSection"->{
  Cell[3571, 119, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->222340768]},
 "GUIRun"->{
  Cell[4261, 147, 661, 16, 70, "Input",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->14702],
  Cell[4925, 165, 333, 8, 70, "Output",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->543332721]},
 "Ex--21907299533234115765,102"->{
  Cell[4261, 147, 661, 16, 70, "Input",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->14702],
  Cell[4925, 165, 333, 8, 70, "Output",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->543332721]},
 "JavaAccess"->{
  Cell[5550, 187, 220, 6, 70, "Input",
   CellTags->"JavaAccess",
   CellID->21216515],
  Cell[5773, 195, 307, 9, 70, "Output",
   CellTags->"JavaAccess",
   CellID->128289455]},
 "WidgetReference"->{
  Cell[6095, 207, 141, 4, 70, "ExampleText",
   CellTags->"WidgetReference",
   CellID->12276],
  Cell[6421, 220, 135, 3, 70, "ExampleText",
   CellTags->"WidgetReference",
   CellID->126092993]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SetWidgetReference", 9644, 331},
 {"PrimaryExamplesSection", 9768, 335},
 {"GUIRun", 9901, 339},
 {"Ex--21907299533234115765,102", 10173, 346},
 {"JavaAccess", 10427, 353},
 {"WidgetReference", 10628, 360}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1338, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1961, 61, 55, 1, 70, "ObjectName",
 CellID->9401],
Cell[2019, 64, 583, 17, 70, "Usage",
 CellID->25199]
}, Open  ]],
Cell[CellGroupData[{
Cell[2639, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3117, 103, 417, 11, 70, "Notes",
 CellTags->"SetWidgetReference",
 CellID->24727]
}, Closed]],
Cell[CellGroupData[{
Cell[3571, 119, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->222340768],
Cell[CellGroupData[{
Cell[3956, 133, 148, 5, 70, "ExampleSection",
 CellID->769929759],
Cell[4107, 140, 129, 3, 70, "Input",
 CellID->123147695],
Cell[CellGroupData[{
Cell[4261, 147, 661, 16, 70, "Input",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellID->14702],
Cell[4925, 165, 333, 8, 70, "Output",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellID->543332721]
}, Open  ]],
Cell[5273, 176, 252, 7, 70, "ExampleText",
 CellID->10606],
Cell[CellGroupData[{
Cell[5550, 187, 220, 6, 70, "Input",
 CellTags->"JavaAccess",
 CellID->21216515],
Cell[5773, 195, 307, 9, 70, "Output",
 CellTags->"JavaAccess",
 CellID->128289455]
}, Open  ]],
Cell[6095, 207, 141, 4, 70, "ExampleText",
 CellTags->"WidgetReference",
 CellID->12276],
Cell[6239, 213, 179, 5, 70, "Input",
 CellID->70290790],
Cell[6421, 220, 135, 3, 70, "ExampleText",
 CellTags->"WidgetReference",
 CellID->126092993],
Cell[CellGroupData[{
Cell[6581, 227, 154, 4, 70, "Input",
 CellID->193688073],
Cell[6738, 233, 145, 4, 70, "Output",
 CellID->291655956]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6944, 244, 311, 9, 70, "SeeAlsoSection",
 CellID->22567],
Cell[7258, 255, 507, 17, 70, "SeeAlso",
 CellID->774415220]
}, Open  ]],
Cell[CellGroupData[{
Cell[7802, 277, 314, 9, 70, "TutorialsSection",
 CellID->32692],
Cell[8119, 288, 360, 12, 70, "Tutorials",
 CellID->695430475]
}, Open  ]],
Cell[8494, 303, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

