(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12690,        440]
NotebookOptionsPosition[      8219,        296]
NotebookOutlinePosition[     10795,        371]
CellTagsIndexPosition[     10540,        361]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{" GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\" GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WidgetReference" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetReference"], 
          "SetWidgetReference" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/ref/SetWidgetReference"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"WidgetReference\"\>", 
       2->"\<\"SetWidgetReference\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["UnsetWidgetReference", "ObjectName",
 CellID->28343],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"UnsetWidgetReference", "[", 
       StyleBox["name", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]removes a widget from the registry with a name in the \
current interface."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22602]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["UnsetWidgetReference"], "InlineFormula"],
 " is used to remove an associated string name with a given widget within the \
component registry of the current script or when used with a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"UnsetWidgetReference",
 CellID->15369]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->137928699],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->117684814],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->756718274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", " ", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", " ", "\[IndentingNewLine]", " ", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<Label\>\"", ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Hello World!\>\""}], "}"}], 
        ",", " ", 
        RowBox[{"Name", "->", "\"\<myLabel\>\""}]}], "]"}], 
      "\[IndentingNewLine]", " ", "}"}]}], " ", "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellLabel->"In[2]:=",
 CellID->14702],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`vm1`JavaObject251853325467649, 
   JLink`Objects`vm1`JavaObject517999698116609]]], "Output",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellLabel->"Out[2]=",
 CellID->633130517]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WidgetReference",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/WidgetReference"]], "InlineFormula"],
 " allows you to use a name to access the underlying object:"
}], "ExampleText",
 CellID->10606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"obj", " ", "=", " ", 
  RowBox[{"ref", " ", "@", " ", 
   RowBox[{"WidgetReference", "[", "\"\<myLabel\>\"", "]"}]}]}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[3]:=",
 CellID->21216515],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"javax", ".", "swing", ".", "JLabel"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`vm1`JavaObject115572452884481]], "Output",
 CellTags->"JavaAccess",
 CellLabel->"Out[3]=",
 CellID->143524648]
}, Open  ]],

Cell["This removes the name for the widget:", "ExampleText",
 CellTags->"WidgetReference",
 CellID->12276],

Cell[BoxData[
 RowBox[{"ref", "@", 
  RowBox[{"UnsetWidgetReference", "[", "\"\<myLabel\>\"", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->70290790],

Cell["Now there are no named widgets:", "ExampleText",
 CellTags->"WidgetReference",
 CellID->126092993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WidgetNames\>\"", "/.", 
  RowBox[{"GUIInformation", "[", "ref", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->193688073],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->287956967]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->35],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetReference",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetReference"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetWidgetReference",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/SetWidgetReference"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->774415220]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3282],

Cell[TextData[{
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->695430475]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UnsetWidgetReference - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 10.8997762}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "UnsetWidgetReference[name] removes a widget from the registry with a \
name in the current interface.", "synonyms" -> {"unset widget reference"}, 
    "title" -> "UnsetWidgetReference", "type" -> "Symbol", "uri" -> 
    "GUIKit/ref/UnsetWidgetReference"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "UnsetWidgetReference"->{
  Cell[2974, 99, 413, 11, 70, "Notes",
   CellTags->"UnsetWidgetReference",
   CellID->15369]},
 "PrimaryExamplesSection"->{
  Cell[3424, 115, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->137928699]},
 "GUIRun"->{
  Cell[4114, 143, 661, 16, 70, "Input",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->14702],
  Cell[4778, 161, 333, 8, 70, "Output",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->633130517]},
 "Ex--21907299533234115765,102"->{
  Cell[4114, 143, 661, 16, 70, "Input",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->14702],
  Cell[4778, 161, 333, 8, 70, "Output",
   CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
   CellID->633130517]},
 "JavaAccess"->{
  Cell[5403, 183, 220, 6, 70, "Input",
   CellTags->"JavaAccess",
   CellID->21216515],
  Cell[5626, 191, 308, 9, 70, "Output",
   CellTags->"JavaAccess",
   CellID->143524648]},
 "WidgetReference"->{
  Cell[5949, 203, 106, 2, 70, "ExampleText",
   CellTags->"WidgetReference",
   CellID->12276],
  Cell[6215, 213, 104, 2, 70, "ExampleText",
   CellTags->"WidgetReference",
   CellID->126092993]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"UnsetWidgetReference", 9335, 322},
 {"PrimaryExamplesSection", 9460, 326},
 {"GUIRun", 9593, 330},
 {"Ex--21907299533234115765,102", 9865, 337},
 {"JavaAccess", 10119, 344},
 {"WidgetReference", 10320, 351}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1332, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1955, 61, 58, 1, 70, "ObjectName",
 CellID->28343],
Cell[2016, 64, 443, 13, 70, "Usage",
 CellID->22602]
}, Open  ]],
Cell[CellGroupData[{
Cell[2496, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2974, 99, 413, 11, 70, "Notes",
 CellTags->"UnsetWidgetReference",
 CellID->15369]
}, Closed]],
Cell[CellGroupData[{
Cell[3424, 115, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->137928699],
Cell[CellGroupData[{
Cell[3809, 129, 148, 5, 70, "ExampleSection",
 CellID->117684814],
Cell[3960, 136, 129, 3, 70, "Input",
 CellID->756718274],
Cell[CellGroupData[{
Cell[4114, 143, 661, 16, 70, "Input",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellID->14702],
Cell[4778, 161, 333, 8, 70, "Output",
 CellTags->{"GUIRun", "Ex--21907299533234115765,102"},
 CellID->633130517]
}, Open  ]],
Cell[5126, 172, 252, 7, 70, "ExampleText",
 CellID->10606],
Cell[CellGroupData[{
Cell[5403, 183, 220, 6, 70, "Input",
 CellTags->"JavaAccess",
 CellID->21216515],
Cell[5626, 191, 308, 9, 70, "Output",
 CellTags->"JavaAccess",
 CellID->143524648]
}, Open  ]],
Cell[5949, 203, 106, 2, 70, "ExampleText",
 CellTags->"WidgetReference",
 CellID->12276],
Cell[6058, 207, 154, 4, 70, "Input",
 CellID->70290790],
Cell[6215, 213, 104, 2, 70, "ExampleText",
 CellTags->"WidgetReference",
 CellID->126092993],
Cell[CellGroupData[{
Cell[6344, 219, 154, 4, 70, "Input",
 CellID->193688073],
Cell[6501, 225, 88, 3, 70, "Output",
 CellID->287956967]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6650, 235, 308, 9, 70, "SeeAlsoSection",
 CellID->35],
Cell[6961, 246, 503, 17, 70, "SeeAlso",
 CellID->774415220]
}, Open  ]],
Cell[CellGroupData[{
Cell[7501, 268, 313, 9, 70, "TutorialsSection",
 CellID->3282],
Cell[7817, 279, 360, 12, 70, "Tutorials",
 CellID->695430475]
}, Open  ]],
Cell[8192, 294, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

