(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64259,       1545]
NotebookOptionsPosition[     53546,       1215]
NotebookOutlinePosition[     59502,       1379]
CellTagsIndexPosition[     58874,       1362]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Widget Basics in GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/WidgetBasics"], 
          "GUI Building Blocks in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/DefinitionBuildingBlocks"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Widget Basics in GUIKit User Guide\"\>", 
       3->"\<\"GUI Building Blocks in GUIKit User Guide\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUILoad" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUILoad"], "GUIRun" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIRun"], "GUIRunModal" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/GUIRunModal"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"GUILoad\"\>", 2->"\<\"GUIRun\"\>", 
       3->"\<\"GUIRunModal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widgets" :> 
          Documentation`HelpLookup["paclet:GUIKit/guide/Widgets"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widgets\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Widget", "ObjectName",
 CellID->5994],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", 
       RowBox[{
        RowBox[{
         StyleBox["class", "TI"], ":", 
         RowBox[{
          StyleBox["class", "TI"], "|", 
          StyleBox["path", "TI"], "|", 
          RowBox[{"URL", "[", 
           StyleBox["path", "TI"], "]"}]}]}], ",", 
        RowBox[{"{", 
         StyleBox["content", "TI"], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]defines a new widget instance."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->579]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->24023],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["InitialArguments",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/InitialArguments"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
a list of arguments to use in the constructor for this widget instance\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Name",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/Name"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
a name with which to register this instance in the widget registry\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExposeWidgetReferences",
     BaseStyle->"Link",
     ButtonData->"paclet:GUIKit/ref/ExposeWidgetReferences"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "a list of widget names to expose from an internal definition", 
     "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->25709]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->412783720],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->27429861],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->764121120],

Cell["Create a widget instance:", "ExampleText",
 CellTags->"Widget",
 CellID->9009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"Widget", "[", "\"\<Panel\>\"", "]"}], "]"}]}]], "Input",
 CellTags->{"Widget", "Ex--21907280849161310363,9"},
 CellLabel->"In[2]:=",
 CellID->27743],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject375439734341633, 
   JLink`Objects`JavaObject38119294369793]]], "Output",
 CellTags->{"Widget", "Ex--21907280849161310363,9"},
 CellLabel->"Out[2]=",
 CellID->30867]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907280849161310363,11",
 CellLabel->"In[3]:=",
 CellID->1265],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WglUVMe2vXQziEajIoiRqKgoIhhBnFBURAaZZBSRQUCZFBzAOEVjBn1+
k/ij0Ty/eZlcyfL/JGpe8pIYjcmPmV7ei1kak6hxeEzddDfgwNA0aHT/c6pu
N4OQ518ruWvVvXXr1j23au9T55yqurE5awvzSnLWFi3NGRFRmrO6sGhp2Yjw
VaVUpLVTFOUxSr4jFM6DstaTFsqgA1BcnuOkbBBnRbGH4nYUyrDX1XTQiTNa
zjlwzhHKw+KWTzJ3sFNOPjioUSsPO8hvdHjgaBOlVZ+quQc6v8u3B7k5ohlv
8B2UoX+xU9tJEoacQS//X9A34hL6J5ej9/xfqE/2IRdJxqyrvaAEX+Ecn4Kv
Oqq3wVetZbNkmYZzWmtlmXO85w1Zr6uoe4UGX9V0fk2I4l4EX4Ey9SwU35Pc
m3t7MTBRD7fl19Er5Sr1wmlB7SookQ2KVr7p9xlDrNi1k6S+pr5ShnrTRa4c
2SBfGNa1spP/xZ4rH7yncveSZ3Uv+Tea0VVyT22e9TtU/o0O3gtdz5Xvwfk3
oeta2Tnw0n1KfugMlBkVMkVXkN6EnqHKdqFnYDfvLCfFGZqws1rOarhc0con
XIPu3PhuEL/myvfDVAFC3gT6WsAp/prrC/Q1p65fo/ac5vriMxr5GSWKRo5d
7BWWEU81YqvpWkVP+UxlSZWcs97FV/lwFfp+eAXfs8zoanHnaC0LpVbMEUnq
MZ9nXZJl8m5Op7JZl/hrQb8oNHinXeQclMkXZZ6v3PZptdwzhvFZOX6sHYuu
k01OrmYhi2oY4kVUllEPJfs6lCWNWmjzGuyhLWymj2oLb8FuuUhUk8/UkLw7
sFvWxkmhjmW38elXkWMIM9r4Vl7TWqEsNtMXmqCktogvWviLqS1QUpqhJDTz
VcMZe85xSxNuQom5Ia+yDr8X00R4Rdyw467ZdeybU+e+LaI+pDdar/SmNpvN
gzanhXvE/aE7x+VtdCr+1QnaFbeJ1+V3XfmJhrtGjx3ybyP/L2bQoTwozlro
r90RZfRM6bmek6x3oAkOORYGRMDgkGVB/p+blP6iTi/o639F/t4GOCxo5I5x
v0gXaruyZu1ZVaee2WWbuTesjnltKkPUH+4OlTmtukNmsfSOPRzX3KWHpaDT
SgzmPiquKHi1BWcvNcB74ZfoO/sjDJj3KQaGfYJBYccxcN5xuISdhEv4p+gf
9hn6hn2O3mGn0Gvel3AM+Rza2Z/DbvaX1KDPMDzuOM5cvMbyFIGf4v+7y2Zk
WdVYmfIPmHH9/Fl8OM8bh8b3xeGJA/CO/0C8FTAIb00ciMMBLjhC6ah/f7w3
sS/en9AbH/j1wns+jnjPW4sPxtrh6GgFh2cOR+1PZwT6Qvms6EvkFSv09l2h
1zDuVCz16JZEvfhXAbiGAXeE09q7Ghvqgxl1jYq6/vodeGeVw2VBOYamlMNz
cRW8MioxJrMCo+k6KqsKnpSGURq6hBxclh4umTXol66H86Ia2CfXwC6O2hL2
I6HzsdAiK+p/gGwb6qzL38/3xulpLjg9ayjOzPPEmQgvSmNwJnw0zkaMwg/h
njgXNgw/hw3Fz3PdcH6OC34O7ofz053x82R7/DDRDl/4KHiHkBeyfwP1exVe
VXah6v2QkpIiwLVncN1UcPnoF38NHuk34L30Jh4pvIlJKxoQWNwA/+JG+Jc0
YsKqRvisboTX6iYMX9WEISXNcFnejL75zXDKboJmMdmaWPps0PEO4P5Rsgla
VfbFqf1wOdQDV2O88a/ER1CeMgkVqYGoSPFHxUJ/VC6cgKoUH+iSvKCLHw59
zBDoI12gD+0L3SwnVEzT4IdHFLw9SrHKjmliC90ZXOHcyFkMP9fZmiyR1oTA
xWsHKQrV6XT0ctWlyzAYjZxI4evq6uhMjxlz2BXf5TSkAz6DFjbBK7cZ/iua
MX1NM4LXmim1YMajZkxfZ8bU9WYEbGiB7wYLvNZbMHydBUNKLRiwshV9Ci1w
yG6GJomUMPgzax/IuPr/EbJtfomPqzMHoSLaC5XJ/qhOnw5dVjB0SyhlzYA+
azqlqajJDIAh3RfGVC+YkofDFD8EpqgBMM7rA12wA85P0uDdMXZSdldD7v+N
DXtnKKPOqz7KIP3tEpslF+AWFRVRz4kAjcC9Ny5fvoyvn31OXIkDwQjn+cr3
/BKRoGGfLCAbLPyxg2iLe1oTJpC3CyLM5q4308DiBjrDZ3MrRm9qxcPrW+Fa
1op+xa1wXtoMh4UGaGb/bwf97F5OH1HDo7v3bP6ej3/NcUdlwgRUZwRBlzsX
5lMfivKavFBKIahZFgxD7jQYswNgyvBBbdpo8dzy8UGYIvtBP8cZF6Y44K9j
NVysYWBZrUOMElrfb23Q2rdDy8An1GkYW44BCV0GiZVaIEutZwAph38UFsCU
noATJ05IoOl6at8eAW5TUxO/J/2rhkF1F5GNRGRYZhOmrCQ0SPvmP9aOrN8W
0kBCdhghO5iQHVBiERagT5pBODgrsm2EXjdyRFnU4xZEPt6CsK0tCHmCtJyu
k7daOsnmoxvZMsKiaImPcjLHVYumCOT1BfO14rkDagrDYCgIgWHZDBhzJ6M2
y0+Rz3oLpa6Z1xcXZvTBe+MdpUirMjPqbDZEZCJAd1BtCYOuo+/WcvyoSOQf
EKiXlZUJNBntD6Njcfbv3+BCWiqqihJQviYT3y1fjFOjRuGDv/1NkmOPfXv3
Svcq02BmUMPhowq9V24TgsuaEUlwxT3R0g79ZgvGbGzFCDIAQ8oscFtlgUtR
M/pnGtF7nk2pSY5rd3JEWdyTLYimfARBPpfSTEpTGPoOsvnoQXZKgyIxY4NS
TYZEXxCJmuI41JTES4i1MBTOhSFvJkE/RYXdUdgTY4wbdBEuuDibQhe/3qq+
hxjFHKVKzlF8jnU0JQw9z5ME9Pr28J1MCkP/xRdfqArfF9+kZ+CEzxg0Z4Sj
PiEUhkPFOJYdjP1jHhZ479n9PE5sXS+ujDsHOQIrdxE9S8DGk67N20BgESiJ
T7Ug6ekWJNA19knSVyoLpRRMejt5cwv8NhFgBJbnWguGrrHAfSUl8oZuSwx4
MMI2DhY1KcO6lc3H/cgW1ule2UyFmDnwUblgPHRL56FmRRwMqxIpJaFmZYIE
vz+REQzrcdfcAGOyJ4zxQ2GIdYcuyh0XKJp53/9BKZbHwJzK9lmjzzErIYOh
jPhWTr6YkAR9p/kUE3L6u9O4evIT/HTyJL5ZEIHqpcEwv7kCNftyUJ87FZen
+eIf/mNxInIybiZH4dL583j19dfEzEXDPAxhd62SEUCuMHqLGclEwsJtFqQ8
bRHAxZL2Rm4h7SWgZm5qQSC5Rb91LRhDI8KTiPBY1QKPEkoEmEdODQZG2rS3
R9l83I9sPnqQnVBHgQcfVckB0BdFw7A6GYY1C2FcnSJIqSmOFcOblNWQMgaG
RE/UxHmgJtYD1TEeOB/ugb9OGihJ4OHABPAkl42+HBYidHS7lwW2SioTzMKm
9DRUTqeAOXQK6jLi0HggD23/3IbGw49CtyUZ3yfMhP7VtajflIiXn9mJ0199
hZdfeZkmkJn1PBaZUBa3qI7QojMP+1oVuKlkyRPIhKRutyDtTxZxTaT7WNLc
iMfImm8ka06xSiDFL76lBByRMZIAG7aiBcOXt8BzeRM8c2vgNt8WA5HsEd3K
FqTch2w+upHNlAh8+KhOmwpDSQKMpakwlqURMak0QoiU5bFkwiLkSCF3nOoL
fdIY6ONHQh87jNJwVMV54vx8T7w72U2KZYtkXYkYdxbKmMNWbkh9HzoJZco5
uXzBiyM08VDSaEhlmAQ31sDm2tqlqH8mA+Y96YKXc7tLcCw/CX8viIbl+DoY
n1qAgzt34M0338TGTRuZGisxTFGa0a0DKTNLm5G2owWZz1iQuVOCl0TAxTFw
m8wIIbMTRKAFlhJwq8wYW2zGKAJsRBEBWGiGVxEF9QTckOiOpHQvm4/7kc1H
D7Jjq9WRUp1JTmJtGozrM2FclwlDaRpqyHTpV8RZR4ouYSx0C0bRCBmB6tiR
ZOm88HOUF96dOkSSYV0KYsyZDDlS+m0hNtw7sxF1RR0tesGI1XeLkPP4R7iw
LZGis+mCgW+LU/D1tvU4lj6bGhaJq4uDoJ/sg4r/eolHisqGScOCxNoSs6FX
EQvfaEb2cxbk7mpF9rMWpO+wIPkpC+LIpkSQPQkhtILWEGKk7n4rzPAuMmN0
gRkj8wktuo4rbMS4pToMjf7UxoZedSJdZfNxP7L56Ea2XKGLrhB5fV44jJuy
YdycK69r02FYmWx1IhzhdjyqYkejKnokXb1QET8OP8WMw9HpQzuzwoywtRJD
RJDS615Skqs7kqIRE7EHcHnCWHw8xRenA/zwbcw0YbHYbzzr4Sb4uJgajo9e
OYCainL8z/69WhsXg7twUfhCK5bvbUXe863IIg1OJT8ST9obReYklKZXwYQX
B6iPEF7jCS9vwmksceFD2utL2uuTq4NHTEcuHLqTrU4Z+nb3nlyI7ICz6clC
1D69HKbH80j7sxRr6KTLCYUuMxjVi6yhUx+yP2NRFU/Kl+CLH2N9cGS6RzvI
VrWXINtU302iPPU7ciPnJMq8WssoLzYI1U9JSYHxrTeE+n9VViqcAhsedhRW
lT802RdXP/hQGC3VVXPIZBAwu3eAmS30yv2tWH1AwpH7XCvSyQglP2FBLFnu
iPUtmEMGIogMRGBJMyaS+/Wj4NKX4PajNIHg8l2qx8MxJ23u1ApzF9kqzA90
914nmNmy1+1YibpnVjPU1rmBvjAWumURNAGeQ5PhIFQtDFSsz6oS/VCeOIFQ
9sWRoIetTZlyjk2u77cS5dGHlA667P4OT3+hzGaUL8p1ctZnibJVl3mm9cPR
o7iWugBN25aiaUMU6qICcP6xDbhSmIMjgdNw+/ZttJnNPYPM8cnG11qx+WAr
1hAYBXukDUjbLq09Ax1O7jGkjIFuxjTS6cDiZgQUy2WFiUUN8CWd7ACyTZe7
yLZNf7t5rxPIHNfU79mI+r2bCeg1sJz+QpaTJTeUJKlohxPaIQLt6rRp4nnT
J0dQleKP8qSJ+DHOhvY9YHdQaed/Bzb7SeoUYU3N/25+OJpNco7b/PVn0PmO
FXlGuJ5marz0w4jL+W93cC/6Uwt2vt2GXUfasPUNCTnr9rL/tCDrGelkkwm2
BAoZozebEUWJ4/vZZFKCShl6MgE51XCP/KQD3L5/hOxOlBjXLsL1V3bixsFd
uPbiVkGLMDVblsG4IQsGjn5WJdOELYHoiaYUJeYOuuzZwsZXLAzEuRgfHJ7i
fp+UBJySu0cRF8jKXCIwyynpBCW8wiMpcRCWxkoBJ1NMJJUSCSSd6zKNlPhb
i2pcGS2N2LyRdOTttmD/B2146dgtAd2m11tR+lIrSl5sFVY473nyigRfzi6L
iFU4Zkmk6D6GzEcojYqpKxvhvaQaruG2xcmkSpWO31m2VEyVDtPWPNx8az8a
Dr8kaKnfswl1z5aidnuJ8AJG8gAm8rimx3JkHLSWY6BE6JfHEC2hqKTA9VyU
N96e5KrSMfW7HsyRfSc6NGFnuY+XuDIxwghTMEl3xIGWCaCs6asvxSiQJPRA
xeAOLKx7uRW7323DvvfbsP2/W/Eo3bNxLnzBgvzdEqUlFJ9ksV36D5pbbW9B
PCny/M1SeQNWNGJURjUmZnwNff1tlYU/THZ8hfKQkF2/ax1uvLEbNw/tw/WX
tqNu16OoJedQSwyYtuYLBowbl1DKgvFRGiClC2l6EE+DY74YGBUpATgbPgof
RU+EvvaW9KxsipiGkceZhg4sjD4kWQj5J+xiOrHA40LJMnDbck2OsMurEzne
cMyhSVyWiZ9y0tps0qD2keCM/H21uKK/gzLSTo4DU7bJ6VEkReK8wEZGgmTP
KjNrMGMNnSYVNyuOmEizVe9lzRieeQOBBRU4d7kR+XtNEnxnzv6/hQ7oSai6
JVyB/D0G3Kq8QspeRsqdTTOuFDnbyo+kMGcu2xxevFkyS0NmZ4aGHPEkamoV
OYSKWG9cCRuOs0mBuHHxHPJ3lGvEIrNWwirxtqq9Rqz921vRliYo6RIb9XJ+
g/HMNVlRzqujmgXXNJzjxT160o68iYN66Q7cxI6xFg6L9cj/cx30126rm5pO
4p7LxdyOUrd19lGdhdXSPxEiDokSEVZMW50d5XCYcbpdmbhzPsesJtb1ddIm
tcscwEV/Lzbd1Z7Zd+wZ90bL/aLSokbRQ9lZudMtkytPIMdxFx3bB7eMCeUW
eVKlGDIa3vPn3f8r9uxmeUn6Av+M8CPjxa6Xbb01kTHSWNdLZXtF54gLbq99
l6aKFhVc00JT3OAM7Uq2QZRV96t595vOc3lXnnJL6+mD2pw6QZAm0yQSN1wM
Cy23XMtNb2+5In5XkGhFXVREyxV7GSuE/ihxdn9HbGKIgWprKqssA2uFkT4s
mrXSDO2qW7zfCaXsDjevlIlT78XVmqcnnOePlvGOOZc7rrnLG6aKNz8dxNtJ
vK9aKjeX1JfsRX1n8esBb08JKPIaxKI+r3OKnwr4Krb4edWyl7xvJ7bjLw08
c9eoizYZYjWHFZA7H3xFUXuuUcNdHi2MqWNBs+iubL7LJnIyDz1FJ8+dPCUZ
uwsYv1skekpnLfz3IVTm6KEo03BOi1HbrW/Qu+r78kxPbGVCsgN/Qyu/5rTq
jtDGJjFb4capLdVKl0cN5V8ZqJmEJr+iiBYSmCyWP+f/HLhVGgTtoVPwi3DG
7P1w5dwgW86Bc9RvynK9jlcigHKOLEcjemHPn+F9b6ny/t/IOYIMl8XvLd8L
/LhpQs/E7zIUeArfz3MtaeltV5uVYdeaIayNWGsziSW2Qbw2OYinsPbWJR7e
tlRX4bQqoQkiy2sYvLIVbbDNk8Remyirk/loMaDDdfzrjZjiG9RUJzc6Zp9z
UEeB3f8B3dkBfw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907280849161310363,11",
 CellLabel->"Out[3]=",
 CellID->227635365]
}, Open  ]],

Cell["Explicitly specify what Java class to use:", "ExampleText",
 CellID->12891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"Widget", "[", "\"\<class:javax.swing.JPanel\>\"", "]"}], 
   "]"}]}]], "Input",
 CellTags->{"Widget", "Ex--21907280849161310363,12"},
 CellLabel->"In[4]:=",
 CellID->30369],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject217856562167809, 
   JLink`Objects`JavaObject123257625772033]]], "Output",
 CellTags->{"Widget", "Ex--21907280849161310363,12"},
 CellLabel->"Out[4]=",
 CellID->1538]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907280849161310363,13",
 CellLabel->"In[5]:=",
 CellID->7604],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907280849161310363,13",
 CellLabel->"Out[5]=",
 CellID->18311756]
}, Open  ]],

Cell["Specify constructor arguments:", "ExampleText",
 CellID->32212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"ref", "=", 
   RowBox[{"GUIRun", "[", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Label\>\"", ",", " ", 
      RowBox[{"{", " ", 
       RowBox[{"\"\<text\>\"", "->", "\"\<Hello World!\>\""}], "}"}]}], "]"}],
     "]"}]}]}]], "Input",
 CellTags->{"Widget", "Ex--21907280849161310363,14"},
 CellLabel->"In[6]:=",
 CellID->10991],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject347494311526401, 
   JLink`Objects`JavaObject383831949443073]]], "Output",
 CellTags->{"Widget", "Ex--21907280849161310363,14"},
 CellLabel->"Out[6]=",
 CellID->12693]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907280849161310363,15",
 CellLabel->"In[7]:=",
 CellID->23409],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907280849161310363,15",
 CellLabel->"Out[7]=",
 CellID->206619377]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16100],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "InitialArguments",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32759],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->160911545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Label\>\"", ",", 
     RowBox[{"InitialArguments", " ", "\[Rule]", " ", 
      RowBox[{"{", " ", "\"\<Hello World!\>\"", "}"}]}]}], "]"}], 
   "]"}]}]], "Input",
 CellTags->{"Widget", "Ex--21907280849161310363,17"},
 CellLabel->"In[2]:=",
 CellID->18440],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject440989927866369, 
   JLink`Objects`JavaObject560397887209473]]], "Output",
 CellTags->{"Widget", "Ex--21907280849161310363,17"},
 CellLabel->"Out[2]=",
 CellID->10089]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907280849161310363,18",
 CellLabel->"In[3]:=",
 CellID->29494],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWgl0VEW6vunOQlBQCYQgEYgQiDEgCWELBAghC9nICoQsJIGshC1BNlFc
YHguPEFwfDpuHD2+pwKOjooo+tzHGfGAqIBAJiHpTncnQczS6QSE7/1/1b2d
7tAozgznvHtO3Vu3btV/6/++v/76q+5NLlxTVry8cE35ksIRcVWFq8rKl1SP
iF1ZRUV6N0VR7qEUOkLhPCirnfRQBj4NxecxTsp6cVYUdyi++6EMe1FNe7w4
o+ecB+c8odwmbvkkc3uccvLBHp1aedgebuHwwNMuSq8+VXM3Orfl2z3cHdGN
l/gOytA/uan9JAlDjqBP6I/oF3cKN2fWou/cH0kn96iTJGNGTR8okWc4x6fI
Gk/1NrJGK5shy3Sc02uVZc7zihayXm9RVwqNrNE5NxOiWIvIM1AmH4UScoi1
uVKLAelG+Fb8hD5ZNaSF17ymlVDiWxW9bDn2I4ZYceshSW2mNqlGi+UkV45v
lQ2GXZfKM2qcuiF779VTWViWu9aCjIxyPXe6Xg8UrUwUebpsxmd3xzJ7fSnN
o/ezHqm6nt44vnK6k0LO2l+bQlwme+blWNb7qtZxpdFva+miuSuRzsrOcCLW
FVd9rkE1j17A/pZKrmjV/w4Zv6fMiTxhunv+CQ0F1NLgXPXw/5WSM5yVvGJ8
evaI0YSonf39xinbefY2RO16dQzcnV7xa0Nd56K7035F32sj9RpdjMfv06+X
VNdE/z5X01sxr7DfVszDhU7evRh2oY1Lhvtcg0tyPc6ucJL/Us9/fXBdreyf
632Nywnu5FVnQxfzrOvKzOhtvYem169IvqIb3uGnrrEbtx6BMq1OpsQ6srfo
I1TZLfoI3OYc5UTA6mKO6jmr43JFL59wDbrz5buB3GwQ3w9TBQh54+htYZ/w
2wY9QW/z6v026s9hri9eo5OvURJoSLkln2EZqVQjuYGu9fSUz1SWcZZz2l1q
fTBXoffH1vE9y0xsEHeeWlk09WKWSDLo4fOMU7JM3s1yKptxit8W8SNZhTLl
JOegTDwp83zlvk9pYs0Yxkel4WqKJTbLLmc2sJCFjQzxQirLbYFS8BOUxW16
6Itb3aEv66CX6ssuwK1CJKrJZ+pI8SW4Le3mpJBiBd18+kXkGMLcbr6V1+wu
KIus9IZ2KAs6xRtt/MYFnVCyOqCkdfBVxxl3znFP036GknReXmUdbpfUTnjF
nXdj1dwcdfNy1m0h6ZDTpl2ppb6AY0l9YSdrxPrQnWdFN50qf/GCftlF4rXi
8iB+omPV6LFHyUWU/MkKOpSbxFkP47lLooyeKVev5yXrPd0Oj0IbAyJg8Mi3
oeSP7crNok4fGFt+QcmuVnjMa2PFWC+yhaberGma1Ttp5lZgZW3YHIu7VYZI
H1aHyrxWXqIYuuqSOzxXX6aHVaDTCgxmHZVBKH2+E0dPtSJo/mfoN/Nd3DLn
QwyI+QADYw5iwJyD8Ik5BJ/YD3FzzEfoF/Mx+sZ8gj5zPoNn1MfQz/wYbjM/
ow59hOEpB3Hk5DmWpwj8lNB/u2xGlk2NjankaSt+On4U78wJwit39sPe8bfg
9dABeDVsIF4dPwB7w3ywj9L+0Jvx5vh+eGtcX7w9tg/eDPbEm0F6vD3GDftH
Kdg7fTiavj8i0BfGp6EvkVc06N17Q69j3KlY2tEFiXrlLwJwHQPuCa81l3V2
1Acz6joVdeNPlxCUXwufebUYmlWLgEX1CMw9i9F5dRhF15H59QigNIzS0MW0
Gso3wievEf1zjPBe2Aj3zEa4pVBfYr4jdN4TVqShfh1k21FnW/5mbhAOT/HB
4RlDcWROAI7EBVIajSOxo3A0biS+jQ3AsZhh+CFmKH6Y7Yvjs3zwQ2R/HJ/q
jR8muuPb8W74NFjB64S8kP0rqF9p8KqxC1Pvj6ysLAGuO4Prq4LLR//Uc/DP
OY+gJT/jrrKfMWFZK8IrWxFa2YbQ5W0Yt7INwavaELiqHcNXtmPI8g74VHSg
X0kHvAraoVtEviaZXhtx0AHc6yWboFVln5zcH6ej/VGTFIR/pN+F2qwJqFsQ
jrqsUNTND8XZ+eNQnxUMQ0YgDKnDYUwaAmO8D4zR/WCY4YW6KTp8e5eC10Yq
muykdvbQzuCKyY0mi+HHnL3JYulNCFy8sOdFTxgMBmpcf+o0TGYzJzL45uZm
OtNjxhxulZc5DXHAZ+D8dgQWdSB0WQemru5A5BorpU5Mu9uKqWutmLzOirD1
nQhZb0PgOhuGr7VhSJUNt6zowg1lNngUdECXQUYY+ZGmAznX0Osh2z4v8VEz
fSDqEgNxNjMUDTlTYciPhGExpfxpMOZPpTQZjXlhMOWEwLwgEJbM4bCkDoEl
4RaY59wAQ6QHjk/Q4Y3RblJ2b0ce+qUde28oI4+rc5RJzreL7Z5cgFteXk6a
EwE6gXtfnD59Gl88+pi4EgeCEc7zle+5EZGg4zlZQDZYzMceoi9+2e0YR7Nd
BGE2e52VBhZ30BvBm7owamMXblvXhUHVXehf2QXvJR3wmG+Cbub/Otinazk3
iBr+rtrZ53s+/jHLD2fTxqEhNwKGotmwfvKOKG8sjqYUhcalkTAVTYG5IAyW
3GA0ZY8Sz23v7YElvj+Ms7xxYpIH/jxGx8U6BpbNOsosoQ35yg6tew+0DHxa
s46x5RiQ0GWQ2KgFstR7BpBy+FtZKSw5aXj//fcl0HT9ZPdOAW57ezu3k/Or
jkH1E5GNRGRYXjsmrSA0yPrm3tOD7Nh7yQIJ2WGE7GBC9pblNuEBbsg2iQlO
Q7ab0HMhR5Ql3GdD/H2diNnciaj7ycrpOnGzzUk2Hy5kywiLoiU+askd1y+c
JJA3ls7Vi+ceaCyLgak0Cqal02Aumoim/LGKfNZXGHXjnH44Me0GvHmnpxSp
GTOjzm5DRCYCdA/VlzDoBnpvE8ePikT+RoF6dXW1QJPRficxGUf/+iVOZC9A
fXkaalfn4euKRfhk5Ei8/Ze/SHLcsXvXLjm9yjSYGdRx+KhCH1jUjsjqDsQT
XCn3d/ZAv8mG0Ru6MIIcwJBqG3xX2uBT3oGb88zoO8du1CRnkCs5oizlgU4k
Uj6OIJ9NaTqlSQy9g2w+riI7q1WRmLFDaSBHYiyNR2NlChqXp0qI9TCVzYap
eDpBP0mF3VP4E3OSLwxxPjg5k0KXsX1Ve48yizVKvVyjBB9wdCUMPa+TBPTG
nvCdXApD/+mnn6oG3w9f5uTi/eDR6MiNRUtaNEyvVOJAQSSeGn2bwHvnjsfx
/uZ14sq4c5AjsPIT0bME7E6ytTnrCSwCJf3BTmQ81Ik0uiY/QPZKZdGUIslu
J27qxNiNBBiBFbDGhqGrbfBbQYlmQ9/FJtwUZx8HC9uVYS5l83EtsoV3ulI2
UyFWDnycnXcnDEvmoHFZCkwr0ylloHFFmgT/ZiIjEtpx2doKc2YAzKlDYUr2
gyHBDycomnkr9CYplsfArLM9q8bgAxohg6GM+EouvpiQNKPTeooJOfz1YdQc
+gDfHzqEL+fFoWFJJKwvL0Pj7kK0FE3G6Skh+FvoGLwfPxE/Zybg1PHjeP7F
F8TKRcc8DOHpWiUjjKbCxHutyCQS5m+xIeshmwAumaw3/l6yXgJq+sZOhNO0
OHZtJ0bTiAggIvxXdsJ/OSUCzL+wEQPi7dZ7Vdl8XItsPq4iO62ZAg8+6jPD
YCxPhGlVJkyr58O8KkuQ0liZLIY3GaspazRM6QFoTPFHY7I/GpL8cTzWH3+e
MECSwMOBCeBFLjt9OSxE6Oh7JQvslVQmmIWNOdk4O5UC5uhJaM5NQdvTxej+
+xa07b0bhnsz8U3adBifX4OWjel49pGHcfjzz/Hsc8/SAjKvhcciE8riFjYT
WnTmYd+kAjeZPHkauZAFW23I/oNNXNPpPpksN+4e8uYbyJtTrBJO8UtIFQFH
ZNxOgA1b1onhFZ0IqGhHQFEjfOfaYyCSPcKlbEHKNcjmw4VspkTgw0dD9mSY
lqfBXLUA5upsImYBjRAipSKZXFicHCk0HS8IgTFjNIypt8OYPIzScNSnBOD4
3AC8MdFXimWPpO1E3HEUyui9GjdkvrcegjLpmNy+4M0RWngo2TSkci2CGy2w
ObdmCVoeyYV1Z47g5diO5ThQkoG/libCdnAtzA/Ow56Ht+Hll1/Gho0bmBqN
GKYo2+zrQMr0qg5kb+tE3iM25D0swcsg4FIYuI1WRJHbiSDQwqsIuJVWjKm0
YiQBNqKcACyzIrCcgnoCbkiiIymuZfNxLbL5uIrs5AZ1pDTk0SSxJhvmdXkw
r82DqSobjeS6jMtStJFiSBsDw7yRNEJGoCH5dvJ0gfghIRBvTB4iydC2ghhz
JkOOlP73Eht+zmwknFFHi1Ewos3dIuQ8+C5ObEmn6GyqYOCryix8sWUdDuTM
pI7Fo2ZRBIwTg1H3X8/wSFHZsOhYkNhbYjaMKmKxG6woeMyGou1dKHjUhpxt
NmQ+aEMK+ZQ48idRhFbEakKMzH3sMiuCyq0YVWrF7SWEFl3vKGvDHUsMGJr4
oZ0NozqJ9JbNx7XI5sOFbLlDl1gn8sbiWJg3FsC8qUhe1+TAtCJTm0Q4wnU8
6pNHoT7xdroGoi71DnyfdAf2Tx3qzAozwt5KDBFBSp8rSclscCRFJxZiN+L0
uDF4b1IIDoeNxVdJU4TH4nnjUX9fwcfJBbF497mn0VhXi/95apfezsXgXlyU
PdGFil1dKH68C/lkwQtoHkkl600gdxJNy6tIwosD1LsIrzsJryDCaQxxEUzW
G0LWG1xkgH+SIxcermSrS4Z+rtrJjUgHnC0PlKHpoQpY7ism689XtNDJUBgN
Q14kGhZqodMN5H/GoD6VjC8tBN8lB2PfVP8ekDWzlyDbTd9Xojz5a5pGjkmU
ebeWUV5kEqaflZUF86svCfP/vLpKTArseHii0Ez+lYkhqHn7HeG01KmaQyaT
gNnPAWb20Cue6sKqpyUcRY91IYecUOb9NiST545b14lZ5CAiyEGEL+/AeJp+
x1JwGUJwj6U0juAKWWLEbUmH7NOpBnMv2SrMN7pq5wQze/bmbSvQ/Mgqhlpb
GxjLkmFYGkcL4Fm0GI5A/fxwRXtWnz4WtenjCOUQ7Iu4TevKpGPsckO+kiiP
ekVxsGW/13n5C2Umo3xS7pOzPUuUNVvmlda3+/fj3IJ5aN+yBO3rE9CcEIbj
96zHmbJC7AufgosXL6Lbar06yByfbHihC5v2dGE1gVG6U/qA7K3S2zPQsTQ9
RlUz0B2YQjYdXtmBsEq5rTC+vBUhZJMOINttuZds+/LXRTsnkDmuadm5AS27
NhHQq2E7/KksJ09uWp6hoh1LaEcJtBuyp4jn7R/sQ31WKGozxuO7FDvaV4Dt
YNLevwU2z5OkFGFN3f96biw6LHKN2/HFRzCEjBF5RriFVmq89cOIy/WvK7gX
/qETD7/Wje37urH5JQk52/bS/7Qh/xE5yWYSbGkUMiZusiKBEsf3M8mlRFQx
9OQCChvgF/+BA9wh10O2EyXmNQvx03MP4/ye7Tj35GZBi3A19y6FeX0+TBz9
rMykBVsa0ZNIKUGsHQwFM4WPr5sfjmNJwdg7ye8aKQn7RH49ijtBXuYUgVlL
ySAo4R0eSYmH8DQaBZwsSfFUSiSQdK7LNFLidy1sHMRo6cTHG0lH8Q4bnnq7
G88cuCCg2/hiF6qe6cLyJ7uEFy5+nGZFgq9wu03EKhyzpFN0n0TuI5pGxeQV
bQha3IBBsfbNyYyzKh3/ZtnSMFU6LJuL8fOrT6F17zOClpadG9H8aBWati4X
s4CZZgALzbiWewplHLSGY6B0GCuSiJZonKXA9VhCEF6bMEilY/LXV3FH7k50
6GKOso6nuDIxwghTMEl3xIGeCaCs5fPPxCiQJFyFisEOLKx9tgs73ujG7re6
sfW/u3A33bNzLnvChpIdEqXFFJ/ks1/6D1pbbe1EKhny3E3SeMOWtWFkbgPG
534BY8tFlYXrJju1TrlVyG7ZvhbnX9qBn1/ZjZ+e2Yrm7XejiSaHJmLAsrlE
MGDesJhSPsx30wCpmk/Lg1QaHHPFwKjLCsPR2JF4N3E8jE0X5MzKrohpuP0g
0+DAwqhXJAtRf4dbkhMLPC6UfBP3rcjiCbfiZpHjD46FtIjLt/BTTnq7TxrY
MxK8UbK7CWeMl1BN1slxYNYWuTyKp0icN9jISZDsGdVWHaatptOEyg7FE+Np
tRq0tAPD884jvLQOx063oWSXRYLvzdnfLfSWqwlVPwnXoWSnCRfOniFjrybj
LqAVV5ZcbZXEU5gzm30Ob94snqEjtzNNRxPxBOpqPU0IdclBOBMzHEczwnH+
5DGUbKvViU1mvYRV4q2ZvU7s/btraEsXlHGKnXott2A8iywaysXNVLP0nI5z
vLlHT3qQt3BQL6cDX/HFWA+PRUaU/LEZxnMX1Y+aXuKey8XajpLLOrupzvwG
OT8RIh7pEhE2THudbbXwmHa4x5hYueADmosd9KL4wUOUcgCX+I346K5q5u6o
GWujZ72otLxNaCiVlV+6ZRrEC8g7WEXPnsEtY0L5iTzjrBgyOv7mz1//z7jz
NMtb0if4Z4TvGC+eetnXa4mckU7bL5X9FcoRF9xf915dFT0qPaeHrrLVG/oV
7IMoq36v5q/fdJ7NX+Upt6SFXqgvbBYE6fIsInHHxbDQc8/13PWenividwWJ
VgL/XkI9V9xlrBD9ncTZ73XxEUMMVHtX2WQZWA1GerHo1gor9Csv8PdOKNWX
uHtVTJx6L65anp5wnl9azV/Mudxz9WX+YKoE8dOB/DmJv6tWyY9LaiN3Ud9b
/HrAn6cEFMWtYlOf9znFTwV8FZ/4edeyj7zvIdbxlwZeuevUTZtcsZvDBsjK
R55RVM11arjLo4Ux9SztEOrK7vtspEnm1gfpFPAwL0nGbAfu3CESPaWzHqG7
ES1z9FCU6Tinx8itWgtqq7aXZ3piLxOSPfgdevk2r5WXhDW2i9UKd07tqV5O
edRR/pWBuklochNF9JDAZLH8utDHwL3SIWInnSKfhDdmPoVBnBtoz3lwjvSm
LNdzvBIBlPNkOTqhhTu/hr97S5MP/VKuEWS4LH5v+Ubgx10TdiZ+l6HAU8z9
vNaSnt5+tXsZnlpzhbcRe20WscU2kPcmB/IS1l3b4uHPluounF4lNE1keQ+D
d7YSTfZ1kvjWJsqaZT5RDOhYA/96I5b4JjU1yw8dM495qKPA7f8Axr0gOw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907280849161310363,18",
 CellLabel->"Out[3]=",
 CellID->255142803]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Name",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31620],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->236016447],

Cell["Assign a name:", "ExampleText",
 CellTags->"Widget",
 CellID->6146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Frame\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"Widget", "[", "\"\<Panel\>\"", "]"}], "}"}], ",", 
     "\[IndentingNewLine]", " ", 
     RowBox[{"Name", "\[Rule]", " ", "\"\<myFrame\>\""}]}], "]"}], " ", 
   "]"}]}]], "Input",
 CellTags->{"Widget", "Ex--21907280849161310363,20"},
 CellLabel->"In[2]:=",
 CellID->27964],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject140189376708609, 
   JLink`Objects`JavaObject255777331740673]]], "Output",
 CellTags->{"Widget", "Ex--21907280849161310363,20"},
 CellLabel->"Out[2]=",
 CellID->11486]
}, Open  ]],

Cell["Reference the named widget:", "ExampleText",
 CellID->1271],

Cell[BoxData[
 RowBox[{"ref", "@", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<myFrame\>\"", ",", "\"\<title\>\""}], "}"}], ",", " ", 
    "\"\<My Title\>\""}], "]"}]}]], "Input",
 CellTags->"Ex--21907280849161310363,21",
 CellLabel->"In[3]:=",
 CellID->30943],

Cell["The interface has been resized to display the entire title:", \
"ExampleText",
 CellID->9466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907280849161310363,22",
 CellLabel->"In[4]:=",
 CellID->21474],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{153, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907280849161310363,22",
 CellLabel->"Out[4]=",
 CellID->131971549]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14023],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUILoad",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUILoad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRun",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRun"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GUIRunModal",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/GUIRunModal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27272]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31657],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->4141],

Cell[TextData[{
 ButtonBox["Widget Basics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/WidgetBasics"]
}], "Tutorials",
 CellID->79585301],

Cell[TextData[{
 ButtonBox["GUI Building Blocks in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks"]
}], "Tutorials",
 CellID->49281538]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->77512844],

Cell[TextData[ButtonBox["Widgets",
 BaseStyle->"Link",
 ButtonData->"paclet:GUIKit/guide/Widgets"]], "MoreAbout",
 CellID->124981533]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Widget - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 16.3838704}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "Widget[class : class | path | URL[path], {content}] defines a new widget \
instance.", "synonyms" -> {}, "title" -> "Widget", "type" -> "Symbol", "uri" -> 
    "GUIKit/ref/Widget"}, "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5535, 170, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->412783720]},
 "Widget"->{
  Cell[6202, 196, 84, 2, 70, "ExampleText",
   CellTags->"Widget",
   CellID->9009],
  Cell[6311, 202, 222, 6, 70, "Input",
   CellTags->{"Widget", "Ex--21907280849161310363,9"},
   CellID->27743],
  Cell[6536, 210, 318, 8, 70, "Output",
   CellTags->{"Widget", "Ex--21907280849161310363,9"},
   CellID->30867],
  Cell[14448, 361, 246, 7, 70, "Input",
   CellTags->{"Widget", "Ex--21907280849161310363,12"},
   CellID->30369],
  Cell[14697, 370, 319, 8, 70, "Output",
   CellTags->{"Widget", "Ex--21907280849161310363,12"},
   CellID->1538],
  Cell[22597, 521, 370, 11, 70, "Input",
   CellTags->{"Widget", "Ex--21907280849161310363,14"},
   CellID->10991],
  Cell[22970, 534, 320, 8, 70, "Output",
   CellTags->{"Widget", "Ex--21907280849161310363,14"},
   CellID->12693],
  Cell[31735, 715, 360, 10, 70, "Input",
   CellTags->{"Widget", "Ex--21907280849161310363,17"},
   CellID->18440],
  Cell[32098, 727, 320, 8, 70, "Output",
   CellTags->{"Widget", "Ex--21907280849161310363,17"},
   CellID->10089],
  Cell[40586, 895, 73, 2, 70, "ExampleText",
   CellTags->"Widget",
   CellID->6146],
  Cell[40684, 901, 453, 12, 70, "Input",
   CellTags->{"Widget", "Ex--21907280849161310363,20"},
   CellID->27964],
  Cell[41140, 915, 320, 8, 70, "Output",
   CellTags->{"Widget", "Ex--21907280849161310363,20"},
   CellID->11486]},
 "Ex--21907280849161310363,9"->{
  Cell[6311, 202, 222, 6, 70, "Input",
   CellTags->{"Widget", "Ex--21907280849161310363,9"},
   CellID->27743],
  Cell[6536, 210, 318, 8, 70, "Output",
   CellTags->{"Widget", "Ex--21907280849161310363,9"},
   CellID->30867]},
 "Ex--21907280849161310363,11"->{
  Cell[6891, 223, 148, 4, 70, "Input",
   CellTags->"Ex--21907280849161310363,11",
   CellID->1265],
  Cell[7042, 229, 7285, 124, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907280849161310363,11",
   CellID->227635365]},
 "Ex--21907280849161310363,12"->{
  Cell[14448, 361, 246, 7, 70, "Input",
   CellTags->{"Widget", "Ex--21907280849161310363,12"},
   CellID->30369],
  Cell[14697, 370, 319, 8, 70, "Output",
   CellTags->{"Widget", "Ex--21907280849161310363,12"},
   CellID->1538]},
 "Ex--21907280849161310363,13"->{
  Cell[15053, 383, 148, 4, 70, "Input",
   CellTags->"Ex--21907280849161310363,13",
   CellID->7604],
  Cell[15204, 389, 7284, 124, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907280849161310363,13",
   CellID->18311756]},
 "Ex--21907280849161310363,14"->{
  Cell[22597, 521, 370, 11, 70, "Input",
   CellTags->{"Widget", "Ex--21907280849161310363,14"},
   CellID->10991],
  Cell[22970, 534, 320, 8, 70, "Output",
   CellTags->{"Widget", "Ex--21907280849161310363,14"},
   CellID->12693]},
 "Ex--21907280849161310363,15"->{
  Cell[23327, 547, 149, 4, 70, "Input",
   CellTags->"Ex--21907280849161310363,15",
   CellID->23409],
  Cell[23479, 553, 7574, 129, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907280849161310363,15",
   CellID->206619377]},
 "Ex--21907280849161310363,17"->{
  Cell[31735, 715, 360, 10, 70, "Input",
   CellTags->{"Widget", "Ex--21907280849161310363,17"},
   CellID->18440],
  Cell[32098, 727, 320, 8, 70, "Output",
   CellTags->{"Widget", "Ex--21907280849161310363,17"},
   CellID->10089]},
 "Ex--21907280849161310363,18"->{
  Cell[32455, 740, 149, 4, 70, "Input",
   CellTags->"Ex--21907280849161310363,18",
   CellID->29494],
  Cell[32607, 746, 7574, 129, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907280849161310363,18",
   CellID->255142803]},
 "Ex--21907280849161310363,20"->{
  Cell[40684, 901, 453, 12, 70, "Input",
   CellTags->{"Widget", "Ex--21907280849161310363,20"},
   CellID->27964],
  Cell[41140, 915, 320, 8, 70, "Output",
   CellTags->{"Widget", "Ex--21907280849161310363,20"},
   CellID->11486]},
 "Ex--21907280849161310363,21"->{
  Cell[41543, 929, 301, 9, 70, "Input",
   CellTags->"Ex--21907280849161310363,21",
   CellID->30943]},
 "Ex--21907280849161310363,22"->{
  Cell[41971, 946, 149, 4, 70, "Input",
   CellTags->"Ex--21907280849161310363,22",
   CellID->21474],
  Cell[42123, 952, 8342, 141, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907280849161310363,22",
   CellID->131971549]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 54573, 1239},
 {"Widget", 54706, 1243},
 {"Ex--21907280849161310363,9", 56064, 1280},
 {"Ex--21907280849161310363,11", 56326, 1287},
 {"Ex--21907280849161310363,12", 56595, 1295},
 {"Ex--21907280849161310363,13", 56860, 1302},
 {"Ex--21907280849161310363,14", 57130, 1310},
 {"Ex--21907280849161310363,15", 57397, 1317},
 {"Ex--21907280849161310363,17", 57669, 1325},
 {"Ex--21907280849161310363,18", 57936, 1332},
 {"Ex--21907280849161310363,20", 58208, 1340},
 {"Ex--21907280849161310363,21", 58475, 1347},
 {"Ex--21907280849161310363,22", 58613, 1351}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2300, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2923, 82, 43, 1, 70, "ObjectName",
 CellID->5994],
Cell[2969, 85, 674, 21, 70, "Usage",
 CellID->579]
}, Open  ]],
Cell[CellGroupData[{
Cell[3680, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4158, 128, 69, 1, 70, "Notes",
 CellID->24023],
Cell[4230, 131, 1268, 34, 70, "3ColumnTableMod",
 CellID->25709]
}, Closed]],
Cell[CellGroupData[{
Cell[5535, 170, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->412783720],
Cell[CellGroupData[{
Cell[5920, 184, 147, 5, 70, "ExampleSection",
 CellID->27429861],
Cell[6070, 191, 129, 3, 70, "Input",
 CellID->764121120],
Cell[6202, 196, 84, 2, 70, "ExampleText",
 CellTags->"Widget",
 CellID->9009],
Cell[CellGroupData[{
Cell[6311, 202, 222, 6, 70, "Input",
 CellTags->{"Widget", "Ex--21907280849161310363,9"},
 CellID->27743],
Cell[6536, 210, 318, 8, 70, "Output",
 CellTags->{"Widget", "Ex--21907280849161310363,9"},
 CellID->30867]
}, Open  ]],
Cell[CellGroupData[{
Cell[6891, 223, 148, 4, 70, "Input",
 CellTags->"Ex--21907280849161310363,11",
 CellID->1265],
Cell[7042, 229, 7285, 124, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907280849161310363,11",
 CellID->227635365]
}, Open  ]],
Cell[14342, 356, 81, 1, 70, "ExampleText",
 CellID->12891],
Cell[CellGroupData[{
Cell[14448, 361, 246, 7, 70, "Input",
 CellTags->{"Widget", "Ex--21907280849161310363,12"},
 CellID->30369],
Cell[14697, 370, 319, 8, 70, "Output",
 CellTags->{"Widget", "Ex--21907280849161310363,12"},
 CellID->1538]
}, Open  ]],
Cell[CellGroupData[{
Cell[15053, 383, 148, 4, 70, "Input",
 CellTags->"Ex--21907280849161310363,13",
 CellID->7604],
Cell[15204, 389, 7284, 124, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907280849161310363,13",
 CellID->18311756]
}, Open  ]],
Cell[22503, 516, 69, 1, 70, "ExampleText",
 CellID->32212],
Cell[CellGroupData[{
Cell[22597, 521, 370, 11, 70, "Input",
 CellTags->{"Widget", "Ex--21907280849161310363,14"},
 CellID->10991],
Cell[22970, 534, 320, 8, 70, "Output",
 CellTags->{"Widget", "Ex--21907280849161310363,14"},
 CellID->12693]
}, Open  ]],
Cell[CellGroupData[{
Cell[23327, 547, 149, 4, 70, "Input",
 CellTags->"Ex--21907280849161310363,15",
 CellID->23409],
Cell[23479, 553, 7574, 129, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907280849161310363,15",
 CellID->206619377]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31102, 688, 218, 7, 70, "ExampleSection",
 CellID->16100],
Cell[CellGroupData[{
Cell[31345, 699, 233, 7, 70, "ExampleSubsection",
 CellID->32759],
Cell[31581, 708, 129, 3, 70, "Input",
 CellID->160911545],
Cell[CellGroupData[{
Cell[31735, 715, 360, 10, 70, "Input",
 CellTags->{"Widget", "Ex--21907280849161310363,17"},
 CellID->18440],
Cell[32098, 727, 320, 8, 70, "Output",
 CellTags->{"Widget", "Ex--21907280849161310363,17"},
 CellID->10089]
}, Open  ]],
Cell[CellGroupData[{
Cell[32455, 740, 149, 4, 70, "Input",
 CellTags->"Ex--21907280849161310363,18",
 CellID->29494],
Cell[32607, 746, 7574, 129, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907280849161310363,18",
 CellID->255142803]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40230, 881, 221, 7, 70, "ExampleSubsection",
 CellID->31620],
Cell[40454, 890, 129, 3, 70, "Input",
 CellID->236016447],
Cell[40586, 895, 73, 2, 70, "ExampleText",
 CellTags->"Widget",
 CellID->6146],
Cell[CellGroupData[{
Cell[40684, 901, 453, 12, 70, "Input",
 CellTags->{"Widget", "Ex--21907280849161310363,20"},
 CellID->27964],
Cell[41140, 915, 320, 8, 70, "Output",
 CellTags->{"Widget", "Ex--21907280849161310363,20"},
 CellID->11486]
}, Open  ]],
Cell[41475, 926, 65, 1, 70, "ExampleText",
 CellID->1271],
Cell[41543, 929, 301, 9, 70, "Input",
 CellTags->"Ex--21907280849161310363,21",
 CellID->30943],
Cell[41847, 940, 99, 2, 70, "ExampleText",
 CellID->9466],
Cell[CellGroupData[{
Cell[41971, 946, 149, 4, 70, "Input",
 CellTags->"Ex--21907280849161310363,22",
 CellID->21474],
Cell[42123, 952, 8342, 141, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907280849161310363,22",
 CellID->131971549]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50538, 1101, 311, 9, 70, "SeeAlsoSection",
 CellID->14023],
Cell[50852, 1112, 717, 26, 70, "SeeAlso",
 CellID->27272]
}, Open  ]],
Cell[CellGroupData[{
Cell[51606, 1143, 314, 9, 70, "TutorialsSection",
 CellID->31657],
Cell[51923, 1154, 268, 9, 70, "Tutorials",
 CellID->4141],
Cell[52194, 1165, 387, 12, 70, "Tutorials",
 CellID->79585301],
Cell[52584, 1179, 429, 12, 70, "Tutorials",
 CellID->49281538]
}, Open  ]],
Cell[CellGroupData[{
Cell[53050, 1196, 318, 9, 70, "MoreAboutSection",
 CellID->77512844],
Cell[53371, 1207, 133, 3, 70, "MoreAbout",
 CellID->124981533]
}, Open  ]],
Cell[53519, 1213, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

