(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51357,       1140]
NotebookOptionsPosition[     43286,        909]
NotebookOutlinePosition[     48521,       1047]
CellTagsIndexPosition[     48123,       1035]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Widget Layout in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Widget Layout in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "WidgetAlign" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetAlign"], 
          "WidgetGroup" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetGroup"], 
          "WidgetSpace" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetSpace"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"WidgetAlign\"\>", 3->"\<\"WidgetGroup\"\>", 
       4->"\<\"WidgetSpace\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WidgetFill", "ObjectName",
 CellID->3370],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"WidgetFill", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]is a widget layout placeholder used when adjacent \
widgets should not dominate the layout space."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8991]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->57404327],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->171614746],

Cell[TextData[{
 "Without ",
 Cell[BoxData["WidgetFill"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Submit\>\""}], "}"}]}], 
        "]"}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "}"}]}], 
    "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,16"},
 CellLabel->"In[2]:=",
 CellID->30185],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject500291027861505, 
   JLink`Objects`JavaObject149346515419137]]], "Output",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,16"},
 CellLabel->"Out[2]=",
 CellID->25516]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,17"},
 CellLabel->"In[3]:=",
 CellID->28608],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,17"},
 CellLabel->"Out[3]=",
 CellID->15782404]
}, Open  ]],

Cell["After resizing:", "ExampleText",
 CellTags->"LayoutExamples",
 CellID->9499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,18"},
 CellLabel->"In[4]:=",
 CellID->12425],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{202, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,18"},
 CellLabel->"Out[4]=",
 CellID->288647958]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["WidgetFill"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WidgetFill", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Button\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Submit\>\""}], "}"}]}], 
         "]"}]}], "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,19"},
 CellLabel->"In[5]:=",
 CellID->25331],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject361065116336129, 
   JLink`Objects`JavaObject453343595986945]]], "Output",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,19"},
 CellLabel->"Out[5]=",
 CellID->9814]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,20"},
 CellLabel->"In[6]:=",
 CellID->11502],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,20"},
 CellLabel->"Out[6]=",
 CellID->637973323]
}, Open  ]],

Cell["After resizing:", "ExampleText",
 CellTags->"LayoutExamples",
 CellID->19537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,21"},
 CellLabel->"In[7]:=",
 CellID->17598],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWnl4VdW1P7k3E8GggFAoY4QAxgBJmBIgDIYMZIAEEiCQhCSQkTAlCIIg
rYVSRFooqMVqC5/DqwpYWxRByhNU9BUUBIUUiBlv7s083nsTEH9vrb3PvbkJ
Nxheyz/vfN8+e1577d9ae+219zlRKesy01amrMtaljI0NDdlTWbWsryhIatz
qUjroCjK1xRihyqcBiUtLy2URw9A6f0CB+W8eCuKI5S+R6EMPqiGQ9054cQp
N07Ra5DI8kumDrVLyQqZclO7DTrkbK1ws5Jyap96tH1fzh5idgQbr3MOyoA/
Oqh8Upv+F+Hq+y+4h17HI7GFcJv9Lyp1nJlPVdMKHoYSeJNT/AoscFOzgQWW
smnWsmlcZpvqflcP+6TuJtrWWE1xkwKeReBNKJMuQfE+xbO5exa95unQN7sW
rnEFVOoyt/ITKGENLCTuOfo0Q6w4tAlJ7aZ2OYfqinxuHNYgOzy4xoM7Nnbx
s994GlM+9O80vj82fPM7b3wXG/fTuDM2phXcB3R2G7vco7EdnjuHzg4a/4HG
gQUPsnGX0ehEgvfR+J6KdF/ifjCN74uN/4eNt4vGzqipvI66mkI0NehhMtbA
bKpDi6l+AFrM9f1x65ZJyynFhd6NaG1ppLiBOnx/P6M4orL8W05hy4F34blo
WwCUqeuI5s+inkXOC2/C2FxFA9fek2Z+R5q64ovI2HEQI6O2I2rLmcnIeq6W
JsTZFbteFzRt6P0EOS1Kv78g+Nl5pEyZKt5OIt/UUH4PvmyMqwXR0u/P8/SY
hAhVVTpUV+km0Ktc6SayFYZiazU3bagtuYeZtTN3yxi7iAAFf9TXVyquqKs1
yKL3dKK6vrbYlm6Xyf72vXL89qiOyVYx2boKUbTbSraoc7J3IdJGdu/7egrl
7mhoqHZkl0jLKY1wjpw4ySnbWBF1GpF0tFaqDToWq7HoIoYgzol/y6gdOC+w
B0innO8/ZsD+vxseIrI1vMLEUDUip+lQpqis1ch5aS2FbRX2GhOvNkRt6y1x
D7VZfX01XiR2OPykMO4xpT98VEmhoicaGy0cUUrluWtlGlHmai1TyzvGPdRm
LKQDctSucN6pdr76cSVeO1X1MJqaalUFoRSZEx6TUtZgyUv+uY22XZns59qu
n029Je6hNuPpvPZxFY1fdTf/g7rO/8HT1RzciWyd4N+RU2Q55Jh11qDmrXOs
Y+dVbaNqlCiVmuZs28c27iEaMf+1OHS6hkL1T/Pv0jn/b56pwRtnax5Cc3O9
iiilRM5RvF1ty0Sw5NVYnVH7/oqdMklTLGhJmKf05qe1ePNsrZ0F/VNWvm0O
b39eh7+cq38IRmODOh6lRE5jp8zJTpm7nTJJz1XwzkNwaMemdLq7zOaRL+tx
5IsGd5hMjQIHV06pg1JK5Lp3KFOEzLnMVTB25It6HKbwk4zcQ+bvn2/k4E9k
mwTZRll0obELO0LnZI991YQPvm7yR0uLiciazUYc+1oU/Vtkj19qxkffNPuT
/9JKZG/daqGsER9dMv4fTKYTSgok2ZNXjBRM+OGHHxR/et8mm3Pysizjevaj
unTCa/M5zrM7hFPfmsjn4LeTyLNT1jmhbuOv2yP0zIt/YedHmYKv9VAdoWde
egeV+u/uscw70iK/qugiyku+EfQ6+GoZvzkIQ9kVEQTJKcSnx9sdfaK7+WMe
mC4hqQxG8c1/9kfB1U+1nCLSjC/PgFtYub2b9M8vUmmRDBFFZEOCLhJph6CL
cJh1iQN5V5rgS1pOarhc0coabkE5P86N5W6+nB+sEhD0xhA2fmd4tD6/p9Fc
Oo5G6F3g9mIYjRxGCc+nAaJuMo1oahFVSnEJW2N6U9n8Yk5ZctElKdzEB0pI
EeeZZkSpyDlbyoKIixkiyFsIfk+7Lstkbka7smnXebTJ/2KL65/PKSgT8mWa
Y+bdv5JnxjDuEm6WdWIRVZLl2FImsqicIV5EZQm0OySTdV3aqIU2rcER2sxm
GlSbeQsO2SJQS34TI2l34LC8lYNCE0tuJXSTfxAphjChlbMyjm+BspiW3yJa
2QtNYkQzj7iQlk5cM5SYZo41nHDkFHMaQzYrsk7Gsg33i2wivELrHHhqDrZz
c2k/t0U0hyWNlph6apPZXGtTTDwjng/lnLNb6ZXzgwu0K26TXLN/9OWaAJ4a
VTul30b6H42gR3lYvLXQ1dwRZVTH7HTSzkW2O9AEpxQzAyJgcEoyI/2lJuUR
0cYVuuofkL6vAU5zG3liPC/ShcqOUrPMrKTdzBySjTwbVse0VlVCNB+eDpW5
rL6jhUvuHUc4r/2RKnNBr1XI5jkqfZDxJxMuXW/AqAWfwn36h+g56x/oFfwx
Hg0+gV6zTqB38Cn0DvkHHgk+DffgT+AWfAausz6F88xPoJ3+CRymf0oMncaQ
OSdwMb+G6SkCP8X3P06bkWVVY2VKP2BE7dVL+GDWKLz1hDsO+/TEu7698Lbf
o3jbpxcO+/XGEQpHfR/B+z7u+NsYNxwb7Yr3vZzx/igtjo10wNHhCg5PHYLK
by8K9IXyWdCXyCsW6B07Qq9h3KlY6tEtiXrODwJwDQPuDJd1P2qsqI9j1ANU
1HW1dzAqqRC95xZiQFwhPBaXwDOhGCMSizCc4mFJJfCgMJjCgKU69E3SoXdi
OXos0aHbonI4xpbDYQ7xEnyF0PlIaJEF9QdA24o66/JXs0fhgn9vXJg2ABdn
eeBiqCeFEbgYMhyXQofhmxAPXA4ejO+CB+C7J/vi6oze+C6wB64GdMN3Exzx
jY8DznopeJeQF7TvgfrdCq8qu1D1HoiLixPgOjK4WSq4/PSIrsHAJXUYtawe
YzPrMW5FA8bnNMA3pxG+KxsxZnUjvNY0wnNNE4asbkL/lc3ond0M9/RmuCQ3
QbOYbE0UDTv5hA24D4o2QavSzp/UAzeCBqIgchS+nzcWhXHjULRwPIrifFG0
wBfFC8agJM4LZfM9URY9BLrI/tCF9YYuyB1l01xQ5K/BN2MVvDNMsdCObGIL
3R5csbnRZjHkcntrslRaEwIXfz500BllZWXUueT6DegNBg6k8FVVVfSmasYc
Djk/ckhlfNyEFZQTeXRBEzxTm+G7ohkBa5sRuM5IwYQpTxkRsN6ISRuM8Hva
BO+nzfDcYMaQ9Wb0zzWj56oWdM80wym5GZr5pImBpy0TIdq+D4K2dXPip2Dq
oyiK8ERxrC9KlwSgLCkQZUspJE2BLimAwiSUJ/pBv8QbhoWeqIgdgoro/qgI
7wnDrO4oC3TC1XEavDfCQdLuaM19z1kF0A3KsKvqRqWXm+5SqzkXCGdlZdHM
SQoaAb4bbty4gc93vSBiEoQQC6c55jx3IkloeGMWkCXzpuwmNMxJMNQvvglj
aN+bTMA9ucFIS4y57AavzS0YvqkFgza0oE9eC3rktKDbsmY4LdBDM/2/bTTV
Pp3uosVAe/2sOz8/38/oh+KYMShNmIyy1CdhPPOBKC9PC6IwE+XLA6FP9Ych
2Q8VCV6ojB8u6s0fHUJFWA/oZnTDtYlO+OtIDRdrGF1W8JkGia/3l1Z8Hdvw
ZfRjqjQMMHuDBDEjxeot4CXuGUVK4X8yM1CxJAYnT56UaFN8Zv9egXBTUxP3
kzuthpFdIXwcicjgxCZMXEVokArOfqYN2dFbSA0J2cGE7M8I2Z4rzcIWdI/X
i63OgmwroWeHjigLf9aMsGdNCN5qwsxfkKpTPGGruR1tfuzQlr4W+U38FJJh
Llk0USCvy5itFfVOKM8Mhj5jJvTLp8CQOgGVSaMVWecmNLt8ljuuTemO959w
liQtGs2oswERPooA3Um1Kgx6GY1byZ6kIpF/SKCel5cn0GS0P4iIwqUvzuFa
/EKUZMWgcG0izmcvxplhw3Ds73+XwnHE/n375EYrwziWYAA7kir0nqlNCMxr
RhjBNecXpjboN5sxYmMLhpIV6J9nRt/VZvTOasYjiQa4zbIqNdHpY4+OKJvz
SxMiKB1KkD9JYSqFiQy9DW1+OqEd16BIzNiqlJI10WWEoTxnDspXRkuItdBn
Pgl92lSCfqIKu7MwKobIvigL7Y386eTEjHZT9X2mQZxWSuRpxeu4rT1h6Pl8
J6DXtTnyZFcY+rNnz6oK745zSxJw0msEmhNCUB0TBP1bOTieHIiXRwwSeO/d
8zuc3LpBxIw7uzsCqxT2Ot1YrVTUniCFm/U0IUbIzHvOhPm/MiGG4qhfktJS
WRCFQFLeCZtNGL2JUCPEPNaZMWCtGf1WUaDNse9SPR4OtS4Goj3YLm1+ukJb
mKi7abM8xEGCn+K5T6Bs2SyUr5gD/ep5FOajfFWMlMAjJJFAWJ4fjQ0wxHrA
ED0A+qh+KAvvh2vk3PzN92FJlhfCjOK2Q6TXcYtUfgZl6JfyLMZSidG1O16x
VC6cv4CCUx/j21OncG5uKEqXBcL4xgqU709Bdeok3PD3xv/4jsTJsAmojw3H
9atX8aeDfxYHGQ0LI4d3b1UYfrQpRmwxIpaEsGCbGXG/MgvgokiFw7aQChNQ
UzeZMJ42yNHrTRhBy8KDBDFwtQkDV1IgwAamlKNXmFWFO6XNT1do89MJ7Rj+
sMBPSawfdFkR0K+JhX7tAhjWxAmhlOdEiTVOGquPGwH9PA+UzxmI8qiBKI0c
iKshA/HXcb2kEHhNsAD4zMuWX64N4Un2vVsKbJpUSbAUNi2JR3EA+c9BE1GV
MAeNB9LQ+s9taDz8FMq2xOKrmKnQ/WkdqjfNw6vP78SFzz7Dq6+9SufJxGpe
kCxQJreoitwUegfwCCpwk8icx5AdWbjdjPhfm0U8j/JRpLmhz5BJ30gmnbyW
8eTJeOcScCSMxwiwwStMGJJtgkd2EzxSy9F3ttUbItpD7dIWQukCbX7s0GaR
CHz4KY2fBP3KGBhyF8KQF0+CWUgrhISSHUV2LFSuFNqTF3pDN38EdNGPQRc1
mMIQlMzxwNXZHnhvQl9Jls2S5WLi8UtQRhy2yKY/efmnoEy8LG8z+K6EziFK
PC2phAohG4uLU7NuGaqfT4Bx7xIhl8t7VuJ4+nx8kREB84n1MDw3F4d27sAb
b7yBjZs2smgsgmERxRuybIQyNbcZ8TtMSHzejMSdErz5BNwcBm6TETPJ7Ewm
0MbnEnCrjRiZY8QwAmxoFgGYaYRnFvn4BFz/CFuh2KfNT1do89MJ7ahSdaWU
JtJOsS4ehg2JMKxPhD43HuVkunQr5lhWSlnMSJTNHUYrZChKox4jS+eJ78I9
8d6k/lIYlpshxpyFIVdKjy0kjX7tpRF+U10tOiERywYunM8TH+LatnnkogUI
CXyZE4fPt23A8SXTibEwFCyeDN0ELxT94RVeKao0KjRMSFw1sTR0KmIhG41I
fsGM1N0tSN5lxpIdZsQ+Z8YcsimhZE9mElqT1xJipO6jVxgxKsuI4RlGPJZO
aFH8eGYjHl9WhgER/7BKQ6duIh1p89MV2vzYoS0v7CKKRFqXFgLDpmQYNqfK
eN0S6FfFWjYRdnNtn5Ko4SiJeIxiTxRFP45vIx/H0YAB7aXCEmFrJZaIEIrr
3UKJLbUVikacyx7CjTEj8dFEb1zwG40vI/2FxeJ9Y9fAvkIe+QtD8OFrB1Be
VIi/vLxPa5VFdgdZZP6+Bdn7WpD2uxYkkQYvpH0kmrQ3nMxJEB20Agkv9lLH
El5PEF6jCKeRJAsv0l5v0l6v1DIMjLSVhZM92uq5wd1eP3kvaYNzxS8zUfmr
bFQ8m0ban6RY/KeylCCUJQaidJHFf+pO9mckSqJJ+WK8cSXKC0cCBraBbFF7
CbJV9ftKlCedp23kskSZL28Z5cV6ofpxcXEwvP26UP/P8nLFpsCGhzcKi8q/
NcEbBcc+EEZL3arZb9ILmFOYnBsvKRVrNtOrXm7BmgMSk9QXWrCELFHsL8yI
IvMdusGEGWQlJpOVGL+yGT60B48mN9ObMB9NYQxh5r1Mh0GRp6x7qgXrDrRV
rB+y168d1mzeq3asQtXzaxhvyylBlxmFsuWhdB6eQWfjyShZMF6x1JXMG43C
eWMIam8cmTzIwsrEy2x3vb+UUA9/S7FR6H7v8mkYynSGOl/enbNSS6gtCs1n
rm+OHkXNwrlo2rYMTU+HoyrcD1efeRo3M1NwZLw/bt++jVajsT3SK2wUmp2U
jX9uweZDLVhLYGTslYYgfrs0+Qx0CO2RM/MY6Gb4k2KPz2mGX468ZfDJaoA3
KaYNyFaF7kDbehC2068dyOzcVO/diOp9mwnotTBfOCvLyZzrV85X0Q4htGcK
tEvj/UV908dHUBLni8L5Prgyx4r2XWDb6HW3nwKbN0vxabmJ2D8/OwTNFfK0
2/z5aZR5jxRpRriazmx8HcSIy5OwPbgX/dqEne+0YveRVmx9XULOur38t2Yk
PS932liCLYb8xojNRoRTYCd/OtmVybkMPdmBlFL0C/vYBm7vB0G7nUgM6xah
9rWdqDu0GzUvbhViEfZmy3IYnk6Cnl2g1bF0dIsh8URQCBcHiLLk6cLQFy0Y
j8uRXjg8sV8XReJ3Rn5RCr1GpuY6gVlIoUyIhC98pEichLmxiIBDRWQYlZIQ
iDq3ZTFS4LEWlfsyWmNZvG5sv1SZpO0x4+VjrXjl+C2B36aDLch9pQUrX2wR
9jjtd7Q/EoYpu83Ca2HvZR75+ZFkQ4JoaUxa1YhRS0vRJ8R6a0m0vR8Ebamd
qkwqtqah/u2X0XD4FSGb6r2bULUrF5XbV4r9wEB7QQXtvRXPpEiPaB17Q/Og
y44k2QShmFzYy+Gj8M64PqpMJp3vxCY5tpOJJvgSz/E6NyaxMMzkVoofSJq0
LAVKVnz2qVgKUhKdyCO5oyjWv9qCPe+1Yv/fWrH9v1rwFOXZTGf+3oz0PRKq
peSuJLGF+g0dtbabEE0qPXuzVGO/FY0YllAKn4TPoau+rYrigdGOLlJ+LmhX
716Putf3oP6t/ah9ZTuqdj+FStomKkkMFVvThRgMG5dSSILhKVoquQvotBBN
y2S2WCJFcX64FDIMH0b4QFd5S260bJRYFo+dYFnYiGL4W1IUM/8Jh8h2ouAV
oiTpmbfUCmc4pFWJFH+OTKEzXVIF13LQWq2TT4c10Q3p+ypwU3cHeaSn7BvG
bZNHpjDyzvnmjWwGDTAtz6jBlLX0GpfTrDjDh06wo5Y3Y0hiHcZnFOHyjUam
pPk3iPbsjKj61bgI6Xv1uFV8k9Q+j9Q8mU5hcfIElh5Grs+TbIL4VmfpNA1Z
oSka2pfHEasltD8URY3CzeAhuDR/POryLyN9R6FGXEFrJbYSdMsC0IjPA44W
yKVFmn+dbXwh92BQUyssUKdVUcuMGg2n+NaPatrgr2BHX+4OWeKjshZOi3VI
f6kKuprb6ndPF5HncnHeo2C3zX5qs6BUbleEiNM8iQhrp7XNjkI4TbnQplE8
Oa/jFovb56D480uUslMX8ZX4Lq/OzNF2ZjwbLc+LSrMaxQzlZOXHcBl8+VCZ
zFN0blvm0k+UX9HnF4t1o+HfAvgHgZuOvOvyXfU1/l/hCuPFOzGbfksgs6Sx
XKRKfsXkSBbMr2MHVgVHGTVaaHIaukG7iq0RJdVP2vyBnN4v8od7Si2rpgG1
KVVCQJrEChGYcbE2tMy5lllv41wRfzRItMLzFcG54ihdh6ArEud+74pPHGK1
WllllWVgLTDSwIKtVUZoV9/iT6JQ8u4we7ksODUvYkuaajjNg+bxR3Uud177
I39TVZZyrQ9/ceJPr7ny+5PayVG07yb+TuAvWAKKtAZx288XoOK/A47FXwB8
nekq822Ctf3rgU/zjA8blwRxw8MKyJMPvKmoM9eo3i+vFsbUOaNZTFey33sT
bTc/f45eHjv5mDJyN/DEHhGolt5a+O7HSzJFlaJMwykthm239KC+an/5phpr
maDsxGNo5Wguq+8IbWwSJxhmTuVUKzc/YpT/diA2CU3uoggOCUwmy8P5vgDm
SoPJe+kV+CK6YfrL8OXUWGvKiVM0b0pyO9uYBEApZ6ajEbNw5GH407hUed9z
8sggvWfxB8xXAj9mTeiZ+KOG/FDhBfD5S5p7a2y1MrzJJghrI+7fKsS121i+
r/ThY62j5dqHv2yqN3NaVaAxIsn3GnzbFaG3HpvElzhRViXTEWJBh5Tx3zni
2K9XQ5X8AjL9spO6Chz+Fy9JwiE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{206, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,21"},
 CellLabel->"Out[7]=",
 CellID->251978202]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30079],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetAlign",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetAlign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetGroup"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetSpace"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24399]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29145],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Widget Layout in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"]
}], "Tutorials",
 CellID->1000152870]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WidgetFill - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 13.1340368}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "WidgetFill[] is a widget layout placeholder used when adjacent widgets \
should not dominate the layout space.", "synonyms" -> {"widget fill"}, 
    "title" -> "WidgetFill", "type" -> "Symbol", "uri" -> 
    "GUIKit/ref/WidgetFill"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2864, 88, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "LayoutExamples"->{
  Cell[3663, 123, 642, 15, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,16"},
   CellID->30185],
  Cell[4308, 140, 328, 8, 70, "Output",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,16"},
   CellID->25516],
  Cell[4673, 153, 169, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,17"},
   CellID->28608],
  Cell[4845, 159, 8451, 143, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,17"},
   CellID->15782404],
  Cell[13311, 305, 82, 2, 70, "ExampleText",
   CellTags->"LayoutExamples",
   CellID->9499],
  Cell[13418, 311, 169, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,18"},
   CellID->12425],
  Cell[13590, 317, 8541, 144, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,18"},
   CellID->288647958],
  Cell[22283, 473, 738, 17, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,19"},
   CellID->25331],
  Cell[23024, 492, 327, 8, 70, "Output",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,19"},
   CellID->9814],
  Cell[23388, 505, 169, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,20"},
   CellID->11502],
  Cell[23560, 511, 8415, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,20"},
   CellID->637973323],
  Cell[31990, 656, 83, 2, 70, "ExampleText",
   CellTags->"LayoutExamples",
   CellID->19537],
  Cell[32098, 662, 169, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,21"},
   CellID->17598],
  Cell[32270, 668, 8537, 144, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,21"},
   CellID->251978202]},
 "Ex--21907296125549291768,16"->{
  Cell[3663, 123, 642, 15, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,16"},
   CellID->30185],
  Cell[4308, 140, 328, 8, 70, "Output",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,16"},
   CellID->25516]},
 "Ex--21907296125549291768,17"->{
  Cell[4673, 153, 169, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,17"},
   CellID->28608],
  Cell[4845, 159, 8451, 143, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,17"},
   CellID->15782404]},
 "Ex--21907296125549291768,18"->{
  Cell[13418, 311, 169, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,18"},
   CellID->12425],
  Cell[13590, 317, 8541, 144, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,18"},
   CellID->288647958]},
 "Ex--21907296125549291768,19"->{
  Cell[22283, 473, 738, 17, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,19"},
   CellID->25331],
  Cell[23024, 492, 327, 8, 70, "Output",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,19"},
   CellID->9814]},
 "Ex--21907296125549291768,20"->{
  Cell[23388, 505, 169, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,20"},
   CellID->11502],
  Cell[23560, 511, 8415, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,20"},
   CellID->637973323]},
 "Ex--21907296125549291768,21"->{
  Cell[32098, 662, 169, 4, 70, "Input",
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,21"},
   CellID->17598],
  Cell[32270, 668, 8537, 144, 70, "Output",
   Evaluatable->False,
   CellTags->{"LayoutExamples", "Ex--21907296125549291768,21"},
   CellID->251978202]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44372, 935},
 {"LayoutExamples", 44504, 939},
 {"Ex--21907296125549291768,16", 46326, 986},
 {"Ex--21907296125549291768,17", 46607, 993},
 {"Ex--21907296125549291768,18", 46916, 1001},
 {"Ex--21907296125549291768,19", 47228, 1009},
 {"Ex--21907296125549291768,20", 47510, 1016},
 {"Ex--21907296125549291768,21", 47822, 1024}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1731, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2354, 68, 47, 1, 70, "ObjectName",
 CellID->3370],
Cell[2404, 71, 423, 12, 70, "Usage",
 CellID->8991]
}, Open  ]],
Cell[CellGroupData[{
Cell[2864, 88, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3241, 102, 147, 5, 70, "ExampleSection",
 CellID->57404327],
Cell[3391, 109, 129, 3, 70, "Input",
 CellID->171614746],
Cell[3523, 114, 115, 5, 70, "ExampleText",
 CellID->12193],
Cell[CellGroupData[{
Cell[3663, 123, 642, 15, 70, "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,16"},
 CellID->30185],
Cell[4308, 140, 328, 8, 70, "Output",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,16"},
 CellID->25516]
}, Open  ]],
Cell[CellGroupData[{
Cell[4673, 153, 169, 4, 70, "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,17"},
 CellID->28608],
Cell[4845, 159, 8451, 143, 70, "Output",
 Evaluatable->False,
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,17"},
 CellID->15782404]
}, Open  ]],
Cell[13311, 305, 82, 2, 70, "ExampleText",
 CellTags->"LayoutExamples",
 CellID->9499],
Cell[CellGroupData[{
Cell[13418, 311, 169, 4, 70, "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,18"},
 CellID->12425],
Cell[13590, 317, 8541, 144, 70, "Output",
 Evaluatable->False,
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,18"},
 CellID->288647958]
}, Open  ]],
Cell[22146, 464, 112, 5, 70, "ExampleText",
 CellID->27769],
Cell[CellGroupData[{
Cell[22283, 473, 738, 17, 70, "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,19"},
 CellID->25331],
Cell[23024, 492, 327, 8, 70, "Output",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,19"},
 CellID->9814]
}, Open  ]],
Cell[CellGroupData[{
Cell[23388, 505, 169, 4, 70, "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,20"},
 CellID->11502],
Cell[23560, 511, 8415, 142, 70, "Output",
 Evaluatable->False,
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,20"},
 CellID->637973323]
}, Open  ]],
Cell[31990, 656, 83, 2, 70, "ExampleText",
 CellTags->"LayoutExamples",
 CellID->19537],
Cell[CellGroupData[{
Cell[32098, 662, 169, 4, 70, "Input",
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,21"},
 CellID->17598],
Cell[32270, 668, 8537, 144, 70, "Output",
 Evaluatable->False,
 CellTags->{"LayoutExamples", "Ex--21907296125549291768,21"},
 CellID->251978202]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40868, 819, 311, 9, 70, "SeeAlsoSection",
 CellID->30079],
Cell[41182, 830, 983, 35, 70, "SeeAlso",
 CellID->24399]
}, Open  ]],
Cell[CellGroupData[{
Cell[42202, 870, 314, 9, 70, "TutorialsSection",
 CellID->29145],
Cell[42519, 881, 273, 9, 70, "Tutorials",
 CellID->341631938],
Cell[42795, 892, 449, 12, 70, "Tutorials",
 CellID->1000152870]
}, Open  ]],
Cell[43259, 907, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

