(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21996,        584]
NotebookOptionsPosition[     18070,        461]
NotebookOutlinePosition[     20377,        526]
CellTagsIndexPosition[     20172,        518]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Widget Layout in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Widget Layout in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "WidgetAlign" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetAlign"], 
          "WidgetFill" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetFill"], 
          "WidgetSpace" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetSpace"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"WidgetAlign\"\>", 3->"\<\"WidgetFill\"\>", 
       4->"\<\"WidgetSpace\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WidgetGroup", "ObjectName",
 CellID->13910],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"WidgetGroup", "[", 
       RowBox[{"{", 
        StyleBox[
         RowBox[{"content", ",", " ", "\[Ellipsis]"}], "TI"], "}"}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]specifies custom layout settings for how the content \
widgets are displayed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["WidgetGroup"], "InlineFormula"],
 " can be used instead of default simple ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/List"]], "InlineFormula"],
 " structures to add optional custom layout features."
}], "Notes",
 CellTags->"WidgetGroup",
 CellID->13132]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->264115877],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->209028482],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->160911545],

Cell["\<\
Change the layout of the buttons to a row (as opposed to a column):\
\>", "ExampleText",
 CellID->18944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"WidgetGroup", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Button A\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Button B\>\""}], "}"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "->", "\"\<Button C\>\""}], "}"}]}], 
          "]"}]}], " ", "}"}], ",", " ", 
       RowBox[{"WidgetLayout", "\[Rule]", "Row"}]}], "]"}]}], "]"}], 
   "]"}]}]], "Input",
 CellTags->{"WidgetGroup", "Ex--21907299533234115765,5"},
 CellLabel->"In[2]:=",
 CellID->6125],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject500854842982401, 
   JLink`Objects`JavaObject330215087669249]]], "Output",
 CellTags->{"WidgetGroup", "Ex--21907299533234115765,5"},
 CellLabel->"Out[2]=",
 CellID->139]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907299533234115765,6",
 CellLabel->"In[3]:=",
 CellID->19821],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{235, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907299533234115765,6",
 CellLabel->"Out[3]=",
 CellID->415403713]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31826],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetAlign",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetAlign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetFill",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetFill"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetSpace"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29348]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19728],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Widget Layout in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"]
}], "Tutorials",
 CellID->1000152870]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WidgetGroup - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 14.3214760}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "WidgetGroup[{content, ...}] specifies custom layout settings for how the \
content widgets are displayed.", "synonyms" -> {"widget group"}, "title" -> 
    "WidgetGroup", "type" -> "Symbol", "uri" -> "GUIKit/ref/WidgetGroup"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "WidgetGroup"->{
  Cell[3439, 109, 342, 10, 70, "Notes",
   CellTags->"WidgetGroup",
   CellID->13132],
  Cell[4625, 157, 1077, 28, 70, "Input",
   CellTags->{"WidgetGroup", "Ex--21907299533234115765,5"},
   CellID->6125],
  Cell[5705, 187, 322, 8, 70, "Output",
   CellTags->{"WidgetGroup", "Ex--21907299533234115765,5"},
   CellID->139]},
 "PrimaryExamplesSection"->{
  Cell[3818, 124, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->264115877]},
 "Ex--21907299533234115765,5"->{
  Cell[4625, 157, 1077, 28, 70, "Input",
   CellTags->{"WidgetGroup", "Ex--21907299533234115765,5"},
   CellID->6125],
  Cell[5705, 187, 322, 8, 70, "Output",
   CellTags->{"WidgetGroup", "Ex--21907299533234115765,5"},
   CellID->139]},
 "Ex--21907299533234115765,6"->{
  Cell[6064, 200, 148, 4, 70, "Input",
   CellTags->"Ex--21907299533234115765,6",
   CellID->19821],
  Cell[6215, 206, 9378, 158, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907299533234115765,6",
   CellID->415403713]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"WidgetGroup", 19139, 486},
 {"PrimaryExamplesSection", 19492, 496},
 {"Ex--21907299533234115765,5", 19645, 500},
 {"Ex--21907299533234115765,6", 19915, 507}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1728, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2351, 68, 49, 1, 70, "ObjectName",
 CellID->13910],
Cell[2403, 71, 521, 16, 70, "Usage",
 CellID->18361]
}, Open  ]],
Cell[CellGroupData[{
Cell[2961, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3439, 109, 342, 10, 70, "Notes",
 CellTags->"WidgetGroup",
 CellID->13132]
}, Closed]],
Cell[CellGroupData[{
Cell[3818, 124, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->264115877],
Cell[CellGroupData[{
Cell[4203, 138, 148, 5, 70, "ExampleSection",
 CellID->209028482],
Cell[4354, 145, 129, 3, 70, "Input",
 CellID->160911545],
Cell[4486, 150, 114, 3, 70, "ExampleText",
 CellID->18944],
Cell[CellGroupData[{
Cell[4625, 157, 1077, 28, 70, "Input",
 CellTags->{"WidgetGroup", "Ex--21907299533234115765,5"},
 CellID->6125],
Cell[5705, 187, 322, 8, 70, "Output",
 CellTags->{"WidgetGroup", "Ex--21907299533234115765,5"},
 CellID->139]
}, Open  ]],
Cell[CellGroupData[{
Cell[6064, 200, 148, 4, 70, "Input",
 CellTags->"Ex--21907299533234115765,6",
 CellID->19821],
Cell[6215, 206, 9378, 158, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907299533234115765,6",
 CellID->415403713]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15654, 371, 311, 9, 70, "SeeAlsoSection",
 CellID->31826],
Cell[15968, 382, 981, 35, 70, "SeeAlso",
 CellID->29348]
}, Open  ]],
Cell[CellGroupData[{
Cell[16986, 422, 314, 9, 70, "TutorialsSection",
 CellID->19728],
Cell[17303, 433, 273, 9, 70, "Tutorials",
 CellID->341631938],
Cell[17579, 444, 449, 12, 70, "Tutorials",
 CellID->1000152870]
}, Open  ]],
Cell[18043, 459, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

