(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31491,        768]
NotebookOptionsPosition[     27066,        628]
NotebookOutlinePosition[     29575,        699]
CellTagsIndexPosition[     29302,        690]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"], 
          "Widget Layout in GUIKit User Guide" :> 
          Documentation`HelpLookup[
           "paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"GUIKit User Guide\"\>", 
       2->"\<\"Widget Layout in GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "WidgetAlign" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetAlign"], 
          "WidgetFill" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetFill"], 
          "WidgetGroup" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetGroup"], 
          "WidgetSpace" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/WidgetSpace"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"WidgetAlign\"\>", 3->"\<\"WidgetFill\"\>", 
       4->"\<\"WidgetGroup\"\>", 
       5->"\<\"WidgetSpace\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WidgetSpace", "ObjectName",
 CellID->11427],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"WidgetSpace", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]is a widget layout placeholder used when spacing is \
needed between widgets."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29355]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->103223595],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->96541690],

Cell[TextData[{
 "Without ",
 Cell[BoxData["WidgetSpace"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", " ", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "->", "\"\<a\>\""}], "}"}]}], "]"}], ",", 
       " ", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "->", "\"\<b\>\""}], "}"}]}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"Ex--21907299533234115765,111",
 CellLabel->"In[2]:=",
 CellID->27843],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject45641946365953, 
   JLink`Objects`JavaObject74957748961281]]], "Output",
 CellTags->"Ex--21907299533234115765,111",
 CellLabel->"Out[2]=",
 CellID->29557]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907299533234115765,112",
 CellLabel->"In[3]:=",
 CellID->7857],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907299533234115765,112",
 CellLabel->"Out[3]=",
 CellID->290671903]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["WidgetSpace"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", " ", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "->", "\"\<a\>\""}], "}"}]}], "]"}], ",", 
       " ", "\[IndentingNewLine]", 
       RowBox[{"WidgetSpace", "[", "20", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<Button\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\"\<text\>\"", "->", "\"\<b\>\""}], "}"}]}], "]"}]}], 
      "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"Ex--21907299533234115765,113",
 CellLabel->"In[4]:=",
 CellID->24149],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject230762083254273, 
   JLink`Objects`JavaObject198578232360961]]], "Output",
 CellTags->"Ex--21907299533234115765,113",
 CellLabel->"Out[4]=",
 CellID->18190]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907299533234115765,114",
 CellLabel->"In[5]:=",
 CellID->3946],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907299533234115765,114",
 CellLabel->"Out[5]=",
 CellID->201319922]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->603],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetAlign",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetAlign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetFill",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetFill"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetGroup"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WidgetSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetSpace"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31688]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25560],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->341631938],

Cell[TextData[{
 ButtonBox["Widget Layout in ",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"],
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/DefinitionBuildingBlocks#4183354"]
}], "Tutorials",
 CellID->1000152870]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WidgetSpace - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 18.6650036}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Symbol", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "WidgetSpace[] is a widget layout placeholder used when spacing is needed \
between widgets.", "synonyms" -> {"widget space"}, "title" -> "WidgetSpace", 
    "type" -> "Symbol", "uri" -> "GUIKit/ref/WidgetSpace"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2977, 91, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "Ex--21907299533234115765,111"->{
  Cell[3777, 126, 756, 20, 70, "Input",
   CellTags->"Ex--21907299533234115765,111",
   CellID->27843],
  Cell[4536, 148, 307, 8, 70, "Output",
   CellTags->"Ex--21907299533234115765,111",
   CellID->29557]},
 "Ex--21907299533234115765,112"->{
  Cell[4880, 161, 149, 4, 70, "Input",
   CellTags->"Ex--21907299533234115765,112",
   CellID->7857],
  Cell[5032, 167, 8884, 150, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907299533234115765,112",
   CellID->290671903]},
 "Ex--21907299533234115765,113"->{
  Cell[14069, 329, 833, 21, 70, "Input",
   CellTags->"Ex--21907299533234115765,113",
   CellID->24149],
  Cell[14905, 352, 309, 8, 70, "Output",
   CellTags->"Ex--21907299533234115765,113",
   CellID->18190]},
 "Ex--21907299533234115765,114"->{
  Cell[15251, 365, 149, 4, 70, "Input",
   CellTags->"Ex--21907299533234115765,114",
   CellID->3946],
  Cell[15403, 371, 8930, 151, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907299533234115765,114",
   CellID->201319922]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28132, 653},
 {"Ex--21907299533234115765,111", 28278, 657},
 {"Ex--21907299533234115765,112", 28522, 664},
 {"Ex--21907299533234115765,113", 28794, 672},
 {"Ex--21907299533234115765,114", 29040, 679}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1860, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2483, 71, 49, 1, 70, "ObjectName",
 CellID->11427],
Cell[2535, 74, 405, 12, 70, "Usage",
 CellID->29355]
}, Open  ]],
Cell[CellGroupData[{
Cell[2977, 91, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3354, 105, 148, 5, 70, "ExampleSection",
 CellID->103223595],
Cell[3505, 112, 128, 3, 70, "Input",
 CellID->96541690],
Cell[3636, 117, 116, 5, 70, "ExampleText",
 CellID->16990],
Cell[CellGroupData[{
Cell[3777, 126, 756, 20, 70, "Input",
 CellTags->"Ex--21907299533234115765,111",
 CellID->27843],
Cell[4536, 148, 307, 8, 70, "Output",
 CellTags->"Ex--21907299533234115765,111",
 CellID->29557]
}, Open  ]],
Cell[CellGroupData[{
Cell[4880, 161, 149, 4, 70, "Input",
 CellTags->"Ex--21907299533234115765,112",
 CellID->7857],
Cell[5032, 167, 8884, 150, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907299533234115765,112",
 CellID->290671903]
}, Open  ]],
Cell[13931, 320, 113, 5, 70, "ExampleText",
 CellID->11875],
Cell[CellGroupData[{
Cell[14069, 329, 833, 21, 70, "Input",
 CellTags->"Ex--21907299533234115765,113",
 CellID->24149],
Cell[14905, 352, 309, 8, 70, "Output",
 CellTags->"Ex--21907299533234115765,113",
 CellID->18190]
}, Open  ]],
Cell[CellGroupData[{
Cell[15251, 365, 149, 4, 70, "Input",
 CellTags->"Ex--21907299533234115765,114",
 CellID->3946],
Cell[15403, 371, 8930, 151, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907299533234115765,114",
 CellID->201319922]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24394, 529, 309, 9, 70, "SeeAlsoSection",
 CellID->603],
Cell[24706, 540, 1239, 44, 70, "SeeAlso",
 CellID->31688]
}, Open  ]],
Cell[CellGroupData[{
Cell[25982, 589, 314, 9, 70, "TutorialsSection",
 CellID->25560],
Cell[26299, 600, 273, 9, 70, "Tutorials",
 CellID->341631938],
Cell[26575, 611, 449, 12, 70, "Tutorials",
 CellID->1000152870]
}, Open  ]],
Cell[27039, 626, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

