(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19255,        516]
NotebookOptionsPosition[     15564,        400]
NotebookOutlinePosition[     17741,        462]
CellTagsIndexPosition[     17539,        454]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "Button" :> 
          Documentation`HelpLookup["paclet:ref/Button"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"Button\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"Button\"", "ObjectName",
 CellID->24161],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<Button\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a button."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21197]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following properties are available:", "Notes",
 CellID->8595],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", "\"\<\>\"", Cell[
    "text label", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"enabled\", \"TI\"]\)\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the button is enabled", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"icon\", \"TI\"]\)\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "a ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Widget", "[", "\"\<Icon\>\"", "]"}], TraditionalForm]], 
      "InlineFormula"],
     " to display"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2125],

Cell["The following event is available: ", "Notes",
 CellID->5485],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"action\", \"TI\"]\)\>\"", Cell[
    "the event triggered when the button is clicked", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->15062]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->499242618],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->302716915],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->95020687],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Button\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<text\>\"", " ", "\[Rule]", " ", "\"\<Submit\>\""}], 
       "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"Button", "Ex--21907280849161310363,29"},
 CellLabel->"In[2]:=",
 CellID->7475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Button", "Ex--21907280849161310363,30"},
 CellLabel->"In[3]:=",
 CellID->28815],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1Wgd4VMe1vtpVAwyxKQJMlUFIlgVGQnREEyqogIQkQCAJBKgimoTpmMSB
EIxJIOA4OHYCn8uLbcAhwcZgwgu4voADBhswIKuudtXLancliv93zsy9q1VL
eO+L7/fNnXJnzpz5z5kzZ2ZudOr6zLRVqeuzlqcODctNXZuZtTxvaOiaXCrS
OymKspXCxKEKp0FJ7aWH0vswlF4vcVA2ibeiOEPxOAFl8BE1HHXjhJ5TLpxy
hTJIZPklU0dbpeSHozq18uCj3MLhg6udlF79qqYea92Ws0eZHcHGG5yDMuD3
TiqfRKH/Fbj7f4fuYbfxeHwBus7+jsbkPOMW0Zia7w4l6C6n+BWU76pmg/K1
sqmyTMcpvVZZplzbtZD12pJqTzQoX9e6mSDFowi6C2X8VSh+53g07UfRc54B
Htk1cE/Ip1G4za1YAyW8XtHLliPPM8SK1qyrvZnaBNUVt1FbXQBzvRFWSzVs
1lo0WesC0WSrC8C9e1Y9pxQ3ejeguamB4npq8D13IrtwIO8uyLsFtJCvKPsG
VeW3sP3we/BauHMllCnriVjf6OeR89JbsDRWUo81kthUJna0DTFHXg1FV5Cx
+wi8o3chevuFHGS9UKO4iuzKvW8IYnauBh/R6LhKpvxv2emUfH+ZOViDPcdL
CUlmxlxf5tC2hQmt8XcOjS/xIHSisR6VlQZUiVCmpIt3F1FWbiriGiJQddTX
FKujzH/UDvYeL81GXV0FIVFbY+Is9r5vENTqaopaMGsZqntnxPCr98vwqxMG
plfJ9GrLRdE+O71Cdfj5j0bvwEkjhbIRqK+vcma7oOeUTlgIF05yyjFWxDed
SDrbP6oV2harsWgiuiBOiHGt1zYsC4l1rjUay4dOmXDoryYvolfN00P0US1y
ujZlispTtRyQXits+dBRZe67hajjdy32VqvV1VXhZWKHw/9rLL/7qIJCuS8a
GjRWKKUy+2hlOlHmbi9Ty9vG3mo1Fsth2WtrllmfBz0Cy699XIHXz1X6wGyu
UXWBUmQLuDNK2YOWl4xzHX2rMtnOvVU7h+9a7K1W43G8/nEl9V/ZhvFWWLt2
xrgOR85XjSBitYJrZ05xbdFTrT2oefvIatlEq3VUzRGlUqNcHds4xt6iEnNd
g6PnqylU/SuuO4f7rQvVePNitRcaG+tUACklcs7i7e5YJoKWV2N1KK3bKx2U
SZpiqkrCPJa3PqnBWxdrHoX5W+2Yf+ezWvzp8zovWCz1akeUEjldB2UuHZR1
76BM0nMXTHMXHP4tf46rmcbf8S/rcPyL+hGwWhvEyN05pfZGKZHr1qZMEeLl
MnfB0fEv6nCMQnsDcKStUrZDSIeTlxqyiZhZEGvgLE5ebvhXxDrXlVNfmfHB
P83ZaGqyUjWbzYJT/xRFj0KvvfhOX23ER183ZpP70EzV7t1roqwFH121tKc3
yE6vS7t1ujhf0jt73ULBigcPHijZ9L5PVuPsNVnG39l/aVm92q+trTkkN2QN
zn1jJbWhpHCAHEZnb+zWYeOtL/+J/Q1lFf5phOp7bP3tu6gwfvtomBsKr6Cs
+GtBqI1DlPHLIzCVXhehI+9K5Sjwdot3Rb0yQQJKGY+iu/8IQP6NT/ScotoM
H/PMNez8TabRer5jp0na++QVKi2UIbKQZn3wFdJap+ArcJp1lQNJRhdyVc9J
HZcrevmFa1DOg3O9uVkfzg9WCQh6o2gEARe4tz6/kSNo3RuN8TLXF93oZDdK
BDniTtF3mUYM1YguobiYDSe9qSyuiFNaLqbYl6tQ/6GFnGeakSUi56qVBRMX
00WQbjG/p96WZTI3vVXZ1Nvc26TvWHwTbnEKythbMs0x8z6hgkfGMO6V7rg2
sMhKyXJ8CRNZWMYQL6SyJDLkS8keLmnQQ59W7wx9ZiN1qs+8B6dsEagmv4mR
tIdwWtHMQaGBLW3m1wORYgiTmjkr48QmKItoWi2kqbrAKnq0cY8LaGYkNEKJ
beRYxwlnTjGnsWRzomplLOtwuygz4RVW68RDc3Icm1vrsS2kMSxu0GJqqV/K
dlafauUR8Xgo55rdTK+cB27Qr7xPcs3+oQ9/0fHQ6LNL+n2k/94CepSfiLce
huqHooy+KZ3Xc5P1DpvhkmpjQAQMLik2pP/WrDwu6rjDUPUA6Qfr4TK3gQfG
4yJdqGgrNW1kxa1G5rTUwqNhdUxrViVE4+HhUJnbmoe0y8p96AzXdT/Qx1zQ
azX68hiVPsj4gxVXb9fDZ/4n6D7tQzwx62/oGfIxeoecQc9ZZ9Ar5Bx6hf4N
j4ecR/eQv6NryAW4z/oErjP+Dv20v8Np2ifE0HkMmXMGV25VMz1F4Kf4/8dp
M7KsaqxM6YctqLlxFR/M8sHbz3THsdFP4D3/nngnoDfeGd0TxwJ64TiFE/6P
4+To7vjLqK44NdIdJ31dcdJHj1PeTjgxXMGxKUNQ8c0Vgb5QPg19ibyiQe/c
Fnod407FUo/uSdRzHgjAdQy4K9zW/6Czo96XUdepqBtqHsInpQC95hZgQEIB
PBcVwyupCCOSCzGc4mEpxfCkMJjCgCW0X04xoFdyGXosNqDLwjI4x5fBaQ7x
EnKd0PlIaJGG+o9A24466/JXs31weUIvXJ46AFdmeeJKmBeFEbgSOhxXw4bh
61BPXAsZjG9DBuDbmR64Mb0Xvg3qgRsTu+Dbsc74erQTLvoqeI+QF7T/Bert
FV5VdqHqPZCQkCDAdWZwPVRw+ekRU42Bi2vhs7wOz2bWYczKegTm1MM/pwH+
qxowak0DfNc2wGutGUPWmNF/VSN6ZTeie3oj3JaaoVtEtiaaup10xgHcH4s2
QavSvjW+B+4ED0R+lA++n/csChLGoHBBIAoT/FE43x9F80ehOMEXpXFeKI0Z
AkNUfxjCe8EQ3B2lU91QOEGHr59V8O4wRaMdZWYL3RpcsbjRYjHkWmtrskRa
EwIXfzx6xBWlpXxkUHz7DowmEwdS+MrKSnrTZ8YcTjk/cOjvgE/v+WZ4LWuE
/8pGTFzXiKD1FgpWTH7OgokbLBi/0YKATVb4bbLBa6MNQzbY0D/XhidWN6Fb
pg0uSxuhiyMlDDqvjYGMq/+PQdu+LvGTP6U3CiO9UBTvj5LFE1GaEoTSJRRS
JsOQMpHCeJQlB8C42A+mBV4ojx+C8pj+KI94AqZZ3VAa5IIbY3R4f4STpN3W
kPt/bseefMdhN9Q1yijX2yV2Sy7AzcrKopGTAHQC9664c+cOPtv7kohJBkIi
nOaY89yIhKDjNVlA1lesxy6Cl36JZoyi1W4SYTZzo4UmFjPYBb7bmjB8SxMG
bWxCn7wm9MhpQpfljXCZb4Ru2n876GfHdLqJGgM7amdf7/n5fno/FMWOQknS
JJQumwnLhQ9EeVlaMIUZKFsRBOOyCTAtDUB5ki8qEoeL77aPjqI8vAcM07vg
5jgX/Nlbx8U6BpbVeoZJQuv3pR1a5xZoGfjYSh1jyz4gocsgsVILZIl7BpBS
+J/MDJQvjsXZs2cl0BRfOHRAgGs2m7mdXF91DGo/4dlIRAYnmzFuNaFB2jd7
awuyI7eTBhKygwnZvoTsE6tswgJ0SzSKBU5DtpnQ64COKIt43obw560I2WHF
jJ+SllM8doetFW1+OqAtPSzylvgpIHNcvHCcQN6QMVsvvrugLDMExowZMK6Y
DNOysahIGanIb12FUpfN6o6bk7vh5DOukqSmzIw6mw3hmQjQXVRbwqCXUr8V
7D8qEvnHBOp5eXkCTUb7g8hoXP3ic9xMXIDirFgUrEvGpexFuDBsGE799a9S
OM44dPCgXF5l6MsS1LH7qELvtcyMoLxGhBNcc35qbYF+mw0jNjdhKBmA/nk2
eKyxoVdWIx5PNqHrLLtSE50+HdERZXN+ZkUkpcMI8pkUplAYx9A70OanE9oJ
9YrEjA1KCRkSQ0Y4ynLmoGxVjIRYD2PmTBjTphD041TYXYU9MUV5oDSsF25N
I9dlZFdV32eYxB6lWO5RfE87mhKGnvdeAnpDi/tOJoWhv3jxoqrw3fH54iSc
9R2BxqRQVMUGw/h2Dk4vDcIrIwYJvA/s/zXO7tgoYsadnRyBVT/hPUvAniFd
m7WJwCJQ5r1gRdzPrYilOPpnpK9UFkwhiPR27DYrRm4hwAgsz/U2DFhnQ7/V
FGg19FhixE/C7PNgoVkZ3CFtfh6FtrBO7WmzKMTOgZ+iuc+gdPkslK2cA+Oa
eRTiULY6VoL/OAkjCNrzg6UepnhPmGIGwBjdD6UR/XCTvJm/+P9EkuU5ML2o
Zdfoe1oTSF8oQ7+Umy8WSKyh1X6KBXL50mXkn/sY35w7h8/nhqFkeRAsb65E
2aFUVC0bjzsT/PA//t44Gz4WdfERuH3jBv5w5I9i56JjOfTn5VoVRgAthZHb
LYgnIczfaUPCz20CuGjS3vDtpL0E1JQtVgTSsjhygxUjaEZ4kiAGrrFi4CoK
BNjA1DL0DLdrb6e0+XkU2vx0QjuWj/P5KY4PgCErEsa18TCumw/T2gQhlLKc
aDG9SVmNCSNgnOeJsjkDURY9ECVRA3EjdCD+PKanFAJPBxYAb3LZ6MtpIVxH
j/ZSYKukSoKlsGVxIoomksMcPA6VSXPQcDgNzf/YiYZjz6F0ezy+ip0Cwx/W
o2rLPLz24h5c/vRTvPb6a7SBTK7iucgCZXILKwktevO0r1CBG0+WPJZMyIJd
NiT+wibieZSPJs0N20rWfDNZc/JVAsl/8csl4EgYTxFgg1daMSTbCs9sMzyX
lcFjtt0HItpDO6QthPIItPnpgDaLRODDT0nieBhXxcKUuwCmvEQSzAKaISSU
7GgyYWFyptByvMAPhrgRMMQ8BUP0YApDUDzHEzdme+L9sR6SLFsk7STi6atQ
RhzTZEPq++Q5KOOuyeMLPhyhjYeSSFMqqVzIRnNsqtcvR9WLSbAcWCzkcm3/
KpxOj8MXGZGwndkA0wtzcXTPbrz55pvYvGUzi0YTDIso0eThIJQpuY1I3G1F
8os2JO+R4MURcHMYuC0WzCCzM4lAC8wl4NZY4J1jwTACbGgWAZhpgVcWOfUE
XP9IR6F0TJufR6HNTye0o0vUmVKSTIvE+kSYNibDtCEZxtxElJHpMqyco82U
0lhvlM4dRjNkKEqinyJL54VvI7zw/vj+UhjaURBjzsKQM6XHdpJGv9bSiLir
zhaDkIi2dguX88yHuLlzHnlnE4UEvsxJwGc7N+L04mnEWDjyF02CYawvCn/3
Ks8UVRrlOiYkzpZYGgYVsdDNFix9yYZl+5qwdK8Ni3fbEP+CDXPIpoSRPZlB
aE1aR4iRuo9caYFPlgXDMyx4Kp3QovjpzAY8vbwUAyL/ZpeGQV1E2tLm51Fo
89MBbXlCF1ko0oa0UJi2LIVp2zIZr18M4+p4bRFhD9fxKY4ejuLIpyj2QmHM
0/gm6mmcmDigtVRYImytxBQRQnFvL5T4Ekeh6MRG7DHcGeWNj8b54XLASHwZ
NUFYLF439g70EPK4tSAUH75+GGWFBfjTKwf1dln0bSOLzN80IftgE9J+3YQU
0uAFtI7EkPZGkDkJpu1VEOHFDuqzhNczhJcP4eRNsvAl7fUj7fVdVoqBUY6y
cOmItrpl6N5RO3kQ6YBz+c8yUfHzbJQ/n0ban6JorlNpajBKk4NQslBznbqR
/fFGcQwpX6wfrkf74vjEgS0ga2ovQbarvodEefwlWkauSZT5tJZRXmQUqp+Q
kADTO28I9f80L1csCmx4eKHQVP7tsX7IP/WBMFrqUs0uk1HA3M8BZrbQq19p
wtrDEo5lLzVhMRmh+J/aEE2WO2yjFdPJQEwiAxG4qhGjafkdSc6lH8E9ksIo
gstvuQGDos7Zl1MN5ja0VZgf66hdK5jZslfuXo3KF9cy1NrewJAZjdIVYbQB
nk6b4Ukonh+oaN+K541EwbxRhLIfjk8apLEy7hqbXL8vJcrD31YcdLnfe7z9
hTKNUb4lz8lZnyXKmi7zTuvrEydQvWAuzDuXw7wpApURAbixdRPuZqbieOAE
3L9/H80WS+cgs3+y+Y9N2Ha0CesIjIwD0gYk7pLWnoEOpeVxRh4D3YgJpNOB
OY0IyJHHCqOz6uFHOukAsl2X29C2b387aNcKZPZrqg5sRtXBbQT0OtguX5Tl
ZMmNq+JUtEMJ7RkC7ZLECeK7+ePjKE7wR0HcaFyfY0e7HdgOKt3l34HN66S4
8TUT+5dmh6KxXO5xGz87j1I/b5FmhKtop8ZHP4y43P92BPfCX1ix591m7Dve
jB1vSMhZt1f8yoaUF+UiG0+wxZLLGLnNgggK7N9PI5MyKZehJxOQWoJ+4R87
wO33Y9BuJRLT+oWoeX0Pao/uQ/XLO4RYhKnZvgKmTSkwsvezJp42bLEknkgK
EWLvULp0mrDxhfMDcS3KF8fG9XtEkQRckLdHYTfJytwmMAsolAqR8AmPFImL
sDSaCDiUR4VTKQmBqHNdFiMF7mthWR9GSycub6Q40vbb8MqpZrx6+p6AbsuR
JuS+2oRVLzcJK5z2a1oVCb7UfTbhq7DPMo+8+ygyH8E0K8avboDPkhL0CbUf
TsYVqeL4D9OWiqmKo3xHGureeQX1x14VYqk6sAWVe3NRsWuVWAVMtAKU04pb
vjVV+kHr2QeaB0N2FIklGEXkuF6L8MG7Y/qo4hh/qRNz5NxKHLqQqzzG21yZ
JMIIkzMpfuQw61kAlCz/9BMxC6QQOhFFXwcpbHitCfvfb8ahvzRj13814TnK
s3HO/I0N6fslSkvIP0lhu/RL2lvtsiKGFHn2Nqm8ASsbMCypBKOTPoOh6r4q
hR+Ndkyh8qSgXbVvA2rf2I+6tw+h5tVdqNz3HCpocaggCZTvSBcSMG1eQiEF
pudoguTOp+1BDE2O2WJiFCYE4GroMHwYORqGintyZWVTxGJ46gyLwUEKw9+W
UpjxDzhFtZICzwslxci8LSt3hVNapUjxhWMqbeJSyvkrB73dJvVumQldkH6o
AncND5FH2sl+YMJOuT0KJ0+cD9jISBDtqXkWHSavo9eYnEbFFaNpt+qzohFD
kmsRmFGIa3cakH6wXILfhZP/Z6JPdEZUvRIuRPoBI+4V3SVlzyPlXko7rgS5
20oPJzdnJtscPrxZMlVHZmeyjhbiMcRqMS0IhdE+uBsyBFfjAlF76xrSdxfo
xCGzXsIq8dbUXifO/p01tKUJirvNRr2AWzCey8o1lNMqqWZGtY5TfLhHX1qQ
L2enXi4HHuLGWA+XRQak/7YShur76qWmm8hzudjbUeiwziGqM79Erk+EiMs8
iQgrpr3O7gK4TL7cokw8ON/Tmontc0T8dyVK2YGL/Epcuqsjc3YcGY9Gz+Oi
0qwGMUI5WHnTLUMf3kA+zUN0bZnc0ieUV+RxRWLK6PjOn2//7zrzMstH0jf5
Z4TrjBcvvWzrtUDGSKedl0p+xeBIFsyvcxtWBUcZ1Xrocuq7QL+abRAl1ftq
vv2m90y+lafU8irqUJ9aKQSkSy4XgRkX00LPnOuZ9RbOFfG7gkQr4pYiOFec
pa8QfF3i3O89cYkhJqqdVVZZBlaDkToWbK22QL/mHt93Qsl7yOzlsuDUvIi1
NH3hNHeaxzfmXO667ge+MFV8+Gtvvk7ie9VcebmkNnIW9buIXw/4ekpAkVYv
DvX5nFP8VMCxuOLnU0t3mW8RrOMvDbxz16mHNkniNIcVkAcfdFdRR65T3V2e
LYypa0ajGK5kv9cWWmSefIFennt4S+K9D3hmvwj0ld56+B9CsEzRR1Gm45Qe
w3ZpLait2l6+6Yu9TFB24T70sje3NQ+FNprFboWZUznVyyWPGOVfGYhNQpOb
KIJDApPJcnf+L4G50mHSAXoFvYwumPYK+nCqtz3lwikaNyW5nmNMAqCUK9PR
iVE4czd87y1V3v9zuUeQ7rL4veUrgR+zJvRM/C5DjqdY+3mvJS29PbZbGV5a
k4S1EWdt5eKIrTefTfbmLayzdsTD15bqKZxeFWisSPIZBp9sRRrt+yRx1ybK
KmU6Ukzo0FL+9UZs8Y1qqJQXHdOuuaizwOl/AdUPCmA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Button", "Ex--21907280849161310363,30"},
 CellLabel->"Out[3]=",
 CellID->287877627]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8079],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8709]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29229],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->27560]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"Button\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 21.8835888}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"Button\"Widget[\"Button\"] represents a button.", 
    "synonyms" -> {}, "title" -> "Button", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/Button"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4374, 146, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->499242618]},
 "Button"->{
  Cell[5041, 172, 423, 11, 70, "Input",
   CellTags->{"Button", "Ex--21907280849161310363,29"},
   CellID->7475],
  Cell[5489, 187, 161, 4, 70, "Input",
   CellTags->{"Button", "Ex--21907280849161310363,30"},
   CellID->28815],
  Cell[5653, 193, 8423, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"Button", "Ex--21907280849161310363,30"},
   CellID->287877627]},
 "Ex--21907280849161310363,29"->{
  Cell[5041, 172, 423, 11, 70, "Input",
   CellTags->{"Button", "Ex--21907280849161310363,29"},
   CellID->7475]},
 "Ex--21907280849161310363,30"->{
  Cell[5489, 187, 161, 4, 70, "Input",
   CellTags->{"Button", "Ex--21907280849161310363,30"},
   CellID->28815],
  Cell[5653, 193, 8423, 142, 70, "Output",
   Evaluatable->False,
   CellTags->{"Button", "Ex--21907280849161310363,30"},
   CellID->287877627]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16566, 424},
 {"Button", 16699, 428},
 {"Ex--21907280849161310363,29", 17107, 439},
 {"Ex--21907280849161310363,30", 17256, 443}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1237, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1860, 59, 48, 1, 70, "ObjectName",
 CellID->24161],
Cell[1911, 62, 361, 11, 70, "Usage",
 CellID->21197]
}, Open  ]],
Cell[CellGroupData[{
Cell[2309, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2787, 95, 71, 1, 70, "Notes",
 CellID->8595],
Cell[2861, 98, 998, 28, 70, "3ColumnTableMod",
 CellID->2125],
Cell[3862, 128, 66, 1, 70, "Notes",
 CellID->5485],
Cell[3931, 131, 406, 10, 70, "2ColumnTableMod",
 CellID->15062]
}, Closed]],
Cell[CellGroupData[{
Cell[4374, 146, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->499242618],
Cell[CellGroupData[{
Cell[4759, 160, 148, 5, 70, "ExampleSection",
 CellID->302716915],
Cell[4910, 167, 128, 3, 70, "Input",
 CellID->95020687],
Cell[5041, 172, 423, 11, 70, "Input",
 CellTags->{"Button", "Ex--21907280849161310363,29"},
 CellID->7475],
Cell[CellGroupData[{
Cell[5489, 187, 161, 4, 70, "Input",
 CellTags->{"Button", "Ex--21907280849161310363,30"},
 CellID->28815],
Cell[5653, 193, 8423, 142, 70, "Output",
 Evaluatable->False,
 CellTags->{"Button", "Ex--21907280849161310363,30"},
 CellID->287877627]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14137, 342, 310, 9, 70, "SeeAlsoSection",
 CellID->8079],
Cell[14450, 353, 449, 17, 70, "SeeAlso",
 CellID->8709]
}, Open  ]],
Cell[CellGroupData[{
Cell[14936, 375, 314, 9, 70, "TutorialsSection",
 CellID->29229],
Cell[15253, 386, 269, 9, 70, "Tutorials",
 CellID->27560]
}, Open  ]],
Cell[15537, 398, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

