(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19752,        523]
NotebookOptionsPosition[     16019,        407]
NotebookOutlinePosition[     18228,        469]
CellTagsIndexPosition[     18026,        461]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "PopupMenu" :> 
          Documentation`HelpLookup["paclet:ref/PopupMenu"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"PopupMenu\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"ComboBox\"", "ObjectName",
 CellID->19764],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<ComboBox\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a combo box."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23713]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following properties are available:", "Notes",
 CellID->24013],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"items\", \"TI\"]\)\>\"", 
    RowBox[{"{", "}"}], Cell["the contents of the combo box", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"selectedItem\", \"TI\"]\)\>\"", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell[
    "the item to display as selected", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"editable\", \"TI\"]\)\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether the combo box can be edited", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"autocomplete\", \"TI\"]\)\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether typed input is automatically completed", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->12452],

Cell["The following event is available: ", "Notes",
 CellID->18170],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"action\", \"TI\"]\)\>\"", Cell[TextData[{
     "the event ",
     StyleBox[
     "triggered when there is a change in the current selection", "Text"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->24978]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->316600881],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->627310225],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->243259936],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<ComboBox\>\"", ",", " ", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"\"\<items\>\"", "\[Rule]", 
        RowBox[{"Script", "[", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Choice A\>\"", ",", " ", "\"\<Choice B\>\"", ",", " ", 
           "\"\<Choice C\>\"", ",", "  ", "\"\<Choice D\>\"", ",", "  ", 
           "\"\<Choice E\>\""}], "}"}], "]"}]}], "\[IndentingNewLine]", 
       "}"}]}], "]"}], " ", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"ComboBox", "Ex--21907296125549291768,2"},
 CellLabel->"In[2]:=",
 CellID->22105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"ComboBox", "Ex--21907296125549291768,5"},
 CellLabel->"In[3]:=",
 CellID->20526],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"ComboBox", "Ex--21907296125549291768,5"},
 CellLabel->"Out[3]=",
 CellID->215884553]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10377],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22837]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6766],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"ComboBox\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 25.4146580}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"ComboBox\"Widget[\"ComboBox\"] represents a combo box.", 
    "synonyms" -> {"combo box"}, "title" -> "ComboBox", "type" -> "Widget", 
    "uri" -> "GUIKit/widget/ComboBox"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4632, 149, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->316600881]},
 "ComboBox"->{
  Cell[5300, 175, 728, 17, 70, "Input",
   CellTags->{"ComboBox", "Ex--21907296125549291768,2"},
   CellID->22105],
  Cell[6053, 196, 162, 4, 70, "Input",
   CellTags->{"ComboBox", "Ex--21907296125549291768,5"},
   CellID->20526],
  Cell[6218, 202, 8306, 140, 70, "Output",
   Evaluatable->False,
   CellTags->{"ComboBox", "Ex--21907296125549291768,5"},
   CellID->215884553]},
 "Ex--21907296125549291768,2"->{
  Cell[5300, 175, 728, 17, 70, "Input",
   CellTags->{"ComboBox", "Ex--21907296125549291768,2"},
   CellID->22105]},
 "Ex--21907296125549291768,5"->{
  Cell[6053, 196, 162, 4, 70, "Input",
   CellTags->{"ComboBox", "Ex--21907296125549291768,5"},
   CellID->20526],
  Cell[6218, 202, 8306, 140, 70, "Output",
   Evaluatable->False,
   CellTags->{"ComboBox", "Ex--21907296125549291768,5"},
   CellID->215884553]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17045, 431},
 {"ComboBox", 17180, 435},
 {"Ex--21907296125549291768,2", 17591, 446},
 {"Ex--21907296125549291768,5", 17741, 450}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1246, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1869, 59, 50, 1, 70, "ObjectName",
 CellID->19764],
Cell[1922, 62, 366, 11, 70, "Usage",
 CellID->23713]
}, Open  ]],
Cell[CellGroupData[{
Cell[2325, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2803, 95, 72, 1, 70, "Notes",
 CellID->24013],
Cell[2878, 98, 1166, 28, 70, "3ColumnTableMod",
 CellID->12452],
Cell[4047, 128, 67, 1, 70, "Notes",
 CellID->18170],
Cell[4117, 131, 478, 13, 70, "2ColumnTableMod",
 CellID->24978]
}, Closed]],
Cell[CellGroupData[{
Cell[4632, 149, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->316600881],
Cell[CellGroupData[{
Cell[5017, 163, 148, 5, 70, "ExampleSection",
 CellID->627310225],
Cell[5168, 170, 129, 3, 70, "Input",
 CellID->243259936],
Cell[5300, 175, 728, 17, 70, "Input",
 CellTags->{"ComboBox", "Ex--21907296125549291768,2"},
 CellID->22105],
Cell[CellGroupData[{
Cell[6053, 196, 162, 4, 70, "Input",
 CellTags->{"ComboBox", "Ex--21907296125549291768,5"},
 CellID->20526],
Cell[6218, 202, 8306, 140, 70, "Output",
 Evaluatable->False,
 CellTags->{"ComboBox", "Ex--21907296125549291768,5"},
 CellID->215884553]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14585, 349, 311, 9, 70, "SeeAlsoSection",
 CellID->10377],
Cell[14899, 360, 456, 17, 70, "SeeAlso",
 CellID->22837]
}, Open  ]],
Cell[CellGroupData[{
Cell[15392, 382, 313, 9, 70, "TutorialsSection",
 CellID->6766],
Cell[15708, 393, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[15992, 405, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

