(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47514,        992]
NotebookOptionsPosition[     43982,        877]
NotebookOutlinePosition[     45855,        931]
CellTagsIndexPosition[     45680,        924]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], 
          "FileNameSetter" :> 
          Documentation`HelpLookup["paclet:ref/FileNameSetter"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"FileNameSetter\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"FileDialog\" ", "ObjectName",
 CellID->16713],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<FileDialog\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an ",
     StyleBox["Open", "DialogElementName"],
     " or ",
     StyleBox["Save", "DialogElementName"],
     " dialog."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27666]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following properties are available:", "Notes",
 CellID->16030],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"multiSelectionEnabled\", \"TI\"]\)\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether multiple files can be selected", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"fileSelectionMode\", \"TI\"]\)\>\"", "0", Cell["\<\
whether files, directories, or files and directories can be selected\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"selectedFile\", \"TI\"]\)\>\"", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell["the selected file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->10806],

Cell["The following methods are available:", "Notes",
 CellID->27109],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"showOpenDialog\", \"TI\"]\)\>\"", Cell[TextData[StyleBox[
    "requests that the dialog open using the \"open a file\" mode", "Text"]], 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"showSaveDialog\", \"TI\"]\)\>\"", Cell[TextData[StyleBox[
    "requests that the dialog open using the \"save a file\" mode", "Text"]], 
     "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->24290],

Cell[TextData[{
 "You will probably want to pass a widget reference of a window or frame \
(instead of ",
 StyleBox["Null", "Output"],
 ") in the argument call of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"showOpenDialog\", \"TI\"]\)\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"showSaveDialog\", \"TI\"]\)\>\""], "InlineFormula"],
 " so that the modal file dialog will base its position and properties \
relative to this parent window."
}], "Notes",
 CellID->29059]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104670147],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->91999672],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->127300672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"Widget", "[", "\"\<FileDialog\>\"", "]"}], "]"}]}]], "Input",
 CellTags->"Ex--21907296125549291768,7",
 CellLabel->"In[2]:=",
 CellID->17557],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject218673629364225, 
   JLink`Objects`JavaObject364601719914497]]], "Output",
 CellTags->"Ex--21907296125549291768,7",
 CellLabel->"Out[2]=",
 CellID->7435]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907296125549291768,8",
 CellLabel->"In[3]:=",
 CellID->12],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{565, 431},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907296125549291768,8",
 CellLabel->"Out[3]=",
 CellID->518624226]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->606],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->391]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31684],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"FileDialog\"  - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 26.5708488}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"FileDialog\" Widget[\"FileDialog\"] represents an Open or Save \
dialog.", "synonyms" -> {"file dialog"}, "title" -> "FileDialog ", "type" -> 
    "Widget", "uri" -> "GUIKit/widget/FileDialog"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5253, 165, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->104670147]},
 "Ex--21907296125549291768,7"->{
  Cell[5942, 193, 215, 6, 70, "Input",
   CellTags->"Ex--21907296125549291768,7",
   CellID->17557],
  Cell[6160, 201, 306, 8, 70, "Output",
   CellTags->"Ex--21907296125549291768,7",
   CellID->7435]},
 "Ex--21907296125549291768,8"->{
  Cell[6503, 214, 145, 4, 70, "Input",
   CellTags->"Ex--21907296125549291768,8",
   CellID->12],
  Cell[6651, 220, 35829, 592, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907296125549291768,8",
   CellID->518624226]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45036, 902},
 {"Ex--21907296125549291768,7", 45189, 906},
 {"Ex--21907296125549291768,8", 45425, 913}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1272, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1895, 60, 53, 1, 70, "ObjectName",
 CellID->16713],
Cell[1951, 63, 477, 15, 70, "Usage",
 CellID->27666]
}, Open  ]],
Cell[CellGroupData[{
Cell[2465, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2943, 100, 72, 1, 70, "Notes",
 CellID->16030],
Cell[3018, 103, 940, 22, 70, "3ColumnTableMod",
 CellID->10806],
Cell[3961, 127, 69, 1, 70, "Notes",
 CellID->27109],
Cell[4033, 130, 690, 15, 70, "2ColumnTableMod",
 CellID->24290],
Cell[4726, 147, 490, 13, 70, "Notes",
 CellID->29059]
}, Closed]],
Cell[CellGroupData[{
Cell[5253, 165, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104670147],
Cell[CellGroupData[{
Cell[5638, 179, 147, 5, 70, "ExampleSection",
 CellID->91999672],
Cell[5788, 186, 129, 3, 70, "Input",
 CellID->127300672],
Cell[CellGroupData[{
Cell[5942, 193, 215, 6, 70, "Input",
 CellTags->"Ex--21907296125549291768,7",
 CellID->17557],
Cell[6160, 201, 306, 8, 70, "Output",
 CellTags->"Ex--21907296125549291768,7",
 CellID->7435]
}, Open  ]],
Cell[CellGroupData[{
Cell[6503, 214, 145, 4, 70, "Input",
 CellTags->"Ex--21907296125549291768,8",
 CellID->12],
Cell[6651, 220, 35829, 592, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907296125549291768,8",
 CellID->518624226]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42541, 819, 309, 9, 70, "SeeAlsoSection",
 CellID->606],
Cell[42853, 830, 464, 17, 70, "SeeAlso",
 CellID->391]
}, Open  ]],
Cell[CellGroupData[{
Cell[43354, 852, 314, 9, 70, "TutorialsSection",
 CellID->31684],
Cell[43671, 863, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[43955, 875, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

