(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31505,        786]
NotebookOptionsPosition[     26539,        629]
NotebookOutlinePosition[     29378,        710]
CellTagsIndexPosition[     29086,        700]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"Icon\"", "ObjectName",
 CellID->5754],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<Icon\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an icon."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1552]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Many widgets take an ",
 StyleBox["\"icon\"", "Output"],
 " property, such as buttons and menu items, and so a ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<Icon\>\"", "]"}]], "InlineFormula"],
 " instance would be used when setting an icon property on another widget."
}], "Notes",
 CellTags->"Images",
 CellID->850],

Cell["The following properties are available:", "Notes",
 CellID->1516],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"path\", \"TI\"]\)\>\"", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell[
    "path or URL of the icon image in GIF, JPEG, or PNG format", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"data\", \"TI\"]\)\>\"", 
    RowBox[{"image", " ", "data"}], Cell["the image data", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->13226],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"data\", \"TI\"]\)\>\""], "InlineFormula"],
 " property can be given as a ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 " or as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", 
   RowBox[{
    ButtonBox["ExportString",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExportString"], "[", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], ",", 
     StyleBox["format", "TI"], ",", 
     StyleBox["options", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["format", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData["\"\<GIF\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<JPEG\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData["\"\<PNG\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->23486]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57100476],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->52719291],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->342340309],

Cell["Display an icon from the filesystem:", "ExampleText",
 CellID->16710],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Button\>\"", ",", " ", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\"\<text\>\"", "->", "\"\<Stop\>\""}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"\"\<icon\>\"", "\[Rule]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Icon\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
            "\"\<path\>\"", "->", "\"\<Wolfram/Example/Stop16.gif\>\""}], 
            "}"}]}], "]"}]}]}], "\[IndentingNewLine]", "  ", "}"}]}], " ", 
     "]"}], " ", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"Images", "Ex--21907299533234115765,8"},
 CellLabel->"In[2]:=",
 CellID->14508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Images", "Ex--21907299533234115765,9"},
 CellLabel->"In[3]:=",
 CellID->26489],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Images", "Ex--21907299533234115765,9"},
 CellLabel->"Out[3]=",
 CellID->546483412]
}, Open  ]],

Cell[TextData[{
 "Display an icon generated by ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<Button\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"\"\<icon\>\"", "->", 
          RowBox[{"Widget", "[", 
           RowBox[{"\"\<Icon\>\"", ",", 
            RowBox[{"{", 
             RowBox[{"\"\<data\>\"", "->", 
              RowBox[{"Script", "[", 
               RowBox[{"ExportString", "[", 
                RowBox[{
                 RowBox[{"ToBoxes", "[", 
                  RowBox[{"a", "+", 
                   FractionBox["b", 
                    SuperscriptBox["c", "4"]]}], "]"}], ",", "\"\<GIF\>\""}], 
                "]"}], "]"}]}], "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], 
    "]"}], "]"}]}]], "Input",
 CellTags->"Ex--21907299533234115765,10",
 CellLabel->"In[4]:=",
 CellID->18121],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject152855923130369, 
   JLink`Objects`JavaObject517349228675073]]], "Output",
 CellTags->"Ex--21907299533234115765,10",
 CellLabel->"Out[4]=",
 CellID->10106]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907299533234115765,11",
 CellLabel->"In[5]:=",
 CellID->23987],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WglYVcf1v7zHIibaxAUxGhURJQSNIO7ihiyyKAioKKCobIqiYNyNbaq1
xthqNU1Nk1a/LP8mUVNbE6OxppqlaTXVaKJWJayP99jX9x645Pc/Z+a+xwMe
hqbxft/cO3fuzDkzv3PmnDMzNyplbUbqypS1mUtTBoXmpKzOyFyaOygkO4eK
tA6KomymFDpI4Twoa7lpofQ6CKXni5yUDeKuKI5Q3I5BGXBITYddOKPlnBPn
nKE8KV75JnOHW+Xkh8MatfKAw9zC5oOzlZRW/armHm3dll8Pc3dEN17nNyj9
fu+g9pMo9L2ELn7/QbfQm3gsLh9dZ/6HxuQ47QbRmJzXBUrgbc7xLTDPWX0N
zLOUTZZlGs5pLZVlzrldC1mvLan2RAPzNK2bCVI8isDbUMZehuJ7hkfTfhQ9
5ujgtrwaXeLzaBQus8uzoYTVKVrZcvhZhlixNOtqbaY2QVX5TdRU5aOhTg+T
sQpmUw2aTLUBaDLX+uPOHZOWc4oL3evR3FRPzzpq8C0zkSxsyHdpR7689GtU
lt3A1oPvwmv+9hVQJq0lYn2inkPWi2/C2FhBHKtbiA1oS8zFv4WYrvAS0nce
wrCoHYjaei4Lmc9XK87idcXu1wUxQWgy9+qwhY5zOzrF317kHmRj19ESQpI7
01BXattWad3YdkTF317gQWhEYy0qKnSoFKlUGcR3L9DlId5dxdcyQyHXFYka
oq66yO541X763WjPavfREk/U1pb3YdpanoaPcG4wlxFONdUGroLd7+kEh9rq
QhsOhzuWjsoAv3qvFL86pmMeFW5MmfWLprrtpQj1UblWMNeaMtFwj5VrgQph
HitFGzHa4brvuJ5SqSfq6iolV60tV+VRyY2+EhHiaWnQnlvbMdrjduCEAQf+
amBuVQ/kViW4VeIlasCpNTchs+/n9rsPyymVeaK+vupBiGqtEnWU/Kk+kaUx
46Ak8b/zF1rjaOXRZtzaTvENzPvv+T7Zmm+neHRGb9rxsBmRImxjp7h1cm68
+lE5XjtT4YmGhuoBTFmDFh5URk2JE177qIKqVvzvPAZ2LKPv4Sbm3X/Jzeuh
UdYwZScrVm1G5NY5vq3we4AtPnS2kpnWSKQsnBSNHc725oC1NzWiN9U4fLaK
UuXD700LSs7q148//hiWWMtV3B0xdepUW8Px4/dUY52qznY6+UPg6VhJ3jxX
hTfOV3misbH2f5MXE+jC3cKbn1TjzfPVnelQO/faqkOiB4LZoIfGw+sHU24d
xPxQyoF2fIi9Pr/9WQ3+9HmtJ4zGOpUy5agB0RcfOX0vZXt9tqXsbp0BXTrH
w44nsqdmtjz6Cq2x74FdfvDIvg+zH4drW49oj+vRL2px9B91njCZ6jvBlWoR
MeJNjWpxhNIDuD4gLD1+oZ5ZNgiWwi3am8BOFqYNgmk9N8Pxi/V2xNqJiXTi
ywa8/+8GTzQ1mfqqBsLG+dvoEVWgrNlsxIl/izbt51dbn2ZnlDh5uREfftXo
SWuh5r52hucqudFXInLnThNVNuLDy8YH6Y9rO25FeZLb6atGSibcu3dPGUz3
u+5WbEXI78llJMfTV2Q9bsPLt44XFG3nBq3CsnHmaxPJhbJi/WdvKedit/Hm
l/7Eyy1lJf6th7r02vzbd1Cu/6ZjjXUNuNmyhCu4hNKirwShNuvB9F8egqHk
qkgd98jFhhhzZYIEnjIWhbf/5Y+8a59oOUe1GVLuM9ew9m8ijdbjbStN0p0n
LlFpgUwRBYR00CWSsEPQJTjMuMyJpKUJvqzlrIbLFa38wjXozY3fenGz3vw+
QCUg6I2gEfifY269fyNH0JobjfEi1xdsNJKNEn6DGETdZhrRVCOqmJ5F9JXv
VBZbyDnLW3SRD1ch/iEF/M40I4rFm7OlLIh6MVUkuSvA98k3ZZl8m9qqbPJN
5jbhPyy+cTc4B2X0DZnnJ/d9XDmPjGHcLXcjLAOLqJBdjitmIvNLGeL5VJZI
0cJickSL6rXQptY5QpvRSEy1GXfgsFwkqsl36kjqfTgsa+ak0MAWN/Ptnsgx
hInN/CqfCU1QFtBUm0+Te55JcDQzx3k0M+IbocQ08lPDGUfOcU9jyNxF1sin
rMPtIhsIr9AaBx6ag+3YXFqPbT6NYWG95UkttYt5s0WbYuIR8XjozXl5M92y
7rlAu+IuyXX5d735i4aHRp+d0u4i7fdGYT5+opoUXdV9UUbflI7ruch6Bxvg
lGJmQAQMTslmpP22QXlM1OkCXeU9pO2vg9Pseh4Yj4t0obyt1CwjK2o1MofF
Rh4Nq2NqsyohGg8Ph8pcsu9r4ZJz3xHOa76jjzkULGlXoQ+PUemN9D+YcPlm
HbznfoJuUz7A4zP+hh7BH6FX8Cn0mHEKPYPPoGfI3/BY8Fl0C/47ugafQ5cZ
n8B52t+hnfJ3OEz5hDp0FgNnncKlG1VMTxH4KX4/Om1GllWNlSntoBHV1y7j
/RneeOvpbjgy8nG869cDb/v3wtsje+CIf08cpXTM7zEcH9kNfxnRFSeGd8Fx
H2cc99bixDAHHBui4MikgSj/+pJAXyifBX2JvGKB3rEt9BrGnYqlHt2RqGfd
E4BrGHBnuKz9TmNFvQ+jrlFR11Xfh3dyPnrOzke/+Hx4LCiCV2IhhiYVYAg9
PZOL4EFpAKV+i3RwS9ahZ1Ipui/UwXV+KRzjSuEwi/oSfJXQ+VANxSXqD4G2
FXXW5S9neuPiuJ64OLkfLs3wwKVQL0pDcSlkCC6HeuKrEA9cCR6Ab4L74Zvp
brg2tSe+CeyOa+Nd8c1oR3w10gHnfRS8S8gL2g9Avb3Cq8ouVL074uPjBbiO
DK6bCi5f3aOr0H9hDbyX1uKZjFqMWlGHgKw6+GXVw29lPUZk18NndT28Vjdg
YHYD+q5sRM/ljeiW1giXxQ3QLCBbE0VsJ5yyAfdh0SZoVdo3xnbHraD+yIv0
xrdznkF+/CgUzAtAQbwfCub6oXDuCBTF+6Ak1gsl0QOhi+wLXVhP6IK6oWSy
CwrGafDVMwre8bSszwhattCtwRXOjZzFwCutrckiaU0IXPzx8CFnlJTwjmnR
zVvQGwycSOErKiroTp8Zczhkfceprw0+veY2wGtJI/xWNGL8mkYErjVSMmHi
s0aMX2fE2PVG+G8wwXeDGV7rzRi4zoy+OWY8vqoJj2SY4bS4EZpYUsLAs5Yx
kHH1exi0rX6Jr7xJvVAQ4YXCOD8ULxyPkuRAlCyilDwRuuTxlMaiNMkf+oW+
MMzzQlncQJRF90VZ+OMwzHgEJYFOuDZKg/eGOkjabQ253+dW7Cme9Lym+ii9
9LeLrJZcgJuZmUkjJwFoBO5dcevWLXy2+0XxJBkIiXCen/zOjUgIGvbJArI+
wh+LYB7uCQ0YQd5uAmE2fb1RriuoFz5bmjBkUxOeXN+E3rlN6J7VBNeljXCa
q4dmysc2+mmfjghxlf722ln9PV/fTnVHYcwIFCdOQMmS6TCee1+Ul6YGUZqG
0mWB0C8ZB8Nif5Ql+qA8YYj4bv7wMMrCukM31RXXxzjhz8M0angdyps1yjSD
hNb3Cyu0ji3QMvAxFRrGlmNAQpdBYqUWyFLvGUDK4Z8Z6ShbGIPTp09LoOl5
7sA+AW5DQwO3k/5Vw6C6i8hGIjIgqQFjVhEapH0zN7cgO3wraSAhO4CQ7UPI
Pr7SLCzAIwl64eAsyDYTenboiLLw58wIe86E4G0mTPspaTk9R28zt6LNlx3a
MsKiaImvfDLHRfPHCOR16TO16iqvNCMY+vRp0C+bCMOS0ShPHi63d0jbWKlL
Z3TD9YmP4PjTzpKkRZkZdTYbIjIRoDuptoRBLyG+5Rw/KhL5RwXqubm5Ak1G
+/2IKFz+x+e4njAPRZkxyF+ThAvLF+CcpydO/PWvUjiOOLB/v3SvMvVhCWo4
fFSh91rSgMDcRoQRXLN+amqBfosZQzc2YRAZgL65Zrhlm9EzsxGPJRnQdYZV
qYlOb3t0RNmsn5kQQflQgnw6pUmUxjD0NrT56oB2fJ3clxMGpZgMiS49DKVZ
s1C6MlpCrIU+Yzr0qZMI+jEq7M7Cnhgi3VAS2hM3plDoMryrqu/TDGKNUiTX
KD4nbU0JQ89rLwG9riV8J5PC0J8/f15V+G74fGEiTvsMRWNiCCpjgqB/Kwsn
Fwfi5aFPCrz37f01Tm9bL56MOwc5Ait3ET1LwJ4mXZuxgcAiUOY8b0Lsz02I
oWfUz0hfqSyIUiDp7egtJgzfRIARWB5rzei3xgz3VZTIG7ot0uMnodZ5ML9B
GWCXNl+doS2sU3vaLAqxcuCrcPbTKFk6A6UrZkGfPYdSLEpXxUjwHyNhBMJy
fWesgyHOA4boftBHuaMk3B3XKZr5i99PJFmeA1MLW1aNPictAukDZdAXcvHF
AonRtVpPsUAuXriIvDMf4eszZ/D57FAULw2E8Y0VKD2QgsolY3FrnC/+6TcM
p8NGozYuHDevXcMfDv1RrFw0LIe+7K5VYfiTK4zYakQcCWHudjPif24WwEWR
9oZtJe0loCZtMiGA3OLwdSYMpRnhQYLon21C/5WUCLD+KaXoEWbV3g5p89UZ
2nx1QDumQm73oCjOH7rMCOhXx0G/Zi4Mq+OFUEqzouT5Qzfo44dCP8cDpbP6
ozSqP4oj++NaSH/8eVQPKQSeDiwAXuSy0ZfTQoSObu2lwFZJlQRLYdPCBBSO
p4A5aAwqEmeh/mAqmv+1HfVHnkXJ1jh8GTMJuj+sReWmOXj1hV24+OmnePW1
V2kBmVTJc5EFyuTmVxBadOdpX64CN5YseQyZkHk7zEj4hVk859B7FGlu6Gay
5hvJmlOsEkDxi28OAUfCGEyADVhhwsDlJngsb4DHklK4zbTGQER7kF3aQiid
oM2XHdosEoEPX8UJY6FfGQNDzjwYchNIMPNohpBQlkeRCQuVM4Xc8Txf6GKH
Qhc9GLqoAZQGomiWB67N9MB7o90kWbZIlp2Ipy5DGXrEIhtS3yfOQBlzRW5f
8OYILTyUBJpSiWVCNpbApmrtUlS+kAjjvoVCLlf2rsTJtFj8Iz0C5lPrYHh+
Ng7v2ok33ngDGzdtZNFYBMMiSjC42QhlUk4jEnaakPSCGUm7JHixBNwsBm6T
EdPI7Ewg0AJyCLhsI4ZlGeFJgA3KJAAzjPDKpKCegOsbYSsU+7T56gxtvjqg
HVWszpTiJHISaxNgWJ8Ew7ok6HMSUEqmS7dilmWmlMQMQ8lsT5ohg1AcNZgs
nRe+CffCe2P7SmFYtoIYcxaGnCndt5I03FtLI/y2Olt0QiIW3y1CzlMf4Pr2
ORSdjRcS+CIrHp9tX4+TC6dQx8KQt2ACdKN9UPC7V3imqNIo0zAhsbfE0tCp
iIVsNGLxi2Ys2dOExbvNWLjTjLjnzZhFNiWU7Mk0QmvCGkKM1H34CiO8M40Y
km7E4DRCi55PZdTjqaUl6BfxN6s0dKoTaUubr87Q5ssObblDF1Eg8rrUEBg2
LYZhyxL5XLsQ+lVxFifCEa7tVRQ1BEURg+nphYLop/B15FM4Nr5fa6mwRNha
iSkihNKlvVDiim2FohELsUdxa8QwfDjGFxf9h+OLyHHCYrHf2N3fTcjjxrwQ
fPDaQZQW5ONPL+/XWmXRp40sMn7ThOX7m5D66yYkkwbPIz8STdobTuYkiJZX
gYQXB6jPEF5PE17ehNMwkoUPaa8vaa/PkhL0j7SVhZM92uqSoZu9dnIj0gbn
sp9loPzny1H2XCppf7JiCZ1KUoJQkhSI4vmW0OkRsj/DUBRNyhfji6tRPjg6
vn8LyBa1lyBbVd9Nojz2ArmRKxJl3q1llBfoherHx8fD8PbrQv0/zc0RToEN
DzsKi8q/NdoXeSfeF0ZLddUcMukFzO42MLOFXvVyE1YflHAsebEJC8kIxf3U
jCiy3KHrTZhKBmICGYiAlY0YSe53OAWXvgT3cEojCC7fpTo8GXnG6k4tMLeh
rcL8qL12rWBmy16xcxUqXljNUFvWBrqMKJQsC6UF8FRaDE9A0dwAxfKtaM5w
5M8ZQSj74uiEJy1dGXOFTa7vFxLlIW8pNrrs/i4vf6FMYZRvyH1y1meJskWX
eaX11bFjqJo3Gw3bl6JhQzgqwv1xbfMG3M5IwdGAcbh79y6ajcaOQeb4ZOMf
m7DlcBPWEBjp+6QNSNghrT0DHULucVouA92IcaTTAVmN8M+S2wojM+vgSzpp
A7JVl9vQti5/7bRrBTLHNZX7NqJy/xYCeg3MF8/LcrLk+pWxKtohhPY0gXZx
wjjxveGjoyiK90N+7EhcnWVFux3YNirt+n1gs5+kQRHW1P0LM0PQWCbXuI2f
nUWJ7zCRZ4QraaXGWz+MuFz/2oN7/i9M2PVOM/Ycbca21yXkrNvLfmVG8gvS
ycYRbDEUMkZsMSKcEsf3U8ikTMhh6MkEpBTDPewjG7h9HwbtViIxrJ2P6td2
oebwHlS9tE2IRZiarctg2JAMPUc/2XG0YIsh8URQChdrh5LFU4SNL5gbgCuR
Pjgyxr2TIvE/J0+PQq+TlblJYOZTKhEi4R0eKRInYWksIuBUFhlGpSQEos51
WYyUmNf80t6MlkYc3khxpO414+UTzXjl5B0B3aZDTch5pQkrX2oSVjj11+QV
Cb6UPWYRq3DMMoei+0gyH0E0K8auqof3omL0DrFuTsYWquL4kWlLxVTFUbYt
FbVvv4y6I68IsVTu24SK3Tko37FSeAEDeYAy8rhlm1NkHLSWY6A50C2PJLEE
oZAC1yvh3nhnVG9VHGMvdGCOHFuJQxN8mcd4kyuTRBhhCibpjWSgZQFQtuzT
T8QskELoQBR9bKSw7tUm7H2vGQf+0owd/9eEZ+mdjXPGb8xI2ytRWkTxSTLb
pV/S2mqHCdGkyDO3SOX1X1EPz8RijEz8DLrKu6oUHhrt6ALlCUG7cs861Ly+
F7VvHUD1KztQsedZlJNzKCcJlG1LExIwbFxEKRmGZ2mC5Myl5UE0TY6ZYmIU
xPvjcognPogYCV35HelZ2RSxGAafYjHYSGHIW1IK0/4Fh8hWUuB5oSTruW9L
ypzhkFohcnzgmEKLuOQy/spJa7VJvVpmgivSDpTjtu4+ckk7OQ6M3y6XR2EU
ifMGGxkJoj0516jBxDV0G5XVqDhjJK1WvZc1YmBSDQLSC3DlVj3S9pdJ8F05
+18TfbwjouqRcAHS9ulxp/A2KXsuKfdiWnHFy9VWWhiFOdPZ5vDmzaLJGjI7
EzXkiEdRV4vIIRREeeN28EBcjg1AzY0rSNuZrxGbzFoJq8TbovYasffvaEFb
mqDYm2zU87kF47mkzIJyagXVTK/ScI439+hLC/JlHNRLd+AmToy1cFqgQ9pv
K6CruqsearqIdy4XaztKduscoDpzi6V/IkSc5khEWDGtdXbmw2nixRZl4sH5
nLSY2N6HxF+5opQDuIgvxaG7OjJH25HxaLQ8LirNrBcjlIOVJ90y9eYF5FM8
ROeWyS1jQnlEHlsopoyGz/z59P+2I7tZ3pK+zj8jXGW82PWyrbckMkYay37p
IctfxEIW3F/HNl0VPUqv0kKTVecK7Sq2QZRVz6v59Jvu0/lUnnJLK4mhNqVC
CEiTVCYSd1xMCy33XMtdb+m5In5XkGiF31BEzxVHGSsEXZU4u78rDjEsvwLL
rrLKMrAWGImx6NYqI7TZd/i8E0rufe5eDgtOfRdPS56+cJ6Z5vKJOZc7r/mO
D0wVb/7ai4+T+Fw1Rx4uqY0cRX1X8esBH08JKFLrxKY+73OKnwr4KY74edey
i3xvEaztLw28cteomzaJYjeHFZAHH3hbUUeuUcNdni2MqXN6oxiu7H7PTeRk
nniebh67eEkybA/w9F6R6CvdtfA7gCCZo4+iTMM5LTx3WFpQW7W9vNMXa5mg
7MQ8tJKbS/Z9oY0NYrXCnVN7qpUujzrKvzJQNwlNbqKIHhKYTJbZ+b0I7pUG
E/bRLfAluGLKy+jNuV7WnBPnaNyU5Xq2TxIA5ZyZjkaMwpHZ8Lm3VHm/z+Ua
oeUP4ogvBX7cNaFn4ncZCjyF7+e1lrT01qfVyrBrTRTWRuy1lYkttl68N9mL
l7COli0ePrZUd+G0qkBjRJb3MHhnK0JvXSeJszZRViHzEWJCh5Twrzdiia9X
U4U86JhyxUmdBQ7/D8FlYfE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907299533234115765,11",
 CellLabel->"Out[5]=",
 CellID->364407987]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22749],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->15967]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6602],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"Icon\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 30.3675294}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"Icon\"Widget[\"Icon\"] represents an icon.", 
    "synonyms" -> {}, "title" -> "Icon", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/Icon"}, "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Images"->{
  Cell[2681, 93, 337, 9, 70, "Notes",
   CellTags->"Images",
   CellID->850],
  Cell[5496, 194, 806, 20, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,8"},
   CellID->14508],
  Cell[6327, 218, 160, 4, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,9"},
   CellID->26489],
  Cell[6490, 224, 8634, 146, 70, "Output",
   Evaluatable->False,
   CellTags->{"Images", "Ex--21907299533234115765,9"},
   CellID->546483412]},
 "PrimaryExamplesSection"->{
  Cell[4752, 165, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->57100476]},
 "Ex--21907299533234115765,8"->{
  Cell[5496, 194, 806, 20, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,8"},
   CellID->14508]},
 "Ex--21907299533234115765,9"->{
  Cell[6327, 218, 160, 4, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,9"},
   CellID->26489],
  Cell[6490, 224, 8634, 146, 70, "Output",
   Evaluatable->False,
   CellTags->{"Images", "Ex--21907299533234115765,9"},
   CellID->546483412]},
 "Ex--21907299533234115765,10"->{
  Cell[15380, 385, 908, 25, 70, "Input",
   CellTags->"Ex--21907299533234115765,10",
   CellID->18121],
  Cell[16291, 412, 308, 8, 70, "Output",
   CellTags->"Ex--21907299533234115765,10",
   CellID->10106]},
 "Ex--21907299533234115765,11"->{
  Cell[16636, 425, 149, 4, 70, "Input",
   CellTags->"Ex--21907299533234115765,11",
   CellID->23987],
  Cell[16788, 431, 8513, 144, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907299533234115765,11",
   CellID->364407987]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Images", 27511, 652},
 {"PrimaryExamplesSection", 27990, 666},
 {"Ex--21907299533234115765,8", 28142, 670},
 {"Ex--21907299533234115765,9", 28290, 674},
 {"Ex--21907299533234115765,10", 28582, 682},
 {"Ex--21907299533234115765,11", 28825, 689}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1138, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1761, 57, 45, 1, 70, "ObjectName",
 CellID->5754],
Cell[1809, 60, 357, 11, 70, "Usage",
 CellID->1552]
}, Open  ]],
Cell[CellGroupData[{
Cell[2203, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2681, 93, 337, 9, 70, "Notes",
 CellTags->"Images",
 CellID->850],
Cell[3021, 104, 71, 1, 70, "Notes",
 CellID->1516],
Cell[3095, 107, 675, 17, 70, "3ColumnTableMod",
 CellID->13226],
Cell[3773, 126, 942, 34, 70, "Notes",
 CellID->23486]
}, Closed]],
Cell[CellGroupData[{
Cell[4752, 165, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57100476],
Cell[CellGroupData[{
Cell[5136, 179, 147, 5, 70, "ExampleSection",
 CellID->52719291],
Cell[5286, 186, 129, 3, 70, "Input",
 CellID->342340309],
Cell[5418, 191, 75, 1, 70, "ExampleText",
 CellID->16710],
Cell[5496, 194, 806, 20, 70, "Input",
 CellTags->{"Images", "Ex--21907299533234115765,8"},
 CellID->14508],
Cell[CellGroupData[{
Cell[6327, 218, 160, 4, 70, "Input",
 CellTags->{"Images", "Ex--21907299533234115765,9"},
 CellID->26489],
Cell[6490, 224, 8634, 146, 70, "Output",
 Evaluatable->False,
 CellTags->{"Images", "Ex--21907299533234115765,9"},
 CellID->546483412]
}, Open  ]],
Cell[15139, 373, 216, 8, 70, "ExampleText",
 CellID->10184],
Cell[CellGroupData[{
Cell[15380, 385, 908, 25, 70, "Input",
 CellTags->"Ex--21907299533234115765,10",
 CellID->18121],
Cell[16291, 412, 308, 8, 70, "Output",
 CellTags->"Ex--21907299533234115765,10",
 CellID->10106]
}, Open  ]],
Cell[CellGroupData[{
Cell[16636, 425, 149, 4, 70, "Input",
 CellTags->"Ex--21907299533234115765,11",
 CellID->23987],
Cell[16788, 431, 8513, 144, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907299533234115765,11",
 CellID->364407987]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25362, 582, 311, 9, 70, "SeeAlsoSection",
 CellID->22749],
Cell[25676, 593, 199, 6, 70, "SeeAlso",
 CellID->15967]
}, Open  ]],
Cell[CellGroupData[{
Cell[25912, 604, 313, 9, 70, "TutorialsSection",
 CellID->6602],
Cell[26228, 615, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[26512, 627, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

