(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     67054,       1358]
NotebookOptionsPosition[     61901,       1201]
NotebookOutlinePosition[     65129,       1291]
CellTagsIndexPosition[     64829,       1281]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"ImageLabel\"", "ObjectName",
 CellID->20311],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<ImageLabel\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an image label."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9693]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<ImageLabel\>\"", "]"}]], "InlineFormula"],
 " is identical in functionality to ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<Label\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/Label"]], "InlineFormula"],
 ", except that it will easily display an image as its label instead of \
text.",
 " ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<ImageLabel\>\"", "]"}]], "InlineFormula"],
 " is useful when basic image display is needed in a user interface."
}], "Notes",
 CellTags->"Images",
 CellID->6332],

Cell["The following properties are available:", "Notes",
 CellID->27451],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<path\>\"", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell[
    "path or URL of the image file in GIF, JPEG, or PNG format", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<data\>\"", 
    RowBox[{"image", " ", "data"}], Cell["the image data", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1814],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"data\", \"TI\"]\)\>\""], "InlineFormula"],
 " property can be given as a ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 " or as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Script",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Script"], "[", 
   RowBox[{
    ButtonBox["ExportString",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExportString"], "[", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], ",", 
     StyleBox["format", "TI"], ",", 
     StyleBox["options", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["format", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData["\"\<GIF\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<JPEG\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData["\"\<PNG\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->31599]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->72964752],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->412345584],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->120915287],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["Widget", "Output"], "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          StyleBox["Widget", "Output"], "[", 
          RowBox[{"\"\<ImageLabel\>\"", ",", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{"\"\<data\>\"", "\[Rule]", " ", 
             RowBox[{"Script", "[", 
              RowBox[{"ExportString", "[", 
               RowBox[{
                RowBox[{"ToBoxes", "[", 
                 RowBox[{
                  RowBox[{"f", "[", "\[Beta]", "]"}], ",", 
                  "TraditionalForm"}], "]"}], ",", " ", "\"\<GIF\>\""}], 
               "]"}], "]"}]}], " ", "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          StyleBox["Widget", "Output"], "[", "\"\<TextField\>\"", "]"}]}], 
        "}"}], "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellTags->{"Images", "Ex--21907299533234115765,13"},
 CellLabel->"In[2]:=",
 CellID->17569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Images", "Ex--21907299533234115765,14"},
 CellLabel->"In[3]:=",
 CellID->9535],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Images", "Ex--21907299533234115765,14"},
 CellLabel->"Out[3]=",
 CellID->202787340]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["Widget", "Output"], "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         StyleBox["Widget", "Output"], "[", 
         RowBox[{"\"\<Label\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"\"\<text\>\"", "->", "\"\<Sample Plot\>\""}], "}"}]}], 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         StyleBox["Widget", "Output"], "[", 
         RowBox[{"\"\<ImageLabel\>\"", ",", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{"\"\<data\>\"", "\[Rule]", " ", 
            RowBox[{"Script", "[", 
             RowBox[{"ExportString", "[", " ", 
              RowBox[{
               RowBox[{"Plot3D", "[", 
                RowBox[{
                 RowBox[{"Sin", "[", 
                  RowBox[{"x", " ", "y"}], "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"y", ",", "0", ",", "Pi"}], "}"}]}], "]"}], ",", 
               " ", "\"\<GIF\>\""}], "]"}], "]"}]}], " ", "}"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->{"Images", "Ex--21907299533234115765,15"},
 CellLabel->"In[4]:=",
 CellID->23365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Images", "Ex--21907299533234115765,16"},
 CellLabel->"In[5]:=",
 CellID->25111],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{368, 342},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Images", "Ex--21907299533234115765,16"},
 CellLabel->"Out[5]=",
 CellID->731845933]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32252],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Widget",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/Widget"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->20912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->216],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"ImageLabel\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 31.7112106}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"ImageLabel\"Widget[\"ImageLabel\"] represents an image label.", 
    "synonyms" -> {"image label"}, "title" -> "ImageLabel", "type" -> 
    "Widget", "uri" -> "GUIKit/widget/ImageLabel"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Images"->{
  Cell[2701, 93, 606, 17, 70, "Notes",
   CellTags->"Images",
   CellID->6332],
  Cell[5646, 197, 1180, 30, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,13"},
   CellID->17569],
  Cell[6851, 231, 160, 4, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,14"},
   CellID->9535],
  Cell[7014, 237, 7614, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"Images", "Ex--21907299533234115765,14"},
   CellID->202787340],
  Cell[14643, 369, 1446, 36, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,15"},
   CellID->23365],
  Cell[16114, 409, 161, 4, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,16"},
   CellID->25111],
  Cell[16278, 415, 44386, 732, 70, "Output",
   Evaluatable->False,
   CellTags->{"Images", "Ex--21907299533234115765,16"},
   CellID->731845933]},
 "PrimaryExamplesSection"->{
  Cell[4979, 171, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->72964752]},
 "Ex--21907299533234115765,13"->{
  Cell[5646, 197, 1180, 30, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,13"},
   CellID->17569]},
 "Ex--21907299533234115765,14"->{
  Cell[6851, 231, 160, 4, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,14"},
   CellID->9535],
  Cell[7014, 237, 7614, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"Images", "Ex--21907299533234115765,14"},
   CellID->202787340]},
 "Ex--21907299533234115765,15"->{
  Cell[14643, 369, 1446, 36, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,15"},
   CellID->23365]},
 "Ex--21907299533234115765,16"->{
  Cell[16114, 409, 161, 4, 70, "Input",
   CellTags->{"Images", "Ex--21907299533234115765,16"},
   CellID->25111],
  Cell[16278, 415, 44386, 732, 70, "Output",
   Evaluatable->False,
   CellTags->{"Images", "Ex--21907299533234115765,16"},
   CellID->731845933]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Images", 62931, 1226},
 {"PrimaryExamplesSection", 63794, 1250},
 {"Ex--21907299533234115765,13", 63947, 1254},
 {"Ex--21907299533234115765,14", 64098, 1258},
 {"Ex--21907299533234115765,15", 64391, 1266},
 {"Ex--21907299533234115765,16", 64543, 1270}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1138, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1761, 57, 52, 1, 70, "ObjectName",
 CellID->20311],
Cell[1816, 60, 370, 11, 70, "Usage",
 CellID->9693]
}, Open  ]],
Cell[CellGroupData[{
Cell[2223, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2701, 93, 606, 17, 70, "Notes",
 CellTags->"Images",
 CellID->6332],
Cell[3310, 112, 72, 1, 70, "Notes",
 CellID->27451],
Cell[3385, 115, 612, 15, 70, "3ColumnTableMod",
 CellID->1814],
Cell[4000, 132, 942, 34, 70, "Notes",
 CellID->31599]
}, Closed]],
Cell[CellGroupData[{
Cell[4979, 171, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->72964752],
Cell[CellGroupData[{
Cell[5363, 185, 148, 5, 70, "ExampleSection",
 CellID->412345584],
Cell[5514, 192, 129, 3, 70, "Input",
 CellID->120915287],
Cell[5646, 197, 1180, 30, 70, "Input",
 CellTags->{"Images", "Ex--21907299533234115765,13"},
 CellID->17569],
Cell[CellGroupData[{
Cell[6851, 231, 160, 4, 70, "Input",
 CellTags->{"Images", "Ex--21907299533234115765,14"},
 CellID->9535],
Cell[7014, 237, 7614, 129, 70, "Output",
 Evaluatable->False,
 CellTags->{"Images", "Ex--21907299533234115765,14"},
 CellID->202787340]
}, Open  ]],
Cell[14643, 369, 1446, 36, 70, "Input",
 CellTags->{"Images", "Ex--21907299533234115765,15"},
 CellID->23365],
Cell[CellGroupData[{
Cell[16114, 409, 161, 4, 70, "Input",
 CellTags->{"Images", "Ex--21907299533234115765,16"},
 CellID->25111],
Cell[16278, 415, 44386, 732, 70, "Output",
 Evaluatable->False,
 CellTags->{"Images", "Ex--21907299533234115765,16"},
 CellID->731845933]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60725, 1154, 311, 9, 70, "SeeAlsoSection",
 CellID->32252],
Cell[61039, 1165, 199, 6, 70, "SeeAlso",
 CellID->20912]
}, Open  ]],
Cell[CellGroupData[{
Cell[61275, 1176, 312, 9, 70, "TutorialsSection",
 CellID->216],
Cell[61590, 1187, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[61874, 1199, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

