(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    194675,       4145]
NotebookOptionsPosition[    164237,       3331]
NotebookOutlinePosition[    184019,       3823]
CellTagsIndexPosition[    182070,       3779]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "LocatorPane" :> 
          Documentation`HelpLookup["paclet:ref/LocatorPane"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"LocatorPane\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"IndexedImagePanel\"", "ObjectName",
 CellID->5030],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<IndexedImagePanel\>\"", "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]represents an indexed image panel."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19782]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
By default, the image is displayed centered and nonscaled in the panel; \
however, you can also allow the image to scale to fit the entire size of the \
panel.\
\>", "Notes",
 CellTags->"IndexedImagePanel",
 CellID->32315],

Cell["The following properties are available:", "Notes",
 CellID->32080],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"imageWidth\", \"TI\"]\)\>\"", "1", Cell[
    "width of the image", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"imageHeight\", \"TI\"]\)\>\"", "1", Cell[
    "height of the image", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"imagePixelSize\", \"TI\"]\)\>\"", "1", Cell[
    "pixel size (an integer)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"imageColorMapSize\", \"TI\"]\)\>\"", "0", Cell[
    "size of the color map", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"imageColorComponents\", \"TI\"]\)\>\"", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell[
    "a list of the components of each color in the color map", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"imagePixels\", \"TI\"]\)\>\"", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell[
    "the indices of each pixel", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"preferredSize\", \"TI\"]\)\>\"", " ", Cell[
    "the display size of the image", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->2021],

Cell["The following event is available: ", "Notes",
 CellID->22425],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"mouseClicked\", \"TI\"]\)\>\"", Cell[TextData[{
     "the event ",
     StyleBox["triggered whe", "Text"],
     "n ",
     "the mouse is clicked anywhere within the panel"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->17752],

Cell["The following method is available: ", "Notes",
 CellID->9204],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"InvokeMethod", "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"getImagePixelCoordinatesAt\", \"TI\"]\)\>\"", ",", " ", 
      StyleBox["mouseEvent", "TI"]}], "]"}], Cell[TextData[StyleBox[
    "returns the image coordinates of the mouse event position", "Text"]], 
     "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->5446],

Cell[TextData[{
 "By default, most methods do not auto-repaint, so you can call a version of \
the methods taking ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " as the last argument. This allows you to make multiple calls to various \
locations on the image and then call ",
 Cell[BoxData[
  RowBox[{"InvokeMethod", "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["panel", "TI"], ",", " ", "\"\<\!\(\*
StyleBox[\"repaint\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
 " or a method with ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " as the last argument."
}], "Notes",
 CellTags->"IndexedImagePanel",
 CellID->19412]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->99051516],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->142111683],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->239152346],

Cell["\<\
Create a 5\[Times]5 image with five indexed colors, with all pixels set to \
black: \
\>", "ExampleText",
 CellID->2429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", "=", 
  RowBox[{"GUIRun", "[", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<IndexedImagePanel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<Dimension\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\"\<width\>\"", "\[Rule]", 
             RowBox[{"20", "*", "5"}]}], ",", 
            RowBox[{"\"\<height\>\"", "\[Rule]", 
             RowBox[{"20", "*", "5"}]}]}], "}"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"\"\<imageWidth\>\"", "\[Rule]", "5"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"\"\<imageHeight\>\"", "\[Rule]", "5"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"\"\<imagePixelSize\>\"", "\[Rule]", "20"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"\"\<imageColorMapSize\>\"", "\[Rule]", "5"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"\"\<imageColorComponents\>\"", "\[Rule]", "  ", 
        RowBox[{"Flatten", "[", "\[IndentingNewLine]", "  ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"255", ",", "255", ",", "255"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"255", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "255", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "255"}], "}"}]}], "}"}], "]"}]}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"\"\<imagePixels\>\"", "->", " ", 
        RowBox[{"Flatten", "[", " ", 
         RowBox[{"Table", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", "5", "}"}], ",", 
           RowBox[{"{", "5", "}"}]}], "]"}], "]"}]}]}], "}"}], ",", " ", 
     RowBox[{"Name", " ", "->", "\"\<imagePanel\>\""}]}], "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->"Ex--21907299533234115765,18",
 CellLabel->"In[2]:=",
 CellID->7761],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject212896881573889, 
   JLink`Objects`JavaObject387849773907969]]], "Output",
 CellTags->"Ex--21907299533234115765,18",
 CellLabel->"Out[2]=",
 CellID->9133]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->"Ex--21907299533234115765,19",
 CellLabel->"In[3]:=",
 CellID->12930],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21907299533234115765,19",
 CellLabel->"Out[3]=",
 CellID->419017098]
}, Open  ]],

Cell["Set all pixels to white:", "ExampleText",
 CellID->5532],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<imagePanel\>\"", ",", " ", "\"\<imagePixels\>\""}], "}"}], 
    ",", "\[IndentingNewLine]", " ", 
    RowBox[{"Flatten", "[", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", "5", "}"}], ",", 
       RowBox[{"{", "5", "}"}]}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,20"},
 CellLabel->"In[4]:=",
 CellID->25283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,21"},
 CellLabel->"In[5]:=",
 CellID->30873],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,21"},
 CellLabel->"Out[5]=",
 CellID->407546298]
}, Open  ]],

Cell["Loop 100 times, setting all pixels to random values:", "ExampleText",
 CellID->21880],

Cell[BoxData[
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ref", " ", "@", " ", 
    RowBox[{"SetPropertyValue", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<imagePanel\>\"", ",", " ", "\"\<imagePixels\>\""}], "}"}],
       ",", "\[IndentingNewLine]", " ", 
      RowBox[{"Flatten", "[", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Random", "[", 
          RowBox[{"Integer", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "4"}], "}"}]}], "]"}], ",", 
         RowBox[{"{", "5", "}"}], ",", 
         RowBox[{"{", "5", "}"}]}], "]"}], "]"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", "100", "}"}]}], "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,22"},
 CellLabel->"In[6]:=",
 CellID->8835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,23"},
 CellLabel->"In[7]:=",
 CellID->24987],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,23"},
 CellLabel->"Out[7]=",
 CellID->236786575]
}, Open  ]],

Cell["\<\
Loop 100 times, setting a random cell in the first row to a random value \
within each loop:\
\>", "ExampleText",
 CellID->25589],

Cell[BoxData[
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pos", " ", "=", " ", 
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "4"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     
    RowBox[{"ind", " ", "=", " ", 
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "4"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     
    RowBox[{"ref", " ", "@", " ", 
     RowBox[{"InvokeMethod", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<imagePanel\>\"", ",", " ", "\"\<setImagePixel\>\""}], 
        "}"}], ",", "pos", ",", "0", ",", "ind"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", "100", "}"}]}], "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,24"},
 CellLabel->"In[8]:=",
 CellID->7629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,25"},
 CellLabel->"In[9]:=",
 CellID->5560],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWgl0VEXWfunOQkAQyEKQCAQIhBCQhLATtpCFbGQFQhaSQEICYUuQTRhc
QAaVXxAcfhw3jh7+XwUcHRVB9Be3cUY8ICogy2TrTncWliydTkD4/nurXnc6
IYzAkSMu75x6r169et+r+u6te29VvejMZbnZCzOX5c3J7B1WkLkkN29OYe/Q
xQVUpLVTFOUhSo/3VjgPylpOWiiuO6G4PMVJWSnOimIPxX0flJ4vq2mXE2e0
nHPgnCOU+8Utn2RuV4ucfLBLo1buuYvfsHngaIXSqk/V3D0t3+XbXdwc0YxX
+A5Kj7/aqe0khO5H0c7/B3QMO43OiUVoP/UH6pP9pFOEMf5cOyhBZznHp6Bz
jupt0DlL2XhZpuGc1lJZ5hyve0PWaw11PWjQOU3L1wQU9yLoLJSRx6D4HeLe
XN+LrvF6uM+/gHZJ56gXTtMqF0MJr1G08s3BHzHFil2zkNTX1FecQIcrSKqu
NjmqKXLtuIyhwmsk3G8equevA8op4HagxjNXu35vUHenBH9OZfA/dbtQ19F+
V0LdHlfjz/1sluFOQzndNlQbtF8HpdAJihXv9wnV9sD57UAFnfsdQN3MwPn1
QrVtRe9GqDZM3x9QPyuUcBM3DzWOUe42gFtj4w+APwD+APjVAVwX5P/CAOPU
0FkYVQU/DdB6pvmfAG5qLv4rBLgVEu9SgFvioM2o9BcHaD0ab4PEXx7g1sTY
xqT6lwZovW7xk2L8qYWPXx7A1QZA3N48VBv2+SagbrAOdzdC3SZXt7IO9wfU
HYW60TrcT0Pd9JLebwbKOfD0bxvK6bagxp6G4vXa3Q9131EqLZYpslgDJfgo
VbYLPgq7Kcc4Kc7QhBzTclbD5YpWPuEadOfOd678mhvf91QBBN4QojPgMH/N
7Rn6mlPrrxHhR7i++IxGfkaJOEUfiD7LGLFUI7qMrqX0lM9UllDCOctdbKkv
V6HvhxbzPWNGlok7R0tZMLViokhyB5PP40/LMnk3sUXZ+NP8tTE/0ExBGXWK
c1CGn5J5vnLbR1Vyz5jGJxWxc2rpWGSVbHJiGYPMLGeKZ1JZajWUjAtQZtdq
oc2usYc2t54+qs29DLv5IlFNPlNDsq/Cbm4TJ5ZgRhOffhQ5pjC1iW/lNbkR
yiwTfaEOyowG8UUzf3FGA5Skeihx9XzVcMaec9zSuEtQoi7Kq6zD70XVEV9h
F+24a3a2fXNq2beZ1IeUWsuV3tRm8MawNrOBe8T9oTvH+U10yv/RCdoFV0iu
86+58RMNd40eO+RcQc5fTUIv71W1U3/+qiijZ8qN6znJejvr4JBpZkIEDQ7p
ZuT8pU7pLOq0g776R+Rsq4HDtFruGPeLdKGytdQsPStt0TO7DBP3htUxu0mV
EPWHu0NlTouvauFUcNUejkuv0cMC0GkRunEfFTfMe7EBx07XwGf6p+g44T10
mfIhuoZ8ANeQA+g65QBcQg7BJfRDdA75CB1DPkb7kMNoN+VTOE76GNoJH8Nu
wqfUoI/QK+YAjp46z3iK4E/x/9mxmVlWNVamnJ0mXDhxDO9O8cHuQR2xZ2gX
vOHfFa8FuOK1oV2xJ8AFeynt8++Mt4Z2xNtD2uOdwe3wlq8j3vLR4p0BdtjX
T8Gecb1Q+d1Rwb5QPgv7knnFQr19a+o1zDsVSz26LFnP/1EQrmHCHeG07JrG
yno3Zl2jsq6/cBU+6UVwmVaEHklF8JpVCu/UEvRPK0Y/uvZNL4UXpZ6UeszW
wz1dD5e0cnRK0cN5ZjnsE8thF0NtCfmW2HlfaJGF9TuAbWWddfnrqT44MsoF
R8b3wNEpXjga5k2pP46G9sOxsL74JtQLx0N64vuQHvh+sjtOTHTB90GdcGK0
M74fbo9vhtrhE18FbxDzAvs/sH69wqvKLlS9E5KSkgS59kyuu0ouH51iz8Mz
5SJ85lzCA7mXMGxBDQLza+CfXwv/hbUYsrgWvktq4b2kDr0W16H7wnq4zK9H
x5x6OGXUQTOLbE00fXbMARty7xQ2UatinxrZCWeCPXEuygf/jn8ARUnDUDwj
EMVJ/iie7o+S6UNQmuQLXYI3dLG9oI/qDn24C/TBHaEb74TiURp884CC1/sq
FuyoOrbQLckVzo2cRa/jLa3JbGlNiFy8tOtlR+h0Onq59PQZGIxGTqTwVVVV
dKbHzDns8q9x6m7Dj+v0Onhn1cN/QT1GL61H0DITpQaMfdCE0ctNGLnChICV
DfBbaYb3CjN6LTeje4EZXRY1okOuGQ4Z9dAkkBIGfWTpAxlX/zuBbfVLfJwb
54riSG+UJPqjLGU0dOlB0M2mlD4W+vTRlEaiPC0AhhQ/GGd4oyKxFypiu6Mi
oguMUzpAF+SAE8M0eLO/ncRubcj9v7By7wyl7wnVRxmkv51tteSC3Ly8POo5
CUAjeG+PM2fO4PMnnxJXkoGQCOf5yvf8EglBwz5ZUNZN+GMH0RaP5DoMIW83
hjibvMKkiACMWuG7phH9Vjfi/hWNcCtsRKf8RjjPqYfDdAM0E/7PRj/bxukg
ani29Z7V3/Px74keKIkbgrLUMdBlTYbp8LuivDw7mNIklM8NgiFrFIwZAahI
9UVlcj/x3Pz+LlSEd4J+ojNOjnDA3wZouFjDxLJaTzJKav2+tFJr30wtEx9X
pWFuOQYkdpkkVmrBLLWeCaQc/pk7DxUpcTh48KAkmq6Ht28V5NbV1fF70r9q
mFQPEdlIRnqm1WHEImKDtG/qQ83MDl5LGkjM9iRmuxGzXRaahQXokGwQDs7C
bBOx1waOKIv4kxnhf2pAyLoGTHqYtJyuw9eZW2Dz0Qa2jLAoWuKjiMxx6cwR
gnn9vKla8dwB5bkhMMybBMPcsTBmDUdl+mBFPmsvlLp8SkecHNsBbw1ylJAW
ZWbW2WyIyESQ7qDaEiZdR9+t5PhRkczfI1gvLCwUbDLb70ZG49g/vsDJ5Bko
zYtD0dI0fDV/Fg737Yt3/v53KRx7bN+2TbpXmbqxBDUcPqrUe2fVIaiwHuFE
V8zDDc3UrzGj/6pG9CYD0L3QDPfFZrjk1aNzmhHtp1iVmnDc2sIRZTGPNCCS
8mFE+WRK4yiNYOptsPm4AXZSjSI5Y4NSRoZEPy8c5fkxKF8YKynWwpA7GYbs
cUT9CJV2R2FPjFHu0IW54NQECl0Gt1f1fZJRzFFK5RzFd7+tKWHqeSIoqNc3
h+9kUpj6Tz75RFX4jvgiJRUHffujPjUU1XHBMOzOx/6MIOzof7/ge+uWp3Fw
3QpxZd45yBFceYjoWRI2iHRtykoii0iJf7QBCY81II6u0Y+QvlJZMKUg0tvh
axoweDURRmR5LTOjx1IzPBZRIm/oPtuAe8Os42BmndKzTWw+bgZbWKfrsVkU
YubAR8m0QdDNmYLyBTEwLI6nlIDyRXGS/M4kjCBYjmumGhgTvWCM7QFDtAd0
ER44SdHM2/73SlgeAxNLmmeNvvstAukGpfeXcvLFAonTt5hPsUCOfHUE5w59
gO8OHcIX08JQNicIplcXoHx7JqqzRuLMKD/8038ADoYPx6XECJw+cQIvvvyS
mLloWA7d2V2rwgggVxi51oREEsL09WYkPWYWxEWT9oavJe0losatbkAgucXB
yxvQn0aEFwnCc3EDPBdSIsI8M8vRNdyqvTfE5uNmsPm4AXZcldzPQmliAPR5
kTAsSYRh6XQYlyQJoZTnR4vhTcpqSOoPQ7wXymM8UR7tibIoT5wI9cTfhnWV
QuDhwALgSS4bfTksROjofr0U2CqpkmAprE5JRsloCpiDR6AqNQa1O7PR9K/1
qN3zIHRrE/F13DjoX1yG6tXxeP6JTTjy2Wd4/oXnaQKZVs1jkQXKcDOriC06
87CvVIkbSZY8jkzIjA1mJD9uFtd4uo8mzQ17iKz5KrLmFKsEUvziV0DEkTD6
EGE9FzSg1/wGeM2vg1dWOdynWmMgwu7dJrYQyk1g89EGNotE8MNHWfJIGBbG
wVgwA8bCZBLMDBohJJT50WTCwuRIIXc8ww/6hP7Qx/aBPronpV4ojfHCiale
eHO4u4Rli2RZiRh4DEr/PRbZkPredwjKiONy+YIXR2jioSTTkEqtELKxBDbn
l81B9ROpMG1NEXI5vmUh9uck4B/zImE+sBzGR6dh16aNePXVV7Fq9SoWjUUw
LKJko7uNUMYV1CN5YwPSnjAjbZMkL4GIi2HiVpswiczOGCItsICIW2zCgHwT
+hJhvfOIwFwTvPMoqCfiukfaCqVtbD5uBpuPG2BHl6kjpSyNnMSyZBhXpMG4
PA2GgmSUk+nSL4ixjBRd3ADopvWlEdIbZdF9yNJ54/sIb7w5srsUhmUpiDln
YciR0mktScOjpTQizqqjRS8kYvHdIuQ88B5Oro+n6Gy0kMCX+Un4fP0K7E+Z
QA0Lx7lZY6Af7ovi/36OR4oqjQoNA4m1JZaGXmUsdJUJGU+ZkbW5ERlPmpGy
0YzER82IIZsSRvZkErE1ZikxRuo+eIEJPnkm9JtnQp8cYouuA3NrMXCODj0i
P7RKQ686kdbYfNwMNh9tYMsVushikddnh8K4OgPGNVnyuiwFhkWJFifCEa7t
URrdD6WRfejqjeLYgfguaiD2je7RUiosEbZWYogIobS7XiiJZbZC0YiJ2D04
M2QA3h/hhyMBg/Fl1ChhsdhvPOnpLuRxakYo3nthJ8qLi/C/O7ZprbLo1koW
uc80Yv62RmQ/3Yh00uAZ5EdiSXsjyJwE0/QqiPjiAPUB4msQ8eVDPA0gWfiS
9vqR9vpm6eAZZSsLh7aw1SlDx7bekwuRNjxXPJKLysfmo+JP2aT96YoldNJl
BkOXFoSymZbQqQPZnwEojSXli/PDt9G+2Dvas5lki9pLkq2q7y5ZHvkVuZHj
kmVerWWWZxmE6iclJcH42itC/T8rLBBOgQ0POwqLyu8e7odz77wrjJbqqjlk
MgiaPWxoZgu9aEcjluyUdGQ91YgUMkKJD5sRTZY7bEUDJpKBGEMGInBhPYaS
+x1MwaUf0T2Y0hCiy2+OHvdHHbK6UwvNrbBVmu9p670WNLNlr9q4CFVPLGGq
LXMDfW40dHPDaAI8kSbDY1A6PVCxPCuNH4yi+CHEsh/2jrnf0pQRx9nk+n0p
We63W7HRZY83ePoLZQKzfEquk7M+S5YtuswzrW/27cP5GdNQt34O6lZGoCoi
ACceWomzuZnYGzgKV65cQZPJdGOSOT5Z9VIj1uxqxFIiY95WaQOSN0hrz0SH
knucVMhE12MU6XRgfj0C8uWywtC8GviRTtqQbNXlVtjW6W8b77UgmeOa6q2r
UL1tDRG9FOYjn8hysuSGhQkq26HE9iTBdlnyKPG87oO9KE3yR1HCUHwbY2X7
OrJtVNr5p8hmP0mdIq6p+V9NDUV9hZzj1n/+EXR+A0SeGa6mmRov/TDjcv7b
Ft0zH2/AptebsHlvE9a9Iiln3Z77X2akPyGdbCLRFkchY+QaEyIocXw/gUzK
mAKmnkxAZhk8wj+wodvvTmC3EIlx2UxceGETLu7ajPPPrhNiEaZm7VwYV6bD
wNHP4kSasMWReCIpRYi5gy5jgrDxxdMDcTzKF3tGeNykSAIOy92jsJNkZU4T
mUWUdEIkvMIjReIgLI1FBJwqosKplIRA6FyXxUiJvzWz3I3Z0ojNGymO7C1m
7HinCc/tvyyoW/1yIwqea8TCZxuFFc5+mrwi0Ze52SxiFY5Z4im6jyLzEUyj
YuSiWvjMLoNbqHVxMqFEFcfPjC0VUxVHxbpsXHptB2r2PCfEUr11NaqeLEDl
hoXCCxjJA1SQx614KFPGQcs4BoqHfn4UiSUYJRS4Ho/wwevD3FRxjPzqBubI
voU4NCHHuI+nuTJJhBmmYJLuSAZaFgBlKz77VIwCKYQbiKKbjRSWP9+ILW82
YfvbTdjwP414kO7ZOOc+Y0bOFsnSbIpP0tku/ZnmVhsaEEuKPHWNVN6ABbXo
m1qGoamfQ199RZXCHcOOLVbuE9jVm5fj4itbcGn3dlx4bgOqNj+ISnIOlSSB
inU5QgLGVbMppcP4IA2Qguk0PYilwTFVDIzipAAcC+2L9yKHQl95WXpWNkUs
hj4HWAw2Uui3W0ph0r9gF9VCCjwulHQDty2rwhF22VUixxuOmTSJS6/gp5y0
Vpvk2jwSnJGzvRJn9VdRSNrJcWDSejk9CqdInBfYyEgQ9vhCkwZjl9JpWH69
4oihNFv1mVuPXmkXETivGMfP1CJnW4Uk35mztwza5Uag6pZwMXK2GnC55Cwp
eyEpdwbNuJLkbCsnnMKcyWxzePFm9ngNmZ2xGnLEw6ippeQQiqN9cDakF44l
BOLiqePI2VikEYvMWkmr5Nui9hqx9m9vYVuaoITTbNSL+A3mM6vCwnJ2FdWc
d17DOV7coyfNzFdwUC/dgbvYMdbCYZYeOX+pgv78FXVT00ncc7mY21Fqs852
qjO9TPonYsQhXjLCimmts7EIDmOPNCsTd853v8XEur1M2qR2mQO4yK/Fprva
M3vbnnFvtNwvKs2rFT2UnZU73TK58QRyIHfRsXlwy5hQbpEnlIgho+E9f979
P2vPbpaXpE/yzwjfMl/setnWWxIZI41lvVS2V3SOZMHttW/VVNGieee10OTX
OEO7iG0QZdX9at79pvNk3pWn3Jxq+qA2s0oISJNWIRI3XAwLLbdcy01vbrki
fleQbEWcUkTLFXsZKwR/K3n2eENsYoiBam0qqywTa6GRPiyatcgE7eLLvN8J
pfAqN6+ABafei6slT084zx8t5B1zLndceo03TBUffurK20m8r1ogN5fUl+xF
fWfx6wFvTwkqsmvEoj6vc4qfCvgqtvh51bKdvG8WrO0vDTxz16iLNqliNYcV
kDsfdFZRe65Rw10eLcyp47x60V3ZfJfV5GTue5ROXpt4SjJgMzBoi0j0lM5a
+G9HsMzRQ1Gm4ZwWfTdY3qB31fflmZ5YywSyA39DK7/mtPiq0MY6MVvhxqkt
1UqXRw3lXxmomcQmv6KIFhKZDMuf838K3CoNxmylU9CzcMaEHXDjnKs158A5
6jdluZ7tlQRAOUfG0Yhe2PNneN9bqrz/F3KOIMNl8XvL14I/bprQM/G7DAWe
wvfzXEtaeuvVamXYtaYKayPW2irEEpsrr0268hTW3rLEw9uW6iqcVhVonMjy
GgavbEUarPMksdcmyqpkPlIM6FAd/3ojpvgGNVXJjY4Jxx3UUWD3/+7VYGE=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,25"},
 CellLabel->"Out[9]=",
 CellID->314772497]
}, Open  ]],

Cell["Repaint the image to see the result:", "ExampleText",
 CellID->10597],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<imagePanel\>\"", ",", " ", "\"\<repaint\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,26"},
 CellLabel->"In[10]:=",
 CellID->32189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,27"},
 CellLabel->"In[11]:=",
 CellID->13163],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,27"},
 CellLabel->"Out[11]=",
 CellID->5716384]
}, Open  ]],

Cell[TextData[{
 "Combine the previous two method calls by giving ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " as the last argument to ",
 Cell[BoxData["\"\<setImagePixel\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18621],

Cell[BoxData[
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pos", " ", "=", " ", 
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "4"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     
    RowBox[{"ind", " ", "=", " ", 
     RowBox[{"Random", "[", 
      RowBox[{"Integer", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "4"}], "}"}]}], "]"}]}], ";", "\[IndentingNewLine]",
     
    RowBox[{"ref", " ", "@", " ", 
     RowBox[{"InvokeMethod", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<imagePanel\>\"", ",", " ", "\"\<setImagePixel\>\""}], 
        "}"}], ",", "pos", ",", "0", ",", "ind", ",", " ", "True"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", ",", 
   RowBox[{"{", "100", "}"}]}], "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,28"},
 CellLabel->"In[12]:=",
 CellID->24705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,29"},
 CellLabel->"In[13]:=",
 CellID->2815],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,29"},
 CellLabel->"Out[13]=",
 CellID->77899395]
}, Open  ]],

Cell["Loop 100 times, setting a random column to a random value:", \
"ExampleText",
 CellID->22334],

Cell[BoxData[
 RowBox[{"Do", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"coords", " ", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{"#", ",", 
            RowBox[{"{", "5", "}"}]}], "]"}], "&"}], " ", "@", " ", 
         RowBox[{"Random", "[", 
          RowBox[{"Integer", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "4"}], "}"}]}], "]"}]}], ",", " ", 
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", "4"}], "]"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ind", " ", "=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{"#", ",", 
         RowBox[{"{", "5", "}"}]}], "]"}], "&"}], " ", "@", " ", 
      RowBox[{"Random", "[", 
       RowBox[{"Integer", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "4"}], "}"}]}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ref", " ", "@", " ", 
     RowBox[{"InvokeMethod", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<imagePanel\>\"", ",", " ", "\"\<setImagePixelArray\>\""}], "}"}],
        ",", "coords", ",", "ind", ",", " ", "True"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", "100", "}"}]}], "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,30"},
 CellLabel->"In[14]:=",
 CellID->16999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GUIScreenShot", "[", "ref", "]"}], " "}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,31"},
 CellLabel->"In[15]:=",
 CellID->13137],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,31"},
 CellLabel->"Out[15]=",
 CellID->51074597]
}, Open  ]],

Cell["Display the grid:", "ExampleText",
 CellID->14164],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<imagePanel\>\"", ",", "\"\<imageGrid\>\""}], "}"}], ",", 
    " ", "True"}], "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,32"},
 CellLabel->"In[16]:=",
 CellID->32058],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<imagePanel\>\"", ",", "\"\<repaint\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,33"},
 CellLabel->"In[17]:=",
 CellID->23511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,34"},
 CellLabel->"In[18]:=",
 CellID->8383],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,34"},
 CellLabel->"Out[18]=",
 CellID->9959186]
}, Open  ]],

Cell["Set the grid color to a custom value:", "ExampleText",
 CellID->20943],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"Script", "[", "\[IndentingNewLine]", 
   RowBox[{"SetPropertyValue", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<imagePanel\>\"", ",", "\"\<imageGridColor\>\""}], "}"}], 
     ",", " ", "\[IndentingNewLine]", 
     RowBox[{"Widget", "[", 
      RowBox[{"\"\<Color\>\"", ",", 
       RowBox[{"InitialArguments", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"255", ",", "0", ",", "0"}], "}"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,35"},
 CellLabel->"In[19]:=",
 CellID->32737],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<imagePanel\>\"", ",", "\"\<repaint\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,36"},
 CellLabel->"In[20]:=",
 CellID->29831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GUIScreenShot", "[", "ref", "]"}], " "}]], "Input",
 CellTags->"IndexedImagePanel",
 CellLabel->"In[21]:=",
 CellID->28655],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"IndexedImagePanel",
 CellLabel->"Out[21]=",
 CellID->11919595]
}, Open  ]],

Cell["\<\
Scale the image to fit the size of the panel (after resizing):\
\>", "ExampleText",
 CellID->24351],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<imagePanel\>\"", ",", "\"\<scaleImage\>\""}], "}"}], ",", 
    " ", "True"}], "]"}]}]], "Input",
 CellTags->"IndexedImagePanel",
 CellLabel->"In[22]:=",
 CellID->13290],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<imagePanel\>\"", ",", "\"\<repaint\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellTags->"IndexedImagePanel",
 CellLabel->"In[23]:=",
 CellID->16052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,37"},
 CellLabel->"In[24]:=",
 CellID->12295],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,37"},
 CellLabel->"Out[24]=",
 CellID->189452871]
}, Open  ]],

Cell["Preserve the aspect ratio:", "ExampleText",
 CellID->24061],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<imagePanel\>\"", ",", "\"\<preserveImageAspectRatio\>\""}], 
     "}"}], ",", " ", "True"}], "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,38"},
 CellLabel->"In[25]:=",
 CellID->14360],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<imagePanel\>\"", ",", "\"\<repaint\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,39"},
 CellLabel->"In[26]:=",
 CellID->29767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,40"},
 CellLabel->"In[27]:=",
 CellID->15273],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWwlUVEe6vnSziEajIoiRqKgoIhpB3FDckEU2WVVkEVAQFDcwbtExi8Zn
El80mvGZyeZJju8lUTPJJDEakxezTWZijsYkSlwGhG66WVxYmgaNfu//q243
izjxnTNR5py+nLq3bt1b//3r+/7666+qJjpzVW720sxVeQsyB4QVZK7IzVtQ
OCB0eQEVae0URXmM0tMDFM6DspaTFkqvvVBcnuOkrBVnRbGH4nYISr/X1bTP
iTNazjlwzhHKw+KWTzK3r1VOPtinUV/ut49rtHjgaBWlVZ+quQda1+XbfayO
UOMNvoPS9092qp4koc9JdPL7BV3DzqF7YjE6z/yF2mQ/rYhkTL7YCUrQBc7x
Keiio3obdNFSNlmWaTintbwsc4631ZDvtRV1u9Cgi5rW1YQobkXQBSjjTkHx
Pcatub0VPeP1cFt8BZ2SLlIrnGZVLocSXqNoZc0RnzHEil0zSWo1tYoT6KCX
IdkVDPcQZ7VM/nEZrGWKvPB7cOW8Swsp6kEayjJSRqpiU6MDqtHPpsY/U8PJ
/16rMZltY59NjY6vRgcxUZsarWzDr+h+qHGbidrUuK+2MflihxhhO7IaTm3U
yOb6Tm2rtWNS90N7mxodTY32na9NjfupRtBFmxodUo3fdL42NTpAmGJTowME
9DY1/g3VaD927AAzZpsardToGCZlU8Omhk0Nmxo2NWxq2NS4h2rc68Xgu1Kj
ndixA2t/7/eeOsi+pE2N31Tj3puoTY2OaBvtrjva1Lj/yxg2NTpeh21ne9Sm
xn3dwW9/g7FDqnF77NiRtb8/IWw76442Ne77T2Q6QD+3qWFTo+OHKR3g51M2
NX5TDeeAczY1OpoaTvdcjYnnoHi+9e+hxu2x4+3VHjpJpSUyRZZooASfpJft
gk/CbsYpToozNCGntJzVcLmilU/4Dbpz47teXM2V7/upAoS8kUSZ/3H+musL
CmvS5mtE6gl+X3xGIz+jRBTRB6IvsIxYeiO6jK6l9JTPVJZwiXOWu9hSH36F
vh9awvcsM7JM3DlayoJJi6kiKeI/hvg8+Zwsk3dTW5VNPsdfC/xF6QRlfBHn
oIwpknm+su7jK7llDOOzivhPJUvDIqukyollLGRuOUM8l8pSq6FkXIEyv1YL
bXaNPbS59fRRbe512C0Wid7kMymSfRN2C5s4KdSwjCY+/SpyDGFqE9/Ka3Ij
lHkm+kIdlDkN4otm/uKcBihJ9VDi6vmq4Yw951jTuGtQoq7Kq3yH60XVEV5h
V+24aXYt2+bUum1zqQ0ptZYr1dRm8D9iaTMbuEXcHrpzXNxEp/xfnaBdcoN4
XXzLlZ9ouGn02CHnBnL+ZBJ2+aBqnfrLN0UZPVPu/J6TfG9vHRwyzQyIgMEh
3YycP9Yp3cU7naCv/hU5u2rgMKuWG8btIluobMuapWWlrVpml2Hi1rA5Zjep
DFF7uDlU5rT8phZOBTft4bjyFj0sAJ2WoTe3UXHFolcbcOpcDbxnf4muUz5C
jxmfomfIJ+gVcgQ9ZxyBS8gxuIR+iu4hn6FryOfoHHIcnWZ8Ccdpn0M75XPY
TfmSFPoM/WOO4GTRZZanCPwUv3+5bEaWTY2NKWevCVfOnMKHM7yxf3hXHBjV
A+/49cRb/r3w1qieOODvgoOUDvl1x3ujuuL9kZ3xwYhOeM/HEe95a/HBUDsc
GqzgwKT+qPzppEBfGJ8FfYm8YoHevi30GsadiqUdXZeo5/8qANcw4I5wWnVL
Y0W9N6OuUVHXX7kJ7/RiuMwqRt+kYnjOK4VX6iUMSSvBYLoOSi+FJ6V+lPrO
18MtXQ+XtHJ0S9HDeW457BPLYRdDuoT8SOh8LKzIgvrvINuKOtvy9zO9cWK8
C05M7ouTMzxxMsyL0hCcDB2MU2GD8EOoJ06H9MPPIX3x83Q3nJnqgp+DuuHM
BGf8PMYeP4yywxc+Ct4h5IXsf4L67QavGrsw9W5ISkoS4NozuG4quHx0i70M
j5Sr8F5wDY/kXsPoJTUIyK+BX34t/JbWYuTyWvisqIXXijr0X16HPkvr4bK4
Hl1z6uGUUQfNPPI10fTZwCMtwP29ZBO0quyicd1wPtgDF6O88Y/4R1CcNBol
cwJQkuSHktl+uDR7JEqTfKBL8IIutj/0UX2gD3eBPrgrdJOdUDJegx8eUfD2
IMUiO6qOPXRrcMXgRoNF/9Otvcl86U0IXLy273VH6HQ6qlx67jwMRiMnMviq
qio602PGHHb5tzj1aYFPr9l18Mqqh9+SekxYWY+gVSZKDZj4qAkTVpswbo0J
/msb4LvWDK81ZvRfbUafAjN6LGtEl1wzHDLqoUkgIwz6zNIGcq5+v4ds67jE
x8VJvVAS6YVLiX4oS5kAXXoQdPMppU+EPn0CpXEoT/OHIcUXxjleqEjsj4rY
PqiI6AHjjC7QBTngzGgN3h1iJ2W3deR+31ixd4Yy6Iw6RhnkeDvf6skFuHl5
edRyIkAjcO+M8+fP4+tnnxNX4kAwwnm+8j1XIhI0PCYLyHqL8VjEYHBPrsNI
Gu0CCbPpa0xqiOUMnw2NGLy+EQ+vaYRrYSO65TfCeUE9HGYboJnyvy3ss305
XcQbHu3Vs473fPxjqjsuxY1EWWogdFnTYTr+oSgvzw6mNA3lC4NgyBoPY4Y/
KlJ9UJk8WDw3f7wPFeHdoJ/qjLNjHfDnoRou1jCwbNbTjBJa32+t0No3Q8vA
x1VpGFuOAQldBomNWiBL2jOAlMPfchehIiUOR48elUDT9fjunQLcuro6rifH
Vw2D6i4iG4lIv7Q6jF1GaJD1zXysGdkRG8kCCdl+hGxvQrbHUrPwAF2SDWKA
syDbROi1I0eURfzBjPA/NCBkUwOmPU5WTtcxm8ytZPPRjmwZYVG0xEcxuePS
uWMF8vpFM7VqcF6eGwLDomkwLJwIY9YYVKaPUOSzzsKoy2d0xdmJXfDecEcp
0mLMjDq7DRGZCNAdVF/CoOvou5UcPyoS+QcE6oWFhQJNRvvDyGic+us3OJs8
B6V5cShemYbvFs/D8UGD8MFf/iLJscfuXbvk8CpTb2ZQw+GjCr1XVh2CCusR
TnDFPN7QDP0GM4asa8QAcgB9Cs1wW26GS149uqcZ0XmG1ahJjmt7ckRZzBMN
iKR8GEE+ndIkSmMZ+hay+biD7KQaRWLGDqWMHIl+UTjK82NQvjRWQqyFIXc6
DNmTCPqxKuyOwp8Yo9ygC3NB0RQKXUZ0Vu19mlHMUUrlHMXncEtXwtDzZFNA
r28O38mlMPRffPGFavBd8U1KKo76DEF9aiiq44Jh2J+PwxlB2DPkYYH3zh3P
4+imNeLKuHOQI7ByF9GzBGw42dqMtQQWgRL/ZAMSnmpAHF2jnyB7pbJgSkFk
t2M2NGDEegKMwPJcZUbflWa4L6NEo6HbfAMeDLP2g7l1Sr92ZfNxN7KFd7pd
NlMhZg58XJo1HLoFM1C+JAaG5fGUElC+LE6C353ICILluGWqgTHRE8bYvjBE
u0MX4Y6zFM287/egFMt9YOql5lmjz2ELIb2hDPhWTr6YkDh9q/kUE3LiuxO4
eOwT/HTsGL6ZFYayBUEwvbkE5bszUZ01DufH++JvfkNxNHwMriVG4NyZM3j1
9dfEzEXDPPTh4Volw5+GwsiNJiQSCbM3m5H0lFkAF03WG76RrJeAmrS+AQE0
LI5Y3YAh1CM8iQiP5Q3wWEqJAPPILEfPcKv13lE2H3cjm487yI6rosCDj9JE
f+jzImFYkQjDytkwrkgSpJTnR8t1g64wJA2BId4T5TEeKI/2QFmUB86EeuDP
o3tKErg7MAE8yWWnL7uFCB3dbmeBvZLKBLOwPiUZlyZQwBw8FlWpMajdm42m
v29G7YFHoduYiO/jJkH/6ipUr4/Hy89sw4mvvsLLr7xME8i0au6LTCiLm1tF
aNGZu32lCtw48uRx5ELmbDEj+WmzuMbTfTRZbthj5M3XkTenWCWA4hffAgKO
yBhIgPVb0oD+ixvgubgOnlnlcJtpjYFI9oB2ZQtS7kI2H+3IZkoEPnyUJY+D
YWkcjAVzYCxMJmLmUA8hUhZHkwsLkz2FhuM5vtAnDIE+diD00f0o9UdpjCfO
zPTEu2PcpFj2SJaViGGnoAw5YOGGzPehY1DGnpbLF7w4QhMPJZm6VGqF4MYS
2FxetQDVz6TCtDNF8HJ6x1IczknAXxdFwnxkNYxPzsK+bVvx5ptvYt36dUyN
hRimKNno1oKUSQX1SN7agLRnzEjbJsFLIOBiGLj1JkwjtxNIoAUUEHDLTRia
b8IgAmxAHgGYa4JXHgX1BFyfyJaktC+bj7uRzccdZEeXqT2lLI0GiVXJMK5J
g3F1GgwFySgn16VfEmPpKbq4odDNGkQ9ZADKogeSp/PCzxFeeHdcH0mGZSmI
MWcyZE/ptpHYcG/NRsQFtbfoBSOWsVuEnEc+wtnN8RSdTRAMfJufhK83r8Hh
lCmkWDguzguEfowPSv7rJe4pKhsVGhYk1paYDb2KWOg6EzKeMyNreyMynjUj
ZasZiU+aEUM+JYz8yTRCK3AlIUbmPmKJCd55JgxeZMLAHEKLrsNyazFsgQ59
Iz+1sqFXB5G2svm4G9l8tCNbrtBFloi8PjsUxvUZMG7IktdVKTAsS7QMIhzh
tjxKowejNHIgXb1QEjsMP0UNw6EJfVuzwoywtxJdRJDS6XZSEstakqIRE7EH
cH7kUHw81hcn/Efg26jxwmPxuPGsh5vgo2hOKD56ZS/KS4rxP3t2aa1c9G7D
Re4LjVi8qxHZzzcinSx4Do0jsWS9EeROgml6FUR4cYD6COE1nPDyJpyGEhc+
ZL2+ZL0+WTp4RLXkwqE92eqUoWt79eRCZAucK57IReVTi1Hxh2yy/nTFEjrp
MoOhSwtC2VxL6NSF/M9QlMaS8cX54sdoHxyc4NEMssXsJchW03eTKI/7joaR
0xJlXq1llOcZhOknJSXB+NYbwvy/KiwQgwI7Hh4oLCa/f4wvLn7woXBa6lDN
IZNBwOzeAmb20Mv2NGLFXglH1nONSCEnlPi4GdHkucPWNGAqOYhAchABS+sx
iobfERRc+hLcIyiNJLh8F+jxcNQx63BqgbmNbBXmB9qr1wpm9uxVW5eh6pkV
DLVlbqDPjYZuYRhNgKfSZDgQpbMDFMuz0vgRKI4fSSj74mDgwxZVxp5ml+v7
rUR58H6lhS27v8PTXyhTGOUiuU7O9ixRttgyz7R+OHQIl+fMQt3mBahbG4Gq
CH+ceWwtLuRm4mDAeNy4cQNNJtOdQeb4ZN1rjdiwrxErCYxFO6UPSN4ivT0D
HUrD47RCBroe48mmA/Lr4Z8vlxVG5dXAl2yyBchWW24j2zr9badeK5A5rqne
uQ7VuzYQ0CthPvGFLCdPbliaoKIdSmhPE2iXJY8Xz+s+OYjSJD8UJ4zCjzFW
tG8Du4VJO/8W2DxOUqMIa1L/u5mhqK+Qc9z6rz+DzneoyDPC1TRT46UfRlzO
f9uDe+7TDdj2dhO2H2zCpjck5GzbC//TjPRn5CCbSLDFUcgYucGECEoc308h
lxJYwNCTC8gsg3v4Jy3g9v09ZLeixLhqLq68sg1X923H5Rc3CVqEq9m4EMa1
6TBw9LM8kSZscURPJKUIMXfQZUwRPr5kdgBOR/ngwFj3u6TE/7jcPQo7S17m
HIFZTEknKOEVHkmJg/A0Fgo4VUSFUymRQNL5XaaREn9rbrkro6URmzeSjuwd
Zuz5oAkvHb4uoFv/eiMKXmrE0hcbhRfOfp5GRYIvc7tZxCocs8RTdB9F7iOY
esW4ZbXwnl8G11Dr4mTCJZWOf7FsaZgqHRWbsnHtrT2oOfCSoKV653pUPVuA
yi1LxShgpBGggkbciscyZRy0imOgeOgXRxEtwbhEgevpCG+8PdpVpWPcd3dw
R/at6NCEnOI2nuOXiRFGmIJJuiMOtEwAZSu++lL0AknCHajo3YKF1S83Yse7
Tdj9fhO2/HcjHqV7ds65L5iRs0OiNJ/ik3T2S/9Bc6stDYglQ565QRqv/5Ja
DEotw6jUr6GvvqGy8LvJji1RHhKyq7evxtU3duDa/t248tIWVG1/FJU0OFQS
AxWbcgQDxnXzKaXD+Ch1kILZND2Ipc4xU3SMkiR/nAodhI8iR0FfeV2OrOyK
mIaBR5iGFiwM3i9ZmPZ32EW1YoH7hZJuYN2yKhxhl10lcrzhmEmTuPQKfspJ
a/VJvZp7gjNydlfigv4mCsk6OQ5M2iynR+EUifMCGzkJkj250KTBxJV0Gp1f
rzhiFM1WvRfWo3/aVQQsKsHp87XI2VUhwXfm7P9baI87CVW3hEuQs9OA65cu
kLEXknFn0IwrSc62csIpzJnOPocXb+ZP1pDbmaihgXg0qVpKA0JJtDcuhPTH
qYQAXC06jZytxRqxyKyVsEq8LWavEWv/9ha0pQtKOMdOvZhrMJ5ZFRaUs6vo
zUWXNZzjxT160ox8BQf1cjhwEzvGWjjM0yPnj1XQX76hbmo6iXsuF3M7Su2+
s5vemV0mxydCxCFeIsKGaX1nazEcJp5oNiZunM9hi4t1fV38UkGUcgAX+b3Y
dFdbZt+yZdwaLbeLSvNqRQtlY+VOt0yuPIEcxk10bO7cMiaUW+QJl0SX0fCe
P+/+X7DnYZaXpM/yjxF+ZLx46GVfb0nkjDSW9VKpr2gcccH62rdRVWi06LIW
mvwaZ2iXsQ+irLpfzbvfdJ7Ou/KUW1BNH9RmVgmCNGkVIrHioltoWXMtq96s
uSJ+riDRiihShOaKvYwVgn+UOLu/IzYxREe1qsomy8BaYKQPC7WWmaBdfp33
O6EU3mT1Cpg49V5cLXl6wnn+aCHvmHO548pbvGGqePPTXrydxPuqBXJzSa1k
L953Fj894O0pAUV2jVjU53VO8aMCvootfl617CTvm4lt+ZMGnrlr1EWbVLGa
wwbIjQ+6oKgt16jhLvcWxtRxUb1orlTfZT0NMg89SSfPbTwlGbodGL5DJHpK
Zy38diNY5uihKNNwTotBWyw1qK5aX57pibVMSHbgb2jl15yW3xTWWCdmK6yc
qqlWDnmkKP+UgdQkNLmKIjQkMFksf87vObBWGgTupFPQi3DGlD1w5Vwva86B
c9RuyvJ7La9EAOUcWY5GtMKeP8P73tLk/b6Rc4TmX/5Efi/wY9WEnYmfy1Dg
KcZ+nmtJT2+9Wr0MD62pwtuItbYKscTWi9cme/EU1t6yxMPbluoqnFYlNE5k
eQ2DV7YiDdZ5kthrE2VVMh8pOnSojn96I6b4BjVVyY2OKacd1F5g939diJe2
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,40"},
 CellLabel->"Out[27]=",
 CellID->35360647]
}, Open  ]],

Cell["Change the origin of the image:", "ExampleText",
 CellID->25191],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"SetPropertyValue", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<imagePanel\>\"", ",", "\"\<centerImage\>\""}], "}"}], ",", 
    " ", "False"}], "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,41"},
 CellLabel->"In[28]:=",
 CellID->9301],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<imagePanel\>\"", ",", "\"\<repaint\>\""}], "}"}], 
   "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,42"},
 CellLabel->"In[29]:=",
 CellID->378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,43"},
 CellLabel->"In[30]:=",
 CellID->25387],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWglUVMe2vXQziEajIoiRqKgoIhpBnEVFZJBJRhUZBBQExQmMUzRm0PhN
4o9G8/zmZXIly/+TqHnJS2I0Jj9menkvZmlMosThMXXTzeAENA0a3f+cqtvN
6Pv+tSJmfbm96t66de89p2rvU6dOVXVk+qrszKXpq3IWpA8IyUtfkZ2zIH9A
8PI8KtLaKIryGKVnBiicB2UtJy2UXnuhOD3PSVkrzopiC8XlEJR+b6hpnwNn
tJyz45w9lIfFLZ9kbl+znHywT6O+3G8ff9Hkgb1VlFZ9quYeaP4t3+7j6ohq
vMl3UPr+2UatJ0nocxKdfH5F15Bz6B5fiM4zf6U22QYUkIwpFztB8b/AOT75
X7RXb/0vWsqmyDIN57SWl2XOvtUX8r2WoloL9b+oaf6ZEMWt8L8AZdwpKN7H
uDWtW9EzVg+XxZfRKeEitcJhVsVyKKHXFK38csTnDLHS+jP1EzCnToJYLeeh
/pQe4qyWKfLSg8/OnHcCHepT9VAeUMtIu9Tdobd99Pa73/U6+N51vVOY330d
eu+J3vvNnu9ZP/IpaBe9rezqPtPbDvxOuXhvxqM/iF5blV+r3kz+tFvLL9qw
iHapaYfedtDbtofr0Pt7e7iLHXrbS28rz9qht70ihftLb3tFoB1621uvbUu9
bUdG92IOdt/pvVdzgw69HXo79Hbo7dDbofePq/eur81NaTsyKvgXkdEfo6bt
thp/r3ZbOvS2j1116G0nfttcM7rP9N5vu2n3Tm+79KM2dnnuL73tsXvY9t5J
e+u1bam3dWT0B6lpu0ZkbawZ3V9622v//F79T6FD7/2l9//5/wTve72Ofuc6
9LZHZHT39U46B8X97Xuu17al3taRUesvHjpJpUUyhRdpoASepJdtAk/CZsYp
ToojNEGntJzVcLmilU/4Dbpz4bte/Jkz3/dTBQh5I4kP3+OszflF0ubQUhsx
doLfF2o0Uo0SVkAKIi+wjGh6I7KUriX0lM9UFlfMOctddIkXv0L6g4v4nmWG
l4o7e0tZINVimkiK+B86n6eck2XyblqzsinnWNvEX5VOUMYXcA7KmAKZ5yvX
fXwFt4xhfE4SbmlYeKWscnwpC5lbxhDPpbLkKihpl6HMr9ZCm3nNFtrsWlKq
zb4Om8Ui0Zt8popk3oTNwgZOCjUsrYFPv4kcQ5jcwLfymlgPZZ6JNNRAmVMn
NJpZ45w6KAm1UGJq+arhjC3nuKYxV6FEXJFX+Q5/F1FDeIVcseGm2TRtm0Pz
ts2lNiRVW670pTaN/96vTa/jFnF76M5+cQOdcn9zgHbJDeJ18S1nfqLhptFj
u6wbyPqzSdjlg6p16i/dFGX0TLn9ew7yvb01sEs3MyACBrtUM7L+VKN0F+90
gr7qN2Ttuga7WdXcMG4X2UJFS9YsLStp1jKbNBO3hs0xs0FliNrDzaEyh+U3
tXDIu2kL+5W36GEe6LQMvbmNijMWvVaHU+euwXP2V+g69WP0mPEZegZ9il5B
R9BzxhE4BR2DU/Bn6B70OboGfYHOQcfRacZXsA/4AtqpX8Bm6ldUoc/RP+oI
ThZcYnmKwE/x+d1lM7JsamxMWXtNuHzmFD6a4Yn9w7viwKgeeNenJ9727YW3
R/XEAV8nHKR0yKc73h/VFR+M7IwPR3TC+172eN9Tiw+H2uDQYAUHJvdHxc8n
BfrC+CzoS+QVC/S2LaHXMO5ULO3oukQ99zcBuIYBt4fDqlsaK+q9GXWNirr+
8k14phbCaVYh+iYUwn1eCTySizEkpQiD6TootQTulPpR6jtfD5dUPZxSytAt
SQ/HuWWwjS+DTRTVJegnQucTYUUW1O+CbCvqbMs/zPTEifFOODGlL07OcMfJ
EA9KQ3AyeDBOhQzCj8HuOB3UD78E9cUv011wZpoTfvHvhjMTHPHLGFv8OMoG
X3opeJeQF7L/BeqtDV41dmHq3ZCQkCDAtWVwXVRw+egWfQluSVfgueAqHsm+
itFLrsEv9xp8cqvhs7QaI5dXw2tFNTxW1KD/8hr0WVoLp8W16JpVC4e0Gmjm
ka+JJLUTjzQB927JJmhV2QXjuuF8oBsuRnjin7GPoDBhNIrm+KEowQdFs31Q
PHskShK8oIvzgC66P/QRfaAPdYI+sCt0UxxQNF6DHx9R8M4gxSI7ooY9dHNw
xeBGg0X/0829yXzpTQhcvL7vDXvodDr6uOTceRiMRk5k8JWVlXSmx4w5bHJv
cerTBJ9es2vgkVELnyW1mLCyFv6rTJTqMOlREyasNmHcGhN819bBe60ZHmvM
6L/ajD55ZvRYVo8u2WbYpdVCE0dG6P+5pQ3kXH3uhmzruMTHxcm9UBTugeJ4
H5QmTYAu1R+6+ZRSJ0GfOoHSOJSl+MKQ5A3jHA+Ux/dHeXQflIf1gHFGF+j8
7XBmtAbvDbGRsls6cp9vrdg7Qhl0Rh2jDHK8nW/15ALcnJwcajkRoBG4d8b5
8+fxzXPPiytxIBjhPF/5nj8iEjQ8JgvIeovx2E7UxTWxBiNptJtImE1fY6KO
xRV0hNeGegxeX4+H19TDOb8e3XLr4bigFnazDdBM/e8m9tm2nC7iDbe2vrOO
93z8c5orimNGojR5InQZ02E6/pEoL8sMpBSAsoX+MGSMhzHNF+XJXqhIHCye
mz/Zh/LQbtBPc8TZsXb4y1ANF2sYWDbrAKOE1vs7K7S2jdAy8DGVGsaWY0BC
l0FioxbIUu0ZQMrh79mLUJ4Ug6NHj0qg6Xp8904Bbk1NDX8nx1cNg+oqIhuJ
SL+UGoxdRmiQ9c18rBHZERvJAgnZfoRsb0K2x1Kz8ABdEg1igLMg20DotSFH
lIU9bkbo43UI2lSHgCfIyuk6ZpO5mWw+2pAtIyyKlvgoJHdcMnesQF6/aKZW
PLdDWXYQDIsCYFg4CcaMMahIHaHIZ52FUZfN6Iqzk7rg/eH2UqTFmBl1dhsi
MhGg26m+hEHXkd4Kjh8VifwDAvX8/HyBJqP9UXgkTv3tW5xNnIOSnBgUrkzB
94vn4figQfjwr3+V5Nhi965dcniVqTczqOHwUYXeI6MG/vm1CCW4op6oa4R+
gxlD1tVjADmAPvlmuCw3wymnFt1TjOg8w2rUJMe5LTmiLOrJOoRTPoQgn05p
MqWxDH0T2XzcRnbCNUVixg6llByJflEoynKjULY0WkKshSF7OgyZkwn6sSrs
9sKfGCNcoAtxQsFUCl1GdFbtPcAo5iglco7idbipK2HoeSYpoNc3hu/kUhj6
L7/8UjX4rvg2KRlHvYagNjkYVTGBMOzPxeE0f+wZ8rDAe+eOF3B00xpxZdw5
yBFYuYroWQI2nGxtxloCi0CJfaoOcU/XIYaukU+SvVJZICV/stsxG+owYj0B
RmC5rzKj70ozXJdRotHQZb4BD4ZY+8HcGqVfm7L5uBPZwju1ls1UiJkDH8Wz
hkO3YAbKlkTBsDyWUhzKlsVI8LsTGf6wHLdM12CMd4cxui8Mka7QhbniLEUz
H/g8KMVyH5hW3Dhr9DpsIaQ3lAHfyckXExKjbzafYkJOfH8CF499ip+PHcO3
s0JQusAfpreWoGx3OqoyxuH8eG/83WcojoaOwdX4MJw7cwavvfG6mLlomIc+
PFyrZPjSUBi+0YR4ImH2ZjMSnjYL4CLJekM3kvUSUJPX18GPhsURq+swhHqE
OxHhtrwObkspEWBu6WXoGWq13tvK5uNOZPNxG9kxlRR48FES7wt9TjgMK+Jh
WDkbxhUJgpSy3EjRvclYDQlDYIh1R1mUG8oi3VAa4YYzwW74y+iekgTuDkwA
T3LZ6ctuIUJHl9YssFdSmWAW1iclongCBcyBY1GZHIXqvZlo+MdmVB94FLqN
8fghZjL0r61C1fpYvPLsNpz4+mu88uorNIFMqeK+yISyuLmVhBadudtXqMCN
I08eQy5kzhYzEp8xi2ss3UeS5YY8Rt58HXlzilX8KH7xziPgiIyBBFi/JXXo
v7gO7otr4J5RBpeZ1hiIZA9oU7Yg5Q5k89GGbKZE4MNHaeI4GJbGwJg3B8b8
RCJmDvUQImVxJLmwENlTaDie4w193BDoowdCH9mPUn+URLnjzEx3vDfGRYpl
j2RZiRh2CsqQAxZuyHwfOgZl7Gm5fMGLIzTxUBKpSyWXC24sgc2lVQtQ9Wwy
TDuTBC+ndyzF4aw4/G1ROMxHVsP41Czs27YVb731FtatX8fUWIhhihKNLk1I
mZxXi8StdUh51oyUbRK8OAIuioFbb0IAuZ2JBJpfHgG33IShuSYMIsAG5BCA
2SZ45FBQT8D1CW9KStuy+bgT2XzcRnZkqdpTSlNokFiVCOOaFBhXp8CQl4gy
cl36JVGWnqKLGQrdrEHUQwagNHIgeToP/BLmgffG9ZFkWJaCGHMmQ/aUbhuJ
DdfmbIRdUHuLXjBiGbtFyHnkY5zdHEvR2QTBwHe5Cfhm8xocTppKFQvFxXkT
oR/jhaL/eJl7ispGuYYFibUlZkOvIha8zoS0583I2F6PtOfMSNpqRvxTZkSR
TwkhfxJAaE1cSYiRuY9YYoJnjgmDF5kwMIvQouuw7GoMW6BD3/DPrGzo1UGk
pWw+7kQ2H23Ilit04UUir88MhnF9GowbMuR1VRIMy+ItgwhHuE2PksjBKAkf
SFcPFEUPw88Rw3BoQt/mrDAj7K1EFxGkdGpNSnxpU1I0YiL2AM6PHIpPxnrj
hO8IfBcxXngsHjeec3MRfBTMCcbHr+5FWVEh/mvPLq2Vi94tuMh+sR6Ld9Uj
84V6pJIFz6FxJJqsN4zcSSBNr/wJLw5QHyG8hhNenoTTUOLCi6zXm6zXK0MH
t4imXNi1JVudMnRt6zu5ENkE5/Ins1Hx9GKUP55J1p+qWEInXXogdCn+KJ1r
CZ26kP8ZipJoMr4Yb/wU6YWDE9waQbaYvQTZavouEuVx39MwclqizKu1jPI8
gzD9hIQEGN9+U5j/1/l5YlBgx8MDhcXk94/xxsUPPxJOSx2qOWQyCJhdm8DM
HnrZnnqs2CvhyHi+HknkhOKfMCOSPHfImjpMIwcxkRyE39JajKLhdwQFl94E
9whKIwku7wV6PBxxzDqcWmBuIVuF+YG2vmsGM3v2yq3LUPnsCobaMjfQZ0dC
tzCEJsDTaDI8ESWz/RTLs5LYESiMHUkoe+PgxIctVRl7ml2u93cS5cH7lSa2
7PouT3+hTGWUC+Q6OduzRNliyzzT+vHQIVyaMws1mxegZm0YKsN8ceaxtbiQ
nY6DfuNx48YNNJhMtweZ45N1r9djw756rCQwFu2UPiBxi/T2DHQwDY8B+Qx0
LcaTTfvl1sI3Vy4rjMq5Bm+yySYgW225hWzr9LeN75qBzHFN1c51qNq1gYBe
CfOJL2U5eXLD0jgV7WBCO0CgXZo4Xjyv+fQgShJ8UBg3Cj9FWdFuBXYTk3b8
38DmcZIaRVhT9b+fGYzacjnHrf3mc+i8h4o8I1xFMzVe+mHE5fy3LbjnPlOH
be80YPvBBmx6U0LOtr3w381IfVYOsvEEWwyFjOEbTAijxPH9VHIpE/MYenIB
6aVwDf20Cdzed0N2M0qMq+bi8qvbcGXfdlx6aZOgRbiajQthXJsKA0c/y+Np
whZD9IRTChNzB13aVOHji2b74XSEFw6Mdb1DSnyPy92jkLPkZc4RmIWUdIIS
XuGRlNgJT2OhgFN5RCiVEgkknd9lGimxrrllzoyWRmzeSDoyd5ix58MGvHz4
uoBu/Rv1yHu5HktfqhdeOPMFGhUJvvTtZhGrcMwSS9F9BLmPQOoV45ZVw3N+
KZyDrYuTccUqHb+zbGmYKh3lmzJx9e09uHbgZUFL1c71qHwuDxVblopRwEgj
QDmNuOWPpcs4aBXHQLHQL44gWgJRTIHr6TBPvDPaWaVj3Pe3cUe2zejQBJ3i
Np7jl4kRRpiCSbojDrRMAGXLv/5K9AJJwm2o6N2EhdWv1GPHew3Y/UEDtvxn
PR6le3bO2S+akbVDojSf4pNU9kv/RnOrLXWIJkOeuUEar++SagxKLsWo5G+g
r7qhsnDXZEcXKQ8J2VXbV+PKmztwdf9uXH55Cyq3P4oKGhwqiIHyTVmCAeO6
+ZRSYXyUOkjebJoeRFPnmCk6RlGCL04FD8LH4aOgr7guR1Z2RUzDwCNMQxMW
Bu+XLAT8AzYRzVjgfqGkGrhuGeX2sMmsFDnecEynSVxqOT/lpLX6pF6NPcER
WbsrcEF/E/lknRwHJmyW06NQisR5gY2cBMmekm/SYNJKOo3OrVXsMYpmq54L
a9E/5Qr8FhXh9PlqZO0ql+A7cvb/LLTH7YSqW8JFyNppwPXiC2Ts+WTcaTTj
SpCzraxQCnOms8/hxZv5UzTkdiZpaCAeTVUtoQGhKNITF4L641ScH64UnEbW
1kKNWGTWSlgl3haz14i1f1sL2tIFxZ1jp17IXzCeGeUWlDMr6c1FlzSc48U9
etKIfDkH9XI4cBE7xlrYzdMj60+V0F+6oW5qOoh7LhdzO0ptvrOb3pldKscn
QsQuViLChml9Z2sh7CadaDQmbpzXYYuLdX5D/ElBlHIAF/6D2HRXW2bbtGXc
Gi23i0pzqkULZWPlTrdMzjyBHMZNtG/s3DImlFvkccWiy2h4z593/y/Y8jDL
S9Jn+c8IPzFePPSyr7ckckYay3qprK9oHHHB9bVtUVVRo0WXtNDkXnOEdhn7
IMqq+9W8+03n6bwrT7kFVaRQm14pCNKklIvEFRfdQss113LVG2uuiL8rSLTC
ChRRc8VWxgqBP0mcXd8Vmxiio1qryibLwFpgJMWiWstM0C6/zvudUPJvcvXy
mDj1XlwteXrCeVaazzvmXG6/8hZvmCqe/LQXbyfxvmqe3FxSP7IV7zuKvx7w
9pSAIvOaWNTndU7xpwK+ii1+XrXsJO8biW36lwaeuWvURZtksZrDBsiN97+g
qC3XqOEu9xbG1H5RrWiurL7TehpkHnqKTu7beEoydDswfIdI9JTOWvjsRqDM
0UNRpuGcFoO2WL6gb9Xv5ZmeWMuEZDvWoZXaHJbfFNZYI2YrXDm1plo55FFF
+a8MVE1Ckz9RRA0JTBbL6nyeB9dKg4k76eT/EhwxdQ+cOdfLmrPjHLWbsvxe
0ysRQDl7lqMRrbBlNbzvLU3e51s5R5Dhsvh7yw8CP66asDPxdxkKPMXYz3Mt
6emtV6uX4aE1WXgbsdZWLpbYevHaZC+ewtpalnh421JdhdOqhMaILK9h8MpW
uME6TxJ7baKsUubDRYcO1vFfb8QU36CmSrnRMfW0ndoLbP4Hjw9L5g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,43"},
 CellLabel->"Out[30]=",
 CellID->647028045]
}, Open  ]],

Cell[TextData[{
 "The method ",
 Cell[BoxData["\"\<fillImagePixels\>\""], "InlineFormula"],
 " fills individual pixels of the image:"
}], "ExampleText",
 CellID->13500],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<imagePanel\>\"", ",", "\"\<fillImagePixels\>\""}], "}"}], 
    ",", "  ", 
    RowBox[{"Random", "[", 
     RowBox[{"Integer", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "]"}], ",", " ", "True"}], 
   "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,44"},
 CellLabel->"In[31]:=",
 CellID->6615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,45"},
 CellLabel->"In[32]:=",
 CellID->12709],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,45"},
 CellLabel->"Out[32]=",
 CellID->393981864]
}, Open  ]],

Cell[TextData[{
 "The method ",
 Cell[BoxData["\"\<fillImagePixelArray\>\""], "InlineFormula"],
 " fills an array of explicit locations:"
}], "ExampleText",
 CellID->25061],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<imagePanel\>\"", ",", "\"\<fillImagePixelArray\>\""}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", "  ", 
    RowBox[{"Random", "[", 
     RowBox[{"Integer", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "]"}], ",", " ", "True"}], 
   "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,46"},
 CellLabel->"In[33]:=",
 CellID->19952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,47"},
 CellLabel->"In[34]:=",
 CellID->10970],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,47"},
 CellLabel->"Out[34]=",
 CellID->555734367]
}, Open  ]],

Cell[TextData[{
 "It also fills a region given by an origin ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " value coupled with relative offset locations:"
}], "ExampleText",
 CellID->18064],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<imagePanel\>\"", ",", "\"\<fillImagePixelArray\>\""}], 
     "}"}], ",", "2", ",", "2", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", "  ", 
    RowBox[{"Random", "[", 
     RowBox[{"Integer", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "]"}], ",", " ", "True"}], 
   "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,48"},
 CellLabel->"In[35]:=",
 CellID->32537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,49"},
 CellLabel->"In[36]:=",
 CellID->22050],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,49"},
 CellLabel->"Out[36]=",
 CellID->220942246]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<imagePanel\>\"", ",", "\"\<fillImagePixelArray\>\""}], 
     "}"}], ",", "0", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "}"}], ",", "  ", 
    RowBox[{"Random", "[", 
     RowBox[{"Integer", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "]"}], ",", " ", "True"}], 
   "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,50"},
 CellLabel->"In[37]:=",
 CellID->28791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GUIScreenShot", "[", "ref", "]"}], " "}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,51"},
 CellLabel->"In[38]:=",
 CellID->12978],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,51"},
 CellLabel->"Out[38]=",
 CellID->96248985]
}, Open  ]],

Cell[TextData[{
 "The method ",
 Cell[BoxData["\"\<fillImagePixelRect\>\""], "InlineFormula"],
 " fills a rectangular region:"
}], "ExampleText",
 CellID->7161],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<imagePanel\>\"", ",", "\"\<fillImagePixelRect\>\""}], "}"}],
     ",", "1", ",", "1", ",", "2", ",", "3", ",", "  ", 
    RowBox[{"Random", "[", 
     RowBox[{"Integer", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "]"}], ",", " ", "True"}], 
   "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,52"},
 CellLabel->"In[39]:=",
 CellID->4821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GUIScreenShot", "[", "ref", "]"}], " "}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,53"},
 CellLabel->"In[40]:=",
 CellID->2718],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,53"},
 CellLabel->"Out[40]=",
 CellID->689861177]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData["\"\<setImagePixelRect\>\""], "InlineFormula"],
 ", the region can be also be specified by its top-left location:"
}], "ExampleText",
 CellID->15183],

Cell[BoxData[
 RowBox[{"ref", " ", "@", " ", 
  RowBox[{"InvokeMethod", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<imagePanel\>\"", ",", "\"\<setImagePixelRect\>\""}], "}"}], 
    ",", "1", ",", "1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], "}"}], ",", " ", "True"}], 
   "]"}]}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,54"},
 CellLabel->"In[41]:=",
 CellID->16933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GUIScreenShot", "[", "ref", "]"}], " "}]], "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,55"},
 CellLabel->"In[42]:=",
 CellID->8695],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,55"},
 CellLabel->"Out[42]=",
 CellID->613116938]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2549],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26994]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13004],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"IndexedImagePanel\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 33.3830000}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"IndexedImagePanel\"Widget[\"IndexedImagePanel\"] represents an indexed \
image panel.", "synonyms" -> {"indexed image panel"}, "title" -> 
    "IndexedImagePanel", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/IndexedImagePanel"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "IndexedImagePanel"->{
  Cell[2844, 96, 232, 6, 70, "Notes",
   CellTags->"IndexedImagePanel",
   CellID->32315],
  Cell[5936, 183, 889, 28, 70, "Notes",
   CellTags->"IndexedImagePanel",
   CellID->19412],
  Cell[17852, 454, 525, 14, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,20"},
   CellID->25283],
  Cell[18402, 472, 172, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,21"},
   CellID->30873],
  Cell[18577, 478, 7496, 127, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,21"},
   CellID->407546298],
  Cell[26182, 611, 815, 22, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,22"},
   CellID->8835],
  Cell[27022, 637, 172, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,23"},
   CellID->24987],
  Cell[27197, 643, 7598, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,23"},
   CellID->236786575],
  Cell[34952, 781, 916, 26, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,24"},
   CellID->7629],
  Cell[35893, 811, 171, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,25"},
   CellID->5560],
  Cell[36067, 817, 7598, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,25"},
   CellID->314772497],
  Cell[43758, 952, 294, 8, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,26"},
   CellID->32189],
  Cell[44077, 964, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,27"},
   CellID->13163],
  Cell[44253, 970, 7597, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,27"},
   CellID->5716384],
  Cell[52175, 1114, 937, 26, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,28"},
   CellID->24705],
  Cell[53137, 1144, 172, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,29"},
   CellID->2815],
  Cell[53312, 1150, 7602, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,29"},
   CellID->77899395],
  Cell[61031, 1286, 1450, 42, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,30"},
   CellID->16999],
  Cell[62506, 1332, 191, 5, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,31"},
   CellID->13137],
  Cell[62700, 1339, 7537, 128, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,31"},
   CellID->51074597],
  Cell[70311, 1473, 330, 9, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,32"},
   CellID->32058],
  Cell[70644, 1484, 289, 8, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,33"},
   CellID->23511],
  Cell[70958, 1496, 172, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,34"},
   CellID->8383],
  Cell[71133, 1502, 7658, 130, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,34"},
   CellID->9959186],
  Cell[78885, 1638, 638, 16, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,35"},
   CellID->32737],
  Cell[79526, 1656, 289, 8, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,36"},
   CellID->29831],
  Cell[79840, 1668, 158, 5, 70, "Input",
   CellTags->"IndexedImagePanel",
   CellID->28655],
  Cell[80001, 1675, 3421, 61, 70, "Output",
   Evaluatable->False,
   CellTags->"IndexedImagePanel",
   CellID->11919595],
  Cell[83549, 1744, 298, 9, 70, "Input",
   CellTags->"IndexedImagePanel",
   CellID->13290],
  Cell[83850, 1755, 256, 8, 70, "Input",
   CellTags->"IndexedImagePanel",
   CellID->16052],
  Cell[84131, 1767, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,37"},
   CellID->12295],
  Cell[84307, 1773, 7660, 130, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,37"},
   CellID->189452871],
  Cell[92050, 1909, 346, 9, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,38"},
   CellID->14360],
  Cell[92399, 1920, 289, 8, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,39"},
   CellID->29767],
  Cell[92713, 1932, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,40"},
   CellID->15273],
  Cell[92889, 1938, 7659, 130, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,40"},
   CellID->35360647],
  Cell[100636, 2074, 332, 9, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,41"},
   CellID->9301],
  Cell[100971, 2085, 287, 8, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,42"},
   CellID->378],
  Cell[101283, 2097, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,43"},
   CellID->25387],
  Cell[101459, 2103, 7655, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,43"},
   CellID->647028045],
  Cell[109300, 2242, 473, 14, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,44"},
   CellID->6615],
  Cell[109798, 2260, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,45"},
   CellID->12709],
  Cell[109974, 2266, 7700, 130, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,45"},
   CellID->393981864],
  Cell[117864, 2406, 715, 22, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,46"},
   CellID->19952],
  Cell[118604, 2432, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,47"},
   CellID->10970],
  Cell[118780, 2438, 8880, 150, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,47"},
   CellID->555734367],
  Cell[127952, 2602, 735, 22, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,48"},
   CellID->32537],
  Cell[128712, 2628, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,49"},
   CellID->22050],
  Cell[128888, 2634, 7753, 131, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,49"},
   CellID->220942246],
  Cell[136656, 2768, 735, 22, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,50"},
   CellID->28791],
  Cell[137416, 2794, 191, 5, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,51"},
   CellID->12978],
  Cell[137610, 2801, 7748, 131, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,51"},
   CellID->96248985],
  Cell[145536, 2942, 516, 14, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,52"},
   CellID->4821],
  Cell[146077, 2960, 190, 5, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,53"},
   CellID->2718],
  Cell[146270, 2967, 7741, 131, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,53"},
   CellID->689861177],
  Cell[154218, 3108, 549, 16, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,54"},
   CellID->16933],
  Cell[154792, 3128, 190, 5, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,55"},
   CellID->8695],
  Cell[154985, 3135, 7753, 131, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,55"},
   CellID->613116938]},
 "PrimaryExamplesSection"->{
  Cell[6862, 216, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->99051516]},
 "Ex--21907299533234115765,18"->{
  Cell[7684, 250, 2100, 50, 70, "Input",
   CellTags->"Ex--21907299533234115765,18",
   CellID->7761],
  Cell[9787, 302, 307, 8, 70, "Output",
   CellTags->"Ex--21907299533234115765,18",
   CellID->9133]},
 "Ex--21907299533234115765,19"->{
  Cell[10131, 315, 149, 4, 70, "Input",
   CellTags->"Ex--21907299533234115765,19",
   CellID->12930],
  Cell[10283, 321, 7489, 127, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21907299533234115765,19",
   CellID->419017098]},
 "Ex--21907299533234115765,20"->{
  Cell[17852, 454, 525, 14, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,20"},
   CellID->25283]},
 "Ex--21907299533234115765,21"->{
  Cell[18402, 472, 172, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,21"},
   CellID->30873],
  Cell[18577, 478, 7496, 127, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,21"},
   CellID->407546298]},
 "Ex--21907299533234115765,22"->{
  Cell[26182, 611, 815, 22, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,22"},
   CellID->8835]},
 "Ex--21907299533234115765,23"->{
  Cell[27022, 637, 172, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,23"},
   CellID->24987],
  Cell[27197, 643, 7598, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,23"},
   CellID->236786575]},
 "Ex--21907299533234115765,24"->{
  Cell[34952, 781, 916, 26, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,24"},
   CellID->7629]},
 "Ex--21907299533234115765,25"->{
  Cell[35893, 811, 171, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,25"},
   CellID->5560],
  Cell[36067, 817, 7598, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,25"},
   CellID->314772497]},
 "Ex--21907299533234115765,26"->{
  Cell[43758, 952, 294, 8, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,26"},
   CellID->32189]},
 "Ex--21907299533234115765,27"->{
  Cell[44077, 964, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,27"},
   CellID->13163],
  Cell[44253, 970, 7597, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,27"},
   CellID->5716384]},
 "Ex--21907299533234115765,28"->{
  Cell[52175, 1114, 937, 26, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,28"},
   CellID->24705]},
 "Ex--21907299533234115765,29"->{
  Cell[53137, 1144, 172, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,29"},
   CellID->2815],
  Cell[53312, 1150, 7602, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,29"},
   CellID->77899395]},
 "Ex--21907299533234115765,30"->{
  Cell[61031, 1286, 1450, 42, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,30"},
   CellID->16999]},
 "Ex--21907299533234115765,31"->{
  Cell[62506, 1332, 191, 5, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,31"},
   CellID->13137],
  Cell[62700, 1339, 7537, 128, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,31"},
   CellID->51074597]},
 "Ex--21907299533234115765,32"->{
  Cell[70311, 1473, 330, 9, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,32"},
   CellID->32058]},
 "Ex--21907299533234115765,33"->{
  Cell[70644, 1484, 289, 8, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,33"},
   CellID->23511]},
 "Ex--21907299533234115765,34"->{
  Cell[70958, 1496, 172, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,34"},
   CellID->8383],
  Cell[71133, 1502, 7658, 130, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,34"},
   CellID->9959186]},
 "Ex--21907299533234115765,35"->{
  Cell[78885, 1638, 638, 16, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,35"},
   CellID->32737]},
 "Ex--21907299533234115765,36"->{
  Cell[79526, 1656, 289, 8, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,36"},
   CellID->29831]},
 "Ex--21907299533234115765,37"->{
  Cell[84131, 1767, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,37"},
   CellID->12295],
  Cell[84307, 1773, 7660, 130, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,37"},
   CellID->189452871]},
 "Ex--21907299533234115765,38"->{
  Cell[92050, 1909, 346, 9, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,38"},
   CellID->14360]},
 "Ex--21907299533234115765,39"->{
  Cell[92399, 1920, 289, 8, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,39"},
   CellID->29767]},
 "Ex--21907299533234115765,40"->{
  Cell[92713, 1932, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,40"},
   CellID->15273],
  Cell[92889, 1938, 7659, 130, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,40"},
   CellID->35360647]},
 "Ex--21907299533234115765,41"->{
  Cell[100636, 2074, 332, 9, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,41"},
   CellID->9301]},
 "Ex--21907299533234115765,42"->{
  Cell[100971, 2085, 287, 8, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,42"},
   CellID->378]},
 "Ex--21907299533234115765,43"->{
  Cell[101283, 2097, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,43"},
   CellID->25387],
  Cell[101459, 2103, 7655, 129, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,43"},
   CellID->647028045]},
 "Ex--21907299533234115765,44"->{
  Cell[109300, 2242, 473, 14, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,44"},
   CellID->6615]},
 "Ex--21907299533234115765,45"->{
  Cell[109798, 2260, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,45"},
   CellID->12709],
  Cell[109974, 2266, 7700, 130, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,45"},
   CellID->393981864]},
 "Ex--21907299533234115765,46"->{
  Cell[117864, 2406, 715, 22, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,46"},
   CellID->19952]},
 "Ex--21907299533234115765,47"->{
  Cell[118604, 2432, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,47"},
   CellID->10970],
  Cell[118780, 2438, 8880, 150, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,47"},
   CellID->555734367]},
 "Ex--21907299533234115765,48"->{
  Cell[127952, 2602, 735, 22, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,48"},
   CellID->32537]},
 "Ex--21907299533234115765,49"->{
  Cell[128712, 2628, 173, 4, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,49"},
   CellID->22050],
  Cell[128888, 2634, 7753, 131, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,49"},
   CellID->220942246]},
 "Ex--21907299533234115765,50"->{
  Cell[136656, 2768, 735, 22, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,50"},
   CellID->28791]},
 "Ex--21907299533234115765,51"->{
  Cell[137416, 2794, 191, 5, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,51"},
   CellID->12978],
  Cell[137610, 2801, 7748, 131, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,51"},
   CellID->96248985]},
 "Ex--21907299533234115765,52"->{
  Cell[145536, 2942, 516, 14, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,52"},
   CellID->4821]},
 "Ex--21907299533234115765,53"->{
  Cell[146077, 2960, 190, 5, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,53"},
   CellID->2718],
  Cell[146270, 2967, 7741, 131, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,53"},
   CellID->689861177]},
 "Ex--21907299533234115765,54"->{
  Cell[154218, 3108, 549, 16, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,54"},
   CellID->16933]},
 "Ex--21907299533234115765,55"->{
  Cell[154792, 3128, 190, 5, 70, "Input",
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,55"},
   CellID->8695],
  Cell[154985, 3135, 7753, 131, 70, "Output",
   Evaluatable->False,
   CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,55"},
   CellID->613116938]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"IndexedImagePanel", 165331, 3357},
 {"PrimaryExamplesSection", 173053, 3549},
 {"Ex--21907299533234115765,18", 173206, 3553},
 {"Ex--21907299533234115765,19", 173446, 3560},
 {"Ex--21907299533234115765,20", 173718, 3568},
 {"Ex--21907299533234115765,21", 173880, 3572},
 {"Ex--21907299533234115765,22", 174198, 3580},
 {"Ex--21907299533234115765,23", 174359, 3584},
 {"Ex--21907299533234115765,24", 174677, 3592},
 {"Ex--21907299533234115765,25", 174838, 3596},
 {"Ex--21907299533234115765,26", 175155, 3604},
 {"Ex--21907299533234115765,27", 175316, 3608},
 {"Ex--21907299533234115765,28", 175632, 3616},
 {"Ex--21907299533234115765,29", 175795, 3620},
 {"Ex--21907299533234115765,30", 176113, 3628},
 {"Ex--21907299533234115765,31", 176277, 3632},
 {"Ex--21907299533234115765,32", 176596, 3640},
 {"Ex--21907299533234115765,33", 176758, 3644},
 {"Ex--21907299533234115765,34", 176920, 3648},
 {"Ex--21907299533234115765,35", 177237, 3656},
 {"Ex--21907299533234115765,36", 177400, 3660},
 {"Ex--21907299533234115765,37", 177562, 3664},
 {"Ex--21907299533234115765,38", 177882, 3672},
 {"Ex--21907299533234115765,39", 178044, 3676},
 {"Ex--21907299533234115765,40", 178206, 3680},
 {"Ex--21907299533234115765,41", 178525, 3688},
 {"Ex--21907299533234115765,42", 178687, 3692},
 {"Ex--21907299533234115765,43", 178848, 3696},
 {"Ex--21907299533234115765,44", 179170, 3704},
 {"Ex--21907299533234115765,45", 179333, 3708},
 {"Ex--21907299533234115765,46", 179655, 3716},
 {"Ex--21907299533234115765,47", 179819, 3720},
 {"Ex--21907299533234115765,48", 180141, 3728},
 {"Ex--21907299533234115765,49", 180305, 3732},
 {"Ex--21907299533234115765,50", 180627, 3740},
 {"Ex--21907299533234115765,51", 180791, 3744},
 {"Ex--21907299533234115765,52", 181112, 3752},
 {"Ex--21907299533234115765,53", 181275, 3756},
 {"Ex--21907299533234115765,54", 181596, 3764},
 {"Ex--21907299533234115765,55", 181760, 3768}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1252, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1875, 59, 58, 1, 70, "ObjectName",
 CellID->5030],
Cell[1936, 62, 393, 12, 70, "Usage",
 CellID->19782]
}, Open  ]],
Cell[CellGroupData[{
Cell[2366, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2844, 96, 232, 6, 70, "Notes",
 CellTags->"IndexedImagePanel",
 CellID->32315],
Cell[3079, 104, 72, 1, 70, "Notes",
 CellID->32080],
Cell[3154, 107, 1559, 36, 70, "3ColumnTableMod",
 CellID->2021],
Cell[4716, 145, 67, 1, 70, "Notes",
 CellID->22425],
Cell[4786, 148, 500, 14, 70, "2ColumnTableMod",
 CellID->17752],
Cell[5289, 164, 67, 1, 70, "Notes",
 CellID->9204],
Cell[5359, 167, 574, 14, 70, "2ColumnTableMod",
 CellID->5446],
Cell[5936, 183, 889, 28, 70, "Notes",
 CellTags->"IndexedImagePanel",
 CellID->19412]
}, Closed]],
Cell[CellGroupData[{
Cell[6862, 216, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->99051516],
Cell[CellGroupData[{
Cell[7246, 230, 148, 5, 70, "ExampleSection",
 CellID->142111683],
Cell[7397, 237, 129, 3, 70, "Input",
 CellID->239152346],
Cell[7529, 242, 130, 4, 70, "ExampleText",
 CellID->2429],
Cell[CellGroupData[{
Cell[7684, 250, 2100, 50, 70, "Input",
 CellTags->"Ex--21907299533234115765,18",
 CellID->7761],
Cell[9787, 302, 307, 8, 70, "Output",
 CellTags->"Ex--21907299533234115765,18",
 CellID->9133]
}, Open  ]],
Cell[CellGroupData[{
Cell[10131, 315, 149, 4, 70, "Input",
 CellTags->"Ex--21907299533234115765,19",
 CellID->12930],
Cell[10283, 321, 7489, 127, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21907299533234115765,19",
 CellID->419017098]
}, Open  ]],
Cell[17787, 451, 62, 1, 70, "ExampleText",
 CellID->5532],
Cell[17852, 454, 525, 14, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,20"},
 CellID->25283],
Cell[CellGroupData[{
Cell[18402, 472, 172, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,21"},
 CellID->30873],
Cell[18577, 478, 7496, 127, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,21"},
 CellID->407546298]
}, Open  ]],
Cell[26088, 608, 91, 1, 70, "ExampleText",
 CellID->21880],
Cell[26182, 611, 815, 22, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,22"},
 CellID->8835],
Cell[CellGroupData[{
Cell[27022, 637, 172, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,23"},
 CellID->24987],
Cell[27197, 643, 7598, 129, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,23"},
 CellID->236786575]
}, Open  ]],
Cell[34810, 775, 139, 4, 70, "ExampleText",
 CellID->25589],
Cell[34952, 781, 916, 26, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,24"},
 CellID->7629],
Cell[CellGroupData[{
Cell[35893, 811, 171, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,25"},
 CellID->5560],
Cell[36067, 817, 7598, 129, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,25"},
 CellID->314772497]
}, Open  ]],
Cell[43680, 949, 75, 1, 70, "ExampleText",
 CellID->10597],
Cell[43758, 952, 294, 8, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,26"},
 CellID->32189],
Cell[CellGroupData[{
Cell[44077, 964, 173, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,27"},
 CellID->13163],
Cell[44253, 970, 7597, 129, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,27"},
 CellID->5716384]
}, Open  ]],
Cell[51865, 1102, 307, 10, 70, "ExampleText",
 CellID->18621],
Cell[52175, 1114, 937, 26, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,28"},
 CellID->24705],
Cell[CellGroupData[{
Cell[53137, 1144, 172, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,29"},
 CellID->2815],
Cell[53312, 1150, 7602, 129, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,29"},
 CellID->77899395]
}, Open  ]],
Cell[60929, 1282, 99, 2, 70, "ExampleText",
 CellID->22334],
Cell[61031, 1286, 1450, 42, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,30"},
 CellID->16999],
Cell[CellGroupData[{
Cell[62506, 1332, 191, 5, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,31"},
 CellID->13137],
Cell[62700, 1339, 7537, 128, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,31"},
 CellID->51074597]
}, Open  ]],
Cell[70252, 1470, 56, 1, 70, "ExampleText",
 CellID->14164],
Cell[70311, 1473, 330, 9, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,32"},
 CellID->32058],
Cell[70644, 1484, 289, 8, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,33"},
 CellID->23511],
Cell[CellGroupData[{
Cell[70958, 1496, 172, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,34"},
 CellID->8383],
Cell[71133, 1502, 7658, 130, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,34"},
 CellID->9959186]
}, Open  ]],
Cell[78806, 1635, 76, 1, 70, "ExampleText",
 CellID->20943],
Cell[78885, 1638, 638, 16, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,35"},
 CellID->32737],
Cell[79526, 1656, 289, 8, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,36"},
 CellID->29831],
Cell[CellGroupData[{
Cell[79840, 1668, 158, 5, 70, "Input",
 CellTags->"IndexedImagePanel",
 CellID->28655],
Cell[80001, 1675, 3421, 61, 70, "Output",
 Evaluatable->False,
 CellTags->"IndexedImagePanel",
 CellID->11919595]
}, Open  ]],
Cell[83437, 1739, 109, 3, 70, "ExampleText",
 CellID->24351],
Cell[83549, 1744, 298, 9, 70, "Input",
 CellTags->"IndexedImagePanel",
 CellID->13290],
Cell[83850, 1755, 256, 8, 70, "Input",
 CellTags->"IndexedImagePanel",
 CellID->16052],
Cell[CellGroupData[{
Cell[84131, 1767, 173, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,37"},
 CellID->12295],
Cell[84307, 1773, 7660, 130, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,37"},
 CellID->189452871]
}, Open  ]],
Cell[91982, 1906, 65, 1, 70, "ExampleText",
 CellID->24061],
Cell[92050, 1909, 346, 9, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,38"},
 CellID->14360],
Cell[92399, 1920, 289, 8, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,39"},
 CellID->29767],
Cell[CellGroupData[{
Cell[92713, 1932, 173, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,40"},
 CellID->15273],
Cell[92889, 1938, 7659, 130, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,40"},
 CellID->35360647]
}, Open  ]],
Cell[100563, 2071, 70, 1, 70, "ExampleText",
 CellID->25191],
Cell[100636, 2074, 332, 9, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,41"},
 CellID->9301],
Cell[100971, 2085, 287, 8, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,42"},
 CellID->378],
Cell[CellGroupData[{
Cell[101283, 2097, 173, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,43"},
 CellID->25387],
Cell[101459, 2103, 7655, 129, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,43"},
 CellID->647028045]
}, Open  ]],
Cell[109129, 2235, 168, 5, 70, "ExampleText",
 CellID->13500],
Cell[109300, 2242, 473, 14, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,44"},
 CellID->6615],
Cell[CellGroupData[{
Cell[109798, 2260, 173, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,45"},
 CellID->12709],
Cell[109974, 2266, 7700, 130, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,45"},
 CellID->393981864]
}, Open  ]],
Cell[117689, 2399, 172, 5, 70, "ExampleText",
 CellID->25061],
Cell[117864, 2406, 715, 22, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,46"},
 CellID->19952],
Cell[CellGroupData[{
Cell[118604, 2432, 173, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,47"},
 CellID->10970],
Cell[118780, 2438, 8880, 150, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,47"},
 CellID->555734367]
}, Open  ]],
Cell[127675, 2591, 274, 9, 70, "ExampleText",
 CellID->18064],
Cell[127952, 2602, 735, 22, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,48"},
 CellID->32537],
Cell[CellGroupData[{
Cell[128712, 2628, 173, 4, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,49"},
 CellID->22050],
Cell[128888, 2634, 7753, 131, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,49"},
 CellID->220942246]
}, Open  ]],
Cell[136656, 2768, 735, 22, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,50"},
 CellID->28791],
Cell[CellGroupData[{
Cell[137416, 2794, 191, 5, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,51"},
 CellID->12978],
Cell[137610, 2801, 7748, 131, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,51"},
 CellID->96248985]
}, Open  ]],
Cell[145373, 2935, 160, 5, 70, "ExampleText",
 CellID->7161],
Cell[145536, 2942, 516, 14, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,52"},
 CellID->4821],
Cell[CellGroupData[{
Cell[146077, 2960, 190, 5, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,53"},
 CellID->2718],
Cell[146270, 2967, 7741, 131, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,53"},
 CellID->689861177]
}, Open  ]],
Cell[154026, 3101, 189, 5, 70, "ExampleText",
 CellID->15183],
Cell[154218, 3108, 549, 16, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,54"},
 CellID->16933],
Cell[CellGroupData[{
Cell[154792, 3128, 190, 5, 70, "Input",
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,55"},
 CellID->8695],
Cell[154985, 3135, 7753, 131, 70, "Output",
 Evaluatable->False,
 CellTags->{"IndexedImagePanel", "Ex--21907299533234115765,55"},
 CellID->613116938]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[162799, 3273, 310, 9, 70, "SeeAlsoSection",
 CellID->2549],
Cell[163112, 3284, 460, 17, 70, "SeeAlso",
 CellID->26994]
}, Open  ]],
Cell[CellGroupData[{
Cell[163609, 3306, 314, 9, 70, "TutorialsSection",
 CellID->13004],
Cell[163926, 3317, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[164210, 3329, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

