(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34419,        798]
NotebookOptionsPosition[     29464,        647]
NotebookOutlinePosition[     32522,        732]
CellTagsIndexPosition[     32230,        722]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "List" :> 
          Documentation`HelpLookup["paclet:ref/List"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"List\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"List\"", "ObjectName",
 CellID->11597],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<List\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a list."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23192]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following properties are available:", "Notes",
 CellID->31121],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"items\", \"TI\"]\)\>\"", 
    RowBox[{"{", "}"}], Cell["the contents of the list", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"visibleRowCount\", \"TI\"]\)\>\"", "8", Cell[
    "the number of visible rows", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"selectedValues\", \"TI\"]\)\>\"", 
    RowBox[{"{", "}"}], Cell["which items are selected", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2819],

Cell["The following event is available: ", "Notes",
 CellID->8907],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"listSelection\", \"TI\"]\)\>\"", Cell[TextData[{
     "the event ",
     StyleBox[
     "triggered when there is a change in the current selection", "Text"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->29071]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->412475010],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->274646564],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->268181037],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<ScrollPane\>\"", ",", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{"\"\<viewportView\>\"", "->", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<List\>\"", ",", " ", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"\"\<visibleRowCount\>\"", "\[Rule]", "3"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"\"\<items\>\"", "\[Rule]", 
                RowBox[{"Script", "[", 
                 RowBox[{"{", 
                  RowBox[{
                  "\"\<Choice A\>\"", ",", " ", "\"\<Choice B\>\"", ",", " ", 
                   "\"\<Choice C\>\"", ",", "  ", "\"\<Choice D\>\"", ",", 
                   "  ", "\"\<Choice E\>\""}], "}"}], "]"}]}]}], 
              "\[IndentingNewLine]", "}"}]}], "]"}]}], " ", "}"}]}], "]"}], 
       " ", "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"List", "Ex--21907299533234115765,69"},
 CellLabel->"In[2]:=",
 CellID->28465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"List", "Ex--21907299533234115765,71"},
 CellLabel->"In[3]:=",
 CellID->27523],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWwl4VEW2vunOAiiMCAQQZJHVGJCEHQxbIAkkAQIJECEhARMCBJAERRBl
RmUctzcyMOPT0RE++ZxRWUQFZJEnqyhbCFsEMlk7nQ0w6e50QhL+d07VvZ3u
TodEB5z53vfu99W9detWnarzn1OnTp3qDo9fkZSwJH7Fwvnx3YJT4p9OWjg/
tVvQshQq0rspivI8pZndFM6DstpND6Xtu1DavMlJeU7cFcUdivd2KF02qWmz
F2f0nPPgnCeUh8Ur32Rus0NOftisUyt32cwt7D542kjp1a9q7n7Htvy6mYcj
hvERv0Hp9Fc3dZxEoeNZNPP7ES2Dr+CByCy0mPgj8eQ+NoNojMpsBiXgGuf4
FpDpqb4GZGplo2SZjnN6rbLMedZrIes5k6pPNCBT59hMkGIuAq5BGZoGxfcA
c1OfiwenGeC96AaaRWUSF15TipdBCSlT9LJlv4MMseJWJyS1mdokFWs/2MuV
Q8pkA7vKHs6VRd040KU0w4W0E7heZsKn3+Zg484f8Ye/Z+DlLefxwqYLePHD
dB3WfHhez29U96Utl7Dx80yUlltFO6Jj32NTOtSLhkcuGMXb/eLuie1HDfUJ
dnEi6OXviqCHaMjX1bxK7Dlehq+/L6du9n5vUlpyHl+esIj0xQkzdh434fOj
5fgxr0K02f7tpbpORzEXm5Wf1+un35qw52QV9p6pVnQ4cOaW0gr7z9D72Wrs
Pl2NLyh9Tt+3fV+F7Ses+PxYuWi3add5557vjJ+eW+l57urUIfAstr8U7Ztd
Lb19LflWR8jLlhuiCkLjauthC/adrsHBtBocSq/W4eC5GoLzm/PV2HO+BrvP
EWPE4I5T1YKxncdMotmHu9KdZdiIGspRernixcaT3omTujIP+7Im1HdGo2Ec
BzsBsu1IhQDjMHF/5HytDocvMiDh8euw70KNAOXLczXYcaYa23+4hZ0nGgfE
S+qXX4Y9ILYBeDYZGNcgeLhg2NNF2TBxd7cxuvO7CmZSj2OX6Eb86VnSNPl3
nrwlppFrtjb/ilyJT+4N8qK38fLViQp6O3axxoMZ0WH3GWZk1+lb2PV9Q/Jx
YsRJXx0Z0bmaZ3dLO13NX2cG9/xgoXonLlULSZE+HqIJyjqpJeJYWKG9JyW/
jlYn02Gd0CR3B4Z54bFjycGYNMHeuNJJZ/37+mQFvs+QqqdjfmiRYC7sudpL
HO07aXbNURcnO+r1CyzOw07ys6tTzzJ8c8aK01drcPpKjRwzjZ742X+mVoyT
kyimDPV64JQUxJav6w3beeFpxP47wtjcRdkDthbO5v1gWiXSMmtwJrMWP/xY
q2cVosY8Zrb6PFQd5+wG/I/9FxzXq3qm3XnAcU6dHr1AXkNODc5l1zJgEijq
+mK1sKzUOXXK92a8jNo63nn4onPHTem3na3fHzKqcKXgNjLyqO9/1uLMVcE0
d8+2AcfOS7POgzhAtmHfKalZ35y8YmcbMpvMcV3PaVk1yCm+LXrXOBewqyM4
kVHNZlb0zizvVa3S2cuZjj3X8+Ya67ngRo3onXk/mm7Ft2lWoaj7T1vEDCPD
gV3kjXz5nQU7jplxraBKtMvKzflFPUuTVFt7S7y1VKdPfZeuMSWX1FqIlqay
Upg5mW7AYr6JCstPsFpNqKo0o6rKiurqSh3dqkj3uePbt6ttqfGOXXun/9/x
v9axWFEa6/geOLJ1bsGQe8FVU+D8dzqyrhByVTbw3oPTBK/pV3Bq/+8y36Dv
2zDLHrY9/sYdP8q9/YcXaBy0sSf+Xtx8Eeu2XHS9r//5/N17l9humstV571d
19Q3ujzx5ueVelUxPj2c74qfnyOuu+/wNiYovuxDGZ64Yb5Nest7L+fwxe6j
lxti7pdbqc4/a9Cezp47+RzCsxGSIAXbIx1Km8PusOVqkmn9+Z5vKydF8bDf
Egqnjx1eDdl9vHk/W9PwxrApyMap6uLUkdidaVA0oZN6UGTcMfrEfhx1wHjX
sXOupt6+r1F2XIe5PBtyZTWOnD3X4+euNRIAaiyeZue52jhizXL2VI3GvDuH
C11D11RHtX7cyhW1uxg+bVq0s6nh08x/Q/jU5RbJ9TS5y+HTpoj/XnmdLmOK
jmX+TnPpbgVXXcT4M/6jfdKmgNNAoPXQxeqfF2h1Edj69QKtIrAuqstoUd3G
XA2vim0/h7L4eeRiLXMp+GPBczk/G464Zrpwy+59yNXDqZYdJZXPesufjEuK
GKxgkXRckWV3isNmuvLS7sDdPXU6nZ1txcn95OtfjMM6njs1RZz/mlvq1SBL
9eKwOnbnRPic1mHmwtmda9QQe/0Co9SlwQHWrRx2cVdFZwsZK/eJ0Wmj5OQy
5OraN2lkzWjc8Wztosw5YOwUfBV6Q8CzmtgFYO8Yf23S6O9F/NX1SvtrxF+b
fqZ9t+OvrnpuPujKrxB/ddWzl8uem+DWjrwCpfsnTj8hsKPm8BOC+pUfOkul
2TKFZpPFDTxLld0Cz8JtfBonmg+6CWl6zuq4XNHLL1yD3rz5rS03a8fvXVQC
gl5/YtT/EPfW7k/SADr2RlCc4vqiG53sRpmUQR2EX2MaU6lGeB49c+kr36ls
eg7ntLepuT5chfoPyuZ3phmaJ948tbJAGsUYkRTxqwu+j7oiy+TbGIeyUVe4
txE/0nxRhmVwjuZ6hszzk8c+rJg5YxjfkBLUGAstkUOOzGMiswoY4llUNqcU
StwNKHPL9dAnlLlDn2SmTvVJt+C2SCSqyXcaSEIt3J6q4qQQY3FVfKsROYZw
ThW/ymd0JZQnLdSDCcrMCtGjlXucWQElygwlwsxPHWfcOccjjfgJSthN+ZR1
uF2YifAKvunGrLnZ8+blyNss4mF2ufaklvo4/jGLPr6COWJ+6M1zURXdkmu8
oF9MBk+36HY7/qJj1uizR2I1Ev8q/B/lN6qaG67XijL6pjRcz0vWe9cEj3gr
AyJg8Ii1IvEvJnkuRlIzlNYgcUMZPKaUM2PMF+lCsbPUNM5yHThzi7MwN6yO
CVWqhIgfZofKvJbV6uGVUusOz+W36WMKLSP6pWjPPJKZWPC3CqRdKUPfGUfQ
cvRutB7/DR6csB9tJ+zFg+P3os2EA2gT9A0emHAQLSd8ixYTDqHZ+CPwHPst
9KO/hdvoIzSgg+g6eS/OZlxneorAT/G767QZWVY1VqbEdy24cSkNu8b3xceP
tcTWAa3xmd+D+MS/LT4Z8CC2+rfBNkrb/R7AzgEt8UX/FviqXzPs9PHEzr56
fNXHDdt7Ktj6RFcUXzgr0BfKp6EvkVc06N2dodcx7lQs9eiWRD25RgCuY8A9
4bXits6GentGXaeibrhRi76xWWgzJQudorLQ/clc9JqTg94x2ehJzx6xuehO
qQulTnMN8I41oE1MAVrNNqD5rAK4RxbAbTKNZcJ5QudroUUa6veAtg111uXT
E/vi1LA2ODWqE86O746zwb0o9cbZoJ5IC+6Bc0HdkT6hCy5O6ISL47xxaUwb
XAxohUvDm+PiYHecG+CGwz4KPiPkBe07oF5f4VVlF6reClFRUQJcdwbXWwWX
r1ZTr6Pz7JvoO/8nPJ70EwYuLsOg5DL4JZfDb0k5+i8rh8/T5ej1tAldl5nQ
cYkZbRaZ0TLRDK84E3RPkq0Jp25H7LUD917RJmhV2hlDW+FqYGdkhvXFP6c9
jqyogcieOQjZUX7InuGHnBn9kRvlg/zpvZA/tSsMYR1hCGkDQ2BL5I/yQvYw
Hc49ruDTHopGO8zEFtoRXLG40WLRNd3RmsyV1oTAxYebN3kiPz+fGudeuQpj
YSEnUviSkhK602fGHG7Jtzl1tMOn7QwTes0zw2+xGcOXmxGwwkKpAiOfsWD4
sxYMXWmB/3MV8H3Oil4rrej6rBUdU6xovbQS9yVZ4RFnhm46KWHAQY0HMq5+
94K2bV3iK/OJtsgO7YWcSD/kzR6O/NgA5M+lFDsShtjhlIaiIMYfxtm+KJzZ
C0WRXVE0tSOKJrVG4fj7kB/ggUsDddjR203Sdjbkfsdt2DeH0uOSukYZ5Xo7
12bJBbgLFy4kzkkAOoF7C1y9ehXH3nhTPEkGQiKc5ye/cyMSgo7XZAFZe7Ee
i60yOkSb0J9WuxGE2biVFnXf1Rw+ayrRc3UlHl5ZiXaplWiVXInm883wmGGE
bvT/2Omnazr3iRqdXbWzrfd8/XNMB+RE9EfenBHInzcOlkO7pHeaEEhpLAqe
CoBx3jAUxvmjaI4PiqN7iu/WrzejKKQVDGOa4/IQD3zeR+x/dAwsq/XYQgmt
7wkbtO510DLwESU6xpZ9QEKXQWKlFsjS6BlAyuH7pAUomh2Bffv2SaDpeWjj
egGuyWTidnJ91TGoHYRnIxHpEmPCkKWEBmnfxOfrkO33AmkgIduFkG1PyLZe
YhUW4L5oo1jgNGSr5CmHMx1RNulFK0JerMCEtRUY+1vScnoOXmt1oM2XC9rS
w4qS+5csMse5s4YI5A0LJmqxiIKkCTAuGAvjUyNROG8wimP7qXGHFkKpC8a3
xOWR92HnY56SpKbMjDqbDeGZCNA9VFvCoOdTv8XsPyoS+fsF6qmpqQJNRntX
aDjSvjuOy9EzkbswAlnLY3By0ZM41KMHvvrySykcd2zcsEEurzK1Zwnq2H1U
oe81z4SAVDNCCK7Jv62og36NFb1XVaIbGYCOqVZ4L7OizUIzHogpRIvxNqUm
Ou1c0RFlk39XgVDKBxPk4yg9QWkIQ29Hm68GaEeVyfCIMCh5ZEgMC0JQkDwZ
BUumaqEdY9I4GBOeIOiHKNo5IduTwjBv5Ae3QcZocl36tVD1fWyh2KPkyj2K
zx57U8LQ8xZNQG+oc9/JpDD0hw8fVhW+JY7PnoN9Pr1hnhOE0ohAGD9Oxp64
ALzT+2GB9/q3/4h9a1eKJ+POTo7AqoPwniVgj5GujX+OwCJQpr1UgekvVyCC
nuG/I32lskBKAaS3g9dUoN9qAozA6r7Cik7LreiwlBKtht5zjfhNsG0ezDLJ
UEs92nw1hbawTvVpsyjEzoGvnCmPIX/+eBQsngzjsmmUpqNgaYQE/wESRgC0
67alDIWR3VE4tROM4R2QP6kDLpM384XfbyRZngNjcup2jT57NIG0h9LthNx8
sUAiDA77KRbIqZOnkHlgPy4cOIDjU4KRNz8Ali2LUbAxHqXzhuLqMF9879cH
+0IG46fISbhy6RL+tulDsXPRsRw68nKtCsOflsLQFyyIJCHMeMWKqJetArhw
0t6QF0h7CagnVldgEC2L/Z6tQG+aEd1JEJ2XVaDzEkoEWOf4AjwYYtPeBmnz
1RTafDVAO6KEHA++ciP9YVgYCuPTkTAun4HCp6OEUAqSw2V4tyWMUb1hnNYd
BZM7oyC8M/LCOuNSUGd8PvBBKQSeDiwA3uSy0ZfTQriO3vWlwFZJlQRLYfXs
aOQMJ4c5cAhK5kxG+bsJqPrhFZRvfQb5L0TidMQTMPxtBUpXT8P7r7+GU0eP
4v0P3qcNZEwpz0UWKJObVUJo0Z2nfbEK3FCy5BFkQmausyL691bxnEbv4aS5
wc+TNV9F1px8lUHkv/imEHAkjEcIsC6LK9B1UQW6LzKh+7wCeE+0+UBEu5tL
2kIoTaDNlwvaLBKBD1950UNhXBKBwpSZKEyNJsHMpBlCQlkUTiYsWM4UWo5n
+sIwvTcMUx+BIbwLpa7IndwdlyZ2x47B3pIsWyQtEvFoGpTeWzXZkPo+dADK
kHQZvuDgCG08lGiaUnOKhGw0x+b6ivkofX0OLOtnC7mkv70EexKn47sFobDu
fRaFL03B5tdexZYtW7Bq9SoWjSYYFlF0obedUJ5IMSP61QrEvG5FzGsSvOkE
3GQGbrUFY8nsjCDQBqUQcMss6JNsQQ8CrNtCAjDJgl4Lyakn4DqG2gvFNW2+
mkKbrwZoh+epMyUvhhaJFdEoXBmDwmdjYEyJRgGZLsPiydpMyY/og/wpPWiG
dENe+CNk6Xrh4qRe2DG0oxSGFgpizFkYcqa0eoGk0cFRGpOuqbPFICSird3C
5dy7G5dfmUbe2XAhgRPJUTj2ykrsmT2aBhaCzCdHwDDYB9n//R7PFFUaRTom
JGJLLA2DiljQKgvi3rRi3luViHvDitmvWhH5khWTyaYEkz0ZS2iNWE6Ikbr3
W2xB34UW9FxgwSOJhBY9H00qx6Pz89Ep9BubNAzqIuJMm6+m0ObLBW0ZoQvN
FnlDQhAKV8ehcM08+VwxG8alkdoiwh6u/ZUb3hO5oY/Qsxeypz6KC2GPYvvw
To5SYYmwtRJTRAilWX2hRObZC0UnNmL342r/Pvh6iC9O+ffDibBhwmLxuvFG
Z28hj4yZQdj9wbsoyM7CP97ZoLfJor2TLJL+VIlFGyqR8MdKxJIGz6R1ZCpp
7yQyJ4G0vQogvNhBfZzweozw6ks49SFZ+JD2+pL2+szLR+cwe1l4uKKtbhla
umonA5F2OBf9LgnFLy9C0YsJpP2xtlOx/PhA5McEIG+W5jrdR/anD3KnkvJF
+OJ8uA+2De9cB7Km9hJkm+p7S5SHnqRlJF2izNFaRvlJo1D9qKgoFH7ykVD/
o6kpYlFgw8MLhabyHw/2ReZXu4TRUpdqdpmMAuYOdjCzhV76TiWeflfCMe/N
SswmIxT5WyvCyXIHr6zAGDIQI8hADFpixgBafvuRc+lLcPej1J/g8p1vwMNh
B2zLqQazE20V5vtdtXOAmS17yatLUfL60wy1tjcwJIUj/6lg2gCPoc3wCOTO
GGQ7w8yd1g9Z0/oTyr7YNuJhbShD0tnk+p6QKPf8WLHT5Q6f8fYXymhGOUPG
yVmfJcqaLvNO69z27bg+cwpMr8yH6blJKJnkj0vPP4drSfHYNmgYqqurUWWx
NAwy+yerPqzEms2VWE5gLFgvbUD0OmntGeggWh7HpjLQZgwjnR6UbIZ/sgwr
DFhYBl/SSTuQbbrsRNu2/XXRzgFk9mtK169C6YY1BPRyWE8dluVkyY1Lpqto
BxHaYwXaedHizygw7d+G3Cg/ZE0fgPOTbWjXA9tOpZs3Bjavk8QUYU3DPzkx
COYiucc1HzuIfN8+Is8Il9JOjUM/jLjc/7qCe9bvK/Dap1V4a1sV1n4kIWfd
fuq/rIh9XS6ykQRbBLmMoWssmESJ/fvRZFJGpDD0ZALi89AhZL8d3L73graD
SApXzMKND17Dzc1v4fqf1wqxCFPzwlMofC4WRvZ+lkXShi2CxBNKaZLYO+TH
jRY2PnvGIKSH+WDrkA5NFIn/IXl6FHyZrMwVAjOLUr4QCUd4pEg8hKXRRMCp
KCyESkkIRJ3rshgpcV+zCtoxWjpxeCPFkfC2Fe98VYX39twS0K3eVImU9yqx
5M+Vwgon/JFWRYIv/i2r8FXYZ5lG3n0YmY9AmhVDl5aj79w8tAuyBSen56ji
uMu0pWKq4iham4CfPnkHZVvfE2IpXb8aJW+koHjdErEKFNIKUEQrbtHz8dIP
WsE+0DQYFoWRWAKRQ45r+qS++HRgO1UcQ082YI7cHcShm5DGPF7hyiQRRpic
SXojGehZAJQtOnpEzAIphAZE0d5OCs++X4m3d1Rh4xdVWPf3SjxD72yck/5k
ReLbEqW55J/Esl36A+2t1lVgKinyxDVSef0Xl6PHnDwMmHMMhtJqVQr3jPbU
bOUhQbv0rWdx86O38dPHG3HjvXUoeesZFNPiUEwSKFqbKCRQuGoupVgUPkMT
JGUGbQ+m0uSYKCZGdpQ/0oJ6YHfoABiKb8mVlU0Ri+GRvSwGOyn0/FhKYewP
cAtzkALPCyXWyGObV+QJt4QSkeMDx3jaxMUW8VdOeptNals3E5ojcWMxrhlq
kUrayX5g1CtyexRCnjgH2MhIEO1RqRYdRi6n28Bks+KJAbRb7fuUGV1jbmLQ
gmykXy1H4oYiCX5zzv5soq0bIqoeCWcjcb0Rt3KukbKnknLH0Y4rSu62EkPI
zRnHNoeDN3NH6cjsjNTRQjyQhppLC0J2eF9cm9AVadMH4WZGOhJfzdKJILNe
wirx1tReJ2L/7hra0gRNv8JGPYtbMJ7zijSUE0qo5oLrOs5xcI++1CFfxE69
XA68xYmxHh5PGpD4lxIYrlerh5pe4p3Lxd6Okss6G6nOjDy5PhEiHtMkIqyY
tjqvZsFj5Kk6ZWLmfPZoJrbdJvGLIlHKDlzoaXHornLmbs8Zc6Nnvqh0Ybng
UDIrT7plascbyEeZRc+6yS19QnlEPj1HTBkdn/nz6f81d15mOSR9mX+McJ7x
4qWXbb2WyBjptHjpJu0XUEIWPF53p6GKES24rocuuaw59EvZBlFWPa/m02+6
j+NTecrNL6UO9fElQkC6mCKReOBiWuh55Hoeet3IFfFzBYnWpAxFjFxxl75C
4HmJc4fPxCGGov7FQw6VVZaB1WCkjsWwllqgX3aLzzuhpPJvd/QpLDj1XTy1
PH3hPHeayifmXO65/DYfmCp9+WtbPk7ic9UUebikNnIX9ZuLnx7w8ZSAIqFM
BPU5zil+VMBPccTPUctm8r1OsPY/aeCdu04N2swR0RxWQGY+4Jqicq79Opdn
C2PqucAs2JXDb7OaFpmHXqJb99d4S9LnLeCxt0Wir3TXw28jAmWOPooyHef0
6LFOa0Ft1fbyTl9sZYKyB/ehl715LasV2mgSuxUenDpSvVzyaKD8UwYaJqHJ
TRQxQgKTyXJ3fm+CR6XDiPV0C/gzmmP0O2jHuba2nAfniG/Kcj37JwmAcp5M
Rye4cOdu+NxbqrzfcblHqPspauhpgR8PTeiZ+LkMOZ5i7ee9lrT0tqfNyvDS
OkdYGxFrKxIhtrYcm2zLW1h3LcTDx5ZqFE6vCjRCZDmGwZGtUKNtnyTO2kRZ
icyHigkdlM8/vRFbfKOaSuRBx+h0D3UWuP0vEwD3LA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"List", "Ex--21907299533234115765,71"},
 CellLabel->"Out[3]=",
 CellID->542760036]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{"Widget", "[", 
        RowBox[{"\"\<ScrollPane\>\"", ",", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{"\"\<viewportView\>\"", "->", 
           RowBox[{"Widget", "[", 
            RowBox[{"\"\<List\>\"", ",", " ", 
             RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"\"\<visibleRowCount\>\"", "\[Rule]", "6"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"\"\<items\>\"", "\[Rule]", 
                RowBox[{"Script", "[", " ", 
                 RowBox[{"Table", "[", " ", 
                  RowBox[{
                   RowBox[{"Random", "[", "]"}], ",", " ", 
                   RowBox[{"{", "20", "}"}]}], "]"}], "]"}]}]}], 
              "\[IndentingNewLine]", "}"}]}], "]"}]}], " ", "}"}]}], "]"}], 
       " ", "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"List", "Ex--21907299533234115765,72"},
 CellLabel->"In[4]:=",
 CellID->25828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"List", "Ex--21907299533234115765,73"},
 CellLabel->"In[5]:=",
 CellID->29235],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{140, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"List", "Ex--21907299533234115765,73"},
 CellLabel->"Out[5]=",
 CellID->400352007]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5251],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["List",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/List"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1523]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5022],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"List\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 36.5234642}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"List\"Widget[\"List\"] represents a list.", 
    "synonyms" -> {}, "title" -> "List", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/List"}, "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4190, 137, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->412475010]},
 "List"->{
  Cell[4858, 163, 1267, 28, 70, "Input",
   CellTags->{"List", "Ex--21907299533234115765,69"},
   CellID->28465],
  Cell[6150, 195, 159, 4, 70, "Input",
   CellTags->{"List", "Ex--21907299533234115765,71"},
   CellID->27523],
  Cell[6312, 201, 9275, 156, 70, "Output",
   Evaluatable->False,
   CellTags->{"List", "Ex--21907299533234115765,71"},
   CellID->542760036],
  Cell[15602, 360, 1191, 27, 70, "Input",
   CellTags->{"List", "Ex--21907299533234115765,72"},
   CellID->25828],
  Cell[16818, 391, 159, 4, 70, "Input",
   CellTags->{"List", "Ex--21907299533234115765,73"},
   CellID->29235],
  Cell[16980, 397, 11001, 185, 70, "Output",
   Evaluatable->False,
   CellTags->{"List", "Ex--21907299533234115765,73"},
   CellID->400352007]},
 "Ex--21907299533234115765,69"->{
  Cell[4858, 163, 1267, 28, 70, "Input",
   CellTags->{"List", "Ex--21907299533234115765,69"},
   CellID->28465]},
 "Ex--21907299533234115765,71"->{
  Cell[6150, 195, 159, 4, 70, "Input",
   CellTags->{"List", "Ex--21907299533234115765,71"},
   CellID->27523],
  Cell[6312, 201, 9275, 156, 70, "Output",
   Evaluatable->False,
   CellTags->{"List", "Ex--21907299533234115765,71"},
   CellID->542760036]},
 "Ex--21907299533234115765,72"->{
  Cell[15602, 360, 1191, 27, 70, "Input",
   CellTags->{"List", "Ex--21907299533234115765,72"},
   CellID->25828]},
 "Ex--21907299533234115765,73"->{
  Cell[16818, 391, 159, 4, 70, "Input",
   CellTags->{"List", "Ex--21907299533234115765,73"},
   CellID->29235],
  Cell[16980, 397, 11001, 185, 70, "Output",
   Evaluatable->False,
   CellTags->{"List", "Ex--21907299533234115765,73"},
   CellID->400352007]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30451, 670},
 {"List", 30582, 674},
 {"Ex--21907299533234115765,69", 31359, 695},
 {"Ex--21907299533234115765,71", 31508, 699},
 {"Ex--21907299533234115765,72", 31798, 707},
 {"Ex--21907299533234115765,73", 31948, 711}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1231, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1854, 59, 46, 1, 70, "ObjectName",
 CellID->11597],
Cell[1903, 62, 357, 11, 70, "Usage",
 CellID->23192]
}, Open  ]],
Cell[CellGroupData[{
Cell[2297, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2775, 95, 72, 1, 70, "Notes",
 CellID->31121],
Cell[2850, 98, 746, 16, 70, "3ColumnTableMod",
 CellID->2819],
Cell[3599, 116, 66, 1, 70, "Notes",
 CellID->8907],
Cell[3668, 119, 485, 13, 70, "2ColumnTableMod",
 CellID->29071]
}, Closed]],
Cell[CellGroupData[{
Cell[4190, 137, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->412475010],
Cell[CellGroupData[{
Cell[4575, 151, 148, 5, 70, "ExampleSection",
 CellID->274646564],
Cell[4726, 158, 129, 3, 70, "Input",
 CellID->268181037],
Cell[4858, 163, 1267, 28, 70, "Input",
 CellTags->{"List", "Ex--21907299533234115765,69"},
 CellID->28465],
Cell[CellGroupData[{
Cell[6150, 195, 159, 4, 70, "Input",
 CellTags->{"List", "Ex--21907299533234115765,71"},
 CellID->27523],
Cell[6312, 201, 9275, 156, 70, "Output",
 Evaluatable->False,
 CellTags->{"List", "Ex--21907299533234115765,71"},
 CellID->542760036]
}, Open  ]],
Cell[15602, 360, 1191, 27, 70, "Input",
 CellTags->{"List", "Ex--21907299533234115765,72"},
 CellID->25828],
Cell[CellGroupData[{
Cell[16818, 391, 159, 4, 70, "Input",
 CellTags->{"List", "Ex--21907299533234115765,73"},
 CellID->29235],
Cell[16980, 397, 11001, 185, 70, "Output",
 Evaluatable->False,
 CellTags->{"List", "Ex--21907299533234115765,73"},
 CellID->400352007]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28042, 589, 310, 9, 70, "SeeAlsoSection",
 CellID->5251],
Cell[28355, 600, 445, 17, 70, "SeeAlso",
 CellID->1523]
}, Open  ]],
Cell[CellGroupData[{
Cell[28837, 622, 313, 9, 70, "TutorialsSection",
 CellID->5022],
Cell[29153, 633, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[29437, 645, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

