(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22166,        580]
NotebookOptionsPosition[     18193,        455]
NotebookOutlinePosition[     20670,        526]
CellTagsIndexPosition[     20469,        518]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "Panel" :> 
          Documentation`HelpLookup["paclet:ref/Panel"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"Panel\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"Panel\"", "ObjectName",
 CellID->23754],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<Panel\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]is an empty container widget."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<Panel\>\"", "]"}]], "InlineFormula"],
 " is an empty container widget where you place all other widgets with visual \
content. If you are interested in designing reusable complex groups of \
interacting widgets that can function together as their own compound widget \
in other user interfaces, it is recommended that you build them within a ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<Panel\>\"", "]"}]], "InlineFormula"],
 " and not ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<Frame\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/Frame"]], "InlineFormula"],
 " because using ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<Frame\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/Frame"]], "InlineFormula"],
 " forces this definition to only be deployable as its own stand-alone \
window."
}], "Notes",
 CellTags->"Panel",
 CellID->20903]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->168311035],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->655599994],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->159608859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
   RowBox[{
    StyleBox["Widget", "Program"], "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        StyleBox[
         RowBox[{
          StyleBox["Widget", "Program"], "Group"}]], "[", 
        RowBox[{
         RowBox[{"{", " ", "\[IndentingNewLine]", 
          RowBox[{
           StyleBox["Widget", "Program"], "[", 
           RowBox[{"\"\<Panel\>\"", ",", " ", 
            RowBox[{
             StyleBox[
              RowBox[{
               StyleBox["Widget", "Program"], "Layout"}]], "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<Stretching\>\"", "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"Maximize", ",", " ", "Maximize"}], "}"}]}], " ", 
              "}"}]}]}], "]"}], "\[IndentingNewLine]", " ", "}"}], ",", " ", 
         RowBox[{
          StyleBox[
           RowBox[{
            StyleBox["Widget", "Program"], "Layout"}]], "\[Rule]", 
          RowBox[{"{", " ", 
           RowBox[{"\"\<Border\>\"", "->", "\"\<Content\>\""}], " ", 
           "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          StyleBox[
           RowBox[{
            StyleBox["Widget", "Program"], "Fill"}]], "[", "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          StyleBox["Widget", "Program"], "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<OK\>\""}], "}"}]}], "]"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{
          StyleBox["Widget", "Program"], "[", 
          RowBox[{"\"\<Button\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Cancel\>\""}], "}"}]}], 
          "]"}]}], "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", 
      "}"}]}], "]"}], " ", "\[IndentingNewLine]", "]"}]}]], "Input",
 CellTags->{"Panel", "Ex--21907299533234115765,90"},
 CellLabel->"In[2]:=",
 CellID->18461],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject186319019966465, 
   JLink`Objects`JavaObject363912427995137]]], "Output",
 CellTags->{"Panel", "Ex--21907299533234115765,90"},
 CellLabel->"Out[2]=",
 CellID->132]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"Panel", "Ex--21907299533234115765,91"},
 CellLabel->"In[3]:=",
 CellID->6635],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{124, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Panel", "Ex--21907299533234115765,91"},
 CellLabel->"Out[3]=",
 CellID->28099490]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22917],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Panel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Panel"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11630]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19445],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"Panel\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 40.7576224}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> "\"Panel\"Widget[\"Panel\"] is an empty container widget.", 
    "synonyms" -> {}, "title" -> "Panel", "type" -> "Widget", "uri" -> 
    "GUIKit/widget/Panel"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Panel"->{
  Cell[2791, 95, 991, 25, 70, "Notes",
   CellTags->"Panel",
   CellID->20903],
  Cell[4509, 153, 2137, 55, 70, "Input",
   CellTags->{"Panel", "Ex--21907299533234115765,90"},
   CellID->18461],
  Cell[6649, 210, 317, 8, 70, "Output",
   CellTags->{"Panel", "Ex--21907299533234115765,90"},
   CellID->132],
  Cell[7003, 223, 159, 4, 70, "Input",
   CellTags->{"Panel", "Ex--21907299533234115765,91"},
   CellID->6635],
  Cell[7165, 229, 9540, 161, 70, "Output",
   Evaluatable->False,
   CellTags->{"Panel", "Ex--21907299533234115765,91"},
   CellID->28099490]},
 "PrimaryExamplesSection"->{
  Cell[3819, 125, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->168311035]},
 "Ex--21907299533234115765,90"->{
  Cell[4509, 153, 2137, 55, 70, "Input",
   CellTags->{"Panel", "Ex--21907299533234115765,90"},
   CellID->18461],
  Cell[6649, 210, 317, 8, 70, "Output",
   CellTags->{"Panel", "Ex--21907299533234115765,90"},
   CellID->132]},
 "Ex--21907299533234115765,91"->{
  Cell[7003, 223, 159, 4, 70, "Input",
   CellTags->{"Panel", "Ex--21907299533234115765,91"},
   CellID->6635],
  Cell[7165, 229, 9540, 161, 70, "Output",
   Evaluatable->False,
   CellTags->{"Panel", "Ex--21907299533234115765,91"},
   CellID->28099490]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Panel", 19182, 479},
 {"PrimaryExamplesSection", 19774, 496},
 {"Ex--21907299533234115765,90", 19928, 500},
 {"Ex--21907299533234115765,91", 20190, 507}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1234, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1857, 59, 47, 1, 70, "ObjectName",
 CellID->23754],
Cell[1907, 62, 369, 11, 70, "Usage",
 CellID->23535]
}, Open  ]],
Cell[CellGroupData[{
Cell[2313, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2791, 95, 991, 25, 70, "Notes",
 CellTags->"Panel",
 CellID->20903]
}, Closed]],
Cell[CellGroupData[{
Cell[3819, 125, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->168311035],
Cell[CellGroupData[{
Cell[4204, 139, 148, 5, 70, "ExampleSection",
 CellID->655599994],
Cell[4355, 146, 129, 3, 70, "Input",
 CellID->159608859],
Cell[CellGroupData[{
Cell[4509, 153, 2137, 55, 70, "Input",
 CellTags->{"Panel", "Ex--21907299533234115765,90"},
 CellID->18461],
Cell[6649, 210, 317, 8, 70, "Output",
 CellTags->{"Panel", "Ex--21907299533234115765,90"},
 CellID->132]
}, Open  ]],
Cell[CellGroupData[{
Cell[7003, 223, 159, 4, 70, "Input",
 CellTags->{"Panel", "Ex--21907299533234115765,91"},
 CellID->6635],
Cell[7165, 229, 9540, 161, 70, "Output",
 Evaluatable->False,
 CellTags->{"Panel", "Ex--21907299533234115765,91"},
 CellID->28099490]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16766, 397, 311, 9, 70, "SeeAlsoSection",
 CellID->22917],
Cell[17080, 408, 448, 17, 70, "SeeAlso",
 CellID->11630]
}, Open  ]],
Cell[CellGroupData[{
Cell[17565, 430, 314, 9, 70, "TutorialsSection",
 CellID->19445],
Cell[17882, 441, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[18166, 453, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

