(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21843,        569]
NotebookOptionsPosition[     17864,        446]
NotebookOutlinePosition[     20225,        512]
CellTagsIndexPosition[     20017,        504]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "RadioButton" :> 
          Documentation`HelpLookup["paclet:ref/RadioButton"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"RadioButton\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"RadioButton\"", "ObjectName",
 CellID->13139],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<RadioButton\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a radio button."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6767]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<RadioButton\>\"", "]"}]], "InlineFormula"],
 " expressions are always used as a group and must also be added to a ",
 Cell[BoxData["ButtonGroup"], "InlineFormula"],
 " widget, which is not a visual widget itself nor is it added to a parent or \
layout, but is responsible for ensuring that only one radio button is \
selected within its set of managed buttons."
}], "Notes",
 CellTags->"RadioButton",
 CellID->24370],

Cell["The following properties are available:", "Notes",
 CellID->6676],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", "\"\<\>\"", Cell[
    "text label", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"selected\", \"TI\"]\)\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether the radio button is selected", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->10143],

Cell["The following event is available: ", "Notes",
 CellID->30556],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"action\", \"TI\"]\)\>\"", Cell[TextData[{
     "the event ",
     StyleBox["triggered when the radio button is clicked", "Text"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->17973]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->363419201],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->323106723],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->415515655],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<Panel\>\"", ",", " ", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<RadioButton\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\"\<text\>\"", " ", "\[Rule]", " ", "\"\<Choice A\>\""}],
             ",", " ", "\[IndentingNewLine]", 
            RowBox[{"\"\<selected\>\"", " ", "\[Rule]", " ", "True"}]}], 
           "}"}], ",", " ", 
          RowBox[{"Name", "->", "\"\<buttonA\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<RadioButton\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\"\<text\>\"", " ", "\[Rule]", " ", "\"\<Choice B\>\""}],
             ",", " ", "\[IndentingNewLine]", 
            RowBox[{"\"\<selected\>\"", " ", "\[Rule]", " ", "False"}]}], 
           "}"}], ",", " ", 
          RowBox[{"Name", "->", "\"\<buttonB\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<RadioButton\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"\"\<text\>\"", " ", "\[Rule]", " ", "\"\<Choice C\>\""}],
             ",", "\[IndentingNewLine]", " ", 
            RowBox[{"\"\<selected\>\"", " ", "\[Rule]", " ", "False"}]}], 
           "}"}], ",", " ", 
          RowBox[{"Name", "->", "\"\<buttonC\>\""}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Widget", "[", 
         RowBox[{"\"\<ButtonGroup\>\"", ",", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"WidgetReference", "[", "\"\<buttonA\>\"", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"WidgetReference", "[", "\"\<buttonB\>\"", "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"WidgetReference", "[", "\"\<buttonC\>\"", "]"}]}], 
           "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}], " ", 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"RadioButton", "Ex--21907299533234115765,99"},
 CellLabel->"In[2]:=",
 CellID->8937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"RadioButton", "Ex--21907299533234115765,100"},
 CellLabel->"In[3]:=",
 CellID->11261],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"RadioButton", "Ex--21907299533234115765,100"},
 CellLabel->"Out[3]=",
 CellID->154232974]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20433],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RadioButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadioButton"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10843]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27116],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"RadioButton\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 44.0855770}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"RadioButton\"Widget[\"RadioButton\"] represents a radio button.", 
    "synonyms" -> {"radio button"}, "title" -> "RadioButton", "type" -> 
    "Widget", "uri" -> "GUIKit/widget/RadioButton"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "RadioButton"->{
  Cell[2817, 95, 477, 10, 70, "Notes",
   CellTags->"RadioButton",
   CellID->24370],
  Cell[5236, 174, 2255, 51, 70, "Input",
   CellTags->{"RadioButton", "Ex--21907299533234115765,99"},
   CellID->8937],
  Cell[7516, 229, 167, 4, 70, "Input",
   CellTags->{"RadioButton", "Ex--21907299533234115765,100"},
   CellID->11261],
  Cell[7686, 235, 8678, 146, 70, "Output",
   Evaluatable->False,
   CellTags->{"RadioButton", "Ex--21907299533234115765,100"},
   CellID->154232974]},
 "PrimaryExamplesSection"->{
  Cell[4568, 148, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->363419201]},
 "Ex--21907299533234115765,99"->{
  Cell[5236, 174, 2255, 51, 70, "Input",
   CellTags->{"RadioButton", "Ex--21907299533234115765,99"},
   CellID->8937]},
 "Ex--21907299533234115765,100"->{
  Cell[7516, 229, 167, 4, 70, "Input",
   CellTags->{"RadioButton", "Ex--21907299533234115765,100"},
   CellID->11261],
  Cell[7686, 235, 8678, 146, 70, "Output",
   Evaluatable->False,
   CellTags->{"RadioButton", "Ex--21907299533234115765,100"},
   CellID->154232974]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"RadioButton", 18905, 471},
 {"PrimaryExamplesSection", 19412, 485},
 {"Ex--21907299533234115765,99", 19566, 489},
 {"Ex--21907299533234115765,100", 19722, 493}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1252, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1875, 59, 53, 1, 70, "ObjectName",
 CellID->13139],
Cell[1931, 62, 371, 11, 70, "Usage",
 CellID->6767]
}, Open  ]],
Cell[CellGroupData[{
Cell[2339, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2817, 95, 477, 10, 70, "Notes",
 CellTags->"RadioButton",
 CellID->24370],
Cell[3297, 107, 71, 1, 70, "Notes",
 CellID->6676],
Cell[3371, 110, 630, 16, 70, "3ColumnTableMod",
 CellID->10143],
Cell[4004, 128, 67, 1, 70, "Notes",
 CellID->30556],
Cell[4074, 131, 457, 12, 70, "2ColumnTableMod",
 CellID->17973]
}, Closed]],
Cell[CellGroupData[{
Cell[4568, 148, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->363419201],
Cell[CellGroupData[{
Cell[4953, 162, 148, 5, 70, "ExampleSection",
 CellID->323106723],
Cell[5104, 169, 129, 3, 70, "Input",
 CellID->415515655],
Cell[5236, 174, 2255, 51, 70, "Input",
 CellTags->{"RadioButton", "Ex--21907299533234115765,99"},
 CellID->8937],
Cell[CellGroupData[{
Cell[7516, 229, 167, 4, 70, "Input",
 CellTags->{"RadioButton", "Ex--21907299533234115765,100"},
 CellID->11261],
Cell[7686, 235, 8678, 146, 70, "Output",
 Evaluatable->False,
 CellTags->{"RadioButton", "Ex--21907299533234115765,100"},
 CellID->154232974]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16425, 388, 311, 9, 70, "SeeAlsoSection",
 CellID->20433],
Cell[16739, 399, 460, 17, 70, "SeeAlso",
 CellID->10843]
}, Open  ]],
Cell[CellGroupData[{
Cell[17236, 421, 314, 9, 70, "TutorialsSection",
 CellID->27116],
Cell[17553, 432, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[17837, 444, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

