(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57202,       1323]
NotebookOptionsPosition[     48150,       1054]
NotebookOutlinePosition[     53756,       1207]
CellTagsIndexPosition[     53257,       1193]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE WIDGET", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GUIKit User Guide" :> 
          Documentation`HelpLookup["paclet:GUIKit/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"GUIKit User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Widget" :> 
          Documentation`HelpLookup["paclet:GUIKit/ref/Widget"], "Panel" :> 
          Documentation`HelpLookup["paclet:ref/Panel"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Widget\"\>", 
       2->"\<\"Panel\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"TextPanel\"", "ObjectName",
 CellID->14780],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Widget", "[", "\"\<TextPanel\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a text panel."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28818]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Typically used to display HTML or RTF styled content.", "Notes",
 CellTags->"TextPanel",
 CellID->29728],

Cell[TextData[{
 "There are three default text widgets provided within ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 ": ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<TextField\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/TextField"]], "InlineFormula"],
 ",",
 " ",
 Cell[BoxData[
  ButtonBox[
   RowBox[{"Widget", "[", "\"\<TextArea\>\"", "]"}],
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/widget/TextArea"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<TextPanel\>\"", "]"}]], "InlineFormula"],
 ".  ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<TextField\>\"", "]"}]], "InlineFormula"],
 " is typically used for single line input using a single font, while ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<TextArea\>\"", "]"}]], "InlineFormula"],
 " would typically be used to display or take multiple line input also in a \
single font style. ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<TextPanel\>\"", "]"}]], "InlineFormula"],
 " is used less often, but has the benefit of displaying stylized text either \
as plain text, HTML 3.2 compliant text, or RTF styled text. "
}], "Notes",
 CellTags->"TextPanel",
 CellID->23289],

Cell[TextData[{
 "In its most basic form, ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<TextPanel\>\"", "]"}]], "InlineFormula"],
 " can display plain text just as ",
 Cell[BoxData[
  RowBox[{"Widget", "[", "\"\<TextArea\>\"", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"TextPanel",
 CellID->21713],

Cell[TextData[{
 "This widget would typically be useful to simplify laying out slightly more \
complicated text blocks using a single text string but including style \
information. You can also take advantage of the ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"path\", \"TI\"]\)\>\""], "InlineFormula"],
 " property by specifying an external source for the text content, either as \
a relative local file or even URL-based paths. You can also support eventing \
off hyperlinks in any HTML you provide in the text, allowing for custom \
hyperlink actions or forwarding standard web URLs to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end to open in the user\[CloseCurlyQuote]s chosen web browser."
}], "Notes",
 CellTags->"TextPanel",
 CellID->4941],

Cell["The following properties are available:", "Notes",
 CellID->28223],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"text\", \"TI\"]\)\>\"", 
    RowBox[{"\"\<\>", "\"\<\>"}], Cell["the text content", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"path\", \"TI\"]\)\>\"", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"], Cell[
    "path or URL of the text content", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"contentType\", \"TI\"]\)\>\"", 
    RowBox[{"\"\<text/plain\>\"", " "}], Cell["content type", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"editable\", \"TI\"]\)\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the text panel can be edited", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->2796],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<contentType\>\""], "InlineFormula"],
 " property can take the values ",
 Cell[BoxData["\"\<text/plain\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<text/html\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<text/rtf\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<text/html;charEncoding\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->6731],

Cell["The following event is available: ", "Notes",
 CellID->12840],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"hyperlinkUpdate\", \"TI\"]\)\>\"", Cell[TextData[StyleBox[
    "the event triggered whenever a hyperlink in the text is activated", 
     "Text"]], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30231],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"hyperlinkUpdate\", \"TI\"]\)\>\""], "InlineFormula"],
 " event is only fired when the panel is not editable."
}], "Notes",
 CellID->12135]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->96184628],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->714412210],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->623802556],

Cell["Display a text panel with content:", "ExampleText",
 CellID->773],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<TextPanel\>\"", ",", " ", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Dimension\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\"\<width\>\"", "\[Rule]", "50"}], ",", 
             RowBox[{"\"\<height\>\"", "\[Rule]", "80"}]}], "}"}]}], "]"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
        "\"\<text\>\"", "->", "\"\<Multiple lines of running text\>\""}]}], 
       "}"}]}], "]"}], " ", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,176"},
 CellLabel->"In[2]:=",
 CellID->21894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,177"},
 CellLabel->"In[3]:=",
 CellID->10419],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"TextPanel", "Ex--21907299533234115765,177"},
 CellLabel->"Out[3]=",
 CellID->352150207]
}, Open  ]],

Cell[TextData[{
 "Display stylized text using HTML and set the ",
 StyleBox["\"contentType\"", "Program"],
 " property:"
}], "ExampleText",
 CellTags->"TextPanel",
 CellID->10883],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<TextPanel\>\"", ",", " ", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Dimension\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\"\<width\>\"", "\[Rule]", "50"}], ",", 
             RowBox[{"\"\<height\>\"", "\[Rule]", "80"}]}], "}"}]}], "]"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
        "\"\<contentType\>\"", " ", "\[Rule]", " ", "\"\<text/html\>\""}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
        "\"\<text\>\"", "->", 
         "\"\<<html><body>Multiple <b>lines</b> of <i>running \
text</i></body></html>\>\""}]}], "}"}]}], "]"}], " ", "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,178"},
 CellLabel->"In[4]:=",
 CellID->6533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,179"},
 CellLabel->"In[5]:=",
 CellID->16782],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"TextPanel", "Ex--21907299533234115765,179"},
 CellLabel->"Out[5]=",
 CellID->576821441]
}, Open  ]],

Cell["Use RTF instead of HTML:", "ExampleText",
 CellTags->"TextPanel",
 CellID->17436],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<TextPanel\>\"", ",", " ", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Dimension\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\"\<width\>\"", "\[Rule]", "50"}], ",", 
             RowBox[{"\"\<height\>\"", "\[Rule]", "80"}]}], "}"}]}], "]"}]}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{
        "\"\<contentType\>\"", " ", "\[Rule]", " ", "\"\<text/rtf\>\""}], ",",
         "\[IndentingNewLine]", 
        RowBox[{
        "\"\<text\>\"", "->", 
         "\"\<{\\\\rtf1 Multiple \\\\b lines\\\\b0  of \\\\i running \
text}\>\""}]}], "}"}]}], "]"}], " ", "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,180"},
 CellLabel->"In[6]:=",
 CellID->16825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,181"},
 CellLabel->"In[7]:=",
 CellID->21052],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"TextPanel", "Ex--21907299533234115765,181"},
 CellLabel->"Out[7]=",
 CellID->6942036]
}, Open  ]],

Cell["Use an external text source:", "ExampleText",
 CellID->24],

Cell[BoxData[
 RowBox[{
  RowBox[{"ref", " ", "=", " ", 
   RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
    RowBox[{"Widget", "[", 
     RowBox[{"\"\<TextPanel\>\"", ",", " ", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
         RowBox[{"Widget", "[", 
          RowBox[{"\"\<Dimension\>\"", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\"\<width\>\"", "\[Rule]", "130"}], ",", 
             RowBox[{"\"\<height\>\"", "\[Rule]", "210"}]}], "}"}]}], "]"}]}],
         ",", "\[IndentingNewLine]", 
        RowBox[{
        "\"\<contentType\>\"", " ", "\[Rule]", " ", "\"\<text/html\>\""}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"\"\<editable\>\"", "\[Rule]", "False"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
        "\"\<path\>\"", "->", "\"\<Wolfram/Example/sampleText.html\>\""}]}], 
       "}"}]}], "]"}], " ", "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,182"},
 CellLabel->"In[8]:=",
 CellID->5845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", "ref", "]"}]], "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,183"},
 CellLabel->"In[9]:=",
 CellID->13296],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{138, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"TextPanel", "Ex--21907299533234115765,183"},
 CellLabel->"Out[9]=",
 CellID->217849178]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12644],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Widget",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/Widget"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Panel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Panel"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8852]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15632],

Cell[TextData[{
 StyleBox[ButtonBox["GUIKit",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:GUIKit/tutorial/Overview"]
}], "Tutorials",
 CellID->31238]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"TextPanel\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 23, 52.4757724}", "context" -> "GUIKit`", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Widget", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "\"TextPanel\"Widget[\"TextPanel\"] represents a text panel.", 
    "synonyms" -> {"text panel"}, "title" -> "TextPanel", "type" -> "Widget", 
    "uri" -> "GUIKit/widget/TextPanel"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "TextPanel"->{
  Cell[2794, 95, 110, 2, 70, "Notes",
   CellTags->"TextPanel",
   CellID->29728],
  Cell[2907, 99, 1222, 34, 70, "Notes",
   CellTags->"TextPanel",
   CellID->23289],
  Cell[4132, 135, 312, 10, 70, "Notes",
   CellTags->"TextPanel",
   CellID->21713],
  Cell[4447, 147, 762, 15, 70, "Notes",
   CellTags->"TextPanel",
   CellID->4941],
  Cell[8284, 265, 862, 21, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,176"},
   CellID->21894],
  Cell[9171, 290, 165, 4, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,177"},
   CellID->10419],
  Cell[9339, 296, 8018, 136, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextPanel", "Ex--21907299533234115765,177"},
   CellID->352150207],
  Cell[17372, 435, 179, 6, 70, "ExampleText",
   CellTags->"TextPanel",
   CellID->10883],
  Cell[17554, 443, 1040, 26, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,178"},
   CellID->6533],
  Cell[18619, 473, 165, 4, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,179"},
   CellID->16782],
  Cell[18787, 479, 8237, 139, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextPanel", "Ex--21907299533234115765,179"},
   CellID->576821441],
  Cell[27039, 621, 87, 2, 70, "ExampleText",
   CellTags->"TextPanel",
   CellID->17436],
  Cell[27129, 625, 1028, 26, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,180"},
   CellID->16825],
  Cell[28182, 655, 165, 4, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,181"},
   CellID->21052],
  Cell[28350, 661, 8056, 136, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextPanel", "Ex--21907299533234115765,181"},
   CellID->6942036],
  Cell[36488, 803, 1090, 26, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,182"},
   CellID->5845],
  Cell[37603, 833, 165, 4, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,183"},
   CellID->13296],
  Cell[37771, 839, 8892, 150, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextPanel", "Ex--21907299533234115765,183"},
   CellID->217849178]},
 "PrimaryExamplesSection"->{
  Cell[7543, 236, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->96184628]},
 "Ex--21907299533234115765,176"->{
  Cell[8284, 265, 862, 21, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,176"},
   CellID->21894]},
 "Ex--21907299533234115765,177"->{
  Cell[9171, 290, 165, 4, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,177"},
   CellID->10419],
  Cell[9339, 296, 8018, 136, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextPanel", "Ex--21907299533234115765,177"},
   CellID->352150207]},
 "Ex--21907299533234115765,178"->{
  Cell[17554, 443, 1040, 26, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,178"},
   CellID->6533]},
 "Ex--21907299533234115765,179"->{
  Cell[18619, 473, 165, 4, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,179"},
   CellID->16782],
  Cell[18787, 479, 8237, 139, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextPanel", "Ex--21907299533234115765,179"},
   CellID->576821441]},
 "Ex--21907299533234115765,180"->{
  Cell[27129, 625, 1028, 26, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,180"},
   CellID->16825]},
 "Ex--21907299533234115765,181"->{
  Cell[28182, 655, 165, 4, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,181"},
   CellID->21052],
  Cell[28350, 661, 8056, 136, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextPanel", "Ex--21907299533234115765,181"},
   CellID->6942036]},
 "Ex--21907299533234115765,182"->{
  Cell[36488, 803, 1090, 26, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,182"},
   CellID->5845]},
 "Ex--21907299533234115765,183"->{
  Cell[37603, 833, 165, 4, 70, "Input",
   CellTags->{"TextPanel", "Ex--21907299533234115765,183"},
   CellID->13296],
  Cell[37771, 839, 8892, 150, 70, "Output",
   Evaluatable->False,
   CellTags->{"TextPanel", "Ex--21907299533234115765,183"},
   CellID->217849178]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"TextPanel", 49175, 1079},
 {"PrimaryExamplesSection", 51275, 1138},
 {"Ex--21907299533234115765,176", 51429, 1142},
 {"Ex--21907299533234115765,177", 51584, 1146},
 {"Ex--21907299533234115765,178", 51887, 1154},
 {"Ex--21907299533234115765,179", 52043, 1158},
 {"Ex--21907299533234115765,180", 52348, 1166},
 {"Ex--21907299533234115765,181", 52505, 1170},
 {"Ex--21907299533234115765,182", 52808, 1178},
 {"Ex--21907299533234115765,183", 52964, 1182}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1234, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1857, 59, 51, 1, 70, "ObjectName",
 CellID->14780],
Cell[1911, 62, 368, 11, 70, "Usage",
 CellID->28818]
}, Open  ]],
Cell[CellGroupData[{
Cell[2316, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2794, 95, 110, 2, 70, "Notes",
 CellTags->"TextPanel",
 CellID->29728],
Cell[2907, 99, 1222, 34, 70, "Notes",
 CellTags->"TextPanel",
 CellID->23289],
Cell[4132, 135, 312, 10, 70, "Notes",
 CellTags->"TextPanel",
 CellID->21713],
Cell[4447, 147, 762, 15, 70, "Notes",
 CellTags->"TextPanel",
 CellID->4941],
Cell[5212, 164, 72, 1, 70, "Notes",
 CellID->28223],
Cell[5287, 167, 1070, 25, 70, "3ColumnTableMod",
 CellID->2796],
Cell[6360, 194, 402, 13, 70, "Notes",
 CellID->6731],
Cell[6765, 209, 67, 1, 70, "Notes",
 CellID->12840],
Cell[6835, 212, 468, 11, 70, "2ColumnTableMod",
 CellID->30231],
Cell[7306, 225, 200, 6, 70, "Notes",
 CellID->12135]
}, Closed]],
Cell[CellGroupData[{
Cell[7543, 236, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->96184628],
Cell[CellGroupData[{
Cell[7927, 250, 148, 5, 70, "ExampleSection",
 CellID->714412210],
Cell[8078, 257, 129, 3, 70, "Input",
 CellID->623802556],
Cell[8210, 262, 71, 1, 70, "ExampleText",
 CellID->773],
Cell[8284, 265, 862, 21, 70, "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,176"},
 CellID->21894],
Cell[CellGroupData[{
Cell[9171, 290, 165, 4, 70, "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,177"},
 CellID->10419],
Cell[9339, 296, 8018, 136, 70, "Output",
 Evaluatable->False,
 CellTags->{"TextPanel", "Ex--21907299533234115765,177"},
 CellID->352150207]
}, Open  ]],
Cell[17372, 435, 179, 6, 70, "ExampleText",
 CellTags->"TextPanel",
 CellID->10883],
Cell[17554, 443, 1040, 26, 70, "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,178"},
 CellID->6533],
Cell[CellGroupData[{
Cell[18619, 473, 165, 4, 70, "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,179"},
 CellID->16782],
Cell[18787, 479, 8237, 139, 70, "Output",
 Evaluatable->False,
 CellTags->{"TextPanel", "Ex--21907299533234115765,179"},
 CellID->576821441]
}, Open  ]],
Cell[27039, 621, 87, 2, 70, "ExampleText",
 CellTags->"TextPanel",
 CellID->17436],
Cell[27129, 625, 1028, 26, 70, "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,180"},
 CellID->16825],
Cell[CellGroupData[{
Cell[28182, 655, 165, 4, 70, "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,181"},
 CellID->21052],
Cell[28350, 661, 8056, 136, 70, "Output",
 Evaluatable->False,
 CellTags->{"TextPanel", "Ex--21907299533234115765,181"},
 CellID->6942036]
}, Open  ]],
Cell[36421, 800, 64, 1, 70, "ExampleText",
 CellID->24],
Cell[36488, 803, 1090, 26, 70, "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,182"},
 CellID->5845],
Cell[CellGroupData[{
Cell[37603, 833, 165, 4, 70, "Input",
 CellTags->{"TextPanel", "Ex--21907299533234115765,183"},
 CellID->13296],
Cell[37771, 839, 8892, 150, 70, "Output",
 Evaluatable->False,
 CellTags->{"TextPanel", "Ex--21907299533234115765,183"},
 CellID->217849178]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46724, 996, 311, 9, 70, "SeeAlsoSection",
 CellID->12644],
Cell[47038, 1007, 447, 17, 70, "SeeAlso",
 CellID->8852]
}, Open  ]],
Cell[CellGroupData[{
Cell[47522, 1029, 314, 9, 70, "TutorialsSection",
 CellID->15632],
Cell[47839, 1040, 269, 9, 70, "Tutorials",
 CellID->31238]
}, Open  ]],
Cell[48123, 1052, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

