(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36561,        865]
NotebookOptionsPosition[     30343,        662]
NotebookOutlinePosition[     34429,        782]
CellTagsIndexPosition[     34356,        777]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GUIKIT PACKAGE TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Access to the Java Object Layer", "Title",
 CellTags->"JavaAccess",
 CellID->398992916],

Cell[TextData[{
 "The ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " framework provides ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions, such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PropertyValue",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/PropertyValue"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"widgetName\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"propertyName\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
 " for accessing state, or calling methods on ",
 Cell[BoxData["JavaObject"], "InlineFormula"],
 " instances using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InvokeMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/InvokeMethod"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"widgetName\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"methodName\", \"TI\"]\)\>\""}], "}"}], ",", 
    StyleBox["arguments", "TI"]}], "]"}]], "InlineFormula"],
 ".",
 " ",
 "However, this does not prevent you from using the standard ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " techniques for manipulating any underlying ",
 Cell[BoxData["JavaObject"], "InlineFormula"],
 " that make up the runtime interface."
}], "Text",
 CellTags->"JavaAccess",
 CellID->392847125],

Cell[BoxData[
 RowBox[{
  RowBox[{"Needs", "[", "\"\<GUIKit`\>\"", "]"}], ";"}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[55]:=",
 CellID->2501759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ref", " ", "=", " ", 
  RowBox[{"GUIRun", "[", " ", "\[IndentingNewLine]", 
   RowBox[{"Widget", "[", 
    RowBox[{"\"\<Panel\>\"", ",", 
     RowBox[{"{", " ", "\[IndentingNewLine]", " ", 
      RowBox[{"Widget", "[", 
       RowBox[{"\"\<Label\>\"", ",", " ", 
        RowBox[{"{", 
         RowBox[{"\"\<text\>\"", "\[Rule]", "\"\<Hello World!\>\""}], "}"}], 
        ",", " ", 
        RowBox[{"Name", "->", "\"\<myLabel\>\""}]}], "]"}], 
      "\[IndentingNewLine]", " ", "}"}]}], " ", "]"}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[56]:=",
 CellID->43458234],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[SkeletonIndicator]", "GUIObject", "\[SkeletonIndicator]"}],
  GUIKit`GUIObject[
  JLink`Objects`JavaObject214327810326529, 
   JLink`Objects`JavaObject308763202420737]]], "Output",
 CellTags->"JavaAccess",
 CellLabel->"Out[56]=",
 CellID->245293703]
}, Open  ]],

Cell["\<\
Here is what this interface will display as on a typical platform.\
\>", "Text",
 CellTags->"JavaAccess",
 CellID->926479789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", " ", "ref", "]"}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[57]:=",
 CellID->319495052],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"JavaAccess",
 CellLabel->"Out[57]=",
 CellID->36078961]
}, Open  ]],

Cell[TextData[{
 "The first argument of a ",
 Cell[BoxData[
  ButtonBox["GUIObject",
   BaseStyle->"Link",
   ButtonData->"paclet:GUIKit/ref/GUIObject"]], "InlineFormula"],
 " is the root window Java class, in this case a ",
 Cell[BoxData[
  RowBox[{"javax", ".", "swing", ".", "JFrame"}]], "InlineFormula"],
 " instance, and we can make method calls on this component while the \
interface is running."
}], "Text",
 CellTags->"JavaAccess",
 CellID->215223449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"First", "[", "ref", "]"}], " ", "@", " ", 
  RowBox[{"isVisible", "[", "]"}]}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[4]:=",
 CellID->47906501],

Cell[BoxData["True"], "Output",
 CellTags->"JavaAccess",
 CellLabel->"Out[4]=",
 CellID->415500953]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"First", "[", "ref", "]"}], " ", "@", " ", 
  RowBox[{"setTitle", "[", "\"\<Test\>\"", "]"}]}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[58]:=",
 CellID->47755146],

Cell["\<\
Here is an update to what the user interface will look like now. (The \
interface has been resized to display the entire title.)\
\>", "Text",
 CellTags->"JavaAccess",
 CellID->616604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", " ", "ref", "]"}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[59]:=",
 CellID->43028925],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{130, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"JavaAccess",
 CellLabel->"Out[59]=",
 CellID->824203561]
}, Open  ]],

Cell[TextData[{
 "Utility ",
 StyleBox["GUIKit",
  FontSlant->"Italic"],
 " functions, such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WidgetReference",
    BaseStyle->"Link",
    ButtonData->"paclet:GUIKit/ref/WidgetReference"], "[", "]"}]], 
  "InlineFormula"],
 ", which looks up specially registered instances, also returns ",
 Cell[BoxData["JavaObject"], "InlineFormula"],
 " instances, and so any object in the interface can be accessed directly \
with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " method calls."
}], "Text",
 CellTags->"JavaAccess",
 CellID->549907900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", " ", "=", " ", 
  RowBox[{"ref", " ", "@", " ", 
   RowBox[{"WidgetReference", "[", "\"\<myLabel\>\"", "]"}]}]}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[60]:=",
 CellID->21216515],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[LeftGuillemet]", 
   RowBox[{"JavaObject", "[", 
    RowBox[{"javax", ".", "swing", ".", "JLabel"}], "]"}], 
   "\[RightGuillemet]"}],
  JLink`Objects`JavaObject323052105629697]], "Output",
 CellTags->"JavaAccess",
 CellLabel->"Out[60]=",
 CellID->208687197]
}, Open  ]],

Cell[BoxData[
 RowBox[{"l", " ", "@", " ", 
  RowBox[{"setText", "[", "\"\<new label\>\"", "]"}]}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[61]:=",
 CellID->299233437],

Cell["\<\
Here is an update to what the user interface will look like now.\
\>", "Text",
 CellTags->"JavaAccess",
 CellID->286782685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GUIScreenShot", "[", " ", "ref", "]"}]], "Input",
 CellTags->"JavaAccess",
 CellLabel->"In[62]:=",
 CellID->208104505],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{130, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"JavaAccess",
 CellLabel->"Out[62]=",
 CellID->57705414]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Access to the Java Object Layer - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 24, 2.5221330}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "GUIKit Package Tutorial", 
    "language" -> "en", "paclet" -> "GUIKit Package", "status" -> "None", 
    "summary" -> 
    "The GUIKit framework provides Mathematica functions, such as \
PropertyValue[{\"widgetName\",\"propertyName\"}] for accessing state, or \
calling methods on JavaObject instances using \
InvokeMethod[{\"widgetName\",\"methodName\"},arguments]. However, this does \
not prevent you from using the standard J/Link techniques for manipulating \
any underlying JavaObject that make up the runtime interface. Here is what \
this interface will display as on a typical platform. The first argument of a \
GUIObject is the root window Java class, in this case a javax.swing.JFrame \
instance, and we can make method calls on this component while the interface \
is running.", "synonyms" -> {}, "title" -> "Access to the Java Object Layer", 
    "type" -> "Tutorial", "uri" -> 
    "GUIKit/tutorial/AccessToTheJavaObjectLayer"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "JavaAccess"->{
  Cell[731, 29, 93, 2, 70, "Title",
   CellTags->"JavaAccess",
   CellID->398992916],
  Cell[827, 33, 1277, 41, 70, "Text",
   CellTags->"JavaAccess",
   CellID->392847125],
  Cell[2107, 76, 157, 5, 70, "Input",
   CellTags->"JavaAccess",
   CellID->2501759],
  Cell[2289, 85, 635, 16, 70, "Input",
   CellTags->"JavaAccess",
   CellID->43458234],
  Cell[2927, 103, 296, 8, 70, "Output",
   CellTags->"JavaAccess",
   CellID->245293703],
  Cell[3238, 114, 135, 4, 70, "Text",
   CellTags->"JavaAccess",
   CellID->926479789],
  Cell[3398, 122, 142, 4, 70, "Input",
   CellTags->"JavaAccess",
   CellID->319495052],
  Cell[3543, 128, 7557, 129, 70, "Output",
   Evaluatable->False,
   CellTags->"JavaAccess",
   CellID->36078961],
  Cell[11115, 260, 460, 13, 70, "Text",
   CellTags->"JavaAccess",
   CellID->215223449],
  Cell[11600, 277, 191, 6, 70, "Input",
   CellTags->"JavaAccess",
   CellID->47906501],
  Cell[11794, 285, 99, 3, 70, "Output",
   CellTags->"JavaAccess",
   CellID->415500953],
  Cell[11908, 291, 207, 6, 70, "Input",
   CellTags->"JavaAccess",
   CellID->47755146],
  Cell[12118, 299, 194, 5, 70, "Text",
   CellTags->"JavaAccess",
   CellID->616604],
  Cell[12337, 308, 141, 4, 70, "Input",
   CellTags->"JavaAccess",
   CellID->43028925],
  Cell[12481, 314, 8094, 137, 70, "Output",
   Evaluatable->False,
   CellTags->"JavaAccess",
   CellID->824203561],
  Cell[20590, 454, 583, 20, 70, "Text",
   CellTags->"JavaAccess",
   CellID->549907900],
  Cell[21198, 478, 219, 6, 70, "Input",
   CellTags->"JavaAccess",
   CellID->21216515],
  Cell[21420, 486, 305, 9, 70, "Output",
   CellTags->"JavaAccess",
   CellID->208687197],
  Cell[21740, 498, 178, 5, 70, "Input",
   CellTags->"JavaAccess",
   CellID->299233437],
  Cell[21921, 505, 133, 4, 70, "Text",
   CellTags->"JavaAccess",
   CellID->286782685],
  Cell[22079, 513, 142, 4, 70, "Input",
   CellTags->"JavaAccess",
   CellID->208104505],
  Cell[22224, 519, 8065, 137, 70, "Output",
   Evaluatable->False,
   CellTags->"JavaAccess",
   CellID->57705414]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"JavaAccess", 32297, 704}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 106, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[731, 29, 93, 2, 70, "Title",
 CellTags->"JavaAccess",
 CellID->398992916],
Cell[827, 33, 1277, 41, 70, "Text",
 CellTags->"JavaAccess",
 CellID->392847125],
Cell[2107, 76, 157, 5, 70, "Input",
 CellTags->"JavaAccess",
 CellID->2501759],
Cell[CellGroupData[{
Cell[2289, 85, 635, 16, 70, "Input",
 CellTags->"JavaAccess",
 CellID->43458234],
Cell[2927, 103, 296, 8, 70, "Output",
 CellTags->"JavaAccess",
 CellID->245293703]
}, Open  ]],
Cell[3238, 114, 135, 4, 70, "Text",
 CellTags->"JavaAccess",
 CellID->926479789],
Cell[CellGroupData[{
Cell[3398, 122, 142, 4, 70, "Input",
 CellTags->"JavaAccess",
 CellID->319495052],
Cell[3543, 128, 7557, 129, 70, "Output",
 Evaluatable->False,
 CellTags->"JavaAccess",
 CellID->36078961]
}, Open  ]],
Cell[11115, 260, 460, 13, 70, "Text",
 CellTags->"JavaAccess",
 CellID->215223449],
Cell[CellGroupData[{
Cell[11600, 277, 191, 6, 70, "Input",
 CellTags->"JavaAccess",
 CellID->47906501],
Cell[11794, 285, 99, 3, 70, "Output",
 CellTags->"JavaAccess",
 CellID->415500953]
}, Open  ]],
Cell[11908, 291, 207, 6, 70, "Input",
 CellTags->"JavaAccess",
 CellID->47755146],
Cell[12118, 299, 194, 5, 70, "Text",
 CellTags->"JavaAccess",
 CellID->616604],
Cell[CellGroupData[{
Cell[12337, 308, 141, 4, 70, "Input",
 CellTags->"JavaAccess",
 CellID->43028925],
Cell[12481, 314, 8094, 137, 70, "Output",
 Evaluatable->False,
 CellTags->"JavaAccess",
 CellID->824203561]
}, Open  ]],
Cell[20590, 454, 583, 20, 70, "Text",
 CellTags->"JavaAccess",
 CellID->549907900],
Cell[CellGroupData[{
Cell[21198, 478, 219, 6, 70, "Input",
 CellTags->"JavaAccess",
 CellID->21216515],
Cell[21420, 486, 305, 9, 70, "Output",
 CellTags->"JavaAccess",
 CellID->208687197]
}, Open  ]],
Cell[21740, 498, 178, 5, 70, "Input",
 CellTags->"JavaAccess",
 CellID->299233437],
Cell[21921, 505, 133, 4, 70, "Text",
 CellTags->"JavaAccess",
 CellID->286782685],
Cell[CellGroupData[{
Cell[22079, 513, 142, 4, 70, "Input",
 CellTags->"JavaAccess",
 CellID->208104505],
Cell[22224, 519, 8065, 137, 70, "Output",
 Evaluatable->False,
 CellTags->"JavaAccess",
 CellID->57705414]
}, Open  ]]
}, Open  ]],
Cell[30316, 660, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

